asm {
USE32
//************************************
//  ASM Global vars not required for 16-bit start-up
	ALIGN	8,OC_NOP
MEM_HEAP_BASE::		DU64	0;
MEM_HEAP_LIMIT::	DU64	0;
MEM_PAGE_SIZE::		DU64	0;
MEM_MAPPED_SPACE::	DU64	0;
MEM_2MEG_NUM::		DU64	0;
MEM_1GIG_NUM::		DU64	0;
MEM_512GIG_NUM::	DU64	0;
MEM_PML2::		DU64	0;
MEM_PML3::		DU64	0;
MEM_PML4::		DU64	0;

#exe {
  StreamPrint(
"SYS_MEM_INIT_FLAG::	DU8	%d;"
"SYS_MEM_INIT_VAL::	DU8	%d;"
"SYS_HEAP_INIT_FLAG::	DU8	%d;"
"SYS_HEAP_INIT_VAL::	DU8	%d;"
"SYS_VAR_INIT_FLAG::	DU8	%d;"
"SYS_VAR_INIT_VAL::	DU8	%d;"
"SYS_STAFF_MODE_FLAG::	DU8	%d;",
kernel_cfg->opts[CFG_MEM_INIT], kernel_cfg->mem_init_val,
kernel_cfg->opts[CFG_HEAP_INIT],kernel_cfg->heap_init_val,
kernel_cfg->opts[CFG_VAR_INIT], kernel_cfg->var_init_val,
kernel_cfg->opts[CFG_STAFF_MODE]);
};
SYS_HEAP_DBG_FLAG::	DU8	_CFG_HEAP_DBG;

	ALIGN	8,0
SYS_CTRL_ALT_FLAGS::	DU64	0;
SYS_EXTERN_TABLE::	DU64	0;

SYS_CODE_BP::		DU64	0;
SYS_DATA_BP::		DU64	0;

SYS_PROGRESSES::
SYS_PROGRESS1::		DU64	0;
SYS_PROGRESS1_MAX::	DU64	0;
SYS_PROGRESS1_T0::	DU64	0;
SYS_PROGRESS1_TF::	DU64	0;
SYS_PROGRESS1_DESC::	DU8	PROGRESS_DESC_LEN DUP(0);
SYS_PROGRESS2::		DU64	0;
SYS_PROGRESS2_MAX::	DU64	0;
SYS_PROGRESS2_T0::	DU64	0;
SYS_PROGRESS2_TF::	DU64	0;
SYS_PROGRESS2_DESC::	DU8	PROGRESS_DESC_LEN DUP(0);
SYS_PROGRESS3::		DU64	0;
SYS_PROGRESS3_MAX::	DU64	0;
SYS_PROGRESS3_T0::	DU64	0;
SYS_PROGRESS3_TF::	DU64	0;
SYS_PROGRESS3_DESC::	DU8	PROGRESS_DESC_LEN DUP(0);
SYS_PROGRESS4::		DU64	0;
SYS_PROGRESS4_MAX::	DU64	0;
SYS_PROGRESS4_T0::	DU64	0;
SYS_PROGRESS4_TF::	DU64	0;
SYS_PROGRESS4_DESC::	DU8	PROGRESS_DESC_LEN DUP(0);
#assert $$-SYS_PROGRESSES==sizeof(CProgress)*4

SYS_FOCUS_TASK::	DU64	0;
SYS_CPU_STRUCTS::	DU64	0;
SYS_MP_CNT::		DU64	1;
SYS_MP_CNT_INITIAL::	DU64	1;
SYS_MP_CNT_LOCK::	DU64	1;

	ALIGN	DFT_CACHE_LINE_WIDTH,OC_NOP
SYS_CACHE_LINE_WIDTH::	DU64	DFT_CACHE_LINE_WIDTH;
	DU8	DFT_CACHE_LINE_WIDTH-sizeof(CBinFile)-8 DUP(0);
SYS_SEMAS::		DU8	SEMA_SEMAS_NUM*DFT_CACHE_LINE_WIDTH DUP(0);
//************************************
	ALIGN	16,OC_NOP
CORE0_32BIT_INIT:: //Entry point for $LK,"BootRAM",A="MN:BootRAM"$.
	PUSH	U32 RFLAGG_START
	POPFD
	MOV	EAX,SYS_START_CR0
	MOV_CR0_EAX

	MOV	AX,CGDT.boot_ds	//LOAD DS SELECTOR
	MOV	DS,AX
	BTS	U32 [SYS_RUN_LEVEL],RLf_32BIT
	MOV	ESI,U32 [SYS_BOOT_PATCH_TABLE_BASE]
	MOV	EDI,U32 [MEM_BOOT_BASE]

	MOV	AX,CGDT.ds
	MOV	DS,AX
	MOV	ES,AX
	MOV	FS,AX
	MOV	GS,AX
	MOV	SS,AX
	MOV	ESP,BOOT_RAM_LIMIT //Tmp Stk

//Patch abs addresses
	MOV	ECX,U32 CPatchTableAbsAddr.abs_addres_cnt[ESI]
	LEA	ESI,U32 CPatchTableAbsAddr.abs_addres[ESI]
@@05:	LODSD
	ADD	EAX,EDI
	ADD	U32 [EAX],EDI
	LOOP	@@05

	DU8	0xEA; //JMP CGDT.cs32:@@10
	DU32	@@10;
	DU16	CGDT.cs32;

@@10:	BTS	U32 [SYS_RUN_LEVEL],RLf_PATCHED

	CALL	SYS_FIND_PCIBIOS_SERVICE_DIR
	CALL	SYS_FIND_PCI_SERVICES
	CALL	SYS_INIT_PAGE_TABLES
	CALL	SYS_INIT_16MEG_SYS_CODE_BP
	PUSH	U32 0	//Return from next call will be 64-bit
	CALL	SYS_ENTER_LONG_MODE

	//We fall-thou to $LK,"KStart64",A="FL:::/Kernel/KStart64.HC,1"$, next.
}
