/* You "Adam include" this because you want the wallpaper
routine to stay in mem even if this task is killed.

  <CTRL-t> to see the hidden text needed for sprite elements.

  <CTRL-r> to add a sprite to a document.
$WW,0$*/

$SP,"<1>",BI=1$


$SP,"<2>",BI=2$


$SP,"<3>",BI=3$


$SP,"<4>",BI=4$



$SP,"<5>",BI=5$



$SP,"<6>",BI=6$



$SP,"<7>",BI=7$


$SP,"<8>",BI=8$


$SP,"<9>",BI=9$


#define TYPES_OF_CRITTERS	3
#define FRAMES_PER_CRITTER	4

U8 *imgs[TYPES_OF_CRITTERS][FRAMES_PER_CRITTER]={
  {$IB,"<1>",BI=1$,$IB,"<2>",BI=2$,$IB,"<3>",BI=3$,$IB,"<2>",BI=2$},
  {$IB,"<4>",BI=4$,$IB,"<5>",BI=5$,$IB,"<6>",BI=6$,$IB,"<5>",BI=5$},
  {$IB,"<7>",BI=7$,$IB,"<8>",BI=8$,$IB,"<9>",BI=9$,$IB,"<8>",BI=8$}
};

#define CRITTERS_NUM	16
class Critter
{
  I64 x,y,dx,dy,type;
  F64 t_offset;
} wall_crits[CRITTERS_NUM];

U0 (*old_wall_paper)(CTask *task);

U0 WallPaperFish(CTask *task)
{
  I64 i,j,x,y;
  CDC *dc=DCAlias(gr.dc2,task);
  Critter *c=wall_crits;

  task->text_attr=CYAN<<4+WHITE;
  dc->color=BROWN;
  for (i=0;i<GR_HEIGHT;i+=20) {
    j=16*Tri(tS*10,20);
    GrLine(dc,0,GR_HEIGHT-i-j,GR_HEIGHT-i-j,GR_HEIGHT);
  }
  for (i=0;i<CRITTERS_NUM;i++,c++) {
    j=(tS*4+c->t_offset)%FRAMES_PER_CRITTER;
    x=c->x>>16%GR_WIDTH;
    if (x<0) x+=GR_WIDTH;
    y=c->y>>16%GR_HEIGHT;
    if (y<0) y+=GR_HEIGHT;
    if (c->dx<0) {
      dc->flags|=DCF_SYMMETRY|DCF_JUST_MIRROR;
      DCSymmetrySet(dc,x,y-1,x,y+1);
    } else
      dc->flags&=~(DCF_SYMMETRY|DCF_JUST_MIRROR);
    Sprite3(dc,x,y,0,imgs[c->type][j]);
    c->x+=c->dx;  c->y+=c->dy;
  }
  DCDel(dc);

  //Uncomment the following if you wish.
  //old_wall_paper(task);
}

U0 WallInit()
{
  I64 i;
  Critter *c;
  if (Fs!=adam_task) {
    "Must be Adam Included with SHIFT-F5.\n"
	  "(Would crash when code mem was freed.)\n";
    return;
  }
  old_wall_paper=gr.fp_wall_paper;
  c=wall_crits;
  for (i=0;i<CRITTERS_NUM;i++,c++) {
    c->x=(RandU16%GR_WIDTH)<<16;
    c->y=(RandU16%GR_HEIGHT)<<16;
    c->type=RandU16%TYPES_OF_CRITTERS;
    c->dx=RandI16;
    if (c->dx<0)
      c->dx-=0x4000;
    else
      c->dx+=0x4000;
    c->dy=RandI16;
    c->t_offset=Rand*FRAMES_PER_CRITTER;
  }
  gr.fp_wall_paper=&WallPaperFish;
}

WallInit;
                                                                                                                                                                                                                                R                                                                                                                      b                                                        2                                             	       b                                                                                                                                                                                                                                                                                                                                                                                    