#define MODULE_SIZE		2*BLK_SIZE
#define BOOT_HIGH_LOC_MHD2	((BOOT_RAM_LIMIT-\
				(BOOT_STK_SIZE+MODULE_SIZE))>>4)

DefinePrint(
  "DD_BOOT_HIGH_LOC_MHD2","%08X",BOOT_HIGH_LOC_MHD2<<4);

asm {
USE16
BMHD2_START::
	MOV	U32 FS:[0],'B'+0x2000+('2'+0x2000)<<16

	MOV	AX,BOOT_HIGH_LOC_MHD2
	MOV	ES,AX
//This copies this bootloader's code to 0x$TX,"00096A00",D="DD_BOOT_HIGH_LOC_MHD2"$
	MOV	AX,CS
	MOV	DS,AX
	MOV	U32 [BMHD2_OLD_CS_RIP-BMHD2_START],EBX
	MOV	U8 [BMHD2_BIOS_DRV_NUM-BMHD2_START],DL

	MOV	CX,MODULE_SIZE
	XOR	SI,SI
	XOR	DI,DI
	REP_MOVSB

	MOV	AX,BOOT_HIGH_LOC_MHD2
	MOV	DS,AX

//My assembler doesn't support 16-bit very well.
	DU8	0xEA;	//JMP BOOT_HIGH_LOC_MHD2:BMHD2_HISTART
	DU16	BMHD2_HISTART-BMHD2_START,BOOT_HIGH_LOC_MHD2;

BMHD2_BOOT_MSG::
	DU8	256 DUP(0);

BMHD2_BIOS_DRV_NUM:	DU8	0;
BMHD2_PAGE:		DU8	0;
BMHD2_BLK_ARRAY::	DU64 8 DUP(0);

BMHD2_DAP:		DU8	16,0,1,0; //One blk at a time
BMHD2_DAP_BUF:		DU16	0,0;
BMHD2_DAP_BLK::	//64-bit
BMHD2_DAP_BLK_LO:	DU32	0;
BMHD2_DAP_BLK_HI:	DU32	0;

BMHD2_PUT_CHAR::
	MOV	AH,0xE
	MOV	BL,7 //Might be foreground color on some BIOS's
	MOV	BH,U8 [BMHD2_PAGE-BMHD2_START]
	INT	0x10
BMHD2_RET::
	RET
BMHD2_PUTS::
@@1:	LODSB
	TEST	AL,AL
	JZ	BMHD2_RET
	CALL	BMHD2_PUT_CHAR
	JMP	@@1

BMHD2_GETCHAR:
	XOR	AH,AH
	INT	0x16
	PUSH	AX
	MOV	AH,0x0E
	MOV	BX,0x07
	INT	0x10
	POP	AX
	RET

BMHD2_HISTART:
	MOV	AH,0xF
	INT	0x10
	MOV	U8 [BMHD2_PAGE-BMHD2_START],BH //Video page

	MOV	U32 FS:[0],0
@@5:	MOV	SI,BMHD2_BOOT_MSG-BMHD2_START
	CALL	BMHD2_PUTS
	CALL	BMHD2_GETCHAR
	CMP	AL,'0'
	JB	@@5
	CMP	AL,'8'
	JAE	@@5
	AND	EAX,7

	MOV	EBX,U32 BMHD2_BLK_ARRAY-BMHD2_START[EAX*8]
	MOV	EAX,U32 BMHD2_BLK_ARRAY+4-BMHD2_START[EAX*8]

	TEST	EBX,EBX
	JNZ	@@10
	TEST	EAX,EAX
	JZ	@@5

@@10:	MOV	U32 [BMHD2_DAP_BLK_LO-BMHD2_START],EBX
	MOV	U32 [BMHD2_DAP_BLK_HI-BMHD2_START],EAX

	MOV	AX,U16 [BMHD2_OLD_CS_RIP-BMHD2_START]
	SHR	AX,4
	ADD	AX,U16 [BMHD2_OLD_CS_RIP+2-BMHD2_START]
	MOV	U16 [BMHD2_DAP_BUF+2-BMHD2_START],AX //ES:0000
	MOV	SI,BMHD2_DAP-BMHD2_START //DS:SI=DAP
	MOV	DL,U8 [BMHD2_BIOS_DRV_NUM-BMHD2_START]
	MOV	AH,0x42
	INT	0x13

	POP	EBP
	POP	EDX
	POP	EBX
	POP	ECX
	XOR	EAX,EAX
	POP	GS
	POP	FS
	POP	ES
	POP	DS
	POPFW

//My assembler doesn't support 16-bit very well.
	DU8	0xEA;	//JMP xxxx:yyyy
BMHD2_OLD_CS_RIP:
	DU16	0,0;
BMHD2_END::
//Continues here $LK,"::/Adam/Opt/Boot/BootHD.HC",A="FF:::/Adam/Opt/Boot/BootHD.HC,START"$
#assert BMHD2_END-BMHD2_START<MODULE_SIZE
}
