#define MODULE_SIZE		1*BLK_SIZE
#define BOOT_HIGH_LOC_HD	((BOOT_RAM_LIMIT-\
				(BOOT_STK_SIZE+MODULE_SIZE))>>4)

DefinePrint(
  "DD_BOOT_HIGH_LOC_HD","%08X",BOOT_HIGH_LOC_HD<<4);

asm {
USE16
BHD_CODE::

#define BHD_START (BHD_CODE-offset(CFAT32Boot.code))

	CLD

	MOV	AX,BOOT_HIGH_LOC_HD
	MOV	ES,AX

	CLI
	MOV	SS,AX
	MOV	SP,BOOT_STK_SIZE+MODULE_SIZE
	STI

	CALL	BHD_GET_RIP
BHD_GET_RIP:
	POP	BX
	SUB	BX,BHD_GET_RIP-BHD_START
	SHR	BX,4
//This copies this bootloader's code to 0x$TX,"00096C00",D="DD_BOOT_HIGH_LOC_HD"$
	MOV	AX,CS
	ADD	AX,BX
	MOV	DS,AX
	MOV	CX,MODULE_SIZE
	XOR	SI,SI
	XOR	DI,DI
	REP_MOVSB

	MOV	AX,BOOT_HIGH_LOC_HD
	MOV	DS,AX

//My assembler doesn't support 16-bit very well.
	DU8	0xEA;	//JMP BOOT_HIGH_LOC_HD:BHD_HISTART
	DU16	BHD_HISTART-BHD_START,BOOT_HIGH_LOC_HD;

BHD_BIOS_DRV_NUM: DU8	0;

//Gets patched by $LK,"BootHDIns",A="MN:BootHDIns"$().
BHD_BLK_CNT::	DU16	0;

BHD_DAP:	DU8	16,0,1,0; //One blk at a time
BHD_DAP_BUF:	DU16	0,0;
//Gets patched by $LK,"BootHDIns",A="MN:BootHDIns"$().
BHD_DAP_BLK::	//64-bit
BHD_DAP_BLK_LO:	DU32	0;
BHD_DAP_BLK_HI:	DU32	0;

BHD_HISTART:
	MOV	U8 [BHD_BIOS_DRV_NUM-BHD_START],DL //Passed in by BIOS
	MOV	AX,BOOT_RAM_BASE/16
	MOV	ES,AX
	XOR	ECX,ECX
	MOV	CX,U16 [BHD_BLK_CNT-BHD_START]

@@05:	PUSH	CX	//Blk cnt

//READ BLK
	PUSH	ES	//Buf seg
	MOV	AX,ES
	MOV	U16 [BHD_DAP_BUF+2-BHD_START],AX //ES:0000
	MOV	SI,BHD_DAP-BHD_START //DS:SI=DAP
	MOV	AH,0x42
	MOV	DL,U8 [BHD_BIOS_DRV_NUM-BHD_START]
	INT	0x13

	POP	AX	//ES
	ADD	AX,BLK_SIZE/16
	MOV	ES,AX
	INC	U32 [BHD_DAP_BLK_LO-BHD_START]
	JNZ	@@10
	INC	U32 [BHD_DAP_BLK_HI-BHD_START]

@@10:	POP	CX
	LOOP	@@05

	XOR	EBX,EBX
	MOV	EAX,BOOT_SRC_HARDDRV //$MA-X+PU,"See sys_boot_src",LM="Find(\"sys_boot_src\",\"/*\");View;\n"$
//My assembler doesn't support 16-bit very well.
	DU8	0xEA;	//JMP BOOT_RAM_BASE:0000
	DU16	0,BOOT_RAM_BASE/16;
//Continues here $LK,"::/Kernel/KStart16.HC",A="FL:::/Kernel/KStart16.HC,1"$
BHD_END::
#assert BHD_END-BHD_START<MODULE_SIZE-2
}
