![banner](docs/readme-banner.png)

# 复古像素字体 / Retro Pixel Font

[![License OFL](https://img.shields.io/badge/license-OFL--1.1-orange)](https://openfontlicense.org)
[![License MIT](https://img.shields.io/badge/license-MIT-green)](https://opensource.org/license/MIT)
[![Releases](https://img.shields.io/github/v/release/TakWolf/retro-pixel-font)](https://github.com/TakWolf/retro-pixel-font/releases)
[![Itch.io](https://img.shields.io/badge/itch.io-retro--pixel--font-FF2449?logo=itch.io&logoColor=white)](https://takwolf.itch.io/retro-pixel-font)
[![Discord](https://img.shields.io/badge/discord-像素字体工房-4E5AF0?logo=discord&logoColor=white)](https://discord.gg/3GKtPKtjdU)
[![QQ Group](https://img.shields.io/badge/QQ群-像素字体工房-brightgreen?logo=tencentqq&logoColor=white)](https://qm.qq.com/q/X1mLrLLGYS)

一组开源的有怀旧游戏感觉的像素字体。字体基本上以英文、数字和符号为主。

如果您在寻找开源的泛中日韩或 Unicode 像素字体，请尝试 [「方舟像素字体」](https://github.com/TakWolf/ark-pixel-font)。

这个项目不仅提供了全部的字形源文件，也提供了构建字体所需要的完整程序。

## 预览

可以通过 [主页](https://retro-pixel-font.takwolf.com) 实时预览字体效果。

### Arcade

尺寸：8px / 行高：12px · [实时预览](https://retro-pixel-font.takwolf.com#font-arcade) · [字母表](https://retro-pixel-font.takwolf.com/arcade/alphabet.html) · [示例文本](https://retro-pixel-font.takwolf.com/arcade/demo.html)

![preview-arcade](docs/arcade/preview.png)

### Cute Mono

尺寸：11px / 行高：15px · [实时预览](https://retro-pixel-font.takwolf.com#font-cute-mono) · [字母表](https://retro-pixel-font.takwolf.com/cute-mono/alphabet.html) · [示例文本](https://retro-pixel-font.takwolf.com/cute-mono/demo.html)

![preview-cute-mono](docs/cute-mono/preview.png)

### Cute Prop

尺寸：11px / 行高：15px · [实时预览](https://retro-pixel-font.takwolf.com#font-cute-prop) · [字母表](https://retro-pixel-font.takwolf.com/cute-prop/alphabet.html) · [示例文本](https://retro-pixel-font.takwolf.com/cute-prop/demo.html)

![preview-cute-prop](docs/cute-prop/preview.png)

### Petty 5H

尺寸：5px / 行高：9px · [实时预览](https://retro-pixel-font.takwolf.com#font-petty-5h) · [字母表](https://retro-pixel-font.takwolf.com/petty-5h/alphabet.html) · [示例文本](https://retro-pixel-font.takwolf.com/petty-5h/demo.html)

![preview-petty-5h](docs/petty-5h/preview.png)

### Petty 5x5

尺寸：5px / 行高：9px · [实时预览](https://retro-pixel-font.takwolf.com#font-petty-5x5) · [字母表](https://retro-pixel-font.takwolf.com/petty-5x5/alphabet.html) · [示例文本](https://retro-pixel-font.takwolf.com/petty-5x5/demo.html)

![preview-petty-5x5](docs/petty-5x5/preview.png)

### Thick

尺寸：16px / 行高：20px · [实时预览](https://retro-pixel-font.takwolf.com#font-thick) · [字母表](https://retro-pixel-font.takwolf.com/thick/alphabet.html) · [示例文本](https://retro-pixel-font.takwolf.com/thick/demo.html)

![preview-thick](docs/thick/preview.png)

## 下载

可通过以下渠道下载最新的版本：

- [GitHub Releases](https://github.com/TakWolf/retro-pixel-font/releases)
- [itch.io](https://takwolf.itch.io/retro-pixel-font)

目前提供 `.otf`、`.ttf`、`.woff2`、`.bdf`、`.pcf` 五种格式。

## 本地构建

这是一个标准的 [Python3](https://www.python.org) 项目。

当您配置好运行环境后，执行 `python -m tools.build` 命令来开始构建。

等待任务完成后，可在 `build/outputs` 目录下找到生成的字体文件。

## 授权许可

分为「字体」和「构建程序」两个部分。

### 字体

使用 [「SIL 开放字体许可证第 1.1 版」](LICENSE-OFL) 授权。

### 构建程序

使用 [「MIT 许可证」](LICENSE-MIT) 授权。

## 官方社区

- [「像素字体工房」Discord 服务器](https://discord.gg/3GKtPKtjdU)
- [「像素字体工房」QQ 群 (302383204)](https://qm.qq.com/q/X1mLrLLGYS)

## 程序依赖

- [Pixel Font Builder](https://github.com/TakWolf/pixel-font-builder)
- [Pixel Font Knife](https://github.com/TakWolf/pixel-font-knife)
- [Pillow](https://github.com/python-pillow/Pillow)
- [Beautiful Soup](https://www.crummy.com/software/BeautifulSoup/)
- [Jinja](https://github.com/pallets/jinja)
- [Loguru](https://github.com/Delgan/loguru)

## 赞助

如果这个项目对您有帮助，请考虑赞助来支持开发工作。

[![赞赏码](https://raw.githubusercontent.com/TakWolf/TakWolf/master/images/badge-payqr@2x.png)](https://github.com/TakWolf/TakWolf/blob/master/payment-qr-codes.md)
[![爱发电](https://raw.githubusercontent.com/TakWolf/TakWolf/master/images/badge-afdian@2x.png)](https://afdian.com/a/takwolf)

请通过下面的链接来查看收到的赞助的具体情况：

[赞助详情](https://github.com/TakWolf/TakWolf/blob/master/sponsors.md)
