var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var __accessCheck = (obj, member, msg) => {
  if (!member.has(obj))
    throw TypeError("Cannot " + msg);
};
var __privateGet = (obj, member, getter) => {
  __accessCheck(obj, member, "read from private field");
  return getter ? getter.call(obj) : member.get(obj);
};
var __privateAdd = (obj, member, value) => {
  if (member.has(obj))
    throw TypeError("Cannot add the same private member more than once");
  member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
};
var __privateSet = (obj, member, value, setter) => {
  __accessCheck(obj, member, "write to private field");
  setter ? setter.call(obj, value) : member.set(obj, value);
  return value;
};
var __privateMethod = (obj, member, method) => {
  __accessCheck(obj, member, "access private method");
  return method;
};
(function() {
  var _root, _hasMagic, _uflag, _parts, _parent, _parentIndex, _negs, _filledNegs, _options, _toString2, _emptyExt, _fillNegs, fillNegs_fn, _parseAST, parseAST_fn, _partsToRegExp, partsToRegExp_fn, _parseGlob, parseGlob_fn;
  "use strict";
  class ErrorHandler {
    constructor() {
      this.listeners = [];
      this.unexpectedErrorHandler = function(e) {
        setTimeout(() => {
          if (e.stack) {
            if (ErrorNoTelemetry.isErrorNoTelemetry(e)) {
              throw new ErrorNoTelemetry(e.message + "\n\n" + e.stack);
            }
            throw new Error(e.message + "\n\n" + e.stack);
          }
          throw e;
        }, 0);
      };
    }
    emit(e) {
      this.listeners.forEach((listener) => {
        listener(e);
      });
    }
    onUnexpectedError(e) {
      this.unexpectedErrorHandler(e);
      this.emit(e);
    }
    // For external errors, we don't want the listeners to be called
    onUnexpectedExternalError(e) {
      this.unexpectedErrorHandler(e);
    }
  }
  const errorHandler = new ErrorHandler();
  function onUnexpectedError(e) {
    if (!isCancellationError(e)) {
      errorHandler.onUnexpectedError(e);
    }
    return void 0;
  }
  function transformErrorForSerialization(error) {
    if (error instanceof Error) {
      const { name, message } = error;
      const stack = error.stacktrace || error.stack;
      return {
        $isError: true,
        name,
        message,
        stack,
        noTelemetry: ErrorNoTelemetry.isErrorNoTelemetry(error)
      };
    }
    return error;
  }
  const canceledName = "Canceled";
  function isCancellationError(error) {
    if (error instanceof CancellationError) {
      return true;
    }
    return error instanceof Error && error.name === canceledName && error.message === canceledName;
  }
  class CancellationError extends Error {
    constructor() {
      super(canceledName);
      this.name = this.message;
    }
  }
  class ErrorNoTelemetry extends Error {
    constructor(msg) {
      super(msg);
      this.name = "CodeExpectedError";
    }
    static fromError(err) {
      if (err instanceof ErrorNoTelemetry) {
        return err;
      }
      const result = new ErrorNoTelemetry();
      result.message = err.message;
      result.stack = err.stack;
      return result;
    }
    static isErrorNoTelemetry(err) {
      return err.name === "CodeExpectedError";
    }
  }
  class BugIndicatingError extends Error {
    constructor(message) {
      super(message || "An unexpected bug occurred.");
      Object.setPrototypeOf(this, BugIndicatingError.prototype);
    }
  }
  function once(fn) {
    const _this = this;
    let didCall = false;
    let result;
    return function() {
      if (didCall) {
        return result;
      }
      didCall = true;
      result = fn.apply(_this, arguments);
      return result;
    };
  }
  var Iterable;
  (function(Iterable2) {
    function is(thing) {
      return thing && typeof thing === "object" && typeof thing[Symbol.iterator] === "function";
    }
    Iterable2.is = is;
    const _empty2 = Object.freeze([]);
    function empty2() {
      return _empty2;
    }
    Iterable2.empty = empty2;
    function* single(element) {
      yield element;
    }
    Iterable2.single = single;
    function wrap(iterableOrElement) {
      if (is(iterableOrElement)) {
        return iterableOrElement;
      } else {
        return single(iterableOrElement);
      }
    }
    Iterable2.wrap = wrap;
    function from(iterable) {
      return iterable || _empty2;
    }
    Iterable2.from = from;
    function isEmpty(iterable) {
      return !iterable || iterable[Symbol.iterator]().next().done === true;
    }
    Iterable2.isEmpty = isEmpty;
    function first(iterable) {
      return iterable[Symbol.iterator]().next().value;
    }
    Iterable2.first = first;
    function some2(iterable, predicate) {
      for (const element of iterable) {
        if (predicate(element)) {
          return true;
        }
      }
      return false;
    }
    Iterable2.some = some2;
    function find(iterable, predicate) {
      for (const element of iterable) {
        if (predicate(element)) {
          return element;
        }
      }
      return void 0;
    }
    Iterable2.find = find;
    function* filter(iterable, predicate) {
      for (const element of iterable) {
        if (predicate(element)) {
          yield element;
        }
      }
    }
    Iterable2.filter = filter;
    function* map2(iterable, fn) {
      let index2 = 0;
      for (const element of iterable) {
        yield fn(element, index2++);
      }
    }
    Iterable2.map = map2;
    function* concat(...iterables) {
      for (const iterable of iterables) {
        for (const element of iterable) {
          yield element;
        }
      }
    }
    Iterable2.concat = concat;
    function reduce(iterable, reducer, initialValue) {
      let value = initialValue;
      for (const element of iterable) {
        value = reducer(value, element);
      }
      return value;
    }
    Iterable2.reduce = reduce;
    function* slice(arr, from2, to = arr.length) {
      if (from2 < 0) {
        from2 += arr.length;
      }
      if (to < 0) {
        to += arr.length;
      } else if (to > arr.length) {
        to = arr.length;
      }
      for (; from2 < to; from2++) {
        yield arr[from2];
      }
    }
    Iterable2.slice = slice;
    function consume(iterable, atMost = Number.POSITIVE_INFINITY) {
      const consumed = [];
      if (atMost === 0) {
        return [consumed, iterable];
      }
      const iterator2 = iterable[Symbol.iterator]();
      for (let i = 0; i < atMost; i++) {
        const next2 = iterator2.next();
        if (next2.done) {
          return [consumed, Iterable2.empty()];
        }
        consumed.push(next2.value);
      }
      return [consumed, { [Symbol.iterator]() {
        return iterator2;
      } }];
    }
    Iterable2.consume = consume;
  })(Iterable || (Iterable = {}));
  function trackDisposable(x) {
    return x;
  }
  function setParentOfDisposable(child, parent) {
  }
  function dispose(arg) {
    if (Iterable.is(arg)) {
      const errors = [];
      for (const d of arg) {
        if (d) {
          try {
            d.dispose();
          } catch (e) {
            errors.push(e);
          }
        }
      }
      if (errors.length === 1) {
        throw errors[0];
      } else if (errors.length > 1) {
        throw new AggregateError(errors, "Encountered errors while disposing of store");
      }
      return Array.isArray(arg) ? [] : arg;
    } else if (arg) {
      arg.dispose();
      return arg;
    }
  }
  function combinedDisposable(...disposables) {
    const parent = toDisposable(() => dispose(disposables));
    return parent;
  }
  function toDisposable(fn) {
    const self2 = trackDisposable({
      dispose: once(() => {
        fn();
      })
    });
    return self2;
  }
  class DisposableStore {
    constructor() {
      this._toDispose = /* @__PURE__ */ new Set();
      this._isDisposed = false;
    }
    /**
     * Dispose of all registered disposables and mark this object as disposed.
     *
     * Any future disposables added to this object will be disposed of on `add`.
     */
    dispose() {
      if (this._isDisposed) {
        return;
      }
      this._isDisposed = true;
      this.clear();
    }
    /**
     * @return `true` if this object has been disposed of.
     */
    get isDisposed() {
      return this._isDisposed;
    }
    /**
     * Dispose of all registered disposables but do not mark this object as disposed.
     */
    clear() {
      if (this._toDispose.size === 0) {
        return;
      }
      try {
        dispose(this._toDispose);
      } finally {
        this._toDispose.clear();
      }
    }
    /**
     * Add a new {@link IDisposable disposable} to the collection.
     */
    add(o) {
      if (!o) {
        return o;
      }
      if (o === this) {
        throw new Error("Cannot register a disposable on itself!");
      }
      if (this._isDisposed) {
        if (!DisposableStore.DISABLE_DISPOSED_WARNING) {
          console.warn(new Error("Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!").stack);
        }
      } else {
        this._toDispose.add(o);
      }
      return o;
    }
  }
  DisposableStore.DISABLE_DISPOSED_WARNING = false;
  class Disposable {
    constructor() {
      this._store = new DisposableStore();
      setParentOfDisposable(this._store);
    }
    dispose() {
      this._store.dispose();
    }
    /**
     * Adds `o` to the collection of disposables managed by this object.
     */
    _register(o) {
      if (o === this) {
        throw new Error("Cannot register a disposable on itself!");
      }
      return this._store.add(o);
    }
  }
  Disposable.None = Object.freeze({ dispose() {
  } });
  let Node$3 = class Node2 {
    constructor(element) {
      this.element = element;
      this.next = Node2.Undefined;
      this.prev = Node2.Undefined;
    }
  };
  Node$3.Undefined = new Node$3(void 0);
  class LinkedList {
    constructor() {
      this._first = Node$3.Undefined;
      this._last = Node$3.Undefined;
      this._size = 0;
    }
    get size() {
      return this._size;
    }
    isEmpty() {
      return this._first === Node$3.Undefined;
    }
    clear() {
      let node = this._first;
      while (node !== Node$3.Undefined) {
        const next2 = node.next;
        node.prev = Node$3.Undefined;
        node.next = Node$3.Undefined;
        node = next2;
      }
      this._first = Node$3.Undefined;
      this._last = Node$3.Undefined;
      this._size = 0;
    }
    unshift(element) {
      return this._insert(element, false);
    }
    push(element) {
      return this._insert(element, true);
    }
    _insert(element, atTheEnd) {
      const newNode = new Node$3(element);
      if (this._first === Node$3.Undefined) {
        this._first = newNode;
        this._last = newNode;
      } else if (atTheEnd) {
        const oldLast = this._last;
        this._last = newNode;
        newNode.prev = oldLast;
        oldLast.next = newNode;
      } else {
        const oldFirst = this._first;
        this._first = newNode;
        newNode.next = oldFirst;
        oldFirst.prev = newNode;
      }
      this._size += 1;
      let didRemove = false;
      return () => {
        if (!didRemove) {
          didRemove = true;
          this._remove(newNode);
        }
      };
    }
    shift() {
      if (this._first === Node$3.Undefined) {
        return void 0;
      } else {
        const res = this._first.element;
        this._remove(this._first);
        return res;
      }
    }
    pop() {
      if (this._last === Node$3.Undefined) {
        return void 0;
      } else {
        const res = this._last.element;
        this._remove(this._last);
        return res;
      }
    }
    _remove(node) {
      if (node.prev !== Node$3.Undefined && node.next !== Node$3.Undefined) {
        const anchor = node.prev;
        anchor.next = node.next;
        node.next.prev = anchor;
      } else if (node.prev === Node$3.Undefined && node.next === Node$3.Undefined) {
        this._first = Node$3.Undefined;
        this._last = Node$3.Undefined;
      } else if (node.next === Node$3.Undefined) {
        this._last = this._last.prev;
        this._last.next = Node$3.Undefined;
      } else if (node.prev === Node$3.Undefined) {
        this._first = this._first.next;
        this._first.prev = Node$3.Undefined;
      }
      this._size -= 1;
    }
    *[Symbol.iterator]() {
      let node = this._first;
      while (node !== Node$3.Undefined) {
        yield node.element;
        node = node.next;
      }
    }
  }
  const hasPerformanceNow = globalThis.performance && typeof globalThis.performance.now === "function";
  class StopWatch {
    static create(highResolution) {
      return new StopWatch(highResolution);
    }
    constructor(highResolution) {
      this._now = hasPerformanceNow && highResolution === false ? Date.now : globalThis.performance.now.bind(globalThis.performance);
      this._startTime = this._now();
      this._stopTime = -1;
    }
    stop() {
      this._stopTime = this._now();
    }
    elapsed() {
      if (this._stopTime !== -1) {
        return this._stopTime - this._startTime;
      }
      return this._now() - this._startTime;
    }
  }
  var Event;
  (function(Event2) {
    Event2.None = () => Disposable.None;
    function defer(event, disposable) {
      return debounce(event, () => void 0, 0, void 0, true, void 0, disposable);
    }
    Event2.defer = defer;
    function once2(event) {
      return (listener, thisArgs = null, disposables) => {
        let didFire = false;
        let result = void 0;
        result = event((e) => {
          if (didFire) {
            return;
          } else if (result) {
            result.dispose();
          } else {
            didFire = true;
          }
          return listener.call(thisArgs, e);
        }, null, disposables);
        if (didFire) {
          result.dispose();
        }
        return result;
      };
    }
    Event2.once = once2;
    function map2(event, map3, disposable) {
      return snapshot((listener, thisArgs = null, disposables) => event((i) => listener.call(thisArgs, map3(i)), null, disposables), disposable);
    }
    Event2.map = map2;
    function forEach(event, each, disposable) {
      return snapshot((listener, thisArgs = null, disposables) => event((i) => {
        each(i);
        listener.call(thisArgs, i);
      }, null, disposables), disposable);
    }
    Event2.forEach = forEach;
    function filter(event, filter2, disposable) {
      return snapshot((listener, thisArgs = null, disposables) => event((e) => filter2(e) && listener.call(thisArgs, e), null, disposables), disposable);
    }
    Event2.filter = filter;
    function signal(event) {
      return event;
    }
    Event2.signal = signal;
    function any(...events) {
      return (listener, thisArgs = null, disposables) => combinedDisposable(...events.map((event) => event((e) => listener.call(thisArgs, e), null, disposables)));
    }
    Event2.any = any;
    function reduce(event, merge, initial, disposable) {
      let output = initial;
      return map2(event, (e) => {
        output = merge(output, e);
        return output;
      }, disposable);
    }
    Event2.reduce = reduce;
    function snapshot(event, disposable) {
      let listener;
      const options = {
        onWillAddFirstListener() {
          listener = event(emitter.fire, emitter);
        },
        onDidRemoveLastListener() {
          listener === null || listener === void 0 ? void 0 : listener.dispose();
        }
      };
      const emitter = new Emitter(options);
      disposable === null || disposable === void 0 ? void 0 : disposable.add(emitter);
      return emitter.event;
    }
    function debounce(event, merge, delay = 100, leading = false, flushOnListenerRemove = false, leakWarningThreshold, disposable) {
      let subscription;
      let output = void 0;
      let handle = void 0;
      let numDebouncedCalls = 0;
      let doFire;
      const options = {
        leakWarningThreshold,
        onWillAddFirstListener() {
          subscription = event((cur) => {
            numDebouncedCalls++;
            output = merge(output, cur);
            if (leading && !handle) {
              emitter.fire(output);
              output = void 0;
            }
            doFire = () => {
              const _output = output;
              output = void 0;
              handle = void 0;
              if (!leading || numDebouncedCalls > 1) {
                emitter.fire(_output);
              }
              numDebouncedCalls = 0;
            };
            if (typeof delay === "number") {
              clearTimeout(handle);
              handle = setTimeout(doFire, delay);
            } else {
              if (handle === void 0) {
                handle = 0;
                queueMicrotask(doFire);
              }
            }
          });
        },
        onWillRemoveListener() {
          if (flushOnListenerRemove && numDebouncedCalls > 0) {
            doFire === null || doFire === void 0 ? void 0 : doFire();
          }
        },
        onDidRemoveLastListener() {
          doFire = void 0;
          subscription.dispose();
        }
      };
      const emitter = new Emitter(options);
      disposable === null || disposable === void 0 ? void 0 : disposable.add(emitter);
      return emitter.event;
    }
    Event2.debounce = debounce;
    function accumulate(event, delay = 0, disposable) {
      return Event2.debounce(event, (last2, e) => {
        if (!last2) {
          return [e];
        }
        last2.push(e);
        return last2;
      }, delay, void 0, true, void 0, disposable);
    }
    Event2.accumulate = accumulate;
    function latch(event, equals2 = (a2, b) => a2 === b, disposable) {
      let firstCall = true;
      let cache;
      return filter(event, (value) => {
        const shouldEmit = firstCall || !equals2(value, cache);
        firstCall = false;
        cache = value;
        return shouldEmit;
      }, disposable);
    }
    Event2.latch = latch;
    function split(event, isT, disposable) {
      return [
        Event2.filter(event, isT, disposable),
        Event2.filter(event, (e) => !isT(e), disposable)
      ];
    }
    Event2.split = split;
    function buffer(event, flushAfterTimeout = false, _buffer = []) {
      let buffer2 = _buffer.slice();
      let listener = event((e) => {
        if (buffer2) {
          buffer2.push(e);
        } else {
          emitter.fire(e);
        }
      });
      const flush2 = () => {
        buffer2 === null || buffer2 === void 0 ? void 0 : buffer2.forEach((e) => emitter.fire(e));
        buffer2 = null;
      };
      const emitter = new Emitter({
        onWillAddFirstListener() {
          if (!listener) {
            listener = event((e) => emitter.fire(e));
          }
        },
        onDidAddFirstListener() {
          if (buffer2) {
            if (flushAfterTimeout) {
              setTimeout(flush2);
            } else {
              flush2();
            }
          }
        },
        onDidRemoveLastListener() {
          if (listener) {
            listener.dispose();
          }
          listener = null;
        }
      });
      return emitter.event;
    }
    Event2.buffer = buffer;
    class ChainableEvent {
      constructor(event) {
        this.event = event;
        this.disposables = new DisposableStore();
      }
      /** @see {@link Event.map} */
      map(fn) {
        return new ChainableEvent(map2(this.event, fn, this.disposables));
      }
      /** @see {@link Event.forEach} */
      forEach(fn) {
        return new ChainableEvent(forEach(this.event, fn, this.disposables));
      }
      filter(fn) {
        return new ChainableEvent(filter(this.event, fn, this.disposables));
      }
      /** @see {@link Event.reduce} */
      reduce(merge, initial) {
        return new ChainableEvent(reduce(this.event, merge, initial, this.disposables));
      }
      /** @see {@link Event.reduce} */
      latch() {
        return new ChainableEvent(latch(this.event, void 0, this.disposables));
      }
      debounce(merge, delay = 100, leading = false, flushOnListenerRemove = false, leakWarningThreshold) {
        return new ChainableEvent(debounce(this.event, merge, delay, leading, flushOnListenerRemove, leakWarningThreshold, this.disposables));
      }
      /**
       * Attach a listener to the event.
       */
      on(listener, thisArgs, disposables) {
        return this.event(listener, thisArgs, disposables);
      }
      /** @see {@link Event.once} */
      once(listener, thisArgs, disposables) {
        return once2(this.event)(listener, thisArgs, disposables);
      }
      dispose() {
        this.disposables.dispose();
      }
    }
    function chain(event) {
      return new ChainableEvent(event);
    }
    Event2.chain = chain;
    function fromNodeEventEmitter(emitter, eventName, map3 = (id) => id) {
      const fn = (...args) => result.fire(map3(...args));
      const onFirstListenerAdd = () => emitter.on(eventName, fn);
      const onLastListenerRemove = () => emitter.removeListener(eventName, fn);
      const result = new Emitter({ onWillAddFirstListener: onFirstListenerAdd, onDidRemoveLastListener: onLastListenerRemove });
      return result.event;
    }
    Event2.fromNodeEventEmitter = fromNodeEventEmitter;
    function fromDOMEventEmitter(emitter, eventName, map3 = (id) => id) {
      const fn = (...args) => result.fire(map3(...args));
      const onFirstListenerAdd = () => emitter.addEventListener(eventName, fn);
      const onLastListenerRemove = () => emitter.removeEventListener(eventName, fn);
      const result = new Emitter({ onWillAddFirstListener: onFirstListenerAdd, onDidRemoveLastListener: onLastListenerRemove });
      return result.event;
    }
    Event2.fromDOMEventEmitter = fromDOMEventEmitter;
    function toPromise(event) {
      return new Promise((resolve2) => once2(event)(resolve2));
    }
    Event2.toPromise = toPromise;
    function runAndSubscribe(event, handler) {
      handler(void 0);
      return event((e) => handler(e));
    }
    Event2.runAndSubscribe = runAndSubscribe;
    function runAndSubscribeWithStore(event, handler) {
      let store = null;
      function run(e) {
        store === null || store === void 0 ? void 0 : store.dispose();
        store = new DisposableStore();
        handler(e, store);
      }
      run(void 0);
      const disposable = event((e) => run(e));
      return toDisposable(() => {
        disposable.dispose();
        store === null || store === void 0 ? void 0 : store.dispose();
      });
    }
    Event2.runAndSubscribeWithStore = runAndSubscribeWithStore;
    class EmitterObserver {
      constructor(_observable, store) {
        this._observable = _observable;
        this._counter = 0;
        this._hasChanged = false;
        const options = {
          onWillAddFirstListener: () => {
            _observable.addObserver(this);
          },
          onDidRemoveLastListener: () => {
            _observable.removeObserver(this);
          }
        };
        this.emitter = new Emitter(options);
        if (store) {
          store.add(this.emitter);
        }
      }
      beginUpdate(_observable) {
        this._counter++;
      }
      handlePossibleChange(_observable) {
      }
      handleChange(_observable, _change) {
        this._hasChanged = true;
      }
      endUpdate(_observable) {
        this._counter--;
        if (this._counter === 0) {
          this._observable.reportChanges();
          if (this._hasChanged) {
            this._hasChanged = false;
            this.emitter.fire(this._observable.get());
          }
        }
      }
    }
    function fromObservable(obs, store) {
      const observer = new EmitterObserver(obs, store);
      return observer.emitter.event;
    }
    Event2.fromObservable = fromObservable;
    function fromObservableLight(observable) {
      return (listener) => {
        let count2 = 0;
        let didChange = false;
        const observer = {
          beginUpdate() {
            count2++;
          },
          endUpdate() {
            count2--;
            if (count2 === 0) {
              observable.reportChanges();
              if (didChange) {
                didChange = false;
                listener();
              }
            }
          },
          handlePossibleChange() {
          },
          handleChange() {
            didChange = true;
          }
        };
        observable.addObserver(observer);
        observable.reportChanges();
        return {
          dispose() {
            observable.removeObserver(observer);
          }
        };
      };
    }
    Event2.fromObservableLight = fromObservableLight;
  })(Event || (Event = {}));
  class EventProfiling {
    constructor(name) {
      this.listenerCount = 0;
      this.invocationCount = 0;
      this.elapsedOverall = 0;
      this.durations = [];
      this.name = `${name}_${EventProfiling._idPool++}`;
      EventProfiling.all.add(this);
    }
    start(listenerCount) {
      this._stopWatch = new StopWatch();
      this.listenerCount = listenerCount;
    }
    stop() {
      if (this._stopWatch) {
        const elapsed = this._stopWatch.elapsed();
        this.durations.push(elapsed);
        this.elapsedOverall += elapsed;
        this.invocationCount += 1;
        this._stopWatch = void 0;
      }
    }
  }
  EventProfiling.all = /* @__PURE__ */ new Set();
  EventProfiling._idPool = 0;
  let _globalLeakWarningThreshold = -1;
  class LeakageMonitor {
    constructor(threshold, name = Math.random().toString(18).slice(2, 5)) {
      this.threshold = threshold;
      this.name = name;
      this._warnCountdown = 0;
    }
    dispose() {
      var _a2;
      (_a2 = this._stacks) === null || _a2 === void 0 ? void 0 : _a2.clear();
    }
    check(stack, listenerCount) {
      const threshold = this.threshold;
      if (threshold <= 0 || listenerCount < threshold) {
        return void 0;
      }
      if (!this._stacks) {
        this._stacks = /* @__PURE__ */ new Map();
      }
      const count2 = this._stacks.get(stack.value) || 0;
      this._stacks.set(stack.value, count2 + 1);
      this._warnCountdown -= 1;
      if (this._warnCountdown <= 0) {
        this._warnCountdown = threshold * 0.5;
        let topStack;
        let topCount = 0;
        for (const [stack2, count3] of this._stacks) {
          if (!topStack || topCount < count3) {
            topStack = stack2;
            topCount = count3;
          }
        }
        console.warn(`[${this.name}] potential listener LEAK detected, having ${listenerCount} listeners already. MOST frequent listener (${topCount}):`);
        console.warn(topStack);
      }
      return () => {
        const count3 = this._stacks.get(stack.value) || 0;
        this._stacks.set(stack.value, count3 - 1);
      };
    }
  }
  class Stacktrace {
    static create() {
      var _a2;
      return new Stacktrace((_a2 = new Error().stack) !== null && _a2 !== void 0 ? _a2 : "");
    }
    constructor(value) {
      this.value = value;
    }
    print() {
      console.warn(this.value.split("\n").slice(2).join("\n"));
    }
  }
  class UniqueContainer {
    constructor(value) {
      this.value = value;
    }
  }
  const compactionThreshold = 2;
  class Emitter {
    constructor(options) {
      var _a2, _b, _c, _d, _e;
      this._size = 0;
      this._options = options;
      this._leakageMon = ((_a2 = this._options) === null || _a2 === void 0 ? void 0 : _a2.leakWarningThreshold) ? new LeakageMonitor((_c = (_b = this._options) === null || _b === void 0 ? void 0 : _b.leakWarningThreshold) !== null && _c !== void 0 ? _c : _globalLeakWarningThreshold) : void 0;
      this._perfMon = ((_d = this._options) === null || _d === void 0 ? void 0 : _d._profName) ? new EventProfiling(this._options._profName) : void 0;
      this._deliveryQueue = (_e = this._options) === null || _e === void 0 ? void 0 : _e.deliveryQueue;
    }
    dispose() {
      var _a2, _b, _c, _d;
      if (!this._disposed) {
        this._disposed = true;
        if (((_a2 = this._deliveryQueue) === null || _a2 === void 0 ? void 0 : _a2.current) === this) {
          this._deliveryQueue.reset();
        }
        if (this._listeners) {
          this._listeners = void 0;
          this._size = 0;
        }
        (_c = (_b = this._options) === null || _b === void 0 ? void 0 : _b.onDidRemoveLastListener) === null || _c === void 0 ? void 0 : _c.call(_b);
        (_d = this._leakageMon) === null || _d === void 0 ? void 0 : _d.dispose();
      }
    }
    /**
     * For the public to allow to subscribe
     * to events from this Emitter
     */
    get event() {
      var _a2;
      (_a2 = this._event) !== null && _a2 !== void 0 ? _a2 : this._event = (callback, thisArgs, disposables) => {
        var _a3, _b, _c, _d, _e;
        if (this._leakageMon && this._size > this._leakageMon.threshold * 3) {
          console.warn(`[${this._leakageMon.name}] REFUSES to accept new listeners because it exceeded its threshold by far`);
          return Disposable.None;
        }
        if (this._disposed) {
          return Disposable.None;
        }
        if (thisArgs) {
          callback = callback.bind(thisArgs);
        }
        const contained = new UniqueContainer(callback);
        let removeMonitor;
        if (this._leakageMon && this._size >= Math.ceil(this._leakageMon.threshold * 0.2)) {
          contained.stack = Stacktrace.create();
          removeMonitor = this._leakageMon.check(contained.stack, this._size + 1);
        }
        if (!this._listeners) {
          (_b = (_a3 = this._options) === null || _a3 === void 0 ? void 0 : _a3.onWillAddFirstListener) === null || _b === void 0 ? void 0 : _b.call(_a3, this);
          this._listeners = contained;
          (_d = (_c = this._options) === null || _c === void 0 ? void 0 : _c.onDidAddFirstListener) === null || _d === void 0 ? void 0 : _d.call(_c, this);
        } else if (this._listeners instanceof UniqueContainer) {
          (_e = this._deliveryQueue) !== null && _e !== void 0 ? _e : this._deliveryQueue = new EventDeliveryQueuePrivate();
          this._listeners = [this._listeners, contained];
        } else {
          this._listeners.push(contained);
        }
        this._size++;
        const result = toDisposable(() => {
          removeMonitor === null || removeMonitor === void 0 ? void 0 : removeMonitor();
          this._removeListener(contained);
        });
        if (disposables instanceof DisposableStore) {
          disposables.add(result);
        } else if (Array.isArray(disposables)) {
          disposables.push(result);
        }
        return result;
      };
      return this._event;
    }
    _removeListener(listener) {
      var _a2, _b, _c, _d;
      (_b = (_a2 = this._options) === null || _a2 === void 0 ? void 0 : _a2.onWillRemoveListener) === null || _b === void 0 ? void 0 : _b.call(_a2, this);
      if (!this._listeners) {
        return;
      }
      if (this._size === 1) {
        this._listeners = void 0;
        (_d = (_c = this._options) === null || _c === void 0 ? void 0 : _c.onDidRemoveLastListener) === null || _d === void 0 ? void 0 : _d.call(_c, this);
        this._size = 0;
        return;
      }
      const listeners = this._listeners;
      const index2 = listeners.indexOf(listener);
      if (index2 === -1) {
        console.log("disposed?", this._disposed);
        console.log("size?", this._size);
        console.log("arr?", JSON.stringify(this._listeners));
        throw new Error("Attempted to dispose unknown listener");
      }
      this._size--;
      listeners[index2] = void 0;
      const adjustDeliveryQueue = this._deliveryQueue.current === this;
      if (this._size * compactionThreshold <= listeners.length) {
        let n = 0;
        for (let i = 0; i < listeners.length; i++) {
          if (listeners[i]) {
            listeners[n++] = listeners[i];
          } else if (adjustDeliveryQueue) {
            this._deliveryQueue.end--;
            if (n < this._deliveryQueue.i) {
              this._deliveryQueue.i--;
            }
          }
        }
        listeners.length = n;
      }
    }
    _deliver(listener, value) {
      var _a2;
      if (!listener) {
        return;
      }
      const errorHandler2 = ((_a2 = this._options) === null || _a2 === void 0 ? void 0 : _a2.onListenerError) || onUnexpectedError;
      if (!errorHandler2) {
        listener.value(value);
        return;
      }
      try {
        listener.value(value);
      } catch (e) {
        errorHandler2(e);
      }
    }
    /** Delivers items in the queue. Assumes the queue is ready to go. */
    _deliverQueue(dq) {
      const listeners = dq.current._listeners;
      while (dq.i < dq.end) {
        this._deliver(listeners[dq.i++], dq.value);
      }
      dq.reset();
    }
    /**
     * To be kept private to fire an event to
     * subscribers
     */
    fire(event) {
      var _a2, _b, _c, _d;
      if ((_a2 = this._deliveryQueue) === null || _a2 === void 0 ? void 0 : _a2.current) {
        this._deliverQueue(this._deliveryQueue);
        (_b = this._perfMon) === null || _b === void 0 ? void 0 : _b.stop();
      }
      (_c = this._perfMon) === null || _c === void 0 ? void 0 : _c.start(this._size);
      if (!this._listeners)
        ;
      else if (this._listeners instanceof UniqueContainer) {
        this._deliver(this._listeners, event);
      } else {
        const dq = this._deliveryQueue;
        dq.enqueue(this, event, this._listeners.length);
        this._deliverQueue(dq);
      }
      (_d = this._perfMon) === null || _d === void 0 ? void 0 : _d.stop();
    }
    hasListeners() {
      return this._size > 0;
    }
  }
  class EventDeliveryQueuePrivate {
    constructor() {
      this.i = -1;
      this.end = 0;
    }
    enqueue(emitter, value, end) {
      this.i = 0;
      this.end = end;
      this.current = emitter;
      this.value = value;
    }
    reset() {
      this.i = this.end;
      this.current = void 0;
      this.value = void 0;
    }
  }
  function isString$2(str2) {
    return typeof str2 === "string";
  }
  function getAllPropertyNames(obj) {
    let res = [];
    while (Object.prototype !== obj) {
      res = res.concat(Object.getOwnPropertyNames(obj));
      obj = Object.getPrototypeOf(obj);
    }
    return res;
  }
  function getAllMethodNames(obj) {
    const methods = [];
    for (const prop of getAllPropertyNames(obj)) {
      if (typeof obj[prop] === "function") {
        methods.push(prop);
      }
    }
    return methods;
  }
  function createProxyObject$1(methodNames, invoke) {
    const createProxyMethod = (method) => {
      return function() {
        const args = Array.prototype.slice.call(arguments, 0);
        return invoke(method, args);
      };
    };
    const result = {};
    for (const methodName of methodNames) {
      result[methodName] = createProxyMethod(methodName);
    }
    return result;
  }
  (function(thisArg, _arguments, P, generator) {
    function adopt(value) {
      return value instanceof P ? value : new P(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P || (P = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e) {
          reject(e);
        }
      }
      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e) {
          reject(e);
        }
      }
      function step(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  });
  let isPseudo = typeof document !== "undefined" && document.location && document.location.hash.indexOf("pseudo=true") >= 0;
  function _format$2(message, args) {
    let result;
    if (args.length === 0) {
      result = message;
    } else {
      result = message.replace(/\{(\d+)\}/g, (match, rest) => {
        const index2 = rest[0];
        const arg = args[index2];
        let result2 = match;
        if (typeof arg === "string") {
          result2 = arg;
        } else if (typeof arg === "number" || typeof arg === "boolean" || arg === void 0 || arg === null) {
          result2 = String(arg);
        }
        return result2;
      });
    }
    if (isPseudo) {
      result = "［" + result.replace(/[aouei]/g, "$&$&") + "］";
    }
    return result;
  }
  function localize$2(data2, message, ...args) {
    return _format$2(message, args);
  }
  function getConfiguredDefaultLocale(_) {
    return void 0;
  }
  var _a$3;
  const LANGUAGE_DEFAULT = "en";
  let _isWindows = false;
  let _isMacintosh = false;
  let _isLinux = false;
  let _isWeb = false;
  let _locale = void 0;
  let _language = LANGUAGE_DEFAULT;
  let _platformLocale = LANGUAGE_DEFAULT;
  let _translationsConfigFile = void 0;
  let _userAgent = void 0;
  const globals = typeof self === "object" ? self : typeof global === "object" ? global : {};
  let nodeProcess = void 0;
  if (typeof globals.vscode !== "undefined" && typeof globals.vscode.process !== "undefined") {
    nodeProcess = globals.vscode.process;
  } else if (typeof process !== "undefined") {
    nodeProcess = process;
  }
  const isElectronProcess = typeof ((_a$3 = nodeProcess === null || nodeProcess === void 0 ? void 0 : nodeProcess.versions) === null || _a$3 === void 0 ? void 0 : _a$3.electron) === "string";
  const isElectronRenderer = isElectronProcess && (nodeProcess === null || nodeProcess === void 0 ? void 0 : nodeProcess.type) === "renderer";
  if (typeof navigator === "object" && !isElectronRenderer) {
    _userAgent = navigator.userAgent;
    _isWindows = _userAgent.indexOf("Windows") >= 0;
    _isMacintosh = _userAgent.indexOf("Macintosh") >= 0;
    (_userAgent.indexOf("Macintosh") >= 0 || _userAgent.indexOf("iPad") >= 0 || _userAgent.indexOf("iPhone") >= 0) && !!navigator.maxTouchPoints && navigator.maxTouchPoints > 0;
    _isLinux = _userAgent.indexOf("Linux") >= 0;
    (_userAgent === null || _userAgent === void 0 ? void 0 : _userAgent.indexOf("Mobi")) >= 0;
    _isWeb = true;
    getConfiguredDefaultLocale(
      // This call _must_ be done in the file that calls `nls.getConfiguredDefaultLocale`
      // to ensure that the NLS AMD Loader plugin has been loaded and configured.
      // This is because the loader plugin decides what the default locale is based on
      // how it's able to resolve the strings.
      localize$2({ key: "ensureLoaderPluginIsLoaded", comment: ["{Locked}"] }, "_")
    );
    _locale = LANGUAGE_DEFAULT;
    _language = _locale;
    _platformLocale = navigator.language;
  } else if (typeof nodeProcess === "object") {
    _isWindows = nodeProcess.platform === "win32";
    _isMacintosh = nodeProcess.platform === "darwin";
    _isLinux = nodeProcess.platform === "linux";
    _isLinux && !!nodeProcess.env["SNAP"] && !!nodeProcess.env["SNAP_REVISION"];
    !!nodeProcess.env["CI"] || !!nodeProcess.env["BUILD_ARTIFACTSTAGINGDIRECTORY"];
    _locale = LANGUAGE_DEFAULT;
    _language = LANGUAGE_DEFAULT;
    const rawNlsConfig = nodeProcess.env["VSCODE_NLS_CONFIG"];
    if (rawNlsConfig) {
      try {
        const nlsConfig = JSON.parse(rawNlsConfig);
        const resolved = nlsConfig.availableLanguages["*"];
        _locale = nlsConfig.locale;
        _platformLocale = nlsConfig.osLocale;
        _language = resolved ? resolved : LANGUAGE_DEFAULT;
        _translationsConfigFile = nlsConfig._translationsConfigFile;
      } catch (e) {
      }
    }
  } else {
    console.error("Unable to resolve platform.");
  }
  const isWindows = _isWindows;
  const isMacintosh = _isMacintosh;
  _isWeb && typeof globals.importScripts === "function";
  const userAgent = _userAgent;
  const setTimeout0IsFaster = typeof globals.postMessage === "function" && !globals.importScripts;
  (() => {
    if (setTimeout0IsFaster) {
      const pending = [];
      globals.addEventListener("message", (e) => {
        if (e.data && e.data.vscodeScheduleAsyncWork) {
          for (let i = 0, len2 = pending.length; i < len2; i++) {
            const candidate = pending[i];
            if (candidate.id === e.data.vscodeScheduleAsyncWork) {
              pending.splice(i, 1);
              candidate.callback();
              return;
            }
          }
        }
      });
      let lastId = 0;
      return (callback) => {
        const myId = ++lastId;
        pending.push({
          id: myId,
          callback
        });
        globals.postMessage({ vscodeScheduleAsyncWork: myId }, "*");
      };
    }
    return (callback) => setTimeout(callback);
  })();
  const isChrome = !!(userAgent && userAgent.indexOf("Chrome") >= 0);
  !!(userAgent && userAgent.indexOf("Firefox") >= 0);
  !!(!isChrome && (userAgent && userAgent.indexOf("Safari") >= 0));
  !!(userAgent && userAgent.indexOf("Edg/") >= 0);
  !!(userAgent && userAgent.indexOf("Android") >= 0);
  class LRUCachedFunction {
    constructor(fn) {
      this.fn = fn;
      this.lastCache = void 0;
      this.lastArgKey = void 0;
    }
    get(arg) {
      const key = JSON.stringify(arg);
      if (this.lastArgKey !== key) {
        this.lastArgKey = key;
        this.lastCache = this.fn(arg);
      }
      return this.lastCache;
    }
  }
  class Lazy {
    constructor(executor) {
      this.executor = executor;
      this._didRun = false;
    }
    /**
     * Get the wrapped value.
     *
     * This will force evaluation of the lazy value if it has not been resolved yet. Lazy values are only
     * resolved once. `getValue` will re-throw exceptions that are hit while resolving the value
     */
    get value() {
      if (!this._didRun) {
        try {
          this._value = this.executor();
        } catch (err) {
          this._error = err;
        } finally {
          this._didRun = true;
        }
      }
      if (this._error) {
        throw this._error;
      }
      return this._value;
    }
    /**
     * Get the wrapped value without forcing evaluation.
     */
    get rawValue() {
      return this._value;
    }
  }
  var _a$2;
  function escapeRegExpCharacters(value) {
    return value.replace(/[\\\{\}\*\+\?\|\^\$\.\[\]\(\)]/g, "\\$&");
  }
  function splitLines(str2) {
    return str2.split(/\r\n|\r|\n/);
  }
  function firstNonWhitespaceIndex(str2) {
    for (let i = 0, len2 = str2.length; i < len2; i++) {
      const chCode = str2.charCodeAt(i);
      if (chCode !== 32 && chCode !== 9) {
        return i;
      }
    }
    return -1;
  }
  function lastNonWhitespaceIndex(str2, startIndex = str2.length - 1) {
    for (let i = startIndex; i >= 0; i--) {
      const chCode = str2.charCodeAt(i);
      if (chCode !== 32 && chCode !== 9) {
        return i;
      }
    }
    return -1;
  }
  function isUpperAsciiLetter(code) {
    return code >= 65 && code <= 90;
  }
  function isHighSurrogate(charCode) {
    return 55296 <= charCode && charCode <= 56319;
  }
  function isLowSurrogate(charCode) {
    return 56320 <= charCode && charCode <= 57343;
  }
  function computeCodePoint(highSurrogate, lowSurrogate) {
    return (highSurrogate - 55296 << 10) + (lowSurrogate - 56320) + 65536;
  }
  function getNextCodePoint(str2, len2, offset) {
    const charCode = str2.charCodeAt(offset);
    if (isHighSurrogate(charCode) && offset + 1 < len2) {
      const nextCharCode = str2.charCodeAt(offset + 1);
      if (isLowSurrogate(nextCharCode)) {
        return computeCodePoint(charCode, nextCharCode);
      }
    }
    return charCode;
  }
  const IS_BASIC_ASCII = /^[\t\n\r\x20-\x7E]*$/;
  function isBasicASCII(str2) {
    return IS_BASIC_ASCII.test(str2);
  }
  class AmbiguousCharacters {
    static getInstance(locales) {
      return AmbiguousCharacters.cache.get(Array.from(locales));
    }
    static getLocales() {
      return AmbiguousCharacters._locales.value;
    }
    constructor(confusableDictionary) {
      this.confusableDictionary = confusableDictionary;
    }
    isAmbiguous(codePoint) {
      return this.confusableDictionary.has(codePoint);
    }
    /**
     * Returns the non basic ASCII code point that the given code point can be confused,
     * or undefined if such code point does note exist.
     */
    getPrimaryConfusable(codePoint) {
      return this.confusableDictionary.get(codePoint);
    }
    getConfusableCodePoints() {
      return new Set(this.confusableDictionary.keys());
    }
  }
  _a$2 = AmbiguousCharacters;
  AmbiguousCharacters.ambiguousCharacterData = new Lazy(() => {
    return JSON.parse('{"_common":[8232,32,8233,32,5760,32,8192,32,8193,32,8194,32,8195,32,8196,32,8197,32,8198,32,8200,32,8201,32,8202,32,8287,32,8199,32,8239,32,2042,95,65101,95,65102,95,65103,95,8208,45,8209,45,8210,45,65112,45,1748,45,8259,45,727,45,8722,45,10134,45,11450,45,1549,44,1643,44,8218,44,184,44,42233,44,894,59,2307,58,2691,58,1417,58,1795,58,1796,58,5868,58,65072,58,6147,58,6153,58,8282,58,1475,58,760,58,42889,58,8758,58,720,58,42237,58,451,33,11601,33,660,63,577,63,2429,63,5038,63,42731,63,119149,46,8228,46,1793,46,1794,46,42510,46,68176,46,1632,46,1776,46,42232,46,1373,96,65287,96,8219,96,8242,96,1370,96,1523,96,8175,96,65344,96,900,96,8189,96,8125,96,8127,96,8190,96,697,96,884,96,712,96,714,96,715,96,756,96,699,96,701,96,700,96,702,96,42892,96,1497,96,2036,96,2037,96,5194,96,5836,96,94033,96,94034,96,65339,91,10088,40,10098,40,12308,40,64830,40,65341,93,10089,41,10099,41,12309,41,64831,41,10100,123,119060,123,10101,125,65342,94,8270,42,1645,42,8727,42,66335,42,5941,47,8257,47,8725,47,8260,47,9585,47,10187,47,10744,47,119354,47,12755,47,12339,47,11462,47,20031,47,12035,47,65340,92,65128,92,8726,92,10189,92,10741,92,10745,92,119311,92,119355,92,12756,92,20022,92,12034,92,42872,38,708,94,710,94,5869,43,10133,43,66203,43,8249,60,10094,60,706,60,119350,60,5176,60,5810,60,5120,61,11840,61,12448,61,42239,61,8250,62,10095,62,707,62,119351,62,5171,62,94015,62,8275,126,732,126,8128,126,8764,126,65372,124,65293,45,120784,50,120794,50,120804,50,120814,50,120824,50,130034,50,42842,50,423,50,1000,50,42564,50,5311,50,42735,50,119302,51,120785,51,120795,51,120805,51,120815,51,120825,51,130035,51,42923,51,540,51,439,51,42858,51,11468,51,1248,51,94011,51,71882,51,120786,52,120796,52,120806,52,120816,52,120826,52,130036,52,5070,52,71855,52,120787,53,120797,53,120807,53,120817,53,120827,53,130037,53,444,53,71867,53,120788,54,120798,54,120808,54,120818,54,120828,54,130038,54,11474,54,5102,54,71893,54,119314,55,120789,55,120799,55,120809,55,120819,55,120829,55,130039,55,66770,55,71878,55,2819,56,2538,56,2666,56,125131,56,120790,56,120800,56,120810,56,120820,56,120830,56,130040,56,547,56,546,56,66330,56,2663,57,2920,57,2541,57,3437,57,120791,57,120801,57,120811,57,120821,57,120831,57,130041,57,42862,57,11466,57,71884,57,71852,57,71894,57,9082,97,65345,97,119834,97,119886,97,119938,97,119990,97,120042,97,120094,97,120146,97,120198,97,120250,97,120302,97,120354,97,120406,97,120458,97,593,97,945,97,120514,97,120572,97,120630,97,120688,97,120746,97,65313,65,119808,65,119860,65,119912,65,119964,65,120016,65,120068,65,120120,65,120172,65,120224,65,120276,65,120328,65,120380,65,120432,65,913,65,120488,65,120546,65,120604,65,120662,65,120720,65,5034,65,5573,65,42222,65,94016,65,66208,65,119835,98,119887,98,119939,98,119991,98,120043,98,120095,98,120147,98,120199,98,120251,98,120303,98,120355,98,120407,98,120459,98,388,98,5071,98,5234,98,5551,98,65314,66,8492,66,119809,66,119861,66,119913,66,120017,66,120069,66,120121,66,120173,66,120225,66,120277,66,120329,66,120381,66,120433,66,42932,66,914,66,120489,66,120547,66,120605,66,120663,66,120721,66,5108,66,5623,66,42192,66,66178,66,66209,66,66305,66,65347,99,8573,99,119836,99,119888,99,119940,99,119992,99,120044,99,120096,99,120148,99,120200,99,120252,99,120304,99,120356,99,120408,99,120460,99,7428,99,1010,99,11429,99,43951,99,66621,99,128844,67,71922,67,71913,67,65315,67,8557,67,8450,67,8493,67,119810,67,119862,67,119914,67,119966,67,120018,67,120174,67,120226,67,120278,67,120330,67,120382,67,120434,67,1017,67,11428,67,5087,67,42202,67,66210,67,66306,67,66581,67,66844,67,8574,100,8518,100,119837,100,119889,100,119941,100,119993,100,120045,100,120097,100,120149,100,120201,100,120253,100,120305,100,120357,100,120409,100,120461,100,1281,100,5095,100,5231,100,42194,100,8558,68,8517,68,119811,68,119863,68,119915,68,119967,68,120019,68,120071,68,120123,68,120175,68,120227,68,120279,68,120331,68,120383,68,120435,68,5024,68,5598,68,5610,68,42195,68,8494,101,65349,101,8495,101,8519,101,119838,101,119890,101,119942,101,120046,101,120098,101,120150,101,120202,101,120254,101,120306,101,120358,101,120410,101,120462,101,43826,101,1213,101,8959,69,65317,69,8496,69,119812,69,119864,69,119916,69,120020,69,120072,69,120124,69,120176,69,120228,69,120280,69,120332,69,120384,69,120436,69,917,69,120492,69,120550,69,120608,69,120666,69,120724,69,11577,69,5036,69,42224,69,71846,69,71854,69,66182,69,119839,102,119891,102,119943,102,119995,102,120047,102,120099,102,120151,102,120203,102,120255,102,120307,102,120359,102,120411,102,120463,102,43829,102,42905,102,383,102,7837,102,1412,102,119315,70,8497,70,119813,70,119865,70,119917,70,120021,70,120073,70,120125,70,120177,70,120229,70,120281,70,120333,70,120385,70,120437,70,42904,70,988,70,120778,70,5556,70,42205,70,71874,70,71842,70,66183,70,66213,70,66853,70,65351,103,8458,103,119840,103,119892,103,119944,103,120048,103,120100,103,120152,103,120204,103,120256,103,120308,103,120360,103,120412,103,120464,103,609,103,7555,103,397,103,1409,103,119814,71,119866,71,119918,71,119970,71,120022,71,120074,71,120126,71,120178,71,120230,71,120282,71,120334,71,120386,71,120438,71,1292,71,5056,71,5107,71,42198,71,65352,104,8462,104,119841,104,119945,104,119997,104,120049,104,120101,104,120153,104,120205,104,120257,104,120309,104,120361,104,120413,104,120465,104,1211,104,1392,104,5058,104,65320,72,8459,72,8460,72,8461,72,119815,72,119867,72,119919,72,120023,72,120179,72,120231,72,120283,72,120335,72,120387,72,120439,72,919,72,120494,72,120552,72,120610,72,120668,72,120726,72,11406,72,5051,72,5500,72,42215,72,66255,72,731,105,9075,105,65353,105,8560,105,8505,105,8520,105,119842,105,119894,105,119946,105,119998,105,120050,105,120102,105,120154,105,120206,105,120258,105,120310,105,120362,105,120414,105,120466,105,120484,105,618,105,617,105,953,105,8126,105,890,105,120522,105,120580,105,120638,105,120696,105,120754,105,1110,105,42567,105,1231,105,43893,105,5029,105,71875,105,65354,106,8521,106,119843,106,119895,106,119947,106,119999,106,120051,106,120103,106,120155,106,120207,106,120259,106,120311,106,120363,106,120415,106,120467,106,1011,106,1112,106,65322,74,119817,74,119869,74,119921,74,119973,74,120025,74,120077,74,120129,74,120181,74,120233,74,120285,74,120337,74,120389,74,120441,74,42930,74,895,74,1032,74,5035,74,5261,74,42201,74,119844,107,119896,107,119948,107,120000,107,120052,107,120104,107,120156,107,120208,107,120260,107,120312,107,120364,107,120416,107,120468,107,8490,75,65323,75,119818,75,119870,75,119922,75,119974,75,120026,75,120078,75,120130,75,120182,75,120234,75,120286,75,120338,75,120390,75,120442,75,922,75,120497,75,120555,75,120613,75,120671,75,120729,75,11412,75,5094,75,5845,75,42199,75,66840,75,1472,108,8739,73,9213,73,65512,73,1633,108,1777,73,66336,108,125127,108,120783,73,120793,73,120803,73,120813,73,120823,73,130033,73,65321,73,8544,73,8464,73,8465,73,119816,73,119868,73,119920,73,120024,73,120128,73,120180,73,120232,73,120284,73,120336,73,120388,73,120440,73,65356,108,8572,73,8467,108,119845,108,119897,108,119949,108,120001,108,120053,108,120105,73,120157,73,120209,73,120261,73,120313,73,120365,73,120417,73,120469,73,448,73,120496,73,120554,73,120612,73,120670,73,120728,73,11410,73,1030,73,1216,73,1493,108,1503,108,1575,108,126464,108,126592,108,65166,108,65165,108,1994,108,11599,73,5825,73,42226,73,93992,73,66186,124,66313,124,119338,76,8556,76,8466,76,119819,76,119871,76,119923,76,120027,76,120079,76,120131,76,120183,76,120235,76,120287,76,120339,76,120391,76,120443,76,11472,76,5086,76,5290,76,42209,76,93974,76,71843,76,71858,76,66587,76,66854,76,65325,77,8559,77,8499,77,119820,77,119872,77,119924,77,120028,77,120080,77,120132,77,120184,77,120236,77,120288,77,120340,77,120392,77,120444,77,924,77,120499,77,120557,77,120615,77,120673,77,120731,77,1018,77,11416,77,5047,77,5616,77,5846,77,42207,77,66224,77,66321,77,119847,110,119899,110,119951,110,120003,110,120055,110,120107,110,120159,110,120211,110,120263,110,120315,110,120367,110,120419,110,120471,110,1400,110,1404,110,65326,78,8469,78,119821,78,119873,78,119925,78,119977,78,120029,78,120081,78,120185,78,120237,78,120289,78,120341,78,120393,78,120445,78,925,78,120500,78,120558,78,120616,78,120674,78,120732,78,11418,78,42208,78,66835,78,3074,111,3202,111,3330,111,3458,111,2406,111,2662,111,2790,111,3046,111,3174,111,3302,111,3430,111,3664,111,3792,111,4160,111,1637,111,1781,111,65359,111,8500,111,119848,111,119900,111,119952,111,120056,111,120108,111,120160,111,120212,111,120264,111,120316,111,120368,111,120420,111,120472,111,7439,111,7441,111,43837,111,959,111,120528,111,120586,111,120644,111,120702,111,120760,111,963,111,120532,111,120590,111,120648,111,120706,111,120764,111,11423,111,4351,111,1413,111,1505,111,1607,111,126500,111,126564,111,126596,111,65259,111,65260,111,65258,111,65257,111,1726,111,64428,111,64429,111,64427,111,64426,111,1729,111,64424,111,64425,111,64423,111,64422,111,1749,111,3360,111,4125,111,66794,111,71880,111,71895,111,66604,111,1984,79,2534,79,2918,79,12295,79,70864,79,71904,79,120782,79,120792,79,120802,79,120812,79,120822,79,130032,79,65327,79,119822,79,119874,79,119926,79,119978,79,120030,79,120082,79,120134,79,120186,79,120238,79,120290,79,120342,79,120394,79,120446,79,927,79,120502,79,120560,79,120618,79,120676,79,120734,79,11422,79,1365,79,11604,79,4816,79,2848,79,66754,79,42227,79,71861,79,66194,79,66219,79,66564,79,66838,79,9076,112,65360,112,119849,112,119901,112,119953,112,120005,112,120057,112,120109,112,120161,112,120213,112,120265,112,120317,112,120369,112,120421,112,120473,112,961,112,120530,112,120544,112,120588,112,120602,112,120646,112,120660,112,120704,112,120718,112,120762,112,120776,112,11427,112,65328,80,8473,80,119823,80,119875,80,119927,80,119979,80,120031,80,120083,80,120187,80,120239,80,120291,80,120343,80,120395,80,120447,80,929,80,120504,80,120562,80,120620,80,120678,80,120736,80,11426,80,5090,80,5229,80,42193,80,66197,80,119850,113,119902,113,119954,113,120006,113,120058,113,120110,113,120162,113,120214,113,120266,113,120318,113,120370,113,120422,113,120474,113,1307,113,1379,113,1382,113,8474,81,119824,81,119876,81,119928,81,119980,81,120032,81,120084,81,120188,81,120240,81,120292,81,120344,81,120396,81,120448,81,11605,81,119851,114,119903,114,119955,114,120007,114,120059,114,120111,114,120163,114,120215,114,120267,114,120319,114,120371,114,120423,114,120475,114,43847,114,43848,114,7462,114,11397,114,43905,114,119318,82,8475,82,8476,82,8477,82,119825,82,119877,82,119929,82,120033,82,120189,82,120241,82,120293,82,120345,82,120397,82,120449,82,422,82,5025,82,5074,82,66740,82,5511,82,42211,82,94005,82,65363,115,119852,115,119904,115,119956,115,120008,115,120060,115,120112,115,120164,115,120216,115,120268,115,120320,115,120372,115,120424,115,120476,115,42801,115,445,115,1109,115,43946,115,71873,115,66632,115,65331,83,119826,83,119878,83,119930,83,119982,83,120034,83,120086,83,120138,83,120190,83,120242,83,120294,83,120346,83,120398,83,120450,83,1029,83,1359,83,5077,83,5082,83,42210,83,94010,83,66198,83,66592,83,119853,116,119905,116,119957,116,120009,116,120061,116,120113,116,120165,116,120217,116,120269,116,120321,116,120373,116,120425,116,120477,116,8868,84,10201,84,128872,84,65332,84,119827,84,119879,84,119931,84,119983,84,120035,84,120087,84,120139,84,120191,84,120243,84,120295,84,120347,84,120399,84,120451,84,932,84,120507,84,120565,84,120623,84,120681,84,120739,84,11430,84,5026,84,42196,84,93962,84,71868,84,66199,84,66225,84,66325,84,119854,117,119906,117,119958,117,120010,117,120062,117,120114,117,120166,117,120218,117,120270,117,120322,117,120374,117,120426,117,120478,117,42911,117,7452,117,43854,117,43858,117,651,117,965,117,120534,117,120592,117,120650,117,120708,117,120766,117,1405,117,66806,117,71896,117,8746,85,8899,85,119828,85,119880,85,119932,85,119984,85,120036,85,120088,85,120140,85,120192,85,120244,85,120296,85,120348,85,120400,85,120452,85,1357,85,4608,85,66766,85,5196,85,42228,85,94018,85,71864,85,8744,118,8897,118,65366,118,8564,118,119855,118,119907,118,119959,118,120011,118,120063,118,120115,118,120167,118,120219,118,120271,118,120323,118,120375,118,120427,118,120479,118,7456,118,957,118,120526,118,120584,118,120642,118,120700,118,120758,118,1141,118,1496,118,71430,118,43945,118,71872,118,119309,86,1639,86,1783,86,8548,86,119829,86,119881,86,119933,86,119985,86,120037,86,120089,86,120141,86,120193,86,120245,86,120297,86,120349,86,120401,86,120453,86,1140,86,11576,86,5081,86,5167,86,42719,86,42214,86,93960,86,71840,86,66845,86,623,119,119856,119,119908,119,119960,119,120012,119,120064,119,120116,119,120168,119,120220,119,120272,119,120324,119,120376,119,120428,119,120480,119,7457,119,1121,119,1309,119,1377,119,71434,119,71438,119,71439,119,43907,119,71919,87,71910,87,119830,87,119882,87,119934,87,119986,87,120038,87,120090,87,120142,87,120194,87,120246,87,120298,87,120350,87,120402,87,120454,87,1308,87,5043,87,5076,87,42218,87,5742,120,10539,120,10540,120,10799,120,65368,120,8569,120,119857,120,119909,120,119961,120,120013,120,120065,120,120117,120,120169,120,120221,120,120273,120,120325,120,120377,120,120429,120,120481,120,5441,120,5501,120,5741,88,9587,88,66338,88,71916,88,65336,88,8553,88,119831,88,119883,88,119935,88,119987,88,120039,88,120091,88,120143,88,120195,88,120247,88,120299,88,120351,88,120403,88,120455,88,42931,88,935,88,120510,88,120568,88,120626,88,120684,88,120742,88,11436,88,11613,88,5815,88,42219,88,66192,88,66228,88,66327,88,66855,88,611,121,7564,121,65369,121,119858,121,119910,121,119962,121,120014,121,120066,121,120118,121,120170,121,120222,121,120274,121,120326,121,120378,121,120430,121,120482,121,655,121,7935,121,43866,121,947,121,8509,121,120516,121,120574,121,120632,121,120690,121,120748,121,1199,121,4327,121,71900,121,65337,89,119832,89,119884,89,119936,89,119988,89,120040,89,120092,89,120144,89,120196,89,120248,89,120300,89,120352,89,120404,89,120456,89,933,89,978,89,120508,89,120566,89,120624,89,120682,89,120740,89,11432,89,1198,89,5033,89,5053,89,42220,89,94019,89,71844,89,66226,89,119859,122,119911,122,119963,122,120015,122,120067,122,120119,122,120171,122,120223,122,120275,122,120327,122,120379,122,120431,122,120483,122,7458,122,43923,122,71876,122,66293,90,71909,90,65338,90,8484,90,8488,90,119833,90,119885,90,119937,90,119989,90,120041,90,120197,90,120249,90,120301,90,120353,90,120405,90,120457,90,918,90,120493,90,120551,90,120609,90,120667,90,120725,90,5059,90,42204,90,71849,90,65282,34,65284,36,65285,37,65286,38,65290,42,65291,43,65294,46,65295,47,65296,48,65297,49,65298,50,65299,51,65300,52,65301,53,65302,54,65303,55,65304,56,65305,57,65308,60,65309,61,65310,62,65312,64,65316,68,65318,70,65319,71,65324,76,65329,81,65330,82,65333,85,65334,86,65335,87,65343,95,65346,98,65348,100,65350,102,65355,107,65357,109,65358,110,65361,113,65362,114,65364,116,65365,117,65367,119,65370,122,65371,123,65373,125,119846,109],"_default":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"cs":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"de":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"es":[8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"fr":[65374,126,65306,58,65281,33,8216,96,8245,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"it":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"ja":[8211,45,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65292,44,65307,59],"ko":[8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"pl":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"pt-BR":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"qps-ploc":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"ru":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,305,105,921,73,1009,112,215,120,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"tr":[160,32,8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"zh-hans":[65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41],"zh-hant":[8211,45,65374,126,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65307,59]}');
  });
  AmbiguousCharacters.cache = new LRUCachedFunction((locales) => {
    function arrayToMap(arr) {
      const result = /* @__PURE__ */ new Map();
      for (let i = 0; i < arr.length; i += 2) {
        result.set(arr[i], arr[i + 1]);
      }
      return result;
    }
    function mergeMaps(map1, map22) {
      const result = new Map(map1);
      for (const [key, value] of map22) {
        result.set(key, value);
      }
      return result;
    }
    function intersectMaps(map1, map22) {
      if (!map1) {
        return map22;
      }
      const result = /* @__PURE__ */ new Map();
      for (const [key, value] of map1) {
        if (map22.has(key)) {
          result.set(key, value);
        }
      }
      return result;
    }
    const data2 = _a$2.ambiguousCharacterData.value;
    let filteredLocales = locales.filter((l) => !l.startsWith("_") && l in data2);
    if (filteredLocales.length === 0) {
      filteredLocales = ["_default"];
    }
    let languageSpecificMap = void 0;
    for (const locale2 of filteredLocales) {
      const map3 = arrayToMap(data2[locale2]);
      languageSpecificMap = intersectMaps(languageSpecificMap, map3);
    }
    const commonMap = arrayToMap(data2["_common"]);
    const map2 = mergeMaps(commonMap, languageSpecificMap);
    return new AmbiguousCharacters(map2);
  });
  AmbiguousCharacters._locales = new Lazy(() => Object.keys(AmbiguousCharacters.ambiguousCharacterData.value).filter((k) => !k.startsWith("_")));
  class InvisibleCharacters {
    static getRawData() {
      return JSON.parse("[9,10,11,12,13,32,127,160,173,847,1564,4447,4448,6068,6069,6155,6156,6157,6158,7355,7356,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8203,8204,8205,8206,8207,8234,8235,8236,8237,8238,8239,8287,8288,8289,8290,8291,8292,8293,8294,8295,8296,8297,8298,8299,8300,8301,8302,8303,10240,12288,12644,65024,65025,65026,65027,65028,65029,65030,65031,65032,65033,65034,65035,65036,65037,65038,65039,65279,65440,65520,65521,65522,65523,65524,65525,65526,65527,65528,65532,78844,119155,119156,119157,119158,119159,119160,119161,119162,917504,917505,917506,917507,917508,917509,917510,917511,917512,917513,917514,917515,917516,917517,917518,917519,917520,917521,917522,917523,917524,917525,917526,917527,917528,917529,917530,917531,917532,917533,917534,917535,917536,917537,917538,917539,917540,917541,917542,917543,917544,917545,917546,917547,917548,917549,917550,917551,917552,917553,917554,917555,917556,917557,917558,917559,917560,917561,917562,917563,917564,917565,917566,917567,917568,917569,917570,917571,917572,917573,917574,917575,917576,917577,917578,917579,917580,917581,917582,917583,917584,917585,917586,917587,917588,917589,917590,917591,917592,917593,917594,917595,917596,917597,917598,917599,917600,917601,917602,917603,917604,917605,917606,917607,917608,917609,917610,917611,917612,917613,917614,917615,917616,917617,917618,917619,917620,917621,917622,917623,917624,917625,917626,917627,917628,917629,917630,917631,917760,917761,917762,917763,917764,917765,917766,917767,917768,917769,917770,917771,917772,917773,917774,917775,917776,917777,917778,917779,917780,917781,917782,917783,917784,917785,917786,917787,917788,917789,917790,917791,917792,917793,917794,917795,917796,917797,917798,917799,917800,917801,917802,917803,917804,917805,917806,917807,917808,917809,917810,917811,917812,917813,917814,917815,917816,917817,917818,917819,917820,917821,917822,917823,917824,917825,917826,917827,917828,917829,917830,917831,917832,917833,917834,917835,917836,917837,917838,917839,917840,917841,917842,917843,917844,917845,917846,917847,917848,917849,917850,917851,917852,917853,917854,917855,917856,917857,917858,917859,917860,917861,917862,917863,917864,917865,917866,917867,917868,917869,917870,917871,917872,917873,917874,917875,917876,917877,917878,917879,917880,917881,917882,917883,917884,917885,917886,917887,917888,917889,917890,917891,917892,917893,917894,917895,917896,917897,917898,917899,917900,917901,917902,917903,917904,917905,917906,917907,917908,917909,917910,917911,917912,917913,917914,917915,917916,917917,917918,917919,917920,917921,917922,917923,917924,917925,917926,917927,917928,917929,917930,917931,917932,917933,917934,917935,917936,917937,917938,917939,917940,917941,917942,917943,917944,917945,917946,917947,917948,917949,917950,917951,917952,917953,917954,917955,917956,917957,917958,917959,917960,917961,917962,917963,917964,917965,917966,917967,917968,917969,917970,917971,917972,917973,917974,917975,917976,917977,917978,917979,917980,917981,917982,917983,917984,917985,917986,917987,917988,917989,917990,917991,917992,917993,917994,917995,917996,917997,917998,917999]");
    }
    static getData() {
      if (!this._data) {
        this._data = new Set(InvisibleCharacters.getRawData());
      }
      return this._data;
    }
    static isInvisibleCharacter(codePoint) {
      return InvisibleCharacters.getData().has(codePoint);
    }
    static get codePoints() {
      return InvisibleCharacters.getData();
    }
  }
  InvisibleCharacters._data = void 0;
  const INITIALIZE = "$initialize";
  class RequestMessage {
    constructor(vsWorker, req, method, args) {
      this.vsWorker = vsWorker;
      this.req = req;
      this.method = method;
      this.args = args;
      this.type = 0;
    }
  }
  class ReplyMessage {
    constructor(vsWorker, seq, res, err) {
      this.vsWorker = vsWorker;
      this.seq = seq;
      this.res = res;
      this.err = err;
      this.type = 1;
    }
  }
  class SubscribeEventMessage {
    constructor(vsWorker, req, eventName, arg) {
      this.vsWorker = vsWorker;
      this.req = req;
      this.eventName = eventName;
      this.arg = arg;
      this.type = 2;
    }
  }
  class EventMessage {
    constructor(vsWorker, req, event) {
      this.vsWorker = vsWorker;
      this.req = req;
      this.event = event;
      this.type = 3;
    }
  }
  class UnsubscribeEventMessage {
    constructor(vsWorker, req) {
      this.vsWorker = vsWorker;
      this.req = req;
      this.type = 4;
    }
  }
  class SimpleWorkerProtocol {
    constructor(handler) {
      this._workerId = -1;
      this._handler = handler;
      this._lastSentReq = 0;
      this._pendingReplies = /* @__PURE__ */ Object.create(null);
      this._pendingEmitters = /* @__PURE__ */ new Map();
      this._pendingEvents = /* @__PURE__ */ new Map();
    }
    setWorkerId(workerId) {
      this._workerId = workerId;
    }
    sendMessage(method, args) {
      const req = String(++this._lastSentReq);
      return new Promise((resolve2, reject) => {
        this._pendingReplies[req] = {
          resolve: resolve2,
          reject
        };
        this._send(new RequestMessage(this._workerId, req, method, args));
      });
    }
    listen(eventName, arg) {
      let req = null;
      const emitter = new Emitter({
        onWillAddFirstListener: () => {
          req = String(++this._lastSentReq);
          this._pendingEmitters.set(req, emitter);
          this._send(new SubscribeEventMessage(this._workerId, req, eventName, arg));
        },
        onDidRemoveLastListener: () => {
          this._pendingEmitters.delete(req);
          this._send(new UnsubscribeEventMessage(this._workerId, req));
          req = null;
        }
      });
      return emitter.event;
    }
    handleMessage(message) {
      if (!message || !message.vsWorker) {
        return;
      }
      if (this._workerId !== -1 && message.vsWorker !== this._workerId) {
        return;
      }
      this._handleMessage(message);
    }
    _handleMessage(msg) {
      switch (msg.type) {
        case 1:
          return this._handleReplyMessage(msg);
        case 0:
          return this._handleRequestMessage(msg);
        case 2:
          return this._handleSubscribeEventMessage(msg);
        case 3:
          return this._handleEventMessage(msg);
        case 4:
          return this._handleUnsubscribeEventMessage(msg);
      }
    }
    _handleReplyMessage(replyMessage) {
      if (!this._pendingReplies[replyMessage.seq]) {
        console.warn("Got reply to unknown seq");
        return;
      }
      const reply = this._pendingReplies[replyMessage.seq];
      delete this._pendingReplies[replyMessage.seq];
      if (replyMessage.err) {
        let err = replyMessage.err;
        if (replyMessage.err.$isError) {
          err = new Error();
          err.name = replyMessage.err.name;
          err.message = replyMessage.err.message;
          err.stack = replyMessage.err.stack;
        }
        reply.reject(err);
        return;
      }
      reply.resolve(replyMessage.res);
    }
    _handleRequestMessage(requestMessage) {
      const req = requestMessage.req;
      const result = this._handler.handleMessage(requestMessage.method, requestMessage.args);
      result.then((r) => {
        this._send(new ReplyMessage(this._workerId, req, r, void 0));
      }, (e) => {
        if (e.detail instanceof Error) {
          e.detail = transformErrorForSerialization(e.detail);
        }
        this._send(new ReplyMessage(this._workerId, req, void 0, transformErrorForSerialization(e)));
      });
    }
    _handleSubscribeEventMessage(msg) {
      const req = msg.req;
      const disposable = this._handler.handleEvent(msg.eventName, msg.arg)((event) => {
        this._send(new EventMessage(this._workerId, req, event));
      });
      this._pendingEvents.set(req, disposable);
    }
    _handleEventMessage(msg) {
      if (!this._pendingEmitters.has(msg.req)) {
        console.warn("Got event for unknown req");
        return;
      }
      this._pendingEmitters.get(msg.req).fire(msg.event);
    }
    _handleUnsubscribeEventMessage(msg) {
      if (!this._pendingEvents.has(msg.req)) {
        console.warn("Got unsubscribe for unknown req");
        return;
      }
      this._pendingEvents.get(msg.req).dispose();
      this._pendingEvents.delete(msg.req);
    }
    _send(msg) {
      const transfer = [];
      if (msg.type === 0) {
        for (let i = 0; i < msg.args.length; i++) {
          if (msg.args[i] instanceof ArrayBuffer) {
            transfer.push(msg.args[i]);
          }
        }
      } else if (msg.type === 1) {
        if (msg.res instanceof ArrayBuffer) {
          transfer.push(msg.res);
        }
      }
      this._handler.sendMessage(msg, transfer);
    }
  }
  function propertyIsEvent(name) {
    return name[0] === "o" && name[1] === "n" && isUpperAsciiLetter(name.charCodeAt(2));
  }
  function propertyIsDynamicEvent(name) {
    return /^onDynamic/.test(name) && isUpperAsciiLetter(name.charCodeAt(9));
  }
  function createProxyObject(methodNames, invoke, proxyListen) {
    const createProxyMethod = (method) => {
      return function() {
        const args = Array.prototype.slice.call(arguments, 0);
        return invoke(method, args);
      };
    };
    const createProxyDynamicEvent = (eventName) => {
      return function(arg) {
        return proxyListen(eventName, arg);
      };
    };
    const result = {};
    for (const methodName of methodNames) {
      if (propertyIsDynamicEvent(methodName)) {
        result[methodName] = createProxyDynamicEvent(methodName);
        continue;
      }
      if (propertyIsEvent(methodName)) {
        result[methodName] = proxyListen(methodName, void 0);
        continue;
      }
      result[methodName] = createProxyMethod(methodName);
    }
    return result;
  }
  class SimpleWorkerServer {
    constructor(postMessage, requestHandlerFactory) {
      this._requestHandlerFactory = requestHandlerFactory;
      this._requestHandler = null;
      this._protocol = new SimpleWorkerProtocol({
        sendMessage: (msg, transfer) => {
          postMessage(msg, transfer);
        },
        handleMessage: (method, args) => this._handleMessage(method, args),
        handleEvent: (eventName, arg) => this._handleEvent(eventName, arg)
      });
    }
    onmessage(msg) {
      this._protocol.handleMessage(msg);
    }
    _handleMessage(method, args) {
      if (method === INITIALIZE) {
        return this.initialize(args[0], args[1], args[2], args[3]);
      }
      if (!this._requestHandler || typeof this._requestHandler[method] !== "function") {
        return Promise.reject(new Error("Missing requestHandler or method: " + method));
      }
      try {
        return Promise.resolve(this._requestHandler[method].apply(this._requestHandler, args));
      } catch (e) {
        return Promise.reject(e);
      }
    }
    _handleEvent(eventName, arg) {
      if (!this._requestHandler) {
        throw new Error(`Missing requestHandler`);
      }
      if (propertyIsDynamicEvent(eventName)) {
        const event = this._requestHandler[eventName].call(this._requestHandler, arg);
        if (typeof event !== "function") {
          throw new Error(`Missing dynamic event ${eventName} on request handler.`);
        }
        return event;
      }
      if (propertyIsEvent(eventName)) {
        const event = this._requestHandler[eventName];
        if (typeof event !== "function") {
          throw new Error(`Missing event ${eventName} on request handler.`);
        }
        return event;
      }
      throw new Error(`Malformed event name ${eventName}`);
    }
    initialize(workerId, loaderConfig, moduleId, hostMethods) {
      this._protocol.setWorkerId(workerId);
      const proxyMethodRequest = (method, args) => {
        return this._protocol.sendMessage(method, args);
      };
      const proxyListen = (eventName, arg) => {
        return this._protocol.listen(eventName, arg);
      };
      const hostProxy = createProxyObject(hostMethods, proxyMethodRequest, proxyListen);
      if (this._requestHandlerFactory) {
        this._requestHandler = this._requestHandlerFactory(hostProxy);
        return Promise.resolve(getAllMethodNames(this._requestHandler));
      }
      if (loaderConfig) {
        if (typeof loaderConfig.baseUrl !== "undefined") {
          delete loaderConfig["baseUrl"];
        }
        if (typeof loaderConfig.paths !== "undefined") {
          if (typeof loaderConfig.paths.vs !== "undefined") {
            delete loaderConfig.paths["vs"];
          }
        }
        if (typeof loaderConfig.trustedTypesPolicy !== void 0) {
          delete loaderConfig["trustedTypesPolicy"];
        }
        loaderConfig.catchError = true;
        globalThis.require.config(loaderConfig);
      }
      return new Promise((resolve2, reject) => {
        const req = globalThis.require;
        req([moduleId], (module) => {
          this._requestHandler = module.create(hostProxy);
          if (!this._requestHandler) {
            reject(new Error(`No RequestHandler!`));
            return;
          }
          resolve2(getAllMethodNames(this._requestHandler));
        }, reject);
      });
    }
  }
  class DiffChange {
    /**
     * Constructs a new DiffChange with the given sequence information
     * and content.
     */
    constructor(originalStart, originalLength, modifiedStart, modifiedLength) {
      this.originalStart = originalStart;
      this.originalLength = originalLength;
      this.modifiedStart = modifiedStart;
      this.modifiedLength = modifiedLength;
    }
    /**
     * The end point (exclusive) of the change in the original sequence.
     */
    getOriginalEnd() {
      return this.originalStart + this.originalLength;
    }
    /**
     * The end point (exclusive) of the change in the modified sequence.
     */
    getModifiedEnd() {
      return this.modifiedStart + this.modifiedLength;
    }
  }
  function numberHash(val, initialHashVal) {
    return (initialHashVal << 5) - initialHashVal + val | 0;
  }
  function stringHash(s, hashVal) {
    hashVal = numberHash(149417, hashVal);
    for (let i = 0, length = s.length; i < length; i++) {
      hashVal = numberHash(s.charCodeAt(i), hashVal);
    }
    return hashVal;
  }
  class StringDiffSequence {
    constructor(source) {
      this.source = source;
    }
    getElements() {
      const source = this.source;
      const characters = new Int32Array(source.length);
      for (let i = 0, len2 = source.length; i < len2; i++) {
        characters[i] = source.charCodeAt(i);
      }
      return characters;
    }
  }
  function stringDiff(original, modified, pretty) {
    return new LcsDiff(new StringDiffSequence(original), new StringDiffSequence(modified)).ComputeDiff(pretty).changes;
  }
  class Debug {
    static Assert(condition, message) {
      if (!condition) {
        throw new Error(message);
      }
    }
  }
  class MyArray {
    /**
     * Copies a range of elements from an Array starting at the specified source index and pastes
     * them to another Array starting at the specified destination index. The length and the indexes
     * are specified as 64-bit integers.
     * sourceArray:
     *		The Array that contains the data to copy.
     * sourceIndex:
     *		A 64-bit integer that represents the index in the sourceArray at which copying begins.
     * destinationArray:
     *		The Array that receives the data.
     * destinationIndex:
     *		A 64-bit integer that represents the index in the destinationArray at which storing begins.
     * length:
     *		A 64-bit integer that represents the number of elements to copy.
     */
    static Copy(sourceArray, sourceIndex, destinationArray, destinationIndex, length) {
      for (let i = 0; i < length; i++) {
        destinationArray[destinationIndex + i] = sourceArray[sourceIndex + i];
      }
    }
    static Copy2(sourceArray, sourceIndex, destinationArray, destinationIndex, length) {
      for (let i = 0; i < length; i++) {
        destinationArray[destinationIndex + i] = sourceArray[sourceIndex + i];
      }
    }
  }
  class DiffChangeHelper {
    /**
     * Constructs a new DiffChangeHelper for the given DiffSequences.
     */
    constructor() {
      this.m_changes = [];
      this.m_originalStart = 1073741824;
      this.m_modifiedStart = 1073741824;
      this.m_originalCount = 0;
      this.m_modifiedCount = 0;
    }
    /**
     * Marks the beginning of the next change in the set of differences.
     */
    MarkNextChange() {
      if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
        this.m_changes.push(new DiffChange(this.m_originalStart, this.m_originalCount, this.m_modifiedStart, this.m_modifiedCount));
      }
      this.m_originalCount = 0;
      this.m_modifiedCount = 0;
      this.m_originalStart = 1073741824;
      this.m_modifiedStart = 1073741824;
    }
    /**
     * Adds the original element at the given position to the elements
     * affected by the current change. The modified index gives context
     * to the change position with respect to the original sequence.
     * @param originalIndex The index of the original element to add.
     * @param modifiedIndex The index of the modified element that provides corresponding position in the modified sequence.
     */
    AddOriginalElement(originalIndex, modifiedIndex) {
      this.m_originalStart = Math.min(this.m_originalStart, originalIndex);
      this.m_modifiedStart = Math.min(this.m_modifiedStart, modifiedIndex);
      this.m_originalCount++;
    }
    /**
     * Adds the modified element at the given position to the elements
     * affected by the current change. The original index gives context
     * to the change position with respect to the modified sequence.
     * @param originalIndex The index of the original element that provides corresponding position in the original sequence.
     * @param modifiedIndex The index of the modified element to add.
     */
    AddModifiedElement(originalIndex, modifiedIndex) {
      this.m_originalStart = Math.min(this.m_originalStart, originalIndex);
      this.m_modifiedStart = Math.min(this.m_modifiedStart, modifiedIndex);
      this.m_modifiedCount++;
    }
    /**
     * Retrieves all of the changes marked by the class.
     */
    getChanges() {
      if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
        this.MarkNextChange();
      }
      return this.m_changes;
    }
    /**
     * Retrieves all of the changes marked by the class in the reverse order
     */
    getReverseChanges() {
      if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
        this.MarkNextChange();
      }
      this.m_changes.reverse();
      return this.m_changes;
    }
  }
  class LcsDiff {
    /**
     * Constructs the DiffFinder
     */
    constructor(originalSequence, modifiedSequence, continueProcessingPredicate = null) {
      this.ContinueProcessingPredicate = continueProcessingPredicate;
      this._originalSequence = originalSequence;
      this._modifiedSequence = modifiedSequence;
      const [originalStringElements, originalElementsOrHash, originalHasStrings] = LcsDiff._getElements(originalSequence);
      const [modifiedStringElements, modifiedElementsOrHash, modifiedHasStrings] = LcsDiff._getElements(modifiedSequence);
      this._hasStrings = originalHasStrings && modifiedHasStrings;
      this._originalStringElements = originalStringElements;
      this._originalElementsOrHash = originalElementsOrHash;
      this._modifiedStringElements = modifiedStringElements;
      this._modifiedElementsOrHash = modifiedElementsOrHash;
      this.m_forwardHistory = [];
      this.m_reverseHistory = [];
    }
    static _isStringArray(arr) {
      return arr.length > 0 && typeof arr[0] === "string";
    }
    static _getElements(sequence) {
      const elements = sequence.getElements();
      if (LcsDiff._isStringArray(elements)) {
        const hashes = new Int32Array(elements.length);
        for (let i = 0, len2 = elements.length; i < len2; i++) {
          hashes[i] = stringHash(elements[i], 0);
        }
        return [elements, hashes, true];
      }
      if (elements instanceof Int32Array) {
        return [[], elements, false];
      }
      return [[], new Int32Array(elements), false];
    }
    ElementsAreEqual(originalIndex, newIndex) {
      if (this._originalElementsOrHash[originalIndex] !== this._modifiedElementsOrHash[newIndex]) {
        return false;
      }
      return this._hasStrings ? this._originalStringElements[originalIndex] === this._modifiedStringElements[newIndex] : true;
    }
    ElementsAreStrictEqual(originalIndex, newIndex) {
      if (!this.ElementsAreEqual(originalIndex, newIndex)) {
        return false;
      }
      const originalElement = LcsDiff._getStrictElement(this._originalSequence, originalIndex);
      const modifiedElement = LcsDiff._getStrictElement(this._modifiedSequence, newIndex);
      return originalElement === modifiedElement;
    }
    static _getStrictElement(sequence, index2) {
      if (typeof sequence.getStrictElement === "function") {
        return sequence.getStrictElement(index2);
      }
      return null;
    }
    OriginalElementsAreEqual(index1, index2) {
      if (this._originalElementsOrHash[index1] !== this._originalElementsOrHash[index2]) {
        return false;
      }
      return this._hasStrings ? this._originalStringElements[index1] === this._originalStringElements[index2] : true;
    }
    ModifiedElementsAreEqual(index1, index2) {
      if (this._modifiedElementsOrHash[index1] !== this._modifiedElementsOrHash[index2]) {
        return false;
      }
      return this._hasStrings ? this._modifiedStringElements[index1] === this._modifiedStringElements[index2] : true;
    }
    ComputeDiff(pretty) {
      return this._ComputeDiff(0, this._originalElementsOrHash.length - 1, 0, this._modifiedElementsOrHash.length - 1, pretty);
    }
    /**
     * Computes the differences between the original and modified input
     * sequences on the bounded range.
     * @returns An array of the differences between the two input sequences.
     */
    _ComputeDiff(originalStart, originalEnd, modifiedStart, modifiedEnd, pretty) {
      const quitEarlyArr = [false];
      let changes = this.ComputeDiffRecursive(originalStart, originalEnd, modifiedStart, modifiedEnd, quitEarlyArr);
      if (pretty) {
        changes = this.PrettifyChanges(changes);
      }
      return {
        quitEarly: quitEarlyArr[0],
        changes
      };
    }
    /**
     * Private helper method which computes the differences on the bounded range
     * recursively.
     * @returns An array of the differences between the two input sequences.
     */
    ComputeDiffRecursive(originalStart, originalEnd, modifiedStart, modifiedEnd, quitEarlyArr) {
      quitEarlyArr[0] = false;
      while (originalStart <= originalEnd && modifiedStart <= modifiedEnd && this.ElementsAreEqual(originalStart, modifiedStart)) {
        originalStart++;
        modifiedStart++;
      }
      while (originalEnd >= originalStart && modifiedEnd >= modifiedStart && this.ElementsAreEqual(originalEnd, modifiedEnd)) {
        originalEnd--;
        modifiedEnd--;
      }
      if (originalStart > originalEnd || modifiedStart > modifiedEnd) {
        let changes;
        if (modifiedStart <= modifiedEnd) {
          Debug.Assert(originalStart === originalEnd + 1, "originalStart should only be one more than originalEnd");
          changes = [
            new DiffChange(originalStart, 0, modifiedStart, modifiedEnd - modifiedStart + 1)
          ];
        } else if (originalStart <= originalEnd) {
          Debug.Assert(modifiedStart === modifiedEnd + 1, "modifiedStart should only be one more than modifiedEnd");
          changes = [
            new DiffChange(originalStart, originalEnd - originalStart + 1, modifiedStart, 0)
          ];
        } else {
          Debug.Assert(originalStart === originalEnd + 1, "originalStart should only be one more than originalEnd");
          Debug.Assert(modifiedStart === modifiedEnd + 1, "modifiedStart should only be one more than modifiedEnd");
          changes = [];
        }
        return changes;
      }
      const midOriginalArr = [0];
      const midModifiedArr = [0];
      const result = this.ComputeRecursionPoint(originalStart, originalEnd, modifiedStart, modifiedEnd, midOriginalArr, midModifiedArr, quitEarlyArr);
      const midOriginal = midOriginalArr[0];
      const midModified = midModifiedArr[0];
      if (result !== null) {
        return result;
      } else if (!quitEarlyArr[0]) {
        const leftChanges = this.ComputeDiffRecursive(originalStart, midOriginal, modifiedStart, midModified, quitEarlyArr);
        let rightChanges = [];
        if (!quitEarlyArr[0]) {
          rightChanges = this.ComputeDiffRecursive(midOriginal + 1, originalEnd, midModified + 1, modifiedEnd, quitEarlyArr);
        } else {
          rightChanges = [
            new DiffChange(midOriginal + 1, originalEnd - (midOriginal + 1) + 1, midModified + 1, modifiedEnd - (midModified + 1) + 1)
          ];
        }
        return this.ConcatenateChanges(leftChanges, rightChanges);
      }
      return [
        new DiffChange(originalStart, originalEnd - originalStart + 1, modifiedStart, modifiedEnd - modifiedStart + 1)
      ];
    }
    WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr) {
      let forwardChanges = null;
      let reverseChanges = null;
      let changeHelper = new DiffChangeHelper();
      let diagonalMin = diagonalForwardStart;
      let diagonalMax = diagonalForwardEnd;
      let diagonalRelative = midOriginalArr[0] - midModifiedArr[0] - diagonalForwardOffset;
      let lastOriginalIndex = -1073741824;
      let historyIndex = this.m_forwardHistory.length - 1;
      do {
        const diagonal = diagonalRelative + diagonalForwardBase;
        if (diagonal === diagonalMin || diagonal < diagonalMax && forwardPoints[diagonal - 1] < forwardPoints[diagonal + 1]) {
          originalIndex = forwardPoints[diagonal + 1];
          modifiedIndex = originalIndex - diagonalRelative - diagonalForwardOffset;
          if (originalIndex < lastOriginalIndex) {
            changeHelper.MarkNextChange();
          }
          lastOriginalIndex = originalIndex;
          changeHelper.AddModifiedElement(originalIndex + 1, modifiedIndex);
          diagonalRelative = diagonal + 1 - diagonalForwardBase;
        } else {
          originalIndex = forwardPoints[diagonal - 1] + 1;
          modifiedIndex = originalIndex - diagonalRelative - diagonalForwardOffset;
          if (originalIndex < lastOriginalIndex) {
            changeHelper.MarkNextChange();
          }
          lastOriginalIndex = originalIndex - 1;
          changeHelper.AddOriginalElement(originalIndex, modifiedIndex + 1);
          diagonalRelative = diagonal - 1 - diagonalForwardBase;
        }
        if (historyIndex >= 0) {
          forwardPoints = this.m_forwardHistory[historyIndex];
          diagonalForwardBase = forwardPoints[0];
          diagonalMin = 1;
          diagonalMax = forwardPoints.length - 1;
        }
      } while (--historyIndex >= -1);
      forwardChanges = changeHelper.getReverseChanges();
      if (quitEarlyArr[0]) {
        let originalStartPoint = midOriginalArr[0] + 1;
        let modifiedStartPoint = midModifiedArr[0] + 1;
        if (forwardChanges !== null && forwardChanges.length > 0) {
          const lastForwardChange = forwardChanges[forwardChanges.length - 1];
          originalStartPoint = Math.max(originalStartPoint, lastForwardChange.getOriginalEnd());
          modifiedStartPoint = Math.max(modifiedStartPoint, lastForwardChange.getModifiedEnd());
        }
        reverseChanges = [
          new DiffChange(originalStartPoint, originalEnd - originalStartPoint + 1, modifiedStartPoint, modifiedEnd - modifiedStartPoint + 1)
        ];
      } else {
        changeHelper = new DiffChangeHelper();
        diagonalMin = diagonalReverseStart;
        diagonalMax = diagonalReverseEnd;
        diagonalRelative = midOriginalArr[0] - midModifiedArr[0] - diagonalReverseOffset;
        lastOriginalIndex = 1073741824;
        historyIndex = deltaIsEven ? this.m_reverseHistory.length - 1 : this.m_reverseHistory.length - 2;
        do {
          const diagonal = diagonalRelative + diagonalReverseBase;
          if (diagonal === diagonalMin || diagonal < diagonalMax && reversePoints[diagonal - 1] >= reversePoints[diagonal + 1]) {
            originalIndex = reversePoints[diagonal + 1] - 1;
            modifiedIndex = originalIndex - diagonalRelative - diagonalReverseOffset;
            if (originalIndex > lastOriginalIndex) {
              changeHelper.MarkNextChange();
            }
            lastOriginalIndex = originalIndex + 1;
            changeHelper.AddOriginalElement(originalIndex + 1, modifiedIndex + 1);
            diagonalRelative = diagonal + 1 - diagonalReverseBase;
          } else {
            originalIndex = reversePoints[diagonal - 1];
            modifiedIndex = originalIndex - diagonalRelative - diagonalReverseOffset;
            if (originalIndex > lastOriginalIndex) {
              changeHelper.MarkNextChange();
            }
            lastOriginalIndex = originalIndex;
            changeHelper.AddModifiedElement(originalIndex + 1, modifiedIndex + 1);
            diagonalRelative = diagonal - 1 - diagonalReverseBase;
          }
          if (historyIndex >= 0) {
            reversePoints = this.m_reverseHistory[historyIndex];
            diagonalReverseBase = reversePoints[0];
            diagonalMin = 1;
            diagonalMax = reversePoints.length - 1;
          }
        } while (--historyIndex >= -1);
        reverseChanges = changeHelper.getChanges();
      }
      return this.ConcatenateChanges(forwardChanges, reverseChanges);
    }
    /**
     * Given the range to compute the diff on, this method finds the point:
     * (midOriginal, midModified)
     * that exists in the middle of the LCS of the two sequences and
     * is the point at which the LCS problem may be broken down recursively.
     * This method will try to keep the LCS trace in memory. If the LCS recursion
     * point is calculated and the full trace is available in memory, then this method
     * will return the change list.
     * @param originalStart The start bound of the original sequence range
     * @param originalEnd The end bound of the original sequence range
     * @param modifiedStart The start bound of the modified sequence range
     * @param modifiedEnd The end bound of the modified sequence range
     * @param midOriginal The middle point of the original sequence range
     * @param midModified The middle point of the modified sequence range
     * @returns The diff changes, if available, otherwise null
     */
    ComputeRecursionPoint(originalStart, originalEnd, modifiedStart, modifiedEnd, midOriginalArr, midModifiedArr, quitEarlyArr) {
      let originalIndex = 0, modifiedIndex = 0;
      let diagonalForwardStart = 0, diagonalForwardEnd = 0;
      let diagonalReverseStart = 0, diagonalReverseEnd = 0;
      originalStart--;
      modifiedStart--;
      midOriginalArr[0] = 0;
      midModifiedArr[0] = 0;
      this.m_forwardHistory = [];
      this.m_reverseHistory = [];
      const maxDifferences = originalEnd - originalStart + (modifiedEnd - modifiedStart);
      const numDiagonals = maxDifferences + 1;
      const forwardPoints = new Int32Array(numDiagonals);
      const reversePoints = new Int32Array(numDiagonals);
      const diagonalForwardBase = modifiedEnd - modifiedStart;
      const diagonalReverseBase = originalEnd - originalStart;
      const diagonalForwardOffset = originalStart - modifiedStart;
      const diagonalReverseOffset = originalEnd - modifiedEnd;
      const delta = diagonalReverseBase - diagonalForwardBase;
      const deltaIsEven = delta % 2 === 0;
      forwardPoints[diagonalForwardBase] = originalStart;
      reversePoints[diagonalReverseBase] = originalEnd;
      quitEarlyArr[0] = false;
      for (let numDifferences = 1; numDifferences <= maxDifferences / 2 + 1; numDifferences++) {
        let furthestOriginalIndex = 0;
        let furthestModifiedIndex = 0;
        diagonalForwardStart = this.ClipDiagonalBound(diagonalForwardBase - numDifferences, numDifferences, diagonalForwardBase, numDiagonals);
        diagonalForwardEnd = this.ClipDiagonalBound(diagonalForwardBase + numDifferences, numDifferences, diagonalForwardBase, numDiagonals);
        for (let diagonal = diagonalForwardStart; diagonal <= diagonalForwardEnd; diagonal += 2) {
          if (diagonal === diagonalForwardStart || diagonal < diagonalForwardEnd && forwardPoints[diagonal - 1] < forwardPoints[diagonal + 1]) {
            originalIndex = forwardPoints[diagonal + 1];
          } else {
            originalIndex = forwardPoints[diagonal - 1] + 1;
          }
          modifiedIndex = originalIndex - (diagonal - diagonalForwardBase) - diagonalForwardOffset;
          const tempOriginalIndex = originalIndex;
          while (originalIndex < originalEnd && modifiedIndex < modifiedEnd && this.ElementsAreEqual(originalIndex + 1, modifiedIndex + 1)) {
            originalIndex++;
            modifiedIndex++;
          }
          forwardPoints[diagonal] = originalIndex;
          if (originalIndex + modifiedIndex > furthestOriginalIndex + furthestModifiedIndex) {
            furthestOriginalIndex = originalIndex;
            furthestModifiedIndex = modifiedIndex;
          }
          if (!deltaIsEven && Math.abs(diagonal - diagonalReverseBase) <= numDifferences - 1) {
            if (originalIndex >= reversePoints[diagonal]) {
              midOriginalArr[0] = originalIndex;
              midModifiedArr[0] = modifiedIndex;
              if (tempOriginalIndex <= reversePoints[diagonal] && 1447 > 0 && numDifferences <= 1447 + 1) {
                return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
              } else {
                return null;
              }
            }
          }
        }
        const matchLengthOfLongest = (furthestOriginalIndex - originalStart + (furthestModifiedIndex - modifiedStart) - numDifferences) / 2;
        if (this.ContinueProcessingPredicate !== null && !this.ContinueProcessingPredicate(furthestOriginalIndex, matchLengthOfLongest)) {
          quitEarlyArr[0] = true;
          midOriginalArr[0] = furthestOriginalIndex;
          midModifiedArr[0] = furthestModifiedIndex;
          if (matchLengthOfLongest > 0 && 1447 > 0 && numDifferences <= 1447 + 1) {
            return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
          } else {
            originalStart++;
            modifiedStart++;
            return [
              new DiffChange(originalStart, originalEnd - originalStart + 1, modifiedStart, modifiedEnd - modifiedStart + 1)
            ];
          }
        }
        diagonalReverseStart = this.ClipDiagonalBound(diagonalReverseBase - numDifferences, numDifferences, diagonalReverseBase, numDiagonals);
        diagonalReverseEnd = this.ClipDiagonalBound(diagonalReverseBase + numDifferences, numDifferences, diagonalReverseBase, numDiagonals);
        for (let diagonal = diagonalReverseStart; diagonal <= diagonalReverseEnd; diagonal += 2) {
          if (diagonal === diagonalReverseStart || diagonal < diagonalReverseEnd && reversePoints[diagonal - 1] >= reversePoints[diagonal + 1]) {
            originalIndex = reversePoints[diagonal + 1] - 1;
          } else {
            originalIndex = reversePoints[diagonal - 1];
          }
          modifiedIndex = originalIndex - (diagonal - diagonalReverseBase) - diagonalReverseOffset;
          const tempOriginalIndex = originalIndex;
          while (originalIndex > originalStart && modifiedIndex > modifiedStart && this.ElementsAreEqual(originalIndex, modifiedIndex)) {
            originalIndex--;
            modifiedIndex--;
          }
          reversePoints[diagonal] = originalIndex;
          if (deltaIsEven && Math.abs(diagonal - diagonalForwardBase) <= numDifferences) {
            if (originalIndex <= forwardPoints[diagonal]) {
              midOriginalArr[0] = originalIndex;
              midModifiedArr[0] = modifiedIndex;
              if (tempOriginalIndex >= forwardPoints[diagonal] && 1447 > 0 && numDifferences <= 1447 + 1) {
                return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
              } else {
                return null;
              }
            }
          }
        }
        if (numDifferences <= 1447) {
          let temp = new Int32Array(diagonalForwardEnd - diagonalForwardStart + 2);
          temp[0] = diagonalForwardBase - diagonalForwardStart + 1;
          MyArray.Copy2(forwardPoints, diagonalForwardStart, temp, 1, diagonalForwardEnd - diagonalForwardStart + 1);
          this.m_forwardHistory.push(temp);
          temp = new Int32Array(diagonalReverseEnd - diagonalReverseStart + 2);
          temp[0] = diagonalReverseBase - diagonalReverseStart + 1;
          MyArray.Copy2(reversePoints, diagonalReverseStart, temp, 1, diagonalReverseEnd - diagonalReverseStart + 1);
          this.m_reverseHistory.push(temp);
        }
      }
      return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
    }
    /**
     * Shifts the given changes to provide a more intuitive diff.
     * While the first element in a diff matches the first element after the diff,
     * we shift the diff down.
     *
     * @param changes The list of changes to shift
     * @returns The shifted changes
     */
    PrettifyChanges(changes) {
      for (let i = 0; i < changes.length; i++) {
        const change = changes[i];
        const originalStop = i < changes.length - 1 ? changes[i + 1].originalStart : this._originalElementsOrHash.length;
        const modifiedStop = i < changes.length - 1 ? changes[i + 1].modifiedStart : this._modifiedElementsOrHash.length;
        const checkOriginal = change.originalLength > 0;
        const checkModified = change.modifiedLength > 0;
        while (change.originalStart + change.originalLength < originalStop && change.modifiedStart + change.modifiedLength < modifiedStop && (!checkOriginal || this.OriginalElementsAreEqual(change.originalStart, change.originalStart + change.originalLength)) && (!checkModified || this.ModifiedElementsAreEqual(change.modifiedStart, change.modifiedStart + change.modifiedLength))) {
          const startStrictEqual = this.ElementsAreStrictEqual(change.originalStart, change.modifiedStart);
          const endStrictEqual = this.ElementsAreStrictEqual(change.originalStart + change.originalLength, change.modifiedStart + change.modifiedLength);
          if (endStrictEqual && !startStrictEqual) {
            break;
          }
          change.originalStart++;
          change.modifiedStart++;
        }
        const mergedChangeArr = [null];
        if (i < changes.length - 1 && this.ChangesOverlap(changes[i], changes[i + 1], mergedChangeArr)) {
          changes[i] = mergedChangeArr[0];
          changes.splice(i + 1, 1);
          i--;
          continue;
        }
      }
      for (let i = changes.length - 1; i >= 0; i--) {
        const change = changes[i];
        let originalStop = 0;
        let modifiedStop = 0;
        if (i > 0) {
          const prevChange = changes[i - 1];
          originalStop = prevChange.originalStart + prevChange.originalLength;
          modifiedStop = prevChange.modifiedStart + prevChange.modifiedLength;
        }
        const checkOriginal = change.originalLength > 0;
        const checkModified = change.modifiedLength > 0;
        let bestDelta = 0;
        let bestScore = this._boundaryScore(change.originalStart, change.originalLength, change.modifiedStart, change.modifiedLength);
        for (let delta = 1; ; delta++) {
          const originalStart = change.originalStart - delta;
          const modifiedStart = change.modifiedStart - delta;
          if (originalStart < originalStop || modifiedStart < modifiedStop) {
            break;
          }
          if (checkOriginal && !this.OriginalElementsAreEqual(originalStart, originalStart + change.originalLength)) {
            break;
          }
          if (checkModified && !this.ModifiedElementsAreEqual(modifiedStart, modifiedStart + change.modifiedLength)) {
            break;
          }
          const touchingPreviousChange = originalStart === originalStop && modifiedStart === modifiedStop;
          const score2 = (touchingPreviousChange ? 5 : 0) + this._boundaryScore(originalStart, change.originalLength, modifiedStart, change.modifiedLength);
          if (score2 > bestScore) {
            bestScore = score2;
            bestDelta = delta;
          }
        }
        change.originalStart -= bestDelta;
        change.modifiedStart -= bestDelta;
        const mergedChangeArr = [null];
        if (i > 0 && this.ChangesOverlap(changes[i - 1], changes[i], mergedChangeArr)) {
          changes[i - 1] = mergedChangeArr[0];
          changes.splice(i, 1);
          i++;
          continue;
        }
      }
      if (this._hasStrings) {
        for (let i = 1, len2 = changes.length; i < len2; i++) {
          const aChange = changes[i - 1];
          const bChange = changes[i];
          const matchedLength = bChange.originalStart - aChange.originalStart - aChange.originalLength;
          const aOriginalStart = aChange.originalStart;
          const bOriginalEnd = bChange.originalStart + bChange.originalLength;
          const abOriginalLength = bOriginalEnd - aOriginalStart;
          const aModifiedStart = aChange.modifiedStart;
          const bModifiedEnd = bChange.modifiedStart + bChange.modifiedLength;
          const abModifiedLength = bModifiedEnd - aModifiedStart;
          if (matchedLength < 5 && abOriginalLength < 20 && abModifiedLength < 20) {
            const t2 = this._findBetterContiguousSequence(aOriginalStart, abOriginalLength, aModifiedStart, abModifiedLength, matchedLength);
            if (t2) {
              const [originalMatchStart, modifiedMatchStart] = t2;
              if (originalMatchStart !== aChange.originalStart + aChange.originalLength || modifiedMatchStart !== aChange.modifiedStart + aChange.modifiedLength) {
                aChange.originalLength = originalMatchStart - aChange.originalStart;
                aChange.modifiedLength = modifiedMatchStart - aChange.modifiedStart;
                bChange.originalStart = originalMatchStart + matchedLength;
                bChange.modifiedStart = modifiedMatchStart + matchedLength;
                bChange.originalLength = bOriginalEnd - bChange.originalStart;
                bChange.modifiedLength = bModifiedEnd - bChange.modifiedStart;
              }
            }
          }
        }
      }
      return changes;
    }
    _findBetterContiguousSequence(originalStart, originalLength, modifiedStart, modifiedLength, desiredLength) {
      if (originalLength < desiredLength || modifiedLength < desiredLength) {
        return null;
      }
      const originalMax = originalStart + originalLength - desiredLength + 1;
      const modifiedMax = modifiedStart + modifiedLength - desiredLength + 1;
      let bestScore = 0;
      let bestOriginalStart = 0;
      let bestModifiedStart = 0;
      for (let i = originalStart; i < originalMax; i++) {
        for (let j = modifiedStart; j < modifiedMax; j++) {
          const score2 = this._contiguousSequenceScore(i, j, desiredLength);
          if (score2 > 0 && score2 > bestScore) {
            bestScore = score2;
            bestOriginalStart = i;
            bestModifiedStart = j;
          }
        }
      }
      if (bestScore > 0) {
        return [bestOriginalStart, bestModifiedStart];
      }
      return null;
    }
    _contiguousSequenceScore(originalStart, modifiedStart, length) {
      let score2 = 0;
      for (let l = 0; l < length; l++) {
        if (!this.ElementsAreEqual(originalStart + l, modifiedStart + l)) {
          return 0;
        }
        score2 += this._originalStringElements[originalStart + l].length;
      }
      return score2;
    }
    _OriginalIsBoundary(index2) {
      if (index2 <= 0 || index2 >= this._originalElementsOrHash.length - 1) {
        return true;
      }
      return this._hasStrings && /^\s*$/.test(this._originalStringElements[index2]);
    }
    _OriginalRegionIsBoundary(originalStart, originalLength) {
      if (this._OriginalIsBoundary(originalStart) || this._OriginalIsBoundary(originalStart - 1)) {
        return true;
      }
      if (originalLength > 0) {
        const originalEnd = originalStart + originalLength;
        if (this._OriginalIsBoundary(originalEnd - 1) || this._OriginalIsBoundary(originalEnd)) {
          return true;
        }
      }
      return false;
    }
    _ModifiedIsBoundary(index2) {
      if (index2 <= 0 || index2 >= this._modifiedElementsOrHash.length - 1) {
        return true;
      }
      return this._hasStrings && /^\s*$/.test(this._modifiedStringElements[index2]);
    }
    _ModifiedRegionIsBoundary(modifiedStart, modifiedLength) {
      if (this._ModifiedIsBoundary(modifiedStart) || this._ModifiedIsBoundary(modifiedStart - 1)) {
        return true;
      }
      if (modifiedLength > 0) {
        const modifiedEnd = modifiedStart + modifiedLength;
        if (this._ModifiedIsBoundary(modifiedEnd - 1) || this._ModifiedIsBoundary(modifiedEnd)) {
          return true;
        }
      }
      return false;
    }
    _boundaryScore(originalStart, originalLength, modifiedStart, modifiedLength) {
      const originalScore = this._OriginalRegionIsBoundary(originalStart, originalLength) ? 1 : 0;
      const modifiedScore = this._ModifiedRegionIsBoundary(modifiedStart, modifiedLength) ? 1 : 0;
      return originalScore + modifiedScore;
    }
    /**
     * Concatenates the two input DiffChange lists and returns the resulting
     * list.
     * @param The left changes
     * @param The right changes
     * @returns The concatenated list
     */
    ConcatenateChanges(left, right) {
      const mergedChangeArr = [];
      if (left.length === 0 || right.length === 0) {
        return right.length > 0 ? right : left;
      } else if (this.ChangesOverlap(left[left.length - 1], right[0], mergedChangeArr)) {
        const result = new Array(left.length + right.length - 1);
        MyArray.Copy(left, 0, result, 0, left.length - 1);
        result[left.length - 1] = mergedChangeArr[0];
        MyArray.Copy(right, 1, result, left.length, right.length - 1);
        return result;
      } else {
        const result = new Array(left.length + right.length);
        MyArray.Copy(left, 0, result, 0, left.length);
        MyArray.Copy(right, 0, result, left.length, right.length);
        return result;
      }
    }
    /**
     * Returns true if the two changes overlap and can be merged into a single
     * change
     * @param left The left change
     * @param right The right change
     * @param mergedChange The merged change if the two overlap, null otherwise
     * @returns True if the two changes overlap
     */
    ChangesOverlap(left, right, mergedChangeArr) {
      Debug.Assert(left.originalStart <= right.originalStart, "Left change is not less than or equal to right change");
      Debug.Assert(left.modifiedStart <= right.modifiedStart, "Left change is not less than or equal to right change");
      if (left.originalStart + left.originalLength >= right.originalStart || left.modifiedStart + left.modifiedLength >= right.modifiedStart) {
        const originalStart = left.originalStart;
        let originalLength = left.originalLength;
        const modifiedStart = left.modifiedStart;
        let modifiedLength = left.modifiedLength;
        if (left.originalStart + left.originalLength >= right.originalStart) {
          originalLength = right.originalStart + right.originalLength - left.originalStart;
        }
        if (left.modifiedStart + left.modifiedLength >= right.modifiedStart) {
          modifiedLength = right.modifiedStart + right.modifiedLength - left.modifiedStart;
        }
        mergedChangeArr[0] = new DiffChange(originalStart, originalLength, modifiedStart, modifiedLength);
        return true;
      } else {
        mergedChangeArr[0] = null;
        return false;
      }
    }
    /**
     * Helper method used to clip a diagonal index to the range of valid
     * diagonals. This also decides whether or not the diagonal index,
     * if it exceeds the boundary, should be clipped to the boundary or clipped
     * one inside the boundary depending on the Even/Odd status of the boundary
     * and numDifferences.
     * @param diagonal The index of the diagonal to clip.
     * @param numDifferences The current number of differences being iterated upon.
     * @param diagonalBaseIndex The base reference diagonal.
     * @param numDiagonals The total number of diagonals.
     * @returns The clipped diagonal index.
     */
    ClipDiagonalBound(diagonal, numDifferences, diagonalBaseIndex, numDiagonals) {
      if (diagonal >= 0 && diagonal < numDiagonals) {
        return diagonal;
      }
      const diagonalsBelow = diagonalBaseIndex;
      const diagonalsAbove = numDiagonals - diagonalBaseIndex - 1;
      const diffEven = numDifferences % 2 === 0;
      if (diagonal < 0) {
        const lowerBoundEven = diagonalsBelow % 2 === 0;
        return diffEven === lowerBoundEven ? 0 : 1;
      } else {
        const upperBoundEven = diagonalsAbove % 2 === 0;
        return diffEven === upperBoundEven ? numDiagonals - 1 : numDiagonals - 2;
      }
    }
  }
  let safeProcess;
  if (typeof globals.vscode !== "undefined" && typeof globals.vscode.process !== "undefined") {
    const sandboxProcess = globals.vscode.process;
    safeProcess = {
      get platform() {
        return sandboxProcess.platform;
      },
      get arch() {
        return sandboxProcess.arch;
      },
      get env() {
        return sandboxProcess.env;
      },
      cwd() {
        return sandboxProcess.cwd();
      }
    };
  } else if (typeof process !== "undefined") {
    safeProcess = {
      get platform() {
        return process.platform;
      },
      get arch() {
        return process.arch;
      },
      get env() {
        return process.env;
      },
      cwd() {
        return process.env["VSCODE_CWD"] || process.cwd();
      }
    };
  } else {
    safeProcess = {
      // Supported
      get platform() {
        return isWindows ? "win32" : isMacintosh ? "darwin" : "linux";
      },
      get arch() {
        return void 0;
      },
      // Unsupported
      get env() {
        return {};
      },
      cwd() {
        return "/";
      }
    };
  }
  const cwd = safeProcess.cwd;
  const env = safeProcess.env;
  const platform = safeProcess.platform;
  const CHAR_UPPERCASE_A = 65;
  const CHAR_LOWERCASE_A = 97;
  const CHAR_UPPERCASE_Z = 90;
  const CHAR_LOWERCASE_Z = 122;
  const CHAR_DOT = 46;
  const CHAR_FORWARD_SLASH = 47;
  const CHAR_BACKWARD_SLASH = 92;
  const CHAR_COLON = 58;
  const CHAR_QUESTION_MARK = 63;
  class ErrorInvalidArgType extends Error {
    constructor(name, expected, actual) {
      let determiner;
      if (typeof expected === "string" && expected.indexOf("not ") === 0) {
        determiner = "must not be";
        expected = expected.replace(/^not /, "");
      } else {
        determiner = "must be";
      }
      const type = name.indexOf(".") !== -1 ? "property" : "argument";
      let msg = `The "${name}" ${type} ${determiner} of type ${expected}`;
      msg += `. Received type ${typeof actual}`;
      super(msg);
      this.code = "ERR_INVALID_ARG_TYPE";
    }
  }
  function validateObject(pathObject, name) {
    if (pathObject === null || typeof pathObject !== "object") {
      throw new ErrorInvalidArgType(name, "Object", pathObject);
    }
  }
  function validateString(value, name) {
    if (typeof value !== "string") {
      throw new ErrorInvalidArgType(name, "string", value);
    }
  }
  const platformIsWin32 = platform === "win32";
  function isPathSeparator(code) {
    return code === CHAR_FORWARD_SLASH || code === CHAR_BACKWARD_SLASH;
  }
  function isPosixPathSeparator(code) {
    return code === CHAR_FORWARD_SLASH;
  }
  function isWindowsDeviceRoot(code) {
    return code >= CHAR_UPPERCASE_A && code <= CHAR_UPPERCASE_Z || code >= CHAR_LOWERCASE_A && code <= CHAR_LOWERCASE_Z;
  }
  function normalizeString(path2, allowAboveRoot, separator, isPathSeparator2) {
    let res = "";
    let lastSegmentLength = 0;
    let lastSlash = -1;
    let dots = 0;
    let code = 0;
    for (let i = 0; i <= path2.length; ++i) {
      if (i < path2.length) {
        code = path2.charCodeAt(i);
      } else if (isPathSeparator2(code)) {
        break;
      } else {
        code = CHAR_FORWARD_SLASH;
      }
      if (isPathSeparator2(code)) {
        if (lastSlash === i - 1 || dots === 1)
          ;
        else if (dots === 2) {
          if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== CHAR_DOT || res.charCodeAt(res.length - 2) !== CHAR_DOT) {
            if (res.length > 2) {
              const lastSlashIndex = res.lastIndexOf(separator);
              if (lastSlashIndex === -1) {
                res = "";
                lastSegmentLength = 0;
              } else {
                res = res.slice(0, lastSlashIndex);
                lastSegmentLength = res.length - 1 - res.lastIndexOf(separator);
              }
              lastSlash = i;
              dots = 0;
              continue;
            } else if (res.length !== 0) {
              res = "";
              lastSegmentLength = 0;
              lastSlash = i;
              dots = 0;
              continue;
            }
          }
          if (allowAboveRoot) {
            res += res.length > 0 ? `${separator}..` : "..";
            lastSegmentLength = 2;
          }
        } else {
          if (res.length > 0) {
            res += `${separator}${path2.slice(lastSlash + 1, i)}`;
          } else {
            res = path2.slice(lastSlash + 1, i);
          }
          lastSegmentLength = i - lastSlash - 1;
        }
        lastSlash = i;
        dots = 0;
      } else if (code === CHAR_DOT && dots !== -1) {
        ++dots;
      } else {
        dots = -1;
      }
    }
    return res;
  }
  function _format$1(sep, pathObject) {
    validateObject(pathObject, "pathObject");
    const dir = pathObject.dir || pathObject.root;
    const base = pathObject.base || `${pathObject.name || ""}${pathObject.ext || ""}`;
    if (!dir) {
      return base;
    }
    return dir === pathObject.root ? `${dir}${base}` : `${dir}${sep}${base}`;
  }
  const win32 = {
    // path.resolve([from ...], to)
    resolve(...pathSegments) {
      let resolvedDevice = "";
      let resolvedTail = "";
      let resolvedAbsolute = false;
      for (let i = pathSegments.length - 1; i >= -1; i--) {
        let path2;
        if (i >= 0) {
          path2 = pathSegments[i];
          validateString(path2, "path");
          if (path2.length === 0) {
            continue;
          }
        } else if (resolvedDevice.length === 0) {
          path2 = cwd();
        } else {
          path2 = env[`=${resolvedDevice}`] || cwd();
          if (path2 === void 0 || path2.slice(0, 2).toLowerCase() !== resolvedDevice.toLowerCase() && path2.charCodeAt(2) === CHAR_BACKWARD_SLASH) {
            path2 = `${resolvedDevice}\\`;
          }
        }
        const len2 = path2.length;
        let rootEnd = 0;
        let device = "";
        let isAbsolute = false;
        const code = path2.charCodeAt(0);
        if (len2 === 1) {
          if (isPathSeparator(code)) {
            rootEnd = 1;
            isAbsolute = true;
          }
        } else if (isPathSeparator(code)) {
          isAbsolute = true;
          if (isPathSeparator(path2.charCodeAt(1))) {
            let j = 2;
            let last2 = j;
            while (j < len2 && !isPathSeparator(path2.charCodeAt(j))) {
              j++;
            }
            if (j < len2 && j !== last2) {
              const firstPart = path2.slice(last2, j);
              last2 = j;
              while (j < len2 && isPathSeparator(path2.charCodeAt(j))) {
                j++;
              }
              if (j < len2 && j !== last2) {
                last2 = j;
                while (j < len2 && !isPathSeparator(path2.charCodeAt(j))) {
                  j++;
                }
                if (j === len2 || j !== last2) {
                  device = `\\\\${firstPart}\\${path2.slice(last2, j)}`;
                  rootEnd = j;
                }
              }
            }
          } else {
            rootEnd = 1;
          }
        } else if (isWindowsDeviceRoot(code) && path2.charCodeAt(1) === CHAR_COLON) {
          device = path2.slice(0, 2);
          rootEnd = 2;
          if (len2 > 2 && isPathSeparator(path2.charCodeAt(2))) {
            isAbsolute = true;
            rootEnd = 3;
          }
        }
        if (device.length > 0) {
          if (resolvedDevice.length > 0) {
            if (device.toLowerCase() !== resolvedDevice.toLowerCase()) {
              continue;
            }
          } else {
            resolvedDevice = device;
          }
        }
        if (resolvedAbsolute) {
          if (resolvedDevice.length > 0) {
            break;
          }
        } else {
          resolvedTail = `${path2.slice(rootEnd)}\\${resolvedTail}`;
          resolvedAbsolute = isAbsolute;
          if (isAbsolute && resolvedDevice.length > 0) {
            break;
          }
        }
      }
      resolvedTail = normalizeString(resolvedTail, !resolvedAbsolute, "\\", isPathSeparator);
      return resolvedAbsolute ? `${resolvedDevice}\\${resolvedTail}` : `${resolvedDevice}${resolvedTail}` || ".";
    },
    normalize(path2) {
      validateString(path2, "path");
      const len2 = path2.length;
      if (len2 === 0) {
        return ".";
      }
      let rootEnd = 0;
      let device;
      let isAbsolute = false;
      const code = path2.charCodeAt(0);
      if (len2 === 1) {
        return isPosixPathSeparator(code) ? "\\" : path2;
      }
      if (isPathSeparator(code)) {
        isAbsolute = true;
        if (isPathSeparator(path2.charCodeAt(1))) {
          let j = 2;
          let last2 = j;
          while (j < len2 && !isPathSeparator(path2.charCodeAt(j))) {
            j++;
          }
          if (j < len2 && j !== last2) {
            const firstPart = path2.slice(last2, j);
            last2 = j;
            while (j < len2 && isPathSeparator(path2.charCodeAt(j))) {
              j++;
            }
            if (j < len2 && j !== last2) {
              last2 = j;
              while (j < len2 && !isPathSeparator(path2.charCodeAt(j))) {
                j++;
              }
              if (j === len2) {
                return `\\\\${firstPart}\\${path2.slice(last2)}\\`;
              }
              if (j !== last2) {
                device = `\\\\${firstPart}\\${path2.slice(last2, j)}`;
                rootEnd = j;
              }
            }
          }
        } else {
          rootEnd = 1;
        }
      } else if (isWindowsDeviceRoot(code) && path2.charCodeAt(1) === CHAR_COLON) {
        device = path2.slice(0, 2);
        rootEnd = 2;
        if (len2 > 2 && isPathSeparator(path2.charCodeAt(2))) {
          isAbsolute = true;
          rootEnd = 3;
        }
      }
      let tail = rootEnd < len2 ? normalizeString(path2.slice(rootEnd), !isAbsolute, "\\", isPathSeparator) : "";
      if (tail.length === 0 && !isAbsolute) {
        tail = ".";
      }
      if (tail.length > 0 && isPathSeparator(path2.charCodeAt(len2 - 1))) {
        tail += "\\";
      }
      if (device === void 0) {
        return isAbsolute ? `\\${tail}` : tail;
      }
      return isAbsolute ? `${device}\\${tail}` : `${device}${tail}`;
    },
    isAbsolute(path2) {
      validateString(path2, "path");
      const len2 = path2.length;
      if (len2 === 0) {
        return false;
      }
      const code = path2.charCodeAt(0);
      return isPathSeparator(code) || // Possible device root
      len2 > 2 && isWindowsDeviceRoot(code) && path2.charCodeAt(1) === CHAR_COLON && isPathSeparator(path2.charCodeAt(2));
    },
    join(...paths) {
      if (paths.length === 0) {
        return ".";
      }
      let joined;
      let firstPart;
      for (let i = 0; i < paths.length; ++i) {
        const arg = paths[i];
        validateString(arg, "path");
        if (arg.length > 0) {
          if (joined === void 0) {
            joined = firstPart = arg;
          } else {
            joined += `\\${arg}`;
          }
        }
      }
      if (joined === void 0) {
        return ".";
      }
      let needsReplace = true;
      let slashCount = 0;
      if (typeof firstPart === "string" && isPathSeparator(firstPart.charCodeAt(0))) {
        ++slashCount;
        const firstLen = firstPart.length;
        if (firstLen > 1 && isPathSeparator(firstPart.charCodeAt(1))) {
          ++slashCount;
          if (firstLen > 2) {
            if (isPathSeparator(firstPart.charCodeAt(2))) {
              ++slashCount;
            } else {
              needsReplace = false;
            }
          }
        }
      }
      if (needsReplace) {
        while (slashCount < joined.length && isPathSeparator(joined.charCodeAt(slashCount))) {
          slashCount++;
        }
        if (slashCount >= 2) {
          joined = `\\${joined.slice(slashCount)}`;
        }
      }
      return win32.normalize(joined);
    },
    // It will solve the relative path from `from` to `to`, for instance:
    //  from = 'C:\\orandea\\test\\aaa'
    //  to = 'C:\\orandea\\impl\\bbb'
    // The output of the function should be: '..\\..\\impl\\bbb'
    relative(from, to) {
      validateString(from, "from");
      validateString(to, "to");
      if (from === to) {
        return "";
      }
      const fromOrig = win32.resolve(from);
      const toOrig = win32.resolve(to);
      if (fromOrig === toOrig) {
        return "";
      }
      from = fromOrig.toLowerCase();
      to = toOrig.toLowerCase();
      if (from === to) {
        return "";
      }
      let fromStart = 0;
      while (fromStart < from.length && from.charCodeAt(fromStart) === CHAR_BACKWARD_SLASH) {
        fromStart++;
      }
      let fromEnd = from.length;
      while (fromEnd - 1 > fromStart && from.charCodeAt(fromEnd - 1) === CHAR_BACKWARD_SLASH) {
        fromEnd--;
      }
      const fromLen = fromEnd - fromStart;
      let toStart = 0;
      while (toStart < to.length && to.charCodeAt(toStart) === CHAR_BACKWARD_SLASH) {
        toStart++;
      }
      let toEnd = to.length;
      while (toEnd - 1 > toStart && to.charCodeAt(toEnd - 1) === CHAR_BACKWARD_SLASH) {
        toEnd--;
      }
      const toLen = toEnd - toStart;
      const length = fromLen < toLen ? fromLen : toLen;
      let lastCommonSep = -1;
      let i = 0;
      for (; i < length; i++) {
        const fromCode = from.charCodeAt(fromStart + i);
        if (fromCode !== to.charCodeAt(toStart + i)) {
          break;
        } else if (fromCode === CHAR_BACKWARD_SLASH) {
          lastCommonSep = i;
        }
      }
      if (i !== length) {
        if (lastCommonSep === -1) {
          return toOrig;
        }
      } else {
        if (toLen > length) {
          if (to.charCodeAt(toStart + i) === CHAR_BACKWARD_SLASH) {
            return toOrig.slice(toStart + i + 1);
          }
          if (i === 2) {
            return toOrig.slice(toStart + i);
          }
        }
        if (fromLen > length) {
          if (from.charCodeAt(fromStart + i) === CHAR_BACKWARD_SLASH) {
            lastCommonSep = i;
          } else if (i === 2) {
            lastCommonSep = 3;
          }
        }
        if (lastCommonSep === -1) {
          lastCommonSep = 0;
        }
      }
      let out2 = "";
      for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
        if (i === fromEnd || from.charCodeAt(i) === CHAR_BACKWARD_SLASH) {
          out2 += out2.length === 0 ? ".." : "\\..";
        }
      }
      toStart += lastCommonSep;
      if (out2.length > 0) {
        return `${out2}${toOrig.slice(toStart, toEnd)}`;
      }
      if (toOrig.charCodeAt(toStart) === CHAR_BACKWARD_SLASH) {
        ++toStart;
      }
      return toOrig.slice(toStart, toEnd);
    },
    toNamespacedPath(path2) {
      if (typeof path2 !== "string" || path2.length === 0) {
        return path2;
      }
      const resolvedPath = win32.resolve(path2);
      if (resolvedPath.length <= 2) {
        return path2;
      }
      if (resolvedPath.charCodeAt(0) === CHAR_BACKWARD_SLASH) {
        if (resolvedPath.charCodeAt(1) === CHAR_BACKWARD_SLASH) {
          const code = resolvedPath.charCodeAt(2);
          if (code !== CHAR_QUESTION_MARK && code !== CHAR_DOT) {
            return `\\\\?\\UNC\\${resolvedPath.slice(2)}`;
          }
        }
      } else if (isWindowsDeviceRoot(resolvedPath.charCodeAt(0)) && resolvedPath.charCodeAt(1) === CHAR_COLON && resolvedPath.charCodeAt(2) === CHAR_BACKWARD_SLASH) {
        return `\\\\?\\${resolvedPath}`;
      }
      return path2;
    },
    dirname(path2) {
      validateString(path2, "path");
      const len2 = path2.length;
      if (len2 === 0) {
        return ".";
      }
      let rootEnd = -1;
      let offset = 0;
      const code = path2.charCodeAt(0);
      if (len2 === 1) {
        return isPathSeparator(code) ? path2 : ".";
      }
      if (isPathSeparator(code)) {
        rootEnd = offset = 1;
        if (isPathSeparator(path2.charCodeAt(1))) {
          let j = 2;
          let last2 = j;
          while (j < len2 && !isPathSeparator(path2.charCodeAt(j))) {
            j++;
          }
          if (j < len2 && j !== last2) {
            last2 = j;
            while (j < len2 && isPathSeparator(path2.charCodeAt(j))) {
              j++;
            }
            if (j < len2 && j !== last2) {
              last2 = j;
              while (j < len2 && !isPathSeparator(path2.charCodeAt(j))) {
                j++;
              }
              if (j === len2) {
                return path2;
              }
              if (j !== last2) {
                rootEnd = offset = j + 1;
              }
            }
          }
        }
      } else if (isWindowsDeviceRoot(code) && path2.charCodeAt(1) === CHAR_COLON) {
        rootEnd = len2 > 2 && isPathSeparator(path2.charCodeAt(2)) ? 3 : 2;
        offset = rootEnd;
      }
      let end = -1;
      let matchedSlash = true;
      for (let i = len2 - 1; i >= offset; --i) {
        if (isPathSeparator(path2.charCodeAt(i))) {
          if (!matchedSlash) {
            end = i;
            break;
          }
        } else {
          matchedSlash = false;
        }
      }
      if (end === -1) {
        if (rootEnd === -1) {
          return ".";
        }
        end = rootEnd;
      }
      return path2.slice(0, end);
    },
    basename(path2, ext) {
      if (ext !== void 0) {
        validateString(ext, "ext");
      }
      validateString(path2, "path");
      let start = 0;
      let end = -1;
      let matchedSlash = true;
      let i;
      if (path2.length >= 2 && isWindowsDeviceRoot(path2.charCodeAt(0)) && path2.charCodeAt(1) === CHAR_COLON) {
        start = 2;
      }
      if (ext !== void 0 && ext.length > 0 && ext.length <= path2.length) {
        if (ext === path2) {
          return "";
        }
        let extIdx = ext.length - 1;
        let firstNonSlashEnd = -1;
        for (i = path2.length - 1; i >= start; --i) {
          const code = path2.charCodeAt(i);
          if (isPathSeparator(code)) {
            if (!matchedSlash) {
              start = i + 1;
              break;
            }
          } else {
            if (firstNonSlashEnd === -1) {
              matchedSlash = false;
              firstNonSlashEnd = i + 1;
            }
            if (extIdx >= 0) {
              if (code === ext.charCodeAt(extIdx)) {
                if (--extIdx === -1) {
                  end = i;
                }
              } else {
                extIdx = -1;
                end = firstNonSlashEnd;
              }
            }
          }
        }
        if (start === end) {
          end = firstNonSlashEnd;
        } else if (end === -1) {
          end = path2.length;
        }
        return path2.slice(start, end);
      }
      for (i = path2.length - 1; i >= start; --i) {
        if (isPathSeparator(path2.charCodeAt(i))) {
          if (!matchedSlash) {
            start = i + 1;
            break;
          }
        } else if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
      }
      if (end === -1) {
        return "";
      }
      return path2.slice(start, end);
    },
    extname(path2) {
      validateString(path2, "path");
      let start = 0;
      let startDot = -1;
      let startPart = 0;
      let end = -1;
      let matchedSlash = true;
      let preDotState = 0;
      if (path2.length >= 2 && path2.charCodeAt(1) === CHAR_COLON && isWindowsDeviceRoot(path2.charCodeAt(0))) {
        start = startPart = 2;
      }
      for (let i = path2.length - 1; i >= start; --i) {
        const code = path2.charCodeAt(i);
        if (isPathSeparator(code)) {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (code === CHAR_DOT) {
          if (startDot === -1) {
            startDot = i;
          } else if (preDotState !== 1) {
            preDotState = 1;
          }
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
      preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
      preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        return "";
      }
      return path2.slice(startDot, end);
    },
    format: _format$1.bind(null, "\\"),
    parse(path2) {
      validateString(path2, "path");
      const ret = { root: "", dir: "", base: "", ext: "", name: "" };
      if (path2.length === 0) {
        return ret;
      }
      const len2 = path2.length;
      let rootEnd = 0;
      let code = path2.charCodeAt(0);
      if (len2 === 1) {
        if (isPathSeparator(code)) {
          ret.root = ret.dir = path2;
          return ret;
        }
        ret.base = ret.name = path2;
        return ret;
      }
      if (isPathSeparator(code)) {
        rootEnd = 1;
        if (isPathSeparator(path2.charCodeAt(1))) {
          let j = 2;
          let last2 = j;
          while (j < len2 && !isPathSeparator(path2.charCodeAt(j))) {
            j++;
          }
          if (j < len2 && j !== last2) {
            last2 = j;
            while (j < len2 && isPathSeparator(path2.charCodeAt(j))) {
              j++;
            }
            if (j < len2 && j !== last2) {
              last2 = j;
              while (j < len2 && !isPathSeparator(path2.charCodeAt(j))) {
                j++;
              }
              if (j === len2) {
                rootEnd = j;
              } else if (j !== last2) {
                rootEnd = j + 1;
              }
            }
          }
        }
      } else if (isWindowsDeviceRoot(code) && path2.charCodeAt(1) === CHAR_COLON) {
        if (len2 <= 2) {
          ret.root = ret.dir = path2;
          return ret;
        }
        rootEnd = 2;
        if (isPathSeparator(path2.charCodeAt(2))) {
          if (len2 === 3) {
            ret.root = ret.dir = path2;
            return ret;
          }
          rootEnd = 3;
        }
      }
      if (rootEnd > 0) {
        ret.root = path2.slice(0, rootEnd);
      }
      let startDot = -1;
      let startPart = rootEnd;
      let end = -1;
      let matchedSlash = true;
      let i = path2.length - 1;
      let preDotState = 0;
      for (; i >= rootEnd; --i) {
        code = path2.charCodeAt(i);
        if (isPathSeparator(code)) {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (code === CHAR_DOT) {
          if (startDot === -1) {
            startDot = i;
          } else if (preDotState !== 1) {
            preDotState = 1;
          }
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (end !== -1) {
        if (startDot === -1 || // We saw a non-dot character immediately before the dot
        preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
        preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          ret.base = ret.name = path2.slice(startPart, end);
        } else {
          ret.name = path2.slice(startPart, startDot);
          ret.base = path2.slice(startPart, end);
          ret.ext = path2.slice(startDot, end);
        }
      }
      if (startPart > 0 && startPart !== rootEnd) {
        ret.dir = path2.slice(0, startPart - 1);
      } else {
        ret.dir = ret.root;
      }
      return ret;
    },
    sep: "\\",
    delimiter: ";",
    win32: null,
    posix: null
  };
  const posixCwd = (() => {
    if (platformIsWin32) {
      const regexp = /\\/g;
      return () => {
        const cwd$1 = cwd().replace(regexp, "/");
        return cwd$1.slice(cwd$1.indexOf("/"));
      };
    }
    return () => cwd();
  })();
  const posix$1 = {
    // path.resolve([from ...], to)
    resolve(...pathSegments) {
      let resolvedPath = "";
      let resolvedAbsolute = false;
      for (let i = pathSegments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
        const path2 = i >= 0 ? pathSegments[i] : posixCwd();
        validateString(path2, "path");
        if (path2.length === 0) {
          continue;
        }
        resolvedPath = `${path2}/${resolvedPath}`;
        resolvedAbsolute = path2.charCodeAt(0) === CHAR_FORWARD_SLASH;
      }
      resolvedPath = normalizeString(resolvedPath, !resolvedAbsolute, "/", isPosixPathSeparator);
      if (resolvedAbsolute) {
        return `/${resolvedPath}`;
      }
      return resolvedPath.length > 0 ? resolvedPath : ".";
    },
    normalize(path2) {
      validateString(path2, "path");
      if (path2.length === 0) {
        return ".";
      }
      const isAbsolute = path2.charCodeAt(0) === CHAR_FORWARD_SLASH;
      const trailingSeparator = path2.charCodeAt(path2.length - 1) === CHAR_FORWARD_SLASH;
      path2 = normalizeString(path2, !isAbsolute, "/", isPosixPathSeparator);
      if (path2.length === 0) {
        if (isAbsolute) {
          return "/";
        }
        return trailingSeparator ? "./" : ".";
      }
      if (trailingSeparator) {
        path2 += "/";
      }
      return isAbsolute ? `/${path2}` : path2;
    },
    isAbsolute(path2) {
      validateString(path2, "path");
      return path2.length > 0 && path2.charCodeAt(0) === CHAR_FORWARD_SLASH;
    },
    join(...paths) {
      if (paths.length === 0) {
        return ".";
      }
      let joined;
      for (let i = 0; i < paths.length; ++i) {
        const arg = paths[i];
        validateString(arg, "path");
        if (arg.length > 0) {
          if (joined === void 0) {
            joined = arg;
          } else {
            joined += `/${arg}`;
          }
        }
      }
      if (joined === void 0) {
        return ".";
      }
      return posix$1.normalize(joined);
    },
    relative(from, to) {
      validateString(from, "from");
      validateString(to, "to");
      if (from === to) {
        return "";
      }
      from = posix$1.resolve(from);
      to = posix$1.resolve(to);
      if (from === to) {
        return "";
      }
      const fromStart = 1;
      const fromEnd = from.length;
      const fromLen = fromEnd - fromStart;
      const toStart = 1;
      const toLen = to.length - toStart;
      const length = fromLen < toLen ? fromLen : toLen;
      let lastCommonSep = -1;
      let i = 0;
      for (; i < length; i++) {
        const fromCode = from.charCodeAt(fromStart + i);
        if (fromCode !== to.charCodeAt(toStart + i)) {
          break;
        } else if (fromCode === CHAR_FORWARD_SLASH) {
          lastCommonSep = i;
        }
      }
      if (i === length) {
        if (toLen > length) {
          if (to.charCodeAt(toStart + i) === CHAR_FORWARD_SLASH) {
            return to.slice(toStart + i + 1);
          }
          if (i === 0) {
            return to.slice(toStart + i);
          }
        } else if (fromLen > length) {
          if (from.charCodeAt(fromStart + i) === CHAR_FORWARD_SLASH) {
            lastCommonSep = i;
          } else if (i === 0) {
            lastCommonSep = 0;
          }
        }
      }
      let out2 = "";
      for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
        if (i === fromEnd || from.charCodeAt(i) === CHAR_FORWARD_SLASH) {
          out2 += out2.length === 0 ? ".." : "/..";
        }
      }
      return `${out2}${to.slice(toStart + lastCommonSep)}`;
    },
    toNamespacedPath(path2) {
      return path2;
    },
    dirname(path2) {
      validateString(path2, "path");
      if (path2.length === 0) {
        return ".";
      }
      const hasRoot = path2.charCodeAt(0) === CHAR_FORWARD_SLASH;
      let end = -1;
      let matchedSlash = true;
      for (let i = path2.length - 1; i >= 1; --i) {
        if (path2.charCodeAt(i) === CHAR_FORWARD_SLASH) {
          if (!matchedSlash) {
            end = i;
            break;
          }
        } else {
          matchedSlash = false;
        }
      }
      if (end === -1) {
        return hasRoot ? "/" : ".";
      }
      if (hasRoot && end === 1) {
        return "//";
      }
      return path2.slice(0, end);
    },
    basename(path2, ext) {
      if (ext !== void 0) {
        validateString(ext, "ext");
      }
      validateString(path2, "path");
      let start = 0;
      let end = -1;
      let matchedSlash = true;
      let i;
      if (ext !== void 0 && ext.length > 0 && ext.length <= path2.length) {
        if (ext === path2) {
          return "";
        }
        let extIdx = ext.length - 1;
        let firstNonSlashEnd = -1;
        for (i = path2.length - 1; i >= 0; --i) {
          const code = path2.charCodeAt(i);
          if (code === CHAR_FORWARD_SLASH) {
            if (!matchedSlash) {
              start = i + 1;
              break;
            }
          } else {
            if (firstNonSlashEnd === -1) {
              matchedSlash = false;
              firstNonSlashEnd = i + 1;
            }
            if (extIdx >= 0) {
              if (code === ext.charCodeAt(extIdx)) {
                if (--extIdx === -1) {
                  end = i;
                }
              } else {
                extIdx = -1;
                end = firstNonSlashEnd;
              }
            }
          }
        }
        if (start === end) {
          end = firstNonSlashEnd;
        } else if (end === -1) {
          end = path2.length;
        }
        return path2.slice(start, end);
      }
      for (i = path2.length - 1; i >= 0; --i) {
        if (path2.charCodeAt(i) === CHAR_FORWARD_SLASH) {
          if (!matchedSlash) {
            start = i + 1;
            break;
          }
        } else if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
      }
      if (end === -1) {
        return "";
      }
      return path2.slice(start, end);
    },
    extname(path2) {
      validateString(path2, "path");
      let startDot = -1;
      let startPart = 0;
      let end = -1;
      let matchedSlash = true;
      let preDotState = 0;
      for (let i = path2.length - 1; i >= 0; --i) {
        const code = path2.charCodeAt(i);
        if (code === CHAR_FORWARD_SLASH) {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (code === CHAR_DOT) {
          if (startDot === -1) {
            startDot = i;
          } else if (preDotState !== 1) {
            preDotState = 1;
          }
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
      preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
      preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        return "";
      }
      return path2.slice(startDot, end);
    },
    format: _format$1.bind(null, "/"),
    parse(path2) {
      validateString(path2, "path");
      const ret = { root: "", dir: "", base: "", ext: "", name: "" };
      if (path2.length === 0) {
        return ret;
      }
      const isAbsolute = path2.charCodeAt(0) === CHAR_FORWARD_SLASH;
      let start;
      if (isAbsolute) {
        ret.root = "/";
        start = 1;
      } else {
        start = 0;
      }
      let startDot = -1;
      let startPart = 0;
      let end = -1;
      let matchedSlash = true;
      let i = path2.length - 1;
      let preDotState = 0;
      for (; i >= start; --i) {
        const code = path2.charCodeAt(i);
        if (code === CHAR_FORWARD_SLASH) {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (code === CHAR_DOT) {
          if (startDot === -1) {
            startDot = i;
          } else if (preDotState !== 1) {
            preDotState = 1;
          }
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (end !== -1) {
        const start2 = startPart === 0 && isAbsolute ? 1 : startPart;
        if (startDot === -1 || // We saw a non-dot character immediately before the dot
        preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
        preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          ret.base = ret.name = path2.slice(start2, end);
        } else {
          ret.name = path2.slice(start2, startDot);
          ret.base = path2.slice(start2, end);
          ret.ext = path2.slice(startDot, end);
        }
      }
      if (startPart > 0) {
        ret.dir = path2.slice(0, startPart - 1);
      } else if (isAbsolute) {
        ret.dir = "/";
      }
      return ret;
    },
    sep: "/",
    delimiter: ":",
    win32: null,
    posix: null
  };
  posix$1.win32 = win32.win32 = win32;
  posix$1.posix = win32.posix = posix$1;
  platformIsWin32 ? win32.normalize : posix$1.normalize;
  platformIsWin32 ? win32.resolve : posix$1.resolve;
  platformIsWin32 ? win32.relative : posix$1.relative;
  platformIsWin32 ? win32.dirname : posix$1.dirname;
  platformIsWin32 ? win32.basename : posix$1.basename;
  platformIsWin32 ? win32.extname : posix$1.extname;
  platformIsWin32 ? win32.sep : posix$1.sep;
  const _schemePattern = /^\w[\w\d+.-]*$/;
  const _singleSlashStart = /^\//;
  const _doubleSlashStart = /^\/\//;
  function _validateUri(ret, _strict) {
    if (!ret.scheme && _strict) {
      throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${ret.authority}", path: "${ret.path}", query: "${ret.query}", fragment: "${ret.fragment}"}`);
    }
    if (ret.scheme && !_schemePattern.test(ret.scheme)) {
      throw new Error("[UriError]: Scheme contains illegal characters.");
    }
    if (ret.path) {
      if (ret.authority) {
        if (!_singleSlashStart.test(ret.path)) {
          throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
        }
      } else {
        if (_doubleSlashStart.test(ret.path)) {
          throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
        }
      }
    }
  }
  function _schemeFix(scheme, _strict) {
    if (!scheme && !_strict) {
      return "file";
    }
    return scheme;
  }
  function _referenceResolution(scheme, path2) {
    switch (scheme) {
      case "https":
      case "http":
      case "file":
        if (!path2) {
          path2 = _slash;
        } else if (path2[0] !== _slash) {
          path2 = _slash + path2;
        }
        break;
    }
    return path2;
  }
  const _empty = "";
  const _slash = "/";
  const _regexp = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
  let URI$2 = class URI2 {
    static isUri(thing) {
      if (thing instanceof URI2) {
        return true;
      }
      if (!thing) {
        return false;
      }
      return typeof thing.authority === "string" && typeof thing.fragment === "string" && typeof thing.path === "string" && typeof thing.query === "string" && typeof thing.scheme === "string" && typeof thing.fsPath === "string" && typeof thing.with === "function" && typeof thing.toString === "function";
    }
    /**
     * @internal
     */
    constructor(schemeOrData, authority, path2, query, fragment, _strict = false) {
      if (typeof schemeOrData === "object") {
        this.scheme = schemeOrData.scheme || _empty;
        this.authority = schemeOrData.authority || _empty;
        this.path = schemeOrData.path || _empty;
        this.query = schemeOrData.query || _empty;
        this.fragment = schemeOrData.fragment || _empty;
      } else {
        this.scheme = _schemeFix(schemeOrData, _strict);
        this.authority = authority || _empty;
        this.path = _referenceResolution(this.scheme, path2 || _empty);
        this.query = query || _empty;
        this.fragment = fragment || _empty;
        _validateUri(this, _strict);
      }
    }
    // ---- filesystem path -----------------------
    /**
     * Returns a string representing the corresponding file system path of this URI.
     * Will handle UNC paths, normalizes windows drive letters to lower-case, and uses the
     * platform specific path separator.
     *
     * * Will *not* validate the path for invalid characters and semantics.
     * * Will *not* look at the scheme of this URI.
     * * The result shall *not* be used for display purposes but for accessing a file on disk.
     *
     *
     * The *difference* to `URI#path` is the use of the platform specific separator and the handling
     * of UNC paths. See the below sample of a file-uri with an authority (UNC path).
     *
     * ```ts
        const u = URI.parse('file://server/c$/folder/file.txt')
        u.authority === 'server'
        u.path === '/shares/c$/file.txt'
        u.fsPath === '\\server\c$\folder\file.txt'
    ```
     *
     * Using `URI#path` to read a file (using fs-apis) would not be enough because parts of the path,
     * namely the server name, would be missing. Therefore `URI#fsPath` exists - it's sugar to ease working
     * with URIs that represent files on disk (`file` scheme).
     */
    get fsPath() {
      return uriToFsPath(this, false);
    }
    // ---- modify to new -------------------------
    with(change) {
      if (!change) {
        return this;
      }
      let { scheme, authority, path: path2, query, fragment } = change;
      if (scheme === void 0) {
        scheme = this.scheme;
      } else if (scheme === null) {
        scheme = _empty;
      }
      if (authority === void 0) {
        authority = this.authority;
      } else if (authority === null) {
        authority = _empty;
      }
      if (path2 === void 0) {
        path2 = this.path;
      } else if (path2 === null) {
        path2 = _empty;
      }
      if (query === void 0) {
        query = this.query;
      } else if (query === null) {
        query = _empty;
      }
      if (fragment === void 0) {
        fragment = this.fragment;
      } else if (fragment === null) {
        fragment = _empty;
      }
      if (scheme === this.scheme && authority === this.authority && path2 === this.path && query === this.query && fragment === this.fragment) {
        return this;
      }
      return new Uri(scheme, authority, path2, query, fragment);
    }
    // ---- parse & validate ------------------------
    /**
     * Creates a new URI from a string, e.g. `http://www.example.com/some/path`,
     * `file:///usr/home`, or `scheme:with/path`.
     *
     * @param value A string which represents an URI (see `URI#toString`).
     */
    static parse(value, _strict = false) {
      const match = _regexp.exec(value);
      if (!match) {
        return new Uri(_empty, _empty, _empty, _empty, _empty);
      }
      return new Uri(match[2] || _empty, percentDecode(match[4] || _empty), percentDecode(match[5] || _empty), percentDecode(match[7] || _empty), percentDecode(match[9] || _empty), _strict);
    }
    /**
     * Creates a new URI from a file system path, e.g. `c:\my\files`,
     * `/usr/home`, or `\\server\share\some\path`.
     *
     * The *difference* between `URI#parse` and `URI#file` is that the latter treats the argument
     * as path, not as stringified-uri. E.g. `URI.file(path)` is **not the same as**
     * `URI.parse('file://' + path)` because the path might contain characters that are
     * interpreted (# and ?). See the following sample:
     * ```ts
    const good = URI.file('/coding/c#/project1');
    good.scheme === 'file';
    good.path === '/coding/c#/project1';
    good.fragment === '';
    const bad = URI.parse('file://' + '/coding/c#/project1');
    bad.scheme === 'file';
    bad.path === '/coding/c'; // path is now broken
    bad.fragment === '/project1';
    ```
     *
     * @param path A file system path (see `URI#fsPath`)
     */
    static file(path2) {
      let authority = _empty;
      if (isWindows) {
        path2 = path2.replace(/\\/g, _slash);
      }
      if (path2[0] === _slash && path2[1] === _slash) {
        const idx = path2.indexOf(_slash, 2);
        if (idx === -1) {
          authority = path2.substring(2);
          path2 = _slash;
        } else {
          authority = path2.substring(2, idx);
          path2 = path2.substring(idx) || _slash;
        }
      }
      return new Uri("file", authority, path2, _empty, _empty);
    }
    /**
     * Creates new URI from uri components.
     *
     * Unless `strict` is `true` the scheme is defaults to be `file`. This function performs
     * validation and should be used for untrusted uri components retrieved from storage,
     * user input, command arguments etc
     */
    static from(components, strict) {
      const result = new Uri(components.scheme, components.authority, components.path, components.query, components.fragment, strict);
      return result;
    }
    /**
     * Join a URI path with path fragments and normalizes the resulting path.
     *
     * @param uri The input URI.
     * @param pathFragment The path fragment to add to the URI path.
     * @returns The resulting URI.
     */
    static joinPath(uri, ...pathFragment) {
      if (!uri.path) {
        throw new Error(`[UriError]: cannot call joinPath on URI without path`);
      }
      let newPath;
      if (isWindows && uri.scheme === "file") {
        newPath = URI2.file(win32.join(uriToFsPath(uri, true), ...pathFragment)).path;
      } else {
        newPath = posix$1.join(uri.path, ...pathFragment);
      }
      return uri.with({ path: newPath });
    }
    // ---- printing/externalize ---------------------------
    /**
     * Creates a string representation for this URI. It's guaranteed that calling
     * `URI.parse` with the result of this function creates an URI which is equal
     * to this URI.
     *
     * * The result shall *not* be used for display purposes but for externalization or transport.
     * * The result will be encoded using the percentage encoding and encoding happens mostly
     * ignore the scheme-specific encoding rules.
     *
     * @param skipEncoding Do not encode the result, default is `false`
     */
    toString(skipEncoding = false) {
      return _asFormatted(this, skipEncoding);
    }
    toJSON() {
      return this;
    }
    static revive(data2) {
      var _a2, _b;
      if (!data2) {
        return data2;
      } else if (data2 instanceof URI2) {
        return data2;
      } else {
        const result = new Uri(data2);
        result._formatted = (_a2 = data2.external) !== null && _a2 !== void 0 ? _a2 : null;
        result._fsPath = data2._sep === _pathSepMarker ? (_b = data2.fsPath) !== null && _b !== void 0 ? _b : null : null;
        return result;
      }
    }
  };
  const _pathSepMarker = isWindows ? 1 : void 0;
  class Uri extends URI$2 {
    constructor() {
      super(...arguments);
      this._formatted = null;
      this._fsPath = null;
    }
    get fsPath() {
      if (!this._fsPath) {
        this._fsPath = uriToFsPath(this, false);
      }
      return this._fsPath;
    }
    toString(skipEncoding = false) {
      if (!skipEncoding) {
        if (!this._formatted) {
          this._formatted = _asFormatted(this, false);
        }
        return this._formatted;
      } else {
        return _asFormatted(this, true);
      }
    }
    toJSON() {
      const res = {
        $mid: 1
        /* MarshalledId.Uri */
      };
      if (this._fsPath) {
        res.fsPath = this._fsPath;
        res._sep = _pathSepMarker;
      }
      if (this._formatted) {
        res.external = this._formatted;
      }
      if (this.path) {
        res.path = this.path;
      }
      if (this.scheme) {
        res.scheme = this.scheme;
      }
      if (this.authority) {
        res.authority = this.authority;
      }
      if (this.query) {
        res.query = this.query;
      }
      if (this.fragment) {
        res.fragment = this.fragment;
      }
      return res;
    }
  }
  const encodeTable = {
    [
      58
      /* CharCode.Colon */
    ]: "%3A",
    [
      47
      /* CharCode.Slash */
    ]: "%2F",
    [
      63
      /* CharCode.QuestionMark */
    ]: "%3F",
    [
      35
      /* CharCode.Hash */
    ]: "%23",
    [
      91
      /* CharCode.OpenSquareBracket */
    ]: "%5B",
    [
      93
      /* CharCode.CloseSquareBracket */
    ]: "%5D",
    [
      64
      /* CharCode.AtSign */
    ]: "%40",
    [
      33
      /* CharCode.ExclamationMark */
    ]: "%21",
    [
      36
      /* CharCode.DollarSign */
    ]: "%24",
    [
      38
      /* CharCode.Ampersand */
    ]: "%26",
    [
      39
      /* CharCode.SingleQuote */
    ]: "%27",
    [
      40
      /* CharCode.OpenParen */
    ]: "%28",
    [
      41
      /* CharCode.CloseParen */
    ]: "%29",
    [
      42
      /* CharCode.Asterisk */
    ]: "%2A",
    [
      43
      /* CharCode.Plus */
    ]: "%2B",
    [
      44
      /* CharCode.Comma */
    ]: "%2C",
    [
      59
      /* CharCode.Semicolon */
    ]: "%3B",
    [
      61
      /* CharCode.Equals */
    ]: "%3D",
    [
      32
      /* CharCode.Space */
    ]: "%20"
  };
  function encodeURIComponentFast(uriComponent, isPath, isAuthority) {
    let res = void 0;
    let nativeEncodePos = -1;
    for (let pos = 0; pos < uriComponent.length; pos++) {
      const code = uriComponent.charCodeAt(pos);
      if (code >= 97 && code <= 122 || code >= 65 && code <= 90 || code >= 48 && code <= 57 || code === 45 || code === 46 || code === 95 || code === 126 || isPath && code === 47 || isAuthority && code === 91 || isAuthority && code === 93 || isAuthority && code === 58) {
        if (nativeEncodePos !== -1) {
          res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
          nativeEncodePos = -1;
        }
        if (res !== void 0) {
          res += uriComponent.charAt(pos);
        }
      } else {
        if (res === void 0) {
          res = uriComponent.substr(0, pos);
        }
        const escaped = encodeTable[code];
        if (escaped !== void 0) {
          if (nativeEncodePos !== -1) {
            res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
            nativeEncodePos = -1;
          }
          res += escaped;
        } else if (nativeEncodePos === -1) {
          nativeEncodePos = pos;
        }
      }
    }
    if (nativeEncodePos !== -1) {
      res += encodeURIComponent(uriComponent.substring(nativeEncodePos));
    }
    return res !== void 0 ? res : uriComponent;
  }
  function encodeURIComponentMinimal(path2) {
    let res = void 0;
    for (let pos = 0; pos < path2.length; pos++) {
      const code = path2.charCodeAt(pos);
      if (code === 35 || code === 63) {
        if (res === void 0) {
          res = path2.substr(0, pos);
        }
        res += encodeTable[code];
      } else {
        if (res !== void 0) {
          res += path2[pos];
        }
      }
    }
    return res !== void 0 ? res : path2;
  }
  function uriToFsPath(uri, keepDriveLetterCasing) {
    let value;
    if (uri.authority && uri.path.length > 1 && uri.scheme === "file") {
      value = `//${uri.authority}${uri.path}`;
    } else if (uri.path.charCodeAt(0) === 47 && (uri.path.charCodeAt(1) >= 65 && uri.path.charCodeAt(1) <= 90 || uri.path.charCodeAt(1) >= 97 && uri.path.charCodeAt(1) <= 122) && uri.path.charCodeAt(2) === 58) {
      if (!keepDriveLetterCasing) {
        value = uri.path[1].toLowerCase() + uri.path.substr(2);
      } else {
        value = uri.path.substr(1);
      }
    } else {
      value = uri.path;
    }
    if (isWindows) {
      value = value.replace(/\//g, "\\");
    }
    return value;
  }
  function _asFormatted(uri, skipEncoding) {
    const encoder = !skipEncoding ? encodeURIComponentFast : encodeURIComponentMinimal;
    let res = "";
    let { scheme, authority, path: path2, query, fragment } = uri;
    if (scheme) {
      res += scheme;
      res += ":";
    }
    if (authority || scheme === "file") {
      res += _slash;
      res += _slash;
    }
    if (authority) {
      let idx = authority.indexOf("@");
      if (idx !== -1) {
        const userinfo = authority.substr(0, idx);
        authority = authority.substr(idx + 1);
        idx = userinfo.lastIndexOf(":");
        if (idx === -1) {
          res += encoder(userinfo, false, false);
        } else {
          res += encoder(userinfo.substr(0, idx), false, false);
          res += ":";
          res += encoder(userinfo.substr(idx + 1), false, true);
        }
        res += "@";
      }
      authority = authority.toLowerCase();
      idx = authority.lastIndexOf(":");
      if (idx === -1) {
        res += encoder(authority, false, true);
      } else {
        res += encoder(authority.substr(0, idx), false, true);
        res += authority.substr(idx);
      }
    }
    if (path2) {
      if (path2.length >= 3 && path2.charCodeAt(0) === 47 && path2.charCodeAt(2) === 58) {
        const code = path2.charCodeAt(1);
        if (code >= 65 && code <= 90) {
          path2 = `/${String.fromCharCode(code + 32)}:${path2.substr(3)}`;
        }
      } else if (path2.length >= 2 && path2.charCodeAt(1) === 58) {
        const code = path2.charCodeAt(0);
        if (code >= 65 && code <= 90) {
          path2 = `${String.fromCharCode(code + 32)}:${path2.substr(2)}`;
        }
      }
      res += encoder(path2, true, false);
    }
    if (query) {
      res += "?";
      res += encoder(query, false, false);
    }
    if (fragment) {
      res += "#";
      res += !skipEncoding ? encodeURIComponentFast(fragment, false, false) : fragment;
    }
    return res;
  }
  function decodeURIComponentGraceful(str2) {
    try {
      return decodeURIComponent(str2);
    } catch (_a2) {
      if (str2.length > 3) {
        return str2.substr(0, 3) + decodeURIComponentGraceful(str2.substr(3));
      } else {
        return str2;
      }
    }
  }
  const _rEncodedAsHex = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
  function percentDecode(str2) {
    if (!str2.match(_rEncodedAsHex)) {
      return str2;
    }
    return str2.replace(_rEncodedAsHex, (match) => decodeURIComponentGraceful(match));
  }
  let Position$1 = class Position2 {
    constructor(lineNumber, column) {
      this.lineNumber = lineNumber;
      this.column = column;
    }
    /**
     * Create a new position from this position.
     *
     * @param newLineNumber new line number
     * @param newColumn new column
     */
    with(newLineNumber = this.lineNumber, newColumn = this.column) {
      if (newLineNumber === this.lineNumber && newColumn === this.column) {
        return this;
      } else {
        return new Position2(newLineNumber, newColumn);
      }
    }
    /**
     * Derive a new position from this position.
     *
     * @param deltaLineNumber line number delta
     * @param deltaColumn column delta
     */
    delta(deltaLineNumber = 0, deltaColumn = 0) {
      return this.with(this.lineNumber + deltaLineNumber, this.column + deltaColumn);
    }
    /**
     * Test if this position equals other position
     */
    equals(other) {
      return Position2.equals(this, other);
    }
    /**
     * Test if position `a` equals position `b`
     */
    static equals(a2, b) {
      if (!a2 && !b) {
        return true;
      }
      return !!a2 && !!b && a2.lineNumber === b.lineNumber && a2.column === b.column;
    }
    /**
     * Test if this position is before other position.
     * If the two positions are equal, the result will be false.
     */
    isBefore(other) {
      return Position2.isBefore(this, other);
    }
    /**
     * Test if position `a` is before position `b`.
     * If the two positions are equal, the result will be false.
     */
    static isBefore(a2, b) {
      if (a2.lineNumber < b.lineNumber) {
        return true;
      }
      if (b.lineNumber < a2.lineNumber) {
        return false;
      }
      return a2.column < b.column;
    }
    /**
     * Test if this position is before other position.
     * If the two positions are equal, the result will be true.
     */
    isBeforeOrEqual(other) {
      return Position2.isBeforeOrEqual(this, other);
    }
    /**
     * Test if position `a` is before position `b`.
     * If the two positions are equal, the result will be true.
     */
    static isBeforeOrEqual(a2, b) {
      if (a2.lineNumber < b.lineNumber) {
        return true;
      }
      if (b.lineNumber < a2.lineNumber) {
        return false;
      }
      return a2.column <= b.column;
    }
    /**
     * A function that compares positions, useful for sorting
     */
    static compare(a2, b) {
      const aLineNumber = a2.lineNumber | 0;
      const bLineNumber = b.lineNumber | 0;
      if (aLineNumber === bLineNumber) {
        const aColumn = a2.column | 0;
        const bColumn = b.column | 0;
        return aColumn - bColumn;
      }
      return aLineNumber - bLineNumber;
    }
    /**
     * Clone this position.
     */
    clone() {
      return new Position2(this.lineNumber, this.column);
    }
    /**
     * Convert to a human-readable representation.
     */
    toString() {
      return "(" + this.lineNumber + "," + this.column + ")";
    }
    // ---
    /**
     * Create a `Position` from an `IPosition`.
     */
    static lift(pos) {
      return new Position2(pos.lineNumber, pos.column);
    }
    /**
     * Test if `obj` is an `IPosition`.
     */
    static isIPosition(obj) {
      return obj && typeof obj.lineNumber === "number" && typeof obj.column === "number";
    }
  };
  let Range$b = class Range2 {
    constructor(startLineNumber, startColumn, endLineNumber, endColumn) {
      if (startLineNumber > endLineNumber || startLineNumber === endLineNumber && startColumn > endColumn) {
        this.startLineNumber = endLineNumber;
        this.startColumn = endColumn;
        this.endLineNumber = startLineNumber;
        this.endColumn = startColumn;
      } else {
        this.startLineNumber = startLineNumber;
        this.startColumn = startColumn;
        this.endLineNumber = endLineNumber;
        this.endColumn = endColumn;
      }
    }
    /**
     * Test if this range is empty.
     */
    isEmpty() {
      return Range2.isEmpty(this);
    }
    /**
     * Test if `range` is empty.
     */
    static isEmpty(range2) {
      return range2.startLineNumber === range2.endLineNumber && range2.startColumn === range2.endColumn;
    }
    /**
     * Test if position is in this range. If the position is at the edges, will return true.
     */
    containsPosition(position) {
      return Range2.containsPosition(this, position);
    }
    /**
     * Test if `position` is in `range`. If the position is at the edges, will return true.
     */
    static containsPosition(range2, position) {
      if (position.lineNumber < range2.startLineNumber || position.lineNumber > range2.endLineNumber) {
        return false;
      }
      if (position.lineNumber === range2.startLineNumber && position.column < range2.startColumn) {
        return false;
      }
      if (position.lineNumber === range2.endLineNumber && position.column > range2.endColumn) {
        return false;
      }
      return true;
    }
    /**
     * Test if `position` is in `range`. If the position is at the edges, will return false.
     * @internal
     */
    static strictContainsPosition(range2, position) {
      if (position.lineNumber < range2.startLineNumber || position.lineNumber > range2.endLineNumber) {
        return false;
      }
      if (position.lineNumber === range2.startLineNumber && position.column <= range2.startColumn) {
        return false;
      }
      if (position.lineNumber === range2.endLineNumber && position.column >= range2.endColumn) {
        return false;
      }
      return true;
    }
    /**
     * Test if range is in this range. If the range is equal to this range, will return true.
     */
    containsRange(range2) {
      return Range2.containsRange(this, range2);
    }
    /**
     * Test if `otherRange` is in `range`. If the ranges are equal, will return true.
     */
    static containsRange(range2, otherRange) {
      if (otherRange.startLineNumber < range2.startLineNumber || otherRange.endLineNumber < range2.startLineNumber) {
        return false;
      }
      if (otherRange.startLineNumber > range2.endLineNumber || otherRange.endLineNumber > range2.endLineNumber) {
        return false;
      }
      if (otherRange.startLineNumber === range2.startLineNumber && otherRange.startColumn < range2.startColumn) {
        return false;
      }
      if (otherRange.endLineNumber === range2.endLineNumber && otherRange.endColumn > range2.endColumn) {
        return false;
      }
      return true;
    }
    /**
     * Test if `range` is strictly in this range. `range` must start after and end before this range for the result to be true.
     */
    strictContainsRange(range2) {
      return Range2.strictContainsRange(this, range2);
    }
    /**
     * Test if `otherRange` is strictly in `range` (must start after, and end before). If the ranges are equal, will return false.
     */
    static strictContainsRange(range2, otherRange) {
      if (otherRange.startLineNumber < range2.startLineNumber || otherRange.endLineNumber < range2.startLineNumber) {
        return false;
      }
      if (otherRange.startLineNumber > range2.endLineNumber || otherRange.endLineNumber > range2.endLineNumber) {
        return false;
      }
      if (otherRange.startLineNumber === range2.startLineNumber && otherRange.startColumn <= range2.startColumn) {
        return false;
      }
      if (otherRange.endLineNumber === range2.endLineNumber && otherRange.endColumn >= range2.endColumn) {
        return false;
      }
      return true;
    }
    /**
     * A reunion of the two ranges.
     * The smallest position will be used as the start point, and the largest one as the end point.
     */
    plusRange(range2) {
      return Range2.plusRange(this, range2);
    }
    /**
     * A reunion of the two ranges.
     * The smallest position will be used as the start point, and the largest one as the end point.
     */
    static plusRange(a2, b) {
      let startLineNumber;
      let startColumn;
      let endLineNumber;
      let endColumn;
      if (b.startLineNumber < a2.startLineNumber) {
        startLineNumber = b.startLineNumber;
        startColumn = b.startColumn;
      } else if (b.startLineNumber === a2.startLineNumber) {
        startLineNumber = b.startLineNumber;
        startColumn = Math.min(b.startColumn, a2.startColumn);
      } else {
        startLineNumber = a2.startLineNumber;
        startColumn = a2.startColumn;
      }
      if (b.endLineNumber > a2.endLineNumber) {
        endLineNumber = b.endLineNumber;
        endColumn = b.endColumn;
      } else if (b.endLineNumber === a2.endLineNumber) {
        endLineNumber = b.endLineNumber;
        endColumn = Math.max(b.endColumn, a2.endColumn);
      } else {
        endLineNumber = a2.endLineNumber;
        endColumn = a2.endColumn;
      }
      return new Range2(startLineNumber, startColumn, endLineNumber, endColumn);
    }
    /**
     * A intersection of the two ranges.
     */
    intersectRanges(range2) {
      return Range2.intersectRanges(this, range2);
    }
    /**
     * A intersection of the two ranges.
     */
    static intersectRanges(a2, b) {
      let resultStartLineNumber = a2.startLineNumber;
      let resultStartColumn = a2.startColumn;
      let resultEndLineNumber = a2.endLineNumber;
      let resultEndColumn = a2.endColumn;
      const otherStartLineNumber = b.startLineNumber;
      const otherStartColumn = b.startColumn;
      const otherEndLineNumber = b.endLineNumber;
      const otherEndColumn = b.endColumn;
      if (resultStartLineNumber < otherStartLineNumber) {
        resultStartLineNumber = otherStartLineNumber;
        resultStartColumn = otherStartColumn;
      } else if (resultStartLineNumber === otherStartLineNumber) {
        resultStartColumn = Math.max(resultStartColumn, otherStartColumn);
      }
      if (resultEndLineNumber > otherEndLineNumber) {
        resultEndLineNumber = otherEndLineNumber;
        resultEndColumn = otherEndColumn;
      } else if (resultEndLineNumber === otherEndLineNumber) {
        resultEndColumn = Math.min(resultEndColumn, otherEndColumn);
      }
      if (resultStartLineNumber > resultEndLineNumber) {
        return null;
      }
      if (resultStartLineNumber === resultEndLineNumber && resultStartColumn > resultEndColumn) {
        return null;
      }
      return new Range2(resultStartLineNumber, resultStartColumn, resultEndLineNumber, resultEndColumn);
    }
    /**
     * Test if this range equals other.
     */
    equalsRange(other) {
      return Range2.equalsRange(this, other);
    }
    /**
     * Test if range `a` equals `b`.
     */
    static equalsRange(a2, b) {
      if (!a2 && !b) {
        return true;
      }
      return !!a2 && !!b && a2.startLineNumber === b.startLineNumber && a2.startColumn === b.startColumn && a2.endLineNumber === b.endLineNumber && a2.endColumn === b.endColumn;
    }
    /**
     * Return the end position (which will be after or equal to the start position)
     */
    getEndPosition() {
      return Range2.getEndPosition(this);
    }
    /**
     * Return the end position (which will be after or equal to the start position)
     */
    static getEndPosition(range2) {
      return new Position$1(range2.endLineNumber, range2.endColumn);
    }
    /**
     * Return the start position (which will be before or equal to the end position)
     */
    getStartPosition() {
      return Range2.getStartPosition(this);
    }
    /**
     * Return the start position (which will be before or equal to the end position)
     */
    static getStartPosition(range2) {
      return new Position$1(range2.startLineNumber, range2.startColumn);
    }
    /**
     * Transform to a user presentable string representation.
     */
    toString() {
      return "[" + this.startLineNumber + "," + this.startColumn + " -> " + this.endLineNumber + "," + this.endColumn + "]";
    }
    /**
     * Create a new range using this range's start position, and using endLineNumber and endColumn as the end position.
     */
    setEndPosition(endLineNumber, endColumn) {
      return new Range2(this.startLineNumber, this.startColumn, endLineNumber, endColumn);
    }
    /**
     * Create a new range using this range's end position, and using startLineNumber and startColumn as the start position.
     */
    setStartPosition(startLineNumber, startColumn) {
      return new Range2(startLineNumber, startColumn, this.endLineNumber, this.endColumn);
    }
    /**
     * Create a new empty range using this range's start position.
     */
    collapseToStart() {
      return Range2.collapseToStart(this);
    }
    /**
     * Create a new empty range using this range's start position.
     */
    static collapseToStart(range2) {
      return new Range2(range2.startLineNumber, range2.startColumn, range2.startLineNumber, range2.startColumn);
    }
    /**
     * Create a new empty range using this range's end position.
     */
    collapseToEnd() {
      return Range2.collapseToEnd(this);
    }
    /**
     * Create a new empty range using this range's end position.
     */
    static collapseToEnd(range2) {
      return new Range2(range2.endLineNumber, range2.endColumn, range2.endLineNumber, range2.endColumn);
    }
    /**
     * Moves the range by the given amount of lines.
     */
    delta(lineCount) {
      return new Range2(this.startLineNumber + lineCount, this.startColumn, this.endLineNumber + lineCount, this.endColumn);
    }
    // ---
    static fromPositions(start, end = start) {
      return new Range2(start.lineNumber, start.column, end.lineNumber, end.column);
    }
    static lift(range2) {
      if (!range2) {
        return null;
      }
      return new Range2(range2.startLineNumber, range2.startColumn, range2.endLineNumber, range2.endColumn);
    }
    /**
     * Test if `obj` is an `IRange`.
     */
    static isIRange(obj) {
      return obj && typeof obj.startLineNumber === "number" && typeof obj.startColumn === "number" && typeof obj.endLineNumber === "number" && typeof obj.endColumn === "number";
    }
    /**
     * Test if the two ranges are touching in any way.
     */
    static areIntersectingOrTouching(a2, b) {
      if (a2.endLineNumber < b.startLineNumber || a2.endLineNumber === b.startLineNumber && a2.endColumn < b.startColumn) {
        return false;
      }
      if (b.endLineNumber < a2.startLineNumber || b.endLineNumber === a2.startLineNumber && b.endColumn < a2.startColumn) {
        return false;
      }
      return true;
    }
    /**
     * Test if the two ranges are intersecting. If the ranges are touching it returns true.
     */
    static areIntersecting(a2, b) {
      if (a2.endLineNumber < b.startLineNumber || a2.endLineNumber === b.startLineNumber && a2.endColumn <= b.startColumn) {
        return false;
      }
      if (b.endLineNumber < a2.startLineNumber || b.endLineNumber === a2.startLineNumber && b.endColumn <= a2.startColumn) {
        return false;
      }
      return true;
    }
    /**
     * A function that compares ranges, useful for sorting ranges
     * It will first compare ranges on the startPosition and then on the endPosition
     */
    static compareRangesUsingStarts(a2, b) {
      if (a2 && b) {
        const aStartLineNumber = a2.startLineNumber | 0;
        const bStartLineNumber = b.startLineNumber | 0;
        if (aStartLineNumber === bStartLineNumber) {
          const aStartColumn = a2.startColumn | 0;
          const bStartColumn = b.startColumn | 0;
          if (aStartColumn === bStartColumn) {
            const aEndLineNumber = a2.endLineNumber | 0;
            const bEndLineNumber = b.endLineNumber | 0;
            if (aEndLineNumber === bEndLineNumber) {
              const aEndColumn = a2.endColumn | 0;
              const bEndColumn = b.endColumn | 0;
              return aEndColumn - bEndColumn;
            }
            return aEndLineNumber - bEndLineNumber;
          }
          return aStartColumn - bStartColumn;
        }
        return aStartLineNumber - bStartLineNumber;
      }
      const aExists = a2 ? 1 : 0;
      const bExists = b ? 1 : 0;
      return aExists - bExists;
    }
    /**
     * A function that compares ranges, useful for sorting ranges
     * It will first compare ranges on the endPosition and then on the startPosition
     */
    static compareRangesUsingEnds(a2, b) {
      if (a2.endLineNumber === b.endLineNumber) {
        if (a2.endColumn === b.endColumn) {
          if (a2.startLineNumber === b.startLineNumber) {
            return a2.startColumn - b.startColumn;
          }
          return a2.startLineNumber - b.startLineNumber;
        }
        return a2.endColumn - b.endColumn;
      }
      return a2.endLineNumber - b.endLineNumber;
    }
    /**
     * Test if the range spans multiple lines.
     */
    static spansMultipleLines(range2) {
      return range2.endLineNumber > range2.startLineNumber;
    }
    toJSON() {
      return this;
    }
  };
  var CompareResult;
  (function(CompareResult2) {
    function isLessThan(result) {
      return result < 0;
    }
    CompareResult2.isLessThan = isLessThan;
    function isGreaterThan(result) {
      return result > 0;
    }
    CompareResult2.isGreaterThan = isGreaterThan;
    function isNeitherLessOrGreaterThan(result) {
      return result === 0;
    }
    CompareResult2.isNeitherLessOrGreaterThan = isNeitherLessOrGreaterThan;
    CompareResult2.greaterThan = 1;
    CompareResult2.lessThan = -1;
    CompareResult2.neitherLessOrGreaterThan = 0;
  })(CompareResult || (CompareResult = {}));
  function toUint8(v) {
    if (v < 0) {
      return 0;
    }
    if (v > 255) {
      return 255;
    }
    return v | 0;
  }
  function toUint32(v) {
    if (v < 0) {
      return 0;
    }
    if (v > 4294967295) {
      return 4294967295;
    }
    return v | 0;
  }
  class PrefixSumComputer {
    constructor(values2) {
      this.values = values2;
      this.prefixSum = new Uint32Array(values2.length);
      this.prefixSumValidIndex = new Int32Array(1);
      this.prefixSumValidIndex[0] = -1;
    }
    insertValues(insertIndex, insertValues) {
      insertIndex = toUint32(insertIndex);
      const oldValues = this.values;
      const oldPrefixSum = this.prefixSum;
      const insertValuesLen = insertValues.length;
      if (insertValuesLen === 0) {
        return false;
      }
      this.values = new Uint32Array(oldValues.length + insertValuesLen);
      this.values.set(oldValues.subarray(0, insertIndex), 0);
      this.values.set(oldValues.subarray(insertIndex), insertIndex + insertValuesLen);
      this.values.set(insertValues, insertIndex);
      if (insertIndex - 1 < this.prefixSumValidIndex[0]) {
        this.prefixSumValidIndex[0] = insertIndex - 1;
      }
      this.prefixSum = new Uint32Array(this.values.length);
      if (this.prefixSumValidIndex[0] >= 0) {
        this.prefixSum.set(oldPrefixSum.subarray(0, this.prefixSumValidIndex[0] + 1));
      }
      return true;
    }
    setValue(index2, value) {
      index2 = toUint32(index2);
      value = toUint32(value);
      if (this.values[index2] === value) {
        return false;
      }
      this.values[index2] = value;
      if (index2 - 1 < this.prefixSumValidIndex[0]) {
        this.prefixSumValidIndex[0] = index2 - 1;
      }
      return true;
    }
    removeValues(startIndex, count2) {
      startIndex = toUint32(startIndex);
      count2 = toUint32(count2);
      const oldValues = this.values;
      const oldPrefixSum = this.prefixSum;
      if (startIndex >= oldValues.length) {
        return false;
      }
      const maxCount = oldValues.length - startIndex;
      if (count2 >= maxCount) {
        count2 = maxCount;
      }
      if (count2 === 0) {
        return false;
      }
      this.values = new Uint32Array(oldValues.length - count2);
      this.values.set(oldValues.subarray(0, startIndex), 0);
      this.values.set(oldValues.subarray(startIndex + count2), startIndex);
      this.prefixSum = new Uint32Array(this.values.length);
      if (startIndex - 1 < this.prefixSumValidIndex[0]) {
        this.prefixSumValidIndex[0] = startIndex - 1;
      }
      if (this.prefixSumValidIndex[0] >= 0) {
        this.prefixSum.set(oldPrefixSum.subarray(0, this.prefixSumValidIndex[0] + 1));
      }
      return true;
    }
    getTotalSum() {
      if (this.values.length === 0) {
        return 0;
      }
      return this._getPrefixSum(this.values.length - 1);
    }
    /**
     * Returns the sum of the first `index + 1` many items.
     * @returns `SUM(0 <= j <= index, values[j])`.
     */
    getPrefixSum(index2) {
      if (index2 < 0) {
        return 0;
      }
      index2 = toUint32(index2);
      return this._getPrefixSum(index2);
    }
    _getPrefixSum(index2) {
      if (index2 <= this.prefixSumValidIndex[0]) {
        return this.prefixSum[index2];
      }
      let startIndex = this.prefixSumValidIndex[0] + 1;
      if (startIndex === 0) {
        this.prefixSum[0] = this.values[0];
        startIndex++;
      }
      if (index2 >= this.values.length) {
        index2 = this.values.length - 1;
      }
      for (let i = startIndex; i <= index2; i++) {
        this.prefixSum[i] = this.prefixSum[i - 1] + this.values[i];
      }
      this.prefixSumValidIndex[0] = Math.max(this.prefixSumValidIndex[0], index2);
      return this.prefixSum[index2];
    }
    getIndexOf(sum) {
      sum = Math.floor(sum);
      this.getTotalSum();
      let low = 0;
      let high = this.values.length - 1;
      let mid = 0;
      let midStop = 0;
      let midStart = 0;
      while (low <= high) {
        mid = low + (high - low) / 2 | 0;
        midStop = this.prefixSum[mid];
        midStart = midStop - this.values[mid];
        if (sum < midStart) {
          high = mid - 1;
        } else if (sum >= midStop) {
          low = mid + 1;
        } else {
          break;
        }
      }
      return new PrefixSumIndexOfResult(mid, sum - midStart);
    }
  }
  class PrefixSumIndexOfResult {
    constructor(index2, remainder) {
      this.index = index2;
      this.remainder = remainder;
      this._prefixSumIndexOfResultBrand = void 0;
      this.index = index2;
      this.remainder = remainder;
    }
  }
  class MirrorTextModel {
    constructor(uri, lines, eol, versionId) {
      this._uri = uri;
      this._lines = lines;
      this._eol = eol;
      this._versionId = versionId;
      this._lineStarts = null;
      this._cachedTextValue = null;
    }
    dispose() {
      this._lines.length = 0;
    }
    get version() {
      return this._versionId;
    }
    getText() {
      if (this._cachedTextValue === null) {
        this._cachedTextValue = this._lines.join(this._eol);
      }
      return this._cachedTextValue;
    }
    onEvents(e) {
      if (e.eol && e.eol !== this._eol) {
        this._eol = e.eol;
        this._lineStarts = null;
      }
      const changes = e.changes;
      for (const change of changes) {
        this._acceptDeleteRange(change.range);
        this._acceptInsertText(new Position$1(change.range.startLineNumber, change.range.startColumn), change.text);
      }
      this._versionId = e.versionId;
      this._cachedTextValue = null;
    }
    _ensureLineStarts() {
      if (!this._lineStarts) {
        const eolLength = this._eol.length;
        const linesLength = this._lines.length;
        const lineStartValues = new Uint32Array(linesLength);
        for (let i = 0; i < linesLength; i++) {
          lineStartValues[i] = this._lines[i].length + eolLength;
        }
        this._lineStarts = new PrefixSumComputer(lineStartValues);
      }
    }
    /**
     * All changes to a line's text go through this method
     */
    _setLineText(lineIndex, newValue) {
      this._lines[lineIndex] = newValue;
      if (this._lineStarts) {
        this._lineStarts.setValue(lineIndex, this._lines[lineIndex].length + this._eol.length);
      }
    }
    _acceptDeleteRange(range2) {
      if (range2.startLineNumber === range2.endLineNumber) {
        if (range2.startColumn === range2.endColumn) {
          return;
        }
        this._setLineText(range2.startLineNumber - 1, this._lines[range2.startLineNumber - 1].substring(0, range2.startColumn - 1) + this._lines[range2.startLineNumber - 1].substring(range2.endColumn - 1));
        return;
      }
      this._setLineText(range2.startLineNumber - 1, this._lines[range2.startLineNumber - 1].substring(0, range2.startColumn - 1) + this._lines[range2.endLineNumber - 1].substring(range2.endColumn - 1));
      this._lines.splice(range2.startLineNumber, range2.endLineNumber - range2.startLineNumber);
      if (this._lineStarts) {
        this._lineStarts.removeValues(range2.startLineNumber, range2.endLineNumber - range2.startLineNumber);
      }
    }
    _acceptInsertText(position, insertText) {
      if (insertText.length === 0) {
        return;
      }
      const insertLines = splitLines(insertText);
      if (insertLines.length === 1) {
        this._setLineText(position.lineNumber - 1, this._lines[position.lineNumber - 1].substring(0, position.column - 1) + insertLines[0] + this._lines[position.lineNumber - 1].substring(position.column - 1));
        return;
      }
      insertLines[insertLines.length - 1] += this._lines[position.lineNumber - 1].substring(position.column - 1);
      this._setLineText(position.lineNumber - 1, this._lines[position.lineNumber - 1].substring(0, position.column - 1) + insertLines[0]);
      const newLengths = new Uint32Array(insertLines.length - 1);
      for (let i = 1; i < insertLines.length; i++) {
        this._lines.splice(position.lineNumber + i - 1, 0, insertLines[i]);
        newLengths[i - 1] = insertLines[i].length + this._eol.length;
      }
      if (this._lineStarts) {
        this._lineStarts.insertValues(position.lineNumber, newLengths);
      }
    }
  }
  const USUAL_WORD_SEPARATORS = "`~!@#$%^&*()-=+[{]}\\|;:'\",.<>/?";
  function createWordRegExp(allowInWords = "") {
    let source = "(-?\\d*\\.\\d\\w*)|([^";
    for (const sep of USUAL_WORD_SEPARATORS) {
      if (allowInWords.indexOf(sep) >= 0) {
        continue;
      }
      source += "\\" + sep;
    }
    source += "\\s]+)";
    return new RegExp(source, "g");
  }
  const DEFAULT_WORD_REGEXP = createWordRegExp();
  function ensureValidWordDefinition(wordDefinition) {
    let result = DEFAULT_WORD_REGEXP;
    if (wordDefinition && wordDefinition instanceof RegExp) {
      if (!wordDefinition.global) {
        let flags = "g";
        if (wordDefinition.ignoreCase) {
          flags += "i";
        }
        if (wordDefinition.multiline) {
          flags += "m";
        }
        if (wordDefinition.unicode) {
          flags += "u";
        }
        result = new RegExp(wordDefinition.source, flags);
      } else {
        result = wordDefinition;
      }
    }
    result.lastIndex = 0;
    return result;
  }
  const _defaultConfig = new LinkedList();
  _defaultConfig.unshift({
    maxLen: 1e3,
    windowSize: 15,
    timeBudget: 150
  });
  function getWordAtText(column, wordDefinition, text2, textOffset, config2) {
    if (!config2) {
      config2 = Iterable.first(_defaultConfig);
    }
    if (text2.length > config2.maxLen) {
      let start = column - config2.maxLen / 2;
      if (start < 0) {
        start = 0;
      } else {
        textOffset += start;
      }
      text2 = text2.substring(start, column + config2.maxLen / 2);
      return getWordAtText(column, wordDefinition, text2, textOffset, config2);
    }
    const t1 = Date.now();
    const pos = column - 1 - textOffset;
    let prevRegexIndex = -1;
    let match = null;
    for (let i = 1; ; i++) {
      if (Date.now() - t1 >= config2.timeBudget) {
        break;
      }
      const regexIndex = pos - config2.windowSize * i;
      wordDefinition.lastIndex = Math.max(0, regexIndex);
      const thisMatch = _findRegexMatchEnclosingPosition(wordDefinition, text2, pos, prevRegexIndex);
      if (!thisMatch && match) {
        break;
      }
      match = thisMatch;
      if (regexIndex <= 0) {
        break;
      }
      prevRegexIndex = regexIndex;
    }
    if (match) {
      const result = {
        word: match[0],
        startColumn: textOffset + 1 + match.index,
        endColumn: textOffset + 1 + match.index + match[0].length
      };
      wordDefinition.lastIndex = 0;
      return result;
    }
    return null;
  }
  function _findRegexMatchEnclosingPosition(wordDefinition, text2, pos, stopPos) {
    let match;
    while (match = wordDefinition.exec(text2)) {
      const matchIndex = match.index || 0;
      if (matchIndex <= pos && wordDefinition.lastIndex >= pos) {
        return match;
      } else if (stopPos > 0 && matchIndex > stopPos) {
        return null;
      }
    }
    return null;
  }
  class CharacterClassifier {
    constructor(_defaultValue) {
      const defaultValue = toUint8(_defaultValue);
      this._defaultValue = defaultValue;
      this._asciiMap = CharacterClassifier._createAsciiMap(defaultValue);
      this._map = /* @__PURE__ */ new Map();
    }
    static _createAsciiMap(defaultValue) {
      const asciiMap = new Uint8Array(256);
      asciiMap.fill(defaultValue);
      return asciiMap;
    }
    set(charCode, _value) {
      const value = toUint8(_value);
      if (charCode >= 0 && charCode < 256) {
        this._asciiMap[charCode] = value;
      } else {
        this._map.set(charCode, value);
      }
    }
    get(charCode) {
      if (charCode >= 0 && charCode < 256) {
        return this._asciiMap[charCode];
      } else {
        return this._map.get(charCode) || this._defaultValue;
      }
    }
    clear() {
      this._asciiMap.fill(this._defaultValue);
      this._map.clear();
    }
  }
  class Uint8Matrix {
    constructor(rows, cols, defaultValue) {
      const data2 = new Uint8Array(rows * cols);
      for (let i = 0, len2 = rows * cols; i < len2; i++) {
        data2[i] = defaultValue;
      }
      this._data = data2;
      this.rows = rows;
      this.cols = cols;
    }
    get(row, col) {
      return this._data[row * this.cols + col];
    }
    set(row, col, value) {
      this._data[row * this.cols + col] = value;
    }
  }
  class StateMachine {
    constructor(edges) {
      let maxCharCode = 0;
      let maxState = 0;
      for (let i = 0, len2 = edges.length; i < len2; i++) {
        const [from, chCode, to] = edges[i];
        if (chCode > maxCharCode) {
          maxCharCode = chCode;
        }
        if (from > maxState) {
          maxState = from;
        }
        if (to > maxState) {
          maxState = to;
        }
      }
      maxCharCode++;
      maxState++;
      const states = new Uint8Matrix(
        maxState,
        maxCharCode,
        0
        /* State.Invalid */
      );
      for (let i = 0, len2 = edges.length; i < len2; i++) {
        const [from, chCode, to] = edges[i];
        states.set(from, chCode, to);
      }
      this._states = states;
      this._maxCharCode = maxCharCode;
    }
    nextState(currentState, chCode) {
      if (chCode < 0 || chCode >= this._maxCharCode) {
        return 0;
      }
      return this._states.get(currentState, chCode);
    }
  }
  let _stateMachine = null;
  function getStateMachine() {
    if (_stateMachine === null) {
      _stateMachine = new StateMachine([
        [
          1,
          104,
          2
          /* State.H */
        ],
        [
          1,
          72,
          2
          /* State.H */
        ],
        [
          1,
          102,
          6
          /* State.F */
        ],
        [
          1,
          70,
          6
          /* State.F */
        ],
        [
          2,
          116,
          3
          /* State.HT */
        ],
        [
          2,
          84,
          3
          /* State.HT */
        ],
        [
          3,
          116,
          4
          /* State.HTT */
        ],
        [
          3,
          84,
          4
          /* State.HTT */
        ],
        [
          4,
          112,
          5
          /* State.HTTP */
        ],
        [
          4,
          80,
          5
          /* State.HTTP */
        ],
        [
          5,
          115,
          9
          /* State.BeforeColon */
        ],
        [
          5,
          83,
          9
          /* State.BeforeColon */
        ],
        [
          5,
          58,
          10
          /* State.AfterColon */
        ],
        [
          6,
          105,
          7
          /* State.FI */
        ],
        [
          6,
          73,
          7
          /* State.FI */
        ],
        [
          7,
          108,
          8
          /* State.FIL */
        ],
        [
          7,
          76,
          8
          /* State.FIL */
        ],
        [
          8,
          101,
          9
          /* State.BeforeColon */
        ],
        [
          8,
          69,
          9
          /* State.BeforeColon */
        ],
        [
          9,
          58,
          10
          /* State.AfterColon */
        ],
        [
          10,
          47,
          11
          /* State.AlmostThere */
        ],
        [
          11,
          47,
          12
          /* State.End */
        ]
      ]);
    }
    return _stateMachine;
  }
  let _classifier = null;
  function getClassifier() {
    if (_classifier === null) {
      _classifier = new CharacterClassifier(
        0
        /* CharacterClass.None */
      );
      const FORCE_TERMINATION_CHARACTERS = ` 	<>'"、。｡､，．：；‘〈「『〔（［｛｢｣｝］）〕』」〉’｀～…`;
      for (let i = 0; i < FORCE_TERMINATION_CHARACTERS.length; i++) {
        _classifier.set(
          FORCE_TERMINATION_CHARACTERS.charCodeAt(i),
          1
          /* CharacterClass.ForceTermination */
        );
      }
      const CANNOT_END_WITH_CHARACTERS = ".,;:";
      for (let i = 0; i < CANNOT_END_WITH_CHARACTERS.length; i++) {
        _classifier.set(
          CANNOT_END_WITH_CHARACTERS.charCodeAt(i),
          2
          /* CharacterClass.CannotEndIn */
        );
      }
    }
    return _classifier;
  }
  class LinkComputer {
    static _createLink(classifier, line, lineNumber, linkBeginIndex, linkEndIndex) {
      let lastIncludedCharIndex = linkEndIndex - 1;
      do {
        const chCode = line.charCodeAt(lastIncludedCharIndex);
        const chClass = classifier.get(chCode);
        if (chClass !== 2) {
          break;
        }
        lastIncludedCharIndex--;
      } while (lastIncludedCharIndex > linkBeginIndex);
      if (linkBeginIndex > 0) {
        const charCodeBeforeLink = line.charCodeAt(linkBeginIndex - 1);
        const lastCharCodeInLink = line.charCodeAt(lastIncludedCharIndex);
        if (charCodeBeforeLink === 40 && lastCharCodeInLink === 41 || charCodeBeforeLink === 91 && lastCharCodeInLink === 93 || charCodeBeforeLink === 123 && lastCharCodeInLink === 125) {
          lastIncludedCharIndex--;
        }
      }
      return {
        range: {
          startLineNumber: lineNumber,
          startColumn: linkBeginIndex + 1,
          endLineNumber: lineNumber,
          endColumn: lastIncludedCharIndex + 2
        },
        url: line.substring(linkBeginIndex, lastIncludedCharIndex + 1)
      };
    }
    static computeLinks(model2, stateMachine = getStateMachine()) {
      const classifier = getClassifier();
      const result = [];
      for (let i = 1, lineCount = model2.getLineCount(); i <= lineCount; i++) {
        const line = model2.getLineContent(i);
        const len2 = line.length;
        let j = 0;
        let linkBeginIndex = 0;
        let linkBeginChCode = 0;
        let state = 1;
        let hasOpenParens = false;
        let hasOpenSquareBracket = false;
        let inSquareBrackets = false;
        let hasOpenCurlyBracket = false;
        while (j < len2) {
          let resetStateMachine = false;
          const chCode = line.charCodeAt(j);
          if (state === 13) {
            let chClass;
            switch (chCode) {
              case 40:
                hasOpenParens = true;
                chClass = 0;
                break;
              case 41:
                chClass = hasOpenParens ? 0 : 1;
                break;
              case 91:
                inSquareBrackets = true;
                hasOpenSquareBracket = true;
                chClass = 0;
                break;
              case 93:
                inSquareBrackets = false;
                chClass = hasOpenSquareBracket ? 0 : 1;
                break;
              case 123:
                hasOpenCurlyBracket = true;
                chClass = 0;
                break;
              case 125:
                chClass = hasOpenCurlyBracket ? 0 : 1;
                break;
              case 39:
              case 34:
              case 96:
                if (linkBeginChCode === chCode) {
                  chClass = 1;
                } else if (linkBeginChCode === 39 || linkBeginChCode === 34 || linkBeginChCode === 96) {
                  chClass = 0;
                } else {
                  chClass = 1;
                }
                break;
              case 42:
                chClass = linkBeginChCode === 42 ? 1 : 0;
                break;
              case 124:
                chClass = linkBeginChCode === 124 ? 1 : 0;
                break;
              case 32:
                chClass = inSquareBrackets ? 0 : 1;
                break;
              default:
                chClass = classifier.get(chCode);
            }
            if (chClass === 1) {
              result.push(LinkComputer._createLink(classifier, line, i, linkBeginIndex, j));
              resetStateMachine = true;
            }
          } else if (state === 12) {
            let chClass;
            if (chCode === 91) {
              hasOpenSquareBracket = true;
              chClass = 0;
            } else {
              chClass = classifier.get(chCode);
            }
            if (chClass === 1) {
              resetStateMachine = true;
            } else {
              state = 13;
            }
          } else {
            state = stateMachine.nextState(state, chCode);
            if (state === 0) {
              resetStateMachine = true;
            }
          }
          if (resetStateMachine) {
            state = 1;
            hasOpenParens = false;
            hasOpenSquareBracket = false;
            hasOpenCurlyBracket = false;
            linkBeginIndex = j + 1;
            linkBeginChCode = chCode;
          }
          j++;
        }
        if (state === 13) {
          result.push(LinkComputer._createLink(classifier, line, i, linkBeginIndex, len2));
        }
      }
      return result;
    }
  }
  function computeLinks(model2) {
    if (!model2 || typeof model2.getLineCount !== "function" || typeof model2.getLineContent !== "function") {
      return [];
    }
    return LinkComputer.computeLinks(model2);
  }
  class BasicInplaceReplace {
    constructor() {
      this._defaultValueSet = [
        ["true", "false"],
        ["True", "False"],
        ["Private", "Public", "Friend", "ReadOnly", "Partial", "Protected", "WriteOnly"],
        ["public", "protected", "private"]
      ];
    }
    navigateValueSet(range1, text1, range2, text2, up) {
      if (range1 && text1) {
        const result = this.doNavigateValueSet(text1, up);
        if (result) {
          return {
            range: range1,
            value: result
          };
        }
      }
      if (range2 && text2) {
        const result = this.doNavigateValueSet(text2, up);
        if (result) {
          return {
            range: range2,
            value: result
          };
        }
      }
      return null;
    }
    doNavigateValueSet(text2, up) {
      const numberResult = this.numberReplace(text2, up);
      if (numberResult !== null) {
        return numberResult;
      }
      return this.textReplace(text2, up);
    }
    numberReplace(value, up) {
      const precision = Math.pow(10, value.length - (value.lastIndexOf(".") + 1));
      let n1 = Number(value);
      const n2 = parseFloat(value);
      if (!isNaN(n1) && !isNaN(n2) && n1 === n2) {
        if (n1 === 0 && !up) {
          return null;
        } else {
          n1 = Math.floor(n1 * precision);
          n1 += up ? precision : -precision;
          return String(n1 / precision);
        }
      }
      return null;
    }
    textReplace(value, up) {
      return this.valueSetsReplace(this._defaultValueSet, value, up);
    }
    valueSetsReplace(valueSets, value, up) {
      let result = null;
      for (let i = 0, len2 = valueSets.length; result === null && i < len2; i++) {
        result = this.valueSetReplace(valueSets[i], value, up);
      }
      return result;
    }
    valueSetReplace(valueSet, value, up) {
      let idx = valueSet.indexOf(value);
      if (idx >= 0) {
        idx += up ? 1 : -1;
        if (idx < 0) {
          idx = valueSet.length - 1;
        } else {
          idx %= valueSet.length;
        }
        return valueSet[idx];
      }
      return null;
    }
  }
  BasicInplaceReplace.INSTANCE = new BasicInplaceReplace();
  const shortcutEvent = Object.freeze(function(callback, context) {
    const handle = setTimeout(callback.bind(context), 0);
    return { dispose() {
      clearTimeout(handle);
    } };
  });
  var CancellationToken;
  (function(CancellationToken2) {
    function isCancellationToken(thing) {
      if (thing === CancellationToken2.None || thing === CancellationToken2.Cancelled) {
        return true;
      }
      if (thing instanceof MutableToken) {
        return true;
      }
      if (!thing || typeof thing !== "object") {
        return false;
      }
      return typeof thing.isCancellationRequested === "boolean" && typeof thing.onCancellationRequested === "function";
    }
    CancellationToken2.isCancellationToken = isCancellationToken;
    CancellationToken2.None = Object.freeze({
      isCancellationRequested: false,
      onCancellationRequested: Event.None
    });
    CancellationToken2.Cancelled = Object.freeze({
      isCancellationRequested: true,
      onCancellationRequested: shortcutEvent
    });
  })(CancellationToken || (CancellationToken = {}));
  class MutableToken {
    constructor() {
      this._isCancelled = false;
      this._emitter = null;
    }
    cancel() {
      if (!this._isCancelled) {
        this._isCancelled = true;
        if (this._emitter) {
          this._emitter.fire(void 0);
          this.dispose();
        }
      }
    }
    get isCancellationRequested() {
      return this._isCancelled;
    }
    get onCancellationRequested() {
      if (this._isCancelled) {
        return shortcutEvent;
      }
      if (!this._emitter) {
        this._emitter = new Emitter();
      }
      return this._emitter.event;
    }
    dispose() {
      if (this._emitter) {
        this._emitter.dispose();
        this._emitter = null;
      }
    }
  }
  class CancellationTokenSource {
    constructor(parent) {
      this._token = void 0;
      this._parentListener = void 0;
      this._parentListener = parent && parent.onCancellationRequested(this.cancel, this);
    }
    get token() {
      if (!this._token) {
        this._token = new MutableToken();
      }
      return this._token;
    }
    cancel() {
      if (!this._token) {
        this._token = CancellationToken.Cancelled;
      } else if (this._token instanceof MutableToken) {
        this._token.cancel();
      }
    }
    dispose(cancel = false) {
      var _a2;
      if (cancel) {
        this.cancel();
      }
      (_a2 = this._parentListener) === null || _a2 === void 0 ? void 0 : _a2.dispose();
      if (!this._token) {
        this._token = CancellationToken.None;
      } else if (this._token instanceof MutableToken) {
        this._token.dispose();
      }
    }
  }
  class KeyCodeStrMap {
    constructor() {
      this._keyCodeToStr = [];
      this._strToKeyCode = /* @__PURE__ */ Object.create(null);
    }
    define(keyCode, str2) {
      this._keyCodeToStr[keyCode] = str2;
      this._strToKeyCode[str2.toLowerCase()] = keyCode;
    }
    keyCodeToStr(keyCode) {
      return this._keyCodeToStr[keyCode];
    }
    strToKeyCode(str2) {
      return this._strToKeyCode[str2.toLowerCase()] || 0;
    }
  }
  const uiMap = new KeyCodeStrMap();
  const userSettingsUSMap = new KeyCodeStrMap();
  const userSettingsGeneralMap = new KeyCodeStrMap();
  const EVENT_KEY_CODE_MAP = new Array(230);
  const scanCodeStrToInt = /* @__PURE__ */ Object.create(null);
  const scanCodeLowerCaseStrToInt = /* @__PURE__ */ Object.create(null);
  (function() {
    const empty2 = "";
    const mappings = [
      // immutable, scanCode, scanCodeStr, keyCode, keyCodeStr, eventKeyCode, vkey, usUserSettingsLabel, generalUserSettingsLabel
      [1, 0, "None", 0, "unknown", 0, "VK_UNKNOWN", empty2, empty2],
      [1, 1, "Hyper", 0, empty2, 0, empty2, empty2, empty2],
      [1, 2, "Super", 0, empty2, 0, empty2, empty2, empty2],
      [1, 3, "Fn", 0, empty2, 0, empty2, empty2, empty2],
      [1, 4, "FnLock", 0, empty2, 0, empty2, empty2, empty2],
      [1, 5, "Suspend", 0, empty2, 0, empty2, empty2, empty2],
      [1, 6, "Resume", 0, empty2, 0, empty2, empty2, empty2],
      [1, 7, "Turbo", 0, empty2, 0, empty2, empty2, empty2],
      [1, 8, "Sleep", 0, empty2, 0, "VK_SLEEP", empty2, empty2],
      [1, 9, "WakeUp", 0, empty2, 0, empty2, empty2, empty2],
      [0, 10, "KeyA", 31, "A", 65, "VK_A", empty2, empty2],
      [0, 11, "KeyB", 32, "B", 66, "VK_B", empty2, empty2],
      [0, 12, "KeyC", 33, "C", 67, "VK_C", empty2, empty2],
      [0, 13, "KeyD", 34, "D", 68, "VK_D", empty2, empty2],
      [0, 14, "KeyE", 35, "E", 69, "VK_E", empty2, empty2],
      [0, 15, "KeyF", 36, "F", 70, "VK_F", empty2, empty2],
      [0, 16, "KeyG", 37, "G", 71, "VK_G", empty2, empty2],
      [0, 17, "KeyH", 38, "H", 72, "VK_H", empty2, empty2],
      [0, 18, "KeyI", 39, "I", 73, "VK_I", empty2, empty2],
      [0, 19, "KeyJ", 40, "J", 74, "VK_J", empty2, empty2],
      [0, 20, "KeyK", 41, "K", 75, "VK_K", empty2, empty2],
      [0, 21, "KeyL", 42, "L", 76, "VK_L", empty2, empty2],
      [0, 22, "KeyM", 43, "M", 77, "VK_M", empty2, empty2],
      [0, 23, "KeyN", 44, "N", 78, "VK_N", empty2, empty2],
      [0, 24, "KeyO", 45, "O", 79, "VK_O", empty2, empty2],
      [0, 25, "KeyP", 46, "P", 80, "VK_P", empty2, empty2],
      [0, 26, "KeyQ", 47, "Q", 81, "VK_Q", empty2, empty2],
      [0, 27, "KeyR", 48, "R", 82, "VK_R", empty2, empty2],
      [0, 28, "KeyS", 49, "S", 83, "VK_S", empty2, empty2],
      [0, 29, "KeyT", 50, "T", 84, "VK_T", empty2, empty2],
      [0, 30, "KeyU", 51, "U", 85, "VK_U", empty2, empty2],
      [0, 31, "KeyV", 52, "V", 86, "VK_V", empty2, empty2],
      [0, 32, "KeyW", 53, "W", 87, "VK_W", empty2, empty2],
      [0, 33, "KeyX", 54, "X", 88, "VK_X", empty2, empty2],
      [0, 34, "KeyY", 55, "Y", 89, "VK_Y", empty2, empty2],
      [0, 35, "KeyZ", 56, "Z", 90, "VK_Z", empty2, empty2],
      [0, 36, "Digit1", 22, "1", 49, "VK_1", empty2, empty2],
      [0, 37, "Digit2", 23, "2", 50, "VK_2", empty2, empty2],
      [0, 38, "Digit3", 24, "3", 51, "VK_3", empty2, empty2],
      [0, 39, "Digit4", 25, "4", 52, "VK_4", empty2, empty2],
      [0, 40, "Digit5", 26, "5", 53, "VK_5", empty2, empty2],
      [0, 41, "Digit6", 27, "6", 54, "VK_6", empty2, empty2],
      [0, 42, "Digit7", 28, "7", 55, "VK_7", empty2, empty2],
      [0, 43, "Digit8", 29, "8", 56, "VK_8", empty2, empty2],
      [0, 44, "Digit9", 30, "9", 57, "VK_9", empty2, empty2],
      [0, 45, "Digit0", 21, "0", 48, "VK_0", empty2, empty2],
      [1, 46, "Enter", 3, "Enter", 13, "VK_RETURN", empty2, empty2],
      [1, 47, "Escape", 9, "Escape", 27, "VK_ESCAPE", empty2, empty2],
      [1, 48, "Backspace", 1, "Backspace", 8, "VK_BACK", empty2, empty2],
      [1, 49, "Tab", 2, "Tab", 9, "VK_TAB", empty2, empty2],
      [1, 50, "Space", 10, "Space", 32, "VK_SPACE", empty2, empty2],
      [0, 51, "Minus", 88, "-", 189, "VK_OEM_MINUS", "-", "OEM_MINUS"],
      [0, 52, "Equal", 86, "=", 187, "VK_OEM_PLUS", "=", "OEM_PLUS"],
      [0, 53, "BracketLeft", 92, "[", 219, "VK_OEM_4", "[", "OEM_4"],
      [0, 54, "BracketRight", 94, "]", 221, "VK_OEM_6", "]", "OEM_6"],
      [0, 55, "Backslash", 93, "\\", 220, "VK_OEM_5", "\\", "OEM_5"],
      [0, 56, "IntlHash", 0, empty2, 0, empty2, empty2, empty2],
      [0, 57, "Semicolon", 85, ";", 186, "VK_OEM_1", ";", "OEM_1"],
      [0, 58, "Quote", 95, "'", 222, "VK_OEM_7", "'", "OEM_7"],
      [0, 59, "Backquote", 91, "`", 192, "VK_OEM_3", "`", "OEM_3"],
      [0, 60, "Comma", 87, ",", 188, "VK_OEM_COMMA", ",", "OEM_COMMA"],
      [0, 61, "Period", 89, ".", 190, "VK_OEM_PERIOD", ".", "OEM_PERIOD"],
      [0, 62, "Slash", 90, "/", 191, "VK_OEM_2", "/", "OEM_2"],
      [1, 63, "CapsLock", 8, "CapsLock", 20, "VK_CAPITAL", empty2, empty2],
      [1, 64, "F1", 59, "F1", 112, "VK_F1", empty2, empty2],
      [1, 65, "F2", 60, "F2", 113, "VK_F2", empty2, empty2],
      [1, 66, "F3", 61, "F3", 114, "VK_F3", empty2, empty2],
      [1, 67, "F4", 62, "F4", 115, "VK_F4", empty2, empty2],
      [1, 68, "F5", 63, "F5", 116, "VK_F5", empty2, empty2],
      [1, 69, "F6", 64, "F6", 117, "VK_F6", empty2, empty2],
      [1, 70, "F7", 65, "F7", 118, "VK_F7", empty2, empty2],
      [1, 71, "F8", 66, "F8", 119, "VK_F8", empty2, empty2],
      [1, 72, "F9", 67, "F9", 120, "VK_F9", empty2, empty2],
      [1, 73, "F10", 68, "F10", 121, "VK_F10", empty2, empty2],
      [1, 74, "F11", 69, "F11", 122, "VK_F11", empty2, empty2],
      [1, 75, "F12", 70, "F12", 123, "VK_F12", empty2, empty2],
      [1, 76, "PrintScreen", 0, empty2, 0, empty2, empty2, empty2],
      [1, 77, "ScrollLock", 84, "ScrollLock", 145, "VK_SCROLL", empty2, empty2],
      [1, 78, "Pause", 7, "PauseBreak", 19, "VK_PAUSE", empty2, empty2],
      [1, 79, "Insert", 19, "Insert", 45, "VK_INSERT", empty2, empty2],
      [1, 80, "Home", 14, "Home", 36, "VK_HOME", empty2, empty2],
      [1, 81, "PageUp", 11, "PageUp", 33, "VK_PRIOR", empty2, empty2],
      [1, 82, "Delete", 20, "Delete", 46, "VK_DELETE", empty2, empty2],
      [1, 83, "End", 13, "End", 35, "VK_END", empty2, empty2],
      [1, 84, "PageDown", 12, "PageDown", 34, "VK_NEXT", empty2, empty2],
      [1, 85, "ArrowRight", 17, "RightArrow", 39, "VK_RIGHT", "Right", empty2],
      [1, 86, "ArrowLeft", 15, "LeftArrow", 37, "VK_LEFT", "Left", empty2],
      [1, 87, "ArrowDown", 18, "DownArrow", 40, "VK_DOWN", "Down", empty2],
      [1, 88, "ArrowUp", 16, "UpArrow", 38, "VK_UP", "Up", empty2],
      [1, 89, "NumLock", 83, "NumLock", 144, "VK_NUMLOCK", empty2, empty2],
      [1, 90, "NumpadDivide", 113, "NumPad_Divide", 111, "VK_DIVIDE", empty2, empty2],
      [1, 91, "NumpadMultiply", 108, "NumPad_Multiply", 106, "VK_MULTIPLY", empty2, empty2],
      [1, 92, "NumpadSubtract", 111, "NumPad_Subtract", 109, "VK_SUBTRACT", empty2, empty2],
      [1, 93, "NumpadAdd", 109, "NumPad_Add", 107, "VK_ADD", empty2, empty2],
      [1, 94, "NumpadEnter", 3, empty2, 0, empty2, empty2, empty2],
      [1, 95, "Numpad1", 99, "NumPad1", 97, "VK_NUMPAD1", empty2, empty2],
      [1, 96, "Numpad2", 100, "NumPad2", 98, "VK_NUMPAD2", empty2, empty2],
      [1, 97, "Numpad3", 101, "NumPad3", 99, "VK_NUMPAD3", empty2, empty2],
      [1, 98, "Numpad4", 102, "NumPad4", 100, "VK_NUMPAD4", empty2, empty2],
      [1, 99, "Numpad5", 103, "NumPad5", 101, "VK_NUMPAD5", empty2, empty2],
      [1, 100, "Numpad6", 104, "NumPad6", 102, "VK_NUMPAD6", empty2, empty2],
      [1, 101, "Numpad7", 105, "NumPad7", 103, "VK_NUMPAD7", empty2, empty2],
      [1, 102, "Numpad8", 106, "NumPad8", 104, "VK_NUMPAD8", empty2, empty2],
      [1, 103, "Numpad9", 107, "NumPad9", 105, "VK_NUMPAD9", empty2, empty2],
      [1, 104, "Numpad0", 98, "NumPad0", 96, "VK_NUMPAD0", empty2, empty2],
      [1, 105, "NumpadDecimal", 112, "NumPad_Decimal", 110, "VK_DECIMAL", empty2, empty2],
      [0, 106, "IntlBackslash", 97, "OEM_102", 226, "VK_OEM_102", empty2, empty2],
      [1, 107, "ContextMenu", 58, "ContextMenu", 93, empty2, empty2, empty2],
      [1, 108, "Power", 0, empty2, 0, empty2, empty2, empty2],
      [1, 109, "NumpadEqual", 0, empty2, 0, empty2, empty2, empty2],
      [1, 110, "F13", 71, "F13", 124, "VK_F13", empty2, empty2],
      [1, 111, "F14", 72, "F14", 125, "VK_F14", empty2, empty2],
      [1, 112, "F15", 73, "F15", 126, "VK_F15", empty2, empty2],
      [1, 113, "F16", 74, "F16", 127, "VK_F16", empty2, empty2],
      [1, 114, "F17", 75, "F17", 128, "VK_F17", empty2, empty2],
      [1, 115, "F18", 76, "F18", 129, "VK_F18", empty2, empty2],
      [1, 116, "F19", 77, "F19", 130, "VK_F19", empty2, empty2],
      [1, 117, "F20", 78, "F20", 131, "VK_F20", empty2, empty2],
      [1, 118, "F21", 79, "F21", 132, "VK_F21", empty2, empty2],
      [1, 119, "F22", 80, "F22", 133, "VK_F22", empty2, empty2],
      [1, 120, "F23", 81, "F23", 134, "VK_F23", empty2, empty2],
      [1, 121, "F24", 82, "F24", 135, "VK_F24", empty2, empty2],
      [1, 122, "Open", 0, empty2, 0, empty2, empty2, empty2],
      [1, 123, "Help", 0, empty2, 0, empty2, empty2, empty2],
      [1, 124, "Select", 0, empty2, 0, empty2, empty2, empty2],
      [1, 125, "Again", 0, empty2, 0, empty2, empty2, empty2],
      [1, 126, "Undo", 0, empty2, 0, empty2, empty2, empty2],
      [1, 127, "Cut", 0, empty2, 0, empty2, empty2, empty2],
      [1, 128, "Copy", 0, empty2, 0, empty2, empty2, empty2],
      [1, 129, "Paste", 0, empty2, 0, empty2, empty2, empty2],
      [1, 130, "Find", 0, empty2, 0, empty2, empty2, empty2],
      [1, 131, "AudioVolumeMute", 117, "AudioVolumeMute", 173, "VK_VOLUME_MUTE", empty2, empty2],
      [1, 132, "AudioVolumeUp", 118, "AudioVolumeUp", 175, "VK_VOLUME_UP", empty2, empty2],
      [1, 133, "AudioVolumeDown", 119, "AudioVolumeDown", 174, "VK_VOLUME_DOWN", empty2, empty2],
      [1, 134, "NumpadComma", 110, "NumPad_Separator", 108, "VK_SEPARATOR", empty2, empty2],
      [0, 135, "IntlRo", 115, "ABNT_C1", 193, "VK_ABNT_C1", empty2, empty2],
      [1, 136, "KanaMode", 0, empty2, 0, empty2, empty2, empty2],
      [0, 137, "IntlYen", 0, empty2, 0, empty2, empty2, empty2],
      [1, 138, "Convert", 0, empty2, 0, empty2, empty2, empty2],
      [1, 139, "NonConvert", 0, empty2, 0, empty2, empty2, empty2],
      [1, 140, "Lang1", 0, empty2, 0, empty2, empty2, empty2],
      [1, 141, "Lang2", 0, empty2, 0, empty2, empty2, empty2],
      [1, 142, "Lang3", 0, empty2, 0, empty2, empty2, empty2],
      [1, 143, "Lang4", 0, empty2, 0, empty2, empty2, empty2],
      [1, 144, "Lang5", 0, empty2, 0, empty2, empty2, empty2],
      [1, 145, "Abort", 0, empty2, 0, empty2, empty2, empty2],
      [1, 146, "Props", 0, empty2, 0, empty2, empty2, empty2],
      [1, 147, "NumpadParenLeft", 0, empty2, 0, empty2, empty2, empty2],
      [1, 148, "NumpadParenRight", 0, empty2, 0, empty2, empty2, empty2],
      [1, 149, "NumpadBackspace", 0, empty2, 0, empty2, empty2, empty2],
      [1, 150, "NumpadMemoryStore", 0, empty2, 0, empty2, empty2, empty2],
      [1, 151, "NumpadMemoryRecall", 0, empty2, 0, empty2, empty2, empty2],
      [1, 152, "NumpadMemoryClear", 0, empty2, 0, empty2, empty2, empty2],
      [1, 153, "NumpadMemoryAdd", 0, empty2, 0, empty2, empty2, empty2],
      [1, 154, "NumpadMemorySubtract", 0, empty2, 0, empty2, empty2, empty2],
      [1, 155, "NumpadClear", 131, "Clear", 12, "VK_CLEAR", empty2, empty2],
      [1, 156, "NumpadClearEntry", 0, empty2, 0, empty2, empty2, empty2],
      [1, 0, empty2, 5, "Ctrl", 17, "VK_CONTROL", empty2, empty2],
      [1, 0, empty2, 4, "Shift", 16, "VK_SHIFT", empty2, empty2],
      [1, 0, empty2, 6, "Alt", 18, "VK_MENU", empty2, empty2],
      [1, 0, empty2, 57, "Meta", 91, "VK_COMMAND", empty2, empty2],
      [1, 157, "ControlLeft", 5, empty2, 0, "VK_LCONTROL", empty2, empty2],
      [1, 158, "ShiftLeft", 4, empty2, 0, "VK_LSHIFT", empty2, empty2],
      [1, 159, "AltLeft", 6, empty2, 0, "VK_LMENU", empty2, empty2],
      [1, 160, "MetaLeft", 57, empty2, 0, "VK_LWIN", empty2, empty2],
      [1, 161, "ControlRight", 5, empty2, 0, "VK_RCONTROL", empty2, empty2],
      [1, 162, "ShiftRight", 4, empty2, 0, "VK_RSHIFT", empty2, empty2],
      [1, 163, "AltRight", 6, empty2, 0, "VK_RMENU", empty2, empty2],
      [1, 164, "MetaRight", 57, empty2, 0, "VK_RWIN", empty2, empty2],
      [1, 165, "BrightnessUp", 0, empty2, 0, empty2, empty2, empty2],
      [1, 166, "BrightnessDown", 0, empty2, 0, empty2, empty2, empty2],
      [1, 167, "MediaPlay", 0, empty2, 0, empty2, empty2, empty2],
      [1, 168, "MediaRecord", 0, empty2, 0, empty2, empty2, empty2],
      [1, 169, "MediaFastForward", 0, empty2, 0, empty2, empty2, empty2],
      [1, 170, "MediaRewind", 0, empty2, 0, empty2, empty2, empty2],
      [1, 171, "MediaTrackNext", 124, "MediaTrackNext", 176, "VK_MEDIA_NEXT_TRACK", empty2, empty2],
      [1, 172, "MediaTrackPrevious", 125, "MediaTrackPrevious", 177, "VK_MEDIA_PREV_TRACK", empty2, empty2],
      [1, 173, "MediaStop", 126, "MediaStop", 178, "VK_MEDIA_STOP", empty2, empty2],
      [1, 174, "Eject", 0, empty2, 0, empty2, empty2, empty2],
      [1, 175, "MediaPlayPause", 127, "MediaPlayPause", 179, "VK_MEDIA_PLAY_PAUSE", empty2, empty2],
      [1, 176, "MediaSelect", 128, "LaunchMediaPlayer", 181, "VK_MEDIA_LAUNCH_MEDIA_SELECT", empty2, empty2],
      [1, 177, "LaunchMail", 129, "LaunchMail", 180, "VK_MEDIA_LAUNCH_MAIL", empty2, empty2],
      [1, 178, "LaunchApp2", 130, "LaunchApp2", 183, "VK_MEDIA_LAUNCH_APP2", empty2, empty2],
      [1, 179, "LaunchApp1", 0, empty2, 0, "VK_MEDIA_LAUNCH_APP1", empty2, empty2],
      [1, 180, "SelectTask", 0, empty2, 0, empty2, empty2, empty2],
      [1, 181, "LaunchScreenSaver", 0, empty2, 0, empty2, empty2, empty2],
      [1, 182, "BrowserSearch", 120, "BrowserSearch", 170, "VK_BROWSER_SEARCH", empty2, empty2],
      [1, 183, "BrowserHome", 121, "BrowserHome", 172, "VK_BROWSER_HOME", empty2, empty2],
      [1, 184, "BrowserBack", 122, "BrowserBack", 166, "VK_BROWSER_BACK", empty2, empty2],
      [1, 185, "BrowserForward", 123, "BrowserForward", 167, "VK_BROWSER_FORWARD", empty2, empty2],
      [1, 186, "BrowserStop", 0, empty2, 0, "VK_BROWSER_STOP", empty2, empty2],
      [1, 187, "BrowserRefresh", 0, empty2, 0, "VK_BROWSER_REFRESH", empty2, empty2],
      [1, 188, "BrowserFavorites", 0, empty2, 0, "VK_BROWSER_FAVORITES", empty2, empty2],
      [1, 189, "ZoomToggle", 0, empty2, 0, empty2, empty2, empty2],
      [1, 190, "MailReply", 0, empty2, 0, empty2, empty2, empty2],
      [1, 191, "MailForward", 0, empty2, 0, empty2, empty2, empty2],
      [1, 192, "MailSend", 0, empty2, 0, empty2, empty2, empty2],
      // See https://lists.w3.org/Archives/Public/www-dom/2010JulSep/att-0182/keyCode-spec.html
      // If an Input Method Editor is processing key input and the event is keydown, return 229.
      [1, 0, empty2, 114, "KeyInComposition", 229, empty2, empty2, empty2],
      [1, 0, empty2, 116, "ABNT_C2", 194, "VK_ABNT_C2", empty2, empty2],
      [1, 0, empty2, 96, "OEM_8", 223, "VK_OEM_8", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_KANA", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_HANGUL", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_JUNJA", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_FINAL", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_HANJA", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_KANJI", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_CONVERT", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_NONCONVERT", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_ACCEPT", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_MODECHANGE", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_SELECT", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_PRINT", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_EXECUTE", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_SNAPSHOT", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_HELP", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_APPS", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_PROCESSKEY", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_PACKET", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_DBE_SBCSCHAR", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_DBE_DBCSCHAR", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_ATTN", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_CRSEL", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_EXSEL", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_EREOF", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_PLAY", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_ZOOM", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_NONAME", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_PA1", empty2, empty2],
      [1, 0, empty2, 0, empty2, 0, "VK_OEM_CLEAR", empty2, empty2]
    ];
    const seenKeyCode = [];
    const seenScanCode = [];
    for (const mapping of mappings) {
      const [immutable, scanCode, scanCodeStr, keyCode, keyCodeStr, eventKeyCode, vkey, usUserSettingsLabel, generalUserSettingsLabel] = mapping;
      if (!seenScanCode[scanCode]) {
        seenScanCode[scanCode] = true;
        scanCodeStrToInt[scanCodeStr] = scanCode;
        scanCodeLowerCaseStrToInt[scanCodeStr.toLowerCase()] = scanCode;
      }
      if (!seenKeyCode[keyCode]) {
        seenKeyCode[keyCode] = true;
        if (!keyCodeStr) {
          throw new Error(`String representation missing for key code ${keyCode} around scan code ${scanCodeStr}`);
        }
        uiMap.define(keyCode, keyCodeStr);
        userSettingsUSMap.define(keyCode, usUserSettingsLabel || keyCodeStr);
        userSettingsGeneralMap.define(keyCode, generalUserSettingsLabel || usUserSettingsLabel || keyCodeStr);
      }
      if (eventKeyCode) {
        EVENT_KEY_CODE_MAP[eventKeyCode] = keyCode;
      }
    }
  })();
  var KeyCodeUtils;
  (function(KeyCodeUtils2) {
    function toString2(keyCode) {
      return uiMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils2.toString = toString2;
    function fromString(key) {
      return uiMap.strToKeyCode(key);
    }
    KeyCodeUtils2.fromString = fromString;
    function toUserSettingsUS(keyCode) {
      return userSettingsUSMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils2.toUserSettingsUS = toUserSettingsUS;
    function toUserSettingsGeneral(keyCode) {
      return userSettingsGeneralMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils2.toUserSettingsGeneral = toUserSettingsGeneral;
    function fromUserSettings(key) {
      return userSettingsUSMap.strToKeyCode(key) || userSettingsGeneralMap.strToKeyCode(key);
    }
    KeyCodeUtils2.fromUserSettings = fromUserSettings;
    function toElectronAccelerator(keyCode) {
      if (keyCode >= 98 && keyCode <= 113) {
        return null;
      }
      switch (keyCode) {
        case 16:
          return "Up";
        case 18:
          return "Down";
        case 15:
          return "Left";
        case 17:
          return "Right";
      }
      return uiMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils2.toElectronAccelerator = toElectronAccelerator;
  })(KeyCodeUtils || (KeyCodeUtils = {}));
  function KeyChord(firstPart, secondPart) {
    const chordPart = (secondPart & 65535) << 16 >>> 0;
    return (firstPart | chordPart) >>> 0;
  }
  class Selection extends Range$b {
    constructor(selectionStartLineNumber, selectionStartColumn, positionLineNumber, positionColumn) {
      super(selectionStartLineNumber, selectionStartColumn, positionLineNumber, positionColumn);
      this.selectionStartLineNumber = selectionStartLineNumber;
      this.selectionStartColumn = selectionStartColumn;
      this.positionLineNumber = positionLineNumber;
      this.positionColumn = positionColumn;
    }
    /**
     * Transform to a human-readable representation.
     */
    toString() {
      return "[" + this.selectionStartLineNumber + "," + this.selectionStartColumn + " -> " + this.positionLineNumber + "," + this.positionColumn + "]";
    }
    /**
     * Test if equals other selection.
     */
    equalsSelection(other) {
      return Selection.selectionsEqual(this, other);
    }
    /**
     * Test if the two selections are equal.
     */
    static selectionsEqual(a2, b) {
      return a2.selectionStartLineNumber === b.selectionStartLineNumber && a2.selectionStartColumn === b.selectionStartColumn && a2.positionLineNumber === b.positionLineNumber && a2.positionColumn === b.positionColumn;
    }
    /**
     * Get directions (LTR or RTL).
     */
    getDirection() {
      if (this.selectionStartLineNumber === this.startLineNumber && this.selectionStartColumn === this.startColumn) {
        return 0;
      }
      return 1;
    }
    /**
     * Create a new selection with a different `positionLineNumber` and `positionColumn`.
     */
    setEndPosition(endLineNumber, endColumn) {
      if (this.getDirection() === 0) {
        return new Selection(this.startLineNumber, this.startColumn, endLineNumber, endColumn);
      }
      return new Selection(endLineNumber, endColumn, this.startLineNumber, this.startColumn);
    }
    /**
     * Get the position at `positionLineNumber` and `positionColumn`.
     */
    getPosition() {
      return new Position$1(this.positionLineNumber, this.positionColumn);
    }
    /**
     * Get the position at the start of the selection.
    */
    getSelectionStart() {
      return new Position$1(this.selectionStartLineNumber, this.selectionStartColumn);
    }
    /**
     * Create a new selection with a different `selectionStartLineNumber` and `selectionStartColumn`.
     */
    setStartPosition(startLineNumber, startColumn) {
      if (this.getDirection() === 0) {
        return new Selection(startLineNumber, startColumn, this.endLineNumber, this.endColumn);
      }
      return new Selection(this.endLineNumber, this.endColumn, startLineNumber, startColumn);
    }
    // ----
    /**
     * Create a `Selection` from one or two positions
     */
    static fromPositions(start, end = start) {
      return new Selection(start.lineNumber, start.column, end.lineNumber, end.column);
    }
    /**
     * Creates a `Selection` from a range, given a direction.
     */
    static fromRange(range2, direction) {
      if (direction === 0) {
        return new Selection(range2.startLineNumber, range2.startColumn, range2.endLineNumber, range2.endColumn);
      } else {
        return new Selection(range2.endLineNumber, range2.endColumn, range2.startLineNumber, range2.startColumn);
      }
    }
    /**
     * Create a `Selection` from an `ISelection`.
     */
    static liftSelection(sel) {
      return new Selection(sel.selectionStartLineNumber, sel.selectionStartColumn, sel.positionLineNumber, sel.positionColumn);
    }
    /**
     * `a` equals `b`.
     */
    static selectionsArrEqual(a2, b) {
      if (a2 && !b || !a2 && b) {
        return false;
      }
      if (!a2 && !b) {
        return true;
      }
      if (a2.length !== b.length) {
        return false;
      }
      for (let i = 0, len2 = a2.length; i < len2; i++) {
        if (!this.selectionsEqual(a2[i], b[i])) {
          return false;
        }
      }
      return true;
    }
    /**
     * Test if `obj` is an `ISelection`.
     */
    static isISelection(obj) {
      return obj && typeof obj.selectionStartLineNumber === "number" && typeof obj.selectionStartColumn === "number" && typeof obj.positionLineNumber === "number" && typeof obj.positionColumn === "number";
    }
    /**
     * Create with a direction.
     */
    static createWithDirection(startLineNumber, startColumn, endLineNumber, endColumn, direction) {
      if (direction === 0) {
        return new Selection(startLineNumber, startColumn, endLineNumber, endColumn);
      }
      return new Selection(endLineNumber, endColumn, startLineNumber, startColumn);
    }
  }
  const _codiconFontCharacters = /* @__PURE__ */ Object.create(null);
  function register$T(id, fontCharacter) {
    if (isString$2(fontCharacter)) {
      const val = _codiconFontCharacters[fontCharacter];
      if (val === void 0) {
        throw new Error(`${id} references an unknown codicon: ${fontCharacter}`);
      }
      fontCharacter = val;
    }
    _codiconFontCharacters[id] = fontCharacter;
    return { id };
  }
  const Codicon = {
    // built-in icons, with image name
    add: register$T("add", 6e4),
    plus: register$T("plus", 6e4),
    gistNew: register$T("gist-new", 6e4),
    repoCreate: register$T("repo-create", 6e4),
    lightbulb: register$T("lightbulb", 60001),
    lightBulb: register$T("light-bulb", 60001),
    repo: register$T("repo", 60002),
    repoDelete: register$T("repo-delete", 60002),
    gistFork: register$T("gist-fork", 60003),
    repoForked: register$T("repo-forked", 60003),
    gitPullRequest: register$T("git-pull-request", 60004),
    gitPullRequestAbandoned: register$T("git-pull-request-abandoned", 60004),
    recordKeys: register$T("record-keys", 60005),
    keyboard: register$T("keyboard", 60005),
    tag: register$T("tag", 60006),
    tagAdd: register$T("tag-add", 60006),
    tagRemove: register$T("tag-remove", 60006),
    person: register$T("person", 60007),
    personFollow: register$T("person-follow", 60007),
    personOutline: register$T("person-outline", 60007),
    personFilled: register$T("person-filled", 60007),
    gitBranch: register$T("git-branch", 60008),
    gitBranchCreate: register$T("git-branch-create", 60008),
    gitBranchDelete: register$T("git-branch-delete", 60008),
    sourceControl: register$T("source-control", 60008),
    mirror: register$T("mirror", 60009),
    mirrorPublic: register$T("mirror-public", 60009),
    star: register$T("star", 60010),
    starAdd: register$T("star-add", 60010),
    starDelete: register$T("star-delete", 60010),
    starEmpty: register$T("star-empty", 60010),
    comment: register$T("comment", 60011),
    commentAdd: register$T("comment-add", 60011),
    alert: register$T("alert", 60012),
    warning: register$T("warning", 60012),
    search: register$T("search", 60013),
    searchSave: register$T("search-save", 60013),
    logOut: register$T("log-out", 60014),
    signOut: register$T("sign-out", 60014),
    logIn: register$T("log-in", 60015),
    signIn: register$T("sign-in", 60015),
    eye: register$T("eye", 60016),
    eyeUnwatch: register$T("eye-unwatch", 60016),
    eyeWatch: register$T("eye-watch", 60016),
    circleFilled: register$T("circle-filled", 60017),
    primitiveDot: register$T("primitive-dot", 60017),
    closeDirty: register$T("close-dirty", 60017),
    debugBreakpoint: register$T("debug-breakpoint", 60017),
    debugBreakpointDisabled: register$T("debug-breakpoint-disabled", 60017),
    debugHint: register$T("debug-hint", 60017),
    primitiveSquare: register$T("primitive-square", 60018),
    edit: register$T("edit", 60019),
    pencil: register$T("pencil", 60019),
    info: register$T("info", 60020),
    issueOpened: register$T("issue-opened", 60020),
    gistPrivate: register$T("gist-private", 60021),
    gitForkPrivate: register$T("git-fork-private", 60021),
    lock: register$T("lock", 60021),
    mirrorPrivate: register$T("mirror-private", 60021),
    close: register$T("close", 60022),
    removeClose: register$T("remove-close", 60022),
    x: register$T("x", 60022),
    repoSync: register$T("repo-sync", 60023),
    sync: register$T("sync", 60023),
    clone: register$T("clone", 60024),
    desktopDownload: register$T("desktop-download", 60024),
    beaker: register$T("beaker", 60025),
    microscope: register$T("microscope", 60025),
    vm: register$T("vm", 60026),
    deviceDesktop: register$T("device-desktop", 60026),
    file: register$T("file", 60027),
    fileText: register$T("file-text", 60027),
    more: register$T("more", 60028),
    ellipsis: register$T("ellipsis", 60028),
    kebabHorizontal: register$T("kebab-horizontal", 60028),
    mailReply: register$T("mail-reply", 60029),
    reply: register$T("reply", 60029),
    organization: register$T("organization", 60030),
    organizationFilled: register$T("organization-filled", 60030),
    organizationOutline: register$T("organization-outline", 60030),
    newFile: register$T("new-file", 60031),
    fileAdd: register$T("file-add", 60031),
    newFolder: register$T("new-folder", 60032),
    fileDirectoryCreate: register$T("file-directory-create", 60032),
    trash: register$T("trash", 60033),
    trashcan: register$T("trashcan", 60033),
    history: register$T("history", 60034),
    clock: register$T("clock", 60034),
    folder: register$T("folder", 60035),
    fileDirectory: register$T("file-directory", 60035),
    symbolFolder: register$T("symbol-folder", 60035),
    logoGithub: register$T("logo-github", 60036),
    markGithub: register$T("mark-github", 60036),
    github: register$T("github", 60036),
    terminal: register$T("terminal", 60037),
    console: register$T("console", 60037),
    repl: register$T("repl", 60037),
    zap: register$T("zap", 60038),
    symbolEvent: register$T("symbol-event", 60038),
    error: register$T("error", 60039),
    stop: register$T("stop", 60039),
    variable: register$T("variable", 60040),
    symbolVariable: register$T("symbol-variable", 60040),
    array: register$T("array", 60042),
    symbolArray: register$T("symbol-array", 60042),
    symbolModule: register$T("symbol-module", 60043),
    symbolPackage: register$T("symbol-package", 60043),
    symbolNamespace: register$T("symbol-namespace", 60043),
    symbolObject: register$T("symbol-object", 60043),
    symbolMethod: register$T("symbol-method", 60044),
    symbolFunction: register$T("symbol-function", 60044),
    symbolConstructor: register$T("symbol-constructor", 60044),
    symbolBoolean: register$T("symbol-boolean", 60047),
    symbolNull: register$T("symbol-null", 60047),
    symbolNumeric: register$T("symbol-numeric", 60048),
    symbolNumber: register$T("symbol-number", 60048),
    symbolStructure: register$T("symbol-structure", 60049),
    symbolStruct: register$T("symbol-struct", 60049),
    symbolParameter: register$T("symbol-parameter", 60050),
    symbolTypeParameter: register$T("symbol-type-parameter", 60050),
    symbolKey: register$T("symbol-key", 60051),
    symbolText: register$T("symbol-text", 60051),
    symbolReference: register$T("symbol-reference", 60052),
    goToFile: register$T("go-to-file", 60052),
    symbolEnum: register$T("symbol-enum", 60053),
    symbolValue: register$T("symbol-value", 60053),
    symbolRuler: register$T("symbol-ruler", 60054),
    symbolUnit: register$T("symbol-unit", 60054),
    activateBreakpoints: register$T("activate-breakpoints", 60055),
    archive: register$T("archive", 60056),
    arrowBoth: register$T("arrow-both", 60057),
    arrowDown: register$T("arrow-down", 60058),
    arrowLeft: register$T("arrow-left", 60059),
    arrowRight: register$T("arrow-right", 60060),
    arrowSmallDown: register$T("arrow-small-down", 60061),
    arrowSmallLeft: register$T("arrow-small-left", 60062),
    arrowSmallRight: register$T("arrow-small-right", 60063),
    arrowSmallUp: register$T("arrow-small-up", 60064),
    arrowUp: register$T("arrow-up", 60065),
    bell: register$T("bell", 60066),
    bold: register$T("bold", 60067),
    book: register$T("book", 60068),
    bookmark: register$T("bookmark", 60069),
    debugBreakpointConditionalUnverified: register$T("debug-breakpoint-conditional-unverified", 60070),
    debugBreakpointConditional: register$T("debug-breakpoint-conditional", 60071),
    debugBreakpointConditionalDisabled: register$T("debug-breakpoint-conditional-disabled", 60071),
    debugBreakpointDataUnverified: register$T("debug-breakpoint-data-unverified", 60072),
    debugBreakpointData: register$T("debug-breakpoint-data", 60073),
    debugBreakpointDataDisabled: register$T("debug-breakpoint-data-disabled", 60073),
    debugBreakpointLogUnverified: register$T("debug-breakpoint-log-unverified", 60074),
    debugBreakpointLog: register$T("debug-breakpoint-log", 60075),
    debugBreakpointLogDisabled: register$T("debug-breakpoint-log-disabled", 60075),
    briefcase: register$T("briefcase", 60076),
    broadcast: register$T("broadcast", 60077),
    browser: register$T("browser", 60078),
    bug: register$T("bug", 60079),
    calendar: register$T("calendar", 60080),
    caseSensitive: register$T("case-sensitive", 60081),
    check: register$T("check", 60082),
    checklist: register$T("checklist", 60083),
    chevronDown: register$T("chevron-down", 60084),
    dropDownButton: register$T("drop-down-button", 60084),
    chevronLeft: register$T("chevron-left", 60085),
    chevronRight: register$T("chevron-right", 60086),
    chevronUp: register$T("chevron-up", 60087),
    chromeClose: register$T("chrome-close", 60088),
    chromeMaximize: register$T("chrome-maximize", 60089),
    chromeMinimize: register$T("chrome-minimize", 60090),
    chromeRestore: register$T("chrome-restore", 60091),
    circle: register$T("circle", 60092),
    circleOutline: register$T("circle-outline", 60092),
    debugBreakpointUnverified: register$T("debug-breakpoint-unverified", 60092),
    circleSlash: register$T("circle-slash", 60093),
    circuitBoard: register$T("circuit-board", 60094),
    clearAll: register$T("clear-all", 60095),
    clippy: register$T("clippy", 60096),
    closeAll: register$T("close-all", 60097),
    cloudDownload: register$T("cloud-download", 60098),
    cloudUpload: register$T("cloud-upload", 60099),
    code: register$T("code", 60100),
    collapseAll: register$T("collapse-all", 60101),
    colorMode: register$T("color-mode", 60102),
    commentDiscussion: register$T("comment-discussion", 60103),
    compareChanges: register$T("compare-changes", 60157),
    creditCard: register$T("credit-card", 60105),
    dash: register$T("dash", 60108),
    dashboard: register$T("dashboard", 60109),
    database: register$T("database", 60110),
    debugContinue: register$T("debug-continue", 60111),
    debugDisconnect: register$T("debug-disconnect", 60112),
    debugPause: register$T("debug-pause", 60113),
    debugRestart: register$T("debug-restart", 60114),
    debugStart: register$T("debug-start", 60115),
    debugStepInto: register$T("debug-step-into", 60116),
    debugStepOut: register$T("debug-step-out", 60117),
    debugStepOver: register$T("debug-step-over", 60118),
    debugStop: register$T("debug-stop", 60119),
    debug: register$T("debug", 60120),
    deviceCameraVideo: register$T("device-camera-video", 60121),
    deviceCamera: register$T("device-camera", 60122),
    deviceMobile: register$T("device-mobile", 60123),
    diffAdded: register$T("diff-added", 60124),
    diffIgnored: register$T("diff-ignored", 60125),
    diffModified: register$T("diff-modified", 60126),
    diffRemoved: register$T("diff-removed", 60127),
    diffRenamed: register$T("diff-renamed", 60128),
    diff: register$T("diff", 60129),
    discard: register$T("discard", 60130),
    editorLayout: register$T("editor-layout", 60131),
    emptyWindow: register$T("empty-window", 60132),
    exclude: register$T("exclude", 60133),
    extensions: register$T("extensions", 60134),
    eyeClosed: register$T("eye-closed", 60135),
    fileBinary: register$T("file-binary", 60136),
    fileCode: register$T("file-code", 60137),
    fileMedia: register$T("file-media", 60138),
    filePdf: register$T("file-pdf", 60139),
    fileSubmodule: register$T("file-submodule", 60140),
    fileSymlinkDirectory: register$T("file-symlink-directory", 60141),
    fileSymlinkFile: register$T("file-symlink-file", 60142),
    fileZip: register$T("file-zip", 60143),
    files: register$T("files", 60144),
    filter: register$T("filter", 60145),
    flame: register$T("flame", 60146),
    foldDown: register$T("fold-down", 60147),
    foldUp: register$T("fold-up", 60148),
    fold: register$T("fold", 60149),
    folderActive: register$T("folder-active", 60150),
    folderOpened: register$T("folder-opened", 60151),
    gear: register$T("gear", 60152),
    gift: register$T("gift", 60153),
    gistSecret: register$T("gist-secret", 60154),
    gist: register$T("gist", 60155),
    gitCommit: register$T("git-commit", 60156),
    gitCompare: register$T("git-compare", 60157),
    gitMerge: register$T("git-merge", 60158),
    githubAction: register$T("github-action", 60159),
    githubAlt: register$T("github-alt", 60160),
    globe: register$T("globe", 60161),
    grabber: register$T("grabber", 60162),
    graph: register$T("graph", 60163),
    gripper: register$T("gripper", 60164),
    heart: register$T("heart", 60165),
    home: register$T("home", 60166),
    horizontalRule: register$T("horizontal-rule", 60167),
    hubot: register$T("hubot", 60168),
    inbox: register$T("inbox", 60169),
    issueClosed: register$T("issue-closed", 60324),
    issueReopened: register$T("issue-reopened", 60171),
    issues: register$T("issues", 60172),
    italic: register$T("italic", 60173),
    jersey: register$T("jersey", 60174),
    json: register$T("json", 60175),
    bracket: register$T("bracket", 60175),
    kebabVertical: register$T("kebab-vertical", 60176),
    key: register$T("key", 60177),
    law: register$T("law", 60178),
    lightbulbAutofix: register$T("lightbulb-autofix", 60179),
    linkExternal: register$T("link-external", 60180),
    link: register$T("link", 60181),
    listOrdered: register$T("list-ordered", 60182),
    listUnordered: register$T("list-unordered", 60183),
    liveShare: register$T("live-share", 60184),
    loading: register$T("loading", 60185),
    location: register$T("location", 60186),
    mailRead: register$T("mail-read", 60187),
    mail: register$T("mail", 60188),
    markdown: register$T("markdown", 60189),
    megaphone: register$T("megaphone", 60190),
    mention: register$T("mention", 60191),
    milestone: register$T("milestone", 60192),
    mortarBoard: register$T("mortar-board", 60193),
    move: register$T("move", 60194),
    multipleWindows: register$T("multiple-windows", 60195),
    mute: register$T("mute", 60196),
    noNewline: register$T("no-newline", 60197),
    note: register$T("note", 60198),
    octoface: register$T("octoface", 60199),
    openPreview: register$T("open-preview", 60200),
    package_: register$T("package", 60201),
    paintcan: register$T("paintcan", 60202),
    pin: register$T("pin", 60203),
    play: register$T("play", 60204),
    run: register$T("run", 60204),
    plug: register$T("plug", 60205),
    preserveCase: register$T("preserve-case", 60206),
    preview: register$T("preview", 60207),
    project: register$T("project", 60208),
    pulse: register$T("pulse", 60209),
    question: register$T("question", 60210),
    quote: register$T("quote", 60211),
    radioTower: register$T("radio-tower", 60212),
    reactions: register$T("reactions", 60213),
    references: register$T("references", 60214),
    refresh: register$T("refresh", 60215),
    regex: register$T("regex", 60216),
    remoteExplorer: register$T("remote-explorer", 60217),
    remote: register$T("remote", 60218),
    remove: register$T("remove", 60219),
    replaceAll: register$T("replace-all", 60220),
    replace: register$T("replace", 60221),
    repoClone: register$T("repo-clone", 60222),
    repoForcePush: register$T("repo-force-push", 60223),
    repoPull: register$T("repo-pull", 60224),
    repoPush: register$T("repo-push", 60225),
    report: register$T("report", 60226),
    requestChanges: register$T("request-changes", 60227),
    rocket: register$T("rocket", 60228),
    rootFolderOpened: register$T("root-folder-opened", 60229),
    rootFolder: register$T("root-folder", 60230),
    rss: register$T("rss", 60231),
    ruby: register$T("ruby", 60232),
    saveAll: register$T("save-all", 60233),
    saveAs: register$T("save-as", 60234),
    save: register$T("save", 60235),
    screenFull: register$T("screen-full", 60236),
    screenNormal: register$T("screen-normal", 60237),
    searchStop: register$T("search-stop", 60238),
    server: register$T("server", 60240),
    settingsGear: register$T("settings-gear", 60241),
    settings: register$T("settings", 60242),
    shield: register$T("shield", 60243),
    smiley: register$T("smiley", 60244),
    sortPrecedence: register$T("sort-precedence", 60245),
    splitHorizontal: register$T("split-horizontal", 60246),
    splitVertical: register$T("split-vertical", 60247),
    squirrel: register$T("squirrel", 60248),
    starFull: register$T("star-full", 60249),
    starHalf: register$T("star-half", 60250),
    symbolClass: register$T("symbol-class", 60251),
    symbolColor: register$T("symbol-color", 60252),
    symbolCustomColor: register$T("symbol-customcolor", 60252),
    symbolConstant: register$T("symbol-constant", 60253),
    symbolEnumMember: register$T("symbol-enum-member", 60254),
    symbolField: register$T("symbol-field", 60255),
    symbolFile: register$T("symbol-file", 60256),
    symbolInterface: register$T("symbol-interface", 60257),
    symbolKeyword: register$T("symbol-keyword", 60258),
    symbolMisc: register$T("symbol-misc", 60259),
    symbolOperator: register$T("symbol-operator", 60260),
    symbolProperty: register$T("symbol-property", 60261),
    wrench: register$T("wrench", 60261),
    wrenchSubaction: register$T("wrench-subaction", 60261),
    symbolSnippet: register$T("symbol-snippet", 60262),
    tasklist: register$T("tasklist", 60263),
    telescope: register$T("telescope", 60264),
    textSize: register$T("text-size", 60265),
    threeBars: register$T("three-bars", 60266),
    thumbsdown: register$T("thumbsdown", 60267),
    thumbsup: register$T("thumbsup", 60268),
    tools: register$T("tools", 60269),
    triangleDown: register$T("triangle-down", 60270),
    triangleLeft: register$T("triangle-left", 60271),
    triangleRight: register$T("triangle-right", 60272),
    triangleUp: register$T("triangle-up", 60273),
    twitter: register$T("twitter", 60274),
    unfold: register$T("unfold", 60275),
    unlock: register$T("unlock", 60276),
    unmute: register$T("unmute", 60277),
    unverified: register$T("unverified", 60278),
    verified: register$T("verified", 60279),
    versions: register$T("versions", 60280),
    vmActive: register$T("vm-active", 60281),
    vmOutline: register$T("vm-outline", 60282),
    vmRunning: register$T("vm-running", 60283),
    watch: register$T("watch", 60284),
    whitespace: register$T("whitespace", 60285),
    wholeWord: register$T("whole-word", 60286),
    window: register$T("window", 60287),
    wordWrap: register$T("word-wrap", 60288),
    zoomIn: register$T("zoom-in", 60289),
    zoomOut: register$T("zoom-out", 60290),
    listFilter: register$T("list-filter", 60291),
    listFlat: register$T("list-flat", 60292),
    listSelection: register$T("list-selection", 60293),
    selection: register$T("selection", 60293),
    listTree: register$T("list-tree", 60294),
    debugBreakpointFunctionUnverified: register$T("debug-breakpoint-function-unverified", 60295),
    debugBreakpointFunction: register$T("debug-breakpoint-function", 60296),
    debugBreakpointFunctionDisabled: register$T("debug-breakpoint-function-disabled", 60296),
    debugStackframeActive: register$T("debug-stackframe-active", 60297),
    circleSmallFilled: register$T("circle-small-filled", 60298),
    debugStackframeDot: register$T("debug-stackframe-dot", 60298),
    debugStackframe: register$T("debug-stackframe", 60299),
    debugStackframeFocused: register$T("debug-stackframe-focused", 60299),
    debugBreakpointUnsupported: register$T("debug-breakpoint-unsupported", 60300),
    symbolString: register$T("symbol-string", 60301),
    debugReverseContinue: register$T("debug-reverse-continue", 60302),
    debugStepBack: register$T("debug-step-back", 60303),
    debugRestartFrame: register$T("debug-restart-frame", 60304),
    callIncoming: register$T("call-incoming", 60306),
    callOutgoing: register$T("call-outgoing", 60307),
    menu: register$T("menu", 60308),
    expandAll: register$T("expand-all", 60309),
    feedback: register$T("feedback", 60310),
    groupByRefType: register$T("group-by-ref-type", 60311),
    ungroupByRefType: register$T("ungroup-by-ref-type", 60312),
    account: register$T("account", 60313),
    bellDot: register$T("bell-dot", 60314),
    debugConsole: register$T("debug-console", 60315),
    library: register$T("library", 60316),
    output: register$T("output", 60317),
    runAll: register$T("run-all", 60318),
    syncIgnored: register$T("sync-ignored", 60319),
    pinned: register$T("pinned", 60320),
    githubInverted: register$T("github-inverted", 60321),
    debugAlt: register$T("debug-alt", 60305),
    serverProcess: register$T("server-process", 60322),
    serverEnvironment: register$T("server-environment", 60323),
    pass: register$T("pass", 60324),
    stopCircle: register$T("stop-circle", 60325),
    playCircle: register$T("play-circle", 60326),
    record: register$T("record", 60327),
    debugAltSmall: register$T("debug-alt-small", 60328),
    vmConnect: register$T("vm-connect", 60329),
    cloud: register$T("cloud", 60330),
    merge: register$T("merge", 60331),
    exportIcon: register$T("export", 60332),
    graphLeft: register$T("graph-left", 60333),
    magnet: register$T("magnet", 60334),
    notebook: register$T("notebook", 60335),
    redo: register$T("redo", 60336),
    checkAll: register$T("check-all", 60337),
    pinnedDirty: register$T("pinned-dirty", 60338),
    passFilled: register$T("pass-filled", 60339),
    circleLargeFilled: register$T("circle-large-filled", 60340),
    circleLarge: register$T("circle-large", 60341),
    circleLargeOutline: register$T("circle-large-outline", 60341),
    combine: register$T("combine", 60342),
    gather: register$T("gather", 60342),
    table: register$T("table", 60343),
    variableGroup: register$T("variable-group", 60344),
    typeHierarchy: register$T("type-hierarchy", 60345),
    typeHierarchySub: register$T("type-hierarchy-sub", 60346),
    typeHierarchySuper: register$T("type-hierarchy-super", 60347),
    gitPullRequestCreate: register$T("git-pull-request-create", 60348),
    runAbove: register$T("run-above", 60349),
    runBelow: register$T("run-below", 60350),
    notebookTemplate: register$T("notebook-template", 60351),
    debugRerun: register$T("debug-rerun", 60352),
    workspaceTrusted: register$T("workspace-trusted", 60353),
    workspaceUntrusted: register$T("workspace-untrusted", 60354),
    workspaceUnspecified: register$T("workspace-unspecified", 60355),
    terminalCmd: register$T("terminal-cmd", 60356),
    terminalDebian: register$T("terminal-debian", 60357),
    terminalLinux: register$T("terminal-linux", 60358),
    terminalPowershell: register$T("terminal-powershell", 60359),
    terminalTmux: register$T("terminal-tmux", 60360),
    terminalUbuntu: register$T("terminal-ubuntu", 60361),
    terminalBash: register$T("terminal-bash", 60362),
    arrowSwap: register$T("arrow-swap", 60363),
    copy: register$T("copy", 60364),
    personAdd: register$T("person-add", 60365),
    filterFilled: register$T("filter-filled", 60366),
    wand: register$T("wand", 60367),
    debugLineByLine: register$T("debug-line-by-line", 60368),
    inspect: register$T("inspect", 60369),
    layers: register$T("layers", 60370),
    layersDot: register$T("layers-dot", 60371),
    layersActive: register$T("layers-active", 60372),
    compass: register$T("compass", 60373),
    compassDot: register$T("compass-dot", 60374),
    compassActive: register$T("compass-active", 60375),
    azure: register$T("azure", 60376),
    issueDraft: register$T("issue-draft", 60377),
    gitPullRequestClosed: register$T("git-pull-request-closed", 60378),
    gitPullRequestDraft: register$T("git-pull-request-draft", 60379),
    debugAll: register$T("debug-all", 60380),
    debugCoverage: register$T("debug-coverage", 60381),
    runErrors: register$T("run-errors", 60382),
    folderLibrary: register$T("folder-library", 60383),
    debugContinueSmall: register$T("debug-continue-small", 60384),
    beakerStop: register$T("beaker-stop", 60385),
    graphLine: register$T("graph-line", 60386),
    graphScatter: register$T("graph-scatter", 60387),
    pieChart: register$T("pie-chart", 60388),
    bracketDot: register$T("bracket-dot", 60389),
    bracketError: register$T("bracket-error", 60390),
    lockSmall: register$T("lock-small", 60391),
    azureDevops: register$T("azure-devops", 60392),
    verifiedFilled: register$T("verified-filled", 60393),
    newLine: register$T("newline", 60394),
    layout: register$T("layout", 60395),
    layoutActivitybarLeft: register$T("layout-activitybar-left", 60396),
    layoutActivitybarRight: register$T("layout-activitybar-right", 60397),
    layoutPanelLeft: register$T("layout-panel-left", 60398),
    layoutPanelCenter: register$T("layout-panel-center", 60399),
    layoutPanelJustify: register$T("layout-panel-justify", 60400),
    layoutPanelRight: register$T("layout-panel-right", 60401),
    layoutPanel: register$T("layout-panel", 60402),
    layoutSidebarLeft: register$T("layout-sidebar-left", 60403),
    layoutSidebarRight: register$T("layout-sidebar-right", 60404),
    layoutStatusbar: register$T("layout-statusbar", 60405),
    layoutMenubar: register$T("layout-menubar", 60406),
    layoutCentered: register$T("layout-centered", 60407),
    layoutSidebarRightOff: register$T("layout-sidebar-right-off", 60416),
    layoutPanelOff: register$T("layout-panel-off", 60417),
    layoutSidebarLeftOff: register$T("layout-sidebar-left-off", 60418),
    target: register$T("target", 60408),
    indent: register$T("indent", 60409),
    recordSmall: register$T("record-small", 60410),
    errorSmall: register$T("error-small", 60411),
    arrowCircleDown: register$T("arrow-circle-down", 60412),
    arrowCircleLeft: register$T("arrow-circle-left", 60413),
    arrowCircleRight: register$T("arrow-circle-right", 60414),
    arrowCircleUp: register$T("arrow-circle-up", 60415),
    heartFilled: register$T("heart-filled", 60420),
    map: register$T("map", 60421),
    mapFilled: register$T("map-filled", 60422),
    circleSmall: register$T("circle-small", 60423),
    bellSlash: register$T("bell-slash", 60424),
    bellSlashDot: register$T("bell-slash-dot", 60425),
    commentUnresolved: register$T("comment-unresolved", 60426),
    gitPullRequestGoToChanges: register$T("git-pull-request-go-to-changes", 60427),
    gitPullRequestNewChanges: register$T("git-pull-request-new-changes", 60428),
    searchFuzzy: register$T("search-fuzzy", 60429),
    commentDraft: register$T("comment-draft", 60430),
    send: register$T("send", 60431),
    sparkle: register$T("sparkle", 60432),
    insert: register$T("insert", 60433),
    // derived icons, that could become separate icons
    dialogError: register$T("dialog-error", "error"),
    dialogWarning: register$T("dialog-warning", "warning"),
    dialogInfo: register$T("dialog-info", "info"),
    dialogClose: register$T("dialog-close", "close"),
    treeItemExpanded: register$T("tree-item-expanded", "chevron-down"),
    treeFilterOnTypeOn: register$T("tree-filter-on-type-on", "list-filter"),
    treeFilterOnTypeOff: register$T("tree-filter-on-type-off", "list-selection"),
    treeFilterClear: register$T("tree-filter-clear", "close"),
    treeItemLoading: register$T("tree-item-loading", "loading"),
    menuSelection: register$T("menu-selection", "check"),
    menuSubmenu: register$T("menu-submenu", "chevron-right"),
    menuBarMore: register$T("menubar-more", "more"),
    scrollbarButtonLeft: register$T("scrollbar-button-left", "triangle-left"),
    scrollbarButtonRight: register$T("scrollbar-button-right", "triangle-right"),
    scrollbarButtonUp: register$T("scrollbar-button-up", "triangle-up"),
    scrollbarButtonDown: register$T("scrollbar-button-down", "triangle-down"),
    toolBarMore: register$T("toolbar-more", "more"),
    quickInputBack: register$T("quick-input-back", "arrow-left")
  };
  var __awaiter$1 = function(thisArg, _arguments, P, generator) {
    function adopt(value) {
      return value instanceof P ? value : new P(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P || (P = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e) {
          reject(e);
        }
      }
      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e) {
          reject(e);
        }
      }
      function step(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  class TokenizationRegistry {
    constructor() {
      this._tokenizationSupports = /* @__PURE__ */ new Map();
      this._factories = /* @__PURE__ */ new Map();
      this._onDidChange = new Emitter();
      this.onDidChange = this._onDidChange.event;
      this._colorMap = null;
    }
    handleChange(languageIds) {
      this._onDidChange.fire({
        changedLanguages: languageIds,
        changedColorMap: false
      });
    }
    register(languageId, support) {
      this._tokenizationSupports.set(languageId, support);
      this.handleChange([languageId]);
      return toDisposable(() => {
        if (this._tokenizationSupports.get(languageId) !== support) {
          return;
        }
        this._tokenizationSupports.delete(languageId);
        this.handleChange([languageId]);
      });
    }
    get(languageId) {
      return this._tokenizationSupports.get(languageId) || null;
    }
    registerFactory(languageId, factory) {
      var _a2;
      (_a2 = this._factories.get(languageId)) === null || _a2 === void 0 ? void 0 : _a2.dispose();
      const myData = new TokenizationSupportFactoryData(this, languageId, factory);
      this._factories.set(languageId, myData);
      return toDisposable(() => {
        const v = this._factories.get(languageId);
        if (!v || v !== myData) {
          return;
        }
        this._factories.delete(languageId);
        v.dispose();
      });
    }
    getOrCreate(languageId) {
      return __awaiter$1(this, void 0, void 0, function* () {
        const tokenizationSupport = this.get(languageId);
        if (tokenizationSupport) {
          return tokenizationSupport;
        }
        const factory = this._factories.get(languageId);
        if (!factory || factory.isResolved) {
          return null;
        }
        yield factory.resolve();
        return this.get(languageId);
      });
    }
    isResolved(languageId) {
      const tokenizationSupport = this.get(languageId);
      if (tokenizationSupport) {
        return true;
      }
      const factory = this._factories.get(languageId);
      if (!factory || factory.isResolved) {
        return true;
      }
      return false;
    }
    setColorMap(colorMap) {
      this._colorMap = colorMap;
      this._onDidChange.fire({
        changedLanguages: Array.from(this._tokenizationSupports.keys()),
        changedColorMap: true
      });
    }
    getColorMap() {
      return this._colorMap;
    }
    getDefaultBackground() {
      if (this._colorMap && this._colorMap.length > 2) {
        return this._colorMap[
          2
          /* ColorId.DefaultBackground */
        ];
      }
      return null;
    }
  }
  class TokenizationSupportFactoryData extends Disposable {
    get isResolved() {
      return this._isResolved;
    }
    constructor(_registry, _languageId, _factory) {
      super();
      this._registry = _registry;
      this._languageId = _languageId;
      this._factory = _factory;
      this._isDisposed = false;
      this._resolvePromise = null;
      this._isResolved = false;
    }
    dispose() {
      this._isDisposed = true;
      super.dispose();
    }
    resolve() {
      return __awaiter$1(this, void 0, void 0, function* () {
        if (!this._resolvePromise) {
          this._resolvePromise = this._create();
        }
        return this._resolvePromise;
      });
    }
    _create() {
      return __awaiter$1(this, void 0, void 0, function* () {
        const value = yield this._factory.tokenizationSupport;
        this._isResolved = true;
        if (value && !this._isDisposed) {
          this._register(this._registry.register(this._languageId, value));
        }
      });
    }
  }
  class Token {
    constructor(offset, type, language) {
      this.offset = offset;
      this.type = type;
      this.language = language;
      this._tokenBrand = void 0;
    }
    toString() {
      return "(" + this.offset + ", " + this.type + ")";
    }
  }
  var CompletionItemKinds;
  (function(CompletionItemKinds2) {
    const byKind = /* @__PURE__ */ new Map();
    byKind.set(0, Codicon.symbolMethod);
    byKind.set(1, Codicon.symbolFunction);
    byKind.set(2, Codicon.symbolConstructor);
    byKind.set(3, Codicon.symbolField);
    byKind.set(4, Codicon.symbolVariable);
    byKind.set(5, Codicon.symbolClass);
    byKind.set(6, Codicon.symbolStruct);
    byKind.set(7, Codicon.symbolInterface);
    byKind.set(8, Codicon.symbolModule);
    byKind.set(9, Codicon.symbolProperty);
    byKind.set(10, Codicon.symbolEvent);
    byKind.set(11, Codicon.symbolOperator);
    byKind.set(12, Codicon.symbolUnit);
    byKind.set(13, Codicon.symbolValue);
    byKind.set(15, Codicon.symbolEnum);
    byKind.set(14, Codicon.symbolConstant);
    byKind.set(15, Codicon.symbolEnum);
    byKind.set(16, Codicon.symbolEnumMember);
    byKind.set(17, Codicon.symbolKeyword);
    byKind.set(27, Codicon.symbolSnippet);
    byKind.set(18, Codicon.symbolText);
    byKind.set(19, Codicon.symbolColor);
    byKind.set(20, Codicon.symbolFile);
    byKind.set(21, Codicon.symbolReference);
    byKind.set(22, Codicon.symbolCustomColor);
    byKind.set(23, Codicon.symbolFolder);
    byKind.set(24, Codicon.symbolTypeParameter);
    byKind.set(25, Codicon.account);
    byKind.set(26, Codicon.issues);
    function toIcon(kind) {
      let codicon = byKind.get(kind);
      if (!codicon) {
        console.info("No codicon found for CompletionItemKind " + kind);
        codicon = Codicon.symbolProperty;
      }
      return codicon;
    }
    CompletionItemKinds2.toIcon = toIcon;
    const data2 = /* @__PURE__ */ new Map();
    data2.set(
      "method",
      0
      /* CompletionItemKind.Method */
    );
    data2.set(
      "function",
      1
      /* CompletionItemKind.Function */
    );
    data2.set(
      "constructor",
      2
      /* CompletionItemKind.Constructor */
    );
    data2.set(
      "field",
      3
      /* CompletionItemKind.Field */
    );
    data2.set(
      "variable",
      4
      /* CompletionItemKind.Variable */
    );
    data2.set(
      "class",
      5
      /* CompletionItemKind.Class */
    );
    data2.set(
      "struct",
      6
      /* CompletionItemKind.Struct */
    );
    data2.set(
      "interface",
      7
      /* CompletionItemKind.Interface */
    );
    data2.set(
      "module",
      8
      /* CompletionItemKind.Module */
    );
    data2.set(
      "property",
      9
      /* CompletionItemKind.Property */
    );
    data2.set(
      "event",
      10
      /* CompletionItemKind.Event */
    );
    data2.set(
      "operator",
      11
      /* CompletionItemKind.Operator */
    );
    data2.set(
      "unit",
      12
      /* CompletionItemKind.Unit */
    );
    data2.set(
      "value",
      13
      /* CompletionItemKind.Value */
    );
    data2.set(
      "constant",
      14
      /* CompletionItemKind.Constant */
    );
    data2.set(
      "enum",
      15
      /* CompletionItemKind.Enum */
    );
    data2.set(
      "enum-member",
      16
      /* CompletionItemKind.EnumMember */
    );
    data2.set(
      "enumMember",
      16
      /* CompletionItemKind.EnumMember */
    );
    data2.set(
      "keyword",
      17
      /* CompletionItemKind.Keyword */
    );
    data2.set(
      "snippet",
      27
      /* CompletionItemKind.Snippet */
    );
    data2.set(
      "text",
      18
      /* CompletionItemKind.Text */
    );
    data2.set(
      "color",
      19
      /* CompletionItemKind.Color */
    );
    data2.set(
      "file",
      20
      /* CompletionItemKind.File */
    );
    data2.set(
      "reference",
      21
      /* CompletionItemKind.Reference */
    );
    data2.set(
      "customcolor",
      22
      /* CompletionItemKind.Customcolor */
    );
    data2.set(
      "folder",
      23
      /* CompletionItemKind.Folder */
    );
    data2.set(
      "type-parameter",
      24
      /* CompletionItemKind.TypeParameter */
    );
    data2.set(
      "typeParameter",
      24
      /* CompletionItemKind.TypeParameter */
    );
    data2.set(
      "account",
      25
      /* CompletionItemKind.User */
    );
    data2.set(
      "issue",
      26
      /* CompletionItemKind.Issue */
    );
    function fromString(value, strict) {
      let res = data2.get(value);
      if (typeof res === "undefined" && !strict) {
        res = 9;
      }
      return res;
    }
    CompletionItemKinds2.fromString = fromString;
  })(CompletionItemKinds || (CompletionItemKinds = {}));
  var InlineCompletionTriggerKind$1;
  (function(InlineCompletionTriggerKind2) {
    InlineCompletionTriggerKind2[InlineCompletionTriggerKind2["Automatic"] = 0] = "Automatic";
    InlineCompletionTriggerKind2[InlineCompletionTriggerKind2["Explicit"] = 1] = "Explicit";
  })(InlineCompletionTriggerKind$1 || (InlineCompletionTriggerKind$1 = {}));
  var SignatureHelpTriggerKind$1;
  (function(SignatureHelpTriggerKind2) {
    SignatureHelpTriggerKind2[SignatureHelpTriggerKind2["Invoke"] = 1] = "Invoke";
    SignatureHelpTriggerKind2[SignatureHelpTriggerKind2["TriggerCharacter"] = 2] = "TriggerCharacter";
    SignatureHelpTriggerKind2[SignatureHelpTriggerKind2["ContentChange"] = 3] = "ContentChange";
  })(SignatureHelpTriggerKind$1 || (SignatureHelpTriggerKind$1 = {}));
  var DocumentHighlightKind$2;
  (function(DocumentHighlightKind2) {
    DocumentHighlightKind2[DocumentHighlightKind2["Text"] = 0] = "Text";
    DocumentHighlightKind2[DocumentHighlightKind2["Read"] = 1] = "Read";
    DocumentHighlightKind2[DocumentHighlightKind2["Write"] = 2] = "Write";
  })(DocumentHighlightKind$2 || (DocumentHighlightKind$2 = {}));
  ({
    [
      17
      /* SymbolKind.Array */
    ]: localize$2("Array", "array"),
    [
      16
      /* SymbolKind.Boolean */
    ]: localize$2("Boolean", "boolean"),
    [
      4
      /* SymbolKind.Class */
    ]: localize$2("Class", "class"),
    [
      13
      /* SymbolKind.Constant */
    ]: localize$2("Constant", "constant"),
    [
      8
      /* SymbolKind.Constructor */
    ]: localize$2("Constructor", "constructor"),
    [
      9
      /* SymbolKind.Enum */
    ]: localize$2("Enum", "enumeration"),
    [
      21
      /* SymbolKind.EnumMember */
    ]: localize$2("EnumMember", "enumeration member"),
    [
      23
      /* SymbolKind.Event */
    ]: localize$2("Event", "event"),
    [
      7
      /* SymbolKind.Field */
    ]: localize$2("Field", "field"),
    [
      0
      /* SymbolKind.File */
    ]: localize$2("File", "file"),
    [
      11
      /* SymbolKind.Function */
    ]: localize$2("Function", "function"),
    [
      10
      /* SymbolKind.Interface */
    ]: localize$2("Interface", "interface"),
    [
      19
      /* SymbolKind.Key */
    ]: localize$2("Key", "key"),
    [
      5
      /* SymbolKind.Method */
    ]: localize$2("Method", "method"),
    [
      1
      /* SymbolKind.Module */
    ]: localize$2("Module", "module"),
    [
      2
      /* SymbolKind.Namespace */
    ]: localize$2("Namespace", "namespace"),
    [
      20
      /* SymbolKind.Null */
    ]: localize$2("Null", "null"),
    [
      15
      /* SymbolKind.Number */
    ]: localize$2("Number", "number"),
    [
      18
      /* SymbolKind.Object */
    ]: localize$2("Object", "object"),
    [
      24
      /* SymbolKind.Operator */
    ]: localize$2("Operator", "operator"),
    [
      3
      /* SymbolKind.Package */
    ]: localize$2("Package", "package"),
    [
      6
      /* SymbolKind.Property */
    ]: localize$2("Property", "property"),
    [
      14
      /* SymbolKind.String */
    ]: localize$2("String", "string"),
    [
      22
      /* SymbolKind.Struct */
    ]: localize$2("Struct", "struct"),
    [
      25
      /* SymbolKind.TypeParameter */
    ]: localize$2("TypeParameter", "type parameter"),
    [
      12
      /* SymbolKind.Variable */
    ]: localize$2("Variable", "variable")
  });
  var SymbolKinds;
  (function(SymbolKinds2) {
    const byKind = /* @__PURE__ */ new Map();
    byKind.set(0, Codicon.symbolFile);
    byKind.set(1, Codicon.symbolModule);
    byKind.set(2, Codicon.symbolNamespace);
    byKind.set(3, Codicon.symbolPackage);
    byKind.set(4, Codicon.symbolClass);
    byKind.set(5, Codicon.symbolMethod);
    byKind.set(6, Codicon.symbolProperty);
    byKind.set(7, Codicon.symbolField);
    byKind.set(8, Codicon.symbolConstructor);
    byKind.set(9, Codicon.symbolEnum);
    byKind.set(10, Codicon.symbolInterface);
    byKind.set(11, Codicon.symbolFunction);
    byKind.set(12, Codicon.symbolVariable);
    byKind.set(13, Codicon.symbolConstant);
    byKind.set(14, Codicon.symbolString);
    byKind.set(15, Codicon.symbolNumber);
    byKind.set(16, Codicon.symbolBoolean);
    byKind.set(17, Codicon.symbolArray);
    byKind.set(18, Codicon.symbolObject);
    byKind.set(19, Codicon.symbolKey);
    byKind.set(20, Codicon.symbolNull);
    byKind.set(21, Codicon.symbolEnumMember);
    byKind.set(22, Codicon.symbolStruct);
    byKind.set(23, Codicon.symbolEvent);
    byKind.set(24, Codicon.symbolOperator);
    byKind.set(25, Codicon.symbolTypeParameter);
    function toIcon(kind) {
      let icon = byKind.get(kind);
      if (!icon) {
        console.info("No codicon found for SymbolKind " + kind);
        icon = Codicon.symbolProperty;
      }
      return icon;
    }
    SymbolKinds2.toIcon = toIcon;
  })(SymbolKinds || (SymbolKinds = {}));
  var Command$1;
  (function(Command2) {
    function is(obj) {
      if (!obj || typeof obj !== "object") {
        return false;
      }
      return typeof obj.id === "string" && typeof obj.title === "string";
    }
    Command2.is = is;
  })(Command$1 || (Command$1 = {}));
  var InlayHintKind$2;
  (function(InlayHintKind2) {
    InlayHintKind2[InlayHintKind2["Type"] = 1] = "Type";
    InlayHintKind2[InlayHintKind2["Parameter"] = 2] = "Parameter";
  })(InlayHintKind$2 || (InlayHintKind$2 = {}));
  new TokenizationRegistry();
  var AccessibilitySupport;
  (function(AccessibilitySupport2) {
    AccessibilitySupport2[AccessibilitySupport2["Unknown"] = 0] = "Unknown";
    AccessibilitySupport2[AccessibilitySupport2["Disabled"] = 1] = "Disabled";
    AccessibilitySupport2[AccessibilitySupport2["Enabled"] = 2] = "Enabled";
  })(AccessibilitySupport || (AccessibilitySupport = {}));
  var CodeActionTriggerType;
  (function(CodeActionTriggerType2) {
    CodeActionTriggerType2[CodeActionTriggerType2["Invoke"] = 1] = "Invoke";
    CodeActionTriggerType2[CodeActionTriggerType2["Auto"] = 2] = "Auto";
  })(CodeActionTriggerType || (CodeActionTriggerType = {}));
  var CompletionItemInsertTextRule;
  (function(CompletionItemInsertTextRule2) {
    CompletionItemInsertTextRule2[CompletionItemInsertTextRule2["None"] = 0] = "None";
    CompletionItemInsertTextRule2[CompletionItemInsertTextRule2["KeepWhitespace"] = 1] = "KeepWhitespace";
    CompletionItemInsertTextRule2[CompletionItemInsertTextRule2["InsertAsSnippet"] = 4] = "InsertAsSnippet";
  })(CompletionItemInsertTextRule || (CompletionItemInsertTextRule = {}));
  var CompletionItemKind$1;
  (function(CompletionItemKind2) {
    CompletionItemKind2[CompletionItemKind2["Method"] = 0] = "Method";
    CompletionItemKind2[CompletionItemKind2["Function"] = 1] = "Function";
    CompletionItemKind2[CompletionItemKind2["Constructor"] = 2] = "Constructor";
    CompletionItemKind2[CompletionItemKind2["Field"] = 3] = "Field";
    CompletionItemKind2[CompletionItemKind2["Variable"] = 4] = "Variable";
    CompletionItemKind2[CompletionItemKind2["Class"] = 5] = "Class";
    CompletionItemKind2[CompletionItemKind2["Struct"] = 6] = "Struct";
    CompletionItemKind2[CompletionItemKind2["Interface"] = 7] = "Interface";
    CompletionItemKind2[CompletionItemKind2["Module"] = 8] = "Module";
    CompletionItemKind2[CompletionItemKind2["Property"] = 9] = "Property";
    CompletionItemKind2[CompletionItemKind2["Event"] = 10] = "Event";
    CompletionItemKind2[CompletionItemKind2["Operator"] = 11] = "Operator";
    CompletionItemKind2[CompletionItemKind2["Unit"] = 12] = "Unit";
    CompletionItemKind2[CompletionItemKind2["Value"] = 13] = "Value";
    CompletionItemKind2[CompletionItemKind2["Constant"] = 14] = "Constant";
    CompletionItemKind2[CompletionItemKind2["Enum"] = 15] = "Enum";
    CompletionItemKind2[CompletionItemKind2["EnumMember"] = 16] = "EnumMember";
    CompletionItemKind2[CompletionItemKind2["Keyword"] = 17] = "Keyword";
    CompletionItemKind2[CompletionItemKind2["Text"] = 18] = "Text";
    CompletionItemKind2[CompletionItemKind2["Color"] = 19] = "Color";
    CompletionItemKind2[CompletionItemKind2["File"] = 20] = "File";
    CompletionItemKind2[CompletionItemKind2["Reference"] = 21] = "Reference";
    CompletionItemKind2[CompletionItemKind2["Customcolor"] = 22] = "Customcolor";
    CompletionItemKind2[CompletionItemKind2["Folder"] = 23] = "Folder";
    CompletionItemKind2[CompletionItemKind2["TypeParameter"] = 24] = "TypeParameter";
    CompletionItemKind2[CompletionItemKind2["User"] = 25] = "User";
    CompletionItemKind2[CompletionItemKind2["Issue"] = 26] = "Issue";
    CompletionItemKind2[CompletionItemKind2["Snippet"] = 27] = "Snippet";
  })(CompletionItemKind$1 || (CompletionItemKind$1 = {}));
  var CompletionItemTag$1;
  (function(CompletionItemTag2) {
    CompletionItemTag2[CompletionItemTag2["Deprecated"] = 1] = "Deprecated";
  })(CompletionItemTag$1 || (CompletionItemTag$1 = {}));
  var CompletionTriggerKind;
  (function(CompletionTriggerKind2) {
    CompletionTriggerKind2[CompletionTriggerKind2["Invoke"] = 0] = "Invoke";
    CompletionTriggerKind2[CompletionTriggerKind2["TriggerCharacter"] = 1] = "TriggerCharacter";
    CompletionTriggerKind2[CompletionTriggerKind2["TriggerForIncompleteCompletions"] = 2] = "TriggerForIncompleteCompletions";
  })(CompletionTriggerKind || (CompletionTriggerKind = {}));
  var ContentWidgetPositionPreference;
  (function(ContentWidgetPositionPreference2) {
    ContentWidgetPositionPreference2[ContentWidgetPositionPreference2["EXACT"] = 0] = "EXACT";
    ContentWidgetPositionPreference2[ContentWidgetPositionPreference2["ABOVE"] = 1] = "ABOVE";
    ContentWidgetPositionPreference2[ContentWidgetPositionPreference2["BELOW"] = 2] = "BELOW";
  })(ContentWidgetPositionPreference || (ContentWidgetPositionPreference = {}));
  var CursorChangeReason;
  (function(CursorChangeReason2) {
    CursorChangeReason2[CursorChangeReason2["NotSet"] = 0] = "NotSet";
    CursorChangeReason2[CursorChangeReason2["ContentFlush"] = 1] = "ContentFlush";
    CursorChangeReason2[CursorChangeReason2["RecoverFromMarkers"] = 2] = "RecoverFromMarkers";
    CursorChangeReason2[CursorChangeReason2["Explicit"] = 3] = "Explicit";
    CursorChangeReason2[CursorChangeReason2["Paste"] = 4] = "Paste";
    CursorChangeReason2[CursorChangeReason2["Undo"] = 5] = "Undo";
    CursorChangeReason2[CursorChangeReason2["Redo"] = 6] = "Redo";
  })(CursorChangeReason || (CursorChangeReason = {}));
  var DefaultEndOfLine;
  (function(DefaultEndOfLine2) {
    DefaultEndOfLine2[DefaultEndOfLine2["LF"] = 1] = "LF";
    DefaultEndOfLine2[DefaultEndOfLine2["CRLF"] = 2] = "CRLF";
  })(DefaultEndOfLine || (DefaultEndOfLine = {}));
  var DocumentHighlightKind$1;
  (function(DocumentHighlightKind2) {
    DocumentHighlightKind2[DocumentHighlightKind2["Text"] = 0] = "Text";
    DocumentHighlightKind2[DocumentHighlightKind2["Read"] = 1] = "Read";
    DocumentHighlightKind2[DocumentHighlightKind2["Write"] = 2] = "Write";
  })(DocumentHighlightKind$1 || (DocumentHighlightKind$1 = {}));
  var EditorAutoIndentStrategy;
  (function(EditorAutoIndentStrategy2) {
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["None"] = 0] = "None";
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["Keep"] = 1] = "Keep";
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["Brackets"] = 2] = "Brackets";
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["Advanced"] = 3] = "Advanced";
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["Full"] = 4] = "Full";
  })(EditorAutoIndentStrategy || (EditorAutoIndentStrategy = {}));
  var EditorOption;
  (function(EditorOption2) {
    EditorOption2[EditorOption2["acceptSuggestionOnCommitCharacter"] = 0] = "acceptSuggestionOnCommitCharacter";
    EditorOption2[EditorOption2["acceptSuggestionOnEnter"] = 1] = "acceptSuggestionOnEnter";
    EditorOption2[EditorOption2["accessibilitySupport"] = 2] = "accessibilitySupport";
    EditorOption2[EditorOption2["accessibilityPageSize"] = 3] = "accessibilityPageSize";
    EditorOption2[EditorOption2["ariaLabel"] = 4] = "ariaLabel";
    EditorOption2[EditorOption2["ariaRequired"] = 5] = "ariaRequired";
    EditorOption2[EditorOption2["autoClosingBrackets"] = 6] = "autoClosingBrackets";
    EditorOption2[EditorOption2["screenReaderAnnounceInlineSuggestion"] = 7] = "screenReaderAnnounceInlineSuggestion";
    EditorOption2[EditorOption2["autoClosingDelete"] = 8] = "autoClosingDelete";
    EditorOption2[EditorOption2["autoClosingOvertype"] = 9] = "autoClosingOvertype";
    EditorOption2[EditorOption2["autoClosingQuotes"] = 10] = "autoClosingQuotes";
    EditorOption2[EditorOption2["autoIndent"] = 11] = "autoIndent";
    EditorOption2[EditorOption2["automaticLayout"] = 12] = "automaticLayout";
    EditorOption2[EditorOption2["autoSurround"] = 13] = "autoSurround";
    EditorOption2[EditorOption2["bracketPairColorization"] = 14] = "bracketPairColorization";
    EditorOption2[EditorOption2["guides"] = 15] = "guides";
    EditorOption2[EditorOption2["codeLens"] = 16] = "codeLens";
    EditorOption2[EditorOption2["codeLensFontFamily"] = 17] = "codeLensFontFamily";
    EditorOption2[EditorOption2["codeLensFontSize"] = 18] = "codeLensFontSize";
    EditorOption2[EditorOption2["colorDecorators"] = 19] = "colorDecorators";
    EditorOption2[EditorOption2["colorDecoratorsLimit"] = 20] = "colorDecoratorsLimit";
    EditorOption2[EditorOption2["columnSelection"] = 21] = "columnSelection";
    EditorOption2[EditorOption2["comments"] = 22] = "comments";
    EditorOption2[EditorOption2["contextmenu"] = 23] = "contextmenu";
    EditorOption2[EditorOption2["copyWithSyntaxHighlighting"] = 24] = "copyWithSyntaxHighlighting";
    EditorOption2[EditorOption2["cursorBlinking"] = 25] = "cursorBlinking";
    EditorOption2[EditorOption2["cursorSmoothCaretAnimation"] = 26] = "cursorSmoothCaretAnimation";
    EditorOption2[EditorOption2["cursorStyle"] = 27] = "cursorStyle";
    EditorOption2[EditorOption2["cursorSurroundingLines"] = 28] = "cursorSurroundingLines";
    EditorOption2[EditorOption2["cursorSurroundingLinesStyle"] = 29] = "cursorSurroundingLinesStyle";
    EditorOption2[EditorOption2["cursorWidth"] = 30] = "cursorWidth";
    EditorOption2[EditorOption2["disableLayerHinting"] = 31] = "disableLayerHinting";
    EditorOption2[EditorOption2["disableMonospaceOptimizations"] = 32] = "disableMonospaceOptimizations";
    EditorOption2[EditorOption2["domReadOnly"] = 33] = "domReadOnly";
    EditorOption2[EditorOption2["dragAndDrop"] = 34] = "dragAndDrop";
    EditorOption2[EditorOption2["dropIntoEditor"] = 35] = "dropIntoEditor";
    EditorOption2[EditorOption2["emptySelectionClipboard"] = 36] = "emptySelectionClipboard";
    EditorOption2[EditorOption2["experimentalWhitespaceRendering"] = 37] = "experimentalWhitespaceRendering";
    EditorOption2[EditorOption2["extraEditorClassName"] = 38] = "extraEditorClassName";
    EditorOption2[EditorOption2["fastScrollSensitivity"] = 39] = "fastScrollSensitivity";
    EditorOption2[EditorOption2["find"] = 40] = "find";
    EditorOption2[EditorOption2["fixedOverflowWidgets"] = 41] = "fixedOverflowWidgets";
    EditorOption2[EditorOption2["folding"] = 42] = "folding";
    EditorOption2[EditorOption2["foldingStrategy"] = 43] = "foldingStrategy";
    EditorOption2[EditorOption2["foldingHighlight"] = 44] = "foldingHighlight";
    EditorOption2[EditorOption2["foldingImportsByDefault"] = 45] = "foldingImportsByDefault";
    EditorOption2[EditorOption2["foldingMaximumRegions"] = 46] = "foldingMaximumRegions";
    EditorOption2[EditorOption2["unfoldOnClickAfterEndOfLine"] = 47] = "unfoldOnClickAfterEndOfLine";
    EditorOption2[EditorOption2["fontFamily"] = 48] = "fontFamily";
    EditorOption2[EditorOption2["fontInfo"] = 49] = "fontInfo";
    EditorOption2[EditorOption2["fontLigatures"] = 50] = "fontLigatures";
    EditorOption2[EditorOption2["fontSize"] = 51] = "fontSize";
    EditorOption2[EditorOption2["fontWeight"] = 52] = "fontWeight";
    EditorOption2[EditorOption2["fontVariations"] = 53] = "fontVariations";
    EditorOption2[EditorOption2["formatOnPaste"] = 54] = "formatOnPaste";
    EditorOption2[EditorOption2["formatOnType"] = 55] = "formatOnType";
    EditorOption2[EditorOption2["glyphMargin"] = 56] = "glyphMargin";
    EditorOption2[EditorOption2["gotoLocation"] = 57] = "gotoLocation";
    EditorOption2[EditorOption2["hideCursorInOverviewRuler"] = 58] = "hideCursorInOverviewRuler";
    EditorOption2[EditorOption2["hover"] = 59] = "hover";
    EditorOption2[EditorOption2["inDiffEditor"] = 60] = "inDiffEditor";
    EditorOption2[EditorOption2["inlineSuggest"] = 61] = "inlineSuggest";
    EditorOption2[EditorOption2["letterSpacing"] = 62] = "letterSpacing";
    EditorOption2[EditorOption2["lightbulb"] = 63] = "lightbulb";
    EditorOption2[EditorOption2["lineDecorationsWidth"] = 64] = "lineDecorationsWidth";
    EditorOption2[EditorOption2["lineHeight"] = 65] = "lineHeight";
    EditorOption2[EditorOption2["lineNumbers"] = 66] = "lineNumbers";
    EditorOption2[EditorOption2["lineNumbersMinChars"] = 67] = "lineNumbersMinChars";
    EditorOption2[EditorOption2["linkedEditing"] = 68] = "linkedEditing";
    EditorOption2[EditorOption2["links"] = 69] = "links";
    EditorOption2[EditorOption2["matchBrackets"] = 70] = "matchBrackets";
    EditorOption2[EditorOption2["minimap"] = 71] = "minimap";
    EditorOption2[EditorOption2["mouseStyle"] = 72] = "mouseStyle";
    EditorOption2[EditorOption2["mouseWheelScrollSensitivity"] = 73] = "mouseWheelScrollSensitivity";
    EditorOption2[EditorOption2["mouseWheelZoom"] = 74] = "mouseWheelZoom";
    EditorOption2[EditorOption2["multiCursorMergeOverlapping"] = 75] = "multiCursorMergeOverlapping";
    EditorOption2[EditorOption2["multiCursorModifier"] = 76] = "multiCursorModifier";
    EditorOption2[EditorOption2["multiCursorPaste"] = 77] = "multiCursorPaste";
    EditorOption2[EditorOption2["multiCursorLimit"] = 78] = "multiCursorLimit";
    EditorOption2[EditorOption2["occurrencesHighlight"] = 79] = "occurrencesHighlight";
    EditorOption2[EditorOption2["overviewRulerBorder"] = 80] = "overviewRulerBorder";
    EditorOption2[EditorOption2["overviewRulerLanes"] = 81] = "overviewRulerLanes";
    EditorOption2[EditorOption2["padding"] = 82] = "padding";
    EditorOption2[EditorOption2["pasteAs"] = 83] = "pasteAs";
    EditorOption2[EditorOption2["parameterHints"] = 84] = "parameterHints";
    EditorOption2[EditorOption2["peekWidgetDefaultFocus"] = 85] = "peekWidgetDefaultFocus";
    EditorOption2[EditorOption2["definitionLinkOpensInPeek"] = 86] = "definitionLinkOpensInPeek";
    EditorOption2[EditorOption2["quickSuggestions"] = 87] = "quickSuggestions";
    EditorOption2[EditorOption2["quickSuggestionsDelay"] = 88] = "quickSuggestionsDelay";
    EditorOption2[EditorOption2["readOnly"] = 89] = "readOnly";
    EditorOption2[EditorOption2["readOnlyMessage"] = 90] = "readOnlyMessage";
    EditorOption2[EditorOption2["renameOnType"] = 91] = "renameOnType";
    EditorOption2[EditorOption2["renderControlCharacters"] = 92] = "renderControlCharacters";
    EditorOption2[EditorOption2["renderFinalNewline"] = 93] = "renderFinalNewline";
    EditorOption2[EditorOption2["renderLineHighlight"] = 94] = "renderLineHighlight";
    EditorOption2[EditorOption2["renderLineHighlightOnlyWhenFocus"] = 95] = "renderLineHighlightOnlyWhenFocus";
    EditorOption2[EditorOption2["renderValidationDecorations"] = 96] = "renderValidationDecorations";
    EditorOption2[EditorOption2["renderWhitespace"] = 97] = "renderWhitespace";
    EditorOption2[EditorOption2["revealHorizontalRightPadding"] = 98] = "revealHorizontalRightPadding";
    EditorOption2[EditorOption2["roundedSelection"] = 99] = "roundedSelection";
    EditorOption2[EditorOption2["rulers"] = 100] = "rulers";
    EditorOption2[EditorOption2["scrollbar"] = 101] = "scrollbar";
    EditorOption2[EditorOption2["scrollBeyondLastColumn"] = 102] = "scrollBeyondLastColumn";
    EditorOption2[EditorOption2["scrollBeyondLastLine"] = 103] = "scrollBeyondLastLine";
    EditorOption2[EditorOption2["scrollPredominantAxis"] = 104] = "scrollPredominantAxis";
    EditorOption2[EditorOption2["selectionClipboard"] = 105] = "selectionClipboard";
    EditorOption2[EditorOption2["selectionHighlight"] = 106] = "selectionHighlight";
    EditorOption2[EditorOption2["selectOnLineNumbers"] = 107] = "selectOnLineNumbers";
    EditorOption2[EditorOption2["showFoldingControls"] = 108] = "showFoldingControls";
    EditorOption2[EditorOption2["showUnused"] = 109] = "showUnused";
    EditorOption2[EditorOption2["snippetSuggestions"] = 110] = "snippetSuggestions";
    EditorOption2[EditorOption2["smartSelect"] = 111] = "smartSelect";
    EditorOption2[EditorOption2["smoothScrolling"] = 112] = "smoothScrolling";
    EditorOption2[EditorOption2["stickyScroll"] = 113] = "stickyScroll";
    EditorOption2[EditorOption2["stickyTabStops"] = 114] = "stickyTabStops";
    EditorOption2[EditorOption2["stopRenderingLineAfter"] = 115] = "stopRenderingLineAfter";
    EditorOption2[EditorOption2["suggest"] = 116] = "suggest";
    EditorOption2[EditorOption2["suggestFontSize"] = 117] = "suggestFontSize";
    EditorOption2[EditorOption2["suggestLineHeight"] = 118] = "suggestLineHeight";
    EditorOption2[EditorOption2["suggestOnTriggerCharacters"] = 119] = "suggestOnTriggerCharacters";
    EditorOption2[EditorOption2["suggestSelection"] = 120] = "suggestSelection";
    EditorOption2[EditorOption2["tabCompletion"] = 121] = "tabCompletion";
    EditorOption2[EditorOption2["tabIndex"] = 122] = "tabIndex";
    EditorOption2[EditorOption2["unicodeHighlighting"] = 123] = "unicodeHighlighting";
    EditorOption2[EditorOption2["unusualLineTerminators"] = 124] = "unusualLineTerminators";
    EditorOption2[EditorOption2["useShadowDOM"] = 125] = "useShadowDOM";
    EditorOption2[EditorOption2["useTabStops"] = 126] = "useTabStops";
    EditorOption2[EditorOption2["wordBreak"] = 127] = "wordBreak";
    EditorOption2[EditorOption2["wordSeparators"] = 128] = "wordSeparators";
    EditorOption2[EditorOption2["wordWrap"] = 129] = "wordWrap";
    EditorOption2[EditorOption2["wordWrapBreakAfterCharacters"] = 130] = "wordWrapBreakAfterCharacters";
    EditorOption2[EditorOption2["wordWrapBreakBeforeCharacters"] = 131] = "wordWrapBreakBeforeCharacters";
    EditorOption2[EditorOption2["wordWrapColumn"] = 132] = "wordWrapColumn";
    EditorOption2[EditorOption2["wordWrapOverride1"] = 133] = "wordWrapOverride1";
    EditorOption2[EditorOption2["wordWrapOverride2"] = 134] = "wordWrapOverride2";
    EditorOption2[EditorOption2["wrappingIndent"] = 135] = "wrappingIndent";
    EditorOption2[EditorOption2["wrappingStrategy"] = 136] = "wrappingStrategy";
    EditorOption2[EditorOption2["showDeprecated"] = 137] = "showDeprecated";
    EditorOption2[EditorOption2["inlayHints"] = 138] = "inlayHints";
    EditorOption2[EditorOption2["editorClassName"] = 139] = "editorClassName";
    EditorOption2[EditorOption2["pixelRatio"] = 140] = "pixelRatio";
    EditorOption2[EditorOption2["tabFocusMode"] = 141] = "tabFocusMode";
    EditorOption2[EditorOption2["layoutInfo"] = 142] = "layoutInfo";
    EditorOption2[EditorOption2["wrappingInfo"] = 143] = "wrappingInfo";
    EditorOption2[EditorOption2["defaultColorDecorators"] = 144] = "defaultColorDecorators";
    EditorOption2[EditorOption2["colorDecoratorsActivatedOn"] = 145] = "colorDecoratorsActivatedOn";
  })(EditorOption || (EditorOption = {}));
  var EndOfLinePreference;
  (function(EndOfLinePreference2) {
    EndOfLinePreference2[EndOfLinePreference2["TextDefined"] = 0] = "TextDefined";
    EndOfLinePreference2[EndOfLinePreference2["LF"] = 1] = "LF";
    EndOfLinePreference2[EndOfLinePreference2["CRLF"] = 2] = "CRLF";
  })(EndOfLinePreference || (EndOfLinePreference = {}));
  var EndOfLineSequence;
  (function(EndOfLineSequence2) {
    EndOfLineSequence2[EndOfLineSequence2["LF"] = 0] = "LF";
    EndOfLineSequence2[EndOfLineSequence2["CRLF"] = 1] = "CRLF";
  })(EndOfLineSequence || (EndOfLineSequence = {}));
  var GlyphMarginLane$1;
  (function(GlyphMarginLane2) {
    GlyphMarginLane2[GlyphMarginLane2["Left"] = 1] = "Left";
    GlyphMarginLane2[GlyphMarginLane2["Right"] = 2] = "Right";
  })(GlyphMarginLane$1 || (GlyphMarginLane$1 = {}));
  var IndentAction;
  (function(IndentAction2) {
    IndentAction2[IndentAction2["None"] = 0] = "None";
    IndentAction2[IndentAction2["Indent"] = 1] = "Indent";
    IndentAction2[IndentAction2["IndentOutdent"] = 2] = "IndentOutdent";
    IndentAction2[IndentAction2["Outdent"] = 3] = "Outdent";
  })(IndentAction || (IndentAction = {}));
  var InjectedTextCursorStops$1;
  (function(InjectedTextCursorStops2) {
    InjectedTextCursorStops2[InjectedTextCursorStops2["Both"] = 0] = "Both";
    InjectedTextCursorStops2[InjectedTextCursorStops2["Right"] = 1] = "Right";
    InjectedTextCursorStops2[InjectedTextCursorStops2["Left"] = 2] = "Left";
    InjectedTextCursorStops2[InjectedTextCursorStops2["None"] = 3] = "None";
  })(InjectedTextCursorStops$1 || (InjectedTextCursorStops$1 = {}));
  var InlayHintKind$1;
  (function(InlayHintKind2) {
    InlayHintKind2[InlayHintKind2["Type"] = 1] = "Type";
    InlayHintKind2[InlayHintKind2["Parameter"] = 2] = "Parameter";
  })(InlayHintKind$1 || (InlayHintKind$1 = {}));
  var InlineCompletionTriggerKind;
  (function(InlineCompletionTriggerKind2) {
    InlineCompletionTriggerKind2[InlineCompletionTriggerKind2["Automatic"] = 0] = "Automatic";
    InlineCompletionTriggerKind2[InlineCompletionTriggerKind2["Explicit"] = 1] = "Explicit";
  })(InlineCompletionTriggerKind || (InlineCompletionTriggerKind = {}));
  var KeyCode;
  (function(KeyCode2) {
    KeyCode2[KeyCode2["DependsOnKbLayout"] = -1] = "DependsOnKbLayout";
    KeyCode2[KeyCode2["Unknown"] = 0] = "Unknown";
    KeyCode2[KeyCode2["Backspace"] = 1] = "Backspace";
    KeyCode2[KeyCode2["Tab"] = 2] = "Tab";
    KeyCode2[KeyCode2["Enter"] = 3] = "Enter";
    KeyCode2[KeyCode2["Shift"] = 4] = "Shift";
    KeyCode2[KeyCode2["Ctrl"] = 5] = "Ctrl";
    KeyCode2[KeyCode2["Alt"] = 6] = "Alt";
    KeyCode2[KeyCode2["PauseBreak"] = 7] = "PauseBreak";
    KeyCode2[KeyCode2["CapsLock"] = 8] = "CapsLock";
    KeyCode2[KeyCode2["Escape"] = 9] = "Escape";
    KeyCode2[KeyCode2["Space"] = 10] = "Space";
    KeyCode2[KeyCode2["PageUp"] = 11] = "PageUp";
    KeyCode2[KeyCode2["PageDown"] = 12] = "PageDown";
    KeyCode2[KeyCode2["End"] = 13] = "End";
    KeyCode2[KeyCode2["Home"] = 14] = "Home";
    KeyCode2[KeyCode2["LeftArrow"] = 15] = "LeftArrow";
    KeyCode2[KeyCode2["UpArrow"] = 16] = "UpArrow";
    KeyCode2[KeyCode2["RightArrow"] = 17] = "RightArrow";
    KeyCode2[KeyCode2["DownArrow"] = 18] = "DownArrow";
    KeyCode2[KeyCode2["Insert"] = 19] = "Insert";
    KeyCode2[KeyCode2["Delete"] = 20] = "Delete";
    KeyCode2[KeyCode2["Digit0"] = 21] = "Digit0";
    KeyCode2[KeyCode2["Digit1"] = 22] = "Digit1";
    KeyCode2[KeyCode2["Digit2"] = 23] = "Digit2";
    KeyCode2[KeyCode2["Digit3"] = 24] = "Digit3";
    KeyCode2[KeyCode2["Digit4"] = 25] = "Digit4";
    KeyCode2[KeyCode2["Digit5"] = 26] = "Digit5";
    KeyCode2[KeyCode2["Digit6"] = 27] = "Digit6";
    KeyCode2[KeyCode2["Digit7"] = 28] = "Digit7";
    KeyCode2[KeyCode2["Digit8"] = 29] = "Digit8";
    KeyCode2[KeyCode2["Digit9"] = 30] = "Digit9";
    KeyCode2[KeyCode2["KeyA"] = 31] = "KeyA";
    KeyCode2[KeyCode2["KeyB"] = 32] = "KeyB";
    KeyCode2[KeyCode2["KeyC"] = 33] = "KeyC";
    KeyCode2[KeyCode2["KeyD"] = 34] = "KeyD";
    KeyCode2[KeyCode2["KeyE"] = 35] = "KeyE";
    KeyCode2[KeyCode2["KeyF"] = 36] = "KeyF";
    KeyCode2[KeyCode2["KeyG"] = 37] = "KeyG";
    KeyCode2[KeyCode2["KeyH"] = 38] = "KeyH";
    KeyCode2[KeyCode2["KeyI"] = 39] = "KeyI";
    KeyCode2[KeyCode2["KeyJ"] = 40] = "KeyJ";
    KeyCode2[KeyCode2["KeyK"] = 41] = "KeyK";
    KeyCode2[KeyCode2["KeyL"] = 42] = "KeyL";
    KeyCode2[KeyCode2["KeyM"] = 43] = "KeyM";
    KeyCode2[KeyCode2["KeyN"] = 44] = "KeyN";
    KeyCode2[KeyCode2["KeyO"] = 45] = "KeyO";
    KeyCode2[KeyCode2["KeyP"] = 46] = "KeyP";
    KeyCode2[KeyCode2["KeyQ"] = 47] = "KeyQ";
    KeyCode2[KeyCode2["KeyR"] = 48] = "KeyR";
    KeyCode2[KeyCode2["KeyS"] = 49] = "KeyS";
    KeyCode2[KeyCode2["KeyT"] = 50] = "KeyT";
    KeyCode2[KeyCode2["KeyU"] = 51] = "KeyU";
    KeyCode2[KeyCode2["KeyV"] = 52] = "KeyV";
    KeyCode2[KeyCode2["KeyW"] = 53] = "KeyW";
    KeyCode2[KeyCode2["KeyX"] = 54] = "KeyX";
    KeyCode2[KeyCode2["KeyY"] = 55] = "KeyY";
    KeyCode2[KeyCode2["KeyZ"] = 56] = "KeyZ";
    KeyCode2[KeyCode2["Meta"] = 57] = "Meta";
    KeyCode2[KeyCode2["ContextMenu"] = 58] = "ContextMenu";
    KeyCode2[KeyCode2["F1"] = 59] = "F1";
    KeyCode2[KeyCode2["F2"] = 60] = "F2";
    KeyCode2[KeyCode2["F3"] = 61] = "F3";
    KeyCode2[KeyCode2["F4"] = 62] = "F4";
    KeyCode2[KeyCode2["F5"] = 63] = "F5";
    KeyCode2[KeyCode2["F6"] = 64] = "F6";
    KeyCode2[KeyCode2["F7"] = 65] = "F7";
    KeyCode2[KeyCode2["F8"] = 66] = "F8";
    KeyCode2[KeyCode2["F9"] = 67] = "F9";
    KeyCode2[KeyCode2["F10"] = 68] = "F10";
    KeyCode2[KeyCode2["F11"] = 69] = "F11";
    KeyCode2[KeyCode2["F12"] = 70] = "F12";
    KeyCode2[KeyCode2["F13"] = 71] = "F13";
    KeyCode2[KeyCode2["F14"] = 72] = "F14";
    KeyCode2[KeyCode2["F15"] = 73] = "F15";
    KeyCode2[KeyCode2["F16"] = 74] = "F16";
    KeyCode2[KeyCode2["F17"] = 75] = "F17";
    KeyCode2[KeyCode2["F18"] = 76] = "F18";
    KeyCode2[KeyCode2["F19"] = 77] = "F19";
    KeyCode2[KeyCode2["F20"] = 78] = "F20";
    KeyCode2[KeyCode2["F21"] = 79] = "F21";
    KeyCode2[KeyCode2["F22"] = 80] = "F22";
    KeyCode2[KeyCode2["F23"] = 81] = "F23";
    KeyCode2[KeyCode2["F24"] = 82] = "F24";
    KeyCode2[KeyCode2["NumLock"] = 83] = "NumLock";
    KeyCode2[KeyCode2["ScrollLock"] = 84] = "ScrollLock";
    KeyCode2[KeyCode2["Semicolon"] = 85] = "Semicolon";
    KeyCode2[KeyCode2["Equal"] = 86] = "Equal";
    KeyCode2[KeyCode2["Comma"] = 87] = "Comma";
    KeyCode2[KeyCode2["Minus"] = 88] = "Minus";
    KeyCode2[KeyCode2["Period"] = 89] = "Period";
    KeyCode2[KeyCode2["Slash"] = 90] = "Slash";
    KeyCode2[KeyCode2["Backquote"] = 91] = "Backquote";
    KeyCode2[KeyCode2["BracketLeft"] = 92] = "BracketLeft";
    KeyCode2[KeyCode2["Backslash"] = 93] = "Backslash";
    KeyCode2[KeyCode2["BracketRight"] = 94] = "BracketRight";
    KeyCode2[KeyCode2["Quote"] = 95] = "Quote";
    KeyCode2[KeyCode2["OEM_8"] = 96] = "OEM_8";
    KeyCode2[KeyCode2["IntlBackslash"] = 97] = "IntlBackslash";
    KeyCode2[KeyCode2["Numpad0"] = 98] = "Numpad0";
    KeyCode2[KeyCode2["Numpad1"] = 99] = "Numpad1";
    KeyCode2[KeyCode2["Numpad2"] = 100] = "Numpad2";
    KeyCode2[KeyCode2["Numpad3"] = 101] = "Numpad3";
    KeyCode2[KeyCode2["Numpad4"] = 102] = "Numpad4";
    KeyCode2[KeyCode2["Numpad5"] = 103] = "Numpad5";
    KeyCode2[KeyCode2["Numpad6"] = 104] = "Numpad6";
    KeyCode2[KeyCode2["Numpad7"] = 105] = "Numpad7";
    KeyCode2[KeyCode2["Numpad8"] = 106] = "Numpad8";
    KeyCode2[KeyCode2["Numpad9"] = 107] = "Numpad9";
    KeyCode2[KeyCode2["NumpadMultiply"] = 108] = "NumpadMultiply";
    KeyCode2[KeyCode2["NumpadAdd"] = 109] = "NumpadAdd";
    KeyCode2[KeyCode2["NUMPAD_SEPARATOR"] = 110] = "NUMPAD_SEPARATOR";
    KeyCode2[KeyCode2["NumpadSubtract"] = 111] = "NumpadSubtract";
    KeyCode2[KeyCode2["NumpadDecimal"] = 112] = "NumpadDecimal";
    KeyCode2[KeyCode2["NumpadDivide"] = 113] = "NumpadDivide";
    KeyCode2[KeyCode2["KEY_IN_COMPOSITION"] = 114] = "KEY_IN_COMPOSITION";
    KeyCode2[KeyCode2["ABNT_C1"] = 115] = "ABNT_C1";
    KeyCode2[KeyCode2["ABNT_C2"] = 116] = "ABNT_C2";
    KeyCode2[KeyCode2["AudioVolumeMute"] = 117] = "AudioVolumeMute";
    KeyCode2[KeyCode2["AudioVolumeUp"] = 118] = "AudioVolumeUp";
    KeyCode2[KeyCode2["AudioVolumeDown"] = 119] = "AudioVolumeDown";
    KeyCode2[KeyCode2["BrowserSearch"] = 120] = "BrowserSearch";
    KeyCode2[KeyCode2["BrowserHome"] = 121] = "BrowserHome";
    KeyCode2[KeyCode2["BrowserBack"] = 122] = "BrowserBack";
    KeyCode2[KeyCode2["BrowserForward"] = 123] = "BrowserForward";
    KeyCode2[KeyCode2["MediaTrackNext"] = 124] = "MediaTrackNext";
    KeyCode2[KeyCode2["MediaTrackPrevious"] = 125] = "MediaTrackPrevious";
    KeyCode2[KeyCode2["MediaStop"] = 126] = "MediaStop";
    KeyCode2[KeyCode2["MediaPlayPause"] = 127] = "MediaPlayPause";
    KeyCode2[KeyCode2["LaunchMediaPlayer"] = 128] = "LaunchMediaPlayer";
    KeyCode2[KeyCode2["LaunchMail"] = 129] = "LaunchMail";
    KeyCode2[KeyCode2["LaunchApp2"] = 130] = "LaunchApp2";
    KeyCode2[KeyCode2["Clear"] = 131] = "Clear";
    KeyCode2[KeyCode2["MAX_VALUE"] = 132] = "MAX_VALUE";
  })(KeyCode || (KeyCode = {}));
  var MarkerSeverity;
  (function(MarkerSeverity2) {
    MarkerSeverity2[MarkerSeverity2["Hint"] = 1] = "Hint";
    MarkerSeverity2[MarkerSeverity2["Info"] = 2] = "Info";
    MarkerSeverity2[MarkerSeverity2["Warning"] = 4] = "Warning";
    MarkerSeverity2[MarkerSeverity2["Error"] = 8] = "Error";
  })(MarkerSeverity || (MarkerSeverity = {}));
  var MarkerTag;
  (function(MarkerTag2) {
    MarkerTag2[MarkerTag2["Unnecessary"] = 1] = "Unnecessary";
    MarkerTag2[MarkerTag2["Deprecated"] = 2] = "Deprecated";
  })(MarkerTag || (MarkerTag = {}));
  var MinimapPosition$1;
  (function(MinimapPosition2) {
    MinimapPosition2[MinimapPosition2["Inline"] = 1] = "Inline";
    MinimapPosition2[MinimapPosition2["Gutter"] = 2] = "Gutter";
  })(MinimapPosition$1 || (MinimapPosition$1 = {}));
  var MouseTargetType;
  (function(MouseTargetType2) {
    MouseTargetType2[MouseTargetType2["UNKNOWN"] = 0] = "UNKNOWN";
    MouseTargetType2[MouseTargetType2["TEXTAREA"] = 1] = "TEXTAREA";
    MouseTargetType2[MouseTargetType2["GUTTER_GLYPH_MARGIN"] = 2] = "GUTTER_GLYPH_MARGIN";
    MouseTargetType2[MouseTargetType2["GUTTER_LINE_NUMBERS"] = 3] = "GUTTER_LINE_NUMBERS";
    MouseTargetType2[MouseTargetType2["GUTTER_LINE_DECORATIONS"] = 4] = "GUTTER_LINE_DECORATIONS";
    MouseTargetType2[MouseTargetType2["GUTTER_VIEW_ZONE"] = 5] = "GUTTER_VIEW_ZONE";
    MouseTargetType2[MouseTargetType2["CONTENT_TEXT"] = 6] = "CONTENT_TEXT";
    MouseTargetType2[MouseTargetType2["CONTENT_EMPTY"] = 7] = "CONTENT_EMPTY";
    MouseTargetType2[MouseTargetType2["CONTENT_VIEW_ZONE"] = 8] = "CONTENT_VIEW_ZONE";
    MouseTargetType2[MouseTargetType2["CONTENT_WIDGET"] = 9] = "CONTENT_WIDGET";
    MouseTargetType2[MouseTargetType2["OVERVIEW_RULER"] = 10] = "OVERVIEW_RULER";
    MouseTargetType2[MouseTargetType2["SCROLLBAR"] = 11] = "SCROLLBAR";
    MouseTargetType2[MouseTargetType2["OVERLAY_WIDGET"] = 12] = "OVERLAY_WIDGET";
    MouseTargetType2[MouseTargetType2["OUTSIDE_EDITOR"] = 13] = "OUTSIDE_EDITOR";
  })(MouseTargetType || (MouseTargetType = {}));
  var OverlayWidgetPositionPreference;
  (function(OverlayWidgetPositionPreference2) {
    OverlayWidgetPositionPreference2[OverlayWidgetPositionPreference2["TOP_RIGHT_CORNER"] = 0] = "TOP_RIGHT_CORNER";
    OverlayWidgetPositionPreference2[OverlayWidgetPositionPreference2["BOTTOM_RIGHT_CORNER"] = 1] = "BOTTOM_RIGHT_CORNER";
    OverlayWidgetPositionPreference2[OverlayWidgetPositionPreference2["TOP_CENTER"] = 2] = "TOP_CENTER";
  })(OverlayWidgetPositionPreference || (OverlayWidgetPositionPreference = {}));
  var OverviewRulerLane$1;
  (function(OverviewRulerLane2) {
    OverviewRulerLane2[OverviewRulerLane2["Left"] = 1] = "Left";
    OverviewRulerLane2[OverviewRulerLane2["Center"] = 2] = "Center";
    OverviewRulerLane2[OverviewRulerLane2["Right"] = 4] = "Right";
    OverviewRulerLane2[OverviewRulerLane2["Full"] = 7] = "Full";
  })(OverviewRulerLane$1 || (OverviewRulerLane$1 = {}));
  var PositionAffinity;
  (function(PositionAffinity2) {
    PositionAffinity2[PositionAffinity2["Left"] = 0] = "Left";
    PositionAffinity2[PositionAffinity2["Right"] = 1] = "Right";
    PositionAffinity2[PositionAffinity2["None"] = 2] = "None";
    PositionAffinity2[PositionAffinity2["LeftOfInjectedText"] = 3] = "LeftOfInjectedText";
    PositionAffinity2[PositionAffinity2["RightOfInjectedText"] = 4] = "RightOfInjectedText";
  })(PositionAffinity || (PositionAffinity = {}));
  var RenderLineNumbersType;
  (function(RenderLineNumbersType2) {
    RenderLineNumbersType2[RenderLineNumbersType2["Off"] = 0] = "Off";
    RenderLineNumbersType2[RenderLineNumbersType2["On"] = 1] = "On";
    RenderLineNumbersType2[RenderLineNumbersType2["Relative"] = 2] = "Relative";
    RenderLineNumbersType2[RenderLineNumbersType2["Interval"] = 3] = "Interval";
    RenderLineNumbersType2[RenderLineNumbersType2["Custom"] = 4] = "Custom";
  })(RenderLineNumbersType || (RenderLineNumbersType = {}));
  var RenderMinimap;
  (function(RenderMinimap2) {
    RenderMinimap2[RenderMinimap2["None"] = 0] = "None";
    RenderMinimap2[RenderMinimap2["Text"] = 1] = "Text";
    RenderMinimap2[RenderMinimap2["Blocks"] = 2] = "Blocks";
  })(RenderMinimap || (RenderMinimap = {}));
  var ScrollType;
  (function(ScrollType2) {
    ScrollType2[ScrollType2["Smooth"] = 0] = "Smooth";
    ScrollType2[ScrollType2["Immediate"] = 1] = "Immediate";
  })(ScrollType || (ScrollType = {}));
  var ScrollbarVisibility;
  (function(ScrollbarVisibility2) {
    ScrollbarVisibility2[ScrollbarVisibility2["Auto"] = 1] = "Auto";
    ScrollbarVisibility2[ScrollbarVisibility2["Hidden"] = 2] = "Hidden";
    ScrollbarVisibility2[ScrollbarVisibility2["Visible"] = 3] = "Visible";
  })(ScrollbarVisibility || (ScrollbarVisibility = {}));
  var SelectionDirection;
  (function(SelectionDirection2) {
    SelectionDirection2[SelectionDirection2["LTR"] = 0] = "LTR";
    SelectionDirection2[SelectionDirection2["RTL"] = 1] = "RTL";
  })(SelectionDirection || (SelectionDirection = {}));
  var SignatureHelpTriggerKind;
  (function(SignatureHelpTriggerKind2) {
    SignatureHelpTriggerKind2[SignatureHelpTriggerKind2["Invoke"] = 1] = "Invoke";
    SignatureHelpTriggerKind2[SignatureHelpTriggerKind2["TriggerCharacter"] = 2] = "TriggerCharacter";
    SignatureHelpTriggerKind2[SignatureHelpTriggerKind2["ContentChange"] = 3] = "ContentChange";
  })(SignatureHelpTriggerKind || (SignatureHelpTriggerKind = {}));
  var SymbolKind$2;
  (function(SymbolKind2) {
    SymbolKind2[SymbolKind2["File"] = 0] = "File";
    SymbolKind2[SymbolKind2["Module"] = 1] = "Module";
    SymbolKind2[SymbolKind2["Namespace"] = 2] = "Namespace";
    SymbolKind2[SymbolKind2["Package"] = 3] = "Package";
    SymbolKind2[SymbolKind2["Class"] = 4] = "Class";
    SymbolKind2[SymbolKind2["Method"] = 5] = "Method";
    SymbolKind2[SymbolKind2["Property"] = 6] = "Property";
    SymbolKind2[SymbolKind2["Field"] = 7] = "Field";
    SymbolKind2[SymbolKind2["Constructor"] = 8] = "Constructor";
    SymbolKind2[SymbolKind2["Enum"] = 9] = "Enum";
    SymbolKind2[SymbolKind2["Interface"] = 10] = "Interface";
    SymbolKind2[SymbolKind2["Function"] = 11] = "Function";
    SymbolKind2[SymbolKind2["Variable"] = 12] = "Variable";
    SymbolKind2[SymbolKind2["Constant"] = 13] = "Constant";
    SymbolKind2[SymbolKind2["String"] = 14] = "String";
    SymbolKind2[SymbolKind2["Number"] = 15] = "Number";
    SymbolKind2[SymbolKind2["Boolean"] = 16] = "Boolean";
    SymbolKind2[SymbolKind2["Array"] = 17] = "Array";
    SymbolKind2[SymbolKind2["Object"] = 18] = "Object";
    SymbolKind2[SymbolKind2["Key"] = 19] = "Key";
    SymbolKind2[SymbolKind2["Null"] = 20] = "Null";
    SymbolKind2[SymbolKind2["EnumMember"] = 21] = "EnumMember";
    SymbolKind2[SymbolKind2["Struct"] = 22] = "Struct";
    SymbolKind2[SymbolKind2["Event"] = 23] = "Event";
    SymbolKind2[SymbolKind2["Operator"] = 24] = "Operator";
    SymbolKind2[SymbolKind2["TypeParameter"] = 25] = "TypeParameter";
  })(SymbolKind$2 || (SymbolKind$2 = {}));
  var SymbolTag$1;
  (function(SymbolTag2) {
    SymbolTag2[SymbolTag2["Deprecated"] = 1] = "Deprecated";
  })(SymbolTag$1 || (SymbolTag$1 = {}));
  var TextEditorCursorBlinkingStyle;
  (function(TextEditorCursorBlinkingStyle2) {
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Hidden"] = 0] = "Hidden";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Blink"] = 1] = "Blink";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Smooth"] = 2] = "Smooth";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Phase"] = 3] = "Phase";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Expand"] = 4] = "Expand";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Solid"] = 5] = "Solid";
  })(TextEditorCursorBlinkingStyle || (TextEditorCursorBlinkingStyle = {}));
  var TextEditorCursorStyle;
  (function(TextEditorCursorStyle2) {
    TextEditorCursorStyle2[TextEditorCursorStyle2["Line"] = 1] = "Line";
    TextEditorCursorStyle2[TextEditorCursorStyle2["Block"] = 2] = "Block";
    TextEditorCursorStyle2[TextEditorCursorStyle2["Underline"] = 3] = "Underline";
    TextEditorCursorStyle2[TextEditorCursorStyle2["LineThin"] = 4] = "LineThin";
    TextEditorCursorStyle2[TextEditorCursorStyle2["BlockOutline"] = 5] = "BlockOutline";
    TextEditorCursorStyle2[TextEditorCursorStyle2["UnderlineThin"] = 6] = "UnderlineThin";
  })(TextEditorCursorStyle || (TextEditorCursorStyle = {}));
  var TrackedRangeStickiness;
  (function(TrackedRangeStickiness2) {
    TrackedRangeStickiness2[TrackedRangeStickiness2["AlwaysGrowsWhenTypingAtEdges"] = 0] = "AlwaysGrowsWhenTypingAtEdges";
    TrackedRangeStickiness2[TrackedRangeStickiness2["NeverGrowsWhenTypingAtEdges"] = 1] = "NeverGrowsWhenTypingAtEdges";
    TrackedRangeStickiness2[TrackedRangeStickiness2["GrowsOnlyWhenTypingBefore"] = 2] = "GrowsOnlyWhenTypingBefore";
    TrackedRangeStickiness2[TrackedRangeStickiness2["GrowsOnlyWhenTypingAfter"] = 3] = "GrowsOnlyWhenTypingAfter";
  })(TrackedRangeStickiness || (TrackedRangeStickiness = {}));
  var WrappingIndent;
  (function(WrappingIndent2) {
    WrappingIndent2[WrappingIndent2["None"] = 0] = "None";
    WrappingIndent2[WrappingIndent2["Same"] = 1] = "Same";
    WrappingIndent2[WrappingIndent2["Indent"] = 2] = "Indent";
    WrappingIndent2[WrappingIndent2["DeepIndent"] = 3] = "DeepIndent";
  })(WrappingIndent || (WrappingIndent = {}));
  class KeyMod {
    static chord(firstPart, secondPart) {
      return KeyChord(firstPart, secondPart);
    }
  }
  KeyMod.CtrlCmd = 2048;
  KeyMod.Shift = 1024;
  KeyMod.Alt = 512;
  KeyMod.WinCtrl = 256;
  function createMonacoBaseAPI() {
    return {
      editor: void 0,
      languages: void 0,
      CancellationTokenSource,
      Emitter,
      KeyCode,
      KeyMod,
      Position: Position$1,
      Range: Range$b,
      Selection,
      SelectionDirection,
      MarkerSeverity,
      MarkerTag,
      Uri: URI$2,
      Token
    };
  }
  var OverviewRulerLane;
  (function(OverviewRulerLane2) {
    OverviewRulerLane2[OverviewRulerLane2["Left"] = 1] = "Left";
    OverviewRulerLane2[OverviewRulerLane2["Center"] = 2] = "Center";
    OverviewRulerLane2[OverviewRulerLane2["Right"] = 4] = "Right";
    OverviewRulerLane2[OverviewRulerLane2["Full"] = 7] = "Full";
  })(OverviewRulerLane || (OverviewRulerLane = {}));
  var GlyphMarginLane;
  (function(GlyphMarginLane2) {
    GlyphMarginLane2[GlyphMarginLane2["Left"] = 1] = "Left";
    GlyphMarginLane2[GlyphMarginLane2["Right"] = 2] = "Right";
  })(GlyphMarginLane || (GlyphMarginLane = {}));
  var MinimapPosition;
  (function(MinimapPosition2) {
    MinimapPosition2[MinimapPosition2["Inline"] = 1] = "Inline";
    MinimapPosition2[MinimapPosition2["Gutter"] = 2] = "Gutter";
  })(MinimapPosition || (MinimapPosition = {}));
  var InjectedTextCursorStops;
  (function(InjectedTextCursorStops2) {
    InjectedTextCursorStops2[InjectedTextCursorStops2["Both"] = 0] = "Both";
    InjectedTextCursorStops2[InjectedTextCursorStops2["Right"] = 1] = "Right";
    InjectedTextCursorStops2[InjectedTextCursorStops2["Left"] = 2] = "Left";
    InjectedTextCursorStops2[InjectedTextCursorStops2["None"] = 3] = "None";
  })(InjectedTextCursorStops || (InjectedTextCursorStops = {}));
  function leftIsWordBounday(wordSeparators, text2, textLength, matchStartIndex, matchLength) {
    if (matchStartIndex === 0) {
      return true;
    }
    const charBefore = text2.charCodeAt(matchStartIndex - 1);
    if (wordSeparators.get(charBefore) !== 0) {
      return true;
    }
    if (charBefore === 13 || charBefore === 10) {
      return true;
    }
    if (matchLength > 0) {
      const firstCharInMatch = text2.charCodeAt(matchStartIndex);
      if (wordSeparators.get(firstCharInMatch) !== 0) {
        return true;
      }
    }
    return false;
  }
  function rightIsWordBounday(wordSeparators, text2, textLength, matchStartIndex, matchLength) {
    if (matchStartIndex + matchLength === textLength) {
      return true;
    }
    const charAfter = text2.charCodeAt(matchStartIndex + matchLength);
    if (wordSeparators.get(charAfter) !== 0) {
      return true;
    }
    if (charAfter === 13 || charAfter === 10) {
      return true;
    }
    if (matchLength > 0) {
      const lastCharInMatch = text2.charCodeAt(matchStartIndex + matchLength - 1);
      if (wordSeparators.get(lastCharInMatch) !== 0) {
        return true;
      }
    }
    return false;
  }
  function isValidMatch(wordSeparators, text2, textLength, matchStartIndex, matchLength) {
    return leftIsWordBounday(wordSeparators, text2, textLength, matchStartIndex, matchLength) && rightIsWordBounday(wordSeparators, text2, textLength, matchStartIndex, matchLength);
  }
  class Searcher {
    constructor(wordSeparators, searchRegex) {
      this._wordSeparators = wordSeparators;
      this._searchRegex = searchRegex;
      this._prevMatchStartIndex = -1;
      this._prevMatchLength = 0;
    }
    reset(lastIndex) {
      this._searchRegex.lastIndex = lastIndex;
      this._prevMatchStartIndex = -1;
      this._prevMatchLength = 0;
    }
    next(text2) {
      const textLength = text2.length;
      let m;
      do {
        if (this._prevMatchStartIndex + this._prevMatchLength === textLength) {
          return null;
        }
        m = this._searchRegex.exec(text2);
        if (!m) {
          return null;
        }
        const matchStartIndex = m.index;
        const matchLength = m[0].length;
        if (matchStartIndex === this._prevMatchStartIndex && matchLength === this._prevMatchLength) {
          if (matchLength === 0) {
            if (getNextCodePoint(text2, textLength, this._searchRegex.lastIndex) > 65535) {
              this._searchRegex.lastIndex += 2;
            } else {
              this._searchRegex.lastIndex += 1;
            }
            continue;
          }
          return null;
        }
        this._prevMatchStartIndex = matchStartIndex;
        this._prevMatchLength = matchLength;
        if (!this._wordSeparators || isValidMatch(this._wordSeparators, text2, textLength, matchStartIndex, matchLength)) {
          return m;
        }
      } while (m);
      return null;
    }
  }
  function assertNever(value, message = "Unreachable") {
    throw new Error(message);
  }
  function assertFn(condition) {
    if (!condition()) {
      debugger;
      condition();
      onUnexpectedError(new BugIndicatingError("Assertion Failed"));
    }
  }
  function checkAdjacentItems(items, predicate) {
    let i = 0;
    while (i < items.length - 1) {
      const a2 = items[i];
      const b = items[i + 1];
      if (!predicate(a2, b)) {
        return false;
      }
      i++;
    }
    return true;
  }
  class UnicodeTextModelHighlighter {
    static computeUnicodeHighlights(model2, options, range2) {
      const startLine = range2 ? range2.startLineNumber : 1;
      const endLine = range2 ? range2.endLineNumber : model2.getLineCount();
      const codePointHighlighter = new CodePointHighlighter(options);
      const candidates = codePointHighlighter.getCandidateCodePoints();
      let regex;
      if (candidates === "allNonBasicAscii") {
        regex = new RegExp("[^\\t\\n\\r\\x20-\\x7E]", "g");
      } else {
        regex = new RegExp(`${buildRegExpCharClassExpr(Array.from(candidates))}`, "g");
      }
      const searcher = new Searcher(null, regex);
      const ranges = [];
      let hasMore = false;
      let m;
      let ambiguousCharacterCount = 0;
      let invisibleCharacterCount = 0;
      let nonBasicAsciiCharacterCount = 0;
      forLoop:
        for (let lineNumber = startLine, lineCount = endLine; lineNumber <= lineCount; lineNumber++) {
          const lineContent = model2.getLineContent(lineNumber);
          const lineLength = lineContent.length;
          searcher.reset(0);
          do {
            m = searcher.next(lineContent);
            if (m) {
              let startIndex = m.index;
              let endIndex = m.index + m[0].length;
              if (startIndex > 0) {
                const charCodeBefore = lineContent.charCodeAt(startIndex - 1);
                if (isHighSurrogate(charCodeBefore)) {
                  startIndex--;
                }
              }
              if (endIndex + 1 < lineLength) {
                const charCodeBefore = lineContent.charCodeAt(endIndex - 1);
                if (isHighSurrogate(charCodeBefore)) {
                  endIndex++;
                }
              }
              const str2 = lineContent.substring(startIndex, endIndex);
              let word = getWordAtText(startIndex + 1, DEFAULT_WORD_REGEXP, lineContent, 0);
              if (word && word.endColumn <= startIndex + 1) {
                word = null;
              }
              const highlightReason = codePointHighlighter.shouldHighlightNonBasicASCII(str2, word ? word.word : null);
              if (highlightReason !== 0) {
                if (highlightReason === 3) {
                  ambiguousCharacterCount++;
                } else if (highlightReason === 2) {
                  invisibleCharacterCount++;
                } else if (highlightReason === 1) {
                  nonBasicAsciiCharacterCount++;
                } else {
                  assertNever();
                }
                const MAX_RESULT_LENGTH = 1e3;
                if (ranges.length >= MAX_RESULT_LENGTH) {
                  hasMore = true;
                  break forLoop;
                }
                ranges.push(new Range$b(lineNumber, startIndex + 1, lineNumber, endIndex + 1));
              }
            }
          } while (m);
        }
      return {
        ranges,
        hasMore,
        ambiguousCharacterCount,
        invisibleCharacterCount,
        nonBasicAsciiCharacterCount
      };
    }
    static computeUnicodeHighlightReason(char, options) {
      const codePointHighlighter = new CodePointHighlighter(options);
      const reason = codePointHighlighter.shouldHighlightNonBasicASCII(char, null);
      switch (reason) {
        case 0:
          return null;
        case 2:
          return {
            kind: 1
            /* UnicodeHighlighterReasonKind.Invisible */
          };
        case 3: {
          const codePoint = char.codePointAt(0);
          const primaryConfusable = codePointHighlighter.ambiguousCharacters.getPrimaryConfusable(codePoint);
          const notAmbiguousInLocales = AmbiguousCharacters.getLocales().filter((l) => !AmbiguousCharacters.getInstance(/* @__PURE__ */ new Set([...options.allowedLocales, l])).isAmbiguous(codePoint));
          return { kind: 0, confusableWith: String.fromCodePoint(primaryConfusable), notAmbiguousInLocales };
        }
        case 1:
          return {
            kind: 2
            /* UnicodeHighlighterReasonKind.NonBasicAscii */
          };
      }
    }
  }
  function buildRegExpCharClassExpr(codePoints, flags) {
    const src = `[${escapeRegExpCharacters(codePoints.map((i) => String.fromCodePoint(i)).join(""))}]`;
    return src;
  }
  class CodePointHighlighter {
    constructor(options) {
      this.options = options;
      this.allowedCodePoints = new Set(options.allowedCodePoints);
      this.ambiguousCharacters = AmbiguousCharacters.getInstance(new Set(options.allowedLocales));
    }
    getCandidateCodePoints() {
      if (this.options.nonBasicASCII) {
        return "allNonBasicAscii";
      }
      const set2 = /* @__PURE__ */ new Set();
      if (this.options.invisibleCharacters) {
        for (const cp of InvisibleCharacters.codePoints) {
          if (!isAllowedInvisibleCharacter(String.fromCodePoint(cp))) {
            set2.add(cp);
          }
        }
      }
      if (this.options.ambiguousCharacters) {
        for (const cp of this.ambiguousCharacters.getConfusableCodePoints()) {
          set2.add(cp);
        }
      }
      for (const cp of this.allowedCodePoints) {
        set2.delete(cp);
      }
      return set2;
    }
    shouldHighlightNonBasicASCII(character, wordContext) {
      const codePoint = character.codePointAt(0);
      if (this.allowedCodePoints.has(codePoint)) {
        return 0;
      }
      if (this.options.nonBasicASCII) {
        return 1;
      }
      let hasBasicASCIICharacters = false;
      let hasNonConfusableNonBasicAsciiCharacter = false;
      if (wordContext) {
        for (const char of wordContext) {
          const codePoint2 = char.codePointAt(0);
          const isBasicASCII$1 = isBasicASCII(char);
          hasBasicASCIICharacters = hasBasicASCIICharacters || isBasicASCII$1;
          if (!isBasicASCII$1 && !this.ambiguousCharacters.isAmbiguous(codePoint2) && !InvisibleCharacters.isInvisibleCharacter(codePoint2)) {
            hasNonConfusableNonBasicAsciiCharacter = true;
          }
        }
      }
      if (
        /* Don't allow mixing weird looking characters with ASCII */
        !hasBasicASCIICharacters && /* Is there an obviously weird looking character? */
        hasNonConfusableNonBasicAsciiCharacter
      ) {
        return 0;
      }
      if (this.options.invisibleCharacters) {
        if (!isAllowedInvisibleCharacter(character) && InvisibleCharacters.isInvisibleCharacter(codePoint)) {
          return 2;
        }
      }
      if (this.options.ambiguousCharacters) {
        if (this.ambiguousCharacters.isAmbiguous(codePoint)) {
          return 3;
        }
      }
      return 0;
    }
  }
  function isAllowedInvisibleCharacter(character) {
    return character === " " || character === "\n" || character === "	";
  }
  class LineRange {
    static fromRange(range2) {
      return new LineRange(range2.startLineNumber, range2.endLineNumber);
    }
    static subtract(a2, b) {
      if (!b) {
        return [a2];
      }
      if (a2.startLineNumber < b.startLineNumber && b.endLineNumberExclusive < a2.endLineNumberExclusive) {
        return [
          new LineRange(a2.startLineNumber, b.startLineNumber),
          new LineRange(b.endLineNumberExclusive, a2.endLineNumberExclusive)
        ];
      } else if (b.startLineNumber <= a2.startLineNumber && a2.endLineNumberExclusive <= b.endLineNumberExclusive) {
        return [];
      } else if (b.endLineNumberExclusive < a2.endLineNumberExclusive) {
        return [new LineRange(Math.max(b.endLineNumberExclusive, a2.startLineNumber), a2.endLineNumberExclusive)];
      } else {
        return [new LineRange(a2.startLineNumber, Math.min(b.startLineNumber, a2.endLineNumberExclusive))];
      }
    }
    /**
     * @param lineRanges An array of sorted line ranges.
     */
    static joinMany(lineRanges) {
      if (lineRanges.length === 0) {
        return [];
      }
      let result = lineRanges[0];
      for (let i = 1; i < lineRanges.length; i++) {
        result = this.join(result, lineRanges[i]);
      }
      return result;
    }
    /**
     * @param lineRanges1 Must be sorted.
     * @param lineRanges2 Must be sorted.
     */
    static join(lineRanges1, lineRanges2) {
      if (lineRanges1.length === 0) {
        return lineRanges2;
      }
      if (lineRanges2.length === 0) {
        return lineRanges1;
      }
      const result = [];
      let i1 = 0;
      let i2 = 0;
      let current = null;
      while (i1 < lineRanges1.length || i2 < lineRanges2.length) {
        let next2 = null;
        if (i1 < lineRanges1.length && i2 < lineRanges2.length) {
          const lineRange1 = lineRanges1[i1];
          const lineRange2 = lineRanges2[i2];
          if (lineRange1.startLineNumber < lineRange2.startLineNumber) {
            next2 = lineRange1;
            i1++;
          } else {
            next2 = lineRange2;
            i2++;
          }
        } else if (i1 < lineRanges1.length) {
          next2 = lineRanges1[i1];
          i1++;
        } else {
          next2 = lineRanges2[i2];
          i2++;
        }
        if (current === null) {
          current = next2;
        } else {
          if (current.endLineNumberExclusive >= next2.startLineNumber) {
            current = new LineRange(current.startLineNumber, Math.max(current.endLineNumberExclusive, next2.endLineNumberExclusive));
          } else {
            result.push(current);
            current = next2;
          }
        }
      }
      if (current !== null) {
        result.push(current);
      }
      return result;
    }
    static ofLength(startLineNumber, length) {
      return new LineRange(startLineNumber, startLineNumber + length);
    }
    /**
     * @internal
     */
    static deserialize(lineRange) {
      return new LineRange(lineRange[0], lineRange[1]);
    }
    constructor(startLineNumber, endLineNumberExclusive) {
      if (startLineNumber > endLineNumberExclusive) {
        throw new BugIndicatingError(`startLineNumber ${startLineNumber} cannot be after endLineNumberExclusive ${endLineNumberExclusive}`);
      }
      this.startLineNumber = startLineNumber;
      this.endLineNumberExclusive = endLineNumberExclusive;
    }
    /**
     * Indicates if this line range contains the given line number.
     */
    contains(lineNumber) {
      return this.startLineNumber <= lineNumber && lineNumber < this.endLineNumberExclusive;
    }
    /**
     * Indicates if this line range is empty.
     */
    get isEmpty() {
      return this.startLineNumber === this.endLineNumberExclusive;
    }
    /**
     * Moves this line range by the given offset of line numbers.
     */
    delta(offset) {
      return new LineRange(this.startLineNumber + offset, this.endLineNumberExclusive + offset);
    }
    /**
     * The number of lines this line range spans.
     */
    get length() {
      return this.endLineNumberExclusive - this.startLineNumber;
    }
    /**
     * Creates a line range that combines this and the given line range.
     */
    join(other) {
      return new LineRange(Math.min(this.startLineNumber, other.startLineNumber), Math.max(this.endLineNumberExclusive, other.endLineNumberExclusive));
    }
    toString() {
      return `[${this.startLineNumber},${this.endLineNumberExclusive})`;
    }
    /**
     * The resulting range is empty if the ranges do not intersect, but touch.
     * If the ranges don't even touch, the result is undefined.
     */
    intersect(other) {
      const startLineNumber = Math.max(this.startLineNumber, other.startLineNumber);
      const endLineNumberExclusive = Math.min(this.endLineNumberExclusive, other.endLineNumberExclusive);
      if (startLineNumber <= endLineNumberExclusive) {
        return new LineRange(startLineNumber, endLineNumberExclusive);
      }
      return void 0;
    }
    intersectsStrict(other) {
      return this.startLineNumber < other.endLineNumberExclusive && other.startLineNumber < this.endLineNumberExclusive;
    }
    overlapOrTouch(other) {
      return this.startLineNumber <= other.endLineNumberExclusive && other.startLineNumber <= this.endLineNumberExclusive;
    }
    equals(b) {
      return this.startLineNumber === b.startLineNumber && this.endLineNumberExclusive === b.endLineNumberExclusive;
    }
    toInclusiveRange() {
      if (this.isEmpty) {
        return null;
      }
      return new Range$b(this.startLineNumber, 1, this.endLineNumberExclusive - 1, Number.MAX_SAFE_INTEGER);
    }
    toExclusiveRange() {
      return new Range$b(this.startLineNumber, 1, this.endLineNumberExclusive, 1);
    }
    mapToLineArray(f2) {
      const result = [];
      for (let lineNumber = this.startLineNumber; lineNumber < this.endLineNumberExclusive; lineNumber++) {
        result.push(f2(lineNumber));
      }
      return result;
    }
    forEach(f2) {
      for (let lineNumber = this.startLineNumber; lineNumber < this.endLineNumberExclusive; lineNumber++) {
        f2(lineNumber);
      }
    }
    /**
     * @internal
     */
    serialize() {
      return [this.startLineNumber, this.endLineNumberExclusive];
    }
    includes(lineNumber) {
      return this.startLineNumber <= lineNumber && lineNumber < this.endLineNumberExclusive;
    }
  }
  class LinesDiff {
    constructor(changes, moves, hitTimeout) {
      this.changes = changes;
      this.moves = moves;
      this.hitTimeout = hitTimeout;
    }
  }
  class LineRangeMapping {
    static inverse(mapping, originalLineCount, modifiedLineCount) {
      const result = [];
      let lastOriginalEndLineNumber = 1;
      let lastModifiedEndLineNumber = 1;
      for (const m of mapping) {
        const r2 = new LineRangeMapping(new LineRange(lastOriginalEndLineNumber, m.originalRange.startLineNumber), new LineRange(lastModifiedEndLineNumber, m.modifiedRange.startLineNumber), void 0);
        if (!r2.modifiedRange.isEmpty) {
          result.push(r2);
        }
        lastOriginalEndLineNumber = m.originalRange.endLineNumberExclusive;
        lastModifiedEndLineNumber = m.modifiedRange.endLineNumberExclusive;
      }
      const r = new LineRangeMapping(new LineRange(lastOriginalEndLineNumber, originalLineCount + 1), new LineRange(lastModifiedEndLineNumber, modifiedLineCount + 1), void 0);
      if (!r.modifiedRange.isEmpty) {
        result.push(r);
      }
      return result;
    }
    constructor(originalRange, modifiedRange, innerChanges) {
      this.originalRange = originalRange;
      this.modifiedRange = modifiedRange;
      this.innerChanges = innerChanges;
    }
    toString() {
      return `{${this.originalRange.toString()}->${this.modifiedRange.toString()}}`;
    }
    get changedLineCount() {
      return Math.max(this.originalRange.length, this.modifiedRange.length);
    }
    flip() {
      var _a2;
      return new LineRangeMapping(this.modifiedRange, this.originalRange, (_a2 = this.innerChanges) === null || _a2 === void 0 ? void 0 : _a2.map((c) => c.flip()));
    }
  }
  class RangeMapping {
    constructor(originalRange, modifiedRange) {
      this.originalRange = originalRange;
      this.modifiedRange = modifiedRange;
    }
    toString() {
      return `{${this.originalRange.toString()}->${this.modifiedRange.toString()}}`;
    }
    flip() {
      return new RangeMapping(this.modifiedRange, this.originalRange);
    }
  }
  class SimpleLineRangeMapping {
    constructor(original, modified) {
      this.original = original;
      this.modified = modified;
    }
    toString() {
      return `{${this.original.toString()}->${this.modified.toString()}}`;
    }
    flip() {
      return new SimpleLineRangeMapping(this.modified, this.original);
    }
  }
  class MovedText {
    constructor(lineRangeMapping, changes) {
      this.lineRangeMapping = lineRangeMapping;
      this.changes = changes;
    }
    flip() {
      return new MovedText(this.lineRangeMapping.flip(), this.changes.map((c) => c.flip()));
    }
  }
  const MINIMUM_MATCHING_CHARACTER_LENGTH = 3;
  class SmartLinesDiffComputer {
    computeDiff(originalLines, modifiedLines, options) {
      var _a2;
      const diffComputer = new DiffComputer(originalLines, modifiedLines, {
        maxComputationTime: options.maxComputationTimeMs,
        shouldIgnoreTrimWhitespace: options.ignoreTrimWhitespace,
        shouldComputeCharChanges: true,
        shouldMakePrettyDiff: true,
        shouldPostProcessCharChanges: true
      });
      const result = diffComputer.computeDiff();
      const changes = [];
      let lastChange = null;
      for (const c of result.changes) {
        let originalRange;
        if (c.originalEndLineNumber === 0) {
          originalRange = new LineRange(c.originalStartLineNumber + 1, c.originalStartLineNumber + 1);
        } else {
          originalRange = new LineRange(c.originalStartLineNumber, c.originalEndLineNumber + 1);
        }
        let modifiedRange;
        if (c.modifiedEndLineNumber === 0) {
          modifiedRange = new LineRange(c.modifiedStartLineNumber + 1, c.modifiedStartLineNumber + 1);
        } else {
          modifiedRange = new LineRange(c.modifiedStartLineNumber, c.modifiedEndLineNumber + 1);
        }
        let change = new LineRangeMapping(originalRange, modifiedRange, (_a2 = c.charChanges) === null || _a2 === void 0 ? void 0 : _a2.map((c2) => new RangeMapping(new Range$b(c2.originalStartLineNumber, c2.originalStartColumn, c2.originalEndLineNumber, c2.originalEndColumn), new Range$b(c2.modifiedStartLineNumber, c2.modifiedStartColumn, c2.modifiedEndLineNumber, c2.modifiedEndColumn))));
        if (lastChange) {
          if (lastChange.modifiedRange.endLineNumberExclusive === change.modifiedRange.startLineNumber || lastChange.originalRange.endLineNumberExclusive === change.originalRange.startLineNumber) {
            change = new LineRangeMapping(lastChange.originalRange.join(change.originalRange), lastChange.modifiedRange.join(change.modifiedRange), lastChange.innerChanges && change.innerChanges ? lastChange.innerChanges.concat(change.innerChanges) : void 0);
            changes.pop();
          }
        }
        changes.push(change);
        lastChange = change;
      }
      assertFn(() => {
        return checkAdjacentItems(changes, (m1, m2) => m2.originalRange.startLineNumber - m1.originalRange.endLineNumberExclusive === m2.modifiedRange.startLineNumber - m1.modifiedRange.endLineNumberExclusive && // There has to be an unchanged line in between (otherwise both diffs should have been joined)
        m1.originalRange.endLineNumberExclusive < m2.originalRange.startLineNumber && m1.modifiedRange.endLineNumberExclusive < m2.modifiedRange.startLineNumber);
      });
      return new LinesDiff(changes, [], result.quitEarly);
    }
  }
  function computeDiff(originalSequence, modifiedSequence, continueProcessingPredicate, pretty) {
    const diffAlgo = new LcsDiff(originalSequence, modifiedSequence, continueProcessingPredicate);
    return diffAlgo.ComputeDiff(pretty);
  }
  let LineSequence$1 = class LineSequence {
    constructor(lines) {
      const startColumns = [];
      const endColumns = [];
      for (let i = 0, length = lines.length; i < length; i++) {
        startColumns[i] = getFirstNonBlankColumn(lines[i], 1);
        endColumns[i] = getLastNonBlankColumn(lines[i], 1);
      }
      this.lines = lines;
      this._startColumns = startColumns;
      this._endColumns = endColumns;
    }
    getElements() {
      const elements = [];
      for (let i = 0, len2 = this.lines.length; i < len2; i++) {
        elements[i] = this.lines[i].substring(this._startColumns[i] - 1, this._endColumns[i] - 1);
      }
      return elements;
    }
    getStrictElement(index2) {
      return this.lines[index2];
    }
    getStartLineNumber(i) {
      return i + 1;
    }
    getEndLineNumber(i) {
      return i + 1;
    }
    createCharSequence(shouldIgnoreTrimWhitespace, startIndex, endIndex) {
      const charCodes = [];
      const lineNumbers = [];
      const columns = [];
      let len2 = 0;
      for (let index2 = startIndex; index2 <= endIndex; index2++) {
        const lineContent = this.lines[index2];
        const startColumn = shouldIgnoreTrimWhitespace ? this._startColumns[index2] : 1;
        const endColumn = shouldIgnoreTrimWhitespace ? this._endColumns[index2] : lineContent.length + 1;
        for (let col = startColumn; col < endColumn; col++) {
          charCodes[len2] = lineContent.charCodeAt(col - 1);
          lineNumbers[len2] = index2 + 1;
          columns[len2] = col;
          len2++;
        }
        if (!shouldIgnoreTrimWhitespace && index2 < endIndex) {
          charCodes[len2] = 10;
          lineNumbers[len2] = index2 + 1;
          columns[len2] = lineContent.length + 1;
          len2++;
        }
      }
      return new CharSequence(charCodes, lineNumbers, columns);
    }
  };
  class CharSequence {
    constructor(charCodes, lineNumbers, columns) {
      this._charCodes = charCodes;
      this._lineNumbers = lineNumbers;
      this._columns = columns;
    }
    toString() {
      return "[" + this._charCodes.map((s, idx) => (s === 10 ? "\\n" : String.fromCharCode(s)) + `-(${this._lineNumbers[idx]},${this._columns[idx]})`).join(", ") + "]";
    }
    _assertIndex(index2, arr) {
      if (index2 < 0 || index2 >= arr.length) {
        throw new Error(`Illegal index`);
      }
    }
    getElements() {
      return this._charCodes;
    }
    getStartLineNumber(i) {
      if (i > 0 && i === this._lineNumbers.length) {
        return this.getEndLineNumber(i - 1);
      }
      this._assertIndex(i, this._lineNumbers);
      return this._lineNumbers[i];
    }
    getEndLineNumber(i) {
      if (i === -1) {
        return this.getStartLineNumber(i + 1);
      }
      this._assertIndex(i, this._lineNumbers);
      if (this._charCodes[i] === 10) {
        return this._lineNumbers[i] + 1;
      }
      return this._lineNumbers[i];
    }
    getStartColumn(i) {
      if (i > 0 && i === this._columns.length) {
        return this.getEndColumn(i - 1);
      }
      this._assertIndex(i, this._columns);
      return this._columns[i];
    }
    getEndColumn(i) {
      if (i === -1) {
        return this.getStartColumn(i + 1);
      }
      this._assertIndex(i, this._columns);
      if (this._charCodes[i] === 10) {
        return 1;
      }
      return this._columns[i] + 1;
    }
  }
  class CharChange {
    constructor(originalStartLineNumber, originalStartColumn, originalEndLineNumber, originalEndColumn, modifiedStartLineNumber, modifiedStartColumn, modifiedEndLineNumber, modifiedEndColumn) {
      this.originalStartLineNumber = originalStartLineNumber;
      this.originalStartColumn = originalStartColumn;
      this.originalEndLineNumber = originalEndLineNumber;
      this.originalEndColumn = originalEndColumn;
      this.modifiedStartLineNumber = modifiedStartLineNumber;
      this.modifiedStartColumn = modifiedStartColumn;
      this.modifiedEndLineNumber = modifiedEndLineNumber;
      this.modifiedEndColumn = modifiedEndColumn;
    }
    static createFromDiffChange(diffChange, originalCharSequence, modifiedCharSequence) {
      const originalStartLineNumber = originalCharSequence.getStartLineNumber(diffChange.originalStart);
      const originalStartColumn = originalCharSequence.getStartColumn(diffChange.originalStart);
      const originalEndLineNumber = originalCharSequence.getEndLineNumber(diffChange.originalStart + diffChange.originalLength - 1);
      const originalEndColumn = originalCharSequence.getEndColumn(diffChange.originalStart + diffChange.originalLength - 1);
      const modifiedStartLineNumber = modifiedCharSequence.getStartLineNumber(diffChange.modifiedStart);
      const modifiedStartColumn = modifiedCharSequence.getStartColumn(diffChange.modifiedStart);
      const modifiedEndLineNumber = modifiedCharSequence.getEndLineNumber(diffChange.modifiedStart + diffChange.modifiedLength - 1);
      const modifiedEndColumn = modifiedCharSequence.getEndColumn(diffChange.modifiedStart + diffChange.modifiedLength - 1);
      return new CharChange(originalStartLineNumber, originalStartColumn, originalEndLineNumber, originalEndColumn, modifiedStartLineNumber, modifiedStartColumn, modifiedEndLineNumber, modifiedEndColumn);
    }
  }
  function postProcessCharChanges(rawChanges) {
    if (rawChanges.length <= 1) {
      return rawChanges;
    }
    const result = [rawChanges[0]];
    let prevChange = result[0];
    for (let i = 1, len2 = rawChanges.length; i < len2; i++) {
      const currChange = rawChanges[i];
      const originalMatchingLength = currChange.originalStart - (prevChange.originalStart + prevChange.originalLength);
      const modifiedMatchingLength = currChange.modifiedStart - (prevChange.modifiedStart + prevChange.modifiedLength);
      const matchingLength = Math.min(originalMatchingLength, modifiedMatchingLength);
      if (matchingLength < MINIMUM_MATCHING_CHARACTER_LENGTH) {
        prevChange.originalLength = currChange.originalStart + currChange.originalLength - prevChange.originalStart;
        prevChange.modifiedLength = currChange.modifiedStart + currChange.modifiedLength - prevChange.modifiedStart;
      } else {
        result.push(currChange);
        prevChange = currChange;
      }
    }
    return result;
  }
  class LineChange {
    constructor(originalStartLineNumber, originalEndLineNumber, modifiedStartLineNumber, modifiedEndLineNumber, charChanges) {
      this.originalStartLineNumber = originalStartLineNumber;
      this.originalEndLineNumber = originalEndLineNumber;
      this.modifiedStartLineNumber = modifiedStartLineNumber;
      this.modifiedEndLineNumber = modifiedEndLineNumber;
      this.charChanges = charChanges;
    }
    static createFromDiffResult(shouldIgnoreTrimWhitespace, diffChange, originalLineSequence, modifiedLineSequence, continueCharDiff, shouldComputeCharChanges, shouldPostProcessCharChanges) {
      let originalStartLineNumber;
      let originalEndLineNumber;
      let modifiedStartLineNumber;
      let modifiedEndLineNumber;
      let charChanges = void 0;
      if (diffChange.originalLength === 0) {
        originalStartLineNumber = originalLineSequence.getStartLineNumber(diffChange.originalStart) - 1;
        originalEndLineNumber = 0;
      } else {
        originalStartLineNumber = originalLineSequence.getStartLineNumber(diffChange.originalStart);
        originalEndLineNumber = originalLineSequence.getEndLineNumber(diffChange.originalStart + diffChange.originalLength - 1);
      }
      if (diffChange.modifiedLength === 0) {
        modifiedStartLineNumber = modifiedLineSequence.getStartLineNumber(diffChange.modifiedStart) - 1;
        modifiedEndLineNumber = 0;
      } else {
        modifiedStartLineNumber = modifiedLineSequence.getStartLineNumber(diffChange.modifiedStart);
        modifiedEndLineNumber = modifiedLineSequence.getEndLineNumber(diffChange.modifiedStart + diffChange.modifiedLength - 1);
      }
      if (shouldComputeCharChanges && diffChange.originalLength > 0 && diffChange.originalLength < 20 && diffChange.modifiedLength > 0 && diffChange.modifiedLength < 20 && continueCharDiff()) {
        const originalCharSequence = originalLineSequence.createCharSequence(shouldIgnoreTrimWhitespace, diffChange.originalStart, diffChange.originalStart + diffChange.originalLength - 1);
        const modifiedCharSequence = modifiedLineSequence.createCharSequence(shouldIgnoreTrimWhitespace, diffChange.modifiedStart, diffChange.modifiedStart + diffChange.modifiedLength - 1);
        if (originalCharSequence.getElements().length > 0 && modifiedCharSequence.getElements().length > 0) {
          let rawChanges = computeDiff(originalCharSequence, modifiedCharSequence, continueCharDiff, true).changes;
          if (shouldPostProcessCharChanges) {
            rawChanges = postProcessCharChanges(rawChanges);
          }
          charChanges = [];
          for (let i = 0, length = rawChanges.length; i < length; i++) {
            charChanges.push(CharChange.createFromDiffChange(rawChanges[i], originalCharSequence, modifiedCharSequence));
          }
        }
      }
      return new LineChange(originalStartLineNumber, originalEndLineNumber, modifiedStartLineNumber, modifiedEndLineNumber, charChanges);
    }
  }
  class DiffComputer {
    constructor(originalLines, modifiedLines, opts) {
      this.shouldComputeCharChanges = opts.shouldComputeCharChanges;
      this.shouldPostProcessCharChanges = opts.shouldPostProcessCharChanges;
      this.shouldIgnoreTrimWhitespace = opts.shouldIgnoreTrimWhitespace;
      this.shouldMakePrettyDiff = opts.shouldMakePrettyDiff;
      this.originalLines = originalLines;
      this.modifiedLines = modifiedLines;
      this.original = new LineSequence$1(originalLines);
      this.modified = new LineSequence$1(modifiedLines);
      this.continueLineDiff = createContinueProcessingPredicate(opts.maxComputationTime);
      this.continueCharDiff = createContinueProcessingPredicate(opts.maxComputationTime === 0 ? 0 : Math.min(opts.maxComputationTime, 5e3));
    }
    computeDiff() {
      if (this.original.lines.length === 1 && this.original.lines[0].length === 0) {
        if (this.modified.lines.length === 1 && this.modified.lines[0].length === 0) {
          return {
            quitEarly: false,
            changes: []
          };
        }
        return {
          quitEarly: false,
          changes: [{
            originalStartLineNumber: 1,
            originalEndLineNumber: 1,
            modifiedStartLineNumber: 1,
            modifiedEndLineNumber: this.modified.lines.length,
            charChanges: void 0
          }]
        };
      }
      if (this.modified.lines.length === 1 && this.modified.lines[0].length === 0) {
        return {
          quitEarly: false,
          changes: [{
            originalStartLineNumber: 1,
            originalEndLineNumber: this.original.lines.length,
            modifiedStartLineNumber: 1,
            modifiedEndLineNumber: 1,
            charChanges: void 0
          }]
        };
      }
      const diffResult = computeDiff(this.original, this.modified, this.continueLineDiff, this.shouldMakePrettyDiff);
      const rawChanges = diffResult.changes;
      const quitEarly = diffResult.quitEarly;
      if (this.shouldIgnoreTrimWhitespace) {
        const lineChanges = [];
        for (let i = 0, length = rawChanges.length; i < length; i++) {
          lineChanges.push(LineChange.createFromDiffResult(this.shouldIgnoreTrimWhitespace, rawChanges[i], this.original, this.modified, this.continueCharDiff, this.shouldComputeCharChanges, this.shouldPostProcessCharChanges));
        }
        return {
          quitEarly,
          changes: lineChanges
        };
      }
      const result = [];
      let originalLineIndex = 0;
      let modifiedLineIndex = 0;
      for (let i = -1, len2 = rawChanges.length; i < len2; i++) {
        const nextChange = i + 1 < len2 ? rawChanges[i + 1] : null;
        const originalStop = nextChange ? nextChange.originalStart : this.originalLines.length;
        const modifiedStop = nextChange ? nextChange.modifiedStart : this.modifiedLines.length;
        while (originalLineIndex < originalStop && modifiedLineIndex < modifiedStop) {
          const originalLine = this.originalLines[originalLineIndex];
          const modifiedLine = this.modifiedLines[modifiedLineIndex];
          if (originalLine !== modifiedLine) {
            {
              let originalStartColumn = getFirstNonBlankColumn(originalLine, 1);
              let modifiedStartColumn = getFirstNonBlankColumn(modifiedLine, 1);
              while (originalStartColumn > 1 && modifiedStartColumn > 1) {
                const originalChar = originalLine.charCodeAt(originalStartColumn - 2);
                const modifiedChar = modifiedLine.charCodeAt(modifiedStartColumn - 2);
                if (originalChar !== modifiedChar) {
                  break;
                }
                originalStartColumn--;
                modifiedStartColumn--;
              }
              if (originalStartColumn > 1 || modifiedStartColumn > 1) {
                this._pushTrimWhitespaceCharChange(result, originalLineIndex + 1, 1, originalStartColumn, modifiedLineIndex + 1, 1, modifiedStartColumn);
              }
            }
            {
              let originalEndColumn = getLastNonBlankColumn(originalLine, 1);
              let modifiedEndColumn = getLastNonBlankColumn(modifiedLine, 1);
              const originalMaxColumn = originalLine.length + 1;
              const modifiedMaxColumn = modifiedLine.length + 1;
              while (originalEndColumn < originalMaxColumn && modifiedEndColumn < modifiedMaxColumn) {
                const originalChar = originalLine.charCodeAt(originalEndColumn - 1);
                const modifiedChar = originalLine.charCodeAt(modifiedEndColumn - 1);
                if (originalChar !== modifiedChar) {
                  break;
                }
                originalEndColumn++;
                modifiedEndColumn++;
              }
              if (originalEndColumn < originalMaxColumn || modifiedEndColumn < modifiedMaxColumn) {
                this._pushTrimWhitespaceCharChange(result, originalLineIndex + 1, originalEndColumn, originalMaxColumn, modifiedLineIndex + 1, modifiedEndColumn, modifiedMaxColumn);
              }
            }
          }
          originalLineIndex++;
          modifiedLineIndex++;
        }
        if (nextChange) {
          result.push(LineChange.createFromDiffResult(this.shouldIgnoreTrimWhitespace, nextChange, this.original, this.modified, this.continueCharDiff, this.shouldComputeCharChanges, this.shouldPostProcessCharChanges));
          originalLineIndex += nextChange.originalLength;
          modifiedLineIndex += nextChange.modifiedLength;
        }
      }
      return {
        quitEarly,
        changes: result
      };
    }
    _pushTrimWhitespaceCharChange(result, originalLineNumber, originalStartColumn, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedEndColumn) {
      if (this._mergeTrimWhitespaceCharChange(result, originalLineNumber, originalStartColumn, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedEndColumn)) {
        return;
      }
      let charChanges = void 0;
      if (this.shouldComputeCharChanges) {
        charChanges = [new CharChange(originalLineNumber, originalStartColumn, originalLineNumber, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedLineNumber, modifiedEndColumn)];
      }
      result.push(new LineChange(originalLineNumber, originalLineNumber, modifiedLineNumber, modifiedLineNumber, charChanges));
    }
    _mergeTrimWhitespaceCharChange(result, originalLineNumber, originalStartColumn, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedEndColumn) {
      const len2 = result.length;
      if (len2 === 0) {
        return false;
      }
      const prevChange = result[len2 - 1];
      if (prevChange.originalEndLineNumber === 0 || prevChange.modifiedEndLineNumber === 0) {
        return false;
      }
      if (prevChange.originalEndLineNumber === originalLineNumber && prevChange.modifiedEndLineNumber === modifiedLineNumber) {
        if (this.shouldComputeCharChanges && prevChange.charChanges) {
          prevChange.charChanges.push(new CharChange(originalLineNumber, originalStartColumn, originalLineNumber, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedLineNumber, modifiedEndColumn));
        }
        return true;
      }
      if (prevChange.originalEndLineNumber + 1 === originalLineNumber && prevChange.modifiedEndLineNumber + 1 === modifiedLineNumber) {
        prevChange.originalEndLineNumber = originalLineNumber;
        prevChange.modifiedEndLineNumber = modifiedLineNumber;
        if (this.shouldComputeCharChanges && prevChange.charChanges) {
          prevChange.charChanges.push(new CharChange(originalLineNumber, originalStartColumn, originalLineNumber, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedLineNumber, modifiedEndColumn));
        }
        return true;
      }
      return false;
    }
  }
  function getFirstNonBlankColumn(txt, defaultValue) {
    const r = firstNonWhitespaceIndex(txt);
    if (r === -1) {
      return defaultValue;
    }
    return r + 1;
  }
  function getLastNonBlankColumn(txt, defaultValue) {
    const r = lastNonWhitespaceIndex(txt);
    if (r === -1) {
      return defaultValue;
    }
    return r + 2;
  }
  function createContinueProcessingPredicate(maximumRuntime) {
    if (maximumRuntime === 0) {
      return () => true;
    }
    const startTime = Date.now();
    return () => {
      return Date.now() - startTime < maximumRuntime;
    };
  }
  class OffsetRange {
    static addRange(range2, sortedRanges) {
      let i = 0;
      while (i < sortedRanges.length && sortedRanges[i].endExclusive < range2.start) {
        i++;
      }
      let j = i;
      while (j < sortedRanges.length && sortedRanges[j].start <= range2.endExclusive) {
        j++;
      }
      if (i === j) {
        sortedRanges.splice(i, 0, range2);
      } else {
        const start = Math.min(range2.start, sortedRanges[i].start);
        const end = Math.max(range2.endExclusive, sortedRanges[j - 1].endExclusive);
        sortedRanges.splice(i, j - i, new OffsetRange(start, end));
      }
    }
    static tryCreate(start, endExclusive) {
      if (start > endExclusive) {
        return void 0;
      }
      return new OffsetRange(start, endExclusive);
    }
    constructor(start, endExclusive) {
      this.start = start;
      this.endExclusive = endExclusive;
      if (start > endExclusive) {
        throw new BugIndicatingError(`Invalid range: ${this.toString()}`);
      }
    }
    get isEmpty() {
      return this.start === this.endExclusive;
    }
    delta(offset) {
      return new OffsetRange(this.start + offset, this.endExclusive + offset);
    }
    get length() {
      return this.endExclusive - this.start;
    }
    toString() {
      return `[${this.start}, ${this.endExclusive})`;
    }
    equals(other) {
      return this.start === other.start && this.endExclusive === other.endExclusive;
    }
    containsRange(other) {
      return this.start <= other.start && other.endExclusive <= this.endExclusive;
    }
    contains(offset) {
      return this.start <= offset && offset < this.endExclusive;
    }
    /**
     * for all numbers n: range1.contains(n) or range2.contains(n) => range1.join(range2).contains(n)
     * The joined range is the smallest range that contains both ranges.
     */
    join(other) {
      return new OffsetRange(Math.min(this.start, other.start), Math.max(this.endExclusive, other.endExclusive));
    }
    /**
     * for all numbers n: range1.contains(n) and range2.contains(n) <=> range1.intersect(range2).contains(n)
     *
     * The resulting range is empty if the ranges do not intersect, but touch.
     * If the ranges don't even touch, the result is undefined.
     */
    intersect(other) {
      const start = Math.max(this.start, other.start);
      const end = Math.min(this.endExclusive, other.endExclusive);
      if (start <= end) {
        return new OffsetRange(start, end);
      }
      return void 0;
    }
  }
  class DiffAlgorithmResult {
    static trivial(seq1, seq2) {
      return new DiffAlgorithmResult([new SequenceDiff(new OffsetRange(0, seq1.length), new OffsetRange(0, seq2.length))], false);
    }
    static trivialTimedOut(seq1, seq2) {
      return new DiffAlgorithmResult([new SequenceDiff(new OffsetRange(0, seq1.length), new OffsetRange(0, seq2.length))], true);
    }
    constructor(diffs, hitTimeout) {
      this.diffs = diffs;
      this.hitTimeout = hitTimeout;
    }
  }
  class SequenceDiff {
    constructor(seq1Range, seq2Range) {
      this.seq1Range = seq1Range;
      this.seq2Range = seq2Range;
    }
    reverse() {
      return new SequenceDiff(this.seq2Range, this.seq1Range);
    }
    toString() {
      return `${this.seq1Range} <-> ${this.seq2Range}`;
    }
    join(other) {
      return new SequenceDiff(this.seq1Range.join(other.seq1Range), this.seq2Range.join(other.seq2Range));
    }
    delta(offset) {
      if (offset === 0) {
        return this;
      }
      return new SequenceDiff(this.seq1Range.delta(offset), this.seq2Range.delta(offset));
    }
  }
  class InfiniteTimeout {
    isValid() {
      return true;
    }
  }
  InfiniteTimeout.instance = new InfiniteTimeout();
  class DateTimeout {
    constructor(timeout) {
      this.timeout = timeout;
      this.startTime = Date.now();
      this.valid = true;
      if (timeout <= 0) {
        throw new BugIndicatingError("timeout must be positive");
      }
    }
    // Recommendation: Set a log-point `{this.disable()}` in the body
    isValid() {
      const valid2 = Date.now() - this.startTime < this.timeout;
      if (!valid2 && this.valid) {
        this.valid = false;
        debugger;
      }
      return this.valid;
    }
  }
  class Array2D {
    constructor(width, height) {
      this.width = width;
      this.height = height;
      this.array = [];
      this.array = new Array(width * height);
    }
    get(x, y) {
      return this.array[x + y * this.width];
    }
    set(x, y, value) {
      this.array[x + y * this.width] = value;
    }
  }
  class DynamicProgrammingDiffing {
    compute(sequence1, sequence2, timeout = InfiniteTimeout.instance, equalityScore) {
      if (sequence1.length === 0 || sequence2.length === 0) {
        return DiffAlgorithmResult.trivial(sequence1, sequence2);
      }
      const lcsLengths = new Array2D(sequence1.length, sequence2.length);
      const directions = new Array2D(sequence1.length, sequence2.length);
      const lengths = new Array2D(sequence1.length, sequence2.length);
      for (let s12 = 0; s12 < sequence1.length; s12++) {
        for (let s22 = 0; s22 < sequence2.length; s22++) {
          if (!timeout.isValid()) {
            return DiffAlgorithmResult.trivialTimedOut(sequence1, sequence2);
          }
          const horizontalLen = s12 === 0 ? 0 : lcsLengths.get(s12 - 1, s22);
          const verticalLen = s22 === 0 ? 0 : lcsLengths.get(s12, s22 - 1);
          let extendedSeqScore;
          if (sequence1.getElement(s12) === sequence2.getElement(s22)) {
            if (s12 === 0 || s22 === 0) {
              extendedSeqScore = 0;
            } else {
              extendedSeqScore = lcsLengths.get(s12 - 1, s22 - 1);
            }
            if (s12 > 0 && s22 > 0 && directions.get(s12 - 1, s22 - 1) === 3) {
              extendedSeqScore += lengths.get(s12 - 1, s22 - 1);
            }
            extendedSeqScore += equalityScore ? equalityScore(s12, s22) : 1;
          } else {
            extendedSeqScore = -1;
          }
          const newValue = Math.max(horizontalLen, verticalLen, extendedSeqScore);
          if (newValue === extendedSeqScore) {
            const prevLen = s12 > 0 && s22 > 0 ? lengths.get(s12 - 1, s22 - 1) : 0;
            lengths.set(s12, s22, prevLen + 1);
            directions.set(s12, s22, 3);
          } else if (newValue === horizontalLen) {
            lengths.set(s12, s22, 0);
            directions.set(s12, s22, 1);
          } else if (newValue === verticalLen) {
            lengths.set(s12, s22, 0);
            directions.set(s12, s22, 2);
          }
          lcsLengths.set(s12, s22, newValue);
        }
      }
      const result = [];
      let lastAligningPosS1 = sequence1.length;
      let lastAligningPosS2 = sequence2.length;
      function reportDecreasingAligningPositions(s12, s22) {
        if (s12 + 1 !== lastAligningPosS1 || s22 + 1 !== lastAligningPosS2) {
          result.push(new SequenceDiff(new OffsetRange(s12 + 1, lastAligningPosS1), new OffsetRange(s22 + 1, lastAligningPosS2)));
        }
        lastAligningPosS1 = s12;
        lastAligningPosS2 = s22;
      }
      let s1 = sequence1.length - 1;
      let s2 = sequence2.length - 1;
      while (s1 >= 0 && s2 >= 0) {
        if (directions.get(s1, s2) === 3) {
          reportDecreasingAligningPositions(s1, s2);
          s1--;
          s2--;
        } else {
          if (directions.get(s1, s2) === 1) {
            s1--;
          } else {
            s2--;
          }
        }
      }
      reportDecreasingAligningPositions(-1, -1);
      result.reverse();
      return new DiffAlgorithmResult(result, false);
    }
  }
  function optimizeSequenceDiffs(sequence1, sequence2, sequenceDiffs) {
    let result = sequenceDiffs;
    result = joinSequenceDiffs(sequence1, sequence2, result);
    result = shiftSequenceDiffs(sequence1, sequence2, result);
    return result;
  }
  function smoothenSequenceDiffs(sequence1, sequence2, sequenceDiffs) {
    const result = [];
    for (const s of sequenceDiffs) {
      const last2 = result[result.length - 1];
      if (!last2) {
        result.push(s);
        continue;
      }
      if (s.seq1Range.start - last2.seq1Range.endExclusive <= 2 || s.seq2Range.start - last2.seq2Range.endExclusive <= 2) {
        result[result.length - 1] = new SequenceDiff(last2.seq1Range.join(s.seq1Range), last2.seq2Range.join(s.seq2Range));
      } else {
        result.push(s);
      }
    }
    return result;
  }
  function removeRandomMatches(sequence1, sequence2, sequenceDiffs) {
    let diffs = sequenceDiffs;
    if (diffs.length === 0) {
      return diffs;
    }
    let counter = 0;
    let shouldRepeat;
    do {
      shouldRepeat = false;
      const result = [
        diffs[0]
      ];
      for (let i = 1; i < diffs.length; i++) {
        let shouldJoinDiffs = function(before, after) {
          const unchangedRange = new OffsetRange(lastResult.seq1Range.endExclusive, cur.seq1Range.start);
          const unchangedLineCount = sequence1.countLinesIn(unchangedRange);
          if (unchangedLineCount > 5 || unchangedRange.length > 500) {
            return false;
          }
          const unchangedText = sequence1.getText(unchangedRange).trim();
          if (unchangedText.length > 20 || unchangedText.split(/\r\n|\r|\n/).length > 1) {
            return false;
          }
          const beforeLineCount1 = sequence1.countLinesIn(before.seq1Range);
          const beforeSeq1Length = before.seq1Range.length;
          const beforeLineCount2 = sequence2.countLinesIn(before.seq2Range);
          const beforeSeq2Length = before.seq2Range.length;
          const afterLineCount1 = sequence1.countLinesIn(after.seq1Range);
          const afterSeq1Length = after.seq1Range.length;
          const afterLineCount2 = sequence2.countLinesIn(after.seq2Range);
          const afterSeq2Length = after.seq2Range.length;
          const max = 2 * 40 + 50;
          function cap(v) {
            return Math.min(v, max);
          }
          if (Math.pow(Math.pow(cap(beforeLineCount1 * 40 + beforeSeq1Length), 1.5) + Math.pow(cap(beforeLineCount2 * 40 + beforeSeq2Length), 1.5), 1.5) + Math.pow(Math.pow(cap(afterLineCount1 * 40 + afterSeq1Length), 1.5) + Math.pow(cap(afterLineCount2 * 40 + afterSeq2Length), 1.5), 1.5) > Math.pow(Math.pow(max, 1.5), 1.5) * 1.3) {
            return true;
          }
          return false;
        };
        const cur = diffs[i];
        const lastResult = result[result.length - 1];
        const shouldJoin = shouldJoinDiffs(lastResult, cur);
        if (shouldJoin) {
          shouldRepeat = true;
          result[result.length - 1] = result[result.length - 1].join(cur);
        } else {
          result.push(cur);
        }
      }
      diffs = result;
    } while (counter++ < 10 && shouldRepeat);
    return diffs;
  }
  function joinSequenceDiffs(sequence1, sequence2, sequenceDiffs) {
    if (sequenceDiffs.length === 0) {
      return sequenceDiffs;
    }
    const result = [];
    result.push(sequenceDiffs[0]);
    for (let i = 1; i < sequenceDiffs.length; i++) {
      const prevResult = result[result.length - 1];
      let cur = sequenceDiffs[i];
      if (cur.seq1Range.isEmpty || cur.seq2Range.isEmpty) {
        const length = cur.seq1Range.start - prevResult.seq1Range.endExclusive;
        let d;
        for (d = 1; d <= length; d++) {
          if (sequence1.getElement(cur.seq1Range.start - d) !== sequence1.getElement(cur.seq1Range.endExclusive - d) || sequence2.getElement(cur.seq2Range.start - d) !== sequence2.getElement(cur.seq2Range.endExclusive - d)) {
            break;
          }
        }
        d--;
        if (d === length) {
          result[result.length - 1] = new SequenceDiff(new OffsetRange(prevResult.seq1Range.start, cur.seq1Range.endExclusive - length), new OffsetRange(prevResult.seq2Range.start, cur.seq2Range.endExclusive - length));
          continue;
        }
        cur = cur.delta(-d);
      }
      result.push(cur);
    }
    const result2 = [];
    for (let i = 0; i < result.length - 1; i++) {
      const nextResult = result[i + 1];
      let cur = result[i];
      if (cur.seq1Range.isEmpty || cur.seq2Range.isEmpty) {
        const length = nextResult.seq1Range.start - cur.seq1Range.endExclusive;
        let d;
        for (d = 0; d < length; d++) {
          if (sequence1.getElement(cur.seq1Range.start + d) !== sequence1.getElement(cur.seq1Range.endExclusive + d) || sequence2.getElement(cur.seq2Range.start + d) !== sequence2.getElement(cur.seq2Range.endExclusive + d)) {
            break;
          }
        }
        if (d === length) {
          result[i + 1] = new SequenceDiff(new OffsetRange(cur.seq1Range.start + length, nextResult.seq1Range.endExclusive), new OffsetRange(cur.seq2Range.start + length, nextResult.seq2Range.endExclusive));
          continue;
        }
        if (d > 0) {
          cur = cur.delta(d);
        }
      }
      result2.push(cur);
    }
    if (result.length > 0) {
      result2.push(result[result.length - 1]);
    }
    return result2;
  }
  function shiftSequenceDiffs(sequence1, sequence2, sequenceDiffs) {
    if (!sequence1.getBoundaryScore || !sequence2.getBoundaryScore) {
      return sequenceDiffs;
    }
    for (let i = 0; i < sequenceDiffs.length; i++) {
      const prevDiff = i > 0 ? sequenceDiffs[i - 1] : void 0;
      const diff2 = sequenceDiffs[i];
      const nextDiff = i + 1 < sequenceDiffs.length ? sequenceDiffs[i + 1] : void 0;
      const seq1ValidRange = new OffsetRange(prevDiff ? prevDiff.seq1Range.start + 1 : 0, nextDiff ? nextDiff.seq1Range.endExclusive - 1 : sequence1.length);
      const seq2ValidRange = new OffsetRange(prevDiff ? prevDiff.seq2Range.start + 1 : 0, nextDiff ? nextDiff.seq2Range.endExclusive - 1 : sequence2.length);
      if (diff2.seq1Range.isEmpty) {
        sequenceDiffs[i] = shiftDiffToBetterPosition(diff2, sequence1, sequence2, seq1ValidRange, seq2ValidRange);
      } else if (diff2.seq2Range.isEmpty) {
        sequenceDiffs[i] = shiftDiffToBetterPosition(diff2.reverse(), sequence2, sequence1, seq2ValidRange, seq1ValidRange).reverse();
      }
    }
    return sequenceDiffs;
  }
  function shiftDiffToBetterPosition(diff2, sequence1, sequence2, seq1ValidRange, seq2ValidRange) {
    const maxShiftLimit = 100;
    let deltaBefore = 1;
    while (diff2.seq1Range.start - deltaBefore >= seq1ValidRange.start && diff2.seq2Range.start - deltaBefore >= seq2ValidRange.start && sequence2.getElement(diff2.seq2Range.start - deltaBefore) === sequence2.getElement(diff2.seq2Range.endExclusive - deltaBefore) && deltaBefore < maxShiftLimit) {
      deltaBefore++;
    }
    deltaBefore--;
    let deltaAfter = 0;
    while (diff2.seq1Range.start + deltaAfter < seq1ValidRange.endExclusive && diff2.seq2Range.endExclusive + deltaAfter < seq2ValidRange.endExclusive && sequence2.getElement(diff2.seq2Range.start + deltaAfter) === sequence2.getElement(diff2.seq2Range.endExclusive + deltaAfter) && deltaAfter < maxShiftLimit) {
      deltaAfter++;
    }
    if (deltaBefore === 0 && deltaAfter === 0) {
      return diff2;
    }
    let bestDelta = 0;
    let bestScore = -1;
    for (let delta = -deltaBefore; delta <= deltaAfter; delta++) {
      const seq2OffsetStart = diff2.seq2Range.start + delta;
      const seq2OffsetEndExclusive = diff2.seq2Range.endExclusive + delta;
      const seq1Offset = diff2.seq1Range.start + delta;
      const score2 = sequence1.getBoundaryScore(seq1Offset) + sequence2.getBoundaryScore(seq2OffsetStart) + sequence2.getBoundaryScore(seq2OffsetEndExclusive);
      if (score2 > bestScore) {
        bestScore = score2;
        bestDelta = delta;
      }
    }
    return diff2.delta(bestDelta);
  }
  class MyersDiffAlgorithm {
    compute(seq1, seq2, timeout = InfiniteTimeout.instance) {
      if (seq1.length === 0 || seq2.length === 0) {
        return DiffAlgorithmResult.trivial(seq1, seq2);
      }
      function getXAfterSnake(x, y) {
        while (x < seq1.length && y < seq2.length && seq1.getElement(x) === seq2.getElement(y)) {
          x++;
          y++;
        }
        return x;
      }
      let d = 0;
      const V = new FastInt32Array();
      V.set(0, getXAfterSnake(0, 0));
      const paths = new FastArrayNegativeIndices();
      paths.set(0, V.get(0) === 0 ? null : new SnakePath(null, 0, 0, V.get(0)));
      let k = 0;
      loop:
        while (true) {
          d++;
          if (!timeout.isValid()) {
            return DiffAlgorithmResult.trivialTimedOut(seq1, seq2);
          }
          const lowerBound = -Math.min(d, seq2.length + d % 2);
          const upperBound = Math.min(d, seq1.length + d % 2);
          for (k = lowerBound; k <= upperBound; k += 2) {
            const maxXofDLineTop = k === upperBound ? -1 : V.get(k + 1);
            const maxXofDLineLeft = k === lowerBound ? -1 : V.get(k - 1) + 1;
            const x = Math.min(Math.max(maxXofDLineTop, maxXofDLineLeft), seq1.length);
            const y = x - k;
            if (x > seq1.length || y > seq2.length) {
              continue;
            }
            const newMaxX = getXAfterSnake(x, y);
            V.set(k, newMaxX);
            const lastPath = x === maxXofDLineTop ? paths.get(k + 1) : paths.get(k - 1);
            paths.set(k, newMaxX !== x ? new SnakePath(lastPath, x, y, newMaxX - x) : lastPath);
            if (V.get(k) === seq1.length && V.get(k) - k === seq2.length) {
              break loop;
            }
          }
        }
      let path2 = paths.get(k);
      const result = [];
      let lastAligningPosS1 = seq1.length;
      let lastAligningPosS2 = seq2.length;
      while (true) {
        const endX = path2 ? path2.x + path2.length : 0;
        const endY = path2 ? path2.y + path2.length : 0;
        if (endX !== lastAligningPosS1 || endY !== lastAligningPosS2) {
          result.push(new SequenceDiff(new OffsetRange(endX, lastAligningPosS1), new OffsetRange(endY, lastAligningPosS2)));
        }
        if (!path2) {
          break;
        }
        lastAligningPosS1 = path2.x;
        lastAligningPosS2 = path2.y;
        path2 = path2.prev;
      }
      result.reverse();
      return new DiffAlgorithmResult(result, false);
    }
  }
  class SnakePath {
    constructor(prev, x, y, length) {
      this.prev = prev;
      this.x = x;
      this.y = y;
      this.length = length;
    }
  }
  class FastInt32Array {
    constructor() {
      this.positiveArr = new Int32Array(10);
      this.negativeArr = new Int32Array(10);
    }
    get(idx) {
      if (idx < 0) {
        idx = -idx - 1;
        return this.negativeArr[idx];
      } else {
        return this.positiveArr[idx];
      }
    }
    set(idx, value) {
      if (idx < 0) {
        idx = -idx - 1;
        if (idx >= this.negativeArr.length) {
          const arr = this.negativeArr;
          this.negativeArr = new Int32Array(arr.length * 2);
          this.negativeArr.set(arr);
        }
        this.negativeArr[idx] = value;
      } else {
        if (idx >= this.positiveArr.length) {
          const arr = this.positiveArr;
          this.positiveArr = new Int32Array(arr.length * 2);
          this.positiveArr.set(arr);
        }
        this.positiveArr[idx] = value;
      }
    }
  }
  class FastArrayNegativeIndices {
    constructor() {
      this.positiveArr = [];
      this.negativeArr = [];
    }
    get(idx) {
      if (idx < 0) {
        idx = -idx - 1;
        return this.negativeArr[idx];
      } else {
        return this.positiveArr[idx];
      }
    }
    set(idx, value) {
      if (idx < 0) {
        idx = -idx - 1;
        this.negativeArr[idx] = value;
      } else {
        this.positiveArr[idx] = value;
      }
    }
  }
  class StandardLinesDiffComputer {
    constructor() {
      this.dynamicProgrammingDiffing = new DynamicProgrammingDiffing();
      this.myersDiffingAlgorithm = new MyersDiffAlgorithm();
    }
    computeDiff(originalLines, modifiedLines, options) {
      if (originalLines.length === 1 && originalLines[0].length === 0 || modifiedLines.length === 1 && modifiedLines[0].length === 0) {
        return {
          changes: [
            new LineRangeMapping(new LineRange(1, originalLines.length + 1), new LineRange(1, modifiedLines.length + 1), [
              new RangeMapping(new Range$b(1, 1, originalLines.length, originalLines[0].length + 1), new Range$b(1, 1, modifiedLines.length, modifiedLines[0].length + 1))
            ])
          ],
          hitTimeout: false,
          moves: []
        };
      }
      const timeout = options.maxComputationTimeMs === 0 ? InfiniteTimeout.instance : new DateTimeout(options.maxComputationTimeMs);
      const considerWhitespaceChanges = !options.ignoreTrimWhitespace;
      const perfectHashes = /* @__PURE__ */ new Map();
      function getOrCreateHash(text2) {
        let hash2 = perfectHashes.get(text2);
        if (hash2 === void 0) {
          hash2 = perfectHashes.size;
          perfectHashes.set(text2, hash2);
        }
        return hash2;
      }
      const srcDocLines = originalLines.map((l) => getOrCreateHash(l.trim()));
      const tgtDocLines = modifiedLines.map((l) => getOrCreateHash(l.trim()));
      const sequence1 = new LineSequence(srcDocLines, originalLines);
      const sequence2 = new LineSequence(tgtDocLines, modifiedLines);
      const lineAlignmentResult = (() => {
        if (sequence1.length + sequence2.length < 1500) {
          return this.dynamicProgrammingDiffing.compute(sequence1, sequence2, timeout, (offset1, offset2) => originalLines[offset1] === modifiedLines[offset2] ? modifiedLines[offset2].length === 0 ? 0.1 : 1 + Math.log(1 + modifiedLines[offset2].length) : 0.99);
        }
        return this.myersDiffingAlgorithm.compute(sequence1, sequence2);
      })();
      let lineAlignments = lineAlignmentResult.diffs;
      let hitTimeout = lineAlignmentResult.hitTimeout;
      lineAlignments = optimizeSequenceDiffs(sequence1, sequence2, lineAlignments);
      const alignments = [];
      const scanForWhitespaceChanges = (equalLinesCount) => {
        if (!considerWhitespaceChanges) {
          return;
        }
        for (let i = 0; i < equalLinesCount; i++) {
          const seq1Offset = seq1LastStart + i;
          const seq2Offset = seq2LastStart + i;
          if (originalLines[seq1Offset] !== modifiedLines[seq2Offset]) {
            const characterDiffs = this.refineDiff(originalLines, modifiedLines, new SequenceDiff(new OffsetRange(seq1Offset, seq1Offset + 1), new OffsetRange(seq2Offset, seq2Offset + 1)), timeout, considerWhitespaceChanges);
            for (const a2 of characterDiffs.mappings) {
              alignments.push(a2);
            }
            if (characterDiffs.hitTimeout) {
              hitTimeout = true;
            }
          }
        }
      };
      let seq1LastStart = 0;
      let seq2LastStart = 0;
      for (const diff2 of lineAlignments) {
        assertFn(() => diff2.seq1Range.start - seq1LastStart === diff2.seq2Range.start - seq2LastStart);
        const equalLinesCount = diff2.seq1Range.start - seq1LastStart;
        scanForWhitespaceChanges(equalLinesCount);
        seq1LastStart = diff2.seq1Range.endExclusive;
        seq2LastStart = diff2.seq2Range.endExclusive;
        const characterDiffs = this.refineDiff(originalLines, modifiedLines, diff2, timeout, considerWhitespaceChanges);
        if (characterDiffs.hitTimeout) {
          hitTimeout = true;
        }
        for (const a2 of characterDiffs.mappings) {
          alignments.push(a2);
        }
      }
      scanForWhitespaceChanges(originalLines.length - seq1LastStart);
      const changes = lineRangeMappingFromRangeMappings(alignments, originalLines, modifiedLines);
      const moves = [];
      if (options.computeMoves) {
        const deletions = changes.filter((c) => c.modifiedRange.isEmpty && c.originalRange.length >= 3).map((d) => new LineRangeFragment(d.originalRange, originalLines));
        const insertions = new Set(changes.filter((c) => c.originalRange.isEmpty && c.modifiedRange.length >= 3).map((d) => new LineRangeFragment(d.modifiedRange, modifiedLines)));
        for (const deletion of deletions) {
          let highestSimilarity = -1;
          let best;
          for (const insertion of insertions) {
            const similarity = deletion.computeSimilarity(insertion);
            if (similarity > highestSimilarity) {
              highestSimilarity = similarity;
              best = insertion;
            }
          }
          if (highestSimilarity > 0.9 && best) {
            const moveChanges = this.refineDiff(originalLines, modifiedLines, new SequenceDiff(new OffsetRange(deletion.range.startLineNumber - 1, deletion.range.endLineNumberExclusive - 1), new OffsetRange(best.range.startLineNumber - 1, best.range.endLineNumberExclusive - 1)), timeout, considerWhitespaceChanges);
            const mappings = lineRangeMappingFromRangeMappings(moveChanges.mappings, originalLines, modifiedLines, true);
            insertions.delete(best);
            moves.push(new MovedText(new SimpleLineRangeMapping(deletion.range, best.range), mappings));
          }
        }
      }
      assertFn(() => {
        function validatePosition(pos, lines) {
          if (pos.lineNumber < 1 || pos.lineNumber > lines.length) {
            return false;
          }
          const line = lines[pos.lineNumber - 1];
          if (pos.column < 1 || pos.column > line.length + 1) {
            return false;
          }
          return true;
        }
        function validateRange(range2, lines) {
          if (range2.startLineNumber < 1 || range2.startLineNumber > lines.length + 1) {
            return false;
          }
          if (range2.endLineNumberExclusive < 1 || range2.endLineNumberExclusive > lines.length + 1) {
            return false;
          }
          return true;
        }
        for (const c of changes) {
          if (!c.innerChanges) {
            return false;
          }
          for (const ic of c.innerChanges) {
            const valid2 = validatePosition(ic.modifiedRange.getStartPosition(), modifiedLines) && validatePosition(ic.modifiedRange.getEndPosition(), modifiedLines) && validatePosition(ic.originalRange.getStartPosition(), originalLines) && validatePosition(ic.originalRange.getEndPosition(), originalLines);
            if (!valid2) {
              return false;
            }
          }
          if (!validateRange(c.modifiedRange, modifiedLines) || !validateRange(c.originalRange, originalLines)) {
            return false;
          }
        }
        return true;
      });
      return new LinesDiff(changes, moves, hitTimeout);
    }
    refineDiff(originalLines, modifiedLines, diff2, timeout, considerWhitespaceChanges) {
      const slice1 = new LinesSliceCharSequence(originalLines, diff2.seq1Range, considerWhitespaceChanges);
      const slice2 = new LinesSliceCharSequence(modifiedLines, diff2.seq2Range, considerWhitespaceChanges);
      const diffResult = slice1.length + slice2.length < 500 ? this.dynamicProgrammingDiffing.compute(slice1, slice2, timeout) : this.myersDiffingAlgorithm.compute(slice1, slice2, timeout);
      let diffs = diffResult.diffs;
      diffs = optimizeSequenceDiffs(slice1, slice2, diffs);
      diffs = coverFullWords(slice1, slice2, diffs);
      diffs = smoothenSequenceDiffs(slice1, slice2, diffs);
      diffs = removeRandomMatches(slice1, slice2, diffs);
      const result = diffs.map((d) => new RangeMapping(slice1.translateRange(d.seq1Range), slice2.translateRange(d.seq2Range)));
      return {
        mappings: result,
        hitTimeout: diffResult.hitTimeout
      };
    }
  }
  function coverFullWords(sequence1, sequence2, sequenceDiffs) {
    const additional = [];
    let lastModifiedWord = void 0;
    function maybePushWordToAdditional() {
      if (!lastModifiedWord) {
        return;
      }
      const originalLength1 = lastModifiedWord.s1Range.length - lastModifiedWord.deleted;
      lastModifiedWord.s2Range.length - lastModifiedWord.added;
      if (Math.max(lastModifiedWord.deleted, lastModifiedWord.added) + (lastModifiedWord.count - 1) > originalLength1) {
        additional.push(new SequenceDiff(lastModifiedWord.s1Range, lastModifiedWord.s2Range));
      }
      lastModifiedWord = void 0;
    }
    for (const s of sequenceDiffs) {
      let processWord = function(s1Range, s2Range) {
        var _a2, _b, _c, _d;
        if (!lastModifiedWord || !lastModifiedWord.s1Range.containsRange(s1Range) || !lastModifiedWord.s2Range.containsRange(s2Range)) {
          if (lastModifiedWord && !(lastModifiedWord.s1Range.endExclusive < s1Range.start && lastModifiedWord.s2Range.endExclusive < s2Range.start)) {
            const s1Added = OffsetRange.tryCreate(lastModifiedWord.s1Range.endExclusive, s1Range.start);
            const s2Added = OffsetRange.tryCreate(lastModifiedWord.s2Range.endExclusive, s2Range.start);
            lastModifiedWord.deleted += (_a2 = s1Added === null || s1Added === void 0 ? void 0 : s1Added.length) !== null && _a2 !== void 0 ? _a2 : 0;
            lastModifiedWord.added += (_b = s2Added === null || s2Added === void 0 ? void 0 : s2Added.length) !== null && _b !== void 0 ? _b : 0;
            lastModifiedWord.s1Range = lastModifiedWord.s1Range.join(s1Range);
            lastModifiedWord.s2Range = lastModifiedWord.s2Range.join(s2Range);
          } else {
            maybePushWordToAdditional();
            lastModifiedWord = { added: 0, deleted: 0, count: 0, s1Range, s2Range };
          }
        }
        const changedS1 = s1Range.intersect(s.seq1Range);
        const changedS2 = s2Range.intersect(s.seq2Range);
        lastModifiedWord.count++;
        lastModifiedWord.deleted += (_c = changedS1 === null || changedS1 === void 0 ? void 0 : changedS1.length) !== null && _c !== void 0 ? _c : 0;
        lastModifiedWord.added += (_d = changedS2 === null || changedS2 === void 0 ? void 0 : changedS2.length) !== null && _d !== void 0 ? _d : 0;
      };
      const w1Before = sequence1.findWordContaining(s.seq1Range.start - 1);
      const w2Before = sequence2.findWordContaining(s.seq2Range.start - 1);
      const w1After = sequence1.findWordContaining(s.seq1Range.endExclusive);
      const w2After = sequence2.findWordContaining(s.seq2Range.endExclusive);
      if (w1Before && w1After && w2Before && w2After && w1Before.equals(w1After) && w2Before.equals(w2After)) {
        processWord(w1Before, w2Before);
      } else {
        if (w1Before && w2Before) {
          processWord(w1Before, w2Before);
        }
        if (w1After && w2After) {
          processWord(w1After, w2After);
        }
      }
    }
    maybePushWordToAdditional();
    const merged = mergeSequenceDiffs(sequenceDiffs, additional);
    return merged;
  }
  function mergeSequenceDiffs(sequenceDiffs1, sequenceDiffs2) {
    const result = [];
    while (sequenceDiffs1.length > 0 || sequenceDiffs2.length > 0) {
      const sd1 = sequenceDiffs1[0];
      const sd2 = sequenceDiffs2[0];
      let next2;
      if (sd1 && (!sd2 || sd1.seq1Range.start < sd2.seq1Range.start)) {
        next2 = sequenceDiffs1.shift();
      } else {
        next2 = sequenceDiffs2.shift();
      }
      if (result.length > 0 && result[result.length - 1].seq1Range.endExclusive >= next2.seq1Range.start) {
        result[result.length - 1] = result[result.length - 1].join(next2);
      } else {
        result.push(next2);
      }
    }
    return result;
  }
  function lineRangeMappingFromRangeMappings(alignments, originalLines, modifiedLines, dontAssertStartLine = false) {
    const changes = [];
    for (const g of group(alignments.map((a2) => getLineRangeMapping(a2, originalLines, modifiedLines)), (a1, a2) => a1.originalRange.overlapOrTouch(a2.originalRange) || a1.modifiedRange.overlapOrTouch(a2.modifiedRange))) {
      const first = g[0];
      const last2 = g[g.length - 1];
      changes.push(new LineRangeMapping(first.originalRange.join(last2.originalRange), first.modifiedRange.join(last2.modifiedRange), g.map((a2) => a2.innerChanges[0])));
    }
    assertFn(() => {
      if (!dontAssertStartLine) {
        if (changes.length > 0 && changes[0].originalRange.startLineNumber !== changes[0].modifiedRange.startLineNumber) {
          return false;
        }
      }
      return checkAdjacentItems(changes, (m1, m2) => m2.originalRange.startLineNumber - m1.originalRange.endLineNumberExclusive === m2.modifiedRange.startLineNumber - m1.modifiedRange.endLineNumberExclusive && // There has to be an unchanged line in between (otherwise both diffs should have been joined)
      m1.originalRange.endLineNumberExclusive < m2.originalRange.startLineNumber && m1.modifiedRange.endLineNumberExclusive < m2.modifiedRange.startLineNumber);
    });
    return changes;
  }
  function getLineRangeMapping(rangeMapping, originalLines, modifiedLines) {
    let lineStartDelta = 0;
    let lineEndDelta = 0;
    if (rangeMapping.modifiedRange.endColumn === 1 && rangeMapping.originalRange.endColumn === 1 && rangeMapping.originalRange.startLineNumber + lineStartDelta <= rangeMapping.originalRange.endLineNumber && rangeMapping.modifiedRange.startLineNumber + lineStartDelta <= rangeMapping.modifiedRange.endLineNumber) {
      lineEndDelta = -1;
    }
    if (rangeMapping.modifiedRange.startColumn - 1 >= modifiedLines[rangeMapping.modifiedRange.startLineNumber - 1].length && rangeMapping.originalRange.startColumn - 1 >= originalLines[rangeMapping.originalRange.startLineNumber - 1].length && rangeMapping.originalRange.startLineNumber <= rangeMapping.originalRange.endLineNumber + lineEndDelta && rangeMapping.modifiedRange.startLineNumber <= rangeMapping.modifiedRange.endLineNumber + lineEndDelta) {
      lineStartDelta = 1;
    }
    const originalLineRange = new LineRange(rangeMapping.originalRange.startLineNumber + lineStartDelta, rangeMapping.originalRange.endLineNumber + 1 + lineEndDelta);
    const modifiedLineRange = new LineRange(rangeMapping.modifiedRange.startLineNumber + lineStartDelta, rangeMapping.modifiedRange.endLineNumber + 1 + lineEndDelta);
    return new LineRangeMapping(originalLineRange, modifiedLineRange, [rangeMapping]);
  }
  function* group(items, shouldBeGrouped) {
    let currentGroup;
    let last2;
    for (const item of items) {
      if (last2 !== void 0 && shouldBeGrouped(last2, item)) {
        currentGroup.push(item);
      } else {
        if (currentGroup) {
          yield currentGroup;
        }
        currentGroup = [item];
      }
      last2 = item;
    }
    if (currentGroup) {
      yield currentGroup;
    }
  }
  class LineSequence {
    constructor(trimmedHash, lines) {
      this.trimmedHash = trimmedHash;
      this.lines = lines;
    }
    getElement(offset) {
      return this.trimmedHash[offset];
    }
    get length() {
      return this.trimmedHash.length;
    }
    getBoundaryScore(length) {
      const indentationBefore = length === 0 ? 0 : getIndentation(this.lines[length - 1]);
      const indentationAfter = length === this.lines.length ? 0 : getIndentation(this.lines[length]);
      return 1e3 - (indentationBefore + indentationAfter);
    }
  }
  function getIndentation(str2) {
    let i = 0;
    while (i < str2.length && (str2.charCodeAt(i) === 32 || str2.charCodeAt(i) === 9)) {
      i++;
    }
    return i;
  }
  class LinesSliceCharSequence {
    constructor(lines, lineRange, considerWhitespaceChanges) {
      this.lines = lines;
      this.considerWhitespaceChanges = considerWhitespaceChanges;
      this.elements = [];
      this.firstCharOffsetByLineMinusOne = [];
      this.offsetByLine = [];
      let trimFirstLineFully = false;
      if (lineRange.start > 0 && lineRange.endExclusive >= lines.length) {
        lineRange = new OffsetRange(lineRange.start - 1, lineRange.endExclusive);
        trimFirstLineFully = true;
      }
      this.lineRange = lineRange;
      for (let i = this.lineRange.start; i < this.lineRange.endExclusive; i++) {
        let line = lines[i];
        let offset = 0;
        if (trimFirstLineFully) {
          offset = line.length;
          line = "";
          trimFirstLineFully = false;
        } else if (!considerWhitespaceChanges) {
          const trimmedStartLine = line.trimStart();
          offset = line.length - trimmedStartLine.length;
          line = trimmedStartLine.trimEnd();
        }
        this.offsetByLine.push(offset);
        for (let i2 = 0; i2 < line.length; i2++) {
          this.elements.push(line.charCodeAt(i2));
        }
        if (i < lines.length - 1) {
          this.elements.push("\n".charCodeAt(0));
          this.firstCharOffsetByLineMinusOne[i - this.lineRange.start] = this.elements.length;
        }
      }
      this.offsetByLine.push(0);
    }
    toString() {
      return `Slice: "${this.text}"`;
    }
    get text() {
      return this.getText(new OffsetRange(0, this.length));
    }
    getText(range2) {
      return this.elements.slice(range2.start, range2.endExclusive).map((e) => String.fromCharCode(e)).join("");
    }
    getElement(offset) {
      return this.elements[offset];
    }
    get length() {
      return this.elements.length;
    }
    getBoundaryScore(length) {
      const prevCategory = getCategory(length > 0 ? this.elements[length - 1] : -1);
      const nextCategory = getCategory(length < this.elements.length ? this.elements[length] : -1);
      if (prevCategory === 6 && nextCategory === 7) {
        return 0;
      }
      let score2 = 0;
      if (prevCategory !== nextCategory) {
        score2 += 10;
        if (nextCategory === 1) {
          score2 += 1;
        }
      }
      score2 += getCategoryBoundaryScore(prevCategory);
      score2 += getCategoryBoundaryScore(nextCategory);
      return score2;
    }
    translateOffset(offset) {
      if (this.lineRange.isEmpty) {
        return new Position$1(this.lineRange.start + 1, 1);
      }
      let i = 0;
      let j = this.firstCharOffsetByLineMinusOne.length;
      while (i < j) {
        const k = Math.floor((i + j) / 2);
        if (this.firstCharOffsetByLineMinusOne[k] > offset) {
          j = k;
        } else {
          i = k + 1;
        }
      }
      const offsetOfFirstCharInLine = i === 0 ? 0 : this.firstCharOffsetByLineMinusOne[i - 1];
      return new Position$1(this.lineRange.start + i + 1, offset - offsetOfFirstCharInLine + 1 + this.offsetByLine[i]);
    }
    translateRange(range2) {
      return Range$b.fromPositions(this.translateOffset(range2.start), this.translateOffset(range2.endExclusive));
    }
    /**
     * Finds the word that contains the character at the given offset
     */
    findWordContaining(offset) {
      if (offset < 0 || offset >= this.elements.length) {
        return void 0;
      }
      if (!isWordChar(this.elements[offset])) {
        return void 0;
      }
      let start = offset;
      while (start > 0 && isWordChar(this.elements[start - 1])) {
        start--;
      }
      let end = offset;
      while (end < this.elements.length && isWordChar(this.elements[end])) {
        end++;
      }
      return new OffsetRange(start, end);
    }
    countLinesIn(range2) {
      return this.translateOffset(range2.endExclusive).lineNumber - this.translateOffset(range2.start).lineNumber;
    }
  }
  function isWordChar(charCode) {
    return charCode >= 97 && charCode <= 122 || charCode >= 65 && charCode <= 90 || charCode >= 48 && charCode <= 57;
  }
  const score = {
    [
      0
      /* CharBoundaryCategory.WordLower */
    ]: 0,
    [
      1
      /* CharBoundaryCategory.WordUpper */
    ]: 0,
    [
      2
      /* CharBoundaryCategory.WordNumber */
    ]: 0,
    [
      3
      /* CharBoundaryCategory.End */
    ]: 10,
    [
      4
      /* CharBoundaryCategory.Other */
    ]: 2,
    [
      5
      /* CharBoundaryCategory.Space */
    ]: 3,
    [
      6
      /* CharBoundaryCategory.LineBreakCR */
    ]: 10,
    [
      7
      /* CharBoundaryCategory.LineBreakLF */
    ]: 10
  };
  function getCategoryBoundaryScore(category) {
    return score[category];
  }
  function getCategory(charCode) {
    if (charCode === 10) {
      return 7;
    } else if (charCode === 13) {
      return 6;
    } else if (isSpace(charCode)) {
      return 5;
    } else if (charCode >= 97 && charCode <= 122) {
      return 0;
    } else if (charCode >= 65 && charCode <= 90) {
      return 1;
    } else if (charCode >= 48 && charCode <= 57) {
      return 2;
    } else if (charCode === -1) {
      return 3;
    } else {
      return 4;
    }
  }
  function isSpace(charCode) {
    return charCode === 32 || charCode === 9;
  }
  const chrKeys = /* @__PURE__ */ new Map();
  function getKey(chr2) {
    let key = chrKeys.get(chr2);
    if (key === void 0) {
      key = chrKeys.size;
      chrKeys.set(chr2, key);
    }
    return key;
  }
  class LineRangeFragment {
    constructor(range2, lines) {
      this.range = range2;
      this.lines = lines;
      this.histogram = [];
      let counter = 0;
      for (let i = range2.startLineNumber - 1; i < range2.endLineNumberExclusive - 1; i++) {
        const line = lines[i];
        for (let j = 0; j < line.length; j++) {
          counter++;
          const chr2 = line[j];
          const key2 = getKey(chr2);
          this.histogram[key2] = (this.histogram[key2] || 0) + 1;
        }
        counter++;
        const key = getKey("\n");
        this.histogram[key] = (this.histogram[key] || 0) + 1;
      }
      this.totalCount = counter;
    }
    computeSimilarity(other) {
      var _a2, _b;
      let sumDifferences = 0;
      const maxLength = Math.max(this.histogram.length, other.histogram.length);
      for (let i = 0; i < maxLength; i++) {
        sumDifferences += Math.abs(((_a2 = this.histogram[i]) !== null && _a2 !== void 0 ? _a2 : 0) - ((_b = other.histogram[i]) !== null && _b !== void 0 ? _b : 0));
      }
      return 1 - sumDifferences / (this.totalCount + other.totalCount);
    }
  }
  const linesDiffComputers = {
    getLegacy: () => new SmartLinesDiffComputer(),
    getAdvanced: () => new StandardLinesDiffComputer()
  };
  function roundFloat(number, decimalPoints) {
    const decimal = Math.pow(10, decimalPoints);
    return Math.round(number * decimal) / decimal;
  }
  class RGBA {
    constructor(r, g, b, a2 = 1) {
      this._rgbaBrand = void 0;
      this.r = Math.min(255, Math.max(0, r)) | 0;
      this.g = Math.min(255, Math.max(0, g)) | 0;
      this.b = Math.min(255, Math.max(0, b)) | 0;
      this.a = roundFloat(Math.max(Math.min(1, a2), 0), 3);
    }
    static equals(a2, b) {
      return a2.r === b.r && a2.g === b.g && a2.b === b.b && a2.a === b.a;
    }
  }
  class HSLA {
    constructor(h, s, l, a2) {
      this._hslaBrand = void 0;
      this.h = Math.max(Math.min(360, h), 0) | 0;
      this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
      this.l = roundFloat(Math.max(Math.min(1, l), 0), 3);
      this.a = roundFloat(Math.max(Math.min(1, a2), 0), 3);
    }
    static equals(a2, b) {
      return a2.h === b.h && a2.s === b.s && a2.l === b.l && a2.a === b.a;
    }
    /**
     * Converts an RGB color value to HSL. Conversion formula
     * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
     * Assumes r, g, and b are contained in the set [0, 255] and
     * returns h in the set [0, 360], s, and l in the set [0, 1].
     */
    static fromRGBA(rgba) {
      const r = rgba.r / 255;
      const g = rgba.g / 255;
      const b = rgba.b / 255;
      const a2 = rgba.a;
      const max = Math.max(r, g, b);
      const min = Math.min(r, g, b);
      let h = 0;
      let s = 0;
      const l = (min + max) / 2;
      const chroma = max - min;
      if (chroma > 0) {
        s = Math.min(l <= 0.5 ? chroma / (2 * l) : chroma / (2 - 2 * l), 1);
        switch (max) {
          case r:
            h = (g - b) / chroma + (g < b ? 6 : 0);
            break;
          case g:
            h = (b - r) / chroma + 2;
            break;
          case b:
            h = (r - g) / chroma + 4;
            break;
        }
        h *= 60;
        h = Math.round(h);
      }
      return new HSLA(h, s, l, a2);
    }
    static _hue2rgb(p, q, t2) {
      if (t2 < 0) {
        t2 += 1;
      }
      if (t2 > 1) {
        t2 -= 1;
      }
      if (t2 < 1 / 6) {
        return p + (q - p) * 6 * t2;
      }
      if (t2 < 1 / 2) {
        return q;
      }
      if (t2 < 2 / 3) {
        return p + (q - p) * (2 / 3 - t2) * 6;
      }
      return p;
    }
    /**
     * Converts an HSL color value to RGB. Conversion formula
     * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
     * Assumes h in the set [0, 360] s, and l are contained in the set [0, 1] and
     * returns r, g, and b in the set [0, 255].
     */
    static toRGBA(hsla) {
      const h = hsla.h / 360;
      const { s, l, a: a2 } = hsla;
      let r, g, b;
      if (s === 0) {
        r = g = b = l;
      } else {
        const q = l < 0.5 ? l * (1 + s) : l + s - l * s;
        const p = 2 * l - q;
        r = HSLA._hue2rgb(p, q, h + 1 / 3);
        g = HSLA._hue2rgb(p, q, h);
        b = HSLA._hue2rgb(p, q, h - 1 / 3);
      }
      return new RGBA(Math.round(r * 255), Math.round(g * 255), Math.round(b * 255), a2);
    }
  }
  class HSVA {
    constructor(h, s, v, a2) {
      this._hsvaBrand = void 0;
      this.h = Math.max(Math.min(360, h), 0) | 0;
      this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
      this.v = roundFloat(Math.max(Math.min(1, v), 0), 3);
      this.a = roundFloat(Math.max(Math.min(1, a2), 0), 3);
    }
    static equals(a2, b) {
      return a2.h === b.h && a2.s === b.s && a2.v === b.v && a2.a === b.a;
    }
    // from http://www.rapidtables.com/convert/color/rgb-to-hsv.htm
    static fromRGBA(rgba) {
      const r = rgba.r / 255;
      const g = rgba.g / 255;
      const b = rgba.b / 255;
      const cmax = Math.max(r, g, b);
      const cmin = Math.min(r, g, b);
      const delta = cmax - cmin;
      const s = cmax === 0 ? 0 : delta / cmax;
      let m;
      if (delta === 0) {
        m = 0;
      } else if (cmax === r) {
        m = ((g - b) / delta % 6 + 6) % 6;
      } else if (cmax === g) {
        m = (b - r) / delta + 2;
      } else {
        m = (r - g) / delta + 4;
      }
      return new HSVA(Math.round(m * 60), s, cmax, rgba.a);
    }
    // from http://www.rapidtables.com/convert/color/hsv-to-rgb.htm
    static toRGBA(hsva) {
      const { h, s, v, a: a2 } = hsva;
      const c = v * s;
      const x = c * (1 - Math.abs(h / 60 % 2 - 1));
      const m = v - c;
      let [r, g, b] = [0, 0, 0];
      if (h < 60) {
        r = c;
        g = x;
      } else if (h < 120) {
        r = x;
        g = c;
      } else if (h < 180) {
        g = c;
        b = x;
      } else if (h < 240) {
        g = x;
        b = c;
      } else if (h < 300) {
        r = x;
        b = c;
      } else if (h <= 360) {
        r = c;
        b = x;
      }
      r = Math.round((r + m) * 255);
      g = Math.round((g + m) * 255);
      b = Math.round((b + m) * 255);
      return new RGBA(r, g, b, a2);
    }
  }
  let Color$1 = class Color2 {
    static fromHex(hex) {
      return Color2.Format.CSS.parseHex(hex) || Color2.red;
    }
    static equals(a2, b) {
      if (!a2 && !b) {
        return true;
      }
      if (!a2 || !b) {
        return false;
      }
      return a2.equals(b);
    }
    get hsla() {
      if (this._hsla) {
        return this._hsla;
      } else {
        return HSLA.fromRGBA(this.rgba);
      }
    }
    get hsva() {
      if (this._hsva) {
        return this._hsva;
      }
      return HSVA.fromRGBA(this.rgba);
    }
    constructor(arg) {
      if (!arg) {
        throw new Error("Color needs a value");
      } else if (arg instanceof RGBA) {
        this.rgba = arg;
      } else if (arg instanceof HSLA) {
        this._hsla = arg;
        this.rgba = HSLA.toRGBA(arg);
      } else if (arg instanceof HSVA) {
        this._hsva = arg;
        this.rgba = HSVA.toRGBA(arg);
      } else {
        throw new Error("Invalid color ctor argument");
      }
    }
    equals(other) {
      return !!other && RGBA.equals(this.rgba, other.rgba) && HSLA.equals(this.hsla, other.hsla) && HSVA.equals(this.hsva, other.hsva);
    }
    /**
     * http://www.w3.org/TR/WCAG20/#relativeluminancedef
     * Returns the number in the set [0, 1]. O => Darkest Black. 1 => Lightest white.
     */
    getRelativeLuminance() {
      const R = Color2._relativeLuminanceForComponent(this.rgba.r);
      const G = Color2._relativeLuminanceForComponent(this.rgba.g);
      const B = Color2._relativeLuminanceForComponent(this.rgba.b);
      const luminance = 0.2126 * R + 0.7152 * G + 0.0722 * B;
      return roundFloat(luminance, 4);
    }
    static _relativeLuminanceForComponent(color) {
      const c = color / 255;
      return c <= 0.03928 ? c / 12.92 : Math.pow((c + 0.055) / 1.055, 2.4);
    }
    /**
     *	http://24ways.org/2010/calculating-color-contrast
     *  Return 'true' if lighter color otherwise 'false'
     */
    isLighter() {
      const yiq = (this.rgba.r * 299 + this.rgba.g * 587 + this.rgba.b * 114) / 1e3;
      return yiq >= 128;
    }
    isLighterThan(another) {
      const lum1 = this.getRelativeLuminance();
      const lum2 = another.getRelativeLuminance();
      return lum1 > lum2;
    }
    isDarkerThan(another) {
      const lum1 = this.getRelativeLuminance();
      const lum2 = another.getRelativeLuminance();
      return lum1 < lum2;
    }
    lighten(factor) {
      return new Color2(new HSLA(this.hsla.h, this.hsla.s, this.hsla.l + this.hsla.l * factor, this.hsla.a));
    }
    darken(factor) {
      return new Color2(new HSLA(this.hsla.h, this.hsla.s, this.hsla.l - this.hsla.l * factor, this.hsla.a));
    }
    transparent(factor) {
      const { r, g, b, a: a2 } = this.rgba;
      return new Color2(new RGBA(r, g, b, a2 * factor));
    }
    isTransparent() {
      return this.rgba.a === 0;
    }
    isOpaque() {
      return this.rgba.a === 1;
    }
    opposite() {
      return new Color2(new RGBA(255 - this.rgba.r, 255 - this.rgba.g, 255 - this.rgba.b, this.rgba.a));
    }
    makeOpaque(opaqueBackground) {
      if (this.isOpaque() || opaqueBackground.rgba.a !== 1) {
        return this;
      }
      const { r, g, b, a: a2 } = this.rgba;
      return new Color2(new RGBA(opaqueBackground.rgba.r - a2 * (opaqueBackground.rgba.r - r), opaqueBackground.rgba.g - a2 * (opaqueBackground.rgba.g - g), opaqueBackground.rgba.b - a2 * (opaqueBackground.rgba.b - b), 1));
    }
    toString() {
      if (!this._toString) {
        this._toString = Color2.Format.CSS.format(this);
      }
      return this._toString;
    }
    static getLighterColor(of, relative, factor) {
      if (of.isLighterThan(relative)) {
        return of;
      }
      factor = factor ? factor : 0.5;
      const lum1 = of.getRelativeLuminance();
      const lum2 = relative.getRelativeLuminance();
      factor = factor * (lum2 - lum1) / lum2;
      return of.lighten(factor);
    }
    static getDarkerColor(of, relative, factor) {
      if (of.isDarkerThan(relative)) {
        return of;
      }
      factor = factor ? factor : 0.5;
      const lum1 = of.getRelativeLuminance();
      const lum2 = relative.getRelativeLuminance();
      factor = factor * (lum1 - lum2) / lum1;
      return of.darken(factor);
    }
  };
  Color$1.white = new Color$1(new RGBA(255, 255, 255, 1));
  Color$1.black = new Color$1(new RGBA(0, 0, 0, 1));
  Color$1.red = new Color$1(new RGBA(255, 0, 0, 1));
  Color$1.blue = new Color$1(new RGBA(0, 0, 255, 1));
  Color$1.green = new Color$1(new RGBA(0, 255, 0, 1));
  Color$1.cyan = new Color$1(new RGBA(0, 255, 255, 1));
  Color$1.lightgrey = new Color$1(new RGBA(211, 211, 211, 1));
  Color$1.transparent = new Color$1(new RGBA(0, 0, 0, 0));
  (function(Color2) {
    (function(Format) {
      (function(CSS) {
        function formatRGB(color) {
          if (color.rgba.a === 1) {
            return `rgb(${color.rgba.r}, ${color.rgba.g}, ${color.rgba.b})`;
          }
          return Color2.Format.CSS.formatRGBA(color);
        }
        CSS.formatRGB = formatRGB;
        function formatRGBA(color) {
          return `rgba(${color.rgba.r}, ${color.rgba.g}, ${color.rgba.b}, ${+color.rgba.a.toFixed(2)})`;
        }
        CSS.formatRGBA = formatRGBA;
        function formatHSL(color) {
          if (color.hsla.a === 1) {
            return `hsl(${color.hsla.h}, ${(color.hsla.s * 100).toFixed(2)}%, ${(color.hsla.l * 100).toFixed(2)}%)`;
          }
          return Color2.Format.CSS.formatHSLA(color);
        }
        CSS.formatHSL = formatHSL;
        function formatHSLA(color) {
          return `hsla(${color.hsla.h}, ${(color.hsla.s * 100).toFixed(2)}%, ${(color.hsla.l * 100).toFixed(2)}%, ${color.hsla.a.toFixed(2)})`;
        }
        CSS.formatHSLA = formatHSLA;
        function _toTwoDigitHex(n) {
          const r = n.toString(16);
          return r.length !== 2 ? "0" + r : r;
        }
        function formatHex(color) {
          return `#${_toTwoDigitHex(color.rgba.r)}${_toTwoDigitHex(color.rgba.g)}${_toTwoDigitHex(color.rgba.b)}`;
        }
        CSS.formatHex = formatHex;
        function formatHexA(color, compact = false) {
          if (compact && color.rgba.a === 1) {
            return Color2.Format.CSS.formatHex(color);
          }
          return `#${_toTwoDigitHex(color.rgba.r)}${_toTwoDigitHex(color.rgba.g)}${_toTwoDigitHex(color.rgba.b)}${_toTwoDigitHex(Math.round(color.rgba.a * 255))}`;
        }
        CSS.formatHexA = formatHexA;
        function format2(color) {
          if (color.isOpaque()) {
            return Color2.Format.CSS.formatHex(color);
          }
          return Color2.Format.CSS.formatRGBA(color);
        }
        CSS.format = format2;
        function parseHex(hex) {
          const length = hex.length;
          if (length === 0) {
            return null;
          }
          if (hex.charCodeAt(0) !== 35) {
            return null;
          }
          if (length === 7) {
            const r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
            const g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
            const b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
            return new Color2(new RGBA(r, g, b, 1));
          }
          if (length === 9) {
            const r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
            const g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
            const b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
            const a2 = 16 * _parseHexDigit(hex.charCodeAt(7)) + _parseHexDigit(hex.charCodeAt(8));
            return new Color2(new RGBA(r, g, b, a2 / 255));
          }
          if (length === 4) {
            const r = _parseHexDigit(hex.charCodeAt(1));
            const g = _parseHexDigit(hex.charCodeAt(2));
            const b = _parseHexDigit(hex.charCodeAt(3));
            return new Color2(new RGBA(16 * r + r, 16 * g + g, 16 * b + b));
          }
          if (length === 5) {
            const r = _parseHexDigit(hex.charCodeAt(1));
            const g = _parseHexDigit(hex.charCodeAt(2));
            const b = _parseHexDigit(hex.charCodeAt(3));
            const a2 = _parseHexDigit(hex.charCodeAt(4));
            return new Color2(new RGBA(16 * r + r, 16 * g + g, 16 * b + b, (16 * a2 + a2) / 255));
          }
          return null;
        }
        CSS.parseHex = parseHex;
        function _parseHexDigit(charCode) {
          switch (charCode) {
            case 48:
              return 0;
            case 49:
              return 1;
            case 50:
              return 2;
            case 51:
              return 3;
            case 52:
              return 4;
            case 53:
              return 5;
            case 54:
              return 6;
            case 55:
              return 7;
            case 56:
              return 8;
            case 57:
              return 9;
            case 97:
              return 10;
            case 65:
              return 10;
            case 98:
              return 11;
            case 66:
              return 11;
            case 99:
              return 12;
            case 67:
              return 12;
            case 100:
              return 13;
            case 68:
              return 13;
            case 101:
              return 14;
            case 69:
              return 14;
            case 102:
              return 15;
            case 70:
              return 15;
          }
          return 0;
        }
      })(Format.CSS || (Format.CSS = {}));
    })(Color2.Format || (Color2.Format = {}));
  })(Color$1 || (Color$1 = {}));
  function _parseCaptureGroups(captureGroups) {
    const values2 = [];
    for (const captureGroup of captureGroups) {
      const parsedNumber = Number(captureGroup);
      if (parsedNumber || parsedNumber === 0 && captureGroup.replace(/\s/g, "") !== "") {
        values2.push(parsedNumber);
      }
    }
    return values2;
  }
  function _toIColor(r, g, b, a2) {
    return {
      red: r / 255,
      blue: b / 255,
      green: g / 255,
      alpha: a2
    };
  }
  function _findRange(model2, match) {
    const index2 = match.index;
    const length = match[0].length;
    if (!index2) {
      return;
    }
    const startPosition = model2.positionAt(index2);
    const range2 = {
      startLineNumber: startPosition.lineNumber,
      startColumn: startPosition.column,
      endLineNumber: startPosition.lineNumber,
      endColumn: startPosition.column + length
    };
    return range2;
  }
  function _findHexColorInformation(range2, hexValue) {
    if (!range2) {
      return;
    }
    const parsedHexColor = Color$1.Format.CSS.parseHex(hexValue);
    if (!parsedHexColor) {
      return;
    }
    return {
      range: range2,
      color: _toIColor(parsedHexColor.rgba.r, parsedHexColor.rgba.g, parsedHexColor.rgba.b, parsedHexColor.rgba.a)
    };
  }
  function _findRGBColorInformation(range2, matches2, isAlpha) {
    if (!range2 || matches2.length !== 1) {
      return;
    }
    const match = matches2[0];
    const captureGroups = match.values();
    const parsedRegex = _parseCaptureGroups(captureGroups);
    return {
      range: range2,
      color: _toIColor(parsedRegex[0], parsedRegex[1], parsedRegex[2], isAlpha ? parsedRegex[3] : 1)
    };
  }
  function _findHSLColorInformation(range2, matches2, isAlpha) {
    if (!range2 || matches2.length !== 1) {
      return;
    }
    const match = matches2[0];
    const captureGroups = match.values();
    const parsedRegex = _parseCaptureGroups(captureGroups);
    const colorEquivalent = new Color$1(new HSLA(parsedRegex[0], parsedRegex[1] / 100, parsedRegex[2] / 100, isAlpha ? parsedRegex[3] : 1));
    return {
      range: range2,
      color: _toIColor(colorEquivalent.rgba.r, colorEquivalent.rgba.g, colorEquivalent.rgba.b, colorEquivalent.rgba.a)
    };
  }
  function _findMatches(model2, regex) {
    if (typeof model2 === "string") {
      return [...model2.matchAll(regex)];
    } else {
      return model2.findMatches(regex);
    }
  }
  function computeColors(model2) {
    const result = [];
    const initialValidationRegex = /\b(rgb|rgba|hsl|hsla)(\([0-9\s,.\%]*\))|(#)([A-Fa-f0-9]{3})\b|(#)([A-Fa-f0-9]{4})\b|(#)([A-Fa-f0-9]{6})\b|(#)([A-Fa-f0-9]{8})\b/gm;
    const initialValidationMatches = _findMatches(model2, initialValidationRegex);
    if (initialValidationMatches.length > 0) {
      for (const initialMatch of initialValidationMatches) {
        const initialCaptureGroups = initialMatch.filter((captureGroup) => captureGroup !== void 0);
        const colorScheme = initialCaptureGroups[1];
        const colorParameters = initialCaptureGroups[2];
        if (!colorParameters) {
          continue;
        }
        let colorInformation;
        if (colorScheme === "rgb") {
          const regexParameters = /^\(\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*\)$/gm;
          colorInformation = _findRGBColorInformation(_findRange(model2, initialMatch), _findMatches(colorParameters, regexParameters), false);
        } else if (colorScheme === "rgba") {
          const regexParameters = /^\(\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(0[.][0-9]+|[.][0-9]+|[01][.]|[01])\s*\)$/gm;
          colorInformation = _findRGBColorInformation(_findRange(model2, initialMatch), _findMatches(colorParameters, regexParameters), true);
        } else if (colorScheme === "hsl") {
          const regexParameters = /^\(\s*(36[0]|3[0-5][0-9]|[12][0-9][0-9]|[1-9]?[0-9])\s*,\s*(100|\d{1,2}[.]\d*|\d{1,2})%\s*,\s*(100|\d{1,2}[.]\d*|\d{1,2})%\s*\)$/gm;
          colorInformation = _findHSLColorInformation(_findRange(model2, initialMatch), _findMatches(colorParameters, regexParameters), false);
        } else if (colorScheme === "hsla") {
          const regexParameters = /^\(\s*(36[0]|3[0-5][0-9]|[12][0-9][0-9]|[1-9]?[0-9])\s*,\s*(100|\d{1,2}[.]\d*|\d{1,2})%\s*,\s*(100|\d{1,2}[.]\d*|\d{1,2})%\s*,\s*(0[.][0-9]+|[.][0-9]+|[01][.]|[01])\s*\)$/gm;
          colorInformation = _findHSLColorInformation(_findRange(model2, initialMatch), _findMatches(colorParameters, regexParameters), true);
        } else if (colorScheme === "#") {
          colorInformation = _findHexColorInformation(_findRange(model2, initialMatch), colorScheme + colorParameters);
        }
        if (colorInformation) {
          result.push(colorInformation);
        }
      }
    }
    return result;
  }
  function computeDefaultDocumentColors(model2) {
    if (!model2 || typeof model2.getValue !== "function" || typeof model2.positionAt !== "function") {
      return [];
    }
    return computeColors(model2);
  }
  var __awaiter = function(thisArg, _arguments, P, generator) {
    function adopt(value) {
      return value instanceof P ? value : new P(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P || (P = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e) {
          reject(e);
        }
      }
      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e) {
          reject(e);
        }
      }
      function step(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  class MirrorModel extends MirrorTextModel {
    get uri() {
      return this._uri;
    }
    get eol() {
      return this._eol;
    }
    getValue() {
      return this.getText();
    }
    findMatches(regex) {
      const matches2 = [];
      for (let i = 0; i < this._lines.length; i++) {
        const line = this._lines[i];
        const offsetToAdd = this.offsetAt(new Position$1(i + 1, 1));
        const iteratorOverMatches = line.matchAll(regex);
        for (const match of iteratorOverMatches) {
          if (match.index || match.index === 0) {
            match.index = match.index + offsetToAdd;
          }
          matches2.push(match);
        }
      }
      return matches2;
    }
    getLinesContent() {
      return this._lines.slice(0);
    }
    getLineCount() {
      return this._lines.length;
    }
    getLineContent(lineNumber) {
      return this._lines[lineNumber - 1];
    }
    getWordAtPosition(position, wordDefinition) {
      const wordAtText = getWordAtText(position.column, ensureValidWordDefinition(wordDefinition), this._lines[position.lineNumber - 1], 0);
      if (wordAtText) {
        return new Range$b(position.lineNumber, wordAtText.startColumn, position.lineNumber, wordAtText.endColumn);
      }
      return null;
    }
    words(wordDefinition) {
      const lines = this._lines;
      const wordenize = this._wordenize.bind(this);
      let lineNumber = 0;
      let lineText = "";
      let wordRangesIdx = 0;
      let wordRanges = [];
      return {
        *[Symbol.iterator]() {
          while (true) {
            if (wordRangesIdx < wordRanges.length) {
              const value = lineText.substring(wordRanges[wordRangesIdx].start, wordRanges[wordRangesIdx].end);
              wordRangesIdx += 1;
              yield value;
            } else {
              if (lineNumber < lines.length) {
                lineText = lines[lineNumber];
                wordRanges = wordenize(lineText, wordDefinition);
                wordRangesIdx = 0;
                lineNumber += 1;
              } else {
                break;
              }
            }
          }
        }
      };
    }
    getLineWords(lineNumber, wordDefinition) {
      const content = this._lines[lineNumber - 1];
      const ranges = this._wordenize(content, wordDefinition);
      const words = [];
      for (const range2 of ranges) {
        words.push({
          word: content.substring(range2.start, range2.end),
          startColumn: range2.start + 1,
          endColumn: range2.end + 1
        });
      }
      return words;
    }
    _wordenize(content, wordDefinition) {
      const result = [];
      let match;
      wordDefinition.lastIndex = 0;
      while (match = wordDefinition.exec(content)) {
        if (match[0].length === 0) {
          break;
        }
        result.push({ start: match.index, end: match.index + match[0].length });
      }
      return result;
    }
    getValueInRange(range2) {
      range2 = this._validateRange(range2);
      if (range2.startLineNumber === range2.endLineNumber) {
        return this._lines[range2.startLineNumber - 1].substring(range2.startColumn - 1, range2.endColumn - 1);
      }
      const lineEnding = this._eol;
      const startLineIndex = range2.startLineNumber - 1;
      const endLineIndex = range2.endLineNumber - 1;
      const resultLines = [];
      resultLines.push(this._lines[startLineIndex].substring(range2.startColumn - 1));
      for (let i = startLineIndex + 1; i < endLineIndex; i++) {
        resultLines.push(this._lines[i]);
      }
      resultLines.push(this._lines[endLineIndex].substring(0, range2.endColumn - 1));
      return resultLines.join(lineEnding);
    }
    offsetAt(position) {
      position = this._validatePosition(position);
      this._ensureLineStarts();
      return this._lineStarts.getPrefixSum(position.lineNumber - 2) + (position.column - 1);
    }
    positionAt(offset) {
      offset = Math.floor(offset);
      offset = Math.max(0, offset);
      this._ensureLineStarts();
      const out2 = this._lineStarts.getIndexOf(offset);
      const lineLength = this._lines[out2.index].length;
      return {
        lineNumber: 1 + out2.index,
        column: 1 + Math.min(out2.remainder, lineLength)
      };
    }
    _validateRange(range2) {
      const start = this._validatePosition({ lineNumber: range2.startLineNumber, column: range2.startColumn });
      const end = this._validatePosition({ lineNumber: range2.endLineNumber, column: range2.endColumn });
      if (start.lineNumber !== range2.startLineNumber || start.column !== range2.startColumn || end.lineNumber !== range2.endLineNumber || end.column !== range2.endColumn) {
        return {
          startLineNumber: start.lineNumber,
          startColumn: start.column,
          endLineNumber: end.lineNumber,
          endColumn: end.column
        };
      }
      return range2;
    }
    _validatePosition(position) {
      if (!Position$1.isIPosition(position)) {
        throw new Error("bad position");
      }
      let { lineNumber, column } = position;
      let hasChanged2 = false;
      if (lineNumber < 1) {
        lineNumber = 1;
        column = 1;
        hasChanged2 = true;
      } else if (lineNumber > this._lines.length) {
        lineNumber = this._lines.length;
        column = this._lines[lineNumber - 1].length + 1;
        hasChanged2 = true;
      } else {
        const maxCharacter = this._lines[lineNumber - 1].length + 1;
        if (column < 1) {
          column = 1;
          hasChanged2 = true;
        } else if (column > maxCharacter) {
          column = maxCharacter;
          hasChanged2 = true;
        }
      }
      if (!hasChanged2) {
        return position;
      } else {
        return { lineNumber, column };
      }
    }
  }
  class EditorSimpleWorker {
    constructor(host, foreignModuleFactory) {
      this._host = host;
      this._models = /* @__PURE__ */ Object.create(null);
      this._foreignModuleFactory = foreignModuleFactory;
      this._foreignModule = null;
    }
    dispose() {
      this._models = /* @__PURE__ */ Object.create(null);
    }
    _getModel(uri) {
      return this._models[uri];
    }
    _getModels() {
      const all = [];
      Object.keys(this._models).forEach((key) => all.push(this._models[key]));
      return all;
    }
    acceptNewModel(data2) {
      this._models[data2.url] = new MirrorModel(URI$2.parse(data2.url), data2.lines, data2.EOL, data2.versionId);
    }
    acceptModelChanged(strURL, e) {
      if (!this._models[strURL]) {
        return;
      }
      const model2 = this._models[strURL];
      model2.onEvents(e);
    }
    acceptRemovedModel(strURL) {
      if (!this._models[strURL]) {
        return;
      }
      delete this._models[strURL];
    }
    computeUnicodeHighlights(url, options, range2) {
      return __awaiter(this, void 0, void 0, function* () {
        const model2 = this._getModel(url);
        if (!model2) {
          return { ranges: [], hasMore: false, ambiguousCharacterCount: 0, invisibleCharacterCount: 0, nonBasicAsciiCharacterCount: 0 };
        }
        return UnicodeTextModelHighlighter.computeUnicodeHighlights(model2, options, range2);
      });
    }
    // ---- BEGIN diff --------------------------------------------------------------------------
    computeDiff(originalUrl, modifiedUrl, options, algorithm) {
      return __awaiter(this, void 0, void 0, function* () {
        const original = this._getModel(originalUrl);
        const modified = this._getModel(modifiedUrl);
        if (!original || !modified) {
          return null;
        }
        return EditorSimpleWorker.computeDiff(original, modified, options, algorithm);
      });
    }
    static computeDiff(originalTextModel, modifiedTextModel, options, algorithm) {
      const diffAlgorithm = algorithm === "advanced" ? linesDiffComputers.getAdvanced() : linesDiffComputers.getLegacy();
      const originalLines = originalTextModel.getLinesContent();
      const modifiedLines = modifiedTextModel.getLinesContent();
      const result = diffAlgorithm.computeDiff(originalLines, modifiedLines, options);
      const identical = result.changes.length > 0 ? false : this._modelsAreIdentical(originalTextModel, modifiedTextModel);
      function getLineChanges(changes) {
        return changes.map((m) => {
          var _a2;
          return [m.originalRange.startLineNumber, m.originalRange.endLineNumberExclusive, m.modifiedRange.startLineNumber, m.modifiedRange.endLineNumberExclusive, (_a2 = m.innerChanges) === null || _a2 === void 0 ? void 0 : _a2.map((m2) => [
            m2.originalRange.startLineNumber,
            m2.originalRange.startColumn,
            m2.originalRange.endLineNumber,
            m2.originalRange.endColumn,
            m2.modifiedRange.startLineNumber,
            m2.modifiedRange.startColumn,
            m2.modifiedRange.endLineNumber,
            m2.modifiedRange.endColumn
          ])];
        });
      }
      return {
        identical,
        quitEarly: result.hitTimeout,
        changes: getLineChanges(result.changes),
        moves: result.moves.map((m) => [
          m.lineRangeMapping.original.startLineNumber,
          m.lineRangeMapping.original.endLineNumberExclusive,
          m.lineRangeMapping.modified.startLineNumber,
          m.lineRangeMapping.modified.endLineNumberExclusive,
          getLineChanges(m.changes)
        ])
      };
    }
    static _modelsAreIdentical(original, modified) {
      const originalLineCount = original.getLineCount();
      const modifiedLineCount = modified.getLineCount();
      if (originalLineCount !== modifiedLineCount) {
        return false;
      }
      for (let line = 1; line <= originalLineCount; line++) {
        const originalLine = original.getLineContent(line);
        const modifiedLine = modified.getLineContent(line);
        if (originalLine !== modifiedLine) {
          return false;
        }
      }
      return true;
    }
    computeMoreMinimalEdits(modelUrl, edits, pretty) {
      return __awaiter(this, void 0, void 0, function* () {
        const model2 = this._getModel(modelUrl);
        if (!model2) {
          return edits;
        }
        const result = [];
        let lastEol = void 0;
        edits = edits.slice(0).sort((a2, b) => {
          if (a2.range && b.range) {
            return Range$b.compareRangesUsingStarts(a2.range, b.range);
          }
          const aRng = a2.range ? 0 : 1;
          const bRng = b.range ? 0 : 1;
          return aRng - bRng;
        });
        for (let { range: range2, text: text2, eol } of edits) {
          if (typeof eol === "number") {
            lastEol = eol;
          }
          if (Range$b.isEmpty(range2) && !text2) {
            continue;
          }
          const original = model2.getValueInRange(range2);
          text2 = text2.replace(/\r\n|\n|\r/g, model2.eol);
          if (original === text2) {
            continue;
          }
          if (Math.max(text2.length, original.length) > EditorSimpleWorker._diffLimit) {
            result.push({ range: range2, text: text2 });
            continue;
          }
          const changes = stringDiff(original, text2, pretty);
          const editOffset = model2.offsetAt(Range$b.lift(range2).getStartPosition());
          for (const change of changes) {
            const start = model2.positionAt(editOffset + change.originalStart);
            const end = model2.positionAt(editOffset + change.originalStart + change.originalLength);
            const newEdit = {
              text: text2.substr(change.modifiedStart, change.modifiedLength),
              range: { startLineNumber: start.lineNumber, startColumn: start.column, endLineNumber: end.lineNumber, endColumn: end.column }
            };
            if (model2.getValueInRange(newEdit.range) !== newEdit.text) {
              result.push(newEdit);
            }
          }
        }
        if (typeof lastEol === "number") {
          result.push({ eol: lastEol, text: "", range: { startLineNumber: 0, startColumn: 0, endLineNumber: 0, endColumn: 0 } });
        }
        return result;
      });
    }
    // ---- END minimal edits ---------------------------------------------------------------
    computeLinks(modelUrl) {
      return __awaiter(this, void 0, void 0, function* () {
        const model2 = this._getModel(modelUrl);
        if (!model2) {
          return null;
        }
        return computeLinks(model2);
      });
    }
    // --- BEGIN default document colors -----------------------------------------------------------
    computeDefaultDocumentColors(modelUrl) {
      return __awaiter(this, void 0, void 0, function* () {
        const model2 = this._getModel(modelUrl);
        if (!model2) {
          return null;
        }
        return computeDefaultDocumentColors(model2);
      });
    }
    textualSuggest(modelUrls, leadingWord, wordDef, wordDefFlags) {
      return __awaiter(this, void 0, void 0, function* () {
        const sw = new StopWatch();
        const wordDefRegExp = new RegExp(wordDef, wordDefFlags);
        const seen2 = /* @__PURE__ */ new Set();
        outer:
          for (const url of modelUrls) {
            const model2 = this._getModel(url);
            if (!model2) {
              continue;
            }
            for (const word of model2.words(wordDefRegExp)) {
              if (word === leadingWord || !isNaN(Number(word))) {
                continue;
              }
              seen2.add(word);
              if (seen2.size > EditorSimpleWorker._suggestionsLimit) {
                break outer;
              }
            }
          }
        return { words: Array.from(seen2), duration: sw.elapsed() };
      });
    }
    // ---- END suggest --------------------------------------------------------------------------
    //#region -- word ranges --
    computeWordRanges(modelUrl, range2, wordDef, wordDefFlags) {
      return __awaiter(this, void 0, void 0, function* () {
        const model2 = this._getModel(modelUrl);
        if (!model2) {
          return /* @__PURE__ */ Object.create(null);
        }
        const wordDefRegExp = new RegExp(wordDef, wordDefFlags);
        const result = /* @__PURE__ */ Object.create(null);
        for (let line = range2.startLineNumber; line < range2.endLineNumber; line++) {
          const words = model2.getLineWords(line, wordDefRegExp);
          for (const word of words) {
            if (!isNaN(Number(word.word))) {
              continue;
            }
            let array = result[word.word];
            if (!array) {
              array = [];
              result[word.word] = array;
            }
            array.push({
              startLineNumber: line,
              startColumn: word.startColumn,
              endLineNumber: line,
              endColumn: word.endColumn
            });
          }
        }
        return result;
      });
    }
    //#endregion
    navigateValueSet(modelUrl, range2, up, wordDef, wordDefFlags) {
      return __awaiter(this, void 0, void 0, function* () {
        const model2 = this._getModel(modelUrl);
        if (!model2) {
          return null;
        }
        const wordDefRegExp = new RegExp(wordDef, wordDefFlags);
        if (range2.startColumn === range2.endColumn) {
          range2 = {
            startLineNumber: range2.startLineNumber,
            startColumn: range2.startColumn,
            endLineNumber: range2.endLineNumber,
            endColumn: range2.endColumn + 1
          };
        }
        const selectionText = model2.getValueInRange(range2);
        const wordRange = model2.getWordAtPosition({ lineNumber: range2.startLineNumber, column: range2.startColumn }, wordDefRegExp);
        if (!wordRange) {
          return null;
        }
        const word = model2.getValueInRange(wordRange);
        const result = BasicInplaceReplace.INSTANCE.navigateValueSet(range2, selectionText, wordRange, word, up);
        return result;
      });
    }
    // ---- BEGIN foreign module support --------------------------------------------------------------------------
    loadForeignModule(moduleId, createData, foreignHostMethods) {
      const proxyMethodRequest = (method, args) => {
        return this._host.fhr(method, args);
      };
      const foreignHost = createProxyObject$1(foreignHostMethods, proxyMethodRequest);
      const ctx = {
        host: foreignHost,
        getMirrorModels: () => {
          return this._getModels();
        }
      };
      if (this._foreignModuleFactory) {
        this._foreignModule = this._foreignModuleFactory(ctx, createData);
        return Promise.resolve(getAllMethodNames(this._foreignModule));
      }
      return Promise.reject(new Error(`Unexpected usage`));
    }
    // foreign method request
    fmr(method, args) {
      if (!this._foreignModule || typeof this._foreignModule[method] !== "function") {
        return Promise.reject(new Error("Missing requestHandler or method: " + method));
      }
      try {
        return Promise.resolve(this._foreignModule[method].apply(this._foreignModule, args));
      } catch (e) {
        return Promise.reject(e);
      }
    }
  }
  EditorSimpleWorker._diffLimit = 1e5;
  EditorSimpleWorker._suggestionsLimit = 1e4;
  if (typeof importScripts === "function") {
    globalThis.monaco = createMonacoBaseAPI();
  }
  let initialized = false;
  function initialize(foreignModule) {
    if (initialized) {
      return;
    }
    initialized = true;
    const simpleWorker = new SimpleWorkerServer((msg) => {
      globalThis.postMessage(msg);
    }, (host) => new EditorSimpleWorker(host, foreignModule));
    globalThis.onmessage = (e) => {
      simpleWorker.onmessage(e.data);
    };
  }
  globalThis.onmessage = (e) => {
    if (!initialized) {
      initialize(null);
    }
  };
  var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  function getAugmentedNamespace(n) {
    if (n.__esModule)
      return n;
    var f2 = n.default;
    if (typeof f2 == "function") {
      var a2 = function a3() {
        if (this instanceof a3) {
          return Reflect.construct(f2, arguments, this.constructor);
        }
        return f2.apply(this, arguments);
      };
      a2.prototype = f2.prototype;
    } else
      a2 = {};
    Object.defineProperty(a2, "__esModule", { value: true });
    Object.keys(n).forEach(function(k) {
      var d = Object.getOwnPropertyDescriptor(n, k);
      Object.defineProperty(a2, k, d.get ? d : {
        enumerable: true,
        get: function() {
          return n[k];
        }
      });
    });
    return a2;
  }
  var out$e = {};
  var types$6 = {};
  Object.defineProperty(types$6, "__esModule", { value: true });
  var jsdelivr = {};
  var utils = {};
  Object.defineProperty(utils, "__esModule", { value: true });
  utils.fetchJson = utils.fetchText = void 0;
  const textCache = /* @__PURE__ */ new Map();
  const jsonCache = /* @__PURE__ */ new Map();
  async function fetchText(url) {
    if (!textCache.has(url)) {
      textCache.set(url, (async () => {
        try {
          const res = await fetch(url);
          if (res.status === 200) {
            return await res.text();
          }
        } catch {
        }
      })());
    }
    return await textCache.get(url);
  }
  utils.fetchText = fetchText;
  async function fetchJson$1(url) {
    if (!jsonCache.has(url)) {
      jsonCache.set(url, (async () => {
        try {
          const res = await fetch(url);
          if (res.status === 200) {
            return await res.json();
          }
        } catch {
        }
      })());
    }
    return await jsonCache.get(url);
  }
  utils.fetchJson = fetchJson$1;
  (function(exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.getPackageName = exports.createJsDelivrFs = exports.createJsDelivrUriResolver = exports.jsDelivrUriBase = void 0;
    const utils_12 = utils;
    exports.jsDelivrUriBase = "https://cdn.jsdelivr.net/npm";
    function createJsDelivrUriResolver(fileNameBase, versions = {}) {
      return {
        uriToFileName,
        fileNameToUri
      };
      function uriToFileName(uri) {
        if (uri === exports.jsDelivrUriBase) {
          return fileNameBase;
        }
        if (uri.startsWith(exports.jsDelivrUriBase + "/")) {
          const path2 = uri.substring(exports.jsDelivrUriBase.length);
          const pkgName = getPackageName(path2);
          if (pkgName == null ? void 0 : pkgName.substring(1).includes("@")) {
            const trimedVersion = pkgName.substring(0, pkgName.lastIndexOf("@"));
            return `${fileNameBase}${path2.replace(pkgName, trimedVersion)}`;
          }
          return `${fileNameBase}${path2}`;
        }
      }
      function fileNameToUri(fileName) {
        if (fileName === fileNameBase) {
          return exports.jsDelivrUriBase;
        }
        if (fileName.startsWith(fileNameBase + "/")) {
          const path2 = fileName.substring(fileNameBase.length);
          const pkgName = getPackageName(path2);
          if (pkgName) {
            const version2 = versions[pkgName] ?? "latest";
            return `${exports.jsDelivrUriBase}/${pkgName}@${version2}${path2.substring(1 + pkgName.length)}`;
          }
          return `${exports.jsDelivrUriBase}${path2}`;
        }
      }
    }
    exports.createJsDelivrUriResolver = createJsDelivrUriResolver;
    function createJsDelivrFs(onReadFile) {
      const fetchResults = /* @__PURE__ */ new Map();
      const flatResults = /* @__PURE__ */ new Map();
      return {
        stat,
        readDirectory,
        readFile
      };
      async function stat(uri) {
        if (uri === exports.jsDelivrUriBase) {
          return {
            type: 2,
            size: -1,
            ctime: -1,
            mtime: -1
          };
        }
        if (uri.startsWith(exports.jsDelivrUriBase + "/")) {
          const path2 = uri.substring(exports.jsDelivrUriBase.length);
          const pkgName = getPackageName(path2);
          if (!pkgName || !await isValidPackageName(pkgName)) {
            return;
          }
          if (!flatResults.has(pkgName)) {
            flatResults.set(pkgName, flat(pkgName));
          }
          const flatResult = await flatResults.get(pkgName);
          const filePath = path2.slice(`/${pkgName}`.length);
          const file = flatResult.find((file2) => file2.name === filePath);
          if (file) {
            return {
              type: 1,
              ctime: new Date(file.time).valueOf(),
              mtime: new Date(file.time).valueOf(),
              size: file.size
            };
          } else if (flatResult.some((file2) => file2.name.startsWith(filePath + "/"))) {
            return {
              type: 2,
              ctime: -1,
              mtime: -1,
              size: -1
            };
          }
        }
      }
      async function readDirectory(uri) {
        if (uri.startsWith(exports.jsDelivrUriBase + "/")) {
          const path2 = uri.substring(exports.jsDelivrUriBase.length);
          const pkgName = getPackageName(path2);
          if (!pkgName || !await isValidPackageName(pkgName)) {
            return [];
          }
          if (!flatResults.has(pkgName)) {
            flatResults.set(pkgName, flat(pkgName));
          }
          const flatResult = await flatResults.get(pkgName);
          const dirPath = path2.slice(`/${pkgName}`.length);
          const files = flatResult.filter((f2) => f2.name.substring(0, f2.name.lastIndexOf("/")) === dirPath).map((f2) => f2.name.slice(dirPath.length + 1));
          const dirs = flatResult.filter((f2) => f2.name.startsWith(dirPath + "/") && f2.name.substring(dirPath.length + 1).split("/").length >= 2).map((f2) => f2.name.slice(dirPath.length + 1).split("/")[0]);
          return [
            ...files.map((f2) => [f2, 1]),
            ...[...new Set(dirs)].map((f2) => [f2, 2])
          ];
        }
        return [];
      }
      async function readFile(uri) {
        if (uri.startsWith(exports.jsDelivrUriBase + "/")) {
          const path2 = uri.substring(exports.jsDelivrUriBase.length);
          const pkgName = getPackageName(path2);
          if (!pkgName || !await isValidPackageName(pkgName)) {
            return;
          }
          if (!fetchResults.has(path2)) {
            fetchResults.set(path2, (async () => {
              var _a2;
              if (((_a2 = await stat(uri)) == null ? void 0 : _a2.type) !== 1) {
                return;
              }
              const text2 = await (0, utils_12.fetchText)(uri);
              if (text2 !== void 0) {
                onReadFile == null ? void 0 : onReadFile(uri, text2);
              }
              return text2;
            })());
          }
          return await fetchResults.get(path2);
        }
      }
      async function flat(pkgNameWithVersion) {
        let pkgName = pkgNameWithVersion;
        let version2 = "latest";
        if (pkgNameWithVersion.substring(1).includes("@")) {
          pkgName = pkgNameWithVersion.substring(0, pkgNameWithVersion.lastIndexOf("@"));
          version2 = pkgNameWithVersion.substring(pkgNameWithVersion.lastIndexOf("@") + 1);
        }
        if (version2 === "latest") {
          const data2 = await (0, utils_12.fetchJson)(`https://data.jsdelivr.com/v1/package/resolve/npm/${pkgName}@latest`);
          if (!(data2 == null ? void 0 : data2.version)) {
            return [];
          }
          version2 = data2.version;
        }
        const flat2 = await (0, utils_12.fetchJson)(`https://data.jsdelivr.com/v1/package/npm/${pkgName}@${version2}/flat`);
        if (!flat2) {
          return [];
        }
        return flat2.files;
      }
      async function isValidPackageName(pkgName) {
        if (pkgName.substring(1).includes("@")) {
          pkgName = pkgName.substring(0, pkgName.lastIndexOf("@"));
        }
        if (pkgName.indexOf(".") >= 0 || pkgName.endsWith("/node_modules")) {
          return false;
        }
        if (pkgName.startsWith("@typescript/") || pkgName.startsWith("@types/typescript__")) {
          return false;
        }
        if (pkgName.startsWith("@types/")) {
          let originalPkgName = pkgName.slice("@types/".length);
          if (originalPkgName.indexOf("__") >= 0) {
            originalPkgName = "@" + originalPkgName.replace("__", "/");
          }
          const packageJson = await readFile(`${exports.jsDelivrUriBase}/${originalPkgName}/package.json`);
          if (packageJson) {
            const packageJsonObj = JSON.parse(packageJson);
            if (packageJsonObj.types || packageJsonObj.typings) {
              return false;
            }
            const indexDts = await stat(`${exports.jsDelivrUriBase}/${originalPkgName}/index.d.ts`);
            if ((indexDts == null ? void 0 : indexDts.type) === 1) {
              return false;
            }
          }
        }
        return true;
      }
    }
    exports.createJsDelivrFs = createJsDelivrFs;
    function getPackageName(path2) {
      const parts = path2.split("/");
      let pkgName = parts[1];
      if (pkgName.startsWith("@")) {
        if (parts.length < 3 || !parts[2]) {
          return void 0;
        }
        pkgName += "/" + parts[2];
      }
      return pkgName;
    }
    exports.getPackageName = getPackageName;
  })(jsdelivr);
  var github = {};
  Object.defineProperty(github, "__esModule", { value: true });
  github.createGitHubFs = github.createGitHubUriResolver = void 0;
  const utils_1 = utils;
  function createGitHubUriResolver(fileNameBase, owner, repo, branch) {
    const gitHubUriBase = getGitHubUriBase(owner, repo, branch);
    return {
      uriToFileName,
      fileNameToUri
    };
    function uriToFileName(uri) {
      if (uri === gitHubUriBase) {
        return fileNameBase;
      }
      if (uri.startsWith(gitHubUriBase + "/")) {
        const path2 = uri.substring(gitHubUriBase.length);
        return `${fileNameBase}${path2}`;
      }
    }
    function fileNameToUri(fileName) {
      if (fileName === fileNameBase) {
        return gitHubUriBase;
      }
      if (fileName.startsWith(fileNameBase + "/")) {
        const path2 = fileName.substring(fileNameBase.length);
        return `${gitHubUriBase}${path2}`;
      }
    }
  }
  github.createGitHubUriResolver = createGitHubUriResolver;
  function createGitHubFs(owner, repo, branch, onReadFile) {
    const gitHubUriBase = getGitHubUriBase(owner, repo, branch);
    return {
      stat,
      readDirectory,
      readFile
    };
    async function stat(uri) {
      if (uri === gitHubUriBase) {
        return {
          type: 2,
          size: -1,
          ctime: -1,
          mtime: -1
        };
      }
      if (uri.startsWith(gitHubUriBase + "/")) {
        if (uri.endsWith("/")) {
          return {
            type: 2,
            size: -1,
            ctime: -1,
            mtime: -1
          };
        }
        const path2 = uri.substring(gitHubUriBase.length);
        const dirName = path2.substring(0, path2.lastIndexOf("/"));
        const baseName = path2.substring(path2.lastIndexOf("/") + 1);
        const dirData = await fetchContents(dirName);
        const file = dirData.find((entry) => entry.name === baseName && entry.type === "file");
        const dir = dirData.find((entry) => entry.name === baseName && entry.type === "dir");
        if (file) {
          return {
            type: 1,
            size: file.size,
            ctime: -1,
            mtime: -1
          };
        }
        if (dir) {
          return {
            type: 2,
            size: dir.size,
            ctime: -1,
            mtime: -1
          };
        }
      }
    }
    async function readDirectory(uri) {
      if (uri === gitHubUriBase || uri.startsWith(gitHubUriBase + "/")) {
        const path2 = uri.substring(gitHubUriBase.length);
        const dirData = await fetchContents(path2);
        const result = dirData.map((entry) => [
          entry.name,
          entry.type === "file" ? 1 : entry.type === "dir" ? 2 : 0
        ]);
        return result;
      }
      return [];
    }
    async function readFile(uri) {
      if (uri.startsWith(gitHubUriBase + "/")) {
        const text2 = await (0, utils_1.fetchText)(uri);
        if (text2 !== void 0) {
          onReadFile == null ? void 0 : onReadFile(uri, text2);
        }
        return text2;
      }
    }
    async function fetchContents(dirName) {
      return await (0, utils_1.fetchJson)(`https://api.github.com/repos/${owner}/${repo}/contents${dirName}?ref=${branch}`) ?? [];
    }
  }
  github.createGitHubFs = createGitHubFs;
  function getGitHubUriBase(owner, repo, branch) {
    return `https://raw.githubusercontent.com/${owner}/${repo}/${branch}`;
  }
  (function(exports) {
    var __createBinding2 = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = commonjsGlobal && commonjsGlobal.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
          __createBinding2(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.decorateServiceEnvironment = void 0;
    __exportStar(types$6, exports);
    __exportStar(jsdelivr, exports);
    __exportStar(github, exports);
    function decorateServiceEnvironment(env2, uriResolver, fs) {
      const _fileNameToUri = env2.fileNameToUri;
      const _uriToFileName = env2.uriToFileName;
      const _fs = env2.fs;
      env2.fileNameToUri = (fileName) => {
        return uriResolver.fileNameToUri(fileName) ?? _fileNameToUri(fileName);
      };
      env2.uriToFileName = (fileName) => {
        return uriResolver.uriToFileName(fileName) ?? _uriToFileName(fileName);
      };
      env2.fs = {
        stat(uri) {
          if (uriResolver.uriToFileName(uri)) {
            return fs.stat(uri);
          }
          return _fs == null ? void 0 : _fs.stat(uri);
        },
        readDirectory(uri) {
          if (uriResolver.uriToFileName(uri)) {
            return fs.readDirectory(uri);
          }
          return (_fs == null ? void 0 : _fs.readDirectory(uri)) ?? [];
        },
        readFile(uri) {
          if (uriResolver.uriToFileName(uri)) {
            return fs.readFile(uri);
          }
          return _fs == null ? void 0 : _fs.readFile(uri);
        }
      };
    }
    exports.decorateServiceEnvironment = decorateServiceEnvironment;
  })(out$e);
  var out$d = {};
  var out$c = {};
  var out$b = {};
  var virtualFiles = {};
  var out$a = {};
  var out$9 = {};
  var binarySearch$2 = {};
  Object.defineProperty(binarySearch$2, "__esModule", { value: true });
  binarySearch$2.binarySearch = void 0;
  function binarySearch$1(offsets, start) {
    let low = 0;
    let high = offsets.length - 1;
    while (low <= high) {
      const mid = Math.floor((low + high) / 2);
      const midValue = offsets[mid];
      if (midValue < start) {
        low = mid + 1;
      } else if (midValue > start) {
        high = mid - 1;
      } else {
        low = mid;
        high = mid;
        break;
      }
    }
    return Math.max(Math.min(low, high, offsets.length - 1), 0);
  }
  binarySearch$2.binarySearch = binarySearch$1;
  var track$2 = {};
  Object.defineProperty(track$2, "__esModule", { value: true });
  track$2.track = track$2.resetOffsetStack = track$2.offsetStack = track$2.setTracking = void 0;
  let tracking = true;
  let stackOffset = 0;
  function setTracking(value) {
    tracking = value;
  }
  track$2.setTracking = setTracking;
  function offsetStack() {
    stackOffset++;
  }
  track$2.offsetStack = offsetStack;
  function resetOffsetStack() {
    stackOffset--;
  }
  track$2.resetOffsetStack = resetOffsetStack;
  function track$1(segments, stacks = []) {
    return [
      new Proxy(segments, {
        get(target2, prop, receiver) {
          if (tracking) {
            if (prop === "push")
              return push2;
            if (prop === "pop")
              return pop;
            if (prop === "shift")
              return shift;
            if (prop === "unshift")
              return unshift2;
            if (prop === "splice")
              return splice;
            if (prop === "sort")
              return sort2;
            if (prop === "reverse")
              return reverse;
          }
          return Reflect.get(target2, prop, receiver);
        }
      }),
      stacks
    ];
    function push2(...items) {
      stacks.push({ stack: getStack(), length: items.length });
      return segments.push(...items);
    }
    function pop() {
      if (stacks.length) {
        const last2 = stacks[stacks.length - 1];
        if (last2.length > 1) {
          last2.length--;
        } else {
          stacks.pop();
        }
      }
      return segments.pop();
    }
    function shift() {
      if (stacks.length) {
        const first = stacks[0];
        if (first.length > 1) {
          first.length--;
        } else {
          stacks.shift();
        }
      }
      return segments.shift();
    }
    function unshift2(...items) {
      stacks.unshift({ stack: getStack(), length: items.length });
      return segments.unshift(...items);
    }
    function splice(start, deleteCount, ...items) {
      if (deleteCount === void 0) {
        deleteCount = segments.length - start;
      }
      let _stackStart = 0;
      let operateIndex;
      for (let i = 0; i < stacks.length; i++) {
        const stack = stacks[i];
        const stackStart = _stackStart;
        const stackEnd = stackStart + stack.length;
        _stackStart = stackEnd;
        if (start >= stackStart) {
          operateIndex = i + 1;
          const originalLength = stack.length;
          stack.length = start - stackStart;
          stacks.splice(operateIndex, 0, { stack: stack.stack, length: originalLength - stack.length });
          break;
        }
      }
      if (operateIndex === void 0) {
        throw new Error("Invalid splice operation");
      }
      let _deleteCount = deleteCount;
      for (let i = operateIndex; i < stacks.length; i++) {
        const stack = stacks[i];
        while (_deleteCount > 0 && stack.length > 0) {
          stack.length--;
          _deleteCount--;
        }
        if (_deleteCount === 0) {
          break;
        }
      }
      stacks.splice(operateIndex, 0, { stack: getStack(), length: items.length });
      return segments.splice(start, deleteCount, ...items);
    }
    function sort2(compareFn) {
      stacks.splice(0, stacks.length, { stack: getStack(), length: segments.length });
      return segments.sort(compareFn);
    }
    function reverse() {
      stacks.splice(0, stacks.length, { stack: getStack(), length: segments.length });
      return segments.reverse();
    }
    function getStack() {
      const stack = new Error().stack;
      let source = stack.split("\n")[3 + stackOffset].trim();
      if (source.endsWith(")")) {
        source = source.slice(source.lastIndexOf("(") + 1, -1);
      } else {
        source = source.slice(source.lastIndexOf(" ") + 1);
      }
      return source;
    }
  }
  track$2.track = track$1;
  var types$5 = {};
  Object.defineProperty(types$5, "__esModule", { value: true });
  (function(exports) {
    var __createBinding2 = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = commonjsGlobal && commonjsGlobal.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
          __createBinding2(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.replaceRange = exports.replaceSourceRange = exports.replaceAll = exports.replace = exports.create = exports.toString = exports.getLength = void 0;
    const binarySearch_1 = binarySearch$2;
    const track_1 = track$2;
    __exportStar(types$5, exports);
    __exportStar(track$2, exports);
    function getLength(segments) {
      let length = 0;
      for (const segment of segments) {
        length += typeof segment == "string" ? segment.length : segment[0].length;
      }
      return length;
    }
    exports.getLength = getLength;
    function toString2(segments) {
      return segments.map((s) => typeof s === "string" ? s : s[0]).join("");
    }
    exports.toString = toString2;
    function create(source) {
      return [[source, void 0, 0]];
    }
    exports.create = create;
    function replace(segments, pattern, ...replacers) {
      const str2 = toString2(segments);
      const match = str2.match(pattern);
      if (match && match.index !== void 0) {
        const startOffset = match.index;
        const endOffset = startOffset + match[0].length;
        (0, track_1.offsetStack)();
        replaceRange(segments, startOffset, endOffset, ...replacers.map((replacer2) => typeof replacer2 === "function" ? replacer2(match[0]) : replacer2));
        (0, track_1.resetOffsetStack)();
      }
    }
    exports.replace = replace;
    function replaceAll(segments, pattern, ...replacers) {
      const str2 = toString2(segments);
      const allMatch = str2.matchAll(pattern);
      let length = str2.length;
      let lengthDiff = 0;
      for (const match of allMatch) {
        if (match.index !== void 0) {
          const startOffset = match.index + lengthDiff;
          const endOffset = startOffset + match[0].length;
          (0, track_1.offsetStack)();
          replaceRange(segments, startOffset, endOffset, ...replacers.map((replacer2) => typeof replacer2 === "function" ? replacer2(match[0]) : replacer2));
          (0, track_1.resetOffsetStack)();
          const newLength = getLength(segments);
          lengthDiff += newLength - length;
          length = newLength;
        }
      }
    }
    exports.replaceAll = replaceAll;
    function replaceSourceRange(segments, source, startOffset, endOffset, ...newSegments) {
      for (const segment of segments) {
        if (typeof segment === "string") {
          continue;
        }
        if (segment[1] === source) {
          const segmentStart = typeof segment[2] === "number" ? segment[2] : segment[2][0];
          const segmentEnd = typeof segment[2] === "number" ? segment[2] + segment[0].length : segment[2][1];
          if (segmentStart <= startOffset && segmentEnd >= endOffset) {
            const inserts = [];
            if (startOffset > segmentStart) {
              inserts.push(trimSegmentEnd(segment, startOffset - segmentStart));
            }
            for (const newSegment of newSegments) {
              inserts.push(newSegment);
            }
            if (endOffset < segmentEnd) {
              inserts.push(trimSegmentStart(segment, endOffset - segmentEnd));
            }
            combineStrings(inserts);
            (0, track_1.offsetStack)();
            segments.splice(segments.indexOf(segment), 1, ...inserts);
            (0, track_1.resetOffsetStack)();
            return true;
          }
        }
      }
      return false;
    }
    exports.replaceSourceRange = replaceSourceRange;
    function replaceRange(segments, startOffset, endOffset, ...newSegments) {
      const offsets = toOffsets(segments);
      const startIndex = (0, binarySearch_1.binarySearch)(offsets, startOffset);
      const endIndex = (0, binarySearch_1.binarySearch)(offsets, endOffset);
      const startSegment = segments[startIndex];
      const endSegment = segments[endIndex];
      const startSegmentStart = offsets[startIndex];
      const endSegmentStart = offsets[endIndex];
      const endSegmentEnd = offsets[endIndex] + (typeof endSegment === "string" ? endSegment.length : endSegment[0].length);
      const inserts = [];
      if (startOffset > startSegmentStart) {
        inserts.push(trimSegmentEnd(startSegment, startOffset - startSegmentStart));
      }
      for (const newSegment of newSegments) {
        inserts.push(newSegment);
      }
      if (endOffset < endSegmentEnd) {
        inserts.push(trimSegmentStart(endSegment, endOffset - endSegmentStart));
      }
      combineStrings(inserts);
      (0, track_1.offsetStack)();
      segments.splice(startIndex, endIndex - startIndex + 1, ...inserts);
      (0, track_1.resetOffsetStack)();
    }
    exports.replaceRange = replaceRange;
    function combineStrings(segments) {
      for (let i = segments.length - 1; i >= 1; i--) {
        if (typeof segments[i] === "string" && typeof segments[i - 1] === "string") {
          segments[i - 1] = segments[i - 1] + segments[i];
          (0, track_1.offsetStack)();
          segments.splice(i, 1);
          (0, track_1.resetOffsetStack)();
        }
      }
    }
    function trimSegmentEnd(segment, trimEnd) {
      if (typeof segment === "string") {
        return segment.slice(0, trimEnd);
      }
      const originalString = segment[0];
      const originalRange = segment[2];
      const newString = originalString.slice(0, trimEnd);
      const newRange = typeof originalRange === "number" ? originalRange : [originalRange[0], originalRange[1] - (originalString.length - newString.length)];
      return [
        newString,
        segment[1],
        newRange,
        ...segment.slice(3)
      ];
    }
    function trimSegmentStart(segment, trimStart) {
      if (typeof segment === "string") {
        return segment.slice(trimStart);
      }
      const originalString = segment[0];
      const originalRange = segment[2];
      const newString = originalString.slice(trimStart);
      if (trimStart < 0) {
        trimStart += originalString.length;
      }
      const newRange = typeof originalRange === "number" ? originalRange + trimStart : [originalRange[0] + trimStart, originalRange[1]];
      return [
        newString,
        segment[1],
        newRange,
        ...segment.slice(3)
      ];
    }
    function toOffsets(segments) {
      const offsets = [];
      let offset = 0;
      for (const segment of segments) {
        offsets.push(offset);
        offset += typeof segment == "string" ? segment.length : segment[0].length;
      }
      return offsets;
    }
  })(out$9);
  (function(exports) {
    var __createBinding2 = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = commonjsGlobal && commonjsGlobal.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
          __createBinding2(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.buildStacks = exports.buildMappings = exports.SourceMap = void 0;
    __exportStar(out$9, exports);
    class SourceMap {
      get memo() {
        if (!this._memo) {
          let createMemo = function(key) {
            const offsets = /* @__PURE__ */ new Set();
            for (const mapping of self2.mappings) {
              offsets.add(mapping[key][0]);
              offsets.add(mapping[key][1]);
            }
            const arr = [...offsets].sort((a2, b) => a2 - b).map((offset) => ({ offset, mappings: /* @__PURE__ */ new Set() }));
            for (const mapping of self2.mappings) {
              const startIndex = binarySearch2(mapping[key][0]);
              const endIndex = binarySearch2(mapping[key][1]);
              for (let i = startIndex; i <= endIndex; i++) {
                arr[i].mappings.add(mapping);
              }
            }
            return arr;
            function binarySearch2(start) {
              let low = 0;
              let high = arr.length - 1;
              while (low <= high) {
                const mid = Math.floor((low + high) / 2);
                const midValue = arr[mid];
                if (midValue.offset < start) {
                  low = mid + 1;
                } else if (midValue.offset > start) {
                  high = mid - 1;
                } else {
                  return mid;
                }
              }
            }
          };
          const self2 = this;
          this._memo = {
            sourceRange: createMemo("sourceRange"),
            generatedRange: createMemo("generatedRange")
          };
        }
        return this._memo;
      }
      constructor(mappings) {
        this.mappings = mappings;
      }
      toSourceOffset(start, baseOnRight = false) {
        for (const mapped of this.matching(start, "generatedRange", "sourceRange", baseOnRight)) {
          return mapped;
        }
      }
      toGeneratedOffset(start, baseOnRight = false) {
        for (const mapped of this.matching(start, "sourceRange", "generatedRange", baseOnRight)) {
          return mapped;
        }
      }
      toSourceOffsets(start, baseOnRight = false) {
        return this.matching(start, "generatedRange", "sourceRange", baseOnRight);
      }
      toGeneratedOffsets(start, baseOnRight = false) {
        return this.matching(start, "sourceRange", "generatedRange", baseOnRight);
      }
      *matching(startOffset, from, to, baseOnRight) {
        const memo = this.memo[from];
        if (memo.length === 0)
          return;
        const { low: start, high: end } = this.binarySearchMemo(memo, startOffset);
        const skip = /* @__PURE__ */ new Set();
        for (let i = start; i <= end; i++) {
          for (const mapping of memo[i].mappings) {
            if (skip.has(mapping)) {
              continue;
            }
            skip.add(mapping);
            const mapped = this.matchOffset(startOffset, mapping[from], mapping[to], baseOnRight);
            if (mapped !== void 0) {
              yield [mapped, mapping];
            }
          }
        }
      }
      matchOffset(start, mappedFromRange, mappedToRange, baseOnRight) {
        if (start >= mappedFromRange[0] && start <= mappedFromRange[1]) {
          let offset = mappedToRange[0] + start - mappedFromRange[0];
          if (baseOnRight) {
            offset += mappedToRange[1] - mappedToRange[0] - (mappedFromRange[1] - mappedFromRange[0]);
          }
          if (offset >= mappedToRange[0] && offset <= mappedToRange[1]) {
            return offset;
          }
        }
      }
      binarySearchMemo(array, start) {
        let low = 0;
        let high = array.length - 1;
        while (low <= high) {
          const mid = Math.floor((low + high) / 2);
          const midValue = array[mid];
          if (midValue.offset < start) {
            low = mid + 1;
          } else if (midValue.offset > start) {
            high = mid - 1;
          } else {
            low = mid;
            high = mid;
            break;
          }
        }
        return {
          low: Math.max(Math.min(low, high, array.length - 1), 0),
          high: Math.min(Math.max(low, high, 0), array.length - 1)
        };
      }
    }
    exports.SourceMap = SourceMap;
    function buildMappings(chunks) {
      let length = 0;
      const mappings = [];
      for (const segment of chunks) {
        if (typeof segment === "string") {
          length += segment.length;
        } else {
          mappings.push({
            generatedRange: [length, length + segment[0].length],
            source: segment[1],
            sourceRange: typeof segment[2] === "number" ? [segment[2], segment[2] + segment[0].length] : segment[2],
            // @ts-ignore
            data: segment[3]
          });
          length += segment[0].length;
        }
      }
      return mappings;
    }
    exports.buildMappings = buildMappings;
    function buildStacks(chunks, stacks) {
      let offset = 0;
      let index2 = 0;
      const result = [];
      for (const stack of stacks) {
        const start = offset;
        for (let i = 0; i < stack.length; i++) {
          const segment = chunks[index2 + i];
          if (typeof segment === "string") {
            offset += segment.length;
          } else {
            offset += segment[0].length;
          }
        }
        index2 += stack.length;
        result.push({
          range: [start, offset],
          source: stack.stack
        });
      }
      return result;
    }
    exports.buildStacks = buildStacks;
  })(out$a);
  var sourceMaps = {};
  Object.defineProperty(sourceMaps, "__esModule", { value: true });
  sourceMaps.MirrorMap = void 0;
  const SourceMaps = out$a;
  class MirrorMap extends SourceMaps.SourceMap {
    *findMirrorOffsets(start) {
      for (const mapped of this.toGeneratedOffsets(start)) {
        yield [mapped[0], mapped[1].data[1]];
      }
      for (const mapped of this.toSourceOffsets(start)) {
        yield [mapped[0], mapped[1].data[0]];
      }
    }
  }
  sourceMaps.MirrorMap = MirrorMap;
  Object.defineProperty(virtualFiles, "__esModule", { value: true });
  virtualFiles.forEachEmbeddedFile = virtualFiles.updateVirtualFileMaps = virtualFiles.createVirtualFiles = void 0;
  const source_map_1$3 = out$a;
  const sourceMaps_1 = sourceMaps;
  function createVirtualFiles(languages) {
    const sourceFiles = /* @__PURE__ */ new Map();
    const virtualFiles2 = /* @__PURE__ */ new Map();
    const virtualFileMaps = /* @__PURE__ */ new WeakMap();
    const virtualFileToMirrorMap = /* @__PURE__ */ new WeakMap();
    return {
      allSources() {
        return Array.from(sourceFiles.values());
      },
      updateSource(fileName, snapshot, languageId) {
        const key = normalizePath(fileName);
        const value = sourceFiles.get(key);
        if (value) {
          if (value.languageId !== languageId) {
            this.deleteSource(fileName);
            return this.updateSource(fileName, snapshot, languageId);
          } else {
            value.snapshot = snapshot;
            deleteVirtualFiles(value);
            value.language.updateVirtualFile(value.root, snapshot);
            updateVirtualFiles(value);
            return value.root;
          }
        }
        for (const language of languages) {
          const virtualFile = language.createVirtualFile(fileName, snapshot, languageId);
          if (virtualFile) {
            const source = { fileName, languageId, snapshot, root: virtualFile, language };
            sourceFiles.set(key, source);
            updateVirtualFiles(source);
            return virtualFile;
          }
        }
      },
      deleteSource(fileName) {
        var _a2, _b;
        const key = normalizePath(fileName);
        const value = sourceFiles.get(key);
        if (value) {
          (_b = (_a2 = value.language).deleteVirtualFile) == null ? void 0 : _b.call(_a2, value.root);
          sourceFiles.delete(key);
          deleteVirtualFiles(value);
        }
      },
      getSource(fileName) {
        const key = normalizePath(fileName);
        return sourceFiles.get(key);
      },
      hasSource: (fileName) => sourceFiles.has(normalizePath(fileName)),
      getMirrorMap,
      getMaps: getMapsByVirtualFile,
      hasVirtualFile(fileName) {
        return !!virtualFiles2.get(normalizePath(fileName));
      },
      getVirtualFile(fileName) {
        const sourceAndVirtual = virtualFiles2.get(normalizePath(fileName));
        if (sourceAndVirtual) {
          return [sourceAndVirtual.virtualFile, sourceAndVirtual.source];
        }
        return [void 0, void 0];
      }
    };
    function deleteVirtualFiles(source) {
      forEachEmbeddedFile$1(source.root, (file) => {
        virtualFiles2.delete(normalizePath(file.fileName));
      });
    }
    function updateVirtualFiles(source) {
      forEachEmbeddedFile$1(source.root, (file) => {
        virtualFiles2.set(normalizePath(file.fileName), { virtualFile: file, source });
      });
    }
    function getMapsByVirtualFile(virtualFile) {
      if (!virtualFileMaps.has(virtualFile.snapshot)) {
        virtualFileMaps.set(virtualFile.snapshot, /* @__PURE__ */ new Map());
      }
      updateVirtualFileMaps(virtualFile, (sourceFileName) => {
        if (sourceFileName) {
          const source = sourceFiles.get(normalizePath(sourceFileName));
          return [sourceFileName, source.snapshot];
        } else {
          const source = virtualFiles2.get(normalizePath(virtualFile.fileName)).source;
          return [source.fileName, source.snapshot];
        }
      }, virtualFileMaps.get(virtualFile.snapshot));
      return virtualFileMaps.get(virtualFile.snapshot);
    }
    function getMirrorMap(file) {
      if (!virtualFileToMirrorMap.has(file.snapshot)) {
        virtualFileToMirrorMap.set(file.snapshot, file.mirrorBehaviorMappings ? new sourceMaps_1.MirrorMap(file.mirrorBehaviorMappings) : void 0);
      }
      return virtualFileToMirrorMap.get(file.snapshot);
    }
  }
  virtualFiles.createVirtualFiles = createVirtualFiles;
  function updateVirtualFileMaps(virtualFile, getSourceSnapshot, map2 = /* @__PURE__ */ new Map()) {
    const sources = /* @__PURE__ */ new Set();
    for (const mapping of virtualFile.mappings) {
      if (sources.has(mapping.source))
        continue;
      sources.add(mapping.source);
      const source = getSourceSnapshot(mapping.source);
      if (!source)
        continue;
      if (!map2.has(source[0]) || map2.get(source[0])[0] !== source[1]) {
        map2.set(source[0], [source[1], new source_map_1$3.SourceMap(virtualFile.mappings.filter((mapping2) => mapping2.source === mapping.source))]);
      }
    }
    return map2;
  }
  virtualFiles.updateVirtualFileMaps = updateVirtualFileMaps;
  function forEachEmbeddedFile$1(file, cb) {
    cb(file);
    for (const embeddedFile of file.embeddedFiles) {
      forEachEmbeddedFile$1(embeddedFile, cb);
    }
  }
  virtualFiles.forEachEmbeddedFile = forEachEmbeddedFile$1;
  function normalizePath(fileName) {
    return fileName.replace(/\\/g, "/").toLowerCase();
  }
  var languageContext = {};
  Object.defineProperty(languageContext, "__esModule", { value: true });
  languageContext.createLanguageContext = void 0;
  const virtualFiles_1 = virtualFiles;
  function createLanguageContext(rawHost, languages) {
    let host = rawHost;
    let lastRootFiles = /* @__PURE__ */ new Map();
    let lastProjectVersion;
    const virtualFiles2 = (0, virtualFiles_1.createVirtualFiles)(languages);
    for (const language of languages.reverse()) {
      if (language.resolveHost) {
        const pastHost = host;
        let proxyHost = language.resolveHost(host);
        if (proxyHost === pastHost) {
          console.warn(`[volar] language.resolveHost() should not return the same host instance.`);
          proxyHost = { ...proxyHost };
        }
        host = new Proxy(proxyHost, {
          get(target2, p) {
            if (p in target2) {
              return target2[p];
            }
            return pastHost[p];
          }
        });
      }
    }
    return {
      rawHost,
      host,
      virtualFiles: new Proxy(virtualFiles2, {
        get: (target2, property) => {
          syncVirtualFiles();
          return target2[property];
        }
      })
    };
    function syncVirtualFiles() {
      var _a2;
      const newProjectVersion = host.getProjectVersion();
      const shouldUpdate = newProjectVersion !== lastProjectVersion;
      if (!shouldUpdate)
        return;
      const nowRootFiles = /* @__PURE__ */ new Map();
      const remainRootFiles = new Set(lastRootFiles.keys());
      for (const rootFileName of host.getScriptFileNames()) {
        nowRootFiles.set(rootFileName, host.getScriptSnapshot(rootFileName));
      }
      for (const [fileName, snapshot] of nowRootFiles) {
        remainRootFiles.delete(fileName);
        if (lastRootFiles.get(fileName) !== nowRootFiles.get(fileName)) {
          if (snapshot) {
            virtualFiles2.updateSource(fileName, snapshot, (_a2 = host.getLanguageId) == null ? void 0 : _a2.call(host, fileName));
          } else {
            virtualFiles2.deleteSource(fileName);
          }
        }
      }
      for (const fileName of remainRootFiles) {
        virtualFiles2.deleteSource(fileName);
      }
      lastRootFiles = nowRootFiles;
      lastProjectVersion = newProjectVersion;
    }
  }
  languageContext.createLanguageContext = createLanguageContext;
  var types$4 = {};
  Object.defineProperty(types$4, "__esModule", { value: true });
  types$4.FileKind = types$4.MirrorBehaviorCapabilities = types$4.FileRangeCapabilities = types$4.FileCapabilities = void 0;
  var FileCapabilities;
  (function(FileCapabilities2) {
    FileCapabilities2.full = {
      diagnostic: true,
      foldingRange: true,
      documentFormatting: true,
      documentSymbol: true,
      codeAction: true,
      inlayHint: true
    };
  })(FileCapabilities || (types$4.FileCapabilities = FileCapabilities = {}));
  var FileRangeCapabilities;
  (function(FileRangeCapabilities2) {
    FileRangeCapabilities2.full = {
      hover: true,
      references: true,
      definition: true,
      rename: true,
      completion: true,
      diagnostic: true,
      semanticTokens: true
    };
  })(FileRangeCapabilities || (types$4.FileRangeCapabilities = FileRangeCapabilities = {}));
  var MirrorBehaviorCapabilities;
  (function(MirrorBehaviorCapabilities2) {
    MirrorBehaviorCapabilities2.full = {
      references: true,
      definition: true,
      rename: true
    };
  })(MirrorBehaviorCapabilities || (types$4.MirrorBehaviorCapabilities = MirrorBehaviorCapabilities = {}));
  var FileKind;
  (function(FileKind2) {
    FileKind2[FileKind2["TextFile"] = 0] = "TextFile";
    FileKind2[FileKind2["TypeScriptHostFile"] = 1] = "TypeScriptHostFile";
  })(FileKind || (types$4.FileKind = FileKind = {}));
  (function(exports) {
    var __createBinding2 = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = commonjsGlobal && commonjsGlobal.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
          __createBinding2(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    __exportStar(virtualFiles, exports);
    __exportStar(languageContext, exports);
    __exportStar(sourceMaps, exports);
    __exportStar(types$4, exports);
  })(out$b);
  var baseLanguageService = {};
  var __spreadArray = function(to, from, pack) {
    if (pack || arguments.length === 2)
      for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
          if (!ar)
            ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
        }
      }
    return to.concat(ar || Array.prototype.slice.call(from));
  };
  var FullTextDocument$1 = (
    /** @class */
    function() {
      function FullTextDocument2(uri, languageId, version2, content) {
        this._uri = uri;
        this._languageId = languageId;
        this._version = version2;
        this._content = content;
        this._lineOffsets = void 0;
      }
      Object.defineProperty(FullTextDocument2.prototype, "uri", {
        get: function() {
          return this._uri;
        },
        enumerable: false,
        configurable: true
      });
      Object.defineProperty(FullTextDocument2.prototype, "languageId", {
        get: function() {
          return this._languageId;
        },
        enumerable: false,
        configurable: true
      });
      Object.defineProperty(FullTextDocument2.prototype, "version", {
        get: function() {
          return this._version;
        },
        enumerable: false,
        configurable: true
      });
      FullTextDocument2.prototype.getText = function(range2) {
        if (range2) {
          var start = this.offsetAt(range2.start);
          var end = this.offsetAt(range2.end);
          return this._content.substring(start, end);
        }
        return this._content;
      };
      FullTextDocument2.prototype.update = function(changes, version2) {
        for (var _i = 0, changes_1 = changes; _i < changes_1.length; _i++) {
          var change = changes_1[_i];
          if (FullTextDocument2.isIncremental(change)) {
            var range2 = getWellformedRange(change.range);
            var startOffset = this.offsetAt(range2.start);
            var endOffset = this.offsetAt(range2.end);
            this._content = this._content.substring(0, startOffset) + change.text + this._content.substring(endOffset, this._content.length);
            var startLine = Math.max(range2.start.line, 0);
            var endLine = Math.max(range2.end.line, 0);
            var lineOffsets = this._lineOffsets;
            var addedLineOffsets = computeLineOffsets(change.text, false, startOffset);
            if (endLine - startLine === addedLineOffsets.length) {
              for (var i = 0, len2 = addedLineOffsets.length; i < len2; i++) {
                lineOffsets[i + startLine + 1] = addedLineOffsets[i];
              }
            } else {
              if (addedLineOffsets.length < 1e4) {
                lineOffsets.splice.apply(lineOffsets, __spreadArray([startLine + 1, endLine - startLine], addedLineOffsets, false));
              } else {
                this._lineOffsets = lineOffsets = lineOffsets.slice(0, startLine + 1).concat(addedLineOffsets, lineOffsets.slice(endLine + 1));
              }
            }
            var diff2 = change.text.length - (endOffset - startOffset);
            if (diff2 !== 0) {
              for (var i = startLine + 1 + addedLineOffsets.length, len2 = lineOffsets.length; i < len2; i++) {
                lineOffsets[i] = lineOffsets[i] + diff2;
              }
            }
          } else if (FullTextDocument2.isFull(change)) {
            this._content = change.text;
            this._lineOffsets = void 0;
          } else {
            throw new Error("Unknown change event received");
          }
        }
        this._version = version2;
      };
      FullTextDocument2.prototype.getLineOffsets = function() {
        if (this._lineOffsets === void 0) {
          this._lineOffsets = computeLineOffsets(this._content, true);
        }
        return this._lineOffsets;
      };
      FullTextDocument2.prototype.positionAt = function(offset) {
        offset = Math.max(Math.min(offset, this._content.length), 0);
        var lineOffsets = this.getLineOffsets();
        var low = 0, high = lineOffsets.length;
        if (high === 0) {
          return { line: 0, character: offset };
        }
        while (low < high) {
          var mid = Math.floor((low + high) / 2);
          if (lineOffsets[mid] > offset) {
            high = mid;
          } else {
            low = mid + 1;
          }
        }
        var line = low - 1;
        return { line, character: offset - lineOffsets[line] };
      };
      FullTextDocument2.prototype.offsetAt = function(position) {
        var lineOffsets = this.getLineOffsets();
        if (position.line >= lineOffsets.length) {
          return this._content.length;
        } else if (position.line < 0) {
          return 0;
        }
        var lineOffset = lineOffsets[position.line];
        var nextLineOffset = position.line + 1 < lineOffsets.length ? lineOffsets[position.line + 1] : this._content.length;
        return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
      };
      Object.defineProperty(FullTextDocument2.prototype, "lineCount", {
        get: function() {
          return this.getLineOffsets().length;
        },
        enumerable: false,
        configurable: true
      });
      FullTextDocument2.isIncremental = function(event) {
        var candidate = event;
        return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range !== void 0 && (candidate.rangeLength === void 0 || typeof candidate.rangeLength === "number");
      };
      FullTextDocument2.isFull = function(event) {
        var candidate = event;
        return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range === void 0 && candidate.rangeLength === void 0;
      };
      return FullTextDocument2;
    }()
  );
  var TextDocument$1;
  (function(TextDocument2) {
    function create(uri, languageId, version2, content) {
      return new FullTextDocument$1(uri, languageId, version2, content);
    }
    TextDocument2.create = create;
    function update(document2, changes, version2) {
      if (document2 instanceof FullTextDocument$1) {
        document2.update(changes, version2);
        return document2;
      } else {
        throw new Error("TextDocument.update: document must be created by TextDocument.create");
      }
    }
    TextDocument2.update = update;
    function applyEdits(document2, edits) {
      var text2 = document2.getText();
      var sortedEdits = mergeSort(edits.map(getWellformedEdit), function(a2, b) {
        var diff2 = a2.range.start.line - b.range.start.line;
        if (diff2 === 0) {
          return a2.range.start.character - b.range.start.character;
        }
        return diff2;
      });
      var lastModifiedOffset = 0;
      var spans = [];
      for (var _i = 0, sortedEdits_1 = sortedEdits; _i < sortedEdits_1.length; _i++) {
        var e = sortedEdits_1[_i];
        var startOffset = document2.offsetAt(e.range.start);
        if (startOffset < lastModifiedOffset) {
          throw new Error("Overlapping edit");
        } else if (startOffset > lastModifiedOffset) {
          spans.push(text2.substring(lastModifiedOffset, startOffset));
        }
        if (e.newText.length) {
          spans.push(e.newText);
        }
        lastModifiedOffset = document2.offsetAt(e.range.end);
      }
      spans.push(text2.substr(lastModifiedOffset));
      return spans.join("");
    }
    TextDocument2.applyEdits = applyEdits;
  })(TextDocument$1 || (TextDocument$1 = {}));
  function mergeSort(data2, compare2) {
    if (data2.length <= 1) {
      return data2;
    }
    var p = data2.length / 2 | 0;
    var left = data2.slice(0, p);
    var right = data2.slice(p);
    mergeSort(left, compare2);
    mergeSort(right, compare2);
    var leftIdx = 0;
    var rightIdx = 0;
    var i = 0;
    while (leftIdx < left.length && rightIdx < right.length) {
      var ret = compare2(left[leftIdx], right[rightIdx]);
      if (ret <= 0) {
        data2[i++] = left[leftIdx++];
      } else {
        data2[i++] = right[rightIdx++];
      }
    }
    while (leftIdx < left.length) {
      data2[i++] = left[leftIdx++];
    }
    while (rightIdx < right.length) {
      data2[i++] = right[rightIdx++];
    }
    return data2;
  }
  function computeLineOffsets(text2, isAtLineStart, textOffset) {
    if (textOffset === void 0) {
      textOffset = 0;
    }
    var result = isAtLineStart ? [textOffset] : [];
    for (var i = 0; i < text2.length; i++) {
      var ch = text2.charCodeAt(i);
      if (ch === 13 || ch === 10) {
        if (ch === 13 && i + 1 < text2.length && text2.charCodeAt(i + 1) === 10) {
          i++;
        }
        result.push(textOffset + i + 1);
      }
    }
    return result;
  }
  function getWellformedRange(range2) {
    var start = range2.start;
    var end = range2.end;
    if (start.line > end.line || start.line === end.line && start.character > end.character) {
      return { start: end, end: start };
    }
    return range2;
  }
  function getWellformedEdit(textEdit2) {
    var range2 = getWellformedRange(textEdit2.range);
    if (range2 !== textEdit2.range) {
      return { newText: textEdit2.newText, range: range2 };
    }
    return textEdit2;
  }
  var main$1 = /* @__PURE__ */ Object.freeze({
    __proto__: null,
    get TextDocument() {
      return TextDocument$1;
    }
  });
  var require$$2$3 = /* @__PURE__ */ getAugmentedNamespace(main$1);
  var documents = {};
  var common$1 = {};
  Object.defineProperty(common$1, "__esModule", { value: true });
  common$1.notEmpty = common$1.sleep = common$1.resolveCommonLanguageId = common$1.stringToSnapshot = common$1.isInsideRange = common$1.getOverlapRange = void 0;
  function getOverlapRange(range1Start, range1End, range2Start, range2End) {
    const start = Math.max(range1Start, range2Start);
    const end = Math.min(range1End, range2End);
    if (start > end)
      return void 0;
    return {
      start,
      end
    };
  }
  common$1.getOverlapRange = getOverlapRange;
  function isInsideRange(parent, child) {
    if (child.start.line < parent.start.line)
      return false;
    if (child.end.line > parent.end.line)
      return false;
    if (child.start.line === parent.start.line && child.start.character < parent.start.character)
      return false;
    if (child.end.line === parent.end.line && child.end.character > parent.end.character)
      return false;
    return true;
  }
  common$1.isInsideRange = isInsideRange;
  function stringToSnapshot(str2) {
    return {
      getText: (start, end) => str2.substring(start, end),
      getLength: () => str2.length,
      getChangeRange: () => void 0
    };
  }
  common$1.stringToSnapshot = stringToSnapshot;
  function resolveCommonLanguageId(uri) {
    const ext = uri.split(".").pop();
    switch (ext) {
      case "js":
        return "javascript";
      case "cjs":
        return "javascript";
      case "mjs":
        return "javascript";
      case "ts":
        return "typescript";
      case "cts":
        return "typescript";
      case "mts":
        return "typescript";
      case "jsx":
        return "javascriptreact";
      case "tsx":
        return "typescriptreact";
      case "pug":
        return "jade";
      case "md":
        return "markdown";
    }
    return ext;
  }
  common$1.resolveCommonLanguageId = resolveCommonLanguageId;
  function sleep(ms) {
    return new Promise((resolve2) => setTimeout(resolve2, ms));
  }
  common$1.sleep = sleep;
  function notEmpty$1(value) {
    return value !== null && value !== void 0;
  }
  common$1.notEmpty = notEmpty$1;
  Object.defineProperty(documents, "__esModule", { value: true });
  documents.createDocumentsAndSourceMaps = documents.MirrorMapWithDocument = documents.SourceMapWithDocuments = void 0;
  const language_core_1$g = out$b;
  const vscode_languageserver_textdocument_1$2 = require$$2$3;
  const common_1$m = common$1;
  class SourceMapWithDocuments {
    constructor(sourceFileDocument, virtualFileDocument, map2) {
      this.sourceFileDocument = sourceFileDocument;
      this.virtualFileDocument = virtualFileDocument;
      this.map = map2;
    }
    // Range APIs
    toSourceRange(range2, filter = () => true) {
      for (const result of this.toSourceRanges(range2, filter)) {
        return result;
      }
    }
    toGeneratedRange(range2, filter = () => true) {
      for (const result of this.toGeneratedRanges(range2, filter)) {
        return result;
      }
    }
    *toSourceRanges(range2, filter = () => true) {
      for (const result of this.toRanges(range2, filter, "toSourcePositionsBase", "matchSourcePosition")) {
        yield result;
      }
    }
    *toGeneratedRanges(range2, filter = () => true) {
      for (const result of this.toRanges(range2, filter, "toGeneratedPositionsBase", "matchGeneratedPosition")) {
        yield result;
      }
    }
    *toRanges(range2, filter, api, api2) {
      const failedLookUps = [];
      for (const mapped of this[api](range2.start, filter, "left")) {
        const end = this[api2](range2.end, mapped[1], "right");
        if (end) {
          yield { start: mapped[0], end };
        } else {
          failedLookUps.push(mapped);
        }
      }
      for (const failedLookUp of failedLookUps) {
        for (const mapped of this[api](range2.end, filter, "right")) {
          yield { start: failedLookUp[0], end: mapped[0] };
        }
      }
    }
    // Position APIs
    toSourcePosition(position, filter = () => true, baseOffset) {
      for (const mapped of this.toSourcePositions(position, filter, baseOffset)) {
        return mapped;
      }
    }
    toGeneratedPosition(position, filter = () => true, baseOffset) {
      for (const mapped of this.toGeneratedPositions(position, filter, baseOffset)) {
        return mapped;
      }
    }
    *toSourcePositions(position, filter = () => true, baseOffset) {
      for (const mapped of this.toSourcePositionsBase(position, filter, baseOffset)) {
        yield mapped[0];
      }
    }
    *toGeneratedPositions(position, filter = () => true, baseOffset) {
      for (const mapped of this.toGeneratedPositionsBase(position, filter, baseOffset)) {
        yield mapped[0];
      }
    }
    *toSourcePositionsBase(position, filter = () => true, baseOffset) {
      let hasResult = false;
      for (const mapped of this.toPositions(position, filter, this.virtualFileDocument, this.sourceFileDocument, "generatedRange", "sourceRange", baseOffset ?? "left")) {
        hasResult = true;
        yield mapped;
      }
      if (!hasResult && baseOffset === void 0) {
        for (const mapped of this.toPositions(position, filter, this.virtualFileDocument, this.sourceFileDocument, "generatedRange", "sourceRange", "right")) {
          yield mapped;
        }
      }
    }
    *toGeneratedPositionsBase(position, filter = () => true, baseOffset) {
      let hasResult = false;
      for (const mapped of this.toPositions(position, filter, this.sourceFileDocument, this.virtualFileDocument, "sourceRange", "generatedRange", baseOffset ?? "left")) {
        hasResult = true;
        yield mapped;
      }
      if (!hasResult && baseOffset === void 0) {
        for (const mapped of this.toPositions(position, filter, this.sourceFileDocument, this.virtualFileDocument, "sourceRange", "generatedRange", "right")) {
          yield mapped;
        }
      }
    }
    *toPositions(position, filter, fromDoc, toDoc, from, to, baseOffset) {
      for (const mapped of this.map.matching(fromDoc.offsetAt(position), from, to, baseOffset === "right")) {
        if (!filter(mapped[1].data)) {
          continue;
        }
        yield [toDoc.positionAt(mapped[0]), mapped[1]];
      }
    }
    matchSourcePosition(position, mapping, baseOffset) {
      let offset = this.map.matchOffset(this.virtualFileDocument.offsetAt(position), mapping["generatedRange"], mapping["sourceRange"], baseOffset === "right");
      if (offset !== void 0) {
        return this.sourceFileDocument.positionAt(offset);
      }
    }
    matchGeneratedPosition(position, mapping, baseOffset) {
      let offset = this.map.matchOffset(this.sourceFileDocument.offsetAt(position), mapping["sourceRange"], mapping["generatedRange"], baseOffset === "right");
      if (offset !== void 0) {
        return this.virtualFileDocument.positionAt(offset);
      }
    }
  }
  documents.SourceMapWithDocuments = SourceMapWithDocuments;
  class MirrorMapWithDocument extends SourceMapWithDocuments {
    constructor(document2, map2) {
      super(document2, document2, map2);
      this.document = document2;
    }
    *findMirrorPositions(start) {
      for (const mapped of this.toGeneratedPositionsBase(start)) {
        yield [mapped[0], mapped[1].data[1]];
      }
      for (const mapped of this.toSourcePositionsBase(start)) {
        yield [mapped[0], mapped[1].data[0]];
      }
    }
  }
  documents.MirrorMapWithDocument = MirrorMapWithDocument;
  function createDocumentsAndSourceMaps(env2, host, mapper) {
    let version2 = 0;
    const map2DocMap = /* @__PURE__ */ new WeakMap();
    const mirrorMap2DocMirrorMap = /* @__PURE__ */ new WeakMap();
    const snapshot2Doc = /* @__PURE__ */ new WeakMap();
    return {
      getSourceByUri(sourceFileUri) {
        return mapper.getSource(env2.uriToFileName(sourceFileUri));
      },
      isVirtualFileUri(virtualFileUri) {
        return mapper.hasVirtualFile(env2.uriToFileName(virtualFileUri));
      },
      getVirtualFileByUri(virtualFileUri) {
        return mapper.getVirtualFile(env2.uriToFileName(virtualFileUri));
      },
      getMirrorMapByUri(virtualFileUri) {
        const fileName = env2.uriToFileName(virtualFileUri);
        const [virtualFile] = mapper.getVirtualFile(fileName);
        if (virtualFile) {
          const map2 = mapper.getMirrorMap(virtualFile);
          if (map2) {
            if (!mirrorMap2DocMirrorMap.has(map2)) {
              mirrorMap2DocMirrorMap.set(map2, new MirrorMapWithDocument(getDocumentByFileName(virtualFile.snapshot, fileName), map2));
            }
            return [virtualFile, mirrorMap2DocMirrorMap.get(map2)];
          }
        }
      },
      getMapsBySourceFileUri(uri) {
        return this.getMapsBySourceFileName(env2.uriToFileName(uri));
      },
      getMapsBySourceFileName(fileName) {
        const source = mapper.getSource(fileName);
        if (source) {
          const result = [];
          (0, language_core_1$g.forEachEmbeddedFile)(source.root, (virtualFile) => {
            for (const [sourceFileName, [sourceSnapshot, map2]] of mapper.getMaps(virtualFile)) {
              if (sourceSnapshot === source.snapshot) {
                if (!map2DocMap.has(map2)) {
                  map2DocMap.set(map2, new SourceMapWithDocuments(getDocumentByFileName(sourceSnapshot, sourceFileName), getDocumentByFileName(virtualFile.snapshot, fileName), map2));
                }
                result.push([virtualFile, map2DocMap.get(map2)]);
              }
            }
          });
          return {
            snapshot: source.snapshot,
            maps: result
          };
        }
      },
      getMapsByVirtualFileUri(virtualFileUri) {
        return this.getMapsByVirtualFileName(env2.uriToFileName(virtualFileUri));
      },
      *getMapsByVirtualFileName(virtualFileName) {
        const [virtualFile] = mapper.getVirtualFile(virtualFileName);
        if (virtualFile) {
          for (const [sourceFileName, [sourceSnapshot, map2]] of mapper.getMaps(virtualFile)) {
            if (!map2DocMap.has(map2)) {
              map2DocMap.set(map2, new SourceMapWithDocuments(getDocumentByFileName(sourceSnapshot, sourceFileName), getDocumentByFileName(virtualFile.snapshot, virtualFileName), map2));
            }
            yield [virtualFile, map2DocMap.get(map2)];
          }
        }
      },
      getDocumentByUri(snapshot, uri) {
        return this.getDocumentByFileName(snapshot, env2.uriToFileName(uri));
      },
      getDocumentByFileName
    };
    function getDocumentByFileName(snapshot, fileName) {
      var _a2;
      if (!snapshot2Doc.has(snapshot)) {
        snapshot2Doc.set(snapshot, /* @__PURE__ */ new Map());
      }
      const map2 = snapshot2Doc.get(snapshot);
      if (!map2.has(fileName)) {
        const uri = env2.fileNameToUri(fileName);
        map2.set(fileName, vscode_languageserver_textdocument_1$2.TextDocument.create(uri, ((_a2 = host.getLanguageId) == null ? void 0 : _a2.call(host, fileName)) ?? (0, common_1$m.resolveCommonLanguageId)(uri), version2++, snapshot.getText(0, snapshot.getLength())));
      }
      return map2.get(fileName);
    }
  }
  documents.createDocumentsAndSourceMaps = createDocumentsAndSourceMaps;
  var autoInsert$1 = {};
  var featureWorkers = {};
  var definePlugin = {};
  Object.defineProperty(definePlugin, "__esModule", { value: true });
  definePlugin.visitEmbedded = void 0;
  async function visitEmbedded(documents2, current, cb, rootFile = current) {
    var _a2;
    for (const embedded2 of current.embeddedFiles) {
      if (!await visitEmbedded(documents2, embedded2, cb, rootFile)) {
        return false;
      }
    }
    for (const [_, map2] of documents2.getMapsByVirtualFileName(current.fileName)) {
      if (((_a2 = documents2.getSourceByUri(map2.sourceFileDocument.uri)) == null ? void 0 : _a2.root) === rootFile) {
        if (!await cb(current, map2)) {
          return false;
        }
      }
    }
    return true;
  }
  definePlugin.visitEmbedded = visitEmbedded;
  var types$3 = {};
  Object.defineProperty(types$3, "__esModule", { value: true });
  types$3.RuleType = types$3.FileType = void 0;
  var FileType$2;
  (function(FileType2) {
    FileType2[FileType2["Unknown"] = 0] = "Unknown";
    FileType2[FileType2["File"] = 1] = "File";
    FileType2[FileType2["Directory"] = 2] = "Directory";
    FileType2[FileType2["SymbolicLink"] = 64] = "SymbolicLink";
  })(FileType$2 || (types$3.FileType = FileType$2 = {}));
  var RuleType;
  (function(RuleType2) {
    RuleType2[RuleType2["Format"] = 0] = "Format";
    RuleType2[RuleType2["Syntax"] = 1] = "Syntax";
    RuleType2[RuleType2["Semantic"] = 2] = "Semantic";
  })(RuleType || (types$3.RuleType = RuleType = {}));
  Object.defineProperty(featureWorkers, "__esModule", { value: true });
  featureWorkers.safeCall = featureWorkers.ruleWorker = featureWorkers.languageFeatureWorker = featureWorkers.documentFeatureWorker = void 0;
  const definePlugin_1$1 = definePlugin;
  const types_1$3 = types$3;
  async function documentFeatureWorker(context, uri, isValidSourceMap, worker2, transform2, combineResult) {
    return languageFeatureWorker(context, uri, void 0, (_, map2, file) => {
      if (isValidSourceMap(file, map2)) {
        return [void 0];
      }
      return [];
    }, worker2, transform2, combineResult);
  }
  featureWorkers.documentFeatureWorker = documentFeatureWorker;
  async function languageFeatureWorker(context, uri, arg, transformArg, worker2, transform2, combineResult, reportProgress) {
    var _a2;
    const document2 = context.getTextDocument(uri);
    const virtualFile = (_a2 = context.documents.getSourceByUri(uri)) == null ? void 0 : _a2.root;
    let results = [];
    if (virtualFile) {
      await (0, definePlugin_1$1.visitEmbedded)(context.documents, virtualFile, async (file, map2) => {
        for (const mappedArg of transformArg(arg, map2, file)) {
          for (const [serviceId, service] of Object.entries(context.services)) {
            const embeddedResult = await safeCall$1(() => worker2(service, map2.virtualFileDocument, mappedArg, map2, file), "service " + serviceId + " crashed on " + map2.virtualFileDocument.uri);
            if (!embeddedResult)
              continue;
            const result = transform2(embeddedResult, map2);
            if (!result)
              continue;
            results.push(result);
            if (!combineResult)
              return false;
            const isEmptyArray = Array.isArray(result) && result.length === 0;
            if (reportProgress && !isEmptyArray) {
              reportProgress(combineResult(results));
            }
          }
        }
        return true;
      });
    } else if (document2) {
      for (const [serviceId, service] of Object.entries(context.services)) {
        const embeddedResult = await safeCall$1(() => worker2(service, document2, arg, void 0, void 0), "service " + serviceId + " crashed on " + uri);
        if (!embeddedResult)
          continue;
        const result = transform2(embeddedResult, void 0);
        if (!result)
          continue;
        results.push(result);
        if (!combineResult)
          break;
        const isEmptyArray = Array.isArray(result) && result.length === 0;
        if (reportProgress && !isEmptyArray) {
          reportProgress(combineResult(results));
        }
      }
    }
    if (combineResult && results.length > 0) {
      return combineResult(results);
    } else if (results.length > 0) {
      return results[0];
    }
  }
  featureWorkers.languageFeatureWorker = languageFeatureWorker;
  async function ruleWorker(context, ruleType, uri, isValidSourceMap, worker2, transform2, combineResult, reportProgress) {
    var _a2;
    const document2 = context.getTextDocument(uri);
    const virtualFile = (_a2 = context.documents.getSourceByUri(uri)) == null ? void 0 : _a2.root;
    const ruleCtx = {
      env: context.env,
      inject: context.inject,
      report: () => {
      }
    };
    let results = [];
    if (virtualFile) {
      await (0, definePlugin_1$1.visitEmbedded)(context.documents, virtualFile, async (file, map2) => {
        if (!isValidSourceMap(file)) {
          return true;
        }
        for (const ruleId in context.rules) {
          const rule = context.rules[ruleId];
          if ((rule.type ?? types_1$3.RuleType.Syntax) !== ruleType) {
            continue;
          }
          const embeddedResult = await safeCall$1(() => worker2(ruleId, rule, map2.virtualFileDocument, ruleCtx), "rule " + ruleId + " crashed on " + map2.virtualFileDocument.uri);
          if (!embeddedResult)
            continue;
          const result = transform2(embeddedResult, map2);
          if (!result)
            continue;
          results.push(result);
          if (!combineResult)
            return false;
          const isEmptyArray = Array.isArray(result) && result.length === 0;
          if (reportProgress && !isEmptyArray) {
            reportProgress(combineResult(results));
          }
        }
        return true;
      });
    } else if (document2) {
      for (const ruleId in context.rules) {
        const rule = context.rules[ruleId];
        if ((rule.type ?? types_1$3.RuleType.Syntax) !== ruleType) {
          continue;
        }
        const embeddedResult = await safeCall$1(() => worker2(ruleId, rule, document2, ruleCtx), "rule " + ruleId + " crashed on " + document2.uri);
        if (!embeddedResult)
          continue;
        const result = transform2(embeddedResult, void 0);
        if (!result)
          continue;
        results.push(result);
        if (!combineResult)
          break;
        const isEmptyArray = Array.isArray(result) && result.length === 0;
        if (reportProgress && !isEmptyArray) {
          reportProgress(combineResult(results));
        }
      }
    }
    if (combineResult && results.length > 0) {
      return combineResult(results);
    } else if (results.length > 0) {
      return results[0];
    }
  }
  featureWorkers.ruleWorker = ruleWorker;
  async function safeCall$1(cb, errorMsg) {
    try {
      return await cb();
    } catch (err) {
      console.warn(errorMsg, err);
    }
  }
  featureWorkers.safeCall = safeCall$1;
  var cancellation = {};
  Object.defineProperty(cancellation, "__esModule", { value: true });
  cancellation.NoneCancellationToken = void 0;
  cancellation.NoneCancellationToken = {
    isCancellationRequested: false,
    onCancellationRequested: () => ({ dispose: () => {
    } })
  };
  Object.defineProperty(autoInsert$1, "__esModule", { value: true });
  autoInsert$1.register = void 0;
  const featureWorkers_1$k = featureWorkers;
  const cancellation_1$t = cancellation;
  function register$S(context) {
    return (uri, position, autoInsertContext, token = cancellation_1$t.NoneCancellationToken) => {
      return (0, featureWorkers_1$k.languageFeatureWorker)(context, uri, { position, autoInsertContext }, function* (arg, map2) {
        var _a2;
        for (const position2 of map2.toGeneratedPositions(arg.position, (data2) => !!data2.completion)) {
          const rangeOffset = (_a2 = map2.map.toGeneratedOffset(arg.autoInsertContext.lastChange.rangeOffset)) == null ? void 0 : _a2[0];
          const range2 = map2.toGeneratedRange(arg.autoInsertContext.lastChange.range);
          if (rangeOffset !== void 0 && range2) {
            yield {
              position: position2,
              autoInsertContext: {
                lastChange: {
                  ...arg.autoInsertContext.lastChange,
                  rangeOffset,
                  range: range2
                }
              }
            };
            break;
          }
        }
      }, (service, document2, arg) => {
        var _a2;
        if (token.isCancellationRequested)
          return;
        return (_a2 = service.provideAutoInsertionEdit) == null ? void 0 : _a2.call(service, document2, arg.position, arg.autoInsertContext, token);
      }, (item, map2) => {
        if (!map2 || typeof item === "string")
          return item;
        const range2 = map2.toSourceRange(item.range);
        if (range2) {
          item.range = range2;
          return item;
        }
      });
    };
  }
  autoInsert$1.register = register$S;
  var callHierarchy$2 = {};
  function assertPath(path2) {
    if (typeof path2 !== "string") {
      throw new TypeError("Path must be a string. Received " + JSON.stringify(path2));
    }
  }
  function normalizeStringPosix(path2, allowAboveRoot) {
    var res = "";
    var lastSegmentLength = 0;
    var lastSlash = -1;
    var dots = 0;
    var code;
    for (var i = 0; i <= path2.length; ++i) {
      if (i < path2.length)
        code = path2.charCodeAt(i);
      else if (code === 47)
        break;
      else
        code = 47;
      if (code === 47) {
        if (lastSlash === i - 1 || dots === 1)
          ;
        else if (lastSlash !== i - 1 && dots === 2) {
          if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== 46 || res.charCodeAt(res.length - 2) !== 46) {
            if (res.length > 2) {
              var lastSlashIndex = res.lastIndexOf("/");
              if (lastSlashIndex !== res.length - 1) {
                if (lastSlashIndex === -1) {
                  res = "";
                  lastSegmentLength = 0;
                } else {
                  res = res.slice(0, lastSlashIndex);
                  lastSegmentLength = res.length - 1 - res.lastIndexOf("/");
                }
                lastSlash = i;
                dots = 0;
                continue;
              }
            } else if (res.length === 2 || res.length === 1) {
              res = "";
              lastSegmentLength = 0;
              lastSlash = i;
              dots = 0;
              continue;
            }
          }
          if (allowAboveRoot) {
            if (res.length > 0)
              res += "/..";
            else
              res = "..";
            lastSegmentLength = 2;
          }
        } else {
          if (res.length > 0)
            res += "/" + path2.slice(lastSlash + 1, i);
          else
            res = path2.slice(lastSlash + 1, i);
          lastSegmentLength = i - lastSlash - 1;
        }
        lastSlash = i;
        dots = 0;
      } else if (code === 46 && dots !== -1) {
        ++dots;
      } else {
        dots = -1;
      }
    }
    return res;
  }
  function _format(sep, pathObject) {
    var dir = pathObject.dir || pathObject.root;
    var base = pathObject.base || (pathObject.name || "") + (pathObject.ext || "");
    if (!dir) {
      return base;
    }
    if (dir === pathObject.root) {
      return dir + base;
    }
    return dir + sep + base;
  }
  var posix = {
    // path.resolve([from ...], to)
    resolve: function resolve2() {
      var resolvedPath = "";
      var resolvedAbsolute = false;
      var cwd2;
      for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
        var path2;
        if (i >= 0)
          path2 = arguments[i];
        else {
          if (cwd2 === void 0)
            cwd2 = process.cwd();
          path2 = cwd2;
        }
        assertPath(path2);
        if (path2.length === 0) {
          continue;
        }
        resolvedPath = path2 + "/" + resolvedPath;
        resolvedAbsolute = path2.charCodeAt(0) === 47;
      }
      resolvedPath = normalizeStringPosix(resolvedPath, !resolvedAbsolute);
      if (resolvedAbsolute) {
        if (resolvedPath.length > 0)
          return "/" + resolvedPath;
        else
          return "/";
      } else if (resolvedPath.length > 0) {
        return resolvedPath;
      } else {
        return ".";
      }
    },
    normalize: function normalize(path2) {
      assertPath(path2);
      if (path2.length === 0)
        return ".";
      var isAbsolute = path2.charCodeAt(0) === 47;
      var trailingSeparator = path2.charCodeAt(path2.length - 1) === 47;
      path2 = normalizeStringPosix(path2, !isAbsolute);
      if (path2.length === 0 && !isAbsolute)
        path2 = ".";
      if (path2.length > 0 && trailingSeparator)
        path2 += "/";
      if (isAbsolute)
        return "/" + path2;
      return path2;
    },
    isAbsolute: function isAbsolute(path2) {
      assertPath(path2);
      return path2.length > 0 && path2.charCodeAt(0) === 47;
    },
    join: function join() {
      if (arguments.length === 0)
        return ".";
      var joined;
      for (var i = 0; i < arguments.length; ++i) {
        var arg = arguments[i];
        assertPath(arg);
        if (arg.length > 0) {
          if (joined === void 0)
            joined = arg;
          else
            joined += "/" + arg;
        }
      }
      if (joined === void 0)
        return ".";
      return posix.normalize(joined);
    },
    relative: function relative(from, to) {
      assertPath(from);
      assertPath(to);
      if (from === to)
        return "";
      from = posix.resolve(from);
      to = posix.resolve(to);
      if (from === to)
        return "";
      var fromStart = 1;
      for (; fromStart < from.length; ++fromStart) {
        if (from.charCodeAt(fromStart) !== 47)
          break;
      }
      var fromEnd = from.length;
      var fromLen = fromEnd - fromStart;
      var toStart = 1;
      for (; toStart < to.length; ++toStart) {
        if (to.charCodeAt(toStart) !== 47)
          break;
      }
      var toEnd = to.length;
      var toLen = toEnd - toStart;
      var length = fromLen < toLen ? fromLen : toLen;
      var lastCommonSep = -1;
      var i = 0;
      for (; i <= length; ++i) {
        if (i === length) {
          if (toLen > length) {
            if (to.charCodeAt(toStart + i) === 47) {
              return to.slice(toStart + i + 1);
            } else if (i === 0) {
              return to.slice(toStart + i);
            }
          } else if (fromLen > length) {
            if (from.charCodeAt(fromStart + i) === 47) {
              lastCommonSep = i;
            } else if (i === 0) {
              lastCommonSep = 0;
            }
          }
          break;
        }
        var fromCode = from.charCodeAt(fromStart + i);
        var toCode = to.charCodeAt(toStart + i);
        if (fromCode !== toCode)
          break;
        else if (fromCode === 47)
          lastCommonSep = i;
      }
      var out2 = "";
      for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
        if (i === fromEnd || from.charCodeAt(i) === 47) {
          if (out2.length === 0)
            out2 += "..";
          else
            out2 += "/..";
        }
      }
      if (out2.length > 0)
        return out2 + to.slice(toStart + lastCommonSep);
      else {
        toStart += lastCommonSep;
        if (to.charCodeAt(toStart) === 47)
          ++toStart;
        return to.slice(toStart);
      }
    },
    _makeLong: function _makeLong(path2) {
      return path2;
    },
    dirname: function dirname2(path2) {
      assertPath(path2);
      if (path2.length === 0)
        return ".";
      var code = path2.charCodeAt(0);
      var hasRoot = code === 47;
      var end = -1;
      var matchedSlash = true;
      for (var i = path2.length - 1; i >= 1; --i) {
        code = path2.charCodeAt(i);
        if (code === 47) {
          if (!matchedSlash) {
            end = i;
            break;
          }
        } else {
          matchedSlash = false;
        }
      }
      if (end === -1)
        return hasRoot ? "/" : ".";
      if (hasRoot && end === 1)
        return "//";
      return path2.slice(0, end);
    },
    basename: function basename(path2, ext) {
      if (ext !== void 0 && typeof ext !== "string")
        throw new TypeError('"ext" argument must be a string');
      assertPath(path2);
      var start = 0;
      var end = -1;
      var matchedSlash = true;
      var i;
      if (ext !== void 0 && ext.length > 0 && ext.length <= path2.length) {
        if (ext.length === path2.length && ext === path2)
          return "";
        var extIdx = ext.length - 1;
        var firstNonSlashEnd = -1;
        for (i = path2.length - 1; i >= 0; --i) {
          var code = path2.charCodeAt(i);
          if (code === 47) {
            if (!matchedSlash) {
              start = i + 1;
              break;
            }
          } else {
            if (firstNonSlashEnd === -1) {
              matchedSlash = false;
              firstNonSlashEnd = i + 1;
            }
            if (extIdx >= 0) {
              if (code === ext.charCodeAt(extIdx)) {
                if (--extIdx === -1) {
                  end = i;
                }
              } else {
                extIdx = -1;
                end = firstNonSlashEnd;
              }
            }
          }
        }
        if (start === end)
          end = firstNonSlashEnd;
        else if (end === -1)
          end = path2.length;
        return path2.slice(start, end);
      } else {
        for (i = path2.length - 1; i >= 0; --i) {
          if (path2.charCodeAt(i) === 47) {
            if (!matchedSlash) {
              start = i + 1;
              break;
            }
          } else if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
        }
        if (end === -1)
          return "";
        return path2.slice(start, end);
      }
    },
    extname: function extname(path2) {
      assertPath(path2);
      var startDot = -1;
      var startPart = 0;
      var end = -1;
      var matchedSlash = true;
      var preDotState = 0;
      for (var i = path2.length - 1; i >= 0; --i) {
        var code = path2.charCodeAt(i);
        if (code === 47) {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (code === 46) {
          if (startDot === -1)
            startDot = i;
          else if (preDotState !== 1)
            preDotState = 1;
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
      preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
      preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        return "";
      }
      return path2.slice(startDot, end);
    },
    format: function format2(pathObject) {
      if (pathObject === null || typeof pathObject !== "object") {
        throw new TypeError('The "pathObject" argument must be of type Object. Received type ' + typeof pathObject);
      }
      return _format("/", pathObject);
    },
    parse: function parse2(path2) {
      assertPath(path2);
      var ret = { root: "", dir: "", base: "", ext: "", name: "" };
      if (path2.length === 0)
        return ret;
      var code = path2.charCodeAt(0);
      var isAbsolute = code === 47;
      var start;
      if (isAbsolute) {
        ret.root = "/";
        start = 1;
      } else {
        start = 0;
      }
      var startDot = -1;
      var startPart = 0;
      var end = -1;
      var matchedSlash = true;
      var i = path2.length - 1;
      var preDotState = 0;
      for (; i >= start; --i) {
        code = path2.charCodeAt(i);
        if (code === 47) {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (code === 46) {
          if (startDot === -1)
            startDot = i;
          else if (preDotState !== 1)
            preDotState = 1;
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
      preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
      preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        if (end !== -1) {
          if (startPart === 0 && isAbsolute)
            ret.base = ret.name = path2.slice(1, end);
          else
            ret.base = ret.name = path2.slice(startPart, end);
        }
      } else {
        if (startPart === 0 && isAbsolute) {
          ret.name = path2.slice(1, startDot);
          ret.base = path2.slice(1, end);
        } else {
          ret.name = path2.slice(startPart, startDot);
          ret.base = path2.slice(startPart, end);
        }
        ret.ext = path2.slice(startDot, end);
      }
      if (startPart > 0)
        ret.dir = path2.slice(0, startPart - 1);
      else if (isAbsolute)
        ret.dir = "/";
      return ret;
    },
    sep: "/",
    delimiter: ":",
    win32: null,
    posix: null
  };
  posix.posix = posix;
  var pathBrowserify = posix;
  var dedupe$9 = {};
  Object.defineProperty(dedupe$9, "__esModule", { value: true });
  dedupe$9.withRanges = dedupe$9.withCallHierarchyOutgoingCalls = dedupe$9.withCallHierarchyIncomingCalls = dedupe$9.withLocationLinks = dedupe$9.withLocations = dedupe$9.withDiagnostics = dedupe$9.withDocumentChanges = dedupe$9.withTextEdits = dedupe$9.withCodeAction = dedupe$9.createLocationSet = void 0;
  function createLocationSet() {
    const set2 = /* @__PURE__ */ new Set();
    return {
      add: add2,
      has: has2
    };
    function add2(item) {
      if (has2(item)) {
        return false;
      }
      set2.add(getKey2(item));
      return true;
    }
    function has2(item) {
      return set2.has(getKey2(item));
    }
    function getKey2(item) {
      return [
        item.uri,
        item.range.start.line,
        item.range.start.character,
        item.range.end.line,
        item.range.end.character
      ].join(":");
    }
  }
  dedupe$9.createLocationSet = createLocationSet;
  function withCodeAction(items) {
    return dedupe$8(items, (item) => [
      item.title
    ].join(":"));
  }
  dedupe$9.withCodeAction = withCodeAction;
  function withTextEdits(items) {
    return dedupe$8(items, (item) => [
      item.range.start.line,
      item.range.start.character,
      item.range.end.line,
      item.range.end.character,
      item.newText
    ].join(":"));
  }
  dedupe$9.withTextEdits = withTextEdits;
  function withDocumentChanges(items) {
    return dedupe$8(items, (item) => JSON.stringify(item));
  }
  dedupe$9.withDocumentChanges = withDocumentChanges;
  function withDiagnostics(items) {
    return dedupe$8(items, (item) => [
      item.range.start.line,
      item.range.start.character,
      item.range.end.line,
      item.range.end.character,
      item.source,
      item.code,
      item.severity,
      item.message
    ].join(":"));
  }
  dedupe$9.withDiagnostics = withDiagnostics;
  function withLocations(items) {
    return dedupe$8(items, (item) => [
      item.uri,
      item.range.start.line,
      item.range.start.character,
      item.range.end.line,
      item.range.end.character
    ].join(":"));
  }
  dedupe$9.withLocations = withLocations;
  function withLocationLinks(items) {
    return dedupe$8(items, (item) => [
      item.targetUri,
      item.targetSelectionRange.start.line,
      item.targetSelectionRange.start.character,
      item.targetSelectionRange.end.line,
      item.targetSelectionRange.end.character
      // ignore difference targetRange
    ].join(":"));
  }
  dedupe$9.withLocationLinks = withLocationLinks;
  function withCallHierarchyIncomingCalls(items) {
    return dedupe$8(items, (item) => [
      item.from.uri,
      item.from.range.start.line,
      item.from.range.start.character,
      item.from.range.end.line,
      item.from.range.end.character
    ].join(":"));
  }
  dedupe$9.withCallHierarchyIncomingCalls = withCallHierarchyIncomingCalls;
  function withCallHierarchyOutgoingCalls(items) {
    return dedupe$8(items, (item) => [
      item.to.uri,
      item.to.range.start.line,
      item.to.range.start.character,
      item.to.range.end.line,
      item.to.range.end.character
    ].join(":"));
  }
  dedupe$9.withCallHierarchyOutgoingCalls = withCallHierarchyOutgoingCalls;
  function withRanges(items) {
    return dedupe$8(items, (item) => [
      item.start.line,
      item.start.character,
      item.end.line,
      item.end.character
    ].join(":"));
  }
  dedupe$9.withRanges = withRanges;
  function dedupe$8(items, getKey2) {
    const map2 = /* @__PURE__ */ new Map();
    for (const item of items.reverse()) {
      map2.set(getKey2(item), item);
    }
    return [...map2.values()];
  }
  Object.defineProperty(callHierarchy$2, "__esModule", { value: true });
  callHierarchy$2.register = void 0;
  const path_1$9 = pathBrowserify;
  const common_1$l = common$1;
  const dedupe$7 = dedupe$9;
  const featureWorkers_1$j = featureWorkers;
  const cancellation_1$s = cancellation;
  function register$R(context) {
    return {
      doPrepare(uri, position, token = cancellation_1$s.NoneCancellationToken) {
        return (0, featureWorkers_1$j.languageFeatureWorker)(context, uri, position, (position2, map2) => map2.toGeneratedPositions(position2, (data2) => !!data2.references), async (service, document2, position2, map2) => {
          var _a2;
          if (token.isCancellationRequested)
            return;
          const items = await ((_a2 = service.provideCallHierarchyItems) == null ? void 0 : _a2.call(service, document2, position2, token));
          items == null ? void 0 : items.forEach((item) => {
            item.data = {
              uri,
              original: {
                data: item.data
              },
              serviceId: Object.keys(context.services).find((key) => context.services[key] === service),
              virtualDocumentUri: map2 == null ? void 0 : map2.virtualFileDocument.uri
            };
          });
          return items;
        }, (data2, sourceMap) => !sourceMap ? data2 : data2.map((item) => {
          var _a2;
          return (_a2 = transformCallHierarchyItem(item, [])) == null ? void 0 : _a2[0];
        }).filter(common_1$l.notEmpty), (arr) => dedupe$7.withLocations(arr.flat()));
      },
      async getIncomingCalls(item, token) {
        const data2 = item.data;
        let incomingItems = [];
        if (data2) {
          const service = context.services[data2.serviceId];
          if (!service.provideCallHierarchyIncomingCalls)
            return incomingItems;
          Object.assign(item, data2.original);
          if (data2.virtualDocumentUri) {
            if (context.documents.isVirtualFileUri(data2.virtualDocumentUri)) {
              const _calls = await service.provideCallHierarchyIncomingCalls(item, token);
              for (const _call of _calls) {
                const calls = transformCallHierarchyItem(_call.from, _call.fromRanges);
                if (!calls)
                  continue;
                incomingItems.push({
                  from: calls[0],
                  fromRanges: calls[1]
                });
              }
            }
          } else {
            const _calls = await service.provideCallHierarchyIncomingCalls(item, token);
            for (const _call of _calls) {
              const calls = transformCallHierarchyItem(_call.from, _call.fromRanges);
              if (!calls)
                continue;
              incomingItems.push({
                from: calls[0],
                fromRanges: calls[1]
              });
            }
          }
        }
        return dedupe$7.withCallHierarchyIncomingCalls(incomingItems);
      },
      async getOutgoingCalls(item, token) {
        const data2 = item.data;
        let items = [];
        if (data2) {
          const service = context.services[data2.serviceId];
          if (!service.provideCallHierarchyOutgoingCalls)
            return items;
          Object.assign(item, data2.original);
          if (data2.virtualDocumentUri) {
            if (context.documents.isVirtualFileUri(data2.virtualDocumentUri)) {
              const _calls = await service.provideCallHierarchyOutgoingCalls(item, token);
              for (const call of _calls) {
                const calls = transformCallHierarchyItem(call.to, call.fromRanges);
                if (!calls)
                  continue;
                items.push({
                  to: calls[0],
                  fromRanges: calls[1]
                });
              }
            }
          } else {
            const _calls = await service.provideCallHierarchyOutgoingCalls(item, token);
            for (const call of _calls) {
              const calls = transformCallHierarchyItem(call.to, call.fromRanges);
              if (!calls)
                continue;
              items.push({
                to: calls[0],
                fromRanges: calls[1]
              });
            }
          }
        }
        return dedupe$7.withCallHierarchyOutgoingCalls(items);
      }
    };
    function transformCallHierarchyItem(tsItem, tsRanges) {
      if (!context.documents.isVirtualFileUri(tsItem.uri))
        return [tsItem, tsRanges];
      for (const [_, map2] of context.documents.getMapsByVirtualFileUri(tsItem.uri)) {
        let range2 = map2.toSourceRange(tsItem.range);
        if (!range2) {
          range2 = {
            start: map2.sourceFileDocument.positionAt(0),
            end: map2.sourceFileDocument.positionAt(map2.sourceFileDocument.getText().length)
          };
        }
        const selectionRange2 = map2.toSourceRange(tsItem.selectionRange);
        if (!selectionRange2)
          continue;
        const vueRanges = tsRanges.map((tsRange) => map2.toSourceRange(tsRange)).filter(common_1$l.notEmpty);
        const vueItem = {
          ...tsItem,
          name: tsItem.name === path_1$9.posix.basename(context.env.uriToFileName(map2.virtualFileDocument.uri)) ? path_1$9.posix.basename(context.env.uriToFileName(map2.sourceFileDocument.uri)) : tsItem.name,
          uri: map2.sourceFileDocument.uri,
          // TS Bug: `range: range` not works
          range: {
            start: range2.start,
            end: range2.end
          },
          selectionRange: {
            start: selectionRange2.start,
            end: selectionRange2.end
          }
        };
        selectionRange2.end;
        return [vueItem, vueRanges];
      }
    }
  }
  callHierarchy$2.register = register$R;
  var codeActionResolve$2 = {};
  var rename$2 = {};
  Object.defineProperty(rename$2, "__esModule", { value: true });
  rename$2.embeddedEditToSourceEdit = rename$2.mergeWorkspaceEdits = rename$2.register = void 0;
  const featureWorkers_1$i = featureWorkers;
  const dedupe$6 = dedupe$9;
  const cancellation_1$r = cancellation;
  function register$Q(context) {
    return (uri, position, newName, token = cancellation_1$r.NoneCancellationToken) => {
      let _data;
      return (0, featureWorkers_1$i.languageFeatureWorker)(context, uri, { position, newName }, function* (arg, map2) {
        for (const mapped of map2.toGeneratedPositions(arg.position, (data2) => {
          _data = data2;
          return typeof data2.rename === "object" ? !!data2.rename.normalize : !!data2.rename;
        })) {
          let newName2 = arg.newName;
          if (_data && typeof _data.rename === "object" && _data.rename.normalize) {
            newName2 = _data.rename.normalize(arg.newName);
          }
          yield { position: mapped, newName: newName2 };
        }
      }, async (service, document2, arg) => {
        if (token.isCancellationRequested)
          return;
        const recursiveChecker = dedupe$6.createLocationSet();
        let result;
        await withMirrors(document2, arg.position, arg.newName);
        return result;
        async function withMirrors(document3, position2, newName2) {
          var _a2;
          if (!service.provideRenameEdits)
            return;
          if (recursiveChecker.has({ uri: document3.uri, range: { start: position2, end: position2 } }))
            return;
          recursiveChecker.add({ uri: document3.uri, range: { start: position2, end: position2 } });
          const workspaceEdit = await service.provideRenameEdits(document3, position2, newName2, token);
          if (!workspaceEdit)
            return;
          if (!result)
            result = {};
          if (workspaceEdit.changes) {
            for (const editUri in workspaceEdit.changes) {
              const textEdits = workspaceEdit.changes[editUri];
              for (const textEdit2 of textEdits) {
                let foundMirrorPosition = false;
                recursiveChecker.add({ uri: editUri, range: { start: textEdit2.range.start, end: textEdit2.range.start } });
                const mirrorMap = (_a2 = context.documents.getMirrorMapByUri(editUri)) == null ? void 0 : _a2[1];
                if (mirrorMap) {
                  for (const mapped of mirrorMap.findMirrorPositions(textEdit2.range.start)) {
                    if (!mapped[1].rename)
                      continue;
                    if (recursiveChecker.has({ uri: mirrorMap.document.uri, range: { start: mapped[0], end: mapped[0] } }))
                      continue;
                    foundMirrorPosition = true;
                    await withMirrors(mirrorMap.document, mapped[0], newName2);
                  }
                }
                if (!foundMirrorPosition) {
                  if (!result.changes)
                    result.changes = {};
                  if (!result.changes[editUri])
                    result.changes[editUri] = [];
                  result.changes[editUri].push(textEdit2);
                }
              }
            }
          }
          if (workspaceEdit.changeAnnotations) {
            for (const uri2 in workspaceEdit.changeAnnotations) {
              if (!result.changeAnnotations)
                result.changeAnnotations = {};
              result.changeAnnotations[uri2] = workspaceEdit.changeAnnotations[uri2];
            }
          }
          if (workspaceEdit.documentChanges) {
            if (!result.documentChanges)
              result.documentChanges = [];
            result.documentChanges = result.documentChanges.concat(workspaceEdit.documentChanges);
          }
        }
      }, (data2) => {
        return embeddedEditToSourceEdit(data2, context.documents, "rename");
      }, (workspaceEdits) => {
        const mainEdit = workspaceEdits[0];
        const otherEdits = workspaceEdits.slice(1);
        mergeWorkspaceEdits(mainEdit, ...otherEdits);
        if (mainEdit.changes) {
          for (const uri2 in mainEdit.changes) {
            mainEdit.changes[uri2] = dedupe$6.withTextEdits(mainEdit.changes[uri2]);
          }
        }
        return workspaceEdits[0];
      });
    };
  }
  rename$2.register = register$Q;
  function mergeWorkspaceEdits(original, ...others) {
    for (const other of others) {
      for (const uri in other.changeAnnotations) {
        if (!original.changeAnnotations) {
          original.changeAnnotations = {};
        }
        original.changeAnnotations[uri] = other.changeAnnotations[uri];
      }
      for (const uri in other.changes) {
        if (!original.changes) {
          original.changes = {};
        }
        if (!original.changes[uri]) {
          original.changes[uri] = [];
        }
        const edits = other.changes[uri];
        original.changes[uri] = original.changes[uri].concat(edits);
      }
      if (other.documentChanges) {
        if (!original.documentChanges) {
          original.documentChanges = [];
        }
        for (const docChange of other.documentChanges) {
          pushEditToDocumentChanges(original.documentChanges, docChange);
        }
      }
    }
  }
  rename$2.mergeWorkspaceEdits = mergeWorkspaceEdits;
  function embeddedEditToSourceEdit(tsResult, documents2, mode, versions = {}) {
    var _a2, _b, _c, _d;
    const sourceResult = {};
    let hasResult = false;
    for (const tsUri in tsResult.changeAnnotations) {
      sourceResult.changeAnnotations ?? (sourceResult.changeAnnotations = {});
      const tsAnno = tsResult.changeAnnotations[tsUri];
      if (!documents2.isVirtualFileUri(tsUri)) {
        sourceResult.changeAnnotations[tsUri] = tsAnno;
      } else {
        for (const [_, map2] of documents2.getMapsByVirtualFileUri(tsUri)) {
          const uri = map2.sourceFileDocument.uri;
          sourceResult.changeAnnotations[uri] = tsAnno;
        }
      }
    }
    for (const tsUri in tsResult.changes) {
      sourceResult.changes ?? (sourceResult.changes = {});
      if (!documents2.isVirtualFileUri(tsUri)) {
        sourceResult.changes[tsUri] = tsResult.changes[tsUri];
        hasResult = true;
        continue;
      }
      for (const [_, map2] of documents2.getMapsByVirtualFileUri(tsUri)) {
        const tsEdits = tsResult.changes[tsUri];
        for (const tsEdit of tsEdits) {
          if (mode === "rename" || mode === "fileName" || mode === "codeAction") {
            let _data;
            const range2 = map2.toSourceRange(tsEdit.range, (data2) => {
              _data = data2;
              return typeof data2.rename === "object" ? !!data2.rename.apply : !!data2.rename;
            });
            if (range2) {
              let newText = tsEdit.newText;
              if (_data && typeof _data.rename === "object" && _data.rename.apply) {
                newText = _data.rename.apply(tsEdit.newText);
              }
              (_a2 = sourceResult.changes)[_b = map2.sourceFileDocument.uri] ?? (_a2[_b] = []);
              sourceResult.changes[map2.sourceFileDocument.uri].push({ newText, range: range2 });
              hasResult = true;
            }
          } else {
            const range2 = map2.toSourceRange(tsEdit.range);
            if (range2) {
              (_c = sourceResult.changes)[_d = map2.sourceFileDocument.uri] ?? (_c[_d] = []);
              sourceResult.changes[map2.sourceFileDocument.uri].push({ newText: tsEdit.newText, range: range2 });
              hasResult = true;
            }
          }
        }
      }
    }
    if (tsResult.documentChanges) {
      for (const tsDocEdit of tsResult.documentChanges) {
        sourceResult.documentChanges ?? (sourceResult.documentChanges = []);
        let sourceEdit;
        if ("textDocument" in tsDocEdit) {
          if (documents2.isVirtualFileUri(tsDocEdit.textDocument.uri)) {
            for (const [_, map2] of documents2.getMapsByVirtualFileUri(tsDocEdit.textDocument.uri)) {
              sourceEdit = {
                textDocument: {
                  uri: map2.sourceFileDocument.uri,
                  version: versions[map2.sourceFileDocument.uri] ?? null
                },
                edits: []
              };
              for (const tsEdit of tsDocEdit.edits) {
                if (mode === "rename" || mode === "fileName" || mode === "codeAction") {
                  let _data;
                  const range2 = map2.toSourceRange(tsEdit.range, (data2) => {
                    _data = data2;
                    return typeof data2.rename === "object" ? !!data2.rename.apply : !!data2.rename;
                  });
                  if (range2) {
                    let newText = tsEdit.newText;
                    if (_data && typeof _data.rename === "object" && _data.rename.apply) {
                      newText = _data.rename.apply(tsEdit.newText);
                    }
                    sourceEdit.edits.push({
                      annotationId: "annotationId" in tsEdit ? tsEdit.annotationId : void 0,
                      newText,
                      range: range2
                    });
                  }
                } else {
                  const range2 = map2.toSourceRange(tsEdit.range);
                  if (range2) {
                    sourceEdit.edits.push({
                      annotationId: "annotationId" in tsEdit ? tsEdit.annotationId : void 0,
                      newText: tsEdit.newText,
                      range: range2
                    });
                  }
                }
              }
              if (!sourceEdit.edits.length) {
                sourceEdit = void 0;
              }
            }
          } else {
            sourceEdit = tsDocEdit;
          }
        } else if (tsDocEdit.kind === "create") {
          sourceEdit = tsDocEdit;
        } else if (tsDocEdit.kind === "rename") {
          if (!documents2.isVirtualFileUri(tsDocEdit.oldUri)) {
            sourceEdit = tsDocEdit;
          } else {
            for (const [_, map2] of documents2.getMapsByVirtualFileUri(tsDocEdit.oldUri)) {
              sourceEdit = {
                kind: "rename",
                oldUri: map2.sourceFileDocument.uri,
                newUri: tsDocEdit.newUri,
                options: tsDocEdit.options,
                annotationId: tsDocEdit.annotationId
              };
            }
          }
        } else if (tsDocEdit.kind === "delete") {
          if (!documents2.isVirtualFileUri(tsDocEdit.uri)) {
            sourceEdit = tsDocEdit;
          } else {
            for (const [_, map2] of documents2.getMapsByVirtualFileUri(tsDocEdit.uri)) {
              sourceEdit = {
                kind: "delete",
                uri: map2.sourceFileDocument.uri,
                options: tsDocEdit.options,
                annotationId: tsDocEdit.annotationId
              };
            }
          }
        }
        if (sourceEdit) {
          pushEditToDocumentChanges(sourceResult.documentChanges, sourceEdit);
          hasResult = true;
        }
      }
    }
    if (hasResult) {
      return sourceResult;
    }
  }
  rename$2.embeddedEditToSourceEdit = embeddedEditToSourceEdit;
  function pushEditToDocumentChanges(arr, item) {
    const current = arr.find((edit) => "textDocument" in edit && "textDocument" in item && edit.textDocument.uri === item.textDocument.uri);
    if (current) {
      current.edits.push(...item.edits);
    } else {
      arr.push(item);
    }
  }
  Object.defineProperty(codeActionResolve$2, "__esModule", { value: true });
  codeActionResolve$2.register = void 0;
  const rename_1$5 = rename$2;
  const cancellation_1$q = cancellation;
  function register$P(context) {
    return async (item, token = cancellation_1$q.NoneCancellationToken) => {
      var _a2, _b, _c, _d, _e, _f2;
      const data2 = item.data;
      if ((data2 == null ? void 0 : data2.type) === "service") {
        const service = context.services[data2.serviceId];
        if (!service.resolveCodeAction)
          return item;
        Object.assign(item, data2.original);
        item = await service.resolveCodeAction(item, token);
        item = ((_a2 = service.transformCodeAction) == null ? void 0 : _a2.call(service, item)) ?? (item.edit ? {
          ...item,
          edit: (0, rename_1$5.embeddedEditToSourceEdit)(item.edit, context.documents, "codeAction", { [data2.uri]: data2.version })
        } : item);
      }
      if ((data2 == null ? void 0 : data2.type) === "rule") {
        const fixes = (_d = (_c = (_b = context.ruleFixes) == null ? void 0 : _b[data2.documentUri]) == null ? void 0 : _c[data2.ruleId]) == null ? void 0 : _d[data2.ruleFixIndex];
        const fix = fixes == null ? void 0 : fixes[1][data2.index];
        if (fix) {
          let edit = await ((_e = fix.getWorkspaceEdit) == null ? void 0 : _e.call(fix, fixes[0])) ?? void 0;
          if (!edit) {
            const edits = await ((_f2 = fix.getEdits) == null ? void 0 : _f2.call(fix, fixes[0]));
            if (edits) {
              edit = {
                documentChanges: [{
                  textDocument: {
                    uri: data2.documentUri,
                    version: null
                  },
                  edits
                }]
              };
            }
          }
          if (edit) {
            item.edit = (0, rename_1$5.embeddedEditToSourceEdit)(edit, context.documents, data2.isFormat ? "format" : "codeAction", { [data2.uri]: data2.version });
          }
        }
      }
      return item;
    };
  }
  codeActionResolve$2.register = register$P;
  var codeActions$1 = {};
  var transformer$8 = {};
  var completionItem = {};
  var textEdit = {};
  Object.defineProperty(textEdit, "__esModule", { value: true });
  textEdit.transform = void 0;
  function transform$c(textEdit2, getOtherRange, document2) {
    if ("range" in textEdit2) {
      let range2 = getOtherRange(textEdit2.range);
      if (range2) {
        return {
          ...textEdit2,
          range: range2
        };
      }
      const cover = tryRecover(getOtherRange, textEdit2.range, textEdit2.newText, document2);
      if (cover) {
        return {
          ...textEdit2,
          range: cover.range,
          newText: cover.newText
        };
      }
    } else if ("replace" in textEdit2 && "insert" in textEdit2) {
      const insert2 = getOtherRange(textEdit2.insert);
      const replace = insert2 ? getOtherRange(textEdit2.replace) : void 0;
      if (insert2 && replace) {
        return {
          ...textEdit2,
          insert: insert2,
          replace
        };
      }
      const recoverInsert = tryRecover(getOtherRange, textEdit2.insert, textEdit2.newText, document2);
      const recoverReplace = recoverInsert ? tryRecover(getOtherRange, textEdit2.replace, textEdit2.newText, document2) : void 0;
      if (recoverInsert && recoverReplace && recoverInsert.newText === recoverReplace.newText) {
        return {
          ...textEdit2,
          insert: recoverInsert.range,
          replace: recoverReplace.range,
          newText: recoverInsert.newText
        };
      }
    }
  }
  textEdit.transform = transform$c;
  function tryRecover(getOtherRange, replaceRange, newText, document2) {
    if (replaceRange.start.line === replaceRange.end.line && replaceRange.end.character > replaceRange.start.character) {
      let character = replaceRange.start.character;
      while (newText.length && replaceRange.end.character > character) {
        const newStart = { line: replaceRange.start.line, character: replaceRange.start.character + 1 };
        if (document2.getText({ start: replaceRange.start, end: newStart }) === newText[0]) {
          newText = newText.slice(1);
          character++;
          const otherRange = getOtherRange({ start: newStart, end: replaceRange.end });
          if (otherRange) {
            return {
              newText,
              range: otherRange
            };
          }
        } else {
          break;
        }
      }
    }
  }
  Object.defineProperty(completionItem, "__esModule", { value: true });
  completionItem.transform = void 0;
  const common_1$k = common$1;
  const textEdit_1 = textEdit;
  function transform$b(item, getOtherRange, document2) {
    var _a2;
    return {
      ...item,
      additionalTextEdits: (_a2 = item.additionalTextEdits) == null ? void 0 : _a2.map((edit) => (0, textEdit_1.transform)(edit, getOtherRange, document2)).filter(common_1$k.notEmpty),
      textEdit: item.textEdit ? (0, textEdit_1.transform)(item.textEdit, getOtherRange, document2) : void 0
    };
  }
  completionItem.transform = transform$b;
  var completionList = {};
  Object.defineProperty(completionList, "__esModule", { value: true });
  completionList.transform = void 0;
  const completionItem_1 = completionItem;
  function transform$a(completionList2, getOtherRange, document2, onItem) {
    return {
      isIncomplete: completionList2.isIncomplete,
      itemDefaults: completionList2.itemDefaults ? {
        ...completionList2.itemDefaults,
        editRange: completionList2.itemDefaults.editRange ? "replace" in completionList2.itemDefaults.editRange ? {
          insert: getOtherRange(completionList2.itemDefaults.editRange.insert),
          replace: getOtherRange(completionList2.itemDefaults.editRange.replace)
        } : getOtherRange(completionList2.itemDefaults.editRange) : void 0
      } : void 0,
      items: completionList2.items.map((item) => {
        const newItem = (0, completionItem_1.transform)(item, getOtherRange, document2);
        onItem == null ? void 0 : onItem(newItem, item);
        return newItem;
      })
    };
  }
  completionList.transform = transform$a;
  var foldingRanges$3 = {};
  Object.defineProperty(foldingRanges$3, "__esModule", { value: true });
  foldingRanges$3.transform = void 0;
  function transform$9(ranges, getOtherRange) {
    const result = [];
    for (const range2 of ranges) {
      const otherRange = getOtherRange({
        start: { line: range2.startLine, character: range2.startCharacter ?? 0 },
        end: { line: range2.endLine, character: range2.endCharacter ?? 0 }
      });
      if (otherRange) {
        range2.startLine = otherRange.start.line;
        range2.endLine = otherRange.end.line;
        if (range2.startCharacter !== void 0)
          range2.startCharacter = otherRange.start.character;
        if (range2.endCharacter !== void 0)
          range2.endCharacter = otherRange.end.character;
        result.push(range2);
      }
    }
    return result;
  }
  foldingRanges$3.transform = transform$9;
  var hover$3 = {};
  Object.defineProperty(hover$3, "__esModule", { value: true });
  hover$3.transform = void 0;
  function transform$8(hover2, getOtherRange) {
    if (!(hover2 == null ? void 0 : hover2.range)) {
      return hover2;
    }
    const range2 = getOtherRange(hover2.range);
    if (!range2)
      return;
    return {
      ...hover2,
      range: range2
    };
  }
  hover$3.transform = transform$8;
  var locationLike = {};
  Object.defineProperty(locationLike, "__esModule", { value: true });
  locationLike.transform = void 0;
  function transform$7(location, getOtherRange) {
    const range2 = getOtherRange(location.range);
    if (!range2)
      return;
    return {
      ...location,
      range: range2
    };
  }
  locationLike.transform = transform$7;
  var locationsLike = {};
  Object.defineProperty(locationsLike, "__esModule", { value: true });
  locationsLike.transform = void 0;
  const common_1$j = common$1;
  const locationLike_1 = locationLike;
  function transform$6(locations, getOtherRange) {
    return locations.map((location) => (0, locationLike_1.transform)(location, getOtherRange)).filter(common_1$j.notEmpty);
  }
  locationsLike.transform = transform$6;
  var selectionRange = {};
  Object.defineProperty(selectionRange, "__esModule", { value: true });
  selectionRange.transform = void 0;
  function transform$5(location, getOtherRange) {
    const range2 = getOtherRange(location.range);
    if (!range2)
      return;
    const parent = location.parent ? transform$5(location.parent, getOtherRange) : void 0;
    return {
      range: range2,
      parent
    };
  }
  selectionRange.transform = transform$5;
  var selectionRanges$3 = {};
  Object.defineProperty(selectionRanges$3, "__esModule", { value: true });
  selectionRanges$3.transform = void 0;
  const common_1$i = common$1;
  const selectionRange_1 = selectionRange;
  function transform$4(locations, getOtherRange) {
    return locations.map((location) => (0, selectionRange_1.transform)(location, getOtherRange)).filter(common_1$i.notEmpty);
  }
  selectionRanges$3.transform = transform$4;
  var documentSymbol$1 = {};
  Object.defineProperty(documentSymbol$1, "__esModule", { value: true });
  documentSymbol$1.transform = void 0;
  const common_1$h = common$1;
  function transform$3(symbol, getOtherRange) {
    var _a2;
    const range2 = getOtherRange(symbol.range);
    if (!range2) {
      return;
    }
    const selectionRange2 = getOtherRange(symbol.selectionRange);
    if (!selectionRange2) {
      return;
    }
    return {
      ...symbol,
      range: range2,
      selectionRange: selectionRange2,
      children: (_a2 = symbol.children) == null ? void 0 : _a2.map((child) => transform$3(child, getOtherRange)).filter(common_1$h.notEmpty)
    };
  }
  documentSymbol$1.transform = transform$3;
  var workspaceSymbol$2 = {};
  Object.defineProperty(workspaceSymbol$2, "__esModule", { value: true });
  workspaceSymbol$2.transform = void 0;
  function transform$2(symbol, getOtherLocation) {
    if (!("range" in symbol.location)) {
      return symbol;
    }
    const loc = getOtherLocation(symbol.location);
    if (!loc) {
      return;
    }
    return {
      ...symbol,
      location: loc
    };
  }
  workspaceSymbol$2.transform = transform$2;
  (function(exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.asWorkspaceSymbol = exports.asDocumentSymbol = exports.asTextEdit = exports.asSelectionRanges = exports.asSelectionRange = exports.asLocations = exports.asLocation = exports.asHover = exports.asFoldingRanges = exports.asCompletionList = exports.asCompletionItem = void 0;
    var completionItem_12 = completionItem;
    Object.defineProperty(exports, "asCompletionItem", { enumerable: true, get: function() {
      return completionItem_12.transform;
    } });
    var completionList_1 = completionList;
    Object.defineProperty(exports, "asCompletionList", { enumerable: true, get: function() {
      return completionList_1.transform;
    } });
    var foldingRanges_1 = foldingRanges$3;
    Object.defineProperty(exports, "asFoldingRanges", { enumerable: true, get: function() {
      return foldingRanges_1.transform;
    } });
    var hover_1 = hover$3;
    Object.defineProperty(exports, "asHover", { enumerable: true, get: function() {
      return hover_1.transform;
    } });
    var locationLike_12 = locationLike;
    Object.defineProperty(exports, "asLocation", { enumerable: true, get: function() {
      return locationLike_12.transform;
    } });
    var locationsLike_1 = locationsLike;
    Object.defineProperty(exports, "asLocations", { enumerable: true, get: function() {
      return locationsLike_1.transform;
    } });
    var selectionRange_12 = selectionRange;
    Object.defineProperty(exports, "asSelectionRange", { enumerable: true, get: function() {
      return selectionRange_12.transform;
    } });
    var selectionRanges_1 = selectionRanges$3;
    Object.defineProperty(exports, "asSelectionRanges", { enumerable: true, get: function() {
      return selectionRanges_1.transform;
    } });
    var textEdit_12 = textEdit;
    Object.defineProperty(exports, "asTextEdit", { enumerable: true, get: function() {
      return textEdit_12.transform;
    } });
    var documentSymbol_1 = documentSymbol$1;
    Object.defineProperty(exports, "asDocumentSymbol", { enumerable: true, get: function() {
      return documentSymbol_1.transform;
    } });
    var workspaceSymbol_1 = workspaceSymbol$2;
    Object.defineProperty(exports, "asWorkspaceSymbol", { enumerable: true, get: function() {
      return workspaceSymbol_1.transform;
    } });
  })(transformer$8);
  Object.defineProperty(codeActions$1, "__esModule", { value: true });
  codeActions$1.register = void 0;
  const transformer$7 = transformer$8;
  const common_1$g = common$1;
  const dedupe$5 = dedupe$9;
  const featureWorkers_1$h = featureWorkers;
  const rename_1$4 = rename$2;
  const cancellation_1$p = cancellation;
  function register$O(context) {
    return async (uri, range2, codeActionContext, token = cancellation_1$p.NoneCancellationToken) => {
      var _a2, _b, _c;
      const sourceDocument = context.getTextDocument(uri);
      if (!sourceDocument)
        return;
      const offsetRange = {
        start: sourceDocument.offsetAt(range2.start),
        end: sourceDocument.offsetAt(range2.end)
      };
      const transformedCodeActions = /* @__PURE__ */ new WeakSet();
      const pluginActions = await (0, featureWorkers_1$h.languageFeatureWorker)(context, uri, { range: range2, codeActionContext }, (_arg, map2, file) => {
        var _a3, _b2;
        if (!file.capabilities.codeAction)
          return [];
        const _codeActionContext = {
          diagnostics: transformer$7.asLocations(codeActionContext.diagnostics, (range3) => map2.toGeneratedRange(range3)),
          only: codeActionContext.only
        };
        let minStart;
        let maxEnd;
        for (const mapping of map2.map.mappings) {
          const overlapRange = (0, common_1$g.getOverlapRange)(offsetRange.start, offsetRange.end, mapping.sourceRange[0], mapping.sourceRange[1]);
          if (overlapRange) {
            const start = (_a3 = map2.map.toGeneratedOffset(overlapRange.start)) == null ? void 0 : _a3[0];
            const end = (_b2 = map2.map.toGeneratedOffset(overlapRange.end)) == null ? void 0 : _b2[0];
            if (start !== void 0 && end !== void 0) {
              minStart = minStart === void 0 ? start : Math.min(start, minStart);
              maxEnd = maxEnd === void 0 ? end : Math.max(end, maxEnd);
            }
          }
        }
        if (minStart !== void 0 && maxEnd !== void 0) {
          return [{
            range: {
              start: map2.virtualFileDocument.positionAt(minStart),
              end: map2.virtualFileDocument.positionAt(maxEnd)
            },
            codeActionContext: _codeActionContext
          }];
        }
        return [];
      }, async (service, document2, { range: range3, codeActionContext: codeActionContext2 }, map2) => {
        var _a3;
        if (token.isCancellationRequested)
          return;
        const serviceId = Object.keys(context.services).find((key) => context.services[key] === service);
        const diagnostics2 = codeActionContext2.diagnostics.filter((diagnostic) => {
          const data2 = diagnostic.data;
          if (data2 && data2.version !== sourceDocument.version) {
            return false;
          }
          return (data2 == null ? void 0 : data2.type) === "service" && (data2 == null ? void 0 : data2.serviceOrRuleId) === serviceId;
        }).map((diagnostic) => {
          const data2 = diagnostic.data;
          return {
            ...diagnostic,
            ...data2.original
          };
        });
        const codeActions2 = await ((_a3 = service.provideCodeActions) == null ? void 0 : _a3.call(service, document2, range3, {
          ...codeActionContext2,
          diagnostics: diagnostics2
        }, token));
        codeActions2 == null ? void 0 : codeActions2.forEach((codeAction2) => {
          codeAction2.data = {
            uri,
            version: sourceDocument.version,
            type: "service",
            original: {
              data: codeAction2.data,
              edit: codeAction2.edit
            },
            serviceId: Object.keys(context.services).find((key) => context.services[key] === service)
          };
        });
        if (codeActions2 && map2 && service.transformCodeAction) {
          for (let i = 0; i < codeActions2.length; i++) {
            const transformed = service.transformCodeAction(codeActions2[i]);
            if (transformed) {
              codeActions2[i] = transformed;
              transformedCodeActions.add(transformed);
            }
          }
        }
        return codeActions2;
      }, (actions, map2) => actions.map((action) => {
        if (transformedCodeActions.has(action))
          return action;
        if (!map2)
          return action;
        if (action.edit) {
          const edit = (0, rename_1$4.embeddedEditToSourceEdit)(action.edit, context.documents, "codeAction");
          if (!edit) {
            return;
          }
          action.edit = edit;
        }
        return action;
      }).filter(common_1$g.notEmpty), (arr) => dedupe$5.withCodeAction(arr.flat()));
      const ruleActions = [];
      for (const diagnostic of codeActionContext.diagnostics) {
        const data2 = diagnostic.data;
        if (data2 && data2.version !== sourceDocument.version) {
          continue;
        }
        if ((data2 == null ? void 0 : data2.type) === "rule") {
          const fixes = (_c = (_b = (_a2 = context.ruleFixes) == null ? void 0 : _a2[data2.documentUri]) == null ? void 0 : _b[data2.serviceOrRuleId]) == null ? void 0 : _c[data2.ruleFixIndex];
          if (fixes) {
            for (let i = 0; i < fixes[1].length; i++) {
              const fix = fixes[1][i];
              const matchKinds = [];
              if (!codeActionContext.only) {
                matchKinds.push(void 0);
              } else {
                for (const kind of fix.kinds ?? ["quickfix"]) {
                  const matchOnly = matchOnlyKind(codeActionContext.only, kind);
                  if (matchOnly) {
                    matchKinds.push(matchOnly);
                  }
                }
              }
              for (const matchKind of matchKinds) {
                const action = {
                  title: fix.title ?? `Fix: ${diagnostic.message}`,
                  kind: matchKind,
                  diagnostics: [diagnostic],
                  data: {
                    uri,
                    type: "rule",
                    version: data2.version,
                    isFormat: data2.isFormat,
                    ruleId: data2.serviceOrRuleId,
                    documentUri: data2.documentUri,
                    ruleFixIndex: data2.ruleFixIndex,
                    index: i
                  }
                };
                ruleActions.push(action);
              }
            }
          }
        }
      }
      return [
        ...pluginActions ?? [],
        ...ruleActions
      ];
    };
  }
  codeActions$1.register = register$O;
  function matchOnlyKind(only, kind) {
    const b = kind.split(".");
    for (const onlyKind of only) {
      const a2 = onlyKind.split(".");
      if (a2.length <= b.length) {
        let matchNum = 0;
        for (let i = 0; i < a2.length; i++) {
          if (a2[i] == b[i]) {
            matchNum++;
          }
        }
        if (matchNum === a2.length) {
          return onlyKind;
        }
      }
    }
  }
  var codeLens$1 = {};
  Object.defineProperty(codeLens$1, "__esModule", { value: true });
  codeLens$1.register = void 0;
  const featureWorkers_1$g = featureWorkers;
  const common_1$f = common$1;
  const cancellation_1$o = cancellation;
  function register$N(context) {
    return async (uri, token = cancellation_1$o.NoneCancellationToken) => {
      return await (0, featureWorkers_1$g.languageFeatureWorker)(context, uri, void 0, (arg) => [arg], async (service, document2) => {
        var _a2, _b;
        if (token.isCancellationRequested)
          return;
        let codeLens2 = await ((_a2 = service.provideCodeLenses) == null ? void 0 : _a2.call(service, document2, token));
        const serviceId = Object.keys(context.services).find((key) => context.services[key] === service);
        codeLens2 == null ? void 0 : codeLens2.forEach((codeLens3) => {
          codeLens3.data = {
            kind: "normal",
            uri,
            original: {
              data: codeLens3.data
            },
            serviceId
          };
        });
        const ranges = await ((_b = service.provideReferencesCodeLensRanges) == null ? void 0 : _b.call(service, document2, token));
        const referencesCodeLens = ranges == null ? void 0 : ranges.map((range2) => ({
          range: range2,
          data: {
            kind: "references",
            uri,
            range: range2,
            serviceId
          }
        }));
        codeLens2 = [
          ...codeLens2 ?? [],
          ...referencesCodeLens ?? []
        ];
        return codeLens2;
      }, (data2, map2) => data2.map((codeLens2) => {
        if (!map2)
          return codeLens2;
        const range2 = map2.toSourceRange(codeLens2.range);
        if (range2) {
          return {
            ...codeLens2,
            range: range2
          };
        }
      }).filter(common_1$f.notEmpty), (arr) => arr.flat()) ?? [];
    };
  }
  codeLens$1.register = register$N;
  var codeLensResolve$1 = {};
  var references$3 = {};
  Object.defineProperty(references$3, "__esModule", { value: true });
  references$3.register = void 0;
  const featureWorkers_1$f = featureWorkers;
  const dedupe$4 = dedupe$9;
  const cancellation_1$n = cancellation;
  function register$M(context) {
    return (uri, position, token = cancellation_1$n.NoneCancellationToken) => {
      return (0, featureWorkers_1$f.languageFeatureWorker)(context, uri, position, (position2, map2) => map2.toGeneratedPositions(position2, (data2) => !!data2.references), async (service, document2, position2) => {
        if (token.isCancellationRequested)
          return;
        const recursiveChecker = dedupe$4.createLocationSet();
        const result = [];
        await withMirrors(document2, position2);
        return result;
        async function withMirrors(document3, position3) {
          var _a2;
          if (!service.provideReferences)
            return;
          if (recursiveChecker.has({ uri: document3.uri, range: { start: position3, end: position3 } }))
            return;
          recursiveChecker.add({ uri: document3.uri, range: { start: position3, end: position3 } });
          const references2 = await service.provideReferences(document3, position3, token) ?? [];
          for (const reference of references2) {
            let foundMirrorPosition = false;
            recursiveChecker.add({ uri: reference.uri, range: { start: reference.range.start, end: reference.range.start } });
            const mirrorMap = (_a2 = context.documents.getMirrorMapByUri(reference.uri)) == null ? void 0 : _a2[1];
            if (mirrorMap) {
              for (const mapped of mirrorMap.findMirrorPositions(reference.range.start)) {
                if (!mapped[1].references)
                  continue;
                if (recursiveChecker.has({ uri: mirrorMap.document.uri, range: { start: mapped[0], end: mapped[0] } }))
                  continue;
                foundMirrorPosition = true;
                await withMirrors(mirrorMap.document, mapped[0]);
              }
            }
            if (!foundMirrorPosition) {
              result.push(reference);
            }
          }
        }
      }, (data2) => {
        const results = [];
        for (const reference of data2) {
          if (context.documents.isVirtualFileUri(reference.uri)) {
            for (const [_, map2] of context.documents.getMapsByVirtualFileUri(reference.uri)) {
              const range2 = map2.toSourceRange(reference.range, (data3) => !!data3.references);
              if (range2) {
                results.push({
                  uri: map2.sourceFileDocument.uri,
                  range: range2
                });
              }
            }
          } else {
            results.push(reference);
          }
        }
        return results;
      }, (arr) => dedupe$4.withLocations(arr.flat()));
    };
  }
  references$3.register = register$M;
  Object.defineProperty(codeLensResolve$1, "__esModule", { value: true });
  codeLensResolve$1.register = void 0;
  const references$2 = references$3;
  const cancellation_1$m = cancellation;
  function register$L(context) {
    const findReferences = references$2.register(context);
    return async (item, token = cancellation_1$m.NoneCancellationToken) => {
      const data2 = item.data;
      if ((data2 == null ? void 0 : data2.kind) === "normal") {
        const service = context.services[data2.serviceId];
        if (!service.resolveCodeLens)
          return item;
        Object.assign(item, data2.original);
        item = await service.resolveCodeLens(item, token);
      }
      if ((data2 == null ? void 0 : data2.kind) === "references") {
        let references2 = await findReferences(data2.uri, item.range.start, token) ?? [];
        const service = context.services[data2.serviceId];
        const document2 = context.getTextDocument(data2.uri);
        if (document2 && service.resolveReferencesCodeLensLocations) {
          references2 = await service.resolveReferencesCodeLensLocations(document2, data2.range, references2, token);
        }
        item.command = context.commands.showReferences.create(data2.uri, data2.range.start, references2);
      }
      return item;
    };
  }
  codeLensResolve$1.register = register$L;
  var complete = {};
  Object.defineProperty(complete, "__esModule", { value: true });
  complete.register = void 0;
  const transformer$6 = transformer$8;
  const definePlugin_1 = definePlugin;
  const cancellation_1$l = cancellation;
  function register$K(context) {
    let cache;
    return async (uri, position, completionContext = { triggerKind: 1 }, token = cancellation_1$l.NoneCancellationToken) => {
      var _a2, _b;
      let document2;
      if ((completionContext == null ? void 0 : completionContext.triggerKind) === 3 && (cache == null ? void 0 : cache.uri) === uri) {
        for (const cacheData of cache.data) {
          if (!cacheData.list.isIncomplete)
            continue;
          if (cacheData.virtualDocumentUri) {
            for (const [_, map2] of context.documents.getMapsByVirtualFileUri(cacheData.virtualDocumentUri)) {
              for (const mapped of map2.toGeneratedPositions(position, (data2) => !!data2.completion)) {
                if (!cacheData.service.provideCompletionItems)
                  continue;
                const embeddedCompletionList = await cacheData.service.provideCompletionItems(map2.virtualFileDocument, mapped, completionContext, token);
                if (!embeddedCompletionList) {
                  cacheData.list.isIncomplete = false;
                  continue;
                }
                cacheData.list = transformer$6.asCompletionList(embeddedCompletionList, (range2) => map2.toSourceRange(range2), map2.virtualFileDocument, (newItem, oldItem) => newItem.data = {
                  uri,
                  original: {
                    additionalTextEdits: oldItem.additionalTextEdits,
                    textEdit: oldItem.textEdit,
                    data: oldItem.data
                  },
                  serviceId: Object.keys(context.services).find((key) => context.services[key] === cacheData.service),
                  virtualDocumentUri: map2.virtualFileDocument.uri
                });
              }
            }
          } else if (document2 = context.getTextDocument(uri)) {
            if (!cacheData.service.provideCompletionItems)
              continue;
            const completionList2 = await cacheData.service.provideCompletionItems(document2, position, completionContext, token);
            if (!completionList2) {
              cacheData.list.isIncomplete = false;
              continue;
            }
            completionList2.items.forEach((item) => {
              item.data = {
                uri,
                original: {
                  additionalTextEdits: item.additionalTextEdits,
                  textEdit: item.textEdit,
                  data: item.data
                },
                serviceId: Object.keys(context.services).find((key) => context.services[key] === cacheData.service),
                virtualDocumentUri: void 0
              };
            });
          }
        }
      } else {
        const rootFile = (_a2 = context.documents.getSourceByUri(uri)) == null ? void 0 : _a2.root;
        cache = {
          uri,
          data: [],
          mainCompletion: void 0
        };
        let isFirstMapping = true;
        if (rootFile) {
          await (0, definePlugin_1.visitEmbedded)(context.documents, rootFile, async (_, map2) => {
            var _a3;
            const services = Object.values(context.services).sort(sortServices);
            let _data;
            for (const mapped of map2.toGeneratedPositions(position, (data2) => {
              _data = data2;
              return !!data2.completion;
            })) {
              for (const service of services) {
                if (token.isCancellationRequested)
                  break;
                if (!service.provideCompletionItems)
                  continue;
                if (service.isAdditionalCompletion && !isFirstMapping)
                  continue;
                if ((completionContext == null ? void 0 : completionContext.triggerCharacter) && !((_a3 = service.triggerCharacters) == null ? void 0 : _a3.includes(completionContext.triggerCharacter)))
                  continue;
                const isAdditional = _data && typeof _data.completion === "object" && _data.completion.additional || service.isAdditionalCompletion;
                if (cache.mainCompletion && (!isAdditional || (cache == null ? void 0 : cache.mainCompletion.documentUri) !== map2.virtualFileDocument.uri))
                  continue;
                if (service.isAdditionalCompletion && (cache == null ? void 0 : cache.data.some((data2) => data2.service === service)))
                  continue;
                const embeddedCompletionList = await service.provideCompletionItems(map2.virtualFileDocument, mapped, completionContext, token);
                if (!embeddedCompletionList || !embeddedCompletionList.items.length)
                  continue;
                if (typeof (_data == null ? void 0 : _data.completion) === "object" && _data.completion.autoImportOnly) {
                  embeddedCompletionList.items = embeddedCompletionList.items.filter((item) => !!item.labelDetails);
                }
                if (!isAdditional) {
                  cache.mainCompletion = { documentUri: map2.virtualFileDocument.uri };
                }
                const completionList2 = transformer$6.asCompletionList(embeddedCompletionList, (range2) => map2.toSourceRange(range2), map2.virtualFileDocument, (newItem, oldItem) => newItem.data = {
                  uri,
                  original: {
                    additionalTextEdits: oldItem.additionalTextEdits,
                    textEdit: oldItem.textEdit,
                    data: oldItem.data
                  },
                  serviceId: Object.keys(context.services).find((key) => context.services[key] === service),
                  virtualDocumentUri: map2.virtualFileDocument.uri
                });
                cache.data.push({
                  virtualDocumentUri: map2.virtualFileDocument.uri,
                  service,
                  list: completionList2
                });
              }
              isFirstMapping = false;
            }
            return true;
          });
        }
        if (document2 = context.getTextDocument(uri)) {
          const services = Object.values(context.services).sort(sortServices);
          for (const service of services) {
            if (token.isCancellationRequested)
              break;
            if (!service.provideCompletionItems)
              continue;
            if (service.isAdditionalCompletion && !isFirstMapping)
              continue;
            if ((completionContext == null ? void 0 : completionContext.triggerCharacter) && !((_b = service.triggerCharacters) == null ? void 0 : _b.includes(completionContext.triggerCharacter)))
              continue;
            if (cache.mainCompletion && (!service.isAdditionalCompletion || cache.mainCompletion.documentUri !== document2.uri))
              continue;
            if (service.isAdditionalCompletion && (cache == null ? void 0 : cache.data.some((data2) => data2.service === service)))
              continue;
            const completionList2 = await service.provideCompletionItems(document2, position, completionContext, token);
            if (!completionList2 || !completionList2.items.length)
              continue;
            if (!service.isAdditionalCompletion) {
              cache.mainCompletion = { documentUri: document2.uri };
            }
            completionList2.items.forEach((item) => {
              item.data = {
                uri,
                original: {
                  additionalTextEdits: item.additionalTextEdits,
                  textEdit: item.textEdit,
                  data: item.data
                },
                serviceId: Object.keys(context.services).find((key) => context.services[key] === service),
                virtualDocumentUri: void 0
              };
            });
            cache.data.push({
              virtualDocumentUri: void 0,
              service,
              list: completionList2
            });
          }
        }
      }
      return combineCompletionList(cache.data.map((cacheData) => cacheData.list));
      function sortServices(a2, b) {
        return (b.isAdditionalCompletion ? -1 : 1) - (a2.isAdditionalCompletion ? -1 : 1);
      }
      function combineCompletionList(lists) {
        var _a3;
        return {
          isIncomplete: lists.some((list) => list.isIncomplete),
          itemDefaults: (_a3 = lists.find((list) => list.itemDefaults)) == null ? void 0 : _a3.itemDefaults,
          items: lists.map((list) => list.items).flat()
        };
      }
    };
  }
  complete.register = register$K;
  var completeResolve = {};
  Object.defineProperty(completeResolve, "__esModule", { value: true });
  completeResolve.register = void 0;
  const transformer$5 = transformer$8;
  const cancellation_1$k = cancellation;
  function register$J(context) {
    return async (item, token = cancellation_1$k.NoneCancellationToken) => {
      var _a2;
      const data2 = item.data;
      if (data2) {
        const service = context.services[data2.serviceId];
        if (!service.resolveCompletionItem)
          return item;
        item = Object.assign(item, data2.original);
        if (data2.virtualDocumentUri) {
          for (const [_, map2] of context.documents.getMapsByVirtualFileUri(data2.virtualDocumentUri)) {
            item = await service.resolveCompletionItem(item, token);
            item = ((_a2 = service.transformCompletionItem) == null ? void 0 : _a2.call(service, item)) ?? transformer$5.asCompletionItem(item, (embeddedRange) => map2.toSourceRange(embeddedRange), map2.virtualFileDocument);
          }
        } else {
          item = await service.resolveCompletionItem(item, token);
        }
      }
      if (item.detail !== item.detail + ".ts") {
        item.detail = item.detail;
      }
      return item;
    };
  }
  completeResolve.register = register$J;
  var definition$2 = {};
  Object.defineProperty(definition$2, "__esModule", { value: true });
  definition$2.register = void 0;
  const featureWorkers_1$e = featureWorkers;
  const dedupe$3 = dedupe$9;
  const common_1$e = common$1;
  const cancellation_1$j = cancellation;
  function register$I(context, apiName, isValidMapping, isValidMirrorPosition) {
    return (uri, position, token = cancellation_1$j.NoneCancellationToken) => {
      return (0, featureWorkers_1$e.languageFeatureWorker)(context, uri, position, (position2, map2) => map2.toGeneratedPositions(position2, isValidMapping), async (service, document2, position2) => {
        if (token.isCancellationRequested)
          return;
        const recursiveChecker = dedupe$3.createLocationSet();
        const result = [];
        await withMirrors(document2, position2, void 0);
        return result;
        async function withMirrors(document3, position3, originDefinition) {
          var _a2;
          const api = service[apiName];
          if (!api)
            return;
          if (recursiveChecker.has({ uri: document3.uri, range: { start: position3, end: position3 } }))
            return;
          recursiveChecker.add({ uri: document3.uri, range: { start: position3, end: position3 } });
          const definitions = await (api == null ? void 0 : api(document3, position3, token)) ?? [];
          for (const definition2 of definitions) {
            let foundMirrorPosition = false;
            recursiveChecker.add({ uri: definition2.targetUri, range: { start: definition2.targetRange.start, end: definition2.targetRange.start } });
            const mirrorMap = (_a2 = context.documents.getMirrorMapByUri(definition2.targetUri)) == null ? void 0 : _a2[1];
            if (mirrorMap) {
              for (const mapped of mirrorMap.findMirrorPositions(definition2.targetSelectionRange.start)) {
                if (!isValidMirrorPosition(mapped[1]))
                  continue;
                if (recursiveChecker.has({ uri: mirrorMap.document.uri, range: { start: mapped[0], end: mapped[0] } }))
                  continue;
                foundMirrorPosition = true;
                await withMirrors(mirrorMap.document, mapped[0], originDefinition ?? definition2);
              }
            }
            if (!foundMirrorPosition) {
              if (originDefinition) {
                result.push({
                  ...definition2,
                  originSelectionRange: originDefinition.originSelectionRange
                });
              } else {
                result.push(definition2);
              }
            }
          }
        }
      }, (data2, sourceMap) => data2.map((link) => {
        if (link.originSelectionRange && sourceMap) {
          const originSelectionRange = toSourcePositionPreferSurroundedPosition(sourceMap, link.originSelectionRange, position);
          if (!originSelectionRange)
            return;
          link.originSelectionRange = originSelectionRange;
        }
        let foundTargetSelectionRange = false;
        for (const [_, targetSourceMap] of context.documents.getMapsByVirtualFileUri(link.targetUri)) {
          const targetSelectionRange = targetSourceMap.toSourceRange(link.targetSelectionRange);
          if (!targetSelectionRange)
            continue;
          foundTargetSelectionRange = true;
          let targetRange = targetSourceMap.toSourceRange(link.targetRange);
          link.targetUri = targetSourceMap.sourceFileDocument.uri;
          link.targetRange = targetRange ?? targetSelectionRange;
          link.targetSelectionRange = targetSelectionRange;
        }
        if (apiName === "provideDefinition" && context.documents.isVirtualFileUri(link.targetUri) && !foundTargetSelectionRange) {
          for (const [_, targetMap2] of context.documents.getMapsByVirtualFileUri(link.targetUri)) {
            if (targetMap2 && targetMap2.sourceFileDocument.uri !== uri) {
              return {
                ...link,
                targetUri: targetMap2.sourceFileDocument.uri,
                targetRange: {
                  start: { line: 0, character: 0 },
                  end: { line: 0, character: 0 }
                },
                targetSelectionRange: {
                  start: { line: 0, character: 0 },
                  end: { line: 0, character: 0 }
                }
              };
            }
          }
          return;
        }
        return link;
      }).filter(common_1$e.notEmpty), (arr) => dedupe$3.withLocationLinks(arr.flat()));
    };
  }
  definition$2.register = register$I;
  function toSourcePositionPreferSurroundedPosition(map2, mappedRange, position) {
    let result;
    for (const range2 of map2.toSourceRanges(mappedRange)) {
      if (!result) {
        result = range2;
      }
      if ((range2.start.line < position.line || range2.start.line === position.line && range2.start.character <= position.character) && (range2.end.line > position.line || range2.end.line === position.line && range2.end.character >= position.character)) {
        return range2;
      }
    }
    return result;
  }
  var documentHighlights = {};
  Object.defineProperty(documentHighlights, "__esModule", { value: true });
  documentHighlights.register = void 0;
  const featureWorkers_1$d = featureWorkers;
  const dedupe$2 = dedupe$9;
  const common_1$d = common$1;
  const cancellation_1$i = cancellation;
  function register$H(context) {
    return (uri, position, token = cancellation_1$i.NoneCancellationToken) => {
      return (0, featureWorkers_1$d.languageFeatureWorker)(context, uri, position, (position2, map2) => map2.toGeneratedPositions(
        position2,
        // note https://github.com/johnsoncodehk/volar/issues/2009
        (data2) => typeof data2.rename === "object" ? !!data2.rename.normalize : !!data2.rename
      ), async (service, document2, position2) => {
        if (token.isCancellationRequested)
          return;
        const recursiveChecker = dedupe$2.createLocationSet();
        const result = [];
        await withMirrors(document2, position2);
        return result;
        async function withMirrors(document3, position3) {
          var _a2;
          if (!service.provideDocumentHighlights)
            return;
          if (recursiveChecker.has({ uri: document3.uri, range: { start: position3, end: position3 } }))
            return;
          recursiveChecker.add({ uri: document3.uri, range: { start: position3, end: position3 } });
          const references2 = await service.provideDocumentHighlights(document3, position3, token) ?? [];
          for (const reference of references2) {
            let foundMirrorPosition = false;
            recursiveChecker.add({ uri: document3.uri, range: { start: reference.range.start, end: reference.range.start } });
            const mirrorMap = (_a2 = context.documents.getMirrorMapByUri(document3.uri)) == null ? void 0 : _a2[1];
            if (mirrorMap) {
              for (const mapped of mirrorMap.findMirrorPositions(reference.range.start)) {
                if (!mapped[1].references)
                  continue;
                if (recursiveChecker.has({ uri: mirrorMap.document.uri, range: { start: mapped[0], end: mapped[0] } }))
                  continue;
                foundMirrorPosition = true;
                await withMirrors(mirrorMap.document, mapped[0]);
              }
            }
            if (!foundMirrorPosition) {
              result.push(reference);
            }
          }
        }
      }, (data2, map2) => data2.map((highlight) => {
        if (!map2)
          return highlight;
        const range2 = map2.toSourceRange(highlight.range);
        if (range2) {
          return {
            ...highlight,
            range: range2
          };
        }
      }).filter(common_1$d.notEmpty), (arr) => arr.flat());
    };
  }
  documentHighlights.register = register$H;
  var documentLinks = {};
  Object.defineProperty(documentLinks, "__esModule", { value: true });
  documentLinks.register = void 0;
  const featureWorkers_1$c = featureWorkers;
  const common_1$c = common$1;
  const cancellation_1$h = cancellation;
  function register$G(context) {
    return async (uri, token = cancellation_1$h.NoneCancellationToken) => {
      const pluginLinks = await (0, featureWorkers_1$c.documentFeatureWorker)(context, uri, (file) => !!file.capabilities.documentSymbol, async (service, document2) => {
        var _a2;
        if (token.isCancellationRequested)
          return;
        const links = await ((_a2 = service.provideDocumentLinks) == null ? void 0 : _a2.call(service, document2, token));
        links == null ? void 0 : links.forEach((link) => {
          link.data = {
            uri,
            original: {
              data: link.data
            },
            serviceId: Object.keys(context.services).find((key) => context.services[key] === service)
          };
        });
        return links;
      }, (links, map2) => links.map((link) => {
        if (!map2)
          return link;
        const range2 = map2.toSourceRange(link.range);
        if (range2) {
          return {
            ...link,
            range: range2
          };
        }
      }).filter(common_1$c.notEmpty), (arr) => arr.flat()) ?? [];
      const maps = context.documents.getMapsBySourceFileUri(uri);
      const fictitiousLinks = maps ? getFictitiousLinks(context.documents.getDocumentByUri(maps.snapshot, uri), maps.maps) : [];
      return [
        ...pluginLinks,
        ...fictitiousLinks
      ];
      function getFictitiousLinks(document2, maps2) {
        const result = [];
        for (const [_, map2] of maps2) {
          for (const mapped of map2.map.mappings) {
            if (!mapped.data.displayWithLink)
              continue;
            if (mapped.sourceRange[0] === mapped.sourceRange[1])
              continue;
            result.push({
              range: {
                start: document2.positionAt(mapped.sourceRange[0]),
                end: document2.positionAt(mapped.sourceRange[1])
              },
              target: uri
              // TODO
            });
          }
        }
        return result;
      }
    };
  }
  documentLinks.register = register$G;
  var documentLinkResolve$1 = {};
  Object.defineProperty(documentLinkResolve$1, "__esModule", { value: true });
  documentLinkResolve$1.register = void 0;
  const cancellation_1$g = cancellation;
  function register$F(context) {
    return async (item, token = cancellation_1$g.NoneCancellationToken) => {
      const data2 = item.data;
      if (data2) {
        const service = context.services[data2.serviceId];
        if (!service.resolveDocumentLink)
          return item;
        Object.assign(item, data2.original);
        item = await service.resolveDocumentLink(item, token);
      }
      return item;
    };
  }
  documentLinkResolve$1.register = register$F;
  var documentSemanticTokens = {};
  var SemanticTokensBuilder$1 = {};
  Object.defineProperty(SemanticTokensBuilder$1, "__esModule", { value: true });
  SemanticTokensBuilder$1.SemanticTokensBuilder = void 0;
  class SemanticTokensBuilder {
    constructor() {
      this.initialize();
    }
    initialize() {
      this._id = Date.now();
      this._prevLine = 0;
      this._prevChar = 0;
      this._data = [];
      this._dataLen = 0;
    }
    push(line, char, length, tokenType, tokenModifiers) {
      let pushLine = line;
      let pushChar = char;
      if (this._dataLen > 0) {
        pushLine -= this._prevLine;
        if (pushLine === 0) {
          pushChar -= this._prevChar;
        }
      }
      this._data[this._dataLen++] = pushLine;
      this._data[this._dataLen++] = pushChar;
      this._data[this._dataLen++] = length;
      this._data[this._dataLen++] = tokenType;
      this._data[this._dataLen++] = tokenModifiers;
      this._prevLine = line;
      this._prevChar = char;
    }
    get id() {
      return this._id.toString();
    }
    build() {
      return {
        resultId: this.id,
        data: this._data
      };
    }
  }
  SemanticTokensBuilder$1.SemanticTokensBuilder = SemanticTokensBuilder;
  Object.defineProperty(documentSemanticTokens, "__esModule", { value: true });
  documentSemanticTokens.register = void 0;
  const featureWorkers_1$b = featureWorkers;
  const SemanticTokensBuilder_1 = SemanticTokensBuilder$1;
  const common_1$b = common$1;
  const cancellation_1$f = cancellation;
  function register$E(context) {
    return async (uri, range2, legend, token = cancellation_1$f.NoneCancellationToken, reportProgress) => {
      const document2 = context.getTextDocument(uri);
      if (!document2)
        return;
      const offsetRange = range2 ? [
        document2.offsetAt(range2.start),
        document2.offsetAt(range2.end)
      ] : [
        0,
        document2.getText().length
      ];
      const tokens = await (0, featureWorkers_1$b.languageFeatureWorker)(context, uri, offsetRange, function* (offsetRange2, map2) {
        let range3;
        for (const mapping of map2.map.mappings) {
          if (mapping.data.semanticTokens && mapping.sourceRange[1] > offsetRange2[0] && mapping.sourceRange[0] < offsetRange2[1]) {
            if (!range3) {
              range3 = [...mapping.generatedRange];
            } else {
              range3[0] = Math.min(range3[0], mapping.generatedRange[0]);
              range3[1] = Math.max(range3[1], mapping.generatedRange[1]);
            }
          }
        }
        if (range3) {
          yield range3;
        }
      }, (service, document3, offsetRange2) => {
        var _a2;
        if (token == null ? void 0 : token.isCancellationRequested)
          return;
        return (_a2 = service.provideDocumentSemanticTokens) == null ? void 0 : _a2.call(service, document3, {
          start: document3.positionAt(offsetRange2[0]),
          end: document3.positionAt(offsetRange2[1])
        }, legend, token);
      }, (tokens2, map2) => tokens2.map((_token) => {
        if (!map2)
          return _token;
        const range3 = map2.toSourceRange({
          start: { line: _token[0], character: _token[1] },
          end: { line: _token[0], character: _token[1] + _token[2] }
        }, (data2) => !!data2.semanticTokens);
        if (range3) {
          return [range3.start.line, range3.start.character, range3.end.character - range3.start.character, _token[3], _token[4]];
        }
      }).filter(common_1$b.notEmpty), (tokens2) => tokens2.flat(), (tokens2) => reportProgress == null ? void 0 : reportProgress(buildTokens(tokens2)));
      if (tokens) {
        return buildTokens(tokens);
      }
    };
  }
  documentSemanticTokens.register = register$E;
  function buildTokens(tokens) {
    const builder = new SemanticTokensBuilder_1.SemanticTokensBuilder();
    const sortedTokens = tokens.sort((a2, b) => a2[0] - b[0] === 0 ? a2[1] - b[1] : a2[0] - b[0]);
    for (const token of sortedTokens) {
      builder.push(...token);
    }
    return builder.build();
  }
  var fileReferences$2 = {};
  Object.defineProperty(fileReferences$2, "__esModule", { value: true });
  fileReferences$2.register = void 0;
  const featureWorkers_1$a = featureWorkers;
  const dedupe$1 = dedupe$9;
  const common_1$a = common$1;
  const cancellation_1$e = cancellation;
  function register$D(context) {
    return (uri, token = cancellation_1$e.NoneCancellationToken) => {
      return (0, featureWorkers_1$a.languageFeatureWorker)(context, uri, void 0, function* (_) {
        yield _;
      }, async (service, document2) => {
        var _a2;
        if (token.isCancellationRequested)
          return;
        return await ((_a2 = service.provideFileReferences) == null ? void 0 : _a2.call(service, document2, token)) ?? [];
      }, (data2) => data2.map((reference) => {
        if (!context.documents.isVirtualFileUri(reference.uri)) {
          return reference;
        }
        for (const [_, map2] of context.documents.getMapsByVirtualFileUri(reference.uri)) {
          const range2 = map2.toSourceRange(reference.range);
          if (range2) {
            reference.uri = map2.sourceFileDocument.uri;
            reference.range = range2;
            return reference;
          }
        }
      }).filter(common_1$a.notEmpty), (arr) => dedupe$1.withLocations(arr.flat()));
    };
  }
  fileReferences$2.register = register$D;
  var fileRename$2 = {};
  Object.defineProperty(fileRename$2, "__esModule", { value: true });
  fileRename$2.register = void 0;
  const rename_1$3 = rename$2;
  const dedupe = dedupe$9;
  const language_core_1$f = out$b;
  const cancellation_1$d = cancellation;
  function register$C(context) {
    return async (oldUri, newUri, token = cancellation_1$d.NoneCancellationToken) => {
      var _a2;
      const rootFile = (_a2 = context.documents.getSourceByUri(oldUri)) == null ? void 0 : _a2.root;
      if (rootFile) {
        let tsExt;
        (0, language_core_1$f.forEachEmbeddedFile)(rootFile, (embedded2) => {
          if (embedded2.kind === language_core_1$f.FileKind.TypeScriptHostFile && embedded2.fileName.replace(rootFile.fileName, "").match(/^\.(js|ts)x?$/)) {
            tsExt = embedded2.fileName.substring(embedded2.fileName.lastIndexOf("."));
          }
        });
        if (!tsExt) {
          return;
        }
        oldUri += tsExt;
        newUri += tsExt;
      }
      for (const service of Object.values(context.services)) {
        if (token.isCancellationRequested)
          break;
        if (!service.provideFileRenameEdits)
          continue;
        const workspaceEdit = await service.provideFileRenameEdits(oldUri, newUri, token);
        if (workspaceEdit) {
          const result = (0, rename_1$3.embeddedEditToSourceEdit)(workspaceEdit, context.documents, "fileName");
          if (result == null ? void 0 : result.documentChanges) {
            result.documentChanges = dedupe.withDocumentChanges(result.documentChanges);
          }
          return result;
        }
      }
    };
  }
  fileRename$2.register = register$C;
  var hover$2 = {};
  var validation = {};
  (function(exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.register = exports.errorMarkups = exports.updateRange = void 0;
    const types_12 = types$3;
    const common_12 = common$1;
    const dedupe2 = dedupe$9;
    const featureWorkers_12 = featureWorkers;
    const cancellation_12 = cancellation;
    function updateRange(range2, change) {
      if (!updatePosition(range2.start, change, false)) {
        return;
      }
      if (!updatePosition(range2.end, change, true)) {
        return;
      }
      if (range2.end.line === range2.start.line && range2.end.character <= range2.start.character) {
        range2.end.character++;
      }
      return range2;
    }
    exports.updateRange = updateRange;
    function updatePosition(position, change, isEnd2) {
      if (change.range.end.line > position.line) {
        if (change.newEnd.line > position.line) {
          return true;
        } else if (change.newEnd.line === position.line) {
          position.character = Math.min(position.character, change.newEnd.character);
          return true;
        } else if (change.newEnd.line < position.line) {
          position.line = change.newEnd.line;
          position.character = change.newEnd.character;
          return true;
        }
      } else if (change.range.end.line === position.line) {
        const characterDiff = change.newEnd.character - change.range.end.character;
        if (position.character >= change.range.end.character) {
          if (change.newEnd.line !== change.range.end.line) {
            position.line = change.newEnd.line;
            position.character = change.newEnd.character + position.character - change.range.end.character;
          } else {
            if (isEnd2 ? change.range.end.character < position.character : change.range.end.character <= position.character) {
              position.character += characterDiff;
            } else {
              const offset = change.range.end.character - position.character;
              if (-characterDiff > offset) {
                position.character += characterDiff + offset;
              }
            }
          }
          return true;
        } else {
          if (change.newEnd.line === change.range.end.line) {
            const offset = change.range.end.character - position.character;
            if (-characterDiff > offset) {
              position.character += characterDiff + offset;
            }
          } else if (change.newEnd.line < change.range.end.line) {
            position.line = change.newEnd.line;
            position.character = change.newEnd.character;
          } else
            ;
          return true;
        }
      } else if (change.range.end.line < position.line) {
        position.line += change.newEnd.line - change.range.end.line;
        return true;
      }
      return false;
    }
    exports.errorMarkups = {};
    function register2(context) {
      const lastResponses = /* @__PURE__ */ new Map();
      const cacheMaps = {
        semantic: /* @__PURE__ */ new Map(),
        syntactic: /* @__PURE__ */ new Map(),
        semantic_rules: /* @__PURE__ */ new Map(),
        syntax_rules: /* @__PURE__ */ new Map(),
        format_rules: /* @__PURE__ */ new Map()
      };
      return async (uri, mode, token = cancellation_12.NoneCancellationToken, response) => {
        const newDocument = context.getTextDocument(uri);
        if (!newDocument) {
          return [];
        }
        const lastResponse = lastResponses.get(uri) ?? lastResponses.set(uri, {
          semantic: { errors: [] },
          syntactic: { errors: [] },
          semantic_rules: { errors: [] },
          syntax_rules: { errors: [] },
          format_rules: { errors: [] }
        }).get(uri);
        const newSnapshot = context.host.getScriptSnapshot(context.env.uriToFileName(uri));
        let updateCacheRangeFailed = false;
        let errorsUpdated = false;
        let lastCheckCancelAt = 0;
        for (const cache of Object.values(lastResponse)) {
          const oldSnapshot = cache.snapshot;
          const oldDocument = cache.document;
          const change = oldSnapshot ? newSnapshot == null ? void 0 : newSnapshot.getChangeRange(oldSnapshot) : void 0;
          cache.snapshot = newSnapshot;
          cache.document = newDocument;
          if (!updateCacheRangeFailed && newDocument && oldSnapshot && oldDocument && newSnapshot && change) {
            const changeRange = {
              range: {
                start: oldDocument.positionAt(change.span.start),
                end: oldDocument.positionAt(change.span.start + change.span.length)
              },
              newEnd: newDocument.positionAt(change.span.start + change.newLength)
            };
            for (const error of cache.errors) {
              if (!updateRange(error.range, changeRange)) {
                updateCacheRangeFailed = true;
                break;
              }
            }
          }
        }
        if (mode === "all" || mode === "syntactic") {
          await lintWorker(types_12.RuleType.Format, cacheMaps.format_rules, lastResponse.format_rules);
          await doResponse();
          await lintWorker(types_12.RuleType.Syntax, cacheMaps.syntax_rules, lastResponse.syntax_rules);
          await doResponse();
          await worker2("provideDiagnostics", cacheMaps.syntactic, lastResponse.syntactic);
          await doResponse();
        }
        if (mode === "all" || mode === "semantic") {
          await lintWorker(types_12.RuleType.Semantic, cacheMaps.semantic_rules, lastResponse.semantic_rules);
          await doResponse();
          await worker2("provideSemanticDiagnostics", cacheMaps.semantic, lastResponse.semantic);
        }
        return await collectErrors();
        async function doResponse() {
          if (errorsUpdated && !updateCacheRangeFailed) {
            response == null ? void 0 : response(await collectErrors());
            errorsUpdated = false;
          }
        }
        async function collectErrors() {
          var _a2;
          const errors = Object.values(lastResponse).flatMap(({ errors: errors2 }) => errors2);
          exports.errorMarkups[uri] = [];
          for (const error of errors) {
            for (const service of Object.values(context.services)) {
              const markup = await ((_a2 = service.provideDiagnosticMarkupContent) == null ? void 0 : _a2.call(service, error, token));
              if (markup) {
                exports.errorMarkups[uri].push({ error, markup });
              }
            }
          }
          return errors;
        }
        async function lintWorker(ruleType, cacheMap, cache) {
          const result = await (0, featureWorkers_12.ruleWorker)(context, ruleType, uri, (file) => ruleType === types_12.RuleType.Format ? !!file.capabilities.documentFormatting : !!file.capabilities.diagnostic, async (ruleId, rule, lintDocument, ruleCtx) => {
            var _a2, _b, _c, _d, _e;
            if (token) {
              if (Date.now() - lastCheckCancelAt >= 5) {
                await (0, common_12.sleep)(5);
                lastCheckCancelAt = Date.now();
              }
              if (token.isCancellationRequested) {
                return;
              }
            }
            const pluginCache = cacheMap.get(ruleId) ?? cacheMap.set(ruleId, /* @__PURE__ */ new Map()).get(ruleId);
            const cache2 = pluginCache.get(lintDocument.uri);
            const projectVersion = ruleType === types_12.RuleType.Semantic ? (_b = (_a2 = context.host).getProjectVersion) == null ? void 0 : _b.call(_a2) : void 0;
            if (ruleType === types_12.RuleType.Semantic) {
              if (cache2 && cache2.documentVersion === lintDocument.version && cache2.projectVersion === projectVersion) {
                return cache2.errors;
              }
            } else {
              if (cache2 && cache2.documentVersion === lintDocument.version) {
                return cache2.errors;
              }
            }
            const reportResults = [];
            ruleCtx.report = (error, ...fixes) => {
              error.message || (error.message = "No message.");
              error.source || (error.source = "rule");
              error.code || (error.code = ruleId);
              reportResults.push([error, ...fixes]);
            };
            try {
              await rule.run(lintDocument, ruleCtx);
            } catch (err) {
              console.warn(`[volar/rules-api] ${ruleId} ${ruleType} error.`);
              console.warn(err);
            }
            context.ruleFixes ?? (context.ruleFixes = {});
            (_c = context.ruleFixes)[_d = lintDocument.uri] ?? (_c[_d] = {});
            (_e = context.ruleFixes[lintDocument.uri])[ruleId] ?? (_e[ruleId] = {});
            reportResults == null ? void 0 : reportResults.forEach(([error, ...fixes], index2) => {
              context.ruleFixes[lintDocument.uri][ruleId][index2] = [error, fixes];
              error.data = {
                uri,
                version: newDocument.version,
                type: "rule",
                isFormat: ruleType === types_12.RuleType.Format,
                serviceOrRuleId: ruleId,
                original: {
                  data: error.data
                },
                ruleFixIndex: index2,
                documentUri: lintDocument.uri
              };
            });
            errorsUpdated = true;
            const errors = reportResults.map((reportResult) => reportResult[0]);
            pluginCache.set(lintDocument.uri, {
              documentVersion: lintDocument.version,
              errors,
              projectVersion
            });
            return errors;
          }, ruleType === types_12.RuleType.Format ? transformFormatErrorRange : transformErrorRange, (arr) => arr.flat());
          if (result) {
            cache.errors = result;
            cache.snapshot = newSnapshot;
          }
        }
        async function worker2(api, cacheMap, cache) {
          const result = await (0, featureWorkers_12.languageFeatureWorker)(context, uri, true, function* (arg, _, file) {
            if (file.capabilities.diagnostic) {
              yield arg;
            }
          }, async (service, document2) => {
            var _a2, _b, _c;
            if (token) {
              if (Date.now() - lastCheckCancelAt >= 5) {
                await (0, common_12.sleep)(5);
                lastCheckCancelAt = Date.now();
              }
              if (token.isCancellationRequested) {
                return;
              }
            }
            const serviceId = Object.keys(context.services).find((key) => context.services[key] === service);
            const serviceCache = cacheMap.get(serviceId) ?? cacheMap.set(serviceId, /* @__PURE__ */ new Map()).get(serviceId);
            const cache2 = serviceCache.get(document2.uri);
            const projectVersion = api === "provideSemanticDiagnostics" ? (_b = (_a2 = context.host).getProjectVersion) == null ? void 0 : _b.call(_a2) : void 0;
            if (api === "provideSemanticDiagnostics") {
              if (cache2 && cache2.documentVersion === document2.version && cache2.projectVersion === projectVersion) {
                return cache2.errors;
              }
            } else {
              if (cache2 && cache2.documentVersion === document2.version) {
                return cache2.errors;
              }
            }
            const errors = await ((_c = service[api]) == null ? void 0 : _c.call(service, document2, token));
            errors == null ? void 0 : errors.forEach((error) => {
              error.data = {
                uri,
                version: newDocument.version,
                type: "service",
                serviceOrRuleId: serviceId,
                isFormat: false,
                original: {
                  data: error.data
                },
                ruleFixIndex: 0,
                documentUri: document2.uri
              };
            });
            errorsUpdated = true;
            serviceCache.set(document2.uri, {
              documentVersion: document2.version,
              errors,
              projectVersion
            });
            return errors;
          }, transformErrorRange, (arr) => dedupe2.withDiagnostics(arr.flat()));
          if (result) {
            cache.errors = result;
            cache.snapshot = newSnapshot;
          }
        }
      };
      function transformFormatErrorRange(errors, map2) {
        return transformErrorRangeBase(errors, map2, () => true);
      }
      function transformErrorRange(errors, map2) {
        return transformErrorRangeBase(errors, map2, (data2) => typeof data2.diagnostic === "object" ? data2.diagnostic.shouldReport() : !!data2.diagnostic);
      }
      function transformErrorRangeBase(errors, map2, filter) {
        const result = [];
        for (const error of errors) {
          let _error = { ...error };
          if (map2) {
            const range2 = map2.toSourceRange(error.range, filter);
            if (!range2) {
              continue;
            }
            _error.range = range2;
          }
          if (_error.relatedInformation) {
            const relatedInfos = [];
            for (const info of _error.relatedInformation) {
              if (context.documents.isVirtualFileUri(info.location.uri)) {
                for (const [_, map3] of context.documents.getMapsByVirtualFileUri(info.location.uri)) {
                  const range2 = map3.toSourceRange(info.location.range, filter);
                  if (range2) {
                    relatedInfos.push({
                      location: {
                        uri: map3.sourceFileDocument.uri,
                        range: range2
                      },
                      message: info.message
                    });
                  }
                }
              } else {
                relatedInfos.push(info);
              }
            }
            _error.relatedInformation = relatedInfos;
          }
          result.push(_error);
        }
        return result;
      }
    }
    exports.register = register2;
  })(validation);
  Object.defineProperty(hover$2, "__esModule", { value: true });
  hover$2.register = void 0;
  const featureWorkers_1$9 = featureWorkers;
  const common_1$9 = common$1;
  const validation_1 = validation;
  const cancellation_1$c = cancellation;
  function register$B(context) {
    return async (uri, position, token = cancellation_1$c.NoneCancellationToken) => {
      let hover2 = await (0, featureWorkers_1$9.languageFeatureWorker)(context, uri, position, (position2, map2) => map2.toGeneratedPositions(position2, (data2) => !!data2.hover), (service, document2, position2) => {
        var _a2;
        if (token.isCancellationRequested)
          return;
        return (_a2 = service.provideHover) == null ? void 0 : _a2.call(service, document2, position2, token);
      }, (item, map2) => {
        if (!map2 || !item.range)
          return item;
        const range2 = map2.toSourceRange(item.range);
        if (range2) {
          item.range = range2;
          return item;
        }
      }, (hovers) => {
        var _a2;
        return {
          contents: {
            kind: "markdown",
            value: hovers.map(getHoverTexts).flat().join("\n\n---\n\n")
          },
          range: ((_a2 = hovers.find((hover3) => hover3.range && (0, common_1$9.isInsideRange)(hover3.range, { start: position, end: position }))) == null ? void 0 : _a2.range) ?? hovers[0].range
        };
      });
      const markups = validation_1.errorMarkups[uri];
      if (markups) {
        for (const errorAndMarkup of markups) {
          if ((0, common_1$9.isInsideRange)(errorAndMarkup.error.range, { start: position, end: position })) {
            hover2 ?? (hover2 = {
              contents: {
                kind: "markdown",
                value: ""
              }
            });
            hover2.range = errorAndMarkup.error.range;
            if (typeof hover2.contents !== "object" || typeof hover2.contents !== "string") {
              hover2.contents = {
                kind: "markdown",
                value: hover2.contents
              };
            }
            if (hover2.contents.value) {
              hover2.contents.value += "\n\n---\n\n";
            }
            hover2.contents.value += errorAndMarkup.markup.value;
          }
        }
      }
      return hover2;
    };
  }
  hover$2.register = register$B;
  function getHoverTexts(hover2) {
    if (typeof hover2.contents === "string") {
      return [hover2.contents];
    }
    if (Array.isArray(hover2.contents)) {
      return hover2.contents.map((content) => {
        if (typeof content === "string") {
          return content;
        }
        return `\`\`\`${content.language}
${content.value}
\`\`\``;
      });
    }
    if ("kind" in hover2.contents) {
      return [hover2.contents.value];
    }
    return [`\`\`\`${hover2.contents.language}
${hover2.contents.value}
\`\`\``];
  }
  var inlayHints$2 = {};
  Object.defineProperty(inlayHints$2, "__esModule", { value: true });
  inlayHints$2.register = void 0;
  const transformer$4 = transformer$8;
  const common_1$8 = common$1;
  const featureWorkers_1$8 = featureWorkers;
  const cancellation_1$b = cancellation;
  function register$A(context) {
    return async (uri, range2, token = cancellation_1$b.NoneCancellationToken) => {
      const document2 = context.getTextDocument(uri);
      if (!document2)
        return;
      const offsetRange = {
        start: document2.offsetAt(range2.start),
        end: document2.offsetAt(range2.end)
      };
      return (0, featureWorkers_1$8.languageFeatureWorker)(context, uri, range2, (_arg, map2, file) => {
        var _a2, _b;
        if (!file.capabilities.inlayHint)
          return [];
        let minStart;
        let maxEnd;
        for (const mapping of map2.map.mappings) {
          const overlapRange = (0, common_1$8.getOverlapRange)(offsetRange.start, offsetRange.end, mapping.sourceRange[0], mapping.sourceRange[1]);
          if (overlapRange) {
            const start = (_a2 = map2.map.toGeneratedOffset(overlapRange.start)) == null ? void 0 : _a2[0];
            const end = (_b = map2.map.toGeneratedOffset(overlapRange.end)) == null ? void 0 : _b[0];
            if (start !== void 0 && end !== void 0) {
              minStart = minStart === void 0 ? start : Math.min(start, minStart);
              maxEnd = maxEnd === void 0 ? end : Math.max(end, maxEnd);
            }
          }
        }
        if (minStart !== void 0 && maxEnd !== void 0) {
          return [{
            start: map2.virtualFileDocument.positionAt(minStart),
            end: map2.virtualFileDocument.positionAt(maxEnd)
          }];
        }
        return [];
      }, async (service, document3, arg) => {
        var _a2;
        if (token.isCancellationRequested)
          return;
        const hints = await ((_a2 = service.provideInlayHints) == null ? void 0 : _a2.call(service, document3, arg, token));
        hints == null ? void 0 : hints.forEach((link) => {
          link.data = {
            uri,
            original: {
              data: link.data
            },
            serviceId: Object.keys(context.services).find((key) => context.services[key] === service)
          };
        });
        return hints;
      }, (inlayHints2, map2) => inlayHints2.map((_inlayHint) => {
        var _a2;
        if (!map2)
          return _inlayHint;
        const position = map2.toSourcePosition(
          _inlayHint.position,
          (data2) => !!data2.semanticTokens
          /* todo */
        );
        const edits = (_a2 = _inlayHint.textEdits) == null ? void 0 : _a2.map((textEdit2) => transformer$4.asTextEdit(textEdit2, (range3) => map2.toSourceRange(range3), map2.virtualFileDocument)).filter(common_1$8.notEmpty);
        if (position) {
          return {
            ..._inlayHint,
            position,
            textEdits: edits
          };
        }
      }).filter(common_1$8.notEmpty), (arr) => arr.flat());
    };
  }
  inlayHints$2.register = register$A;
  var inlayHintResolve$1 = {};
  Object.defineProperty(inlayHintResolve$1, "__esModule", { value: true });
  inlayHintResolve$1.register = void 0;
  const cancellation_1$a = cancellation;
  function register$z(context) {
    return async (item, token = cancellation_1$a.NoneCancellationToken) => {
      const data2 = item.data;
      if (data2) {
        const service = context.services[data2.serviceId];
        if (!service.resolveInlayHint)
          return item;
        Object.assign(item, data2.original);
        item = await service.resolveInlayHint(item, token);
      }
      return item;
    };
  }
  inlayHintResolve$1.register = register$z;
  var renamePrepare$1 = {};
  Object.defineProperty(renamePrepare$1, "__esModule", { value: true });
  renamePrepare$1.register = void 0;
  const featureWorkers_1$7 = featureWorkers;
  const cancellation_1$9 = cancellation;
  function register$y(context) {
    return (uri, position, token = cancellation_1$9.NoneCancellationToken) => {
      return (0, featureWorkers_1$7.languageFeatureWorker)(context, uri, position, (position2, map2) => map2.toGeneratedPositions(position2, (data2) => typeof data2.rename === "object" ? !!data2.rename.normalize : !!data2.rename), (service, document2, position2) => {
        var _a2;
        if (token.isCancellationRequested)
          return;
        return (_a2 = service.provideRenameRange) == null ? void 0 : _a2.call(service, document2, position2, token);
      }, (item, map2) => {
        if (!map2) {
          return item;
        }
        if ("start" in item && "end" in item) {
          return map2.toSourceRange(item);
        }
        return item;
      }, (prepares) => {
        for (const prepare of prepares) {
          if ("start" in prepare && "end" in prepare) {
            return prepare;
          }
        }
        return prepares[0];
      });
    };
  }
  renamePrepare$1.register = register$y;
  var signatureHelp$2 = {};
  Object.defineProperty(signatureHelp$2, "__esModule", { value: true });
  signatureHelp$2.register = void 0;
  const featureWorkers_1$6 = featureWorkers;
  const cancellation_1$8 = cancellation;
  function register$x(context) {
    return (uri, position, signatureHelpContext = {
      triggerKind: 1,
      isRetrigger: false
    }, token = cancellation_1$8.NoneCancellationToken) => {
      return (0, featureWorkers_1$6.languageFeatureWorker)(context, uri, position, (position2, map2) => map2.toGeneratedPositions(position2, (data2) => !!data2.completion), (service, document2, position2) => {
        var _a2, _b;
        if (token.isCancellationRequested)
          return;
        if ((signatureHelpContext == null ? void 0 : signatureHelpContext.triggerKind) === 2 && signatureHelpContext.triggerCharacter && !((_a2 = signatureHelpContext.isRetrigger ? service.signatureHelpRetriggerCharacters : service.signatureHelpTriggerCharacters) == null ? void 0 : _a2.includes(signatureHelpContext.triggerCharacter))) {
          return;
        }
        return (_b = service.provideSignatureHelp) == null ? void 0 : _b.call(service, document2, position2, signatureHelpContext, token);
      }, (data2) => data2);
    };
  }
  signatureHelp$2.register = register$x;
  var workspaceSymbols = {};
  Object.defineProperty(workspaceSymbols, "__esModule", { value: true });
  workspaceSymbols.register = void 0;
  const transformer$3 = transformer$8;
  const common_1$7 = common$1;
  const cancellation_1$7 = cancellation;
  function register$w(context) {
    return async (query, token = cancellation_1$7.NoneCancellationToken) => {
      const symbolsList = [];
      for (const service of Object.values(context.services)) {
        if (token.isCancellationRequested)
          break;
        if (!service.provideWorkspaceSymbols)
          continue;
        const embeddedSymbols = await service.provideWorkspaceSymbols(query, token);
        if (!embeddedSymbols)
          continue;
        const symbols = embeddedSymbols.map((symbol) => transformer$3.asWorkspaceSymbol(symbol, (loc) => {
          if (context.documents.isVirtualFileUri(loc.uri)) {
            for (const [_, map2] of context.documents.getMapsByVirtualFileUri(loc.uri)) {
              const range2 = map2.toSourceRange(loc.range);
              if (range2) {
                return { uri: map2.sourceFileDocument.uri, range: range2 };
              }
            }
          } else {
            return loc;
          }
        })).filter(common_1$7.notEmpty);
        symbolsList.push(symbols);
      }
      return symbolsList.flat();
    };
  }
  workspaceSymbols.register = register$w;
  var colorPresentations$1 = {};
  Object.defineProperty(colorPresentations$1, "__esModule", { value: true });
  colorPresentations$1.register = void 0;
  const featureWorkers_1$5 = featureWorkers;
  const common_1$6 = common$1;
  const cancellation_1$6 = cancellation;
  function register$v(context) {
    return (uri, color, range2, token = cancellation_1$6.NoneCancellationToken) => {
      return (0, featureWorkers_1$5.languageFeatureWorker)(context, uri, range2, (range3, map2, file) => {
        if (file.capabilities.documentSymbol)
          return map2.toGeneratedRanges(range3);
        return [];
      }, (service, document2, range3) => {
        var _a2;
        if (token.isCancellationRequested)
          return;
        return (_a2 = service.provideColorPresentations) == null ? void 0 : _a2.call(service, document2, color, range3, token);
      }, (data2, map2) => map2 ? data2.map((cp) => {
        if (cp.textEdit) {
          const range3 = map2.toSourceRange(cp.textEdit.range);
          if (!range3)
            return void 0;
          cp.textEdit.range = range3;
        }
        if (cp.additionalTextEdits) {
          for (const textEdit2 of cp.additionalTextEdits) {
            const range3 = map2.toSourceRange(textEdit2.range);
            if (!range3)
              return void 0;
            textEdit2.range = range3;
          }
        }
        return cp;
      }).filter(common_1$6.notEmpty) : data2);
    };
  }
  colorPresentations$1.register = register$v;
  var documentColors$1 = {};
  Object.defineProperty(documentColors$1, "__esModule", { value: true });
  documentColors$1.register = void 0;
  const featureWorkers_1$4 = featureWorkers;
  const common_1$5 = common$1;
  const cancellation_1$5 = cancellation;
  function register$u(context) {
    return (uri, token = cancellation_1$5.NoneCancellationToken) => {
      return (0, featureWorkers_1$4.documentFeatureWorker)(
        context,
        uri,
        (file) => !!file.capabilities.documentSymbol,
        // TODO: add color capability setting
        (service, document2) => {
          var _a2;
          if (token.isCancellationRequested)
            return;
          return (_a2 = service.provideDocumentColors) == null ? void 0 : _a2.call(service, document2, token);
        },
        (data2, map2) => map2 ? data2.map((color) => {
          const range2 = map2.toSourceRange(color.range);
          if (range2) {
            return {
              range: range2,
              color: color.color
            };
          }
        }).filter(common_1$5.notEmpty) : data2,
        (arr) => arr.flat()
      );
    };
  }
  documentColors$1.register = register$u;
  var documentSymbols$1 = {};
  Object.defineProperty(documentSymbols$1, "__esModule", { value: true });
  documentSymbols$1.register = void 0;
  const featureWorkers_1$3 = featureWorkers;
  const transformer$2 = transformer$8;
  const common_1$4 = common$1;
  const cancellation_1$4 = cancellation;
  function register$t(context) {
    return (uri, token = cancellation_1$4.NoneCancellationToken) => {
      return (0, featureWorkers_1$3.documentFeatureWorker)(context, uri, (file) => !!file.capabilities.documentSymbol, async (service, document2) => {
        var _a2;
        if (token.isCancellationRequested)
          return;
        return (_a2 = service.provideDocumentSymbols) == null ? void 0 : _a2.call(service, document2, token);
      }, (data2, map2) => map2 ? data2.map((symbol) => transformer$2.asDocumentSymbol(symbol, (range2) => map2.toSourceRange(range2))).filter(common_1$4.notEmpty) : data2, (results) => {
        for (let i = 0; i < results.length; i++) {
          for (let j = 0; j < results.length; j++) {
            if (i === j)
              continue;
            results[i] = results[i].filter((child) => {
              for (const parent of results[j]) {
                if ((0, common_1$4.isInsideRange)(parent.range, child.range)) {
                  parent.children ?? (parent.children = []);
                  parent.children.push(child);
                  return false;
                }
              }
              return true;
            });
          }
        }
        return results.flat();
      });
    };
  }
  documentSymbols$1.register = register$t;
  var foldingRanges$2 = {};
  Object.defineProperty(foldingRanges$2, "__esModule", { value: true });
  foldingRanges$2.register = void 0;
  const featureWorkers_1$2 = featureWorkers;
  const transformer$1 = transformer$8;
  const cancellation_1$3 = cancellation;
  function register$s(context) {
    return (uri, token = cancellation_1$3.NoneCancellationToken) => {
      return (0, featureWorkers_1$2.documentFeatureWorker)(context, uri, (file) => !!file.capabilities.foldingRange, (service, document2) => {
        var _a2;
        if (token.isCancellationRequested)
          return;
        return (_a2 = service.provideFoldingRanges) == null ? void 0 : _a2.call(service, document2, token);
      }, (data2, map2) => map2 ? transformer$1.asFoldingRanges(data2, (range2) => map2.toSourceRange(range2)) : data2, (arr) => arr.flat());
    };
  }
  foldingRanges$2.register = register$s;
  var format$8 = {};
  Object.defineProperty(format$8, "__esModule", { value: true });
  format$8.register = void 0;
  const language_core_1$e = out$b;
  const vscode_languageserver_textdocument_1$1 = require$$2$3;
  const common_1$3 = common$1;
  const cancellation_1$2 = cancellation;
  const documents_1$1 = documents;
  function register$r(context) {
    let fakeVersion = 0;
    return async (uri, options, range2, onTypeParams, token = cancellation_1$2.NoneCancellationToken) => {
      var _a2, _b, _c, _d, _e;
      let document2 = context.getTextDocument(uri);
      if (!document2)
        return;
      range2 ?? (range2 = {
        start: document2.positionAt(0),
        end: document2.positionAt(document2.getText().length)
      });
      const source = context.documents.getSourceByUri(document2.uri);
      if (!source) {
        return onTypeParams ? (_a2 = await tryFormat(document2, onTypeParams.position, onTypeParams.ch)) == null ? void 0 : _a2.edits : (_b = await tryFormat(document2, range2, void 0)) == null ? void 0 : _b.edits;
      }
      const initialIndentLanguageId = await ((_d = (_c = context.env).getConfiguration) == null ? void 0 : _d.call(_c, "volar.format.initialIndent")) ?? { html: true };
      let tempSourceSnapshot = source.snapshot;
      const tempVirtualFile = source.language.createVirtualFile(source.fileName, source.snapshot, source.languageId);
      const originalDocument = document2;
      let level = 0;
      while (true) {
        const embeddedFiles = getEmbeddedFilesByLevel(tempVirtualFile, level++);
        if (embeddedFiles.length === 0)
          break;
        let edits = [];
        const toPatchIndent = [];
        for (const file of embeddedFiles) {
          if (!file.capabilities.documentFormatting)
            continue;
          const isCodeBlock = file.mappings.length === 1 && file.mappings[0].generatedRange[0] === 0 && file.mappings[0].generatedRange[1] === file.snapshot.getLength();
          if (onTypeParams && !isCodeBlock)
            continue;
          const docMap = createDocMap(file, source.fileName, tempSourceSnapshot);
          if (!docMap)
            continue;
          let embeddedCodeResult;
          if (onTypeParams) {
            const embeddedPosition = docMap.toGeneratedPosition(onTypeParams.position);
            if (embeddedPosition) {
              embeddedCodeResult = await tryFormat(docMap.virtualFileDocument, embeddedPosition, onTypeParams.ch);
            }
          } else {
            embeddedCodeResult = await tryFormat(docMap.virtualFileDocument, {
              start: docMap.virtualFileDocument.positionAt(0),
              end: docMap.virtualFileDocument.positionAt(docMap.virtualFileDocument.getText().length)
            });
          }
          if (!embeddedCodeResult)
            continue;
          toPatchIndent.push({
            virtualFileName: file.fileName,
            isCodeBlock,
            service: embeddedCodeResult.service
          });
          for (const textEdit3 of embeddedCodeResult.edits) {
            const range3 = docMap.toSourceRange(textEdit3.range);
            if (range3) {
              edits.push({
                newText: textEdit3.newText,
                range: range3
              });
            }
          }
        }
        edits = edits.filter((edit) => (0, common_1$3.isInsideRange)(range2, edit.range));
        if (edits.length > 0) {
          const newText = vscode_languageserver_textdocument_1$1.TextDocument.applyEdits(document2, edits);
          document2 = vscode_languageserver_textdocument_1$1.TextDocument.create(document2.uri, document2.languageId, document2.version + 1, newText);
          tempSourceSnapshot = (0, common_1$3.stringToSnapshot)(newText);
          source.language.updateVirtualFile(tempVirtualFile, tempSourceSnapshot);
        }
        if (level > 1) {
          const baseIndent = options.insertSpaces ? " ".repeat(options.tabSize) : "	";
          const editLines = /* @__PURE__ */ new Set();
          if (onTypeParams) {
            for (const edit of edits) {
              for (let line = edit.range.start.line; line <= edit.range.end.line; line++) {
                editLines.add(line);
              }
            }
          }
          for (const item of toPatchIndent) {
            let virtualFile;
            (0, language_core_1$e.forEachEmbeddedFile)(tempVirtualFile, (file) => {
              if (file.fileName === item.virtualFileName) {
                virtualFile = file;
              }
            });
            const docMap = createDocMap(virtualFile, source.fileName, tempSourceSnapshot);
            if (!docMap)
              continue;
            const indentSensitiveLines = /* @__PURE__ */ new Set();
            for (const service of item.service.provideFormattingIndentSensitiveLines ? [item.service] : Object.values(context.services)) {
              if (token.isCancellationRequested)
                break;
              if (service.provideFormattingIndentSensitiveLines) {
                const lines = await service.provideFormattingIndentSensitiveLines(docMap.virtualFileDocument, token);
                if (lines) {
                  for (const line of lines) {
                    const sourceLine = (_e = docMap.toSourcePosition({ line, character: 0 })) == null ? void 0 : _e.line;
                    if (sourceLine !== void 0) {
                      indentSensitiveLines.add(sourceLine);
                    }
                  }
                }
              }
            }
            let indentEdits = patchIndents(document2, item.isCodeBlock, docMap.map, initialIndentLanguageId[docMap.virtualFileDocument.languageId] ? baseIndent : "");
            indentEdits = indentEdits.filter((edit) => {
              for (let line = edit.range.start.line; line <= edit.range.end.line; line++) {
                if (indentSensitiveLines.has(line) && !edit.newText.includes("\n")) {
                  return false;
                }
                if (onTypeParams && !editLines.has(line)) {
                  return false;
                }
                if (!(0, common_1$3.isInsideRange)(range2, edit.range)) {
                  return false;
                }
              }
              return true;
            });
            if (indentEdits.length > 0) {
              const newText = vscode_languageserver_textdocument_1$1.TextDocument.applyEdits(document2, indentEdits);
              document2 = vscode_languageserver_textdocument_1$1.TextDocument.create(document2.uri, document2.languageId, document2.version + 1, newText);
              tempSourceSnapshot = (0, common_1$3.stringToSnapshot)(newText);
              source.language.updateVirtualFile(tempVirtualFile, tempSourceSnapshot);
            }
          }
        }
      }
      if (document2.getText() === originalDocument.getText())
        return;
      const editRange = {
        start: originalDocument.positionAt(0),
        end: originalDocument.positionAt(originalDocument.getText().length)
      };
      const textEdit2 = {
        range: editRange,
        newText: document2.getText()
      };
      return [textEdit2];
      function getEmbeddedFilesByLevel(rootFile, level2) {
        const embeddedFilesByLevel = [[rootFile]];
        while (true) {
          if (embeddedFilesByLevel.length > level2)
            return embeddedFilesByLevel[level2];
          let nextLevel = [];
          for (const file of embeddedFilesByLevel[embeddedFilesByLevel.length - 1]) {
            nextLevel = nextLevel.concat(file.embeddedFiles);
          }
          embeddedFilesByLevel.push(nextLevel);
        }
      }
      async function tryFormat(document3, range3, ch) {
        var _a3, _b2, _c2;
        let formatRange = range3;
        for (const service of Object.values(context.services)) {
          if (token.isCancellationRequested)
            break;
          let edits;
          try {
            if (ch !== void 0 && "line" in formatRange && "character" in formatRange) {
              if ((_a3 = service.autoFormatTriggerCharacters) == null ? void 0 : _a3.includes(ch)) {
                edits = await ((_b2 = service.provideOnTypeFormattingEdits) == null ? void 0 : _b2.call(service, document3, formatRange, ch, options, token));
              }
            } else if (ch === void 0 && "start" in formatRange && "end" in formatRange) {
              edits = await ((_c2 = service.provideDocumentFormattingEdits) == null ? void 0 : _c2.call(service, document3, formatRange, options, token));
            }
          } catch (err) {
            console.warn(err);
          }
          if (!edits)
            continue;
          return {
            service,
            edits
          };
        }
      }
    };
    function createDocMap(file, _sourceFileName, _sourceSnapshot) {
      var _a2, _b, _c, _d;
      const maps = (0, language_core_1$e.updateVirtualFileMaps)(file, (sourceFileName) => {
        if (!sourceFileName) {
          return [_sourceFileName, _sourceSnapshot];
        }
      });
      if (maps.has(_sourceFileName) && maps.get(_sourceFileName)[0] === _sourceSnapshot) {
        const [_, map2] = maps.get(_sourceFileName);
        const version2 = fakeVersion++;
        return new documents_1$1.SourceMapWithDocuments(vscode_languageserver_textdocument_1$1.TextDocument.create(context.env.fileNameToUri(_sourceFileName), ((_b = (_a2 = context.host).getLanguageId) == null ? void 0 : _b.call(_a2, _sourceFileName)) ?? (0, common_1$3.resolveCommonLanguageId)(context.env.fileNameToUri(_sourceFileName)), version2, _sourceSnapshot.getText(0, _sourceSnapshot.getLength())), vscode_languageserver_textdocument_1$1.TextDocument.create(context.env.fileNameToUri(file.fileName), ((_d = (_c = context.host).getLanguageId) == null ? void 0 : _d.call(_c, file.fileName)) ?? (0, common_1$3.resolveCommonLanguageId)(context.env.fileNameToUri(file.fileName)), version2, file.snapshot.getText(0, file.snapshot.getLength())), map2);
      }
    }
  }
  format$8.register = register$r;
  function patchIndents(document2, isCodeBlock, map2, initialIndent) {
    const indentTextEdits = [];
    if (!isCodeBlock) {
      initialIndent = "";
    }
    for (let i = 0; i < map2.mappings.length; i++) {
      const mapping = map2.mappings[i];
      const firstLineIndent = getBaseIndent(mapping.sourceRange[0]);
      const text2 = document2.getText().substring(mapping.sourceRange[0], mapping.sourceRange[1]);
      const lines = text2.split("\n");
      const baseIndent = firstLineIndent + initialIndent;
      let lineOffset = lines[0].length + 1;
      let insertedFinalNewLine = false;
      if (!text2.trim())
        continue;
      if (isCodeBlock && text2.trimStart().length === text2.length) {
        indentTextEdits.push({
          newText: "\n" + baseIndent,
          range: {
            start: document2.positionAt(mapping.sourceRange[0]),
            end: document2.positionAt(mapping.sourceRange[0])
          }
        });
      }
      if (isCodeBlock && text2.trimEnd().length === text2.length) {
        indentTextEdits.push({
          newText: "\n",
          range: {
            start: document2.positionAt(mapping.sourceRange[1]),
            end: document2.positionAt(mapping.sourceRange[1])
          }
        });
        insertedFinalNewLine = true;
      }
      if (baseIndent && lines.length > 1) {
        for (let i2 = 1; i2 < lines.length; i2++) {
          if (lines[i2].trim() || i2 === lines.length - 1) {
            const isLastLine = i2 === lines.length - 1 && !insertedFinalNewLine;
            indentTextEdits.push({
              newText: isLastLine ? firstLineIndent : baseIndent,
              range: {
                start: document2.positionAt(mapping.sourceRange[0] + lineOffset),
                end: document2.positionAt(mapping.sourceRange[0] + lineOffset)
              }
            });
          }
          lineOffset += lines[i2].length + 1;
        }
      }
    }
    return indentTextEdits;
    function getBaseIndent(pos) {
      const startPos = document2.positionAt(pos);
      const startLineText = document2.getText({ start: { line: startPos.line, character: 0 }, end: startPos });
      return startLineText.substring(0, startLineText.length - startLineText.trimStart().length);
    }
  }
  var linkedEditingRanges$1 = {};
  Object.defineProperty(linkedEditingRanges$1, "__esModule", { value: true });
  linkedEditingRanges$1.register = void 0;
  const featureWorkers_1$1 = featureWorkers;
  const common_1$2 = common$1;
  const cancellation_1$1 = cancellation;
  function register$q(context) {
    return (uri, position, token = cancellation_1$1.NoneCancellationToken) => {
      return (0, featureWorkers_1$1.languageFeatureWorker)(context, uri, position, (position2, map2) => map2.toGeneratedPositions(position2, (data2) => !!data2.completion), (service, document2, position2) => {
        var _a2;
        if (token.isCancellationRequested)
          return;
        return (_a2 = service.provideLinkedEditingRanges) == null ? void 0 : _a2.call(service, document2, position2, token);
      }, (data2, map2) => map2 ? {
        wordPattern: data2.wordPattern,
        ranges: data2.ranges.map((range2) => map2.toSourceRange(range2)).filter(common_1$2.notEmpty)
      } : data2);
    };
  }
  linkedEditingRanges$1.register = register$q;
  var selectionRanges$2 = {};
  Object.defineProperty(selectionRanges$2, "__esModule", { value: true });
  selectionRanges$2.register = void 0;
  const featureWorkers_1 = featureWorkers;
  const transformer = transformer$8;
  const common_1$1 = common$1;
  const cancellation_1 = cancellation;
  function register$p(context) {
    return (uri, positions, token = cancellation_1.NoneCancellationToken) => {
      return (0, featureWorkers_1.languageFeatureWorker)(context, uri, positions, (positions2, map2, file) => {
        if (file.capabilities.documentFormatting) {
          const result = positions2.map((position) => map2.toGeneratedPosition(position)).filter(common_1$1.notEmpty);
          if (result.length) {
            return [result];
          }
        }
        return [];
      }, (service, document2, positions2) => {
        var _a2;
        if (token.isCancellationRequested)
          return;
        return (_a2 = service.provideSelectionRanges) == null ? void 0 : _a2.call(service, document2, positions2, token);
      }, (item, map2) => map2 ? transformer.asSelectionRanges(item, (range2) => map2.toSourceRange(range2)) : item, (results) => {
        const result = [];
        for (let i = 0; i < positions.length; i++) {
          let pluginResults = [];
          for (const ranges of results) {
            pluginResults.push(ranges[i]);
          }
          pluginResults = pluginResults.sort((a2, b) => {
            if ((0, common_1$1.isInsideRange)(a2.range, b.range)) {
              return 1;
            }
            if ((0, common_1$1.isInsideRange)(b.range, a2.range)) {
              return -1;
            }
            return 0;
          });
          for (let i2 = 1; i2 < pluginResults.length; i2++) {
            let root = pluginResults[i2 - 1];
            while (root.parent) {
              root = root.parent;
            }
            let parent = pluginResults[i2];
            while (parent && !(0, common_1$1.isInsideRange)(parent.range, root.range)) {
              parent = parent.parent;
            }
            if (parent) {
              root.parent = parent;
            }
          }
          result.push(pluginResults[0]);
        }
        return result;
      });
    };
  }
  selectionRanges$2.register = register$p;
  Object.defineProperty(baseLanguageService, "__esModule", { value: true });
  baseLanguageService.createLanguageService = void 0;
  const language_core_1$d = out$b;
  const vscode_languageserver_textdocument_1 = require$$2$3;
  const documents_1 = documents;
  const autoInsert = autoInsert$1;
  const callHierarchy$1 = callHierarchy$2;
  const codeActionResolve$1 = codeActionResolve$2;
  const codeActions = codeActions$1;
  const codeLens = codeLens$1;
  const codeLensResolve = codeLensResolve$1;
  const completions = complete;
  const completionResolve = completeResolve;
  const definition$1 = definition$2;
  const documentHighlight$1 = documentHighlights;
  const documentLink = documentLinks;
  const documentLinkResolve = documentLinkResolve$1;
  const semanticTokens$1 = documentSemanticTokens;
  const fileReferences$1 = fileReferences$2;
  const fileRename$1 = fileRename$2;
  const hover$1 = hover$2;
  const inlayHints$1 = inlayHints$2;
  const inlayHintResolve = inlayHintResolve$1;
  const references$1 = references$3;
  const rename$1 = rename$2;
  const renamePrepare = renamePrepare$1;
  const signatureHelp$1 = signatureHelp$2;
  const diagnostics$1 = validation;
  const workspaceSymbol$1 = workspaceSymbols;
  const colorPresentations = colorPresentations$1;
  const documentColors = documentColors$1;
  const documentSymbols = documentSymbols$1;
  const foldingRanges$1 = foldingRanges$2;
  const format$7 = format$8;
  const linkedEditingRanges = linkedEditingRanges$1;
  const selectionRanges$1 = selectionRanges$2;
  const common_1 = common$1;
  function createLanguageService$2(modules2, env2, config2, languageHost) {
    if (languageHost.workspacePath.indexOf("\\") >= 0 || languageHost.rootPath.indexOf("\\") >= 0) {
      throw new Error("Volar: Current directory must be posix style.");
    }
    if (languageHost.getScriptFileNames().some((fileName) => fileName.indexOf("\\") >= 0)) {
      throw new Error("Volar: Script file names must be posix style.");
    }
    const languageContext2 = (0, language_core_1$d.createLanguageContext)(languageHost, Object.values(config2.languages ?? {}).filter(common_1.notEmpty));
    const context = createLanguageServicePluginContext(modules2, env2, config2, languageHost, languageContext2);
    return createLanguageServiceBase(context);
  }
  baseLanguageService.createLanguageService = createLanguageService$2;
  function createLanguageServicePluginContext(modules2, env2, config2, host, languageContext2) {
    var _a2;
    const textDocumentMapper = (0, documents_1.createDocumentsAndSourceMaps)(env2, host, languageContext2.virtualFiles);
    const documents2 = /* @__PURE__ */ new WeakMap();
    const documentVersions = /* @__PURE__ */ new Map();
    const context = {
      ...languageContext2,
      env: env2,
      inject: (key, ...args) => {
        var _a3;
        for (const service of Object.values(context.services)) {
          const provide = (_a3 = service.provide) == null ? void 0 : _a3[key];
          if (provide) {
            return provide(...args);
          }
        }
        throw `No service provide ${key}`;
      },
      rules: config2.rules ?? {},
      services: {},
      documents: textDocumentMapper,
      commands: {
        rename: {
          create(uri, position) {
            const source = toSourceLocation(uri, position, (data2) => typeof data2.rename === "object" ? !!data2.rename.normalize : !!data2.rename);
            if (!source) {
              return;
            }
            return {
              title: "",
              command: "editor.action.rename",
              arguments: [
                source.uri,
                source.position
              ]
            };
          },
          is(command) {
            return command.command === "editor.action.rename";
          }
        },
        showReferences: {
          create(uri, position, locations) {
            const source = toSourceLocation(uri, position);
            if (!source) {
              return;
            }
            const sourceReferences = [];
            for (const reference of locations) {
              if (context.documents.isVirtualFileUri(reference.uri)) {
                for (const [_, map2] of context.documents.getMapsByVirtualFileUri(reference.uri)) {
                  const range2 = map2.toSourceRange(reference.range);
                  if (range2) {
                    sourceReferences.push({ uri: map2.sourceFileDocument.uri, range: range2 });
                  }
                }
              } else {
                sourceReferences.push(reference);
              }
            }
            return {
              title: locations.length === 1 ? "1 reference" : `${locations.length} references`,
              command: "editor.action.showReferences",
              arguments: [
                source.uri,
                source.position,
                sourceReferences
              ]
            };
          },
          is(command) {
            return command.command === "editor.action.showReferences";
          }
        },
        setSelection: {
          create(position) {
            return {
              title: "",
              command: "setSelection",
              arguments: [{
                selection: {
                  selectionStartLineNumber: position.line + 1,
                  positionLineNumber: position.line + 1,
                  selectionStartColumn: position.character + 1,
                  positionColumn: position.character + 1
                }
              }]
            };
          },
          is(command) {
            return command.command === "setSelection";
          }
        }
      },
      getTextDocument
    };
    for (const serviceId in config2.services ?? {}) {
      const service = (_a2 = config2.services) == null ? void 0 : _a2[serviceId];
      if (service) {
        context.services[serviceId] = service(context, modules2);
      }
    }
    return context;
    function toSourceLocation(uri, position, filter) {
      if (!textDocumentMapper.isVirtualFileUri(uri)) {
        return { uri, position };
      }
      const map2 = textDocumentMapper.getVirtualFileByUri(uri);
      if (map2) {
        for (const [_, map3] of context.documents.getMapsByVirtualFileUri(uri)) {
          const sourcePosition = map3.toSourcePosition(position, filter);
          if (sourcePosition) {
            return {
              uri: map3.sourceFileDocument.uri,
              position: sourcePosition
            };
          }
        }
      }
    }
    function getTextDocument(uri) {
      var _a3;
      for (const [_, map2] of context.documents.getMapsByVirtualFileUri(uri)) {
        return map2.virtualFileDocument;
      }
      const fileName = env2.uriToFileName(uri);
      const scriptSnapshot = host.getScriptSnapshot(fileName);
      if (scriptSnapshot) {
        let document2 = documents2.get(scriptSnapshot);
        if (!document2) {
          const newVersion = (documentVersions.get(uri.toLowerCase()) ?? 0) + 1;
          documentVersions.set(uri.toLowerCase(), newVersion);
          document2 = vscode_languageserver_textdocument_1.TextDocument.create(uri, ((_a3 = host.getLanguageId) == null ? void 0 : _a3.call(host, fileName)) ?? (0, common_1.resolveCommonLanguageId)(uri), newVersion, scriptSnapshot.getText(0, scriptSnapshot.getLength()));
          documents2.set(scriptSnapshot, document2);
        }
        return document2;
      }
    }
  }
  function createLanguageServiceBase(context) {
    return {
      getTriggerCharacters: () => Object.values(context.services).map((service) => (service == null ? void 0 : service.triggerCharacters) ?? []).flat(),
      getAutoFormatTriggerCharacters: () => Object.values(context.services).map((service) => (service == null ? void 0 : service.autoFormatTriggerCharacters) ?? []).flat(),
      getSignatureHelpTriggerCharacters: () => Object.values(context.services).map((service) => (service == null ? void 0 : service.signatureHelpTriggerCharacters) ?? []).flat(),
      getSignatureHelpRetriggerCharacters: () => Object.values(context.services).map((service) => (service == null ? void 0 : service.signatureHelpRetriggerCharacters) ?? []).flat(),
      format: format$7.register(context),
      getFoldingRanges: foldingRanges$1.register(context),
      getSelectionRanges: selectionRanges$1.register(context),
      findLinkedEditingRanges: linkedEditingRanges.register(context),
      findDocumentSymbols: documentSymbols.register(context),
      findDocumentColors: documentColors.register(context),
      getColorPresentations: colorPresentations.register(context),
      doValidation: diagnostics$1.register(context),
      findReferences: references$1.register(context),
      findFileReferences: fileReferences$1.register(context),
      findDefinition: definition$1.register(context, "provideDefinition", (data2) => !!data2.definition, (data2) => !!data2.definition),
      findTypeDefinition: definition$1.register(context, "provideTypeDefinition", (data2) => !!data2.definition, (data2) => !!data2.definition),
      findImplementations: definition$1.register(context, "provideImplementation", (data2) => !!data2.references, () => false),
      prepareRename: renamePrepare.register(context),
      doRename: rename$1.register(context),
      getEditsForFileRename: fileRename$1.register(context),
      getSemanticTokens: semanticTokens$1.register(context),
      doHover: hover$1.register(context),
      doComplete: completions.register(context),
      doCodeActions: codeActions.register(context),
      doCodeActionResolve: codeActionResolve$1.register(context),
      doCompletionResolve: completionResolve.register(context),
      getSignatureHelp: signatureHelp$1.register(context),
      doCodeLens: codeLens.register(context),
      doCodeLensResolve: codeLensResolve.register(context),
      findDocumentHighlights: documentHighlight$1.register(context),
      findDocumentLinks: documentLink.register(context),
      doDocumentLinkResolve: documentLinkResolve.register(context),
      findWorkspaceSymbols: workspaceSymbol$1.register(context),
      doAutoInsert: autoInsert.register(context),
      getInlayHints: inlayHints$1.register(context),
      doInlayHintResolve: inlayHintResolve.register(context),
      callHierarchy: callHierarchy$1.register(context),
      dispose: () => Object.values(context.services).forEach((service) => {
        var _a2;
        return (_a2 = service.dispose) == null ? void 0 : _a2.call(service);
      }),
      context
    };
  }
  (function(exports) {
    var __createBinding2 = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = commonjsGlobal && commonjsGlobal.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
          __createBinding2(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.standardSemanticTokensLegend = exports.transformer = exports.mergeWorkspaceEdits = void 0;
    __exportStar(out$b, exports);
    __exportStar(baseLanguageService, exports);
    __exportStar(documents, exports);
    var rename_12 = rename$2;
    Object.defineProperty(exports, "mergeWorkspaceEdits", { enumerable: true, get: function() {
      return rename_12.mergeWorkspaceEdits;
    } });
    __exportStar(types$3, exports);
    exports.transformer = transformer$8;
    exports.standardSemanticTokensLegend = {
      tokenTypes: [
        "namespace",
        "class",
        "enum",
        "interface",
        "struct",
        "typeParameter",
        "type",
        "parameter",
        "variable",
        "property",
        "enumMember",
        "decorator",
        "event",
        "function",
        "method",
        "macro",
        "label",
        "comment",
        "string",
        "keyword",
        "number",
        "regexp",
        "operator"
      ],
      tokenModifiers: [
        "declaration",
        "definition",
        "readonly",
        "static",
        "deprecated",
        "abstract",
        "async",
        "modification",
        "documentation",
        "defaultLibrary"
      ]
    };
  })(out$c);
  var out$8 = {};
  var template = {};
  function makeMap$1(str2, expectsLowerCase) {
    const map2 = /* @__PURE__ */ Object.create(null);
    const list = str2.split(",");
    for (let i = 0; i < list.length; i++) {
      map2[list[i]] = true;
    }
    return expectsLowerCase ? (val) => !!map2[val.toLowerCase()] : (val) => !!map2[val];
  }
  const EMPTY_OBJ = {};
  const EMPTY_ARR = [];
  const NOOP = () => {
  };
  const NO = () => false;
  const onRE$1 = /^on[^a-z]/;
  const isOn = (key) => onRE$1.test(key);
  const isModelListener = (key) => key.startsWith("onUpdate:");
  const extend$1 = Object.assign;
  const remove$1 = (arr, el) => {
    const i = arr.indexOf(el);
    if (i > -1) {
      arr.splice(i, 1);
    }
  };
  const hasOwnProperty$2 = Object.prototype.hasOwnProperty;
  const hasOwn$1 = (val, key) => hasOwnProperty$2.call(val, key);
  const isArray$2 = Array.isArray;
  const isMap = (val) => toTypeString(val) === "[object Map]";
  const isSet = (val) => toTypeString(val) === "[object Set]";
  const isDate = (val) => toTypeString(val) === "[object Date]";
  const isRegExp = (val) => toTypeString(val) === "[object RegExp]";
  const isFunction$1 = (val) => typeof val === "function";
  const isString$1 = (val) => typeof val === "string";
  const isSymbol = (val) => typeof val === "symbol";
  const isObject$2 = (val) => val !== null && typeof val === "object";
  const isPromise$1 = (val) => {
    return isObject$2(val) && isFunction$1(val.then) && isFunction$1(val.catch);
  };
  const objectToString = Object.prototype.toString;
  const toTypeString = (value) => objectToString.call(value);
  const toRawType$1 = (value) => {
    return toTypeString(value).slice(8, -1);
  };
  const isPlainObject$1 = (val) => toTypeString(val) === "[object Object]";
  const isIntegerKey = (key) => isString$1(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
  const isReservedProp = /* @__PURE__ */ makeMap$1(
    // the leading comma is intentional so empty string "" is also included
    ",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted"
  );
  const isBuiltInDirective = /* @__PURE__ */ makeMap$1(
    "bind,cloak,else-if,else,for,html,if,model,on,once,pre,show,slot,text,memo"
  );
  const cacheStringFunction = (fn) => {
    const cache = /* @__PURE__ */ Object.create(null);
    return (str2) => {
      const hit = cache[str2];
      return hit || (cache[str2] = fn(str2));
    };
  };
  const camelizeRE$1 = /-(\w)/g;
  const camelize$1 = cacheStringFunction((str2) => {
    return str2.replace(camelizeRE$1, (_, c) => c ? c.toUpperCase() : "");
  });
  const hyphenateRE$1 = /\B([A-Z])/g;
  const hyphenate$1 = cacheStringFunction(
    (str2) => str2.replace(hyphenateRE$1, "-$1").toLowerCase()
  );
  const capitalize$1 = cacheStringFunction(
    (str2) => str2.charAt(0).toUpperCase() + str2.slice(1)
  );
  const toHandlerKey = cacheStringFunction(
    (str2) => str2 ? `on${capitalize$1(str2)}` : ``
  );
  const hasChanged$1 = (value, oldValue) => !Object.is(value, oldValue);
  const invokeArrayFns = (fns, arg) => {
    for (let i = 0; i < fns.length; i++) {
      fns[i](arg);
    }
  };
  const def$1 = (obj, key, value) => {
    Object.defineProperty(obj, key, {
      configurable: true,
      enumerable: false,
      value
    });
  };
  const looseToNumber = (val) => {
    const n = parseFloat(val);
    return isNaN(n) ? val : n;
  };
  const toNumber$1 = (val) => {
    const n = isString$1(val) ? Number(val) : NaN;
    return isNaN(n) ? val : n;
  };
  let _globalThis;
  const getGlobalThis = () => {
    return _globalThis || (_globalThis = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
  };
  const identRE = /^[_$a-zA-Z\xA0-\uFFFF][_$a-zA-Z0-9\xA0-\uFFFF]*$/;
  function genPropsAccessExp(name) {
    return identRE.test(name) ? `__props.${name}` : `__props[${JSON.stringify(name)}]`;
  }
  const PatchFlagNames = {
    [1]: `TEXT`,
    [2]: `CLASS`,
    [4]: `STYLE`,
    [8]: `PROPS`,
    [16]: `FULL_PROPS`,
    [32]: `HYDRATE_EVENTS`,
    [64]: `STABLE_FRAGMENT`,
    [128]: `KEYED_FRAGMENT`,
    [256]: `UNKEYED_FRAGMENT`,
    [512]: `NEED_PATCH`,
    [1024]: `DYNAMIC_SLOTS`,
    [2048]: `DEV_ROOT_FRAGMENT`,
    [-1]: `HOISTED`,
    [-2]: `BAIL`
  };
  const slotFlagsText = {
    [1]: "STABLE",
    [2]: "DYNAMIC",
    [3]: "FORWARDED"
  };
  const GLOBALS_WHITE_LISTED = "Infinity,undefined,NaN,isFinite,isNaN,parseFloat,parseInt,decodeURI,decodeURIComponent,encodeURI,encodeURIComponent,Math,Number,Date,Array,Object,Boolean,String,RegExp,Map,Set,JSON,Intl,BigInt,console";
  const isGloballyWhitelisted = /* @__PURE__ */ makeMap$1(GLOBALS_WHITE_LISTED);
  const range$3 = 2;
  function generateCodeFrame$1(source, start = 0, end = source.length) {
    let lines = source.split(/(\r?\n)/);
    const newlineSequences = lines.filter((_, idx) => idx % 2 === 1);
    lines = lines.filter((_, idx) => idx % 2 === 0);
    let count2 = 0;
    const res = [];
    for (let i = 0; i < lines.length; i++) {
      count2 += lines[i].length + (newlineSequences[i] && newlineSequences[i].length || 0);
      if (count2 >= start) {
        for (let j = i - range$3; j <= i + range$3 || end > count2; j++) {
          if (j < 0 || j >= lines.length)
            continue;
          const line = j + 1;
          res.push(
            `${line}${" ".repeat(Math.max(3 - String(line).length, 0))}|  ${lines[j]}`
          );
          const lineLength = lines[j].length;
          const newLineSeqLength = newlineSequences[j] && newlineSequences[j].length || 0;
          if (j === i) {
            const pad = start - (count2 - (lineLength + newLineSeqLength));
            const length = Math.max(
              1,
              end > count2 ? lineLength - pad : end - start
            );
            res.push(`   |  ` + " ".repeat(pad) + "^".repeat(length));
          } else if (j > i) {
            if (end > count2) {
              const length = Math.max(Math.min(end - count2, lineLength), 1);
              res.push(`   |  ` + "^".repeat(length));
            }
            count2 += lineLength + newLineSeqLength;
          }
        }
        break;
      }
    }
    return res.join("\n");
  }
  function normalizeStyle(value) {
    if (isArray$2(value)) {
      const res = {};
      for (let i = 0; i < value.length; i++) {
        const item = value[i];
        const normalized = isString$1(item) ? parseStringStyle(item) : normalizeStyle(item);
        if (normalized) {
          for (const key in normalized) {
            res[key] = normalized[key];
          }
        }
      }
      return res;
    } else if (isString$1(value)) {
      return value;
    } else if (isObject$2(value)) {
      return value;
    }
  }
  const listDelimiterRE = /;(?![^(]*\))/g;
  const propertyDelimiterRE = /:([^]+)/;
  const styleCommentRE = /\/\*[^]*?\*\//g;
  function parseStringStyle(cssText) {
    const ret = {};
    cssText.replace(styleCommentRE, "").split(listDelimiterRE).forEach((item) => {
      if (item) {
        const tmp = item.split(propertyDelimiterRE);
        tmp.length > 1 && (ret[tmp[0].trim()] = tmp[1].trim());
      }
    });
    return ret;
  }
  function stringifyStyle(styles) {
    let ret = "";
    if (!styles || isString$1(styles)) {
      return ret;
    }
    for (const key in styles) {
      const value = styles[key];
      const normalizedKey = key.startsWith(`--`) ? key : hyphenate$1(key);
      if (isString$1(value) || typeof value === "number") {
        ret += `${normalizedKey}:${value};`;
      }
    }
    return ret;
  }
  function normalizeClass(value) {
    let res = "";
    if (isString$1(value)) {
      res = value;
    } else if (isArray$2(value)) {
      for (let i = 0; i < value.length; i++) {
        const normalized = normalizeClass(value[i]);
        if (normalized) {
          res += normalized + " ";
        }
      }
    } else if (isObject$2(value)) {
      for (const name in value) {
        if (value[name]) {
          res += name + " ";
        }
      }
    }
    return res.trim();
  }
  function normalizeProps$1(props) {
    if (!props)
      return null;
    let { class: klass2, style: style2 } = props;
    if (klass2 && !isString$1(klass2)) {
      props.class = normalizeClass(klass2);
    }
    if (style2) {
      props.style = normalizeStyle(style2);
    }
    return props;
  }
  const HTML_TAGS$1 = "html,body,base,head,link,meta,style,title,address,article,aside,footer,header,hgroup,h1,h2,h3,h4,h5,h6,nav,section,div,dd,dl,dt,figcaption,figure,picture,hr,img,li,main,ol,p,pre,ul,a,b,abbr,bdi,bdo,br,cite,code,data,dfn,em,i,kbd,mark,q,rp,rt,ruby,s,samp,small,span,strong,sub,sup,time,u,var,wbr,area,audio,map,track,video,embed,object,param,source,canvas,script,noscript,del,ins,caption,col,colgroup,table,thead,tbody,td,th,tr,button,datalist,fieldset,form,input,label,legend,meter,optgroup,option,output,progress,select,textarea,details,dialog,menu,summary,template,blockquote,iframe,tfoot";
  const SVG_TAGS$1 = "svg,animate,animateMotion,animateTransform,circle,clipPath,color-profile,defs,desc,discard,ellipse,feBlend,feColorMatrix,feComponentTransfer,feComposite,feConvolveMatrix,feDiffuseLighting,feDisplacementMap,feDistantLight,feDropShadow,feFlood,feFuncA,feFuncB,feFuncG,feFuncR,feGaussianBlur,feImage,feMerge,feMergeNode,feMorphology,feOffset,fePointLight,feSpecularLighting,feSpotLight,feTile,feTurbulence,filter,foreignObject,g,hatch,hatchpath,image,line,linearGradient,marker,mask,mesh,meshgradient,meshpatch,meshrow,metadata,mpath,path,pattern,polygon,polyline,radialGradient,rect,set,solidcolor,stop,switch,symbol,text,textPath,title,tspan,unknown,use,view";
  const VOID_TAGS = "area,base,br,col,embed,hr,img,input,link,meta,param,source,track,wbr";
  const isHTMLTag$1 = /* @__PURE__ */ makeMap$1(HTML_TAGS$1);
  const isSVGTag = /* @__PURE__ */ makeMap$1(SVG_TAGS$1);
  const isVoidTag = /* @__PURE__ */ makeMap$1(VOID_TAGS);
  const specialBooleanAttrs = `itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly`;
  const isSpecialBooleanAttr = /* @__PURE__ */ makeMap$1(specialBooleanAttrs);
  const isBooleanAttr$1 = /* @__PURE__ */ makeMap$1(
    specialBooleanAttrs + `,async,autofocus,autoplay,controls,default,defer,disabled,hidden,inert,loop,open,required,reversed,scoped,seamless,checked,muted,multiple,selected`
  );
  function includeBooleanAttr(value) {
    return !!value || value === "";
  }
  const unsafeAttrCharRE = /[>/="'\u0009\u000a\u000c\u0020]/;
  const attrValidationCache = {};
  function isSSRSafeAttrName(name) {
    if (attrValidationCache.hasOwnProperty(name)) {
      return attrValidationCache[name];
    }
    const isUnsafe = unsafeAttrCharRE.test(name);
    if (isUnsafe) {
      console.error(`unsafe attribute name: ${name}`);
    }
    return attrValidationCache[name] = !isUnsafe;
  }
  const propsToAttrMap$1 = {
    acceptCharset: "accept-charset",
    className: "class",
    htmlFor: "for",
    httpEquiv: "http-equiv"
  };
  const isKnownHtmlAttr = /* @__PURE__ */ makeMap$1(
    `accept,accept-charset,accesskey,action,align,allow,alt,async,autocapitalize,autocomplete,autofocus,autoplay,background,bgcolor,border,buffered,capture,challenge,charset,checked,cite,class,code,codebase,color,cols,colspan,content,contenteditable,contextmenu,controls,coords,crossorigin,csp,data,datetime,decoding,default,defer,dir,dirname,disabled,download,draggable,dropzone,enctype,enterkeyhint,for,form,formaction,formenctype,formmethod,formnovalidate,formtarget,headers,height,hidden,high,href,hreflang,http-equiv,icon,id,importance,inert,integrity,ismap,itemprop,keytype,kind,label,lang,language,loading,list,loop,low,manifest,max,maxlength,minlength,media,min,multiple,muted,name,novalidate,open,optimum,pattern,ping,placeholder,poster,preload,radiogroup,readonly,referrerpolicy,rel,required,reversed,rows,rowspan,sandbox,scope,scoped,selected,shape,size,sizes,slot,span,spellcheck,src,srcdoc,srclang,srcset,start,step,style,summary,tabindex,target,title,translate,type,usemap,value,width,wrap`
  );
  const isKnownSvgAttr = /* @__PURE__ */ makeMap$1(
    `xmlns,accent-height,accumulate,additive,alignment-baseline,alphabetic,amplitude,arabic-form,ascent,attributeName,attributeType,azimuth,baseFrequency,baseline-shift,baseProfile,bbox,begin,bias,by,calcMode,cap-height,class,clip,clipPathUnits,clip-path,clip-rule,color,color-interpolation,color-interpolation-filters,color-profile,color-rendering,contentScriptType,contentStyleType,crossorigin,cursor,cx,cy,d,decelerate,descent,diffuseConstant,direction,display,divisor,dominant-baseline,dur,dx,dy,edgeMode,elevation,enable-background,end,exponent,fill,fill-opacity,fill-rule,filter,filterRes,filterUnits,flood-color,flood-opacity,font-family,font-size,font-size-adjust,font-stretch,font-style,font-variant,font-weight,format,from,fr,fx,fy,g1,g2,glyph-name,glyph-orientation-horizontal,glyph-orientation-vertical,glyphRef,gradientTransform,gradientUnits,hanging,height,href,hreflang,horiz-adv-x,horiz-origin-x,id,ideographic,image-rendering,in,in2,intercept,k,k1,k2,k3,k4,kernelMatrix,kernelUnitLength,kerning,keyPoints,keySplines,keyTimes,lang,lengthAdjust,letter-spacing,lighting-color,limitingConeAngle,local,marker-end,marker-mid,marker-start,markerHeight,markerUnits,markerWidth,mask,maskContentUnits,maskUnits,mathematical,max,media,method,min,mode,name,numOctaves,offset,opacity,operator,order,orient,orientation,origin,overflow,overline-position,overline-thickness,panose-1,paint-order,path,pathLength,patternContentUnits,patternTransform,patternUnits,ping,pointer-events,points,pointsAtX,pointsAtY,pointsAtZ,preserveAlpha,preserveAspectRatio,primitiveUnits,r,radius,referrerPolicy,refX,refY,rel,rendering-intent,repeatCount,repeatDur,requiredExtensions,requiredFeatures,restart,result,rotate,rx,ry,scale,seed,shape-rendering,slope,spacing,specularConstant,specularExponent,speed,spreadMethod,startOffset,stdDeviation,stemh,stemv,stitchTiles,stop-color,stop-opacity,strikethrough-position,strikethrough-thickness,string,stroke,stroke-dasharray,stroke-dashoffset,stroke-linecap,stroke-linejoin,stroke-miterlimit,stroke-opacity,stroke-width,style,surfaceScale,systemLanguage,tabindex,tableValues,target,targetX,targetY,text-anchor,text-decoration,text-rendering,textLength,to,transform,transform-origin,type,u1,u2,underline-position,underline-thickness,unicode,unicode-bidi,unicode-range,units-per-em,v-alphabetic,v-hanging,v-ideographic,v-mathematical,values,vector-effect,version,vert-adv-y,vert-origin-x,vert-origin-y,viewBox,viewTarget,visibility,width,widths,word-spacing,writing-mode,x,x-height,x1,x2,xChannelSelector,xlink:actuate,xlink:arcrole,xlink:href,xlink:role,xlink:show,xlink:title,xlink:type,xml:base,xml:lang,xml:space,y,y1,y2,yChannelSelector,z,zoomAndPan`
  );
  const escapeRE = /["'&<>]/;
  function escapeHtml(string) {
    const str2 = "" + string;
    const match = escapeRE.exec(str2);
    if (!match) {
      return str2;
    }
    let html2 = "";
    let escaped;
    let index2;
    let lastIndex = 0;
    for (index2 = match.index; index2 < str2.length; index2++) {
      switch (str2.charCodeAt(index2)) {
        case 34:
          escaped = "&quot;";
          break;
        case 38:
          escaped = "&amp;";
          break;
        case 39:
          escaped = "&#39;";
          break;
        case 60:
          escaped = "&lt;";
          break;
        case 62:
          escaped = "&gt;";
          break;
        default:
          continue;
      }
      if (lastIndex !== index2) {
        html2 += str2.slice(lastIndex, index2);
      }
      lastIndex = index2 + 1;
      html2 += escaped;
    }
    return lastIndex !== index2 ? html2 + str2.slice(lastIndex, index2) : html2;
  }
  const commentStripRE = /^-?>|<!--|-->|--!>|<!-$/g;
  function escapeHtmlComment(src) {
    return src.replace(commentStripRE, "");
  }
  function looseCompareArrays(a2, b) {
    if (a2.length !== b.length)
      return false;
    let equal = true;
    for (let i = 0; equal && i < a2.length; i++) {
      equal = looseEqual$1(a2[i], b[i]);
    }
    return equal;
  }
  function looseEqual$1(a2, b) {
    if (a2 === b)
      return true;
    let aValidType = isDate(a2);
    let bValidType = isDate(b);
    if (aValidType || bValidType) {
      return aValidType && bValidType ? a2.getTime() === b.getTime() : false;
    }
    aValidType = isSymbol(a2);
    bValidType = isSymbol(b);
    if (aValidType || bValidType) {
      return a2 === b;
    }
    aValidType = isArray$2(a2);
    bValidType = isArray$2(b);
    if (aValidType || bValidType) {
      return aValidType && bValidType ? looseCompareArrays(a2, b) : false;
    }
    aValidType = isObject$2(a2);
    bValidType = isObject$2(b);
    if (aValidType || bValidType) {
      if (!aValidType || !bValidType) {
        return false;
      }
      const aKeysCount = Object.keys(a2).length;
      const bKeysCount = Object.keys(b).length;
      if (aKeysCount !== bKeysCount) {
        return false;
      }
      for (const key in a2) {
        const aHasKey = a2.hasOwnProperty(key);
        const bHasKey = b.hasOwnProperty(key);
        if (aHasKey && !bHasKey || !aHasKey && bHasKey || !looseEqual$1(a2[key], b[key])) {
          return false;
        }
      }
    }
    return String(a2) === String(b);
  }
  function looseIndexOf$1(arr, val) {
    return arr.findIndex((item) => looseEqual$1(item, val));
  }
  const toDisplayString$1 = (val) => {
    return isString$1(val) ? val : val == null ? "" : isArray$2(val) || isObject$2(val) && (val.toString === objectToString || !isFunction$1(val.toString)) ? JSON.stringify(val, replacer, 2) : String(val);
  };
  const replacer = (_key, val) => {
    if (val && val.__v_isRef) {
      return replacer(_key, val.value);
    } else if (isMap(val)) {
      return {
        [`Map(${val.size})`]: [...val.entries()].reduce((entries, [key, val2]) => {
          entries[`${key} =>`] = val2;
          return entries;
        }, {})
      };
    } else if (isSet(val)) {
      return {
        [`Set(${val.size})`]: [...val.values()]
      };
    } else if (isObject$2(val) && !isArray$2(val) && !isPlainObject$1(val)) {
      return String(val);
    }
    return val;
  };
  var shared_esmBundler = /* @__PURE__ */ Object.freeze({
    __proto__: null,
    EMPTY_ARR,
    EMPTY_OBJ,
    NO,
    NOOP,
    PatchFlagNames,
    camelize: camelize$1,
    capitalize: capitalize$1,
    def: def$1,
    escapeHtml,
    escapeHtmlComment,
    extend: extend$1,
    genPropsAccessExp,
    generateCodeFrame: generateCodeFrame$1,
    getGlobalThis,
    hasChanged: hasChanged$1,
    hasOwn: hasOwn$1,
    hyphenate: hyphenate$1,
    includeBooleanAttr,
    invokeArrayFns,
    isArray: isArray$2,
    isBooleanAttr: isBooleanAttr$1,
    isBuiltInDirective,
    isDate,
    isFunction: isFunction$1,
    isGloballyWhitelisted,
    isHTMLTag: isHTMLTag$1,
    isIntegerKey,
    isKnownHtmlAttr,
    isKnownSvgAttr,
    isMap,
    isModelListener,
    isObject: isObject$2,
    isOn,
    isPlainObject: isPlainObject$1,
    isPromise: isPromise$1,
    isRegExp,
    isReservedProp,
    isSSRSafeAttrName,
    isSVGTag,
    isSet,
    isSpecialBooleanAttr,
    isString: isString$1,
    isSymbol,
    isVoidTag,
    looseEqual: looseEqual$1,
    looseIndexOf: looseIndexOf$1,
    looseToNumber,
    makeMap: makeMap$1,
    normalizeClass,
    normalizeProps: normalizeProps$1,
    normalizeStyle,
    objectToString,
    parseStringStyle,
    propsToAttrMap: propsToAttrMap$1,
    remove: remove$1,
    slotFlagsText,
    stringifyStyle,
    toDisplayString: toDisplayString$1,
    toHandlerKey,
    toNumber: toNumber$1,
    toRawType: toRawType$1,
    toTypeString
  });
  function defaultOnError(error) {
    throw error;
  }
  function defaultOnWarn(msg) {
  }
  function createCompilerError(code, loc, messages, additionalMessage) {
    const msg = code;
    const error = new SyntaxError(String(msg));
    error.code = code;
    error.loc = loc;
    return error;
  }
  const FRAGMENT = Symbol(``);
  const TELEPORT = Symbol(``);
  const SUSPENSE = Symbol(``);
  const KEEP_ALIVE = Symbol(``);
  const BASE_TRANSITION = Symbol(``);
  const OPEN_BLOCK = Symbol(``);
  const CREATE_BLOCK = Symbol(``);
  const CREATE_ELEMENT_BLOCK = Symbol(``);
  const CREATE_VNODE = Symbol(``);
  const CREATE_ELEMENT_VNODE = Symbol(``);
  const CREATE_COMMENT = Symbol(``);
  const CREATE_TEXT = Symbol(``);
  const CREATE_STATIC = Symbol(``);
  const RESOLVE_COMPONENT = Symbol(``);
  const RESOLVE_DYNAMIC_COMPONENT = Symbol(
    ``
  );
  const RESOLVE_DIRECTIVE = Symbol(``);
  const RESOLVE_FILTER = Symbol(``);
  const WITH_DIRECTIVES = Symbol(``);
  const RENDER_LIST = Symbol(``);
  const RENDER_SLOT = Symbol(``);
  const CREATE_SLOTS = Symbol(``);
  const TO_DISPLAY_STRING = Symbol(``);
  const MERGE_PROPS = Symbol(``);
  const NORMALIZE_CLASS = Symbol(``);
  const NORMALIZE_STYLE = Symbol(``);
  const NORMALIZE_PROPS = Symbol(``);
  const GUARD_REACTIVE_PROPS = Symbol(``);
  const TO_HANDLERS = Symbol(``);
  const CAMELIZE = Symbol(``);
  const CAPITALIZE = Symbol(``);
  const TO_HANDLER_KEY = Symbol(``);
  const SET_BLOCK_TRACKING = Symbol(``);
  const PUSH_SCOPE_ID = Symbol(``);
  const POP_SCOPE_ID = Symbol(``);
  const WITH_CTX = Symbol(``);
  const UNREF = Symbol(``);
  const IS_REF = Symbol(``);
  const WITH_MEMO = Symbol(``);
  const IS_MEMO_SAME = Symbol(``);
  const helperNameMap = {
    [FRAGMENT]: `Fragment`,
    [TELEPORT]: `Teleport`,
    [SUSPENSE]: `Suspense`,
    [KEEP_ALIVE]: `KeepAlive`,
    [BASE_TRANSITION]: `BaseTransition`,
    [OPEN_BLOCK]: `openBlock`,
    [CREATE_BLOCK]: `createBlock`,
    [CREATE_ELEMENT_BLOCK]: `createElementBlock`,
    [CREATE_VNODE]: `createVNode`,
    [CREATE_ELEMENT_VNODE]: `createElementVNode`,
    [CREATE_COMMENT]: `createCommentVNode`,
    [CREATE_TEXT]: `createTextVNode`,
    [CREATE_STATIC]: `createStaticVNode`,
    [RESOLVE_COMPONENT]: `resolveComponent`,
    [RESOLVE_DYNAMIC_COMPONENT]: `resolveDynamicComponent`,
    [RESOLVE_DIRECTIVE]: `resolveDirective`,
    [RESOLVE_FILTER]: `resolveFilter`,
    [WITH_DIRECTIVES]: `withDirectives`,
    [RENDER_LIST]: `renderList`,
    [RENDER_SLOT]: `renderSlot`,
    [CREATE_SLOTS]: `createSlots`,
    [TO_DISPLAY_STRING]: `toDisplayString`,
    [MERGE_PROPS]: `mergeProps`,
    [NORMALIZE_CLASS]: `normalizeClass`,
    [NORMALIZE_STYLE]: `normalizeStyle`,
    [NORMALIZE_PROPS]: `normalizeProps`,
    [GUARD_REACTIVE_PROPS]: `guardReactiveProps`,
    [TO_HANDLERS]: `toHandlers`,
    [CAMELIZE]: `camelize`,
    [CAPITALIZE]: `capitalize`,
    [TO_HANDLER_KEY]: `toHandlerKey`,
    [SET_BLOCK_TRACKING]: `setBlockTracking`,
    [PUSH_SCOPE_ID]: `pushScopeId`,
    [POP_SCOPE_ID]: `popScopeId`,
    [WITH_CTX]: `withCtx`,
    [UNREF]: `unref`,
    [IS_REF]: `isRef`,
    [WITH_MEMO]: `withMemo`,
    [IS_MEMO_SAME]: `isMemoSame`
  };
  function registerRuntimeHelpers(helpers2) {
    Object.getOwnPropertySymbols(helpers2).forEach((s) => {
      helperNameMap[s] = helpers2[s];
    });
  }
  const locStub = {
    source: "",
    start: { line: 1, column: 1, offset: 0 },
    end: { line: 1, column: 1, offset: 0 }
  };
  function createRoot(children, loc = locStub) {
    return {
      type: 0,
      children,
      helpers: /* @__PURE__ */ new Set(),
      components: [],
      directives: [],
      hoists: [],
      imports: [],
      cached: 0,
      temps: 0,
      codegenNode: void 0,
      loc
    };
  }
  function createVNodeCall(context, tag, props, children, patchFlag, dynamicProps, directives2, isBlock = false, disableTracking = false, isComponent2 = false, loc = locStub) {
    if (context) {
      if (isBlock) {
        context.helper(OPEN_BLOCK);
        context.helper(getVNodeBlockHelper(context.inSSR, isComponent2));
      } else {
        context.helper(getVNodeHelper(context.inSSR, isComponent2));
      }
      if (directives2) {
        context.helper(WITH_DIRECTIVES);
      }
    }
    return {
      type: 13,
      tag,
      props,
      children,
      patchFlag,
      dynamicProps,
      directives: directives2,
      isBlock,
      disableTracking,
      isComponent: isComponent2,
      loc
    };
  }
  function createArrayExpression(elements, loc = locStub) {
    return {
      type: 17,
      loc,
      elements
    };
  }
  function createObjectExpression(properties, loc = locStub) {
    return {
      type: 15,
      loc,
      properties
    };
  }
  function createObjectProperty(key, value) {
    return {
      type: 16,
      loc: locStub,
      key: isString$1(key) ? createSimpleExpression(key, true) : key,
      value
    };
  }
  function createSimpleExpression(content, isStatic2 = false, loc = locStub, constType = 0) {
    return {
      type: 4,
      loc,
      content,
      isStatic: isStatic2,
      constType: isStatic2 ? 3 : constType
    };
  }
  function createInterpolation(content, loc) {
    return {
      type: 5,
      loc,
      content: isString$1(content) ? createSimpleExpression(content, false, loc) : content
    };
  }
  function createCompoundExpression(children, loc = locStub) {
    return {
      type: 8,
      loc,
      children
    };
  }
  function createCallExpression(callee, args = [], loc = locStub) {
    return {
      type: 14,
      loc,
      callee,
      arguments: args
    };
  }
  function createFunctionExpression(params, returns = void 0, newline = false, isSlot = false, loc = locStub) {
    return {
      type: 18,
      params,
      returns,
      newline,
      isSlot,
      loc
    };
  }
  function createConditionalExpression(test, consequent, alternate, newline = true) {
    return {
      type: 19,
      test,
      consequent,
      alternate,
      newline,
      loc: locStub
    };
  }
  function createCacheExpression(index2, value, isVNode = false) {
    return {
      type: 20,
      index: index2,
      value,
      isVNode,
      loc: locStub
    };
  }
  function createBlockStatement(body) {
    return {
      type: 21,
      body,
      loc: locStub
    };
  }
  function createTemplateLiteral(elements) {
    return {
      type: 22,
      elements,
      loc: locStub
    };
  }
  function createIfStatement(test, consequent, alternate) {
    return {
      type: 23,
      test,
      consequent,
      alternate,
      loc: locStub
    };
  }
  function createAssignmentExpression(left, right) {
    return {
      type: 24,
      left,
      right,
      loc: locStub
    };
  }
  function createSequenceExpression(expressions) {
    return {
      type: 25,
      expressions,
      loc: locStub
    };
  }
  function createReturnStatement(returns) {
    return {
      type: 26,
      returns,
      loc: locStub
    };
  }
  function getVNodeHelper(ssr, isComponent2) {
    return ssr || isComponent2 ? CREATE_VNODE : CREATE_ELEMENT_VNODE;
  }
  function getVNodeBlockHelper(ssr, isComponent2) {
    return ssr || isComponent2 ? CREATE_BLOCK : CREATE_ELEMENT_BLOCK;
  }
  function convertToBlock(node, { helper, removeHelper, inSSR }) {
    if (!node.isBlock) {
      node.isBlock = true;
      removeHelper(getVNodeHelper(inSSR, node.isComponent));
      helper(OPEN_BLOCK);
      helper(getVNodeBlockHelper(inSSR, node.isComponent));
    }
  }
  const isStaticExp = (p) => p.type === 4 && p.isStatic;
  const isBuiltInType = (tag, expected) => tag === expected || tag === hyphenate$1(expected);
  function isCoreComponent(tag) {
    if (isBuiltInType(tag, "Teleport")) {
      return TELEPORT;
    } else if (isBuiltInType(tag, "Suspense")) {
      return SUSPENSE;
    } else if (isBuiltInType(tag, "KeepAlive")) {
      return KEEP_ALIVE;
    } else if (isBuiltInType(tag, "BaseTransition")) {
      return BASE_TRANSITION;
    }
  }
  const nonIdentifierRE = /^\d|[^\$\w]/;
  const isSimpleIdentifier = (name) => !nonIdentifierRE.test(name);
  const validFirstIdentCharRE = /[A-Za-z_$\xA0-\uFFFF]/;
  const validIdentCharRE = /[\.\?\w$\xA0-\uFFFF]/;
  const whitespaceRE$1 = /\s+[.[]\s*|\s*[.[]\s+/g;
  const isMemberExpressionBrowser = (path2) => {
    path2 = path2.trim().replace(whitespaceRE$1, (s) => s.trim());
    let state = 0;
    let stateStack = [];
    let currentOpenBracketCount = 0;
    let currentOpenParensCount = 0;
    let currentStringType = null;
    for (let i = 0; i < path2.length; i++) {
      const char = path2.charAt(i);
      switch (state) {
        case 0:
          if (char === "[") {
            stateStack.push(state);
            state = 1;
            currentOpenBracketCount++;
          } else if (char === "(") {
            stateStack.push(state);
            state = 2;
            currentOpenParensCount++;
          } else if (!(i === 0 ? validFirstIdentCharRE : validIdentCharRE).test(char)) {
            return false;
          }
          break;
        case 1:
          if (char === `'` || char === `"` || char === "`") {
            stateStack.push(state);
            state = 3;
            currentStringType = char;
          } else if (char === `[`) {
            currentOpenBracketCount++;
          } else if (char === `]`) {
            if (!--currentOpenBracketCount) {
              state = stateStack.pop();
            }
          }
          break;
        case 2:
          if (char === `'` || char === `"` || char === "`") {
            stateStack.push(state);
            state = 3;
            currentStringType = char;
          } else if (char === `(`) {
            currentOpenParensCount++;
          } else if (char === `)`) {
            if (i === path2.length - 1) {
              return false;
            }
            if (!--currentOpenParensCount) {
              state = stateStack.pop();
            }
          }
          break;
        case 3:
          if (char === currentStringType) {
            state = stateStack.pop();
            currentStringType = null;
          }
          break;
      }
    }
    return !currentOpenBracketCount && !currentOpenParensCount;
  };
  const isMemberExpressionNode = NOOP;
  const isMemberExpression = isMemberExpressionBrowser;
  function getInnerRange(loc, offset, length) {
    const source = loc.source.slice(offset, offset + length);
    const newLoc = {
      source,
      start: advancePositionWithClone(loc.start, loc.source, offset),
      end: loc.end
    };
    if (length != null) {
      newLoc.end = advancePositionWithClone(
        loc.start,
        loc.source,
        offset + length
      );
    }
    return newLoc;
  }
  function advancePositionWithClone(pos, source, numberOfCharacters = source.length) {
    return advancePositionWithMutation(
      extend$1({}, pos),
      source,
      numberOfCharacters
    );
  }
  function advancePositionWithMutation(pos, source, numberOfCharacters = source.length) {
    let linesCount = 0;
    let lastNewLinePos = -1;
    for (let i = 0; i < numberOfCharacters; i++) {
      if (source.charCodeAt(i) === 10) {
        linesCount++;
        lastNewLinePos = i;
      }
    }
    pos.offset += numberOfCharacters;
    pos.line += linesCount;
    pos.column = lastNewLinePos === -1 ? pos.column + numberOfCharacters : numberOfCharacters - lastNewLinePos;
    return pos;
  }
  function assert(condition, msg) {
    if (!condition) {
      throw new Error(msg || `unexpected compiler condition`);
    }
  }
  function findDir(node, name, allowEmpty = false) {
    for (let i = 0; i < node.props.length; i++) {
      const p = node.props[i];
      if (p.type === 7 && (allowEmpty || p.exp) && (isString$1(name) ? p.name === name : name.test(p.name))) {
        return p;
      }
    }
  }
  function findProp(node, name, dynamicOnly = false, allowEmpty = false) {
    for (let i = 0; i < node.props.length; i++) {
      const p = node.props[i];
      if (p.type === 6) {
        if (dynamicOnly)
          continue;
        if (p.name === name && (p.value || allowEmpty)) {
          return p;
        }
      } else if (p.name === "bind" && (p.exp || allowEmpty) && isStaticArgOf(p.arg, name)) {
        return p;
      }
    }
  }
  function isStaticArgOf(arg, name) {
    return !!(arg && isStaticExp(arg) && arg.content === name);
  }
  function hasDynamicKeyVBind(node) {
    return node.props.some(
      (p) => p.type === 7 && p.name === "bind" && (!p.arg || // v-bind="obj"
      p.arg.type !== 4 || // v-bind:[_ctx.foo]
      !p.arg.isStatic)
      // v-bind:[foo]
    );
  }
  function isText$1(node) {
    return node.type === 5 || node.type === 2;
  }
  function isVSlot(p) {
    return p.type === 7 && p.name === "slot";
  }
  function isTemplateNode(node) {
    return node.type === 1 && node.tagType === 3;
  }
  function isSlotOutlet(node) {
    return node.type === 1 && node.tagType === 2;
  }
  const propsHelperSet = /* @__PURE__ */ new Set([NORMALIZE_PROPS, GUARD_REACTIVE_PROPS]);
  function getUnnormalizedProps(props, callPath = []) {
    if (props && !isString$1(props) && props.type === 14) {
      const callee = props.callee;
      if (!isString$1(callee) && propsHelperSet.has(callee)) {
        return getUnnormalizedProps(
          props.arguments[0],
          callPath.concat(props)
        );
      }
    }
    return [props, callPath];
  }
  function injectProp(node, prop, context) {
    let propsWithInjection;
    let props = node.type === 13 ? node.props : node.arguments[2];
    let callPath = [];
    let parentCall;
    if (props && !isString$1(props) && props.type === 14) {
      const ret = getUnnormalizedProps(props);
      props = ret[0];
      callPath = ret[1];
      parentCall = callPath[callPath.length - 1];
    }
    if (props == null || isString$1(props)) {
      propsWithInjection = createObjectExpression([prop]);
    } else if (props.type === 14) {
      const first = props.arguments[0];
      if (!isString$1(first) && first.type === 15) {
        if (!hasProp(prop, first)) {
          first.properties.unshift(prop);
        }
      } else {
        if (props.callee === TO_HANDLERS) {
          propsWithInjection = createCallExpression(context.helper(MERGE_PROPS), [
            createObjectExpression([prop]),
            props
          ]);
        } else {
          props.arguments.unshift(createObjectExpression([prop]));
        }
      }
      !propsWithInjection && (propsWithInjection = props);
    } else if (props.type === 15) {
      if (!hasProp(prop, props)) {
        props.properties.unshift(prop);
      }
      propsWithInjection = props;
    } else {
      propsWithInjection = createCallExpression(context.helper(MERGE_PROPS), [
        createObjectExpression([prop]),
        props
      ]);
      if (parentCall && parentCall.callee === GUARD_REACTIVE_PROPS) {
        parentCall = callPath[callPath.length - 2];
      }
    }
    if (node.type === 13) {
      if (parentCall) {
        parentCall.arguments[0] = propsWithInjection;
      } else {
        node.props = propsWithInjection;
      }
    } else {
      if (parentCall) {
        parentCall.arguments[0] = propsWithInjection;
      } else {
        node.arguments[2] = propsWithInjection;
      }
    }
  }
  function hasProp(prop, props) {
    let result = false;
    if (prop.key.type === 4) {
      const propKeyName = prop.key.content;
      result = props.properties.some(
        (p) => p.key.type === 4 && p.key.content === propKeyName
      );
    }
    return result;
  }
  function toValidAssetId(name, type) {
    return `_${type}_${name.replace(/[^\w]/g, (searchValue, replaceValue) => {
      return searchValue === "-" ? "_" : name.charCodeAt(replaceValue).toString();
    })}`;
  }
  function hasScopeRef(node, ids) {
    if (!node || Object.keys(ids).length === 0) {
      return false;
    }
    switch (node.type) {
      case 1:
        for (let i = 0; i < node.props.length; i++) {
          const p = node.props[i];
          if (p.type === 7 && (hasScopeRef(p.arg, ids) || hasScopeRef(p.exp, ids))) {
            return true;
          }
        }
        return node.children.some((c) => hasScopeRef(c, ids));
      case 11:
        if (hasScopeRef(node.source, ids)) {
          return true;
        }
        return node.children.some((c) => hasScopeRef(c, ids));
      case 9:
        return node.branches.some((b) => hasScopeRef(b, ids));
      case 10:
        if (hasScopeRef(node.condition, ids)) {
          return true;
        }
        return node.children.some((c) => hasScopeRef(c, ids));
      case 4:
        return !node.isStatic && isSimpleIdentifier(node.content) && !!ids[node.content];
      case 8:
        return node.children.some((c) => isObject$2(c) && hasScopeRef(c, ids));
      case 5:
      case 12:
        return hasScopeRef(node.content, ids);
      case 2:
      case 3:
        return false;
      default:
        return false;
    }
  }
  function getMemoedVNodeCall(node) {
    if (node.type === 14 && node.callee === WITH_MEMO) {
      return node.arguments[1].returns;
    } else {
      return node;
    }
  }
  const deprecationData = {
    ["COMPILER_IS_ON_ELEMENT"]: {
      message: `Platform-native elements with "is" prop will no longer be treated as components in Vue 3 unless the "is" value is explicitly prefixed with "vue:".`,
      link: `https://v3-migration.vuejs.org/breaking-changes/custom-elements-interop.html`
    },
    ["COMPILER_V_BIND_SYNC"]: {
      message: (key) => `.sync modifier for v-bind has been removed. Use v-model with argument instead. \`v-bind:${key}.sync\` should be changed to \`v-model:${key}\`.`,
      link: `https://v3-migration.vuejs.org/breaking-changes/v-model.html`
    },
    ["COMPILER_V_BIND_PROP"]: {
      message: `.prop modifier for v-bind has been removed and no longer necessary. Vue 3 will automatically set a binding as DOM property when appropriate.`
    },
    ["COMPILER_V_BIND_OBJECT_ORDER"]: {
      message: `v-bind="obj" usage is now order sensitive and behaves like JavaScript object spread: it will now overwrite an existing non-mergeable attribute that appears before v-bind in the case of conflict. To retain 2.x behavior, move v-bind to make it the first attribute. You can also suppress this warning if the usage is intended.`,
      link: `https://v3-migration.vuejs.org/breaking-changes/v-bind.html`
    },
    ["COMPILER_V_ON_NATIVE"]: {
      message: `.native modifier for v-on has been removed as is no longer necessary.`,
      link: `https://v3-migration.vuejs.org/breaking-changes/v-on-native-modifier-removed.html`
    },
    ["COMPILER_V_IF_V_FOR_PRECEDENCE"]: {
      message: `v-if / v-for precedence when used on the same element has changed in Vue 3: v-if now takes higher precedence and will no longer have access to v-for scope variables. It is best to avoid the ambiguity with <template> tags or use a computed property that filters v-for data source.`,
      link: `https://v3-migration.vuejs.org/breaking-changes/v-if-v-for.html`
    },
    ["COMPILER_NATIVE_TEMPLATE"]: {
      message: `<template> with no special directives will render as a native template element instead of its inner content in Vue 3.`
    },
    ["COMPILER_INLINE_TEMPLATE"]: {
      message: `"inline-template" has been removed in Vue 3.`,
      link: `https://v3-migration.vuejs.org/breaking-changes/inline-template-attribute.html`
    },
    ["COMPILER_FILTER"]: {
      message: `filters have been removed in Vue 3. The "|" symbol will be treated as native JavaScript bitwise OR operator. Use method calls or computed properties instead.`,
      link: `https://v3-migration.vuejs.org/breaking-changes/filters.html`
    }
  };
  function getCompatValue(key, context) {
    const config2 = context.options ? context.options.compatConfig : context.compatConfig;
    const value = config2 && config2[key];
    if (key === "MODE") {
      return value || 3;
    } else {
      return value;
    }
  }
  function isCompatEnabled(key, context) {
    const mode = getCompatValue("MODE", context);
    const value = getCompatValue(key, context);
    return mode === 3 ? value === true : value !== false;
  }
  function checkCompatEnabled(key, context, loc, ...args) {
    const enabled = isCompatEnabled(key, context);
    return enabled;
  }
  function warnDeprecation(key, context, loc, ...args) {
    const val = getCompatValue(key, context);
    if (val === "suppress-warning") {
      return;
    }
    const { message, link } = deprecationData[key];
    const msg = `(deprecation ${key}) ${typeof message === "function" ? message(...args) : message}${link ? `
  Details: ${link}` : ``}`;
    const err = new SyntaxError(msg);
    err.code = key;
    if (loc)
      err.loc = loc;
    context.onWarn(err);
  }
  const decodeRE = /&(gt|lt|amp|apos|quot);/g;
  const decodeMap = {
    gt: ">",
    lt: "<",
    amp: "&",
    apos: "'",
    quot: '"'
  };
  const defaultParserOptions = {
    delimiters: [`{{`, `}}`],
    getNamespace: () => 0,
    getTextMode: () => 0,
    isVoidTag: NO,
    isPreTag: NO,
    isCustomElement: NO,
    decodeEntities: (rawText) => rawText.replace(decodeRE, (_, p1) => decodeMap[p1]),
    onError: defaultOnError,
    onWarn: defaultOnWarn,
    comments: false
  };
  function baseParse(content, options = {}) {
    const context = createParserContext(content, options);
    const start = getCursor(context);
    return createRoot(
      parseChildren(context, 0, []),
      getSelection(context, start)
    );
  }
  function createParserContext(content, rawOptions) {
    const options = extend$1({}, defaultParserOptions);
    let key;
    for (key in rawOptions) {
      options[key] = rawOptions[key] === void 0 ? defaultParserOptions[key] : rawOptions[key];
    }
    return {
      options,
      column: 1,
      line: 1,
      offset: 0,
      originalSource: content,
      source: content,
      inPre: false,
      inVPre: false,
      onWarn: options.onWarn
    };
  }
  function parseChildren(context, mode, ancestors) {
    const parent = last$1(ancestors);
    const ns = parent ? parent.ns : 0;
    const nodes = [];
    while (!isEnd(context, mode, ancestors)) {
      const s = context.source;
      let node = void 0;
      if (mode === 0 || mode === 1) {
        if (!context.inVPre && startsWith$4(s, context.options.delimiters[0])) {
          node = parseInterpolation(context, mode);
        } else if (mode === 0 && s[0] === "<") {
          if (s.length === 1) {
            emitError(context, 5, 1);
          } else if (s[1] === "!") {
            if (startsWith$4(s, "<!--")) {
              node = parseComment(context);
            } else if (startsWith$4(s, "<!DOCTYPE")) {
              node = parseBogusComment(context);
            } else if (startsWith$4(s, "<![CDATA[")) {
              if (ns !== 0) {
                node = parseCDATA(context, ancestors);
              } else {
                emitError(context, 1);
                node = parseBogusComment(context);
              }
            } else {
              emitError(context, 11);
              node = parseBogusComment(context);
            }
          } else if (s[1] === "/") {
            if (s.length === 2) {
              emitError(context, 5, 2);
            } else if (s[2] === ">") {
              emitError(context, 14, 2);
              advanceBy(context, 3);
              continue;
            } else if (/[a-z]/i.test(s[2])) {
              emitError(context, 23);
              parseTag(context, TagType.End, parent);
              continue;
            } else {
              emitError(
                context,
                12,
                2
              );
              node = parseBogusComment(context);
            }
          } else if (/[a-z]/i.test(s[1])) {
            node = parseElement(context, ancestors);
            if (isCompatEnabled(
              "COMPILER_NATIVE_TEMPLATE",
              context
            ) && node && node.tag === "template" && !node.props.some(
              (p) => p.type === 7 && isSpecialTemplateDirective(p.name)
            )) {
              node = node.children;
            }
          } else if (s[1] === "?") {
            emitError(
              context,
              21,
              1
            );
            node = parseBogusComment(context);
          } else {
            emitError(context, 12, 1);
          }
        }
      }
      if (!node) {
        node = parseText$1(context, mode);
      }
      if (isArray$2(node)) {
        for (let i = 0; i < node.length; i++) {
          pushNode(nodes, node[i]);
        }
      } else {
        pushNode(nodes, node);
      }
    }
    let removedWhitespace = false;
    if (mode !== 2 && mode !== 1) {
      const shouldCondense = context.options.whitespace !== "preserve";
      for (let i = 0; i < nodes.length; i++) {
        const node = nodes[i];
        if (node.type === 2) {
          if (!context.inPre) {
            if (!/[^\t\r\n\f ]/.test(node.content)) {
              const prev = nodes[i - 1];
              const next2 = nodes[i + 1];
              if (!prev || !next2 || shouldCondense && (prev.type === 3 && next2.type === 3 || prev.type === 3 && next2.type === 1 || prev.type === 1 && next2.type === 3 || prev.type === 1 && next2.type === 1 && /[\r\n]/.test(node.content))) {
                removedWhitespace = true;
                nodes[i] = null;
              } else {
                node.content = " ";
              }
            } else if (shouldCondense) {
              node.content = node.content.replace(/[\t\r\n\f ]+/g, " ");
            }
          } else {
            node.content = node.content.replace(/\r\n/g, "\n");
          }
        } else if (node.type === 3 && !context.options.comments) {
          removedWhitespace = true;
          nodes[i] = null;
        }
      }
      if (context.inPre && parent && context.options.isPreTag(parent.tag)) {
        const first = nodes[0];
        if (first && first.type === 2) {
          first.content = first.content.replace(/^\r?\n/, "");
        }
      }
    }
    return removedWhitespace ? nodes.filter(Boolean) : nodes;
  }
  function pushNode(nodes, node) {
    if (node.type === 2) {
      const prev = last$1(nodes);
      if (prev && prev.type === 2 && prev.loc.end.offset === node.loc.start.offset) {
        prev.content += node.content;
        prev.loc.end = node.loc.end;
        prev.loc.source += node.loc.source;
        return;
      }
    }
    nodes.push(node);
  }
  function parseCDATA(context, ancestors) {
    advanceBy(context, 9);
    const nodes = parseChildren(context, 3, ancestors);
    if (context.source.length === 0) {
      emitError(context, 6);
    } else {
      advanceBy(context, 3);
    }
    return nodes;
  }
  function parseComment(context) {
    const start = getCursor(context);
    let content;
    const match = /--(\!)?>/.exec(context.source);
    if (!match) {
      content = context.source.slice(4);
      advanceBy(context, context.source.length);
      emitError(context, 7);
    } else {
      if (match.index <= 3) {
        emitError(context, 0);
      }
      if (match[1]) {
        emitError(context, 10);
      }
      content = context.source.slice(4, match.index);
      const s = context.source.slice(0, match.index);
      let prevIndex = 1, nestedIndex = 0;
      while ((nestedIndex = s.indexOf("<!--", prevIndex)) !== -1) {
        advanceBy(context, nestedIndex - prevIndex + 1);
        if (nestedIndex + 4 < s.length) {
          emitError(context, 16);
        }
        prevIndex = nestedIndex + 1;
      }
      advanceBy(context, match.index + match[0].length - prevIndex + 1);
    }
    return {
      type: 3,
      content,
      loc: getSelection(context, start)
    };
  }
  function parseBogusComment(context) {
    const start = getCursor(context);
    const contentStart = context.source[1] === "?" ? 1 : 2;
    let content;
    const closeIndex = context.source.indexOf(">");
    if (closeIndex === -1) {
      content = context.source.slice(contentStart);
      advanceBy(context, context.source.length);
    } else {
      content = context.source.slice(contentStart, closeIndex);
      advanceBy(context, closeIndex + 1);
    }
    return {
      type: 3,
      content,
      loc: getSelection(context, start)
    };
  }
  function parseElement(context, ancestors) {
    const wasInPre = context.inPre;
    const wasInVPre = context.inVPre;
    const parent = last$1(ancestors);
    const element = parseTag(context, TagType.Start, parent);
    const isPreBoundary = context.inPre && !wasInPre;
    const isVPreBoundary = context.inVPre && !wasInVPre;
    if (element.isSelfClosing || context.options.isVoidTag(element.tag)) {
      if (isPreBoundary) {
        context.inPre = false;
      }
      if (isVPreBoundary) {
        context.inVPre = false;
      }
      return element;
    }
    ancestors.push(element);
    const mode = context.options.getTextMode(element, parent);
    const children = parseChildren(context, mode, ancestors);
    ancestors.pop();
    {
      const inlineTemplateProp = element.props.find(
        (p) => p.type === 6 && p.name === "inline-template"
      );
      if (inlineTemplateProp && checkCompatEnabled(
        "COMPILER_INLINE_TEMPLATE",
        context,
        inlineTemplateProp.loc
      )) {
        const loc = getSelection(context, element.loc.end);
        inlineTemplateProp.value = {
          type: 2,
          content: loc.source,
          loc
        };
      }
    }
    element.children = children;
    if (startsWithEndTagOpen(context.source, element.tag)) {
      parseTag(context, TagType.End, parent);
    } else {
      emitError(context, 24, 0, element.loc.start);
      if (context.source.length === 0 && element.tag.toLowerCase() === "script") {
        const first = children[0];
        if (first && startsWith$4(first.loc.source, "<!--")) {
          emitError(context, 8);
        }
      }
    }
    element.loc = getSelection(context, element.loc.start);
    if (isPreBoundary) {
      context.inPre = false;
    }
    if (isVPreBoundary) {
      context.inVPre = false;
    }
    return element;
  }
  var TagType = /* @__PURE__ */ ((TagType2) => {
    TagType2[TagType2["Start"] = 0] = "Start";
    TagType2[TagType2["End"] = 1] = "End";
    return TagType2;
  })(TagType || {});
  const isSpecialTemplateDirective = /* @__PURE__ */ makeMap$1(
    `if,else,else-if,for,slot`
  );
  function parseTag(context, type, parent) {
    const start = getCursor(context);
    const match = /^<\/?([a-z][^\t\r\n\f />]*)/i.exec(context.source);
    const tag = match[1];
    const ns = context.options.getNamespace(tag, parent);
    advanceBy(context, match[0].length);
    advanceSpaces(context);
    const cursor = getCursor(context);
    const currentSource = context.source;
    if (context.options.isPreTag(tag)) {
      context.inPre = true;
    }
    let props = parseAttributes(context, type);
    if (type === 0 && !context.inVPre && props.some((p) => p.type === 7 && p.name === "pre")) {
      context.inVPre = true;
      extend$1(context, cursor);
      context.source = currentSource;
      props = parseAttributes(context, type).filter((p) => p.name !== "v-pre");
    }
    let isSelfClosing = false;
    if (context.source.length === 0) {
      emitError(context, 9);
    } else {
      isSelfClosing = startsWith$4(context.source, "/>");
      if (type === 1 && isSelfClosing) {
        emitError(context, 4);
      }
      advanceBy(context, isSelfClosing ? 2 : 1);
    }
    if (type === 1) {
      return;
    }
    let tagType = 0;
    if (!context.inVPre) {
      if (tag === "slot") {
        tagType = 2;
      } else if (tag === "template") {
        if (props.some(
          (p) => p.type === 7 && isSpecialTemplateDirective(p.name)
        )) {
          tagType = 3;
        }
      } else if (isComponent(tag, props, context)) {
        tagType = 1;
      }
    }
    return {
      type: 1,
      ns,
      tag,
      tagType,
      props,
      isSelfClosing,
      children: [],
      loc: getSelection(context, start),
      codegenNode: void 0
      // to be created during transform phase
    };
  }
  function isComponent(tag, props, context) {
    const options = context.options;
    if (options.isCustomElement(tag)) {
      return false;
    }
    if (tag === "component" || /^[A-Z]/.test(tag) || isCoreComponent(tag) || options.isBuiltInComponent && options.isBuiltInComponent(tag) || options.isNativeTag && !options.isNativeTag(tag)) {
      return true;
    }
    for (let i = 0; i < props.length; i++) {
      const p = props[i];
      if (p.type === 6) {
        if (p.name === "is" && p.value) {
          if (p.value.content.startsWith("vue:")) {
            return true;
          } else if (checkCompatEnabled(
            "COMPILER_IS_ON_ELEMENT",
            context,
            p.loc
          )) {
            return true;
          }
        }
      } else {
        if (p.name === "is") {
          return true;
        } else if (
          // :is on plain element - only treat as component in compat mode
          p.name === "bind" && isStaticArgOf(p.arg, "is") && true && checkCompatEnabled(
            "COMPILER_IS_ON_ELEMENT",
            context,
            p.loc
          )
        ) {
          return true;
        }
      }
    }
  }
  function parseAttributes(context, type) {
    const props = [];
    const attributeNames = /* @__PURE__ */ new Set();
    while (context.source.length > 0 && !startsWith$4(context.source, ">") && !startsWith$4(context.source, "/>")) {
      if (startsWith$4(context.source, "/")) {
        emitError(context, 22);
        advanceBy(context, 1);
        advanceSpaces(context);
        continue;
      }
      if (type === 1) {
        emitError(context, 3);
      }
      const attr = parseAttribute(context, attributeNames);
      if (attr.type === 6 && attr.value && attr.name === "class") {
        attr.value.content = attr.value.content.replace(/\s+/g, " ").trim();
      }
      if (type === 0) {
        props.push(attr);
      }
      if (/^[^\t\r\n\f />]/.test(context.source)) {
        emitError(context, 15);
      }
      advanceSpaces(context);
    }
    return props;
  }
  function parseAttribute(context, nameSet) {
    var _a2;
    const start = getCursor(context);
    const match = /^[^\t\r\n\f />][^\t\r\n\f />=]*/.exec(context.source);
    const name = match[0];
    if (nameSet.has(name)) {
      emitError(context, 2);
    }
    nameSet.add(name);
    if (name[0] === "=") {
      emitError(context, 19);
    }
    {
      const pattern = /["'<]/g;
      let m;
      while (m = pattern.exec(name)) {
        emitError(
          context,
          17,
          m.index
        );
      }
    }
    advanceBy(context, name.length);
    let value = void 0;
    if (/^[\t\r\n\f ]*=/.test(context.source)) {
      advanceSpaces(context);
      advanceBy(context, 1);
      advanceSpaces(context);
      value = parseAttributeValue(context);
      if (!value) {
        emitError(context, 13);
      }
    }
    const loc = getSelection(context, start);
    if (!context.inVPre && /^(v-[A-Za-z0-9-]|:|\.|@|#)/.test(name)) {
      const match2 = /(?:^v-([a-z0-9-]+))?(?:(?::|^\.|^@|^#)(\[[^\]]+\]|[^\.]+))?(.+)?$/i.exec(
        name
      );
      let isPropShorthand = startsWith$4(name, ".");
      let dirName = match2[1] || (isPropShorthand || startsWith$4(name, ":") ? "bind" : startsWith$4(name, "@") ? "on" : "slot");
      let arg;
      if (match2[2]) {
        const isSlot = dirName === "slot";
        const startOffset = name.lastIndexOf(
          match2[2],
          name.length - (((_a2 = match2[3]) == null ? void 0 : _a2.length) || 0)
        );
        const loc2 = getSelection(
          context,
          getNewPosition(context, start, startOffset),
          getNewPosition(
            context,
            start,
            startOffset + match2[2].length + (isSlot && match2[3] || "").length
          )
        );
        let content = match2[2];
        let isStatic2 = true;
        if (content.startsWith("[")) {
          isStatic2 = false;
          if (!content.endsWith("]")) {
            emitError(
              context,
              27
            );
            content = content.slice(1);
          } else {
            content = content.slice(1, content.length - 1);
          }
        } else if (isSlot) {
          content += match2[3] || "";
        }
        arg = {
          type: 4,
          content,
          isStatic: isStatic2,
          constType: isStatic2 ? 3 : 0,
          loc: loc2
        };
      }
      if (value && value.isQuoted) {
        const valueLoc = value.loc;
        valueLoc.start.offset++;
        valueLoc.start.column++;
        valueLoc.end = advancePositionWithClone(valueLoc.start, value.content);
        valueLoc.source = valueLoc.source.slice(1, -1);
      }
      const modifiers2 = match2[3] ? match2[3].slice(1).split(".") : [];
      if (isPropShorthand)
        modifiers2.push("prop");
      if (dirName === "bind" && arg) {
        if (modifiers2.includes("sync") && checkCompatEnabled(
          "COMPILER_V_BIND_SYNC",
          context,
          loc,
          arg.loc.source
        )) {
          dirName = "model";
          modifiers2.splice(modifiers2.indexOf("sync"), 1);
        }
      }
      return {
        type: 7,
        name: dirName,
        exp: value && {
          type: 4,
          content: value.content,
          isStatic: false,
          // Treat as non-constant by default. This can be potentially set to
          // other values by `transformExpression` to make it eligible for hoisting.
          constType: 0,
          loc: value.loc
        },
        arg,
        modifiers: modifiers2,
        loc
      };
    }
    if (!context.inVPre && startsWith$4(name, "v-")) {
      emitError(context, 26);
    }
    return {
      type: 6,
      name,
      value: value && {
        type: 2,
        content: value.content,
        loc: value.loc
      },
      loc
    };
  }
  function parseAttributeValue(context) {
    const start = getCursor(context);
    let content;
    const quote = context.source[0];
    const isQuoted = quote === `"` || quote === `'`;
    if (isQuoted) {
      advanceBy(context, 1);
      const endIndex = context.source.indexOf(quote);
      if (endIndex === -1) {
        content = parseTextData(
          context,
          context.source.length,
          4
        );
      } else {
        content = parseTextData(context, endIndex, 4);
        advanceBy(context, 1);
      }
    } else {
      const match = /^[^\t\r\n\f >]+/.exec(context.source);
      if (!match) {
        return void 0;
      }
      const unexpectedChars = /["'<=`]/g;
      let m;
      while (m = unexpectedChars.exec(match[0])) {
        emitError(
          context,
          18,
          m.index
        );
      }
      content = parseTextData(context, match[0].length, 4);
    }
    return { content, isQuoted, loc: getSelection(context, start) };
  }
  function parseInterpolation(context, mode) {
    const [open, close] = context.options.delimiters;
    const closeIndex = context.source.indexOf(close, open.length);
    if (closeIndex === -1) {
      emitError(context, 25);
      return void 0;
    }
    const start = getCursor(context);
    advanceBy(context, open.length);
    const innerStart = getCursor(context);
    const innerEnd = getCursor(context);
    const rawContentLength = closeIndex - open.length;
    const rawContent = context.source.slice(0, rawContentLength);
    const preTrimContent = parseTextData(context, rawContentLength, mode);
    const content = preTrimContent.trim();
    const startOffset = preTrimContent.indexOf(content);
    if (startOffset > 0) {
      advancePositionWithMutation(innerStart, rawContent, startOffset);
    }
    const endOffset = rawContentLength - (preTrimContent.length - content.length - startOffset);
    advancePositionWithMutation(innerEnd, rawContent, endOffset);
    advanceBy(context, close.length);
    return {
      type: 5,
      content: {
        type: 4,
        isStatic: false,
        // Set `isConstant` to false by default and will decide in transformExpression
        constType: 0,
        content,
        loc: getSelection(context, innerStart, innerEnd)
      },
      loc: getSelection(context, start)
    };
  }
  function parseText$1(context, mode) {
    const endTokens = mode === 3 ? ["]]>"] : ["<", context.options.delimiters[0]];
    let endIndex = context.source.length;
    for (let i = 0; i < endTokens.length; i++) {
      const index2 = context.source.indexOf(endTokens[i], 1);
      if (index2 !== -1 && endIndex > index2) {
        endIndex = index2;
      }
    }
    const start = getCursor(context);
    const content = parseTextData(context, endIndex, mode);
    return {
      type: 2,
      content,
      loc: getSelection(context, start)
    };
  }
  function parseTextData(context, length, mode) {
    const rawText = context.source.slice(0, length);
    advanceBy(context, length);
    if (mode === 2 || mode === 3 || !rawText.includes("&")) {
      return rawText;
    } else {
      return context.options.decodeEntities(
        rawText,
        mode === 4
      );
    }
  }
  function getCursor(context) {
    const { column, line, offset } = context;
    return { column, line, offset };
  }
  function getSelection(context, start, end) {
    end = end || getCursor(context);
    return {
      start,
      end,
      source: context.originalSource.slice(start.offset, end.offset)
    };
  }
  function last$1(xs) {
    return xs[xs.length - 1];
  }
  function startsWith$4(source, searchString) {
    return source.startsWith(searchString);
  }
  function advanceBy(context, numberOfCharacters) {
    const { source } = context;
    advancePositionWithMutation(context, source, numberOfCharacters);
    context.source = source.slice(numberOfCharacters);
  }
  function advanceSpaces(context) {
    const match = /^[\t\r\n\f ]+/.exec(context.source);
    if (match) {
      advanceBy(context, match[0].length);
    }
  }
  function getNewPosition(context, start, numberOfCharacters) {
    return advancePositionWithClone(
      start,
      context.originalSource.slice(start.offset, numberOfCharacters),
      numberOfCharacters
    );
  }
  function emitError(context, code, offset, loc = getCursor(context)) {
    if (offset) {
      loc.offset += offset;
      loc.column += offset;
    }
    context.options.onError(
      createCompilerError(code, {
        start: loc,
        end: loc,
        source: ""
      })
    );
  }
  function isEnd(context, mode, ancestors) {
    const s = context.source;
    switch (mode) {
      case 0:
        if (startsWith$4(s, "</")) {
          for (let i = ancestors.length - 1; i >= 0; --i) {
            if (startsWithEndTagOpen(s, ancestors[i].tag)) {
              return true;
            }
          }
        }
        break;
      case 1:
      case 2: {
        const parent = last$1(ancestors);
        if (parent && startsWithEndTagOpen(s, parent.tag)) {
          return true;
        }
        break;
      }
      case 3:
        if (startsWith$4(s, "]]>")) {
          return true;
        }
        break;
    }
    return !s;
  }
  function startsWithEndTagOpen(source, tag) {
    return startsWith$4(source, "</") && source.slice(2, 2 + tag.length).toLowerCase() === tag.toLowerCase() && /[\t\r\n\f />]/.test(source[2 + tag.length] || ">");
  }
  function hoistStatic(root, context) {
    walk$1(
      root,
      context,
      // Root node is unfortunately non-hoistable due to potential parent
      // fallthrough attributes.
      isSingleElementRoot(root, root.children[0])
    );
  }
  function isSingleElementRoot(root, child) {
    const { children } = root;
    return children.length === 1 && child.type === 1 && !isSlotOutlet(child);
  }
  function walk$1(node, context, doNotHoistNode = false) {
    const { children } = node;
    const originalCount = children.length;
    let hoistedCount = 0;
    for (let i = 0; i < children.length; i++) {
      const child = children[i];
      if (child.type === 1 && child.tagType === 0) {
        const constantType = doNotHoistNode ? 0 : getConstantType(child, context);
        if (constantType > 0) {
          if (constantType >= 2) {
            child.codegenNode.patchFlag = `-1`;
            child.codegenNode = context.hoist(child.codegenNode);
            hoistedCount++;
            continue;
          }
        } else {
          const codegenNode = child.codegenNode;
          if (codegenNode.type === 13) {
            const flag = getPatchFlag(codegenNode);
            if ((!flag || flag === 512 || flag === 1) && getGeneratedPropsConstantType(child, context) >= 2) {
              const props = getNodeProps(child);
              if (props) {
                codegenNode.props = context.hoist(props);
              }
            }
            if (codegenNode.dynamicProps) {
              codegenNode.dynamicProps = context.hoist(codegenNode.dynamicProps);
            }
          }
        }
      }
      if (child.type === 1) {
        const isComponent2 = child.tagType === 1;
        if (isComponent2) {
          context.scopes.vSlot++;
        }
        walk$1(child, context);
        if (isComponent2) {
          context.scopes.vSlot--;
        }
      } else if (child.type === 11) {
        walk$1(child, context, child.children.length === 1);
      } else if (child.type === 9) {
        for (let i2 = 0; i2 < child.branches.length; i2++) {
          walk$1(
            child.branches[i2],
            context,
            child.branches[i2].children.length === 1
          );
        }
      }
    }
    if (hoistedCount && context.transformHoist) {
      context.transformHoist(children, context, node);
    }
    if (hoistedCount && hoistedCount === originalCount && node.type === 1 && node.tagType === 0 && node.codegenNode && node.codegenNode.type === 13 && isArray$2(node.codegenNode.children)) {
      node.codegenNode.children = context.hoist(
        createArrayExpression(node.codegenNode.children)
      );
    }
  }
  function getConstantType(node, context) {
    const { constantCache } = context;
    switch (node.type) {
      case 1:
        if (node.tagType !== 0) {
          return 0;
        }
        const cached2 = constantCache.get(node);
        if (cached2 !== void 0) {
          return cached2;
        }
        const codegenNode = node.codegenNode;
        if (codegenNode.type !== 13) {
          return 0;
        }
        if (codegenNode.isBlock && node.tag !== "svg" && node.tag !== "foreignObject") {
          return 0;
        }
        const flag = getPatchFlag(codegenNode);
        if (!flag) {
          let returnType2 = 3;
          const generatedPropsType = getGeneratedPropsConstantType(node, context);
          if (generatedPropsType === 0) {
            constantCache.set(node, 0);
            return 0;
          }
          if (generatedPropsType < returnType2) {
            returnType2 = generatedPropsType;
          }
          for (let i = 0; i < node.children.length; i++) {
            const childType = getConstantType(node.children[i], context);
            if (childType === 0) {
              constantCache.set(node, 0);
              return 0;
            }
            if (childType < returnType2) {
              returnType2 = childType;
            }
          }
          if (returnType2 > 1) {
            for (let i = 0; i < node.props.length; i++) {
              const p = node.props[i];
              if (p.type === 7 && p.name === "bind" && p.exp) {
                const expType = getConstantType(p.exp, context);
                if (expType === 0) {
                  constantCache.set(node, 0);
                  return 0;
                }
                if (expType < returnType2) {
                  returnType2 = expType;
                }
              }
            }
          }
          if (codegenNode.isBlock) {
            for (let i = 0; i < node.props.length; i++) {
              const p = node.props[i];
              if (p.type === 7) {
                constantCache.set(node, 0);
                return 0;
              }
            }
            context.removeHelper(OPEN_BLOCK);
            context.removeHelper(
              getVNodeBlockHelper(context.inSSR, codegenNode.isComponent)
            );
            codegenNode.isBlock = false;
            context.helper(getVNodeHelper(context.inSSR, codegenNode.isComponent));
          }
          constantCache.set(node, returnType2);
          return returnType2;
        } else {
          constantCache.set(node, 0);
          return 0;
        }
      case 2:
      case 3:
        return 3;
      case 9:
      case 11:
      case 10:
        return 0;
      case 5:
      case 12:
        return getConstantType(node.content, context);
      case 4:
        return node.constType;
      case 8:
        let returnType = 3;
        for (let i = 0; i < node.children.length; i++) {
          const child = node.children[i];
          if (isString$1(child) || isSymbol(child)) {
            continue;
          }
          const childType = getConstantType(child, context);
          if (childType === 0) {
            return 0;
          } else if (childType < returnType) {
            returnType = childType;
          }
        }
        return returnType;
      default:
        return 0;
    }
  }
  const allowHoistedHelperSet = /* @__PURE__ */ new Set([
    NORMALIZE_CLASS,
    NORMALIZE_STYLE,
    NORMALIZE_PROPS,
    GUARD_REACTIVE_PROPS
  ]);
  function getConstantTypeOfHelperCall(value, context) {
    if (value.type === 14 && !isString$1(value.callee) && allowHoistedHelperSet.has(value.callee)) {
      const arg = value.arguments[0];
      if (arg.type === 4) {
        return getConstantType(arg, context);
      } else if (arg.type === 14) {
        return getConstantTypeOfHelperCall(arg, context);
      }
    }
    return 0;
  }
  function getGeneratedPropsConstantType(node, context) {
    let returnType = 3;
    const props = getNodeProps(node);
    if (props && props.type === 15) {
      const { properties } = props;
      for (let i = 0; i < properties.length; i++) {
        const { key, value } = properties[i];
        const keyType = getConstantType(key, context);
        if (keyType === 0) {
          return keyType;
        }
        if (keyType < returnType) {
          returnType = keyType;
        }
        let valueType;
        if (value.type === 4) {
          valueType = getConstantType(value, context);
        } else if (value.type === 14) {
          valueType = getConstantTypeOfHelperCall(value, context);
        } else {
          valueType = 0;
        }
        if (valueType === 0) {
          return valueType;
        }
        if (valueType < returnType) {
          returnType = valueType;
        }
      }
    }
    return returnType;
  }
  function getNodeProps(node) {
    const codegenNode = node.codegenNode;
    if (codegenNode.type === 13) {
      return codegenNode.props;
    }
  }
  function getPatchFlag(node) {
    const flag = node.patchFlag;
    return flag ? parseInt(flag, 10) : void 0;
  }
  function createTransformContext(root, {
    filename = "",
    prefixIdentifiers = false,
    hoistStatic: hoistStatic2 = false,
    cacheHandlers = false,
    nodeTransforms = [],
    directiveTransforms = {},
    transformHoist = null,
    isBuiltInComponent = NOOP,
    isCustomElement = NOOP,
    expressionPlugins = [],
    scopeId = null,
    slotted = true,
    ssr = false,
    inSSR = false,
    ssrCssVars = ``,
    bindingMetadata = EMPTY_OBJ,
    inline = false,
    isTS = false,
    onError = defaultOnError,
    onWarn = defaultOnWarn,
    compatConfig
  }) {
    const nameMatch = filename.replace(/\?.*$/, "").match(/([^/\\]+)\.\w+$/);
    const context = {
      // options
      selfName: nameMatch && capitalize$1(camelize$1(nameMatch[1])),
      prefixIdentifiers,
      hoistStatic: hoistStatic2,
      cacheHandlers,
      nodeTransforms,
      directiveTransforms,
      transformHoist,
      isBuiltInComponent,
      isCustomElement,
      expressionPlugins,
      scopeId,
      slotted,
      ssr,
      inSSR,
      ssrCssVars,
      bindingMetadata,
      inline,
      isTS,
      onError,
      onWarn,
      compatConfig,
      // state
      root,
      helpers: /* @__PURE__ */ new Map(),
      components: /* @__PURE__ */ new Set(),
      directives: /* @__PURE__ */ new Set(),
      hoists: [],
      imports: [],
      constantCache: /* @__PURE__ */ new Map(),
      temps: 0,
      cached: 0,
      identifiers: /* @__PURE__ */ Object.create(null),
      scopes: {
        vFor: 0,
        vSlot: 0,
        vPre: 0,
        vOnce: 0
      },
      parent: null,
      currentNode: root,
      childIndex: 0,
      inVOnce: false,
      // methods
      helper(name) {
        const count2 = context.helpers.get(name) || 0;
        context.helpers.set(name, count2 + 1);
        return name;
      },
      removeHelper(name) {
        const count2 = context.helpers.get(name);
        if (count2) {
          const currentCount = count2 - 1;
          if (!currentCount) {
            context.helpers.delete(name);
          } else {
            context.helpers.set(name, currentCount);
          }
        }
      },
      helperString(name) {
        return `_${helperNameMap[context.helper(name)]}`;
      },
      replaceNode(node) {
        context.parent.children[context.childIndex] = context.currentNode = node;
      },
      removeNode(node) {
        const list = context.parent.children;
        const removalIndex = node ? list.indexOf(node) : context.currentNode ? context.childIndex : -1;
        if (!node || node === context.currentNode) {
          context.currentNode = null;
          context.onNodeRemoved();
        } else {
          if (context.childIndex > removalIndex) {
            context.childIndex--;
            context.onNodeRemoved();
          }
        }
        context.parent.children.splice(removalIndex, 1);
      },
      onNodeRemoved: () => {
      },
      addIdentifiers(exp) {
      },
      removeIdentifiers(exp) {
      },
      hoist(exp) {
        if (isString$1(exp))
          exp = createSimpleExpression(exp);
        context.hoists.push(exp);
        const identifier = createSimpleExpression(
          `_hoisted_${context.hoists.length}`,
          false,
          exp.loc,
          2
        );
        identifier.hoisted = exp;
        return identifier;
      },
      cache(exp, isVNode = false) {
        return createCacheExpression(context.cached++, exp, isVNode);
      }
    };
    {
      context.filters = /* @__PURE__ */ new Set();
    }
    return context;
  }
  function transform$1(root, options) {
    const context = createTransformContext(root, options);
    traverseNode(root, context);
    if (options.hoistStatic) {
      hoistStatic(root, context);
    }
    if (!options.ssr) {
      createRootCodegen(root, context);
    }
    root.helpers = /* @__PURE__ */ new Set([...context.helpers.keys()]);
    root.components = [...context.components];
    root.directives = [...context.directives];
    root.imports = context.imports;
    root.hoists = context.hoists;
    root.temps = context.temps;
    root.cached = context.cached;
    {
      root.filters = [...context.filters];
    }
  }
  function createRootCodegen(root, context) {
    const { helper } = context;
    const { children } = root;
    if (children.length === 1) {
      const child = children[0];
      if (isSingleElementRoot(root, child) && child.codegenNode) {
        const codegenNode = child.codegenNode;
        if (codegenNode.type === 13) {
          convertToBlock(codegenNode, context);
        }
        root.codegenNode = codegenNode;
      } else {
        root.codegenNode = child;
      }
    } else if (children.length > 1) {
      let patchFlag = 64;
      PatchFlagNames[64];
      root.codegenNode = createVNodeCall(
        context,
        helper(FRAGMENT),
        void 0,
        root.children,
        patchFlag + ``,
        void 0,
        void 0,
        true,
        void 0,
        false
        /* isComponent */
      );
    } else
      ;
  }
  function traverseChildren(parent, context) {
    let i = 0;
    const nodeRemoved = () => {
      i--;
    };
    for (; i < parent.children.length; i++) {
      const child = parent.children[i];
      if (isString$1(child))
        continue;
      context.parent = parent;
      context.childIndex = i;
      context.onNodeRemoved = nodeRemoved;
      traverseNode(child, context);
    }
  }
  function traverseNode(node, context) {
    context.currentNode = node;
    const { nodeTransforms } = context;
    const exitFns = [];
    for (let i2 = 0; i2 < nodeTransforms.length; i2++) {
      const onExit = nodeTransforms[i2](node, context);
      if (onExit) {
        if (isArray$2(onExit)) {
          exitFns.push(...onExit);
        } else {
          exitFns.push(onExit);
        }
      }
      if (!context.currentNode) {
        return;
      } else {
        node = context.currentNode;
      }
    }
    switch (node.type) {
      case 3:
        if (!context.ssr) {
          context.helper(CREATE_COMMENT);
        }
        break;
      case 5:
        if (!context.ssr) {
          context.helper(TO_DISPLAY_STRING);
        }
        break;
      case 9:
        for (let i2 = 0; i2 < node.branches.length; i2++) {
          traverseNode(node.branches[i2], context);
        }
        break;
      case 10:
      case 11:
      case 1:
      case 0:
        traverseChildren(node, context);
        break;
    }
    context.currentNode = node;
    let i = exitFns.length;
    while (i--) {
      exitFns[i]();
    }
  }
  function createStructuralDirectiveTransform(name, fn) {
    const matches2 = isString$1(name) ? (n) => n === name : (n) => name.test(n);
    return (node, context) => {
      if (node.type === 1) {
        const { props } = node;
        if (node.tagType === 3 && props.some(isVSlot)) {
          return;
        }
        const exitFns = [];
        for (let i = 0; i < props.length; i++) {
          const prop = props[i];
          if (prop.type === 7 && matches2(prop.name)) {
            props.splice(i, 1);
            i--;
            const onExit = fn(node, prop, context);
            if (onExit)
              exitFns.push(onExit);
          }
        }
        return exitFns;
      }
    };
  }
  const PURE_ANNOTATION = `/*#__PURE__*/`;
  const aliasHelper = (s) => `${helperNameMap[s]}: _${helperNameMap[s]}`;
  function createCodegenContext(ast2, {
    mode = "function",
    prefixIdentifiers = mode === "module",
    sourceMap = false,
    filename = `template.vue.html`,
    scopeId = null,
    optimizeImports = false,
    runtimeGlobalName = `Vue`,
    runtimeModuleName = `vue`,
    ssrRuntimeModuleName = "vue/server-renderer",
    ssr = false,
    isTS = false,
    inSSR = false
  }) {
    const context = {
      mode,
      prefixIdentifiers,
      sourceMap,
      filename,
      scopeId,
      optimizeImports,
      runtimeGlobalName,
      runtimeModuleName,
      ssrRuntimeModuleName,
      ssr,
      isTS,
      inSSR,
      source: ast2.loc.source,
      code: ``,
      column: 1,
      line: 1,
      offset: 0,
      indentLevel: 0,
      pure: false,
      map: void 0,
      helper(key) {
        return `_${helperNameMap[key]}`;
      },
      push(code, node) {
        context.code += code;
      },
      indent() {
        newline(++context.indentLevel);
      },
      deindent(withoutNewLine = false) {
        if (withoutNewLine) {
          --context.indentLevel;
        } else {
          newline(--context.indentLevel);
        }
      },
      newline() {
        newline(context.indentLevel);
      }
    };
    function newline(n) {
      context.push("\n" + `  `.repeat(n));
    }
    return context;
  }
  function generate$4(ast2, options = {}) {
    const context = createCodegenContext(ast2, options);
    if (options.onContextCreated)
      options.onContextCreated(context);
    const {
      mode,
      push: push2,
      prefixIdentifiers,
      indent,
      deindent: deindent2,
      newline,
      scopeId,
      ssr
    } = context;
    const helpers2 = Array.from(ast2.helpers);
    const hasHelpers = helpers2.length > 0;
    const useWithBlock = !prefixIdentifiers && mode !== "module";
    const isSetupInlined = false;
    const preambleContext = isSetupInlined ? createCodegenContext(ast2, options) : context;
    {
      genFunctionPreamble(ast2, preambleContext);
    }
    const functionName = ssr ? `ssrRender` : `render`;
    const args = ssr ? ["_ctx", "_push", "_parent", "_attrs"] : ["_ctx", "_cache"];
    const signature = args.join(", ");
    {
      push2(`function ${functionName}(${signature}) {`);
    }
    indent();
    if (useWithBlock) {
      push2(`with (_ctx) {`);
      indent();
      if (hasHelpers) {
        push2(`const { ${helpers2.map(aliasHelper).join(", ")} } = _Vue`);
        push2(`
`);
        newline();
      }
    }
    if (ast2.components.length) {
      genAssets(ast2.components, "component", context);
      if (ast2.directives.length || ast2.temps > 0) {
        newline();
      }
    }
    if (ast2.directives.length) {
      genAssets(ast2.directives, "directive", context);
      if (ast2.temps > 0) {
        newline();
      }
    }
    if (ast2.filters && ast2.filters.length) {
      newline();
      genAssets(ast2.filters, "filter", context);
      newline();
    }
    if (ast2.temps > 0) {
      push2(`let `);
      for (let i = 0; i < ast2.temps; i++) {
        push2(`${i > 0 ? `, ` : ``}_temp${i}`);
      }
    }
    if (ast2.components.length || ast2.directives.length || ast2.temps) {
      push2(`
`);
      newline();
    }
    if (!ssr) {
      push2(`return `);
    }
    if (ast2.codegenNode) {
      genNode$1(ast2.codegenNode, context);
    } else {
      push2(`null`);
    }
    if (useWithBlock) {
      deindent2();
      push2(`}`);
    }
    deindent2();
    push2(`}`);
    return {
      ast: ast2,
      code: context.code,
      preamble: isSetupInlined ? preambleContext.code : ``,
      // SourceMapGenerator does have toJSON() method but it's not in the types
      map: context.map ? context.map.toJSON() : void 0
    };
  }
  function genFunctionPreamble(ast2, context) {
    const {
      ssr,
      prefixIdentifiers,
      push: push2,
      newline,
      runtimeModuleName,
      runtimeGlobalName,
      ssrRuntimeModuleName
    } = context;
    const VueBinding = runtimeGlobalName;
    const helpers2 = Array.from(ast2.helpers);
    if (helpers2.length > 0) {
      {
        push2(`const _Vue = ${VueBinding}
`);
        if (ast2.hoists.length) {
          const staticHelpers = [
            CREATE_VNODE,
            CREATE_ELEMENT_VNODE,
            CREATE_COMMENT,
            CREATE_TEXT,
            CREATE_STATIC
          ].filter((helper) => helpers2.includes(helper)).map(aliasHelper).join(", ");
          push2(`const { ${staticHelpers} } = _Vue
`);
        }
      }
    }
    genHoists(ast2.hoists, context);
    newline();
    push2(`return `);
  }
  function genAssets(assets, type, { helper, push: push2, newline, isTS }) {
    const resolver = helper(
      type === "filter" ? RESOLVE_FILTER : type === "component" ? RESOLVE_COMPONENT : RESOLVE_DIRECTIVE
    );
    for (let i = 0; i < assets.length; i++) {
      let id = assets[i];
      const maybeSelfReference = id.endsWith("__self");
      if (maybeSelfReference) {
        id = id.slice(0, -6);
      }
      push2(
        `const ${toValidAssetId(id, type)} = ${resolver}(${JSON.stringify(id)}${maybeSelfReference ? `, true` : ``})${isTS ? `!` : ``}`
      );
      if (i < assets.length - 1) {
        newline();
      }
    }
  }
  function genHoists(hoists, context) {
    if (!hoists.length) {
      return;
    }
    context.pure = true;
    const { push: push2, newline, helper, scopeId, mode } = context;
    newline();
    for (let i = 0; i < hoists.length; i++) {
      const exp = hoists[i];
      if (exp) {
        push2(
          `const _hoisted_${i + 1} = ${``}`
        );
        genNode$1(exp, context);
        newline();
      }
    }
    context.pure = false;
  }
  function genNodeListAsArray(nodes, context) {
    const multilines = nodes.length > 3 || false;
    context.push(`[`);
    multilines && context.indent();
    genNodeList(nodes, context, multilines);
    multilines && context.deindent();
    context.push(`]`);
  }
  function genNodeList(nodes, context, multilines = false, comma = true) {
    const { push: push2, newline } = context;
    for (let i = 0; i < nodes.length; i++) {
      const node = nodes[i];
      if (isString$1(node)) {
        push2(node);
      } else if (isArray$2(node)) {
        genNodeListAsArray(node, context);
      } else {
        genNode$1(node, context);
      }
      if (i < nodes.length - 1) {
        if (multilines) {
          comma && push2(",");
          newline();
        } else {
          comma && push2(", ");
        }
      }
    }
  }
  function genNode$1(node, context) {
    if (isString$1(node)) {
      context.push(node);
      return;
    }
    if (isSymbol(node)) {
      context.push(context.helper(node));
      return;
    }
    switch (node.type) {
      case 1:
      case 9:
      case 11:
        genNode$1(node.codegenNode, context);
        break;
      case 2:
        genText$1(node, context);
        break;
      case 4:
        genExpression(node, context);
        break;
      case 5:
        genInterpolation(node, context);
        break;
      case 12:
        genNode$1(node.codegenNode, context);
        break;
      case 8:
        genCompoundExpression(node, context);
        break;
      case 3:
        genComment$1(node, context);
        break;
      case 13:
        genVNodeCall(node, context);
        break;
      case 14:
        genCallExpression(node, context);
        break;
      case 15:
        genObjectExpression(node, context);
        break;
      case 17:
        genArrayExpression(node, context);
        break;
      case 18:
        genFunctionExpression(node, context);
        break;
      case 19:
        genConditionalExpression(node, context);
        break;
      case 20:
        genCacheExpression(node, context);
        break;
      case 21:
        genNodeList(node.body, context, true, false);
        break;
    }
  }
  function genText$1(node, context) {
    context.push(JSON.stringify(node.content), node);
  }
  function genExpression(node, context) {
    const { content, isStatic: isStatic2 } = node;
    context.push(isStatic2 ? JSON.stringify(content) : content, node);
  }
  function genInterpolation(node, context) {
    const { push: push2, helper, pure } = context;
    if (pure)
      push2(PURE_ANNOTATION);
    push2(`${helper(TO_DISPLAY_STRING)}(`);
    genNode$1(node.content, context);
    push2(`)`);
  }
  function genCompoundExpression(node, context) {
    for (let i = 0; i < node.children.length; i++) {
      const child = node.children[i];
      if (isString$1(child)) {
        context.push(child);
      } else {
        genNode$1(child, context);
      }
    }
  }
  function genExpressionAsPropertyKey(node, context) {
    const { push: push2 } = context;
    if (node.type === 8) {
      push2(`[`);
      genCompoundExpression(node, context);
      push2(`]`);
    } else if (node.isStatic) {
      const text2 = isSimpleIdentifier(node.content) ? node.content : JSON.stringify(node.content);
      push2(text2, node);
    } else {
      push2(`[${node.content}]`, node);
    }
  }
  function genComment$1(node, context) {
    const { push: push2, helper, pure } = context;
    if (pure) {
      push2(PURE_ANNOTATION);
    }
    push2(`${helper(CREATE_COMMENT)}(${JSON.stringify(node.content)})`, node);
  }
  function genVNodeCall(node, context) {
    const { push: push2, helper, pure } = context;
    const {
      tag,
      props,
      children,
      patchFlag,
      dynamicProps,
      directives: directives2,
      isBlock,
      disableTracking,
      isComponent: isComponent2
    } = node;
    if (directives2) {
      push2(helper(WITH_DIRECTIVES) + `(`);
    }
    if (isBlock) {
      push2(`(${helper(OPEN_BLOCK)}(${disableTracking ? `true` : ``}), `);
    }
    if (pure) {
      push2(PURE_ANNOTATION);
    }
    const callHelper = isBlock ? getVNodeBlockHelper(context.inSSR, isComponent2) : getVNodeHelper(context.inSSR, isComponent2);
    push2(helper(callHelper) + `(`, node);
    genNodeList(
      genNullableArgs([tag, props, children, patchFlag, dynamicProps]),
      context
    );
    push2(`)`);
    if (isBlock) {
      push2(`)`);
    }
    if (directives2) {
      push2(`, `);
      genNode$1(directives2, context);
      push2(`)`);
    }
  }
  function genNullableArgs(args) {
    let i = args.length;
    while (i--) {
      if (args[i] != null)
        break;
    }
    return args.slice(0, i + 1).map((arg) => arg || `null`);
  }
  function genCallExpression(node, context) {
    const { push: push2, helper, pure } = context;
    const callee = isString$1(node.callee) ? node.callee : helper(node.callee);
    if (pure) {
      push2(PURE_ANNOTATION);
    }
    push2(callee + `(`, node);
    genNodeList(node.arguments, context);
    push2(`)`);
  }
  function genObjectExpression(node, context) {
    const { push: push2, indent, deindent: deindent2, newline } = context;
    const { properties } = node;
    if (!properties.length) {
      push2(`{}`, node);
      return;
    }
    const multilines = properties.length > 1 || false;
    push2(multilines ? `{` : `{ `);
    multilines && indent();
    for (let i = 0; i < properties.length; i++) {
      const { key, value } = properties[i];
      genExpressionAsPropertyKey(key, context);
      push2(`: `);
      genNode$1(value, context);
      if (i < properties.length - 1) {
        push2(`,`);
        newline();
      }
    }
    multilines && deindent2();
    push2(multilines ? `}` : ` }`);
  }
  function genArrayExpression(node, context) {
    genNodeListAsArray(node.elements, context);
  }
  function genFunctionExpression(node, context) {
    const { push: push2, indent, deindent: deindent2 } = context;
    const { params, returns, body, newline, isSlot } = node;
    if (isSlot) {
      push2(`_${helperNameMap[WITH_CTX]}(`);
    }
    push2(`(`, node);
    if (isArray$2(params)) {
      genNodeList(params, context);
    } else if (params) {
      genNode$1(params, context);
    }
    push2(`) => `);
    if (newline || body) {
      push2(`{`);
      indent();
    }
    if (returns) {
      if (newline) {
        push2(`return `);
      }
      if (isArray$2(returns)) {
        genNodeListAsArray(returns, context);
      } else {
        genNode$1(returns, context);
      }
    } else if (body) {
      genNode$1(body, context);
    }
    if (newline || body) {
      deindent2();
      push2(`}`);
    }
    if (isSlot) {
      if (node.isNonScopedSlot) {
        push2(`, undefined, true`);
      }
      push2(`)`);
    }
  }
  function genConditionalExpression(node, context) {
    const { test, consequent, alternate, newline: needNewline } = node;
    const { push: push2, indent, deindent: deindent2, newline } = context;
    if (test.type === 4) {
      const needsParens = !isSimpleIdentifier(test.content);
      needsParens && push2(`(`);
      genExpression(test, context);
      needsParens && push2(`)`);
    } else {
      push2(`(`);
      genNode$1(test, context);
      push2(`)`);
    }
    needNewline && indent();
    context.indentLevel++;
    needNewline || push2(` `);
    push2(`? `);
    genNode$1(consequent, context);
    context.indentLevel--;
    needNewline && newline();
    needNewline || push2(` `);
    push2(`: `);
    const isNested = alternate.type === 19;
    if (!isNested) {
      context.indentLevel++;
    }
    genNode$1(alternate, context);
    if (!isNested) {
      context.indentLevel--;
    }
    needNewline && deindent2(
      true
      /* without newline */
    );
  }
  function genCacheExpression(node, context) {
    const { push: push2, helper, indent, deindent: deindent2, newline } = context;
    push2(`_cache[${node.index}] || (`);
    if (node.isVNode) {
      indent();
      push2(`${helper(SET_BLOCK_TRACKING)}(-1),`);
      newline();
    }
    push2(`_cache[${node.index}] = `);
    genNode$1(node.value, context);
    if (node.isVNode) {
      push2(`,`);
      newline();
      push2(`${helper(SET_BLOCK_TRACKING)}(1),`);
      newline();
      push2(`_cache[${node.index}]`);
      deindent2();
    }
    push2(`)`);
  }
  function walkIdentifiers$1(root, onIdentifier, includeAll = false, parentStack = [], knownIds = /* @__PURE__ */ Object.create(null)) {
    {
      return;
    }
  }
  function isReferencedIdentifier(id, parent, parentStack) {
    {
      return false;
    }
  }
  function isInDestructureAssignment(parent, parentStack) {
    if (parent && (parent.type === "ObjectProperty" || parent.type === "ArrayPattern")) {
      let i = parentStack.length;
      while (i--) {
        const p = parentStack[i];
        if (p.type === "AssignmentExpression") {
          return true;
        } else if (p.type !== "ObjectProperty" && !p.type.endsWith("Pattern")) {
          break;
        }
      }
    }
    return false;
  }
  function walkFunctionParams(node, onIdent) {
    for (const p of node.params) {
      for (const id of extractIdentifiers(p)) {
        onIdent(id);
      }
    }
  }
  function walkBlockDeclarations(block, onIdent) {
    for (const stmt of block.body) {
      if (stmt.type === "VariableDeclaration") {
        if (stmt.declare)
          continue;
        for (const decl of stmt.declarations) {
          for (const id of extractIdentifiers(decl.id)) {
            onIdent(id);
          }
        }
      } else if (stmt.type === "FunctionDeclaration" || stmt.type === "ClassDeclaration") {
        if (stmt.declare || !stmt.id)
          continue;
        onIdent(stmt.id);
      }
    }
  }
  function extractIdentifiers(param, nodes = []) {
    switch (param.type) {
      case "Identifier":
        nodes.push(param);
        break;
      case "MemberExpression":
        let object = param;
        while (object.type === "MemberExpression") {
          object = object.object;
        }
        nodes.push(object);
        break;
      case "ObjectPattern":
        for (const prop of param.properties) {
          if (prop.type === "RestElement") {
            extractIdentifiers(prop.argument, nodes);
          } else {
            extractIdentifiers(prop.value, nodes);
          }
        }
        break;
      case "ArrayPattern":
        param.elements.forEach((element) => {
          if (element)
            extractIdentifiers(element, nodes);
        });
        break;
      case "RestElement":
        extractIdentifiers(param.argument, nodes);
        break;
      case "AssignmentPattern":
        extractIdentifiers(param.left, nodes);
        break;
    }
    return nodes;
  }
  const isFunctionType = (node) => {
    return /Function(?:Expression|Declaration)$|Method$/.test(node.type);
  };
  const isStaticProperty = (node) => node && (node.type === "ObjectProperty" || node.type === "ObjectMethod") && !node.computed;
  const isStaticPropertyKey = (node, parent) => isStaticProperty(parent) && parent.key === node;
  const TS_NODE_TYPES = [
    "TSAsExpression",
    // foo as number
    "TSTypeAssertion",
    // (<number>foo)
    "TSNonNullExpression",
    // foo!
    "TSInstantiationExpression",
    // foo<string>
    "TSSatisfiesExpression"
    // foo satisfies T
  ];
  new RegExp(
    "\\b" + "arguments,await,break,case,catch,class,const,continue,debugger,default,delete,do,else,export,extends,finally,for,function,if,import,let,new,return,super,switch,throw,try,var,void,while,with,yield".split(",").join("\\b|\\b") + "\\b"
  );
  const transformExpression = (node, context) => {
    if (node.type === 5) {
      node.content = processExpression(
        node.content,
        context
      );
    } else if (node.type === 1) {
      for (let i = 0; i < node.props.length; i++) {
        const dir = node.props[i];
        if (dir.type === 7 && dir.name !== "for") {
          const exp = dir.exp;
          const arg = dir.arg;
          if (exp && exp.type === 4 && !(dir.name === "on" && arg)) {
            dir.exp = processExpression(
              exp,
              context,
              // slot args must be processed as function params
              dir.name === "slot"
            );
          }
          if (arg && arg.type === 4 && !arg.isStatic) {
            dir.arg = processExpression(arg, context);
          }
        }
      }
    }
  };
  function processExpression(node, context, asParams = false, asRawStatements = false, localVars = Object.create(context.identifiers)) {
    {
      return node;
    }
  }
  function stringifyExpression(exp) {
    if (isString$1(exp)) {
      return exp;
    } else if (exp.type === 4) {
      return exp.content;
    } else {
      return exp.children.map(stringifyExpression).join("");
    }
  }
  const transformIf = createStructuralDirectiveTransform(
    /^(if|else|else-if)$/,
    (node, dir, context) => {
      return processIf$1(node, dir, context, (ifNode, branch, isRoot) => {
        const siblings = context.parent.children;
        let i = siblings.indexOf(ifNode);
        let key = 0;
        while (i-- >= 0) {
          const sibling = siblings[i];
          if (sibling && sibling.type === 9) {
            key += sibling.branches.length;
          }
        }
        return () => {
          if (isRoot) {
            ifNode.codegenNode = createCodegenNodeForBranch(
              branch,
              key,
              context
            );
          } else {
            const parentCondition = getParentCondition(ifNode.codegenNode);
            parentCondition.alternate = createCodegenNodeForBranch(
              branch,
              key + ifNode.branches.length - 1,
              context
            );
          }
        };
      });
    }
  );
  function processIf$1(node, dir, context, processCodegen) {
    if (dir.name !== "else" && (!dir.exp || !dir.exp.content.trim())) {
      const loc = dir.exp ? dir.exp.loc : node.loc;
      context.onError(
        createCompilerError(28, dir.loc)
      );
      dir.exp = createSimpleExpression(`true`, false, loc);
    }
    if (dir.name === "if") {
      const branch = createIfBranch(node, dir);
      const ifNode = {
        type: 9,
        loc: node.loc,
        branches: [branch]
      };
      context.replaceNode(ifNode);
      if (processCodegen) {
        return processCodegen(ifNode, branch, true);
      }
    } else {
      const siblings = context.parent.children;
      let i = siblings.indexOf(node);
      while (i-- >= -1) {
        const sibling = siblings[i];
        if (sibling && sibling.type === 3) {
          context.removeNode(sibling);
          continue;
        }
        if (sibling && sibling.type === 2 && !sibling.content.trim().length) {
          context.removeNode(sibling);
          continue;
        }
        if (sibling && sibling.type === 9) {
          if (dir.name === "else-if" && sibling.branches[sibling.branches.length - 1].condition === void 0) {
            context.onError(
              createCompilerError(30, node.loc)
            );
          }
          context.removeNode();
          const branch = createIfBranch(node, dir);
          sibling.branches.push(branch);
          const onExit = processCodegen && processCodegen(sibling, branch, false);
          traverseNode(branch, context);
          if (onExit)
            onExit();
          context.currentNode = null;
        } else {
          context.onError(
            createCompilerError(30, node.loc)
          );
        }
        break;
      }
    }
  }
  function createIfBranch(node, dir) {
    const isTemplateIf = node.tagType === 3;
    return {
      type: 10,
      loc: node.loc,
      condition: dir.name === "else" ? void 0 : dir.exp,
      children: isTemplateIf && !findDir(node, "for") ? node.children : [node],
      userKey: findProp(node, `key`),
      isTemplateIf
    };
  }
  function createCodegenNodeForBranch(branch, keyIndex, context) {
    if (branch.condition) {
      return createConditionalExpression(
        branch.condition,
        createChildrenCodegenNode(branch, keyIndex, context),
        // make sure to pass in asBlock: true so that the comment node call
        // closes the current block.
        createCallExpression(context.helper(CREATE_COMMENT), [
          '""',
          "true"
        ])
      );
    } else {
      return createChildrenCodegenNode(branch, keyIndex, context);
    }
  }
  function createChildrenCodegenNode(branch, keyIndex, context) {
    const { helper } = context;
    const keyProperty = createObjectProperty(
      `key`,
      createSimpleExpression(
        `${keyIndex}`,
        false,
        locStub,
        2
      )
    );
    const { children } = branch;
    const firstChild = children[0];
    const needFragmentWrapper = children.length !== 1 || firstChild.type !== 1;
    if (needFragmentWrapper) {
      if (children.length === 1 && firstChild.type === 11) {
        const vnodeCall = firstChild.codegenNode;
        injectProp(vnodeCall, keyProperty, context);
        return vnodeCall;
      } else {
        let patchFlag = 64;
        PatchFlagNames[64];
        return createVNodeCall(
          context,
          helper(FRAGMENT),
          createObjectExpression([keyProperty]),
          children,
          patchFlag + ``,
          void 0,
          void 0,
          true,
          false,
          false,
          branch.loc
        );
      }
    } else {
      const ret = firstChild.codegenNode;
      const vnodeCall = getMemoedVNodeCall(ret);
      if (vnodeCall.type === 13) {
        convertToBlock(vnodeCall, context);
      }
      injectProp(vnodeCall, keyProperty, context);
      return ret;
    }
  }
  function getParentCondition(node) {
    while (true) {
      if (node.type === 19) {
        if (node.alternate.type === 19) {
          node = node.alternate;
        } else {
          return node;
        }
      } else if (node.type === 20) {
        node = node.value;
      }
    }
  }
  const transformFor = createStructuralDirectiveTransform(
    "for",
    (node, dir, context) => {
      const { helper, removeHelper } = context;
      return processFor$1(node, dir, context, (forNode) => {
        const renderExp = createCallExpression(helper(RENDER_LIST), [
          forNode.source
        ]);
        const isTemplate = isTemplateNode(node);
        const memo = findDir(node, "memo");
        const keyProp = findProp(node, `key`);
        const keyExp = keyProp && (keyProp.type === 6 ? createSimpleExpression(keyProp.value.content, true) : keyProp.exp);
        const keyProperty = keyProp ? createObjectProperty(`key`, keyExp) : null;
        const isStableFragment = forNode.source.type === 4 && forNode.source.constType > 0;
        const fragmentFlag = isStableFragment ? 64 : keyProp ? 128 : 256;
        forNode.codegenNode = createVNodeCall(
          context,
          helper(FRAGMENT),
          void 0,
          renderExp,
          fragmentFlag + ``,
          void 0,
          void 0,
          true,
          !isStableFragment,
          false,
          node.loc
        );
        return () => {
          let childBlock;
          const { children } = forNode;
          const needFragmentWrapper = children.length !== 1 || children[0].type !== 1;
          const slotOutlet = isSlotOutlet(node) ? node : isTemplate && node.children.length === 1 && isSlotOutlet(node.children[0]) ? node.children[0] : null;
          if (slotOutlet) {
            childBlock = slotOutlet.codegenNode;
            if (isTemplate && keyProperty) {
              injectProp(childBlock, keyProperty, context);
            }
          } else if (needFragmentWrapper) {
            childBlock = createVNodeCall(
              context,
              helper(FRAGMENT),
              keyProperty ? createObjectExpression([keyProperty]) : void 0,
              node.children,
              `64`,
              void 0,
              void 0,
              true,
              void 0,
              false
              /* isComponent */
            );
          } else {
            childBlock = children[0].codegenNode;
            if (isTemplate && keyProperty) {
              injectProp(childBlock, keyProperty, context);
            }
            if (childBlock.isBlock !== !isStableFragment) {
              if (childBlock.isBlock) {
                removeHelper(OPEN_BLOCK);
                removeHelper(
                  getVNodeBlockHelper(context.inSSR, childBlock.isComponent)
                );
              } else {
                removeHelper(
                  getVNodeHelper(context.inSSR, childBlock.isComponent)
                );
              }
            }
            childBlock.isBlock = !isStableFragment;
            if (childBlock.isBlock) {
              helper(OPEN_BLOCK);
              helper(getVNodeBlockHelper(context.inSSR, childBlock.isComponent));
            } else {
              helper(getVNodeHelper(context.inSSR, childBlock.isComponent));
            }
          }
          if (memo) {
            const loop = createFunctionExpression(
              createForLoopParams(forNode.parseResult, [
                createSimpleExpression(`_cached`)
              ])
            );
            loop.body = createBlockStatement([
              createCompoundExpression([`const _memo = (`, memo.exp, `)`]),
              createCompoundExpression([
                `if (_cached`,
                ...keyExp ? [` && _cached.key === `, keyExp] : [],
                ` && ${context.helperString(
                  IS_MEMO_SAME
                )}(_cached, _memo)) return _cached`
              ]),
              createCompoundExpression([`const _item = `, childBlock]),
              createSimpleExpression(`_item.memo = _memo`),
              createSimpleExpression(`return _item`)
            ]);
            renderExp.arguments.push(
              loop,
              createSimpleExpression(`_cache`),
              createSimpleExpression(String(context.cached++))
            );
          } else {
            renderExp.arguments.push(
              createFunctionExpression(
                createForLoopParams(forNode.parseResult),
                childBlock,
                true
                /* force newline */
              )
            );
          }
        };
      });
    }
  );
  function processFor$1(node, dir, context, processCodegen) {
    if (!dir.exp) {
      context.onError(
        createCompilerError(31, dir.loc)
      );
      return;
    }
    const parseResult = parseForExpression(
      // can only be simple expression because vFor transform is applied
      // before expression transform.
      dir.exp
    );
    if (!parseResult) {
      context.onError(
        createCompilerError(32, dir.loc)
      );
      return;
    }
    const { addIdentifiers, removeIdentifiers, scopes } = context;
    const { source, value, key, index: index2 } = parseResult;
    const forNode = {
      type: 11,
      loc: dir.loc,
      source,
      valueAlias: value,
      keyAlias: key,
      objectIndexAlias: index2,
      parseResult,
      children: isTemplateNode(node) ? node.children : [node]
    };
    context.replaceNode(forNode);
    scopes.vFor++;
    const onExit = processCodegen && processCodegen(forNode);
    return () => {
      scopes.vFor--;
      if (onExit)
        onExit();
    };
  }
  const forAliasRE$1 = /([\s\S]*?)\s+(?:in|of)\s+([\s\S]*)/;
  const forIteratorRE$1 = /,([^,\}\]]*)(?:,([^,\}\]]*))?$/;
  const stripParensRE$1 = /^\(|\)$/g;
  function parseForExpression(input, context) {
    const loc = input.loc;
    const exp = input.content;
    const inMatch = exp.match(forAliasRE$1);
    if (!inMatch)
      return;
    const [, LHS, RHS] = inMatch;
    const result = {
      source: createAliasExpression(
        loc,
        RHS.trim(),
        exp.indexOf(RHS, LHS.length)
      ),
      value: void 0,
      key: void 0,
      index: void 0
    };
    let valueContent = LHS.trim().replace(stripParensRE$1, "").trim();
    const trimmedOffset = LHS.indexOf(valueContent);
    const iteratorMatch = valueContent.match(forIteratorRE$1);
    if (iteratorMatch) {
      valueContent = valueContent.replace(forIteratorRE$1, "").trim();
      const keyContent = iteratorMatch[1].trim();
      let keyOffset;
      if (keyContent) {
        keyOffset = exp.indexOf(keyContent, trimmedOffset + valueContent.length);
        result.key = createAliasExpression(loc, keyContent, keyOffset);
      }
      if (iteratorMatch[2]) {
        const indexContent = iteratorMatch[2].trim();
        if (indexContent) {
          result.index = createAliasExpression(
            loc,
            indexContent,
            exp.indexOf(
              indexContent,
              result.key ? keyOffset + keyContent.length : trimmedOffset + valueContent.length
            )
          );
        }
      }
    }
    if (valueContent) {
      result.value = createAliasExpression(loc, valueContent, trimmedOffset);
    }
    return result;
  }
  function createAliasExpression(range2, content, offset) {
    return createSimpleExpression(
      content,
      false,
      getInnerRange(range2, offset, content.length)
    );
  }
  function createForLoopParams({ value, key, index: index2 }, memoArgs = []) {
    return createParamsList([value, key, index2, ...memoArgs]);
  }
  function createParamsList(args) {
    let i = args.length;
    while (i--) {
      if (args[i])
        break;
    }
    return args.slice(0, i + 1).map((arg, i2) => arg || createSimpleExpression(`_`.repeat(i2 + 1), false));
  }
  const defaultFallback = createSimpleExpression(`undefined`, false);
  const trackSlotScopes = (node, context) => {
    if (node.type === 1 && (node.tagType === 1 || node.tagType === 3)) {
      const vSlot = findDir(node, "slot");
      if (vSlot) {
        vSlot.exp;
        context.scopes.vSlot++;
        return () => {
          context.scopes.vSlot--;
        };
      }
    }
  };
  const trackVForSlotScopes = (node, context) => {
    let vFor;
    if (isTemplateNode(node) && node.props.some(isVSlot) && (vFor = findDir(node, "for"))) {
      const result = vFor.parseResult = parseForExpression(
        vFor.exp
      );
      if (result) {
        const { value, key, index: index2 } = result;
        const { addIdentifiers, removeIdentifiers } = context;
        value && addIdentifiers(value);
        key && addIdentifiers(key);
        index2 && addIdentifiers(index2);
        return () => {
          value && removeIdentifiers(value);
          key && removeIdentifiers(key);
          index2 && removeIdentifiers(index2);
        };
      }
    }
  };
  const buildClientSlotFn = (props, children, loc) => createFunctionExpression(
    props,
    children,
    false,
    true,
    children.length ? children[0].loc : loc
  );
  function buildSlots(node, context, buildSlotFn = buildClientSlotFn) {
    context.helper(WITH_CTX);
    const { children, loc } = node;
    const slotsProperties = [];
    const dynamicSlots = [];
    let hasDynamicSlots = context.scopes.vSlot > 0 || context.scopes.vFor > 0;
    const onComponentSlot = findDir(node, "slot", true);
    if (onComponentSlot) {
      const { arg, exp } = onComponentSlot;
      if (arg && !isStaticExp(arg)) {
        hasDynamicSlots = true;
      }
      slotsProperties.push(
        createObjectProperty(
          arg || createSimpleExpression("default", true),
          buildSlotFn(exp, children, loc)
        )
      );
    }
    let hasTemplateSlots = false;
    let hasNamedDefaultSlot = false;
    const implicitDefaultChildren = [];
    const seenSlotNames = /* @__PURE__ */ new Set();
    let conditionalBranchIndex = 0;
    for (let i = 0; i < children.length; i++) {
      const slotElement = children[i];
      let slotDir;
      if (!isTemplateNode(slotElement) || !(slotDir = findDir(slotElement, "slot", true))) {
        if (slotElement.type !== 3) {
          implicitDefaultChildren.push(slotElement);
        }
        continue;
      }
      if (onComponentSlot) {
        context.onError(
          createCompilerError(37, slotDir.loc)
        );
        break;
      }
      hasTemplateSlots = true;
      const { children: slotChildren, loc: slotLoc } = slotElement;
      const {
        arg: slotName = createSimpleExpression(`default`, true),
        exp: slotProps,
        loc: dirLoc
      } = slotDir;
      let staticSlotName;
      if (isStaticExp(slotName)) {
        staticSlotName = slotName ? slotName.content : `default`;
      } else {
        hasDynamicSlots = true;
      }
      const slotFunction = buildSlotFn(slotProps, slotChildren, slotLoc);
      let vIf;
      let vElse;
      let vFor;
      if (vIf = findDir(slotElement, "if")) {
        hasDynamicSlots = true;
        dynamicSlots.push(
          createConditionalExpression(
            vIf.exp,
            buildDynamicSlot(slotName, slotFunction, conditionalBranchIndex++),
            defaultFallback
          )
        );
      } else if (vElse = findDir(
        slotElement,
        /^else(-if)?$/,
        true
        /* allowEmpty */
      )) {
        let j = i;
        let prev;
        while (j--) {
          prev = children[j];
          if (prev.type !== 3) {
            break;
          }
        }
        if (prev && isTemplateNode(prev) && findDir(prev, "if")) {
          children.splice(i, 1);
          i--;
          let conditional = dynamicSlots[dynamicSlots.length - 1];
          while (conditional.alternate.type === 19) {
            conditional = conditional.alternate;
          }
          conditional.alternate = vElse.exp ? createConditionalExpression(
            vElse.exp,
            buildDynamicSlot(
              slotName,
              slotFunction,
              conditionalBranchIndex++
            ),
            defaultFallback
          ) : buildDynamicSlot(slotName, slotFunction, conditionalBranchIndex++);
        } else {
          context.onError(
            createCompilerError(30, vElse.loc)
          );
        }
      } else if (vFor = findDir(slotElement, "for")) {
        hasDynamicSlots = true;
        const parseResult = vFor.parseResult || parseForExpression(vFor.exp);
        if (parseResult) {
          dynamicSlots.push(
            createCallExpression(context.helper(RENDER_LIST), [
              parseResult.source,
              createFunctionExpression(
                createForLoopParams(parseResult),
                buildDynamicSlot(slotName, slotFunction),
                true
                /* force newline */
              )
            ])
          );
        } else {
          context.onError(
            createCompilerError(32, vFor.loc)
          );
        }
      } else {
        if (staticSlotName) {
          if (seenSlotNames.has(staticSlotName)) {
            context.onError(
              createCompilerError(
                38,
                dirLoc
              )
            );
            continue;
          }
          seenSlotNames.add(staticSlotName);
          if (staticSlotName === "default") {
            hasNamedDefaultSlot = true;
          }
        }
        slotsProperties.push(createObjectProperty(slotName, slotFunction));
      }
    }
    if (!onComponentSlot) {
      const buildDefaultSlotProperty = (props, children2) => {
        const fn = buildSlotFn(props, children2, loc);
        if (context.compatConfig) {
          fn.isNonScopedSlot = true;
        }
        return createObjectProperty(`default`, fn);
      };
      if (!hasTemplateSlots) {
        slotsProperties.push(buildDefaultSlotProperty(void 0, children));
      } else if (implicitDefaultChildren.length && // #3766
      // with whitespace: 'preserve', whitespaces between slots will end up in
      // implicitDefaultChildren. Ignore if all implicit children are whitespaces.
      implicitDefaultChildren.some((node2) => isNonWhitespaceContent(node2))) {
        if (hasNamedDefaultSlot) {
          context.onError(
            createCompilerError(
              39,
              implicitDefaultChildren[0].loc
            )
          );
        } else {
          slotsProperties.push(
            buildDefaultSlotProperty(void 0, implicitDefaultChildren)
          );
        }
      }
    }
    const slotFlag = hasDynamicSlots ? 2 : hasForwardedSlots(node.children) ? 3 : 1;
    let slots = createObjectExpression(
      slotsProperties.concat(
        createObjectProperty(
          `_`,
          // 2 = compiled but dynamic = can skip normalization, but must run diff
          // 1 = compiled and static = can skip normalization AND diff as optimized
          createSimpleExpression(
            slotFlag + ``,
            false
          )
        )
      ),
      loc
    );
    if (dynamicSlots.length) {
      slots = createCallExpression(context.helper(CREATE_SLOTS), [
        slots,
        createArrayExpression(dynamicSlots)
      ]);
    }
    return {
      slots,
      hasDynamicSlots
    };
  }
  function buildDynamicSlot(name, fn, index2) {
    const props = [
      createObjectProperty(`name`, name),
      createObjectProperty(`fn`, fn)
    ];
    if (index2 != null) {
      props.push(
        createObjectProperty(`key`, createSimpleExpression(String(index2), true))
      );
    }
    return createObjectExpression(props);
  }
  function hasForwardedSlots(children) {
    for (let i = 0; i < children.length; i++) {
      const child = children[i];
      switch (child.type) {
        case 1:
          if (child.tagType === 2 || hasForwardedSlots(child.children)) {
            return true;
          }
          break;
        case 9:
          if (hasForwardedSlots(child.branches))
            return true;
          break;
        case 10:
        case 11:
          if (hasForwardedSlots(child.children))
            return true;
          break;
      }
    }
    return false;
  }
  function isNonWhitespaceContent(node) {
    if (node.type !== 2 && node.type !== 12)
      return true;
    return node.type === 2 ? !!node.content.trim() : isNonWhitespaceContent(node.content);
  }
  const directiveImportMap = /* @__PURE__ */ new WeakMap();
  const transformElement = (node, context) => {
    return function postTransformElement() {
      node = context.currentNode;
      if (!(node.type === 1 && (node.tagType === 0 || node.tagType === 1))) {
        return;
      }
      const { tag, props } = node;
      const isComponent2 = node.tagType === 1;
      let vnodeTag = isComponent2 ? resolveComponentType(node, context) : `"${tag}"`;
      const isDynamicComponent = isObject$2(vnodeTag) && vnodeTag.callee === RESOLVE_DYNAMIC_COMPONENT;
      let vnodeProps;
      let vnodeChildren;
      let vnodePatchFlag;
      let patchFlag = 0;
      let vnodeDynamicProps;
      let dynamicPropNames;
      let vnodeDirectives;
      let shouldUseBlock = (
        // dynamic component may resolve to plain elements
        isDynamicComponent || vnodeTag === TELEPORT || vnodeTag === SUSPENSE || !isComponent2 && // <svg> and <foreignObject> must be forced into blocks so that block
        // updates inside get proper isSVG flag at runtime. (#639, #643)
        // This is technically web-specific, but splitting the logic out of core
        // leads to too much unnecessary complexity.
        (tag === "svg" || tag === "foreignObject")
      );
      if (props.length > 0) {
        const propsBuildResult = buildProps(
          node,
          context,
          void 0,
          isComponent2,
          isDynamicComponent
        );
        vnodeProps = propsBuildResult.props;
        patchFlag = propsBuildResult.patchFlag;
        dynamicPropNames = propsBuildResult.dynamicPropNames;
        const directives2 = propsBuildResult.directives;
        vnodeDirectives = directives2 && directives2.length ? createArrayExpression(
          directives2.map((dir) => buildDirectiveArgs(dir, context))
        ) : void 0;
        if (propsBuildResult.shouldUseBlock) {
          shouldUseBlock = true;
        }
      }
      if (node.children.length > 0) {
        if (vnodeTag === KEEP_ALIVE) {
          shouldUseBlock = true;
          patchFlag |= 1024;
        }
        const shouldBuildAsSlots = isComponent2 && // Teleport is not a real component and has dedicated runtime handling
        vnodeTag !== TELEPORT && // explained above.
        vnodeTag !== KEEP_ALIVE;
        if (shouldBuildAsSlots) {
          const { slots, hasDynamicSlots } = buildSlots(node, context);
          vnodeChildren = slots;
          if (hasDynamicSlots) {
            patchFlag |= 1024;
          }
        } else if (node.children.length === 1 && vnodeTag !== TELEPORT) {
          const child = node.children[0];
          const type = child.type;
          const hasDynamicTextChild = type === 5 || type === 8;
          if (hasDynamicTextChild && getConstantType(child, context) === 0) {
            patchFlag |= 1;
          }
          if (hasDynamicTextChild || type === 2) {
            vnodeChildren = child;
          } else {
            vnodeChildren = node.children;
          }
        } else {
          vnodeChildren = node.children;
        }
      }
      if (patchFlag !== 0) {
        {
          vnodePatchFlag = String(patchFlag);
        }
        if (dynamicPropNames && dynamicPropNames.length) {
          vnodeDynamicProps = stringifyDynamicPropNames(dynamicPropNames);
        }
      }
      node.codegenNode = createVNodeCall(
        context,
        vnodeTag,
        vnodeProps,
        vnodeChildren,
        vnodePatchFlag,
        vnodeDynamicProps,
        vnodeDirectives,
        !!shouldUseBlock,
        false,
        isComponent2,
        node.loc
      );
    };
  };
  function resolveComponentType(node, context, ssr = false) {
    let { tag } = node;
    const isExplicitDynamic = isComponentTag(tag);
    const isProp = findProp(node, "is");
    if (isProp) {
      if (isExplicitDynamic || isCompatEnabled(
        "COMPILER_IS_ON_ELEMENT",
        context
      )) {
        const exp = isProp.type === 6 ? isProp.value && createSimpleExpression(isProp.value.content, true) : isProp.exp;
        if (exp) {
          return createCallExpression(context.helper(RESOLVE_DYNAMIC_COMPONENT), [
            exp
          ]);
        }
      } else if (isProp.type === 6 && isProp.value.content.startsWith("vue:")) {
        tag = isProp.value.content.slice(4);
      }
    }
    const isDir = !isExplicitDynamic && findDir(node, "is");
    if (isDir && isDir.exp) {
      return createCallExpression(context.helper(RESOLVE_DYNAMIC_COMPONENT), [
        isDir.exp
      ]);
    }
    const builtIn = isCoreComponent(tag) || context.isBuiltInComponent(tag);
    if (builtIn) {
      if (!ssr)
        context.helper(builtIn);
      return builtIn;
    }
    context.helper(RESOLVE_COMPONENT);
    context.components.add(tag);
    return toValidAssetId(tag, `component`);
  }
  function buildProps(node, context, props = node.props, isComponent2, isDynamicComponent, ssr = false) {
    const { tag, loc: elementLoc, children } = node;
    let properties = [];
    const mergeArgs = [];
    const runtimeDirectives = [];
    const hasChildren = children.length > 0;
    let shouldUseBlock = false;
    let patchFlag = 0;
    let hasRef = false;
    let hasClassBinding = false;
    let hasStyleBinding = false;
    let hasHydrationEventBinding = false;
    let hasDynamicKeys = false;
    let hasVnodeHook = false;
    const dynamicPropNames = [];
    const pushMergeArg = (arg) => {
      if (properties.length) {
        mergeArgs.push(
          createObjectExpression(dedupeProperties(properties), elementLoc)
        );
        properties = [];
      }
      if (arg)
        mergeArgs.push(arg);
    };
    const analyzePatchFlag = ({ key, value }) => {
      if (isStaticExp(key)) {
        const name = key.content;
        const isEventHandler = isOn(name);
        if (isEventHandler && (!isComponent2 || isDynamicComponent) && // omit the flag for click handlers because hydration gives click
        // dedicated fast path.
        name.toLowerCase() !== "onclick" && // omit v-model handlers
        name !== "onUpdate:modelValue" && // omit onVnodeXXX hooks
        !isReservedProp(name)) {
          hasHydrationEventBinding = true;
        }
        if (isEventHandler && isReservedProp(name)) {
          hasVnodeHook = true;
        }
        if (value.type === 20 || (value.type === 4 || value.type === 8) && getConstantType(value, context) > 0) {
          return;
        }
        if (name === "ref") {
          hasRef = true;
        } else if (name === "class") {
          hasClassBinding = true;
        } else if (name === "style") {
          hasStyleBinding = true;
        } else if (name !== "key" && !dynamicPropNames.includes(name)) {
          dynamicPropNames.push(name);
        }
        if (isComponent2 && (name === "class" || name === "style") && !dynamicPropNames.includes(name)) {
          dynamicPropNames.push(name);
        }
      } else {
        hasDynamicKeys = true;
      }
    };
    for (let i = 0; i < props.length; i++) {
      const prop = props[i];
      if (prop.type === 6) {
        const { loc, name, value } = prop;
        let isStatic2 = true;
        if (name === "ref") {
          hasRef = true;
          if (context.scopes.vFor > 0) {
            properties.push(
              createObjectProperty(
                createSimpleExpression("ref_for", true),
                createSimpleExpression("true")
              )
            );
          }
        }
        if (name === "is" && (isComponentTag(tag) || value && value.content.startsWith("vue:") || isCompatEnabled(
          "COMPILER_IS_ON_ELEMENT",
          context
        ))) {
          continue;
        }
        properties.push(
          createObjectProperty(
            createSimpleExpression(
              name,
              true,
              getInnerRange(loc, 0, name.length)
            ),
            createSimpleExpression(
              value ? value.content : "",
              isStatic2,
              value ? value.loc : loc
            )
          )
        );
      } else {
        const { name, arg, exp, loc } = prop;
        const isVBind = name === "bind";
        const isVOn = name === "on";
        if (name === "slot") {
          if (!isComponent2) {
            context.onError(
              createCompilerError(40, loc)
            );
          }
          continue;
        }
        if (name === "once" || name === "memo") {
          continue;
        }
        if (name === "is" || isVBind && isStaticArgOf(arg, "is") && (isComponentTag(tag) || isCompatEnabled(
          "COMPILER_IS_ON_ELEMENT",
          context
        ))) {
          continue;
        }
        if (isVOn && ssr) {
          continue;
        }
        if (
          // #938: elements with dynamic keys should be forced into blocks
          isVBind && isStaticArgOf(arg, "key") || // inline before-update hooks need to force block so that it is invoked
          // before children
          isVOn && hasChildren && isStaticArgOf(arg, "vue:before-update")
        ) {
          shouldUseBlock = true;
        }
        if (isVBind && isStaticArgOf(arg, "ref") && context.scopes.vFor > 0) {
          properties.push(
            createObjectProperty(
              createSimpleExpression("ref_for", true),
              createSimpleExpression("true")
            )
          );
        }
        if (!arg && (isVBind || isVOn)) {
          hasDynamicKeys = true;
          if (exp) {
            if (isVBind) {
              pushMergeArg();
              {
                if (isCompatEnabled(
                  "COMPILER_V_BIND_OBJECT_ORDER",
                  context
                )) {
                  mergeArgs.unshift(exp);
                  continue;
                }
              }
              mergeArgs.push(exp);
            } else {
              pushMergeArg({
                type: 14,
                loc,
                callee: context.helper(TO_HANDLERS),
                arguments: isComponent2 ? [exp] : [exp, `true`]
              });
            }
          } else {
            context.onError(
              createCompilerError(
                isVBind ? 34 : 35,
                loc
              )
            );
          }
          continue;
        }
        const directiveTransform = context.directiveTransforms[name];
        if (directiveTransform) {
          const { props: props2, needRuntime } = directiveTransform(prop, node, context);
          !ssr && props2.forEach(analyzePatchFlag);
          if (isVOn && arg && !isStaticExp(arg)) {
            pushMergeArg(createObjectExpression(props2, elementLoc));
          } else {
            properties.push(...props2);
          }
          if (needRuntime) {
            runtimeDirectives.push(prop);
            if (isSymbol(needRuntime)) {
              directiveImportMap.set(prop, needRuntime);
            }
          }
        } else if (!isBuiltInDirective(name)) {
          runtimeDirectives.push(prop);
          if (hasChildren) {
            shouldUseBlock = true;
          }
        }
      }
    }
    let propsExpression = void 0;
    if (mergeArgs.length) {
      pushMergeArg();
      if (mergeArgs.length > 1) {
        propsExpression = createCallExpression(
          context.helper(MERGE_PROPS),
          mergeArgs,
          elementLoc
        );
      } else {
        propsExpression = mergeArgs[0];
      }
    } else if (properties.length) {
      propsExpression = createObjectExpression(
        dedupeProperties(properties),
        elementLoc
      );
    }
    if (hasDynamicKeys) {
      patchFlag |= 16;
    } else {
      if (hasClassBinding && !isComponent2) {
        patchFlag |= 2;
      }
      if (hasStyleBinding && !isComponent2) {
        patchFlag |= 4;
      }
      if (dynamicPropNames.length) {
        patchFlag |= 8;
      }
      if (hasHydrationEventBinding) {
        patchFlag |= 32;
      }
    }
    if (!shouldUseBlock && (patchFlag === 0 || patchFlag === 32) && (hasRef || hasVnodeHook || runtimeDirectives.length > 0)) {
      patchFlag |= 512;
    }
    if (!context.inSSR && propsExpression) {
      switch (propsExpression.type) {
        case 15:
          let classKeyIndex = -1;
          let styleKeyIndex = -1;
          let hasDynamicKey = false;
          for (let i = 0; i < propsExpression.properties.length; i++) {
            const key = propsExpression.properties[i].key;
            if (isStaticExp(key)) {
              if (key.content === "class") {
                classKeyIndex = i;
              } else if (key.content === "style") {
                styleKeyIndex = i;
              }
            } else if (!key.isHandlerKey) {
              hasDynamicKey = true;
            }
          }
          const classProp = propsExpression.properties[classKeyIndex];
          const styleProp = propsExpression.properties[styleKeyIndex];
          if (!hasDynamicKey) {
            if (classProp && !isStaticExp(classProp.value)) {
              classProp.value = createCallExpression(
                context.helper(NORMALIZE_CLASS),
                [classProp.value]
              );
            }
            if (styleProp && // the static style is compiled into an object,
            // so use `hasStyleBinding` to ensure that it is a dynamic style binding
            (hasStyleBinding || styleProp.value.type === 4 && styleProp.value.content.trim()[0] === `[` || // v-bind:style and style both exist,
            // v-bind:style with static literal object
            styleProp.value.type === 17)) {
              styleProp.value = createCallExpression(
                context.helper(NORMALIZE_STYLE),
                [styleProp.value]
              );
            }
          } else {
            propsExpression = createCallExpression(
              context.helper(NORMALIZE_PROPS),
              [propsExpression]
            );
          }
          break;
        case 14:
          break;
        default:
          propsExpression = createCallExpression(
            context.helper(NORMALIZE_PROPS),
            [
              createCallExpression(context.helper(GUARD_REACTIVE_PROPS), [
                propsExpression
              ])
            ]
          );
          break;
      }
    }
    return {
      props: propsExpression,
      directives: runtimeDirectives,
      patchFlag,
      dynamicPropNames,
      shouldUseBlock
    };
  }
  function dedupeProperties(properties) {
    const knownProps = /* @__PURE__ */ new Map();
    const deduped = [];
    for (let i = 0; i < properties.length; i++) {
      const prop = properties[i];
      if (prop.key.type === 8 || !prop.key.isStatic) {
        deduped.push(prop);
        continue;
      }
      const name = prop.key.content;
      const existing = knownProps.get(name);
      if (existing) {
        if (name === "style" || name === "class" || isOn(name)) {
          mergeAsArray(existing, prop);
        }
      } else {
        knownProps.set(name, prop);
        deduped.push(prop);
      }
    }
    return deduped;
  }
  function mergeAsArray(existing, incoming) {
    if (existing.value.type === 17) {
      existing.value.elements.push(incoming.value);
    } else {
      existing.value = createArrayExpression(
        [existing.value, incoming.value],
        existing.loc
      );
    }
  }
  function buildDirectiveArgs(dir, context) {
    const dirArgs = [];
    const runtime = directiveImportMap.get(dir);
    if (runtime) {
      dirArgs.push(context.helperString(runtime));
    } else {
      {
        context.helper(RESOLVE_DIRECTIVE);
        context.directives.add(dir.name);
        dirArgs.push(toValidAssetId(dir.name, `directive`));
      }
    }
    const { loc } = dir;
    if (dir.exp)
      dirArgs.push(dir.exp);
    if (dir.arg) {
      if (!dir.exp) {
        dirArgs.push(`void 0`);
      }
      dirArgs.push(dir.arg);
    }
    if (Object.keys(dir.modifiers).length) {
      if (!dir.arg) {
        if (!dir.exp) {
          dirArgs.push(`void 0`);
        }
        dirArgs.push(`void 0`);
      }
      const trueExpression = createSimpleExpression(`true`, false, loc);
      dirArgs.push(
        createObjectExpression(
          dir.modifiers.map(
            (modifier) => createObjectProperty(modifier, trueExpression)
          ),
          loc
        )
      );
    }
    return createArrayExpression(dirArgs, dir.loc);
  }
  function stringifyDynamicPropNames(props) {
    let propsNamesString = `[`;
    for (let i = 0, l = props.length; i < l; i++) {
      propsNamesString += JSON.stringify(props[i]);
      if (i < l - 1)
        propsNamesString += ", ";
    }
    return propsNamesString + `]`;
  }
  function isComponentTag(tag) {
    return tag === "component" || tag === "Component";
  }
  const transformSlotOutlet = (node, context) => {
    if (isSlotOutlet(node)) {
      const { children, loc } = node;
      const { slotName, slotProps } = processSlotOutlet$1(node, context);
      const slotArgs = [
        context.prefixIdentifiers ? `_ctx.$slots` : `$slots`,
        slotName,
        "{}",
        "undefined",
        "true"
      ];
      let expectedLen = 2;
      if (slotProps) {
        slotArgs[2] = slotProps;
        expectedLen = 3;
      }
      if (children.length) {
        slotArgs[3] = createFunctionExpression([], children, false, false, loc);
        expectedLen = 4;
      }
      if (context.scopeId && !context.slotted) {
        expectedLen = 5;
      }
      slotArgs.splice(expectedLen);
      node.codegenNode = createCallExpression(
        context.helper(RENDER_SLOT),
        slotArgs,
        loc
      );
    }
  };
  function processSlotOutlet$1(node, context) {
    let slotName = `"default"`;
    let slotProps = void 0;
    const nonNameProps = [];
    for (let i = 0; i < node.props.length; i++) {
      const p = node.props[i];
      if (p.type === 6) {
        if (p.value) {
          if (p.name === "name") {
            slotName = JSON.stringify(p.value.content);
          } else {
            p.name = camelize$1(p.name);
            nonNameProps.push(p);
          }
        }
      } else {
        if (p.name === "bind" && isStaticArgOf(p.arg, "name")) {
          if (p.exp)
            slotName = p.exp;
        } else {
          if (p.name === "bind" && p.arg && isStaticExp(p.arg)) {
            p.arg.content = camelize$1(p.arg.content);
          }
          nonNameProps.push(p);
        }
      }
    }
    if (nonNameProps.length > 0) {
      const { props, directives: directives2 } = buildProps(
        node,
        context,
        nonNameProps,
        false,
        false
      );
      slotProps = props;
      if (directives2.length) {
        context.onError(
          createCompilerError(
            36,
            directives2[0].loc
          )
        );
      }
    }
    return {
      slotName,
      slotProps
    };
  }
  const fnExpRE$1 = /^\s*([\w$_]+|(async\s*)?\([^)]*?\))\s*(:[^=]+)?=>|^\s*(async\s+)?function(?:\s+[\w$]+)?\s*\(/;
  const transformOn$1 = (dir, node, context, augmentor) => {
    const { loc, modifiers: modifiers2, arg } = dir;
    if (!dir.exp && !modifiers2.length) {
      context.onError(createCompilerError(35, loc));
    }
    let eventName;
    if (arg.type === 4) {
      if (arg.isStatic) {
        let rawName = arg.content;
        if (rawName.startsWith("vue:")) {
          rawName = `vnode-${rawName.slice(4)}`;
        }
        const eventString = node.tagType !== 0 || rawName.startsWith("vnode") || !/[A-Z]/.test(rawName) ? (
          // for non-element and vnode lifecycle event listeners, auto convert
          // it to camelCase. See issue #2249
          toHandlerKey(camelize$1(rawName))
        ) : (
          // preserve case for plain element listeners that have uppercase
          // letters, as these may be custom elements' custom events
          `on:${rawName}`
        );
        eventName = createSimpleExpression(eventString, true, arg.loc);
      } else {
        eventName = createCompoundExpression([
          `${context.helperString(TO_HANDLER_KEY)}(`,
          arg,
          `)`
        ]);
      }
    } else {
      eventName = arg;
      eventName.children.unshift(`${context.helperString(TO_HANDLER_KEY)}(`);
      eventName.children.push(`)`);
    }
    let exp = dir.exp;
    if (exp && !exp.content.trim()) {
      exp = void 0;
    }
    let shouldCache = context.cacheHandlers && !exp && !context.inVOnce;
    if (exp) {
      const isMemberExp = isMemberExpression(exp.content);
      const isInlineStatement = !(isMemberExp || fnExpRE$1.test(exp.content));
      const hasMultipleStatements = exp.content.includes(`;`);
      if (isInlineStatement || shouldCache && isMemberExp) {
        exp = createCompoundExpression([
          `${isInlineStatement ? `$event` : `${``}(...args)`} => ${hasMultipleStatements ? `{` : `(`}`,
          exp,
          hasMultipleStatements ? `}` : `)`
        ]);
      }
    }
    let ret = {
      props: [
        createObjectProperty(
          eventName,
          exp || createSimpleExpression(`() => {}`, false, loc)
        )
      ]
    };
    if (augmentor) {
      ret = augmentor(ret);
    }
    if (shouldCache) {
      ret.props[0].value = context.cache(ret.props[0].value);
    }
    ret.props.forEach((p) => p.key.isHandlerKey = true);
    return ret;
  };
  const transformBind = (dir, _node, context) => {
    const { exp, modifiers: modifiers2, loc } = dir;
    const arg = dir.arg;
    if (arg.type !== 4) {
      arg.children.unshift(`(`);
      arg.children.push(`) || ""`);
    } else if (!arg.isStatic) {
      arg.content = `${arg.content} || ""`;
    }
    if (modifiers2.includes("camel")) {
      if (arg.type === 4) {
        if (arg.isStatic) {
          arg.content = camelize$1(arg.content);
        } else {
          arg.content = `${context.helperString(CAMELIZE)}(${arg.content})`;
        }
      } else {
        arg.children.unshift(`${context.helperString(CAMELIZE)}(`);
        arg.children.push(`)`);
      }
    }
    if (!context.inSSR) {
      if (modifiers2.includes("prop")) {
        injectPrefix(arg, ".");
      }
      if (modifiers2.includes("attr")) {
        injectPrefix(arg, "^");
      }
    }
    if (!exp || exp.type === 4 && !exp.content.trim()) {
      context.onError(createCompilerError(34, loc));
      return {
        props: [createObjectProperty(arg, createSimpleExpression("", true, loc))]
      };
    }
    return {
      props: [createObjectProperty(arg, exp)]
    };
  };
  const injectPrefix = (arg, prefix) => {
    if (arg.type === 4) {
      if (arg.isStatic) {
        arg.content = prefix + arg.content;
      } else {
        arg.content = `\`${prefix}\${${arg.content}}\``;
      }
    } else {
      arg.children.unshift(`'${prefix}' + (`);
      arg.children.push(`)`);
    }
  };
  const transformText = (node, context) => {
    if (node.type === 0 || node.type === 1 || node.type === 11 || node.type === 10) {
      return () => {
        const children = node.children;
        let currentContainer = void 0;
        let hasText = false;
        for (let i = 0; i < children.length; i++) {
          const child = children[i];
          if (isText$1(child)) {
            hasText = true;
            for (let j = i + 1; j < children.length; j++) {
              const next2 = children[j];
              if (isText$1(next2)) {
                if (!currentContainer) {
                  currentContainer = children[i] = createCompoundExpression(
                    [child],
                    child.loc
                  );
                }
                currentContainer.children.push(` + `, next2);
                children.splice(j, 1);
                j--;
              } else {
                currentContainer = void 0;
                break;
              }
            }
          }
        }
        if (!hasText || // if this is a plain element with a single text child, leave it
        // as-is since the runtime has dedicated fast path for this by directly
        // setting textContent of the element.
        // for component root it's always normalized anyway.
        children.length === 1 && (node.type === 0 || node.type === 1 && node.tagType === 0 && // #3756
        // custom directives can potentially add DOM elements arbitrarily,
        // we need to avoid setting textContent of the element at runtime
        // to avoid accidentally overwriting the DOM elements added
        // by the user through custom directives.
        !node.props.find(
          (p) => p.type === 7 && !context.directiveTransforms[p.name]
        ) && // in compat mode, <template> tags with no special directives
        // will be rendered as a fragment so its children must be
        // converted into vnodes.
        !(node.tag === "template"))) {
          return;
        }
        for (let i = 0; i < children.length; i++) {
          const child = children[i];
          if (isText$1(child) || child.type === 8) {
            const callArgs = [];
            if (child.type !== 2 || child.content !== " ") {
              callArgs.push(child);
            }
            if (!context.ssr && getConstantType(child, context) === 0) {
              callArgs.push(
                `1`
              );
            }
            children[i] = {
              type: 12,
              content: child,
              loc: child.loc,
              codegenNode: createCallExpression(
                context.helper(CREATE_TEXT),
                callArgs
              )
            };
          }
        }
      };
    }
  };
  const seen$1 = /* @__PURE__ */ new WeakSet();
  const transformOnce = (node, context) => {
    if (node.type === 1 && findDir(node, "once", true)) {
      if (seen$1.has(node) || context.inVOnce || context.inSSR) {
        return;
      }
      seen$1.add(node);
      context.inVOnce = true;
      context.helper(SET_BLOCK_TRACKING);
      return () => {
        context.inVOnce = false;
        const cur = context.currentNode;
        if (cur.codegenNode) {
          cur.codegenNode = context.cache(
            cur.codegenNode,
            true
            /* isVNode */
          );
        }
      };
    }
  };
  const transformModel$2 = (dir, node, context) => {
    const { exp, arg } = dir;
    if (!exp) {
      context.onError(
        createCompilerError(41, dir.loc)
      );
      return createTransformProps();
    }
    const rawExp = exp.loc.source;
    const expString = exp.type === 4 ? exp.content : rawExp;
    const bindingType = context.bindingMetadata[rawExp];
    if (bindingType === "props" || bindingType === "props-aliased") {
      context.onError(createCompilerError(44, exp.loc));
      return createTransformProps();
    }
    const maybeRef = false;
    if (!expString.trim() || !isMemberExpression(expString) && !maybeRef) {
      context.onError(
        createCompilerError(42, exp.loc)
      );
      return createTransformProps();
    }
    const propName = arg ? arg : createSimpleExpression("modelValue", true);
    const eventName = arg ? isStaticExp(arg) ? `onUpdate:${camelize$1(arg.content)}` : createCompoundExpression(['"onUpdate:" + ', arg]) : `onUpdate:modelValue`;
    let assignmentExp;
    const eventArg = context.isTS ? `($event: any)` : `$event`;
    {
      assignmentExp = createCompoundExpression([
        `${eventArg} => ((`,
        exp,
        `) = $event)`
      ]);
    }
    const props = [
      // modelValue: foo
      createObjectProperty(propName, dir.exp),
      // "onUpdate:modelValue": $event => (foo = $event)
      createObjectProperty(eventName, assignmentExp)
    ];
    if (dir.modifiers.length && node.tagType === 1) {
      const modifiers2 = dir.modifiers.map((m) => (isSimpleIdentifier(m) ? m : JSON.stringify(m)) + `: true`).join(`, `);
      const modifiersKey = arg ? isStaticExp(arg) ? `${arg.content}Modifiers` : createCompoundExpression([arg, ' + "Modifiers"']) : `modelModifiers`;
      props.push(
        createObjectProperty(
          modifiersKey,
          createSimpleExpression(
            `{ ${modifiers2} }`,
            false,
            dir.loc,
            2
          )
        )
      );
    }
    return createTransformProps(props);
  };
  function createTransformProps(props = []) {
    return { props };
  }
  const validDivisionCharRE$1 = /[\w).+\-_$\]]/;
  const transformFilter = (node, context) => {
    if (!isCompatEnabled("COMPILER_FILTER", context)) {
      return;
    }
    if (node.type === 5) {
      rewriteFilter(node.content, context);
    }
    if (node.type === 1) {
      node.props.forEach((prop) => {
        if (prop.type === 7 && prop.name !== "for" && prop.exp) {
          rewriteFilter(prop.exp, context);
        }
      });
    }
  };
  function rewriteFilter(node, context) {
    if (node.type === 4) {
      parseFilter(node, context);
    } else {
      for (let i = 0; i < node.children.length; i++) {
        const child = node.children[i];
        if (typeof child !== "object")
          continue;
        if (child.type === 4) {
          parseFilter(child, context);
        } else if (child.type === 8) {
          rewriteFilter(node, context);
        } else if (child.type === 5) {
          rewriteFilter(child.content, context);
        }
      }
    }
  }
  function parseFilter(node, context) {
    const exp = node.content;
    let inSingle = false;
    let inDouble = false;
    let inTemplateString = false;
    let inRegex = false;
    let curly = 0;
    let square = 0;
    let paren = 0;
    let lastFilterIndex = 0;
    let c, prev, i, expression, filters = [];
    for (i = 0; i < exp.length; i++) {
      prev = c;
      c = exp.charCodeAt(i);
      if (inSingle) {
        if (c === 39 && prev !== 92)
          inSingle = false;
      } else if (inDouble) {
        if (c === 34 && prev !== 92)
          inDouble = false;
      } else if (inTemplateString) {
        if (c === 96 && prev !== 92)
          inTemplateString = false;
      } else if (inRegex) {
        if (c === 47 && prev !== 92)
          inRegex = false;
      } else if (c === 124 && // pipe
      exp.charCodeAt(i + 1) !== 124 && exp.charCodeAt(i - 1) !== 124 && !curly && !square && !paren) {
        if (expression === void 0) {
          lastFilterIndex = i + 1;
          expression = exp.slice(0, i).trim();
        } else {
          pushFilter();
        }
      } else {
        switch (c) {
          case 34:
            inDouble = true;
            break;
          case 39:
            inSingle = true;
            break;
          case 96:
            inTemplateString = true;
            break;
          case 40:
            paren++;
            break;
          case 41:
            paren--;
            break;
          case 91:
            square++;
            break;
          case 93:
            square--;
            break;
          case 123:
            curly++;
            break;
          case 125:
            curly--;
            break;
        }
        if (c === 47) {
          let j = i - 1;
          let p;
          for (; j >= 0; j--) {
            p = exp.charAt(j);
            if (p !== " ")
              break;
          }
          if (!p || !validDivisionCharRE$1.test(p)) {
            inRegex = true;
          }
        }
      }
    }
    if (expression === void 0) {
      expression = exp.slice(0, i).trim();
    } else if (lastFilterIndex !== 0) {
      pushFilter();
    }
    function pushFilter() {
      filters.push(exp.slice(lastFilterIndex, i).trim());
      lastFilterIndex = i + 1;
    }
    if (filters.length) {
      for (i = 0; i < filters.length; i++) {
        expression = wrapFilter$1(expression, filters[i], context);
      }
      node.content = expression;
    }
  }
  function wrapFilter$1(exp, filter, context) {
    context.helper(RESOLVE_FILTER);
    const i = filter.indexOf("(");
    if (i < 0) {
      context.filters.add(filter);
      return `${toValidAssetId(filter, "filter")}(${exp})`;
    } else {
      const name = filter.slice(0, i);
      const args = filter.slice(i + 1);
      context.filters.add(name);
      return `${toValidAssetId(name, "filter")}(${exp}${args !== ")" ? "," + args : args}`;
    }
  }
  const seen = /* @__PURE__ */ new WeakSet();
  const transformMemo = (node, context) => {
    if (node.type === 1) {
      const dir = findDir(node, "memo");
      if (!dir || seen.has(node)) {
        return;
      }
      seen.add(node);
      return () => {
        const codegenNode = node.codegenNode || context.currentNode.codegenNode;
        if (codegenNode && codegenNode.type === 13) {
          if (node.tagType !== 1) {
            convertToBlock(codegenNode, context);
          }
          node.codegenNode = createCallExpression(context.helper(WITH_MEMO), [
            dir.exp,
            createFunctionExpression(void 0, codegenNode),
            `_cache`,
            String(context.cached++)
          ]);
        }
      };
    }
  };
  function getBaseTransformPreset(prefixIdentifiers) {
    return [
      [
        transformOnce,
        transformIf,
        transformMemo,
        transformFor,
        ...[transformFilter],
        ...[],
        transformSlotOutlet,
        transformElement,
        trackSlotScopes,
        transformText
      ],
      {
        on: transformOn$1,
        bind: transformBind,
        model: transformModel$2
      }
    ];
  }
  function baseCompile(template2, options = {}) {
    const onError = options.onError || defaultOnError;
    const isModuleMode = options.mode === "module";
    {
      if (options.prefixIdentifiers === true) {
        onError(createCompilerError(47));
      } else if (isModuleMode) {
        onError(createCompilerError(48));
      }
    }
    const prefixIdentifiers = false;
    if (options.cacheHandlers) {
      onError(createCompilerError(49));
    }
    if (options.scopeId && !isModuleMode) {
      onError(createCompilerError(50));
    }
    const ast2 = isString$1(template2) ? baseParse(template2, options) : template2;
    const [nodeTransforms, directiveTransforms] = getBaseTransformPreset();
    transform$1(
      ast2,
      extend$1({}, options, {
        prefixIdentifiers,
        nodeTransforms: [
          ...nodeTransforms,
          ...options.nodeTransforms || []
          // user transforms
        ],
        directiveTransforms: extend$1(
          {},
          directiveTransforms,
          options.directiveTransforms || {}
          // user transforms
        )
      })
    );
    return generate$4(
      ast2,
      extend$1({}, options, {
        prefixIdentifiers
      })
    );
  }
  const noopDirectiveTransform = () => ({ props: [] });
  const V_MODEL_RADIO = Symbol(``);
  const V_MODEL_CHECKBOX = Symbol(``);
  const V_MODEL_TEXT = Symbol(``);
  const V_MODEL_SELECT = Symbol(``);
  const V_MODEL_DYNAMIC = Symbol(``);
  const V_ON_WITH_MODIFIERS = Symbol(``);
  const V_ON_WITH_KEYS = Symbol(``);
  const V_SHOW = Symbol(``);
  const TRANSITION = Symbol(``);
  const TRANSITION_GROUP = Symbol(``);
  registerRuntimeHelpers({
    [V_MODEL_RADIO]: `vModelRadio`,
    [V_MODEL_CHECKBOX]: `vModelCheckbox`,
    [V_MODEL_TEXT]: `vModelText`,
    [V_MODEL_SELECT]: `vModelSelect`,
    [V_MODEL_DYNAMIC]: `vModelDynamic`,
    [V_ON_WITH_MODIFIERS]: `withModifiers`,
    [V_ON_WITH_KEYS]: `withKeys`,
    [V_SHOW]: `vShow`,
    [TRANSITION]: `Transition`,
    [TRANSITION_GROUP]: `TransitionGroup`
  });
  let decoder;
  function decodeHtmlBrowser(raw, asAttr = false) {
    if (!decoder) {
      decoder = document.createElement("div");
    }
    if (asAttr) {
      decoder.innerHTML = `<div foo="${raw.replace(/"/g, "&quot;")}">`;
      return decoder.children[0].getAttribute("foo");
    } else {
      decoder.innerHTML = raw;
      return decoder.textContent;
    }
  }
  const isRawTextContainer = /* @__PURE__ */ makeMap$1(
    "style,iframe,script,noscript",
    true
  );
  const parserOptions = {
    isVoidTag,
    isNativeTag: (tag) => isHTMLTag$1(tag) || isSVGTag(tag),
    isPreTag: (tag) => tag === "pre",
    decodeEntities: decodeHtmlBrowser,
    isBuiltInComponent: (tag) => {
      if (isBuiltInType(tag, `Transition`)) {
        return TRANSITION;
      } else if (isBuiltInType(tag, `TransitionGroup`)) {
        return TRANSITION_GROUP;
      }
    },
    // https://html.spec.whatwg.org/multipage/parsing.html#tree-construction-dispatcher
    getNamespace(tag, parent) {
      let ns = parent ? parent.ns : 0;
      if (parent && ns === 2) {
        if (parent.tag === "annotation-xml") {
          if (tag === "svg") {
            return 1;
          }
          if (parent.props.some(
            (a2) => a2.type === 6 && a2.name === "encoding" && a2.value != null && (a2.value.content === "text/html" || a2.value.content === "application/xhtml+xml")
          )) {
            ns = 0;
          }
        } else if (/^m(?:[ions]|text)$/.test(parent.tag) && tag !== "mglyph" && tag !== "malignmark") {
          ns = 0;
        }
      } else if (parent && ns === 1) {
        if (parent.tag === "foreignObject" || parent.tag === "desc" || parent.tag === "title") {
          ns = 0;
        }
      }
      if (ns === 0) {
        if (tag === "svg") {
          return 1;
        }
        if (tag === "math") {
          return 2;
        }
      }
      return ns;
    },
    // https://html.spec.whatwg.org/multipage/parsing.html#parsing-html-fragments
    getTextMode({ tag, ns }) {
      if (ns === 0) {
        if (tag === "textarea" || tag === "title") {
          return 1;
        }
        if (isRawTextContainer(tag)) {
          return 2;
        }
      }
      return 0;
    }
  };
  const transformStyle = (node) => {
    if (node.type === 1) {
      node.props.forEach((p, i) => {
        if (p.type === 6 && p.name === "style" && p.value) {
          node.props[i] = {
            type: 7,
            name: `bind`,
            arg: createSimpleExpression(`style`, true, p.loc),
            exp: parseInlineCSS(p.value.content, p.loc),
            modifiers: [],
            loc: p.loc
          };
        }
      });
    }
  };
  const parseInlineCSS = (cssText, loc) => {
    const normalized = parseStringStyle(cssText);
    return createSimpleExpression(
      JSON.stringify(normalized),
      false,
      loc,
      3
    );
  };
  function createDOMCompilerError(code, loc) {
    return createCompilerError(
      code,
      loc
    );
  }
  const transformVHtml = (dir, node, context) => {
    const { exp, loc } = dir;
    if (!exp) {
      context.onError(
        createDOMCompilerError(53, loc)
      );
    }
    if (node.children.length) {
      context.onError(
        createDOMCompilerError(54, loc)
      );
      node.children.length = 0;
    }
    return {
      props: [
        createObjectProperty(
          createSimpleExpression(`innerHTML`, true, loc),
          exp || createSimpleExpression("", true)
        )
      ]
    };
  };
  const transformVText = (dir, node, context) => {
    const { exp, loc } = dir;
    if (!exp) {
      context.onError(
        createDOMCompilerError(55, loc)
      );
    }
    if (node.children.length) {
      context.onError(
        createDOMCompilerError(56, loc)
      );
      node.children.length = 0;
    }
    return {
      props: [
        createObjectProperty(
          createSimpleExpression(`textContent`, true),
          exp ? getConstantType(exp, context) > 0 ? exp : createCallExpression(
            context.helperString(TO_DISPLAY_STRING),
            [exp],
            loc
          ) : createSimpleExpression("", true)
        )
      ]
    };
  };
  const transformModel$1 = (dir, node, context) => {
    const baseResult = transformModel$2(dir, node, context);
    if (!baseResult.props.length || node.tagType === 1) {
      return baseResult;
    }
    if (dir.arg) {
      context.onError(
        createDOMCompilerError(
          58,
          dir.arg.loc
        )
      );
    }
    const { tag } = node;
    const isCustomElement = context.isCustomElement(tag);
    if (tag === "input" || tag === "textarea" || tag === "select" || isCustomElement) {
      let directiveToUse = V_MODEL_TEXT;
      let isInvalidType = false;
      if (tag === "input" || isCustomElement) {
        const type = findProp(node, `type`);
        if (type) {
          if (type.type === 7) {
            directiveToUse = V_MODEL_DYNAMIC;
          } else if (type.value) {
            switch (type.value.content) {
              case "radio":
                directiveToUse = V_MODEL_RADIO;
                break;
              case "checkbox":
                directiveToUse = V_MODEL_CHECKBOX;
                break;
              case "file":
                isInvalidType = true;
                context.onError(
                  createDOMCompilerError(
                    59,
                    dir.loc
                  )
                );
                break;
            }
          }
        } else if (hasDynamicKeyVBind(node)) {
          directiveToUse = V_MODEL_DYNAMIC;
        } else
          ;
      } else if (tag === "select") {
        directiveToUse = V_MODEL_SELECT;
      } else
        ;
      if (!isInvalidType) {
        baseResult.needRuntime = context.helper(directiveToUse);
      }
    } else {
      context.onError(
        createDOMCompilerError(
          57,
          dir.loc
        )
      );
    }
    baseResult.props = baseResult.props.filter(
      (p) => !(p.key.type === 4 && p.key.content === "modelValue")
    );
    return baseResult;
  };
  const isEventOptionModifier = /* @__PURE__ */ makeMap$1(`passive,once,capture`);
  const isNonKeyModifier = /* @__PURE__ */ makeMap$1(
    // event propagation management
    `stop,prevent,self,ctrl,shift,alt,meta,exact,middle`
  );
  const maybeKeyModifier = /* @__PURE__ */ makeMap$1("left,right");
  const isKeyboardEvent = /* @__PURE__ */ makeMap$1(
    `onkeyup,onkeydown,onkeypress`,
    true
  );
  const resolveModifiers = (key, modifiers2, context, loc) => {
    const keyModifiers = [];
    const nonKeyModifiers = [];
    const eventOptionModifiers = [];
    for (let i = 0; i < modifiers2.length; i++) {
      const modifier = modifiers2[i];
      if (modifier === "native" && checkCompatEnabled(
        "COMPILER_V_ON_NATIVE",
        context
      )) {
        eventOptionModifiers.push(modifier);
      } else if (isEventOptionModifier(modifier)) {
        eventOptionModifiers.push(modifier);
      } else {
        if (maybeKeyModifier(modifier)) {
          if (isStaticExp(key)) {
            if (isKeyboardEvent(key.content)) {
              keyModifiers.push(modifier);
            } else {
              nonKeyModifiers.push(modifier);
            }
          } else {
            keyModifiers.push(modifier);
            nonKeyModifiers.push(modifier);
          }
        } else {
          if (isNonKeyModifier(modifier)) {
            nonKeyModifiers.push(modifier);
          } else {
            keyModifiers.push(modifier);
          }
        }
      }
    }
    return {
      keyModifiers,
      nonKeyModifiers,
      eventOptionModifiers
    };
  };
  const transformClick = (key, event) => {
    const isStaticClick = isStaticExp(key) && key.content.toLowerCase() === "onclick";
    return isStaticClick ? createSimpleExpression(event, true) : key.type !== 4 ? createCompoundExpression([
      `(`,
      key,
      `) === "onClick" ? "${event}" : (`,
      key,
      `)`
    ]) : key;
  };
  const transformOn = (dir, node, context) => {
    return transformOn$1(dir, node, context, (baseResult) => {
      const { modifiers: modifiers2 } = dir;
      if (!modifiers2.length)
        return baseResult;
      let { key, value: handlerExp } = baseResult.props[0];
      const { keyModifiers, nonKeyModifiers, eventOptionModifiers } = resolveModifiers(key, modifiers2, context, dir.loc);
      if (nonKeyModifiers.includes("right")) {
        key = transformClick(key, `onContextmenu`);
      }
      if (nonKeyModifiers.includes("middle")) {
        key = transformClick(key, `onMouseup`);
      }
      if (nonKeyModifiers.length) {
        handlerExp = createCallExpression(context.helper(V_ON_WITH_MODIFIERS), [
          handlerExp,
          JSON.stringify(nonKeyModifiers)
        ]);
      }
      if (keyModifiers.length && // if event name is dynamic, always wrap with keys guard
      (!isStaticExp(key) || isKeyboardEvent(key.content))) {
        handlerExp = createCallExpression(context.helper(V_ON_WITH_KEYS), [
          handlerExp,
          JSON.stringify(keyModifiers)
        ]);
      }
      if (eventOptionModifiers.length) {
        const modifierPostfix = eventOptionModifiers.map(capitalize$1).join("");
        key = isStaticExp(key) ? createSimpleExpression(`${key.content}${modifierPostfix}`, true) : createCompoundExpression([`(`, key, `) + "${modifierPostfix}"`]);
      }
      return {
        props: [createObjectProperty(key, handlerExp)]
      };
    });
  };
  const transformShow = (dir, node, context) => {
    const { exp, loc } = dir;
    if (!exp) {
      context.onError(
        createDOMCompilerError(61, loc)
      );
    }
    return {
      props: [],
      needRuntime: context.helper(V_SHOW)
    };
  };
  const ignoreSideEffectTags = (node, context) => {
    if (node.type === 1 && node.tagType === 0 && (node.tag === "script" || node.tag === "style")) {
      context.removeNode();
    }
  };
  const DOMNodeTransforms = [
    transformStyle,
    ...[]
  ];
  const DOMDirectiveTransforms = {
    cloak: noopDirectiveTransform,
    html: transformVHtml,
    text: transformVText,
    model: transformModel$1,
    // override compiler-core
    on: transformOn,
    // override compiler-core
    show: transformShow
  };
  function compile$2(template2, options = {}) {
    return baseCompile(
      template2,
      extend$1({}, parserOptions, options, {
        nodeTransforms: [
          // ignore <script> and <tag>
          // this is not put inside DOMNodeTransforms because that list is used
          // by compiler-ssr to generate vnode fallback branches
          ignoreSideEffectTags,
          ...DOMNodeTransforms,
          ...options.nodeTransforms || []
        ],
        directiveTransforms: extend$1(
          {},
          DOMDirectiveTransforms,
          options.directiveTransforms || {}
        ),
        transformHoist: null
      })
    );
  }
  function parse$c(template2, options = {}) {
    return baseParse(template2, extend$1({}, parserOptions, options));
  }
  var compilerDom_esmBundler = /* @__PURE__ */ Object.freeze({
    __proto__: null,
    BASE_TRANSITION,
    CAMELIZE,
    CAPITALIZE,
    CREATE_BLOCK,
    CREATE_COMMENT,
    CREATE_ELEMENT_BLOCK,
    CREATE_ELEMENT_VNODE,
    CREATE_SLOTS,
    CREATE_STATIC,
    CREATE_TEXT,
    CREATE_VNODE,
    DOMDirectiveTransforms,
    DOMNodeTransforms,
    FRAGMENT,
    GUARD_REACTIVE_PROPS,
    IS_MEMO_SAME,
    IS_REF,
    KEEP_ALIVE,
    MERGE_PROPS,
    NORMALIZE_CLASS,
    NORMALIZE_PROPS,
    NORMALIZE_STYLE,
    OPEN_BLOCK,
    POP_SCOPE_ID,
    PUSH_SCOPE_ID,
    RENDER_LIST,
    RENDER_SLOT,
    RESOLVE_COMPONENT,
    RESOLVE_DIRECTIVE,
    RESOLVE_DYNAMIC_COMPONENT,
    RESOLVE_FILTER,
    SET_BLOCK_TRACKING,
    SUSPENSE,
    TELEPORT,
    TO_DISPLAY_STRING,
    TO_HANDLERS,
    TO_HANDLER_KEY,
    TRANSITION,
    TRANSITION_GROUP,
    TS_NODE_TYPES,
    UNREF,
    V_MODEL_CHECKBOX,
    V_MODEL_DYNAMIC,
    V_MODEL_RADIO,
    V_MODEL_SELECT,
    V_MODEL_TEXT,
    V_ON_WITH_KEYS,
    V_ON_WITH_MODIFIERS,
    V_SHOW,
    WITH_CTX,
    WITH_DIRECTIVES,
    WITH_MEMO,
    advancePositionWithClone,
    advancePositionWithMutation,
    assert,
    baseCompile,
    baseParse,
    buildDirectiveArgs,
    buildProps,
    buildSlots,
    checkCompatEnabled,
    compile: compile$2,
    convertToBlock,
    createArrayExpression,
    createAssignmentExpression,
    createBlockStatement,
    createCacheExpression,
    createCallExpression,
    createCompilerError,
    createCompoundExpression,
    createConditionalExpression,
    createDOMCompilerError,
    createForLoopParams,
    createFunctionExpression,
    createIfStatement,
    createInterpolation,
    createObjectExpression,
    createObjectProperty,
    createReturnStatement,
    createRoot,
    createSequenceExpression,
    createSimpleExpression,
    createStructuralDirectiveTransform,
    createTemplateLiteral,
    createTransformContext,
    createVNodeCall,
    extractIdentifiers,
    findDir,
    findProp,
    generate: generate$4,
    generateCodeFrame: generateCodeFrame$1,
    getBaseTransformPreset,
    getConstantType,
    getInnerRange,
    getMemoedVNodeCall,
    getVNodeBlockHelper,
    getVNodeHelper,
    hasDynamicKeyVBind,
    hasScopeRef,
    helperNameMap,
    injectProp,
    isBuiltInType,
    isCoreComponent,
    isFunctionType,
    isInDestructureAssignment,
    isMemberExpression,
    isMemberExpressionBrowser,
    isMemberExpressionNode,
    isReferencedIdentifier,
    isSimpleIdentifier,
    isSlotOutlet,
    isStaticArgOf,
    isStaticExp,
    isStaticProperty,
    isStaticPropertyKey,
    isTemplateNode,
    isText: isText$1,
    isVSlot,
    locStub,
    noopDirectiveTransform,
    parse: parse$c,
    parserOptions,
    processExpression,
    processFor: processFor$1,
    processIf: processIf$1,
    processSlotOutlet: processSlotOutlet$1,
    registerRuntimeHelpers,
    resolveComponentType,
    stringifyExpression,
    toValidAssetId,
    trackSlotScopes,
    trackVForSlotScopes,
    transform: transform$1,
    transformBind,
    transformElement,
    transformExpression,
    transformModel: transformModel$2,
    transformOn: transformOn$1,
    transformStyle,
    traverseNode,
    walkBlockDeclarations,
    walkFunctionParams,
    walkIdentifiers: walkIdentifiers$1,
    warnDeprecation
  });
  var require$$9$1 = /* @__PURE__ */ getAugmentedNamespace(compilerDom_esmBundler);
  var require$$1$3 = /* @__PURE__ */ getAugmentedNamespace(shared_esmBundler);
  var transform = {};
  Object.defineProperty(transform, "__esModule", { value: true });
  transform.colletVars = transform.walkInterpolationFragment = void 0;
  const shared_1$x = require$$1$3;
  function walkInterpolationFragment(ts2, code, ast2, cb, localVars, identifiers2, vueOptions) {
    let ctxVars = [];
    const varCb = (id, isShorthand) => {
      if (!!localVars[id.text] || // https://github.com/vuejs/core/blob/245230e135152900189f13a4281302de45fdcfaa/packages/compiler-core/src/transforms/transformExpression.ts#L342-L352
      (0, shared_1$x.isGloballyWhitelisted)(id.text) || id.text === "require" || id.text.startsWith("__VLS_"))
        ;
      else {
        ctxVars.push({
          text: id.text,
          isShorthand,
          offset: id.getStart(ast2)
        });
        identifiers2.add(id.text);
      }
    };
    ast2.forEachChild((node) => walkIdentifiers(ts2, node, varCb, localVars));
    ctxVars = ctxVars.sort((a2, b) => a2.offset - b.offset);
    if (ctxVars.length) {
      if (ctxVars[0].isShorthand) {
        cb(code.substring(0, ctxVars[0].offset + ctxVars[0].text.length), 0);
        cb(": ", void 0);
      } else {
        cb(code.substring(0, ctxVars[0].offset), 0);
      }
      for (let i = 0; i < ctxVars.length - 1; i++) {
        cb("", ctxVars[i + 1].offset, true);
        if (vueOptions.experimentalUseElementAccessInTemplate) {
          const varStart = ctxVars[i].offset;
          const varEnd = ctxVars[i].offset + ctxVars[i].text.length;
          cb("__VLS_ctx[", void 0);
          cb("", varStart, true);
          cb("'", void 0);
          cb(code.substring(varStart, varEnd), varStart);
          cb("'", void 0);
          cb("", varEnd, true);
          cb("]", void 0);
          if (ctxVars[i + 1].isShorthand) {
            cb(code.substring(varEnd, ctxVars[i + 1].offset + ctxVars[i + 1].text.length), varEnd);
            cb(": ", void 0);
          } else {
            cb(code.substring(varEnd, ctxVars[i + 1].offset), varEnd);
          }
        } else {
          cb("__VLS_ctx.", void 0);
          if (ctxVars[i + 1].isShorthand) {
            cb(code.substring(ctxVars[i].offset, ctxVars[i + 1].offset + ctxVars[i + 1].text.length), ctxVars[i].offset);
            cb(": ", void 0);
          } else {
            cb(code.substring(ctxVars[i].offset, ctxVars[i + 1].offset), ctxVars[i].offset);
          }
        }
      }
      if (vueOptions.experimentalUseElementAccessInTemplate) {
        const varStart = ctxVars[ctxVars.length - 1].offset;
        const varEnd = ctxVars[ctxVars.length - 1].offset + ctxVars[ctxVars.length - 1].text.length;
        cb("__VLS_ctx[", void 0);
        cb("", varStart, true);
        cb("'", void 0);
        cb(code.substring(varStart, varEnd), varStart);
        cb("'", void 0);
        cb("", varEnd, true);
        cb("]", void 0);
        cb(code.substring(varEnd), varEnd);
      } else {
        cb("", ctxVars[ctxVars.length - 1].offset, true);
        cb("__VLS_ctx.", void 0);
        cb(code.substring(ctxVars[ctxVars.length - 1].offset), ctxVars[ctxVars.length - 1].offset);
      }
    } else {
      cb(code, 0);
    }
    return ctxVars;
  }
  transform.walkInterpolationFragment = walkInterpolationFragment;
  function walkIdentifiers(ts2, node, cb, localVars, blockVars = [], isRoot = true) {
    if (ts2.isIdentifier(node)) {
      cb(node, false);
    } else if (ts2.isShorthandPropertyAssignment(node)) {
      cb(node.name, true);
    } else if (ts2.isPropertyAccessExpression(node)) {
      walkIdentifiers(ts2, node.expression, cb, localVars, blockVars, false);
    } else if (ts2.isVariableDeclaration(node)) {
      colletVars(ts2, node.name, blockVars);
      for (const varName of blockVars) {
        localVars[varName] = (localVars[varName] ?? 0) + 1;
      }
      if (node.initializer)
        walkIdentifiers(ts2, node.initializer, cb, localVars, blockVars, false);
    } else if (ts2.isArrowFunction(node) || ts2.isFunctionExpression(node)) {
      const functionArgs = [];
      for (const param of node.parameters) {
        colletVars(ts2, param.name, functionArgs);
        if (param.type) {
          walkIdentifiers(ts2, param.type, cb, localVars, blockVars, false);
        }
      }
      for (const varName of functionArgs)
        localVars[varName] = (localVars[varName] ?? 0) + 1;
      walkIdentifiers(ts2, node.body, cb, localVars, blockVars, false);
      for (const varName of functionArgs)
        localVars[varName]--;
    } else if (ts2.isObjectLiteralExpression(node)) {
      for (const prop of node.properties) {
        if (ts2.isPropertyAssignment(prop)) {
          if (ts2.isComputedPropertyName(prop.name)) {
            walkIdentifiers(ts2, prop.name.expression, cb, localVars, blockVars, false);
          }
          walkIdentifiers(ts2, prop.initializer, cb, localVars, blockVars, false);
        } else if (ts2.isShorthandPropertyAssignment(prop)) {
          walkIdentifiers(ts2, prop, cb, localVars, blockVars, false);
        } else if (ts2.isSpreadAssignment(prop)) {
          walkIdentifiers(ts2, prop.expression, cb, localVars, blockVars, false);
        }
      }
    } else if (ts2.isTypeReferenceNode(node)) {
      node.forEachChild((node2) => walkIdentifiersInTypeReference(ts2, node2, cb));
    } else {
      const _blockVars = blockVars;
      if (ts2.isBlock(node)) {
        blockVars = [];
      }
      node.forEachChild((node2) => walkIdentifiers(ts2, node2, cb, localVars, blockVars, false));
      if (ts2.isBlock(node)) {
        for (const varName of blockVars) {
          localVars[varName]--;
        }
      }
      blockVars = _blockVars;
    }
    if (isRoot) {
      for (const varName of blockVars) {
        localVars[varName]--;
      }
    }
  }
  function walkIdentifiersInTypeReference(ts2, node, cb) {
    if (ts2.isTypeQueryNode(node) && ts2.isIdentifier(node.exprName)) {
      cb(node.exprName, false);
    } else {
      node.forEachChild((node2) => walkIdentifiersInTypeReference(ts2, node2, cb));
    }
  }
  function colletVars(ts2, node, result) {
    if (ts2.isIdentifier(node)) {
      result.push(node.text);
    } else if (ts2.isObjectBindingPattern(node)) {
      for (const el of node.elements) {
        colletVars(ts2, el.name, result);
      }
    } else if (ts2.isArrayBindingPattern(node)) {
      for (const el of node.elements) {
        if (ts2.isBindingElement(el)) {
          colletVars(ts2, el.name, result);
        }
      }
    } else {
      node.forEachChild((node2) => colletVars(ts2, node2, result));
    }
  }
  transform.colletVars = colletVars;
  var cjs = {};
  var balancedMatch = balanced$1;
  function balanced$1(a2, b, str2) {
    if (a2 instanceof RegExp)
      a2 = maybeMatch(a2, str2);
    if (b instanceof RegExp)
      b = maybeMatch(b, str2);
    var r = range$2(a2, b, str2);
    return r && {
      start: r[0],
      end: r[1],
      pre: str2.slice(0, r[0]),
      body: str2.slice(r[0] + a2.length, r[1]),
      post: str2.slice(r[1] + b.length)
    };
  }
  function maybeMatch(reg, str2) {
    var m = str2.match(reg);
    return m ? m[0] : null;
  }
  balanced$1.range = range$2;
  function range$2(a2, b, str2) {
    var begs, beg, left, right, result;
    var ai = str2.indexOf(a2);
    var bi = str2.indexOf(b, ai + 1);
    var i = ai;
    if (ai >= 0 && bi > 0) {
      if (a2 === b) {
        return [ai, bi];
      }
      begs = [];
      left = str2.length;
      while (i >= 0 && !result) {
        if (i == ai) {
          begs.push(i);
          ai = str2.indexOf(a2, i + 1);
        } else if (begs.length == 1) {
          result = [begs.pop(), bi];
        } else {
          beg = begs.pop();
          if (beg < left) {
            left = beg;
            right = bi;
          }
          bi = str2.indexOf(b, i + 1);
        }
        i = ai < bi && ai >= 0 ? ai : bi;
      }
      if (begs.length) {
        result = [left, right];
      }
    }
    return result;
  }
  var balanced = balancedMatch;
  var braceExpansion = expandTop;
  var escSlash = "\0SLASH" + Math.random() + "\0";
  var escOpen = "\0OPEN" + Math.random() + "\0";
  var escClose = "\0CLOSE" + Math.random() + "\0";
  var escComma = "\0COMMA" + Math.random() + "\0";
  var escPeriod = "\0PERIOD" + Math.random() + "\0";
  function numeric$1(str2) {
    return parseInt(str2, 10) == str2 ? parseInt(str2, 10) : str2.charCodeAt(0);
  }
  function escapeBraces(str2) {
    return str2.split("\\\\").join(escSlash).split("\\{").join(escOpen).split("\\}").join(escClose).split("\\,").join(escComma).split("\\.").join(escPeriod);
  }
  function unescapeBraces(str2) {
    return str2.split(escSlash).join("\\").split(escOpen).join("{").split(escClose).join("}").split(escComma).join(",").split(escPeriod).join(".");
  }
  function parseCommaParts(str2) {
    if (!str2)
      return [""];
    var parts = [];
    var m = balanced("{", "}", str2);
    if (!m)
      return str2.split(",");
    var pre = m.pre;
    var body = m.body;
    var post = m.post;
    var p = pre.split(",");
    p[p.length - 1] += "{" + body + "}";
    var postParts = parseCommaParts(post);
    if (post.length) {
      p[p.length - 1] += postParts.shift();
      p.push.apply(p, postParts);
    }
    parts.push.apply(parts, p);
    return parts;
  }
  function expandTop(str2) {
    if (!str2)
      return [];
    if (str2.substr(0, 2) === "{}") {
      str2 = "\\{\\}" + str2.substr(2);
    }
    return expand(escapeBraces(str2), true).map(unescapeBraces);
  }
  function embrace(str2) {
    return "{" + str2 + "}";
  }
  function isPadded(el) {
    return /^-?0\d/.test(el);
  }
  function lte$4(i, y) {
    return i <= y;
  }
  function gte$4(i, y) {
    return i >= y;
  }
  function expand(str2, isTop) {
    var expansions = [];
    var m = balanced("{", "}", str2);
    if (!m)
      return [str2];
    var pre = m.pre;
    var post = m.post.length ? expand(m.post, false) : [""];
    if (/\$$/.test(m.pre)) {
      for (var k = 0; k < post.length; k++) {
        var expansion = pre + "{" + m.body + "}" + post[k];
        expansions.push(expansion);
      }
    } else {
      var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
      var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
      var isSequence = isNumericSequence || isAlphaSequence;
      var isOptions = m.body.indexOf(",") >= 0;
      if (!isSequence && !isOptions) {
        if (m.post.match(/,.*\}/)) {
          str2 = m.pre + "{" + m.body + escClose + m.post;
          return expand(str2);
        }
        return [str2];
      }
      var n;
      if (isSequence) {
        n = m.body.split(/\.\./);
      } else {
        n = parseCommaParts(m.body);
        if (n.length === 1) {
          n = expand(n[0], false).map(embrace);
          if (n.length === 1) {
            return post.map(function(p) {
              return m.pre + n[0] + p;
            });
          }
        }
      }
      var N;
      if (isSequence) {
        var x = numeric$1(n[0]);
        var y = numeric$1(n[1]);
        var width = Math.max(n[0].length, n[1].length);
        var incr = n.length == 3 ? Math.abs(numeric$1(n[2])) : 1;
        var test = lte$4;
        var reverse = y < x;
        if (reverse) {
          incr *= -1;
          test = gte$4;
        }
        var pad = n.some(isPadded);
        N = [];
        for (var i = x; test(i, y); i += incr) {
          var c;
          if (isAlphaSequence) {
            c = String.fromCharCode(i);
            if (c === "\\")
              c = "";
          } else {
            c = String(i);
            if (pad) {
              var need = width - c.length;
              if (need > 0) {
                var z = new Array(need + 1).join("0");
                if (i < 0)
                  c = "-" + z + c.slice(1);
                else
                  c = z + c;
              }
            }
          }
          N.push(c);
        }
      } else {
        N = [];
        for (var j = 0; j < n.length; j++) {
          N.push.apply(N, expand(n[j], false));
        }
      }
      for (var j = 0; j < N.length; j++) {
        for (var k = 0; k < post.length; k++) {
          var expansion = pre + N[j] + post[k];
          if (!isTop || isSequence || expansion)
            expansions.push(expansion);
        }
      }
    }
    return expansions;
  }
  var assertValidPattern$1 = {};
  Object.defineProperty(assertValidPattern$1, "__esModule", { value: true });
  assertValidPattern$1.assertValidPattern = void 0;
  const MAX_PATTERN_LENGTH = 1024 * 64;
  const assertValidPattern = (pattern) => {
    if (typeof pattern !== "string") {
      throw new TypeError("invalid pattern");
    }
    if (pattern.length > MAX_PATTERN_LENGTH) {
      throw new TypeError("pattern is too long");
    }
  };
  assertValidPattern$1.assertValidPattern = assertValidPattern;
  var ast = {};
  var braceExpressions = {};
  Object.defineProperty(braceExpressions, "__esModule", { value: true });
  braceExpressions.parseClass = void 0;
  const posixClasses = {
    "[:alnum:]": ["\\p{L}\\p{Nl}\\p{Nd}", true],
    "[:alpha:]": ["\\p{L}\\p{Nl}", true],
    "[:ascii:]": ["\\x00-\\x7f", false],
    "[:blank:]": ["\\p{Zs}\\t", true],
    "[:cntrl:]": ["\\p{Cc}", true],
    "[:digit:]": ["\\p{Nd}", true],
    "[:graph:]": ["\\p{Z}\\p{C}", true, true],
    "[:lower:]": ["\\p{Ll}", true],
    "[:print:]": ["\\p{C}", true],
    "[:punct:]": ["\\p{P}", true],
    "[:space:]": ["\\p{Z}\\t\\r\\n\\v\\f", true],
    "[:upper:]": ["\\p{Lu}", true],
    "[:word:]": ["\\p{L}\\p{Nl}\\p{Nd}\\p{Pc}", true],
    "[:xdigit:]": ["A-Fa-f0-9", false]
  };
  const braceEscape = (s) => s.replace(/[[\]\\-]/g, "\\$&");
  const regexpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
  const rangesToString = (ranges) => ranges.join("");
  const parseClass = (glob, position) => {
    const pos = position;
    if (glob.charAt(pos) !== "[") {
      throw new Error("not in a brace expression");
    }
    const ranges = [];
    const negs = [];
    let i = pos + 1;
    let sawStart = false;
    let uflag = false;
    let escaping = false;
    let negate = false;
    let endPos = pos;
    let rangeStart = "";
    WHILE:
      while (i < glob.length) {
        const c = glob.charAt(i);
        if ((c === "!" || c === "^") && i === pos + 1) {
          negate = true;
          i++;
          continue;
        }
        if (c === "]" && sawStart && !escaping) {
          endPos = i + 1;
          break;
        }
        sawStart = true;
        if (c === "\\") {
          if (!escaping) {
            escaping = true;
            i++;
            continue;
          }
        }
        if (c === "[" && !escaping) {
          for (const [cls, [unip, u, neg]] of Object.entries(posixClasses)) {
            if (glob.startsWith(cls, i)) {
              if (rangeStart) {
                return ["$.", false, glob.length - pos, true];
              }
              i += cls.length;
              if (neg)
                negs.push(unip);
              else
                ranges.push(unip);
              uflag = uflag || u;
              continue WHILE;
            }
          }
        }
        escaping = false;
        if (rangeStart) {
          if (c > rangeStart) {
            ranges.push(braceEscape(rangeStart) + "-" + braceEscape(c));
          } else if (c === rangeStart) {
            ranges.push(braceEscape(c));
          }
          rangeStart = "";
          i++;
          continue;
        }
        if (glob.startsWith("-]", i + 1)) {
          ranges.push(braceEscape(c + "-"));
          i += 2;
          continue;
        }
        if (glob.startsWith("-", i + 1)) {
          rangeStart = c;
          i += 2;
          continue;
        }
        ranges.push(braceEscape(c));
        i++;
      }
    if (endPos < i) {
      return ["", false, 0, false];
    }
    if (!ranges.length && !negs.length) {
      return ["$.", false, glob.length - pos, true];
    }
    if (negs.length === 0 && ranges.length === 1 && /^\\?.$/.test(ranges[0]) && !negate) {
      const r = ranges[0].length === 2 ? ranges[0].slice(-1) : ranges[0];
      return [regexpEscape(r), false, endPos - pos, false];
    }
    const sranges = "[" + (negate ? "^" : "") + rangesToString(ranges) + "]";
    const snegs = "[" + (negate ? "" : "^") + rangesToString(negs) + "]";
    const comb = ranges.length && negs.length ? "(" + sranges + "|" + snegs + ")" : ranges.length ? sranges : snegs;
    return [comb, uflag, endPos - pos, true];
  };
  braceExpressions.parseClass = parseClass;
  var _unescape = {};
  Object.defineProperty(_unescape, "__esModule", { value: true });
  _unescape.unescape = void 0;
  const unescape$3 = (s, { windowsPathsNoEscape = false } = {}) => {
    return windowsPathsNoEscape ? s.replace(/\[([^\/\\])\]/g, "$1") : s.replace(/((?!\\).|^)\[([^\/\\])\]/g, "$1$2").replace(/\\([^\/])/g, "$1");
  };
  _unescape.unescape = unescape$3;
  Object.defineProperty(ast, "__esModule", { value: true });
  ast.AST = void 0;
  const brace_expressions_js_1 = braceExpressions;
  const unescape_js_1 = _unescape;
  const types$2 = /* @__PURE__ */ new Set(["!", "?", "+", "*", "@"]);
  const isExtglobType = (c) => types$2.has(c);
  const startNoTraversal = "(?!(?:^|/)\\.\\.?(?:$|/))";
  const startNoDot = "(?!\\.)";
  const addPatternStart = /* @__PURE__ */ new Set(["[", "."]);
  const justDots = /* @__PURE__ */ new Set(["..", "."]);
  const reSpecials = new Set("().*{}+?[]^$\\!");
  const regExpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
  const qmark = "[^/]";
  const star = qmark + "*?";
  const starNoEmpty = qmark + "+?";
  const _AST = class _AST {
    constructor(type, parent, options = {}) {
      __privateAdd(this, _fillNegs);
      __privateAdd(this, _partsToRegExp);
      __publicField(this, "type");
      __privateAdd(this, _root, void 0);
      __privateAdd(this, _hasMagic, void 0);
      __privateAdd(this, _uflag, false);
      __privateAdd(this, _parts, []);
      __privateAdd(this, _parent, void 0);
      __privateAdd(this, _parentIndex, void 0);
      __privateAdd(this, _negs, void 0);
      __privateAdd(this, _filledNegs, false);
      __privateAdd(this, _options, void 0);
      __privateAdd(this, _toString2, void 0);
      // set to true if it's an extglob with no children
      // (which really means one child of '')
      __privateAdd(this, _emptyExt, false);
      this.type = type;
      if (type)
        __privateSet(this, _hasMagic, true);
      __privateSet(this, _parent, parent);
      __privateSet(this, _root, __privateGet(this, _parent) ? __privateGet(__privateGet(this, _parent), _root) : this);
      __privateSet(this, _options, __privateGet(this, _root) === this ? options : __privateGet(__privateGet(this, _root), _options));
      __privateSet(this, _negs, __privateGet(this, _root) === this ? [] : __privateGet(__privateGet(this, _root), _negs));
      if (type === "!" && !__privateGet(__privateGet(this, _root), _filledNegs))
        __privateGet(this, _negs).push(this);
      __privateSet(this, _parentIndex, __privateGet(this, _parent) ? __privateGet(__privateGet(this, _parent), _parts).length : 0);
    }
    get hasMagic() {
      if (__privateGet(this, _hasMagic) !== void 0)
        return __privateGet(this, _hasMagic);
      for (const p of __privateGet(this, _parts)) {
        if (typeof p === "string")
          continue;
        if (p.type || p.hasMagic)
          return __privateSet(this, _hasMagic, true);
      }
      return __privateGet(this, _hasMagic);
    }
    // reconstructs the pattern
    toString() {
      if (__privateGet(this, _toString2) !== void 0)
        return __privateGet(this, _toString2);
      if (!this.type) {
        return __privateSet(this, _toString2, __privateGet(this, _parts).map((p) => String(p)).join(""));
      } else {
        return __privateSet(this, _toString2, this.type + "(" + __privateGet(this, _parts).map((p) => String(p)).join("|") + ")");
      }
    }
    push(...parts) {
      for (const p of parts) {
        if (p === "")
          continue;
        if (typeof p !== "string" && !(p instanceof _AST && __privateGet(p, _parent) === this)) {
          throw new Error("invalid part: " + p);
        }
        __privateGet(this, _parts).push(p);
      }
    }
    toJSON() {
      var _a2;
      const ret = this.type === null ? __privateGet(this, _parts).slice().map((p) => typeof p === "string" ? p : p.toJSON()) : [this.type, ...__privateGet(this, _parts).map((p) => p.toJSON())];
      if (this.isStart() && !this.type)
        ret.unshift([]);
      if (this.isEnd() && (this === __privateGet(this, _root) || __privateGet(__privateGet(this, _root), _filledNegs) && ((_a2 = __privateGet(this, _parent)) == null ? void 0 : _a2.type) === "!")) {
        ret.push({});
      }
      return ret;
    }
    isStart() {
      var _a2;
      if (__privateGet(this, _root) === this)
        return true;
      if (!((_a2 = __privateGet(this, _parent)) == null ? void 0 : _a2.isStart()))
        return false;
      if (__privateGet(this, _parentIndex) === 0)
        return true;
      const p = __privateGet(this, _parent);
      for (let i = 0; i < __privateGet(this, _parentIndex); i++) {
        const pp = __privateGet(p, _parts)[i];
        if (!(pp instanceof _AST && pp.type === "!")) {
          return false;
        }
      }
      return true;
    }
    isEnd() {
      var _a2, _b, _c;
      if (__privateGet(this, _root) === this)
        return true;
      if (((_a2 = __privateGet(this, _parent)) == null ? void 0 : _a2.type) === "!")
        return true;
      if (!((_b = __privateGet(this, _parent)) == null ? void 0 : _b.isEnd()))
        return false;
      if (!this.type)
        return (_c = __privateGet(this, _parent)) == null ? void 0 : _c.isEnd();
      const pl = __privateGet(this, _parent) ? __privateGet(__privateGet(this, _parent), _parts).length : 0;
      return __privateGet(this, _parentIndex) === pl - 1;
    }
    copyIn(part) {
      if (typeof part === "string")
        this.push(part);
      else
        this.push(part.clone(this));
    }
    clone(parent) {
      const c = new _AST(this.type, parent);
      for (const p of __privateGet(this, _parts)) {
        c.copyIn(p);
      }
      return c;
    }
    static fromGlob(pattern, options = {}) {
      var _a2;
      const ast2 = new _AST(null, void 0, options);
      __privateMethod(_a2 = _AST, _parseAST, parseAST_fn).call(_a2, pattern, ast2, 0, options);
      return ast2;
    }
    // returns the regular expression if there's magic, or the unescaped
    // string if not.
    toMMPattern() {
      if (this !== __privateGet(this, _root))
        return __privateGet(this, _root).toMMPattern();
      const glob = this.toString();
      const [re2, body, hasMagic, uflag] = this.toRegExpSource();
      const anyMagic = hasMagic || __privateGet(this, _hasMagic) || __privateGet(this, _options).nocase && !__privateGet(this, _options).nocaseMagicOnly && glob.toUpperCase() !== glob.toLowerCase();
      if (!anyMagic) {
        return body;
      }
      const flags = (__privateGet(this, _options).nocase ? "i" : "") + (uflag ? "u" : "");
      return Object.assign(new RegExp(`^${re2}$`, flags), {
        _src: re2,
        _glob: glob
      });
    }
    // returns the string match, the regexp source, whether there's magic
    // in the regexp (so a regular expression is required) and whether or
    // not the uflag is needed for the regular expression (for posix classes)
    // TODO: instead of injecting the start/end at this point, just return
    // the BODY of the regexp, along with the start/end portions suitable
    // for binding the start/end in either a joined full-path makeRe context
    // (where we bind to (^|/), or a standalone matchPart context (where
    // we bind to ^, and not /).  Otherwise slashes get duped!
    //
    // In part-matching mode, the start is:
    // - if not isStart: nothing
    // - if traversal possible, but not allowed: ^(?!\.\.?$)
    // - if dots allowed or not possible: ^
    // - if dots possible and not allowed: ^(?!\.)
    // end is:
    // - if not isEnd(): nothing
    // - else: $
    //
    // In full-path matching mode, we put the slash at the START of the
    // pattern, so start is:
    // - if first pattern: same as part-matching mode
    // - if not isStart(): nothing
    // - if traversal possible, but not allowed: /(?!\.\.?(?:$|/))
    // - if dots allowed or not possible: /
    // - if dots possible and not allowed: /(?!\.)
    // end is:
    // - if last pattern, same as part-matching mode
    // - else nothing
    //
    // Always put the (?:$|/) on negated tails, though, because that has to be
    // there to bind the end of the negated pattern portion, and it's easier to
    // just stick it in now rather than try to inject it later in the middle of
    // the pattern.
    //
    // We can just always return the same end, and leave it up to the caller
    // to know whether it's going to be used joined or in parts.
    // And, if the start is adjusted slightly, can do the same there:
    // - if not isStart: nothing
    // - if traversal possible, but not allowed: (?:/|^)(?!\.\.?$)
    // - if dots allowed or not possible: (?:/|^)
    // - if dots possible and not allowed: (?:/|^)(?!\.)
    //
    // But it's better to have a simpler binding without a conditional, for
    // performance, so probably better to return both start options.
    //
    // Then the caller just ignores the end if it's not the first pattern,
    // and the start always gets applied.
    //
    // But that's always going to be $ if it's the ending pattern, or nothing,
    // so the caller can just attach $ at the end of the pattern when building.
    //
    // So the todo is:
    // - better detect what kind of start is needed
    // - return both flavors of starting pattern
    // - attach $ at the end of the pattern when creating the actual RegExp
    //
    // Ah, but wait, no, that all only applies to the root when the first pattern
    // is not an extglob. If the first pattern IS an extglob, then we need all
    // that dot prevention biz to live in the extglob portions, because eg
    // +(*|.x*) can match .xy but not .yx.
    //
    // So, return the two flavors if it's #root and the first child is not an
    // AST, otherwise leave it to the child AST to handle it, and there,
    // use the (?:^|/) style of start binding.
    //
    // Even simplified further:
    // - Since the start for a join is eg /(?!\.) and the start for a part
    // is ^(?!\.), we can just prepend (?!\.) to the pattern (either root
    // or start or whatever) and prepend ^ or / at the Regexp construction.
    toRegExpSource(allowDot) {
      var _a2;
      const dot = allowDot ?? !!__privateGet(this, _options).dot;
      if (__privateGet(this, _root) === this)
        __privateMethod(this, _fillNegs, fillNegs_fn).call(this);
      if (!this.type) {
        const noEmpty = this.isStart() && this.isEnd();
        const src = __privateGet(this, _parts).map((p) => {
          var _a3;
          const [re2, _, hasMagic, uflag] = typeof p === "string" ? __privateMethod(_a3 = _AST, _parseGlob, parseGlob_fn).call(_a3, p, __privateGet(this, _hasMagic), noEmpty) : p.toRegExpSource(allowDot);
          __privateSet(this, _hasMagic, __privateGet(this, _hasMagic) || hasMagic);
          __privateSet(this, _uflag, __privateGet(this, _uflag) || uflag);
          return re2;
        }).join("");
        let start2 = "";
        if (this.isStart()) {
          if (typeof __privateGet(this, _parts)[0] === "string") {
            const dotTravAllowed = __privateGet(this, _parts).length === 1 && justDots.has(__privateGet(this, _parts)[0]);
            if (!dotTravAllowed) {
              const aps = addPatternStart;
              const needNoTrav = (
                // dots are allowed, and the pattern starts with [ or .
                dot && aps.has(src.charAt(0)) || // the pattern starts with \., and then [ or .
                src.startsWith("\\.") && aps.has(src.charAt(2)) || // the pattern starts with \.\., and then [ or .
                src.startsWith("\\.\\.") && aps.has(src.charAt(4))
              );
              const needNoDot = !dot && !allowDot && aps.has(src.charAt(0));
              start2 = needNoTrav ? startNoTraversal : needNoDot ? startNoDot : "";
            }
          }
        }
        let end = "";
        if (this.isEnd() && __privateGet(__privateGet(this, _root), _filledNegs) && ((_a2 = __privateGet(this, _parent)) == null ? void 0 : _a2.type) === "!") {
          end = "(?:$|\\/)";
        }
        const final2 = start2 + src + end;
        return [
          final2,
          (0, unescape_js_1.unescape)(src),
          __privateSet(this, _hasMagic, !!__privateGet(this, _hasMagic)),
          __privateGet(this, _uflag)
        ];
      }
      const repeated = this.type === "*" || this.type === "+";
      const start = this.type === "!" ? "(?:(?!(?:" : "(?:";
      let body = __privateMethod(this, _partsToRegExp, partsToRegExp_fn).call(this, dot);
      if (this.isStart() && this.isEnd() && !body && this.type !== "!") {
        const s = this.toString();
        __privateSet(this, _parts, [s]);
        this.type = null;
        __privateSet(this, _hasMagic, void 0);
        return [s, (0, unescape_js_1.unescape)(this.toString()), false, false];
      }
      let bodyDotAllowed = !repeated || allowDot || dot || !startNoDot ? "" : __privateMethod(this, _partsToRegExp, partsToRegExp_fn).call(this, true);
      if (bodyDotAllowed === body) {
        bodyDotAllowed = "";
      }
      if (bodyDotAllowed) {
        body = `(?:${body})(?:${bodyDotAllowed})*?`;
      }
      let final = "";
      if (this.type === "!" && __privateGet(this, _emptyExt)) {
        final = (this.isStart() && !dot ? startNoDot : "") + starNoEmpty;
      } else {
        const close = this.type === "!" ? (
          // !() must match something,but !(x) can match ''
          "))" + (this.isStart() && !dot && !allowDot ? startNoDot : "") + star + ")"
        ) : this.type === "@" ? ")" : this.type === "?" ? ")?" : this.type === "+" && bodyDotAllowed ? ")" : this.type === "*" && bodyDotAllowed ? `)?` : `)${this.type}`;
        final = start + body + close;
      }
      return [
        final,
        (0, unescape_js_1.unescape)(body),
        __privateSet(this, _hasMagic, !!__privateGet(this, _hasMagic)),
        __privateGet(this, _uflag)
      ];
    }
  };
  _root = new WeakMap();
  _hasMagic = new WeakMap();
  _uflag = new WeakMap();
  _parts = new WeakMap();
  _parent = new WeakMap();
  _parentIndex = new WeakMap();
  _negs = new WeakMap();
  _filledNegs = new WeakMap();
  _options = new WeakMap();
  _toString2 = new WeakMap();
  _emptyExt = new WeakMap();
  _fillNegs = new WeakSet();
  fillNegs_fn = function() {
    if (this !== __privateGet(this, _root))
      throw new Error("should only call on root");
    if (__privateGet(this, _filledNegs))
      return this;
    this.toString();
    __privateSet(this, _filledNegs, true);
    let n;
    while (n = __privateGet(this, _negs).pop()) {
      if (n.type !== "!")
        continue;
      let p = n;
      let pp = __privateGet(p, _parent);
      while (pp) {
        for (let i = __privateGet(p, _parentIndex) + 1; !pp.type && i < __privateGet(pp, _parts).length; i++) {
          for (const part of __privateGet(n, _parts)) {
            if (typeof part === "string") {
              throw new Error("string part in extglob AST??");
            }
            part.copyIn(__privateGet(pp, _parts)[i]);
          }
        }
        p = pp;
        pp = __privateGet(p, _parent);
      }
    }
    return this;
  };
  _parseAST = new WeakSet();
  parseAST_fn = function(str2, ast2, pos, opt) {
    var _a2, _b;
    let escaping = false;
    let inBrace = false;
    let braceStart = -1;
    let braceNeg = false;
    if (ast2.type === null) {
      let i2 = pos;
      let acc2 = "";
      while (i2 < str2.length) {
        const c = str2.charAt(i2++);
        if (escaping || c === "\\") {
          escaping = !escaping;
          acc2 += c;
          continue;
        }
        if (inBrace) {
          if (i2 === braceStart + 1) {
            if (c === "^" || c === "!") {
              braceNeg = true;
            }
          } else if (c === "]" && !(i2 === braceStart + 2 && braceNeg)) {
            inBrace = false;
          }
          acc2 += c;
          continue;
        } else if (c === "[") {
          inBrace = true;
          braceStart = i2;
          braceNeg = false;
          acc2 += c;
          continue;
        }
        if (!opt.noext && isExtglobType(c) && str2.charAt(i2) === "(") {
          ast2.push(acc2);
          acc2 = "";
          const ext = new _AST(c, ast2);
          i2 = __privateMethod(_a2 = _AST, _parseAST, parseAST_fn).call(_a2, str2, ext, i2, opt);
          ast2.push(ext);
          continue;
        }
        acc2 += c;
      }
      ast2.push(acc2);
      return i2;
    }
    let i = pos + 1;
    let part = new _AST(null, ast2);
    const parts = [];
    let acc = "";
    while (i < str2.length) {
      const c = str2.charAt(i++);
      if (escaping || c === "\\") {
        escaping = !escaping;
        acc += c;
        continue;
      }
      if (inBrace) {
        if (i === braceStart + 1) {
          if (c === "^" || c === "!") {
            braceNeg = true;
          }
        } else if (c === "]" && !(i === braceStart + 2 && braceNeg)) {
          inBrace = false;
        }
        acc += c;
        continue;
      } else if (c === "[") {
        inBrace = true;
        braceStart = i;
        braceNeg = false;
        acc += c;
        continue;
      }
      if (isExtglobType(c) && str2.charAt(i) === "(") {
        part.push(acc);
        acc = "";
        const ext = new _AST(c, part);
        part.push(ext);
        i = __privateMethod(_b = _AST, _parseAST, parseAST_fn).call(_b, str2, ext, i, opt);
        continue;
      }
      if (c === "|") {
        part.push(acc);
        acc = "";
        parts.push(part);
        part = new _AST(null, ast2);
        continue;
      }
      if (c === ")") {
        if (acc === "" && __privateGet(ast2, _parts).length === 0) {
          __privateSet(ast2, _emptyExt, true);
        }
        part.push(acc);
        acc = "";
        ast2.push(...parts, part);
        return i;
      }
      acc += c;
    }
    ast2.type = null;
    __privateSet(ast2, _hasMagic, void 0);
    __privateSet(ast2, _parts, [str2.substring(pos - 1)]);
    return i;
  };
  _partsToRegExp = new WeakSet();
  partsToRegExp_fn = function(dot) {
    return __privateGet(this, _parts).map((p) => {
      if (typeof p === "string") {
        throw new Error("string type in extglob ast??");
      }
      const [re2, _, _hasMagic2, uflag] = p.toRegExpSource(dot);
      __privateSet(this, _uflag, __privateGet(this, _uflag) || uflag);
      return re2;
    }).filter((p) => !(this.isStart() && this.isEnd()) || !!p).join("|");
  };
  _parseGlob = new WeakSet();
  parseGlob_fn = function(glob, hasMagic, noEmpty = false) {
    let escaping = false;
    let re2 = "";
    let uflag = false;
    for (let i = 0; i < glob.length; i++) {
      const c = glob.charAt(i);
      if (escaping) {
        escaping = false;
        re2 += (reSpecials.has(c) ? "\\" : "") + c;
        continue;
      }
      if (c === "\\") {
        if (i === glob.length - 1) {
          re2 += "\\\\";
        } else {
          escaping = true;
        }
        continue;
      }
      if (c === "[") {
        const [src, needUflag, consumed, magic] = (0, brace_expressions_js_1.parseClass)(glob, i);
        if (consumed) {
          re2 += src;
          uflag = uflag || needUflag;
          i += consumed - 1;
          hasMagic = hasMagic || magic;
          continue;
        }
      }
      if (c === "*") {
        if (noEmpty && glob === "*")
          re2 += starNoEmpty;
        else
          re2 += star;
        hasMagic = true;
        continue;
      }
      if (c === "?") {
        re2 += qmark;
        hasMagic = true;
        continue;
      }
      re2 += regExpEscape(c);
    }
    return [re2, (0, unescape_js_1.unescape)(glob), !!hasMagic, uflag];
  };
  __privateAdd(_AST, _parseAST);
  __privateAdd(_AST, _parseGlob);
  let AST = _AST;
  ast.AST = AST;
  var _escape = {};
  Object.defineProperty(_escape, "__esModule", { value: true });
  _escape.escape = void 0;
  const escape$1 = (s, { windowsPathsNoEscape = false } = {}) => {
    return windowsPathsNoEscape ? s.replace(/[?*()[\]]/g, "[$&]") : s.replace(/[?*()[\]\\]/g, "\\$&");
  };
  _escape.escape = escape$1;
  (function(exports) {
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.unescape = exports.escape = exports.AST = exports.Minimatch = exports.match = exports.makeRe = exports.braceExpand = exports.defaults = exports.filter = exports.GLOBSTAR = exports.sep = exports.minimatch = void 0;
    const brace_expansion_1 = __importDefault(braceExpansion);
    const assert_valid_pattern_js_1 = assertValidPattern$1;
    const ast_js_1 = ast;
    const escape_js_1 = _escape;
    const unescape_js_12 = _unescape;
    const minimatch = (p, pattern, options = {}) => {
      (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
      if (!options.nocomment && pattern.charAt(0) === "#") {
        return false;
      }
      return new Minimatch(pattern, options).match(p);
    };
    exports.minimatch = minimatch;
    const starDotExtRE = /^\*+([^+@!?\*\[\(]*)$/;
    const starDotExtTest = (ext2) => (f2) => !f2.startsWith(".") && f2.endsWith(ext2);
    const starDotExtTestDot = (ext2) => (f2) => f2.endsWith(ext2);
    const starDotExtTestNocase = (ext2) => {
      ext2 = ext2.toLowerCase();
      return (f2) => !f2.startsWith(".") && f2.toLowerCase().endsWith(ext2);
    };
    const starDotExtTestNocaseDot = (ext2) => {
      ext2 = ext2.toLowerCase();
      return (f2) => f2.toLowerCase().endsWith(ext2);
    };
    const starDotStarRE = /^\*+\.\*+$/;
    const starDotStarTest = (f2) => !f2.startsWith(".") && f2.includes(".");
    const starDotStarTestDot = (f2) => f2 !== "." && f2 !== ".." && f2.includes(".");
    const dotStarRE = /^\.\*+$/;
    const dotStarTest = (f2) => f2 !== "." && f2 !== ".." && f2.startsWith(".");
    const starRE = /^\*+$/;
    const starTest = (f2) => f2.length !== 0 && !f2.startsWith(".");
    const starTestDot = (f2) => f2.length !== 0 && f2 !== "." && f2 !== "..";
    const qmarksRE = /^\?+([^+@!?\*\[\(]*)?$/;
    const qmarksTestNocase = ([$0, ext2 = ""]) => {
      const noext = qmarksTestNoExt([$0]);
      if (!ext2)
        return noext;
      ext2 = ext2.toLowerCase();
      return (f2) => noext(f2) && f2.toLowerCase().endsWith(ext2);
    };
    const qmarksTestNocaseDot = ([$0, ext2 = ""]) => {
      const noext = qmarksTestNoExtDot([$0]);
      if (!ext2)
        return noext;
      ext2 = ext2.toLowerCase();
      return (f2) => noext(f2) && f2.toLowerCase().endsWith(ext2);
    };
    const qmarksTestDot = ([$0, ext2 = ""]) => {
      const noext = qmarksTestNoExtDot([$0]);
      return !ext2 ? noext : (f2) => noext(f2) && f2.endsWith(ext2);
    };
    const qmarksTest = ([$0, ext2 = ""]) => {
      const noext = qmarksTestNoExt([$0]);
      return !ext2 ? noext : (f2) => noext(f2) && f2.endsWith(ext2);
    };
    const qmarksTestNoExt = ([$0]) => {
      const len2 = $0.length;
      return (f2) => f2.length === len2 && !f2.startsWith(".");
    };
    const qmarksTestNoExtDot = ([$0]) => {
      const len2 = $0.length;
      return (f2) => f2.length === len2 && f2 !== "." && f2 !== "..";
    };
    const defaultPlatform = typeof process === "object" && process ? typeof process.env === "object" && process.env && {}.__MINIMATCH_TESTING_PLATFORM__ || process.platform : "posix";
    const path2 = {
      win32: { sep: "\\" },
      posix: { sep: "/" }
    };
    exports.sep = defaultPlatform === "win32" ? path2.win32.sep : path2.posix.sep;
    exports.minimatch.sep = exports.sep;
    exports.GLOBSTAR = Symbol("globstar **");
    exports.minimatch.GLOBSTAR = exports.GLOBSTAR;
    const qmark2 = "[^/]";
    const star2 = qmark2 + "*?";
    const twoStarDot = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
    const twoStarNoDot = "(?:(?!(?:\\/|^)\\.).)*?";
    const filter = (pattern, options = {}) => (p) => (0, exports.minimatch)(p, pattern, options);
    exports.filter = filter;
    exports.minimatch.filter = exports.filter;
    const ext = (a2, b = {}) => Object.assign({}, a2, b);
    const defaults = (def2) => {
      if (!def2 || typeof def2 !== "object" || !Object.keys(def2).length) {
        return exports.minimatch;
      }
      const orig = exports.minimatch;
      const m = (p, pattern, options = {}) => orig(p, pattern, ext(def2, options));
      return Object.assign(m, {
        Minimatch: class Minimatch extends orig.Minimatch {
          constructor(pattern, options = {}) {
            super(pattern, ext(def2, options));
          }
          static defaults(options) {
            return orig.defaults(ext(def2, options)).Minimatch;
          }
        },
        AST: class AST extends orig.AST {
          /* c8 ignore start */
          constructor(type, parent, options = {}) {
            super(type, parent, ext(def2, options));
          }
          /* c8 ignore stop */
          static fromGlob(pattern, options = {}) {
            return orig.AST.fromGlob(pattern, ext(def2, options));
          }
        },
        unescape: (s, options = {}) => orig.unescape(s, ext(def2, options)),
        escape: (s, options = {}) => orig.escape(s, ext(def2, options)),
        filter: (pattern, options = {}) => orig.filter(pattern, ext(def2, options)),
        defaults: (options) => orig.defaults(ext(def2, options)),
        makeRe: (pattern, options = {}) => orig.makeRe(pattern, ext(def2, options)),
        braceExpand: (pattern, options = {}) => orig.braceExpand(pattern, ext(def2, options)),
        match: (list, pattern, options = {}) => orig.match(list, pattern, ext(def2, options)),
        sep: orig.sep,
        GLOBSTAR: exports.GLOBSTAR
      });
    };
    exports.defaults = defaults;
    exports.minimatch.defaults = exports.defaults;
    const braceExpand = (pattern, options = {}) => {
      (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
      if (options.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
        return [pattern];
      }
      return (0, brace_expansion_1.default)(pattern);
    };
    exports.braceExpand = braceExpand;
    exports.minimatch.braceExpand = exports.braceExpand;
    const makeRe = (pattern, options = {}) => new Minimatch(pattern, options).makeRe();
    exports.makeRe = makeRe;
    exports.minimatch.makeRe = exports.makeRe;
    const match = (list, pattern, options = {}) => {
      const mm = new Minimatch(pattern, options);
      list = list.filter((f2) => mm.match(f2));
      if (mm.options.nonull && !list.length) {
        list.push(pattern);
      }
      return list;
    };
    exports.match = match;
    exports.minimatch.match = exports.match;
    const globMagic = /[?*]|[+@!]\(.*?\)|\[|\]/;
    const regExpEscape2 = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    class Minimatch {
      constructor(pattern, options = {}) {
        __publicField(this, "options");
        __publicField(this, "set");
        __publicField(this, "pattern");
        __publicField(this, "windowsPathsNoEscape");
        __publicField(this, "nonegate");
        __publicField(this, "negate");
        __publicField(this, "comment");
        __publicField(this, "empty");
        __publicField(this, "preserveMultipleSlashes");
        __publicField(this, "partial");
        __publicField(this, "globSet");
        __publicField(this, "globParts");
        __publicField(this, "nocase");
        __publicField(this, "isWindows");
        __publicField(this, "platform");
        __publicField(this, "windowsNoMagicRoot");
        __publicField(this, "regexp");
        (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
        options = options || {};
        this.options = options;
        this.pattern = pattern;
        this.platform = options.platform || defaultPlatform;
        this.isWindows = this.platform === "win32";
        this.windowsPathsNoEscape = !!options.windowsPathsNoEscape || options.allowWindowsEscape === false;
        if (this.windowsPathsNoEscape) {
          this.pattern = this.pattern.replace(/\\/g, "/");
        }
        this.preserveMultipleSlashes = !!options.preserveMultipleSlashes;
        this.regexp = null;
        this.negate = false;
        this.nonegate = !!options.nonegate;
        this.comment = false;
        this.empty = false;
        this.partial = !!options.partial;
        this.nocase = !!this.options.nocase;
        this.windowsNoMagicRoot = options.windowsNoMagicRoot !== void 0 ? options.windowsNoMagicRoot : !!(this.isWindows && this.nocase);
        this.globSet = [];
        this.globParts = [];
        this.set = [];
        this.make();
      }
      hasMagic() {
        if (this.options.magicalBraces && this.set.length > 1) {
          return true;
        }
        for (const pattern of this.set) {
          for (const part of pattern) {
            if (typeof part !== "string")
              return true;
          }
        }
        return false;
      }
      debug(..._) {
      }
      make() {
        const pattern = this.pattern;
        const options = this.options;
        if (!options.nocomment && pattern.charAt(0) === "#") {
          this.comment = true;
          return;
        }
        if (!pattern) {
          this.empty = true;
          return;
        }
        this.parseNegate();
        this.globSet = [...new Set(this.braceExpand())];
        if (options.debug) {
          this.debug = (...args) => console.error(...args);
        }
        this.debug(this.pattern, this.globSet);
        const rawGlobParts = this.globSet.map((s) => this.slashSplit(s));
        this.globParts = this.preprocess(rawGlobParts);
        this.debug(this.pattern, this.globParts);
        let set2 = this.globParts.map((s, _, __) => {
          if (this.isWindows && this.windowsNoMagicRoot) {
            const isUNC = s[0] === "" && s[1] === "" && (s[2] === "?" || !globMagic.test(s[2])) && !globMagic.test(s[3]);
            const isDrive = /^[a-z]:/i.test(s[0]);
            if (isUNC) {
              return [...s.slice(0, 4), ...s.slice(4).map((ss) => this.parse(ss))];
            } else if (isDrive) {
              return [s[0], ...s.slice(1).map((ss) => this.parse(ss))];
            }
          }
          return s.map((ss) => this.parse(ss));
        });
        this.debug(this.pattern, set2);
        this.set = set2.filter((s) => s.indexOf(false) === -1);
        if (this.isWindows) {
          for (let i = 0; i < this.set.length; i++) {
            const p = this.set[i];
            if (p[0] === "" && p[1] === "" && this.globParts[i][2] === "?" && typeof p[3] === "string" && /^[a-z]:$/i.test(p[3])) {
              p[2] = "?";
            }
          }
        }
        this.debug(this.pattern, this.set);
      }
      // various transforms to equivalent pattern sets that are
      // faster to process in a filesystem walk.  The goal is to
      // eliminate what we can, and push all ** patterns as far
      // to the right as possible, even if it increases the number
      // of patterns that we have to process.
      preprocess(globParts) {
        if (this.options.noglobstar) {
          for (let i = 0; i < globParts.length; i++) {
            for (let j = 0; j < globParts[i].length; j++) {
              if (globParts[i][j] === "**") {
                globParts[i][j] = "*";
              }
            }
          }
        }
        const { optimizationLevel = 1 } = this.options;
        if (optimizationLevel >= 2) {
          globParts = this.firstPhasePreProcess(globParts);
          globParts = this.secondPhasePreProcess(globParts);
        } else if (optimizationLevel >= 1) {
          globParts = this.levelOneOptimize(globParts);
        } else {
          globParts = this.adjascentGlobstarOptimize(globParts);
        }
        return globParts;
      }
      // just get rid of adjascent ** portions
      adjascentGlobstarOptimize(globParts) {
        return globParts.map((parts) => {
          let gs = -1;
          while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
            let i = gs;
            while (parts[i + 1] === "**") {
              i++;
            }
            if (i !== gs) {
              parts.splice(gs, i - gs);
            }
          }
          return parts;
        });
      }
      // get rid of adjascent ** and resolve .. portions
      levelOneOptimize(globParts) {
        return globParts.map((parts) => {
          parts = parts.reduce((set2, part) => {
            const prev = set2[set2.length - 1];
            if (part === "**" && prev === "**") {
              return set2;
            }
            if (part === "..") {
              if (prev && prev !== ".." && prev !== "." && prev !== "**") {
                set2.pop();
                return set2;
              }
            }
            set2.push(part);
            return set2;
          }, []);
          return parts.length === 0 ? [""] : parts;
        });
      }
      levelTwoFileOptimize(parts) {
        if (!Array.isArray(parts)) {
          parts = this.slashSplit(parts);
        }
        let didSomething = false;
        do {
          didSomething = false;
          if (!this.preserveMultipleSlashes) {
            for (let i = 1; i < parts.length - 1; i++) {
              const p = parts[i];
              if (i === 1 && p === "" && parts[0] === "")
                continue;
              if (p === "." || p === "") {
                didSomething = true;
                parts.splice(i, 1);
                i--;
              }
            }
            if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
              didSomething = true;
              parts.pop();
            }
          }
          let dd = 0;
          while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
            const p = parts[dd - 1];
            if (p && p !== "." && p !== ".." && p !== "**") {
              didSomething = true;
              parts.splice(dd - 1, 2);
              dd -= 2;
            }
          }
        } while (didSomething);
        return parts.length === 0 ? [""] : parts;
      }
      // First phase: single-pattern processing
      // <pre> is 1 or more portions
      // <rest> is 1 or more portions
      // <p> is any portion other than ., .., '', or **
      // <e> is . or ''
      //
      // **/.. is *brutal* for filesystem walking performance, because
      // it effectively resets the recursive walk each time it occurs,
      // and ** cannot be reduced out by a .. pattern part like a regexp
      // or most strings (other than .., ., and '') can be.
      //
      // <pre>/**/../<p>/<p>/<rest> -> {<pre>/../<p>/<p>/<rest>,<pre>/**/<p>/<p>/<rest>}
      // <pre>/<e>/<rest> -> <pre>/<rest>
      // <pre>/<p>/../<rest> -> <pre>/<rest>
      // **/**/<rest> -> **/<rest>
      //
      // **/*/<rest> -> */**/<rest> <== not valid because ** doesn't follow
      // this WOULD be allowed if ** did follow symlinks, or * didn't
      firstPhasePreProcess(globParts) {
        let didSomething = false;
        do {
          didSomething = false;
          for (let parts of globParts) {
            let gs = -1;
            while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
              let gss = gs;
              while (parts[gss + 1] === "**") {
                gss++;
              }
              if (gss > gs) {
                parts.splice(gs + 1, gss - gs);
              }
              let next2 = parts[gs + 1];
              const p = parts[gs + 2];
              const p2 = parts[gs + 3];
              if (next2 !== "..")
                continue;
              if (!p || p === "." || p === ".." || !p2 || p2 === "." || p2 === "..") {
                continue;
              }
              didSomething = true;
              parts.splice(gs, 1);
              const other = parts.slice(0);
              other[gs] = "**";
              globParts.push(other);
              gs--;
            }
            if (!this.preserveMultipleSlashes) {
              for (let i = 1; i < parts.length - 1; i++) {
                const p = parts[i];
                if (i === 1 && p === "" && parts[0] === "")
                  continue;
                if (p === "." || p === "") {
                  didSomething = true;
                  parts.splice(i, 1);
                  i--;
                }
              }
              if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
                didSomething = true;
                parts.pop();
              }
            }
            let dd = 0;
            while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
              const p = parts[dd - 1];
              if (p && p !== "." && p !== ".." && p !== "**") {
                didSomething = true;
                const needDot = dd === 1 && parts[dd + 1] === "**";
                const splin = needDot ? ["."] : [];
                parts.splice(dd - 1, 2, ...splin);
                if (parts.length === 0)
                  parts.push("");
                dd -= 2;
              }
            }
          }
        } while (didSomething);
        return globParts;
      }
      // second phase: multi-pattern dedupes
      // {<pre>/*/<rest>,<pre>/<p>/<rest>} -> <pre>/*/<rest>
      // {<pre>/<rest>,<pre>/<rest>} -> <pre>/<rest>
      // {<pre>/**/<rest>,<pre>/<rest>} -> <pre>/**/<rest>
      //
      // {<pre>/**/<rest>,<pre>/**/<p>/<rest>} -> <pre>/**/<rest>
      // ^-- not valid because ** doens't follow symlinks
      secondPhasePreProcess(globParts) {
        for (let i = 0; i < globParts.length - 1; i++) {
          for (let j = i + 1; j < globParts.length; j++) {
            const matched = this.partsMatch(globParts[i], globParts[j], !this.preserveMultipleSlashes);
            if (!matched)
              continue;
            globParts[i] = matched;
            globParts[j] = [];
          }
        }
        return globParts.filter((gs) => gs.length);
      }
      partsMatch(a2, b, emptyGSMatch = false) {
        let ai = 0;
        let bi = 0;
        let result = [];
        let which = "";
        while (ai < a2.length && bi < b.length) {
          if (a2[ai] === b[bi]) {
            result.push(which === "b" ? b[bi] : a2[ai]);
            ai++;
            bi++;
          } else if (emptyGSMatch && a2[ai] === "**" && b[bi] === a2[ai + 1]) {
            result.push(a2[ai]);
            ai++;
          } else if (emptyGSMatch && b[bi] === "**" && a2[ai] === b[bi + 1]) {
            result.push(b[bi]);
            bi++;
          } else if (a2[ai] === "*" && b[bi] && (this.options.dot || !b[bi].startsWith(".")) && b[bi] !== "**") {
            if (which === "b")
              return false;
            which = "a";
            result.push(a2[ai]);
            ai++;
            bi++;
          } else if (b[bi] === "*" && a2[ai] && (this.options.dot || !a2[ai].startsWith(".")) && a2[ai] !== "**") {
            if (which === "a")
              return false;
            which = "b";
            result.push(b[bi]);
            ai++;
            bi++;
          } else {
            return false;
          }
        }
        return a2.length === b.length && result;
      }
      parseNegate() {
        if (this.nonegate)
          return;
        const pattern = this.pattern;
        let negate = false;
        let negateOffset = 0;
        for (let i = 0; i < pattern.length && pattern.charAt(i) === "!"; i++) {
          negate = !negate;
          negateOffset++;
        }
        if (negateOffset)
          this.pattern = pattern.slice(negateOffset);
        this.negate = negate;
      }
      // set partial to true to test if, for example,
      // "/a/b" matches the start of "/*/b/*/d"
      // Partial means, if you run out of file before you run
      // out of pattern, then that's fine, as long as all
      // the parts match.
      matchOne(file, pattern, partial = false) {
        const options = this.options;
        if (this.isWindows) {
          const fileDrive = typeof file[0] === "string" && /^[a-z]:$/i.test(file[0]);
          const fileUNC = !fileDrive && file[0] === "" && file[1] === "" && file[2] === "?" && /^[a-z]:$/i.test(file[3]);
          const patternDrive = typeof pattern[0] === "string" && /^[a-z]:$/i.test(pattern[0]);
          const patternUNC = !patternDrive && pattern[0] === "" && pattern[1] === "" && pattern[2] === "?" && typeof pattern[3] === "string" && /^[a-z]:$/i.test(pattern[3]);
          const fdi = fileUNC ? 3 : fileDrive ? 0 : void 0;
          const pdi = patternUNC ? 3 : patternDrive ? 0 : void 0;
          if (typeof fdi === "number" && typeof pdi === "number") {
            const [fd, pd] = [file[fdi], pattern[pdi]];
            if (fd.toLowerCase() === pd.toLowerCase()) {
              pattern[pdi] = fd;
              if (pdi > fdi) {
                pattern = pattern.slice(pdi);
              } else if (fdi > pdi) {
                file = file.slice(fdi);
              }
            }
          }
        }
        const { optimizationLevel = 1 } = this.options;
        if (optimizationLevel >= 2) {
          file = this.levelTwoFileOptimize(file);
        }
        this.debug("matchOne", this, { file, pattern });
        this.debug("matchOne", file.length, pattern.length);
        for (var fi = 0, pi = 0, fl = file.length, pl = pattern.length; fi < fl && pi < pl; fi++, pi++) {
          this.debug("matchOne loop");
          var p = pattern[pi];
          var f2 = file[fi];
          this.debug(pattern, p, f2);
          if (p === false) {
            return false;
          }
          if (p === exports.GLOBSTAR) {
            this.debug("GLOBSTAR", [pattern, p, f2]);
            var fr = fi;
            var pr = pi + 1;
            if (pr === pl) {
              this.debug("** at the end");
              for (; fi < fl; fi++) {
                if (file[fi] === "." || file[fi] === ".." || !options.dot && file[fi].charAt(0) === ".")
                  return false;
              }
              return true;
            }
            while (fr < fl) {
              var swallowee = file[fr];
              this.debug("\nglobstar while", file, fr, pattern, pr, swallowee);
              if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
                this.debug("globstar found match!", fr, fl, swallowee);
                return true;
              } else {
                if (swallowee === "." || swallowee === ".." || !options.dot && swallowee.charAt(0) === ".") {
                  this.debug("dot detected!", file, fr, pattern, pr);
                  break;
                }
                this.debug("globstar swallow a segment, and continue");
                fr++;
              }
            }
            if (partial) {
              this.debug("\n>>> no match, partial?", file, fr, pattern, pr);
              if (fr === fl) {
                return true;
              }
            }
            return false;
          }
          let hit;
          if (typeof p === "string") {
            hit = f2 === p;
            this.debug("string match", p, f2, hit);
          } else {
            hit = p.test(f2);
            this.debug("pattern match", p, f2, hit);
          }
          if (!hit)
            return false;
        }
        if (fi === fl && pi === pl) {
          return true;
        } else if (fi === fl) {
          return partial;
        } else if (pi === pl) {
          return fi === fl - 1 && file[fi] === "";
        } else {
          throw new Error("wtf?");
        }
      }
      braceExpand() {
        return (0, exports.braceExpand)(this.pattern, this.options);
      }
      parse(pattern) {
        (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
        const options = this.options;
        if (pattern === "**")
          return exports.GLOBSTAR;
        if (pattern === "")
          return "";
        let m;
        let fastTest = null;
        if (m = pattern.match(starRE)) {
          fastTest = options.dot ? starTestDot : starTest;
        } else if (m = pattern.match(starDotExtRE)) {
          fastTest = (options.nocase ? options.dot ? starDotExtTestNocaseDot : starDotExtTestNocase : options.dot ? starDotExtTestDot : starDotExtTest)(m[1]);
        } else if (m = pattern.match(qmarksRE)) {
          fastTest = (options.nocase ? options.dot ? qmarksTestNocaseDot : qmarksTestNocase : options.dot ? qmarksTestDot : qmarksTest)(m);
        } else if (m = pattern.match(starDotStarRE)) {
          fastTest = options.dot ? starDotStarTestDot : starDotStarTest;
        } else if (m = pattern.match(dotStarRE)) {
          fastTest = dotStarTest;
        }
        const re2 = ast_js_1.AST.fromGlob(pattern, this.options).toMMPattern();
        return fastTest ? Object.assign(re2, { test: fastTest }) : re2;
      }
      makeRe() {
        if (this.regexp || this.regexp === false)
          return this.regexp;
        const set2 = this.set;
        if (!set2.length) {
          this.regexp = false;
          return this.regexp;
        }
        const options = this.options;
        const twoStar = options.noglobstar ? star2 : options.dot ? twoStarDot : twoStarNoDot;
        const flags = new Set(options.nocase ? ["i"] : []);
        let re2 = set2.map((pattern) => {
          const pp = pattern.map((p) => {
            if (p instanceof RegExp) {
              for (const f2 of p.flags.split(""))
                flags.add(f2);
            }
            return typeof p === "string" ? regExpEscape2(p) : p === exports.GLOBSTAR ? exports.GLOBSTAR : p._src;
          });
          pp.forEach((p, i) => {
            const next2 = pp[i + 1];
            const prev = pp[i - 1];
            if (p !== exports.GLOBSTAR || prev === exports.GLOBSTAR) {
              return;
            }
            if (prev === void 0) {
              if (next2 !== void 0 && next2 !== exports.GLOBSTAR) {
                pp[i + 1] = "(?:\\/|" + twoStar + "\\/)?" + next2;
              } else {
                pp[i] = twoStar;
              }
            } else if (next2 === void 0) {
              pp[i - 1] = prev + "(?:\\/|" + twoStar + ")?";
            } else if (next2 !== exports.GLOBSTAR) {
              pp[i - 1] = prev + "(?:\\/|\\/" + twoStar + "\\/)" + next2;
              pp[i + 1] = exports.GLOBSTAR;
            }
          });
          return pp.filter((p) => p !== exports.GLOBSTAR).join("/");
        }).join("|");
        const [open, close] = set2.length > 1 ? ["(?:", ")"] : ["", ""];
        re2 = "^" + open + re2 + close + "$";
        if (this.negate)
          re2 = "^(?!" + re2 + ").+$";
        try {
          this.regexp = new RegExp(re2, [...flags].join(""));
        } catch (ex) {
          this.regexp = false;
        }
        return this.regexp;
      }
      slashSplit(p) {
        if (this.preserveMultipleSlashes) {
          return p.split("/");
        } else if (this.isWindows && /^\/\/[^\/]+/.test(p)) {
          return ["", ...p.split(/\/+/)];
        } else {
          return p.split(/\/+/);
        }
      }
      match(f2, partial = this.partial) {
        this.debug("match", f2, this.pattern);
        if (this.comment) {
          return false;
        }
        if (this.empty) {
          return f2 === "";
        }
        if (f2 === "/" && partial) {
          return true;
        }
        const options = this.options;
        if (this.isWindows) {
          f2 = f2.split("\\").join("/");
        }
        const ff = this.slashSplit(f2);
        this.debug(this.pattern, "split", ff);
        const set2 = this.set;
        this.debug(this.pattern, "set", set2);
        let filename = ff[ff.length - 1];
        if (!filename) {
          for (let i = ff.length - 2; !filename && i >= 0; i--) {
            filename = ff[i];
          }
        }
        for (let i = 0; i < set2.length; i++) {
          const pattern = set2[i];
          let file = ff;
          if (options.matchBase && pattern.length === 1) {
            file = [filename];
          }
          const hit = this.matchOne(file, pattern, partial);
          if (hit) {
            if (options.flipNegate) {
              return true;
            }
            return !this.negate;
          }
        }
        if (options.flipNegate) {
          return false;
        }
        return this.negate;
      }
      static defaults(def2) {
        return exports.minimatch.defaults(def2).Minimatch;
      }
    }
    exports.Minimatch = Minimatch;
    var ast_js_2 = ast;
    Object.defineProperty(exports, "AST", { enumerable: true, get: function() {
      return ast_js_2.AST;
    } });
    var escape_js_2 = _escape;
    Object.defineProperty(exports, "escape", { enumerable: true, get: function() {
      return escape_js_2.escape;
    } });
    var unescape_js_2 = _unescape;
    Object.defineProperty(exports, "unescape", { enumerable: true, get: function() {
      return unescape_js_2.unescape;
    } });
    exports.minimatch.AST = ast_js_1.AST;
    exports.minimatch.Minimatch = Minimatch;
    exports.minimatch.escape = escape_js_1.escape;
    exports.minimatch.unescape = unescape_js_12.unescape;
  })(cjs);
  Object.defineProperty(template, "__esModule", { value: true });
  template.walkElementNodes = template.generate = void 0;
  const language_core_1$c = out$b;
  const CompilerDOM$1 = require$$9$1;
  const shared_1$w = require$$1$3;
  const transform_1$1 = transform;
  const minimatch_1 = cjs;
  const muggle$2 = out$9;
  const capabilitiesPresets = {
    all: language_core_1$c.FileRangeCapabilities.full,
    allWithHiddenParam: {
      ...language_core_1$c.FileRangeCapabilities.full,
      __hint: {
        setting: "vue.inlayHints.inlineHandlerLeading",
        label: "$event =>",
        tooltip: [
          "`$event` is a hidden parameter, you can use it in this callback.",
          "To hide this hint, set `vue.inlayHints.inlineHandlerLeading` to `false` in IDE settings.",
          "[More info](https://github.com/vuejs/language-tools/issues/2445#issuecomment-1444771420)"
        ].join("\n\n"),
        paddingRight: true
      }
      /* TODO */
    },
    noDiagnostic: { ...language_core_1$c.FileRangeCapabilities.full, diagnostic: false },
    diagnosticOnly: { diagnostic: true },
    tagHover: { hover: true },
    event: { hover: true, diagnostic: true },
    tagReference: { references: true, definition: true, rename: { normalize: void 0, apply: noEditApply } },
    attr: { hover: true, diagnostic: true, references: true, definition: true, rename: true },
    attrReference: { references: true, definition: true, rename: true },
    slotProp: { references: true, definition: true, rename: true, diagnostic: true },
    scopedClassName: { references: true, definition: true, rename: true, completion: true },
    slotName: { hover: true, diagnostic: true, references: true, definition: true, completion: true },
    slotNameExport: {
      hover: true,
      diagnostic: true,
      references: true,
      definition: true
      /* referencesCodeLens: true */
    },
    refAttr: { references: true, definition: true, rename: true }
  };
  const formatBrackets = {
    normal: ["`${", "}`;"],
    // fix https://github.com/vuejs/language-tools/issues/1210
    // fix https://github.com/vuejs/language-tools/issues/2305
    curly: ["0 +", "+ 0;"],
    event: ["() => ", ";"]
  };
  const validTsVarReg = /^[a-zA-Z_$][0-9a-zA-Z_$]*$/;
  const colonReg = /:/g;
  const transformContext = {
    onError: () => {
    },
    helperString: (str2) => str2.toString(),
    replaceNode: () => {
    },
    cacheHandlers: false,
    prefixIdentifiers: false,
    scopes: {
      vFor: 0,
      vOnce: 0,
      vPre: 0,
      vSlot: 0
    },
    expressionPlugins: ["typescript"]
  };
  function generate$3(ts2, compilerOptions, vueCompilerOptions, sourceTemplate, sourceLang, sfc, hasScriptSetupSlots, codegenStack) {
    const nativeTags = new Set(vueCompilerOptions.nativeTags);
    const [codes, codeStacks] = codegenStack ? muggle$2.track([]) : [[], []];
    const [formatCodes, formatCodeStacks] = codegenStack ? muggle$2.track([]) : [[], []];
    const [cssCodes, cssCodeStacks] = codegenStack ? muggle$2.track([]) : [[], []];
    const slots = /* @__PURE__ */ new Map();
    const slotExps = /* @__PURE__ */ new Map();
    const tagNames = collectTagOffsets();
    const localVars = {};
    const tempVars = [];
    const identifiers2 = /* @__PURE__ */ new Set();
    const scopedClasses = [];
    const blockConditions = [];
    let hasSlot = false;
    let elementIndex = 0;
    let ignoreStart;
    let expectedErrorStart;
    let expectedErrorNode;
    generatePreResolveComponents();
    if (sfc.templateAst) {
      visitNode(sfc.templateAst, void 0, void 0, void 0);
    }
    generateStyleScopedClasses();
    if (!hasScriptSetupSlots) {
      codes.push("var __VLS_slots!:", ...createSlotsTypeCode(), ";\n");
    }
    generateAutoImportCompletionCode();
    return {
      codes,
      codeStacks,
      formatCodes,
      formatCodeStacks,
      cssCodes,
      cssCodeStacks,
      tagNames,
      identifiers: identifiers2,
      hasSlot
    };
    function createSlotsTypeCode() {
      const codes2 = [];
      for (const [exp, slot] of slotExps) {
        hasSlot = true;
        codes2.push(`Partial<Record<NonNullable<typeof ${exp}>, (_: typeof ${slot.varName}) => any>> &
`);
      }
      codes2.push(`{
`);
      for (const [name, slot] of slots) {
        hasSlot = true;
        codes2.push(...createObjectPropertyCode([
          name,
          "template",
          slot.loc,
          {
            ...capabilitiesPresets.slotNameExport,
            referencesCodeLens: true
          }
        ], slot.nodeLoc));
        codes2.push(`?(_: typeof ${slot.varName}): any,
`);
      }
      codes2.push(`}`);
      return codes2;
    }
    function generateStyleScopedClasses() {
      const allClasses = /* @__PURE__ */ new Set();
      for (const block of sfc.styles) {
        if (block.scoped || vueCompilerOptions.experimentalResolveStyleCssClasses === "always") {
          for (const className of block.classNames) {
            allClasses.add(className.text.substring(1));
          }
        }
      }
      codes.push(`if (typeof __VLS_styleScopedClasses === 'object' && !Array.isArray(__VLS_styleScopedClasses)) {
`);
      for (const { className, offset } of scopedClasses) {
        codes.push(`__VLS_styleScopedClasses[`);
        codes.push(...createStringLiteralKeyCode([
          className,
          "template",
          offset,
          {
            ...capabilitiesPresets.scopedClassName,
            displayWithLink: allClasses.has(className)
          }
        ]));
        codes.push(`];
`);
      }
      codes.push("}\n");
    }
    function toCanonicalComponentName(tagText) {
      return validTsVarReg.test(tagText) ? tagText : (0, shared_1$w.capitalize)((0, shared_1$w.camelize)(tagText.replace(colonReg, "-")));
    }
    function getPossibleOriginalComponentName(tagText) {
      return [.../* @__PURE__ */ new Set([
        // order is important: https://github.com/vuejs/language-tools/issues/2010
        (0, shared_1$w.capitalize)((0, shared_1$w.camelize)(tagText)),
        (0, shared_1$w.camelize)(tagText),
        tagText
      ])];
    }
    function generatePreResolveComponents() {
      codes.push(`let __VLS_resolvedLocalAndGlobalComponents!: {}
`);
      for (const tagName in tagNames) {
        if (nativeTags.has(tagName))
          continue;
        const isNamespacedTag = tagName.indexOf(".") >= 0;
        if (isNamespacedTag)
          continue;
        codes.push(
          `& __VLS_WithComponent<'${toCanonicalComponentName(tagName)}', typeof __VLS_localComponents, `,
          // order is important: https://github.com/vuejs/language-tools/issues/2010
          `"${(0, shared_1$w.capitalize)((0, shared_1$w.camelize)(tagName))}", `,
          `"${(0, shared_1$w.camelize)(tagName)}", `,
          `"${tagName}"`,
          ">\n"
        );
      }
      codes.push(`;
`);
      for (const tagName in tagNames) {
        const tagOffsets = tagNames[tagName];
        const tagRanges = tagOffsets.map((offset) => [offset, offset + tagName.length]);
        const names = nativeTags.has(tagName) ? [tagName] : getPossibleOriginalComponentName(tagName);
        for (const name of names) {
          for (const tagRange of tagRanges) {
            codes.push(nativeTags.has(tagName) ? "({} as __VLS_IntrinsicElements)" : "__VLS_components", ...createPropertyAccessCode([
              name,
              "template",
              tagRange,
              {
                ...capabilitiesPresets.tagReference,
                rename: {
                  normalize: tagName === name ? capabilitiesPresets.tagReference.rename.normalize : camelizeComponentName,
                  apply: getRenameApply(tagName)
                }
              }
            ]), ";");
          }
        }
        codes.push("\n");
        if (nativeTags.has(tagName))
          continue;
        const isNamespacedTag = tagName.indexOf(".") >= 0;
        if (isNamespacedTag)
          continue;
        codes.push(
          "// @ts-ignore\n",
          // #2304
          "["
        );
        const validName = toCanonicalComponentName(tagName);
        for (const tagRange of tagRanges) {
          codes.push([
            validName,
            "template",
            tagRange,
            {
              completion: {
                additional: true,
                autoImportOnly: true
              }
            }
          ]);
          codes.push(",");
        }
        codes.push(`];
`);
      }
    }
    function collectTagOffsets() {
      const tagOffsetsMap = {};
      if (!sfc.templateAst) {
        return tagOffsetsMap;
      }
      walkElementNodes(sfc.templateAst, (node) => {
        var _a2;
        if (node.tag === "slot")
          ;
        else if (node.tag === "component" || node.tag === "Component") {
          for (const prop of node.props) {
            if (prop.type === 6 && prop.name === "is" && prop.value) {
              const tag = prop.value.content;
              tagOffsetsMap[tag] ?? (tagOffsetsMap[tag] = []);
              tagOffsetsMap[tag].push(prop.value.loc.start.offset + prop.value.loc.source.lastIndexOf(tag));
              break;
            }
          }
        } else {
          tagOffsetsMap[_a2 = node.tag] ?? (tagOffsetsMap[_a2] = []);
          const offsets = tagOffsetsMap[node.tag];
          const source = sourceTemplate.substring(node.loc.start.offset);
          const startTagOffset = node.loc.start.offset + source.indexOf(node.tag);
          offsets.push(startTagOffset);
          if (!node.isSelfClosing && sourceLang === "html") {
            const endTagOffset = node.loc.start.offset + node.loc.source.lastIndexOf(node.tag);
            if (endTagOffset !== startTagOffset) {
              offsets.push(endTagOffset);
            }
          }
        }
      });
      return tagOffsetsMap;
    }
    function resolveComment() {
      if (ignoreStart !== void 0) {
        for (let i = ignoreStart; i < codes.length; i++) {
          const code = codes[i];
          if (typeof code === "string") {
            continue;
          }
          const cap = code[3];
          if (cap.diagnostic) {
            code[3] = {
              ...cap,
              diagnostic: false
            };
          }
        }
        ignoreStart = void 0;
      }
      if (expectedErrorStart !== void 0 && expectedErrorStart !== codes.length && expectedErrorNode) {
        let errors = 0;
        const suppressError = () => {
          errors++;
          return false;
        };
        for (let i = expectedErrorStart; i < codes.length; i++) {
          const code = codes[i];
          if (typeof code === "string") {
            continue;
          }
          const cap = code[3];
          if (cap.diagnostic) {
            code[3] = {
              ...cap,
              diagnostic: {
                shouldReport: suppressError
              }
            };
          }
        }
        codes.push([
          "// @ts-expect-error",
          "template",
          [expectedErrorNode.loc.start.offset, expectedErrorNode.loc.end.offset],
          {
            diagnostic: {
              shouldReport: () => errors === 0
            }
          }
        ], "\n;\n");
        expectedErrorStart = void 0;
        expectedErrorNode = void 0;
      }
    }
    function visitNode(node, parentEl, prevNode, componentCtxVar) {
      resolveComment();
      if ((prevNode == null ? void 0 : prevNode.type) === 3) {
        const commentText = prevNode.content.trim().split(" ")[0];
        if (commentText.match(/^@vue-skip\b[\s\S]*/)) {
          return;
        } else if (commentText.match(/^@vue-ignore\b[\s\S]*/)) {
          ignoreStart = codes.length;
        } else if (commentText.match(/^@vue-expect-error\b[\s\S]*/)) {
          expectedErrorStart = codes.length;
          expectedErrorNode = prevNode;
        }
      }
      if (node.type === 0) {
        let prev;
        for (const childNode of node.children) {
          visitNode(childNode, parentEl, prev, componentCtxVar);
          prev = childNode;
        }
        resolveComment();
      } else if (node.type === 1) {
        const vForNode = getVForNode(node);
        const vIfNode = getVIfNode(node);
        if (vForNode) {
          visitVForNode(vForNode, parentEl, componentCtxVar);
        } else if (vIfNode) {
          visitVIfNode(vIfNode, parentEl, componentCtxVar);
        } else {
          visitElementNode(node, parentEl, componentCtxVar);
        }
      } else if (node.type === 12) {
        visitNode(node.content, parentEl, void 0, componentCtxVar);
      } else if (node.type === 8) {
        for (const childNode of node.children) {
          if (typeof childNode === "object") {
            visitNode(childNode, parentEl, void 0, componentCtxVar);
          }
        }
      } else if (node.type === 5) {
        let content = node.content.loc.source;
        let start = node.content.loc.start.offset;
        let leftCharacter;
        let rightCharacter;
        while ((leftCharacter = sourceTemplate.substring(start - 1, start)).trim() === "" && leftCharacter.length) {
          start--;
          content = leftCharacter + content;
        }
        while ((rightCharacter = sourceTemplate.substring(start + content.length, start + content.length + 1)).trim() === "" && rightCharacter.length) {
          content = content + rightCharacter;
        }
        codes.push(...createInterpolationCode(content, node.content.loc, start, capabilitiesPresets.all, "(", ");\n"));
        const lines = content.split("\n");
        formatCodes.push(...createFormatCode(content, start, lines.length <= 1 ? formatBrackets.curly : [
          formatBrackets.curly[0],
          lines[lines.length - 1].trim() === "" ? "" : formatBrackets.curly[1]
        ]));
      } else if (node.type === 9) {
        visitVIfNode(node, parentEl, componentCtxVar);
      } else if (node.type === 11) {
        visitVForNode(node, parentEl, componentCtxVar);
      } else if (node.type === 2)
        ;
    }
    function visitVIfNode(node, parentEl, componentCtxVar) {
      var _a2;
      let originalBlockConditionsLength = blockConditions.length;
      for (let i = 0; i < node.branches.length; i++) {
        const branch = node.branches[i];
        if (i === 0)
          codes.push("if");
        else if (branch.condition)
          codes.push("else if");
        else
          codes.push("else");
        let addedBlockCondition = false;
        if (((_a2 = branch.condition) == null ? void 0 : _a2.type) === 4) {
          codes.push(` `);
          const beforeCodeLength = codes.length;
          codes.push(...createInterpolationCode(branch.condition.content, branch.condition.loc, branch.condition.loc.start.offset, capabilitiesPresets.all, "(", ")"));
          const afterCodeLength = codes.length;
          formatCodes.push(...createFormatCode(branch.condition.content, branch.condition.loc.start.offset, formatBrackets.normal));
          blockConditions.push(muggle$2.toString(codes.slice(beforeCodeLength, afterCodeLength)));
          addedBlockCondition = true;
        }
        codes.push(` {
`);
        let prev;
        for (const childNode of branch.children) {
          visitNode(childNode, parentEl, prev, componentCtxVar);
          prev = childNode;
        }
        resolveComment();
        generateAutoImportCompletionCode();
        codes.push("}\n");
        if (addedBlockCondition) {
          blockConditions[blockConditions.length - 1] = `!(${blockConditions[blockConditions.length - 1]})`;
        }
      }
      blockConditions.length = originalBlockConditionsLength;
    }
    function visitVForNode(node, parentEl, componentCtxVar) {
      const { source, value, key, index: index2 } = node.parseResult;
      const leftExpressionRange = value ? { start: (value ?? key ?? index2).loc.start.offset, end: (index2 ?? key ?? value).loc.end.offset } : void 0;
      const leftExpressionText = leftExpressionRange ? node.loc.source.substring(leftExpressionRange.start - node.loc.start.offset, leftExpressionRange.end - node.loc.start.offset) : void 0;
      const forBlockVars = [];
      codes.push(`for (const [`);
      if (leftExpressionRange && leftExpressionText) {
        const collectAst = createTsAst(node.parseResult, `const [${leftExpressionText}]`);
        (0, transform_1$1.colletVars)(ts2, collectAst, forBlockVars);
        for (const varName of forBlockVars)
          localVars[varName] = (localVars[varName] ?? 0) + 1;
        codes.push([leftExpressionText, "template", leftExpressionRange.start, capabilitiesPresets.all]);
        formatCodes.push(...createFormatCode(leftExpressionText, leftExpressionRange.start, formatBrackets.normal));
      }
      codes.push(`] of __VLS_getVForSourceType`);
      if (source.type === 4) {
        codes.push(
          "(",
          ...createInterpolationCode(source.content, source.loc, source.loc.start.offset, capabilitiesPresets.all, "(", ")"),
          "!)",
          // #3102
          ") {\n"
        );
        let prev;
        for (const childNode of node.children) {
          visitNode(childNode, parentEl, prev, componentCtxVar);
          prev = childNode;
        }
        resolveComment();
        generateAutoImportCompletionCode();
        codes.push("}\n");
        formatCodes.push(...createFormatCode(source.content, source.loc.start.offset, formatBrackets.normal));
      }
      for (const varName of forBlockVars)
        localVars[varName]--;
    }
    function visitElementNode(node, parentEl, componentCtxVar) {
      var _a2, _b, _c, _d;
      codes.push(`{
`);
      const startTagOffset = node.loc.start.offset + sourceTemplate.substring(node.loc.start.offset).indexOf(node.tag);
      let endTagOffset = !node.isSelfClosing && sourceLang === "html" ? node.loc.start.offset + node.loc.source.lastIndexOf(node.tag) : void 0;
      if (endTagOffset === startTagOffset) {
        endTagOffset = void 0;
      }
      let tag = node.tag;
      let tagOffsets = endTagOffset !== void 0 ? [startTagOffset, endTagOffset] : [startTagOffset];
      let props = node.props;
      const propsFailedExps = [];
      const isNamespacedTag = tag.indexOf(".") >= 0;
      const var_originalComponent = `__VLS_${elementIndex++}`;
      const var_functionalComponent = `__VLS_${elementIndex++}`;
      const var_componentInstance = `__VLS_${elementIndex++}`;
      let dynamicTagExp;
      if (tag === "slot") {
        tagOffsets.length = 0;
      } else if (tag === "component" || tag === "Component") {
        tagOffsets.length = 0;
        for (const prop of node.props) {
          if (prop.type === 6 && prop.name === "is" && prop.value) {
            tag = prop.value.content;
            tagOffsets = [prop.value.loc.start.offset + prop.value.loc.source.lastIndexOf(tag)];
            props = props.filter((p) => p !== prop);
            break;
          } else if (prop.type === 7 && prop.name === "bind" && ((_a2 = prop.arg) == null ? void 0 : _a2.loc.source) === "is" && prop.exp) {
            dynamicTagExp = prop.exp;
            props = props.filter((p) => p !== prop);
            break;
          }
        }
      }
      const isIntrinsicElement = nativeTags.has(tag) && tagOffsets.length;
      if (isIntrinsicElement) {
        codes.push("const ", var_originalComponent, ` = ({} as __VLS_IntrinsicElements)[`, ...createStringLiteralKeyCode([
          tag,
          "template",
          tagOffsets[0],
          capabilitiesPresets.diagnosticOnly
        ]), "];\n");
      } else if (isNamespacedTag) {
        codes.push(`const ${var_originalComponent} = `, ...createInterpolationCode(tag, node.loc, startTagOffset, capabilitiesPresets.all, "", ""), ";\n");
      } else if (dynamicTagExp) {
        codes.push(`const ${var_originalComponent} = `, ...createInterpolationCode(dynamicTagExp.loc.source, dynamicTagExp.loc, dynamicTagExp.loc.start.offset, capabilitiesPresets.all, "(", ")"), ";\n");
      } else {
        codes.push(`let ${var_originalComponent}!: `);
        for (const componentName of getPossibleOriginalComponentName(tag)) {
          codes.push(`'${componentName}' extends keyof typeof __VLS_ctx ? typeof __VLS_ctx${validTsVarReg.test(componentName) ? `.${componentName}` : `['${componentName}']`} : `);
        }
        codes.push(`typeof __VLS_resolvedLocalAndGlobalComponents['${toCanonicalComponentName(tag)}'];
`);
      }
      codes.push(`const ${var_functionalComponent} = __VLS_asFunctionalComponent(`, `${var_originalComponent}, `);
      if (isIntrinsicElement) {
        codes.push("{}");
      } else {
        codes.push(`new ${var_originalComponent}({`, ...createPropsCode(node, props, "extraReferences"), "})");
      }
      codes.push(");\n");
      for (const offset of tagOffsets) {
        if (isNamespacedTag || dynamicTagExp) {
          continue;
        } else if (isIntrinsicElement) {
          codes.push(`({} as __VLS_IntrinsicElements).`);
          codes.push([
            tag,
            "template",
            [offset, offset + tag.length],
            {
              ...capabilitiesPresets.tagHover,
              ...capabilitiesPresets.diagnosticOnly
            }
          ], ";\n");
        } else {
          const key = toCanonicalComponentName(tag);
          codes.push(`({} as { ${key}: typeof ${var_originalComponent} }).`);
          codes.push([
            key,
            "template",
            [offset, offset + tag.length],
            {
              ...capabilitiesPresets.tagHover,
              ...capabilitiesPresets.diagnosticOnly
            }
          ], ";\n");
        }
      }
      codes.push(
        `const ${var_componentInstance} = ${var_functionalComponent}(`,
        // diagnostic start
        tagOffsets.length ? ["", "template", tagOffsets[0], capabilitiesPresets.diagnosticOnly] : dynamicTagExp ? ["", "template", startTagOffset, capabilitiesPresets.diagnosticOnly] : "",
        "{ ",
        ...createPropsCode(node, props, "normal", propsFailedExps),
        "}",
        // diagnostic end
        tagOffsets.length ? ["", "template", tagOffsets[0] + tag.length, capabilitiesPresets.diagnosticOnly] : dynamicTagExp ? ["", "template", startTagOffset + tag.length, capabilitiesPresets.diagnosticOnly] : "",
        `, ...__VLS_functionalComponentArgsRest(${var_functionalComponent}));
`
      );
      if (tag !== "template" && tag !== "slot") {
        componentCtxVar = `__VLS_${elementIndex++}`;
        codes.push(`const ${componentCtxVar} = __VLS_pickFunctionalComponentCtx(${var_originalComponent}, ${var_componentInstance})!;
`);
        parentEl = node;
      }
      for (const failedExp of propsFailedExps) {
        codes.push(...createInterpolationCode(failedExp.loc.source, failedExp.loc, failedExp.loc.start.offset, capabilitiesPresets.all, "(", ")"), ";\n");
        const fb = formatBrackets.normal;
        if (fb) {
          formatCodes.push(...createFormatCode(failedExp.loc.source, failedExp.loc.start.offset, fb));
        }
      }
      generateInlineCss(props);
      const vScope = props.find((prop) => prop.type === 7 && (prop.name === "scope" || prop.name === "data"));
      let inScope = false;
      let originalConditionsNum = blockConditions.length;
      if ((vScope == null ? void 0 : vScope.type) === 7 && vScope.exp) {
        const scopeVar = `__VLS_${elementIndex++}`;
        const condition = `__VLS_withScope(__VLS_ctx, ${scopeVar})`;
        codes.push(`const ${scopeVar} = `);
        codes.push([
          vScope.exp.loc.source,
          "template",
          vScope.exp.loc.start.offset,
          capabilitiesPresets.all
        ]);
        codes.push(";\n");
        codes.push(`if (${condition}) {
`);
        blockConditions.push(condition);
        inScope = true;
      }
      generateDirectives(node);
      generateElReferences(node);
      if (sfc.styles.some((s) => s.scoped || vueCompilerOptions.experimentalResolveStyleCssClasses === "always")) {
        generateClassScoped(node);
      }
      if (componentCtxVar) {
        generateEvents(node, var_functionalComponent, var_componentInstance, componentCtxVar);
      }
      if (node.tag === "slot") {
        generateSlot(node, startTagOffset);
      }
      if (inScope) {
        codes.push("}\n");
        blockConditions.length = originalConditionsNum;
      }
      const slotDir = node.props.find((p) => p.type === 7 && p.name === "slot");
      if (slotDir && componentCtxVar) {
        const slotBlockVars = [];
        codes.push(`{
`);
        let hasProps = false;
        if (((_b = slotDir == null ? void 0 : slotDir.exp) == null ? void 0 : _b.type) === 4) {
          formatCodes.push(...createFormatCode(slotDir.exp.content, slotDir.exp.loc.start.offset, formatBrackets.normal));
          const collectAst = createTsAst(slotDir, `(${slotDir.exp.content}) => {}`);
          (0, transform_1$1.colletVars)(ts2, collectAst, slotBlockVars);
          hasProps = true;
          if (slotDir.exp.content.indexOf(":") === -1) {
            codes.push("const [", [
              slotDir.exp.content,
              "template",
              slotDir.exp.loc.start.offset,
              capabilitiesPresets.all
            ], `] = __VLS_getSlotParams(`);
          } else {
            codes.push("const ", [
              slotDir.exp.content,
              "template",
              slotDir.exp.loc.start.offset,
              capabilitiesPresets.all
            ], ` = __VLS_getSlotParam(`);
          }
        }
        codes.push(["", "template", (slotDir.arg ?? slotDir).loc.start.offset, capabilitiesPresets.diagnosticOnly], `(${componentCtxVar}.slots!)`, ...((_c = slotDir == null ? void 0 : slotDir.arg) == null ? void 0 : _c.type) === 4 && slotDir.arg.content ? createPropertyAccessCode([
          slotDir.arg.loc.source,
          "template",
          slotDir.arg.loc.start.offset,
          slotDir.arg.isStatic ? capabilitiesPresets.slotName : capabilitiesPresets.all
        ], slotDir.arg.loc) : createPropertyAccessCode([
          "default",
          "template",
          [slotDir.loc.start.offset, slotDir.loc.start.offset + (slotDir.loc.source.startsWith("#") ? "#".length : slotDir.loc.source.startsWith("v-slot:") ? "v-slot:".length : 0)],
          { ...capabilitiesPresets.slotName, completion: false }
        ]), ["", "template", (slotDir.arg ?? slotDir).loc.end.offset, capabilitiesPresets.diagnosticOnly]);
        if (hasProps) {
          codes.push(")");
        }
        codes.push(";\n");
        slotBlockVars.forEach((varName) => {
          localVars[varName] ?? (localVars[varName] = 0);
          localVars[varName]++;
        });
        let prev;
        for (const childNode of node.children) {
          visitNode(childNode, parentEl, prev, componentCtxVar);
          prev = childNode;
        }
        resolveComment();
        slotBlockVars.forEach((varName) => {
          localVars[varName]--;
        });
        let isStatic2 = true;
        if (((_d = slotDir == null ? void 0 : slotDir.arg) == null ? void 0 : _d.type) === 4) {
          isStatic2 = slotDir.arg.isStatic;
        }
        if (isStatic2 && slotDir && !slotDir.arg) {
          codes.push(`${componentCtxVar}.slots!['`, [
            "",
            "template",
            slotDir.loc.start.offset + (slotDir.loc.source.startsWith("#") ? "#".length : slotDir.loc.source.startsWith("v-slot:") ? "v-slot:".length : 0),
            { completion: true }
          ], `'/* empty slot name completion */]
`);
        }
        codes.push(`}
`);
      } else {
        let prev;
        for (const childNode of node.children) {
          visitNode(childNode, parentEl, prev, componentCtxVar);
          prev = childNode;
        }
        resolveComment();
      }
      codes.push(`}
`);
    }
    function generateEvents(node, componentVar, componentInstanceVar, componentCtxVar) {
      var _a2, _b;
      for (const prop of node.props) {
        let appendExpressionNode = function(prop2) {
          var _a3;
          if (((_a3 = prop2.exp) == null ? void 0 : _a3.type) === 4) {
            const ast2 = createTsAst(prop2.exp, prop2.exp.content);
            let isCompoundExpression = true;
            if (ast2.getChildCount() === 2) {
              ast2.forEachChild((child_1) => {
                if (ts2.isExpressionStatement(child_1)) {
                  child_1.forEachChild((child_2) => {
                    if (ts2.isArrowFunction(child_2)) {
                      isCompoundExpression = false;
                    } else if (ts2.isIdentifier(child_2)) {
                      isCompoundExpression = false;
                    }
                  });
                } else if (ts2.isFunctionDeclaration(child_1)) {
                  isCompoundExpression = false;
                }
              });
            }
            let prefix = "(";
            let suffix = ")";
            if (isCompoundExpression) {
              prefix = "$event => {\n";
              for (const blockCondition of blockConditions) {
                prefix += `if (!(${blockCondition})) return;
`;
              }
              suffix = "\n}";
            }
            let isFirstMapping = true;
            codes.push(...createInterpolationCode(prop2.exp.content, prop2.exp.loc, prop2.exp.loc.start.offset, () => {
              if (isCompoundExpression && isFirstMapping) {
                isFirstMapping = false;
                return capabilitiesPresets.allWithHiddenParam;
              }
              return capabilitiesPresets.all;
            }, prefix, suffix));
            formatCodes.push(...createFormatCode(prop2.exp.content, prop2.exp.loc.start.offset, isCompoundExpression ? formatBrackets.event : formatBrackets.normal));
          } else {
            codes.push(`() => {}`);
          }
        };
        if (prop.type === 7 && prop.name === "on" && ((_a2 = prop.arg) == null ? void 0 : _a2.type) === 4) {
          const eventVar = `__VLS_${elementIndex++}`;
          codes.push(`let ${eventVar} = { '${prop.arg.loc.source}': `, `__VLS_pickEvent(${componentCtxVar}.emit!, '${prop.arg.loc.source}' as const, __VLS_componentProps(${componentVar}, ${componentInstanceVar})`, ...createPropertyAccessCode([
            (0, shared_1$w.camelize)("on-" + prop.arg.loc.source),
            "template",
            [prop.arg.loc.start.offset, prop.arg.loc.end.offset],
            {
              ...capabilitiesPresets.attrReference,
              rename: {
                // @click-outside -> onClickOutside
                normalize(newName) {
                  return (0, shared_1$w.camelize)("on-" + newName);
                },
                // onClickOutside -> @click-outside
                apply(newName) {
                  const hName = (0, shared_1$w.hyphenate)(newName);
                  if ((0, shared_1$w.hyphenate)(newName).startsWith("on-")) {
                    return (0, shared_1$w.camelize)(hName.slice("on-".length));
                  }
                  return newName;
                }
              }
            }
          ]), `) };
`, `${eventVar} = {
`);
          if (prop.arg.loc.source.startsWith("[") && prop.arg.loc.source.endsWith("]")) {
            codes.push("[(", ...createInterpolationCode(prop.arg.loc.source.slice(1, -1), prop.arg.loc, prop.arg.loc.start.offset + 1, capabilitiesPresets.all, "", ""), ")!]");
          } else {
            codes.push(...createObjectPropertyCode([
              prop.arg.loc.source,
              "template",
              prop.arg.loc.start.offset,
              capabilitiesPresets.event
            ], prop.arg.loc));
          }
          codes.push(`: `);
          appendExpressionNode(prop);
          codes.push(`};
`);
        } else if (prop.type === 7 && prop.name === "on" && ((_b = prop.exp) == null ? void 0 : _b.type) === 4) {
          codes.push(...createInterpolationCode(prop.exp.content, prop.exp.loc, prop.exp.loc.start.offset, capabilitiesPresets.all, "$event => {(", ")}"), ";\n");
          formatCodes.push(...createFormatCode(prop.exp.content, prop.exp.loc.start.offset, formatBrackets.normal));
        }
      }
    }
    function createPropsCode(node, props, mode, propsFailedExps) {
      var _a2, _b, _c, _d, _e;
      let styleAttrNum = 0;
      let classAttrNum = 0;
      if (props.some(
        (prop) => {
          var _a3;
          return prop.type === 7 && prop.name === "bind" && !prop.arg && ((_a3 = prop.exp) == null ? void 0 : _a3.type) === 4;
        }
        /* CompilerDOM.NodeTypes.SIMPLE_EXPRESSION */
      )) {
        styleAttrNum++;
        classAttrNum++;
      }
      const codes2 = [];
      let caps_all = capabilitiesPresets.all;
      let caps_diagnosticOnly = capabilitiesPresets.diagnosticOnly;
      let caps_attr = capabilitiesPresets.attr;
      if (mode === "extraReferences") {
        caps_all = {
          references: caps_all.references,
          rename: caps_all.rename
        };
        caps_diagnosticOnly = {
          references: caps_diagnosticOnly.references,
          rename: caps_diagnosticOnly.rename
        };
        caps_attr = {
          references: caps_attr.references,
          rename: caps_attr.rename
        };
      }
      codes2.push(`...{ `);
      for (const prop of props) {
        if (prop.type === 7 && prop.name === "on" && ((_a2 = prop.arg) == null ? void 0 : _a2.type) === 4) {
          codes2.push(...createObjectPropertyCode((0, shared_1$w.camelize)("on-" + prop.arg.loc.source)), ": {} as any, ");
        }
      }
      codes2.push(`}, `);
      for (const prop of props) {
        if (prop.type === 7 && (prop.name === "bind" || prop.name === "model") && (prop.name === "model" || ((_b = prop.arg) == null ? void 0 : _b.type) === 4) && (!prop.exp || prop.exp.type === 4)) {
          let attrNameText = ((_c = prop.arg) == null ? void 0 : _c.type) === 4 ? prop.arg.constType === 3 ? prop.arg.content : prop.arg.loc.source : getModelValuePropName(node, vueCompilerOptions.target, vueCompilerOptions);
          if (prop.modifiers.some((m) => m === "prop" || m === "attr")) {
            attrNameText = attrNameText == null ? void 0 : attrNameText.substring(1);
          }
          if (attrNameText === void 0 || vueCompilerOptions.dataAttributes.some((pattern) => (0, minimatch_1.minimatch)(attrNameText, pattern)) || attrNameText === "style" && ++styleAttrNum >= 2 || attrNameText === "class" && ++classAttrNum >= 2 || attrNameText === "name" && node.tag === "slot") {
            if (prop.exp && prop.exp.constType !== 3) {
              propsFailedExps == null ? void 0 : propsFailedExps.push(prop.exp);
            }
            continue;
          }
          let camelized = false;
          if ((!prop.arg || prop.arg.type === 4 && prop.arg.isStatic) && (0, shared_1$w.hyphenate)(attrNameText) === attrNameText && !vueCompilerOptions.htmlAttributes.some((pattern) => (0, minimatch_1.minimatch)(attrNameText, pattern))) {
            attrNameText = (0, shared_1$w.camelize)(attrNameText);
            camelized = true;
          }
          codes2.push([
            "",
            "template",
            prop.loc.start.offset,
            caps_diagnosticOnly
          ]);
          if (!prop.arg) {
            codes2.push(...createObjectPropertyCode([
              attrNameText,
              "template",
              [prop.loc.start.offset, prop.loc.start.offset + prop.loc.source.indexOf("=")],
              caps_attr
            ], prop.loc.name_1 ?? (prop.loc.name_1 = {})));
          } else if (((_d = prop.exp) == null ? void 0 : _d.constType) === 3) {
            codes2.push(...createObjectPropertyCode([
              attrNameText,
              "template",
              [prop.arg.loc.start.offset, prop.arg.loc.start.offset + attrNameText.length],
              {
                ...caps_attr,
                rename: {
                  normalize: shared_1$w.camelize,
                  apply: camelized ? shared_1$w.hyphenate : noEditApply
                }
              }
            ], prop.loc.name_2 ?? (prop.loc.name_2 = {})));
          } else {
            codes2.push(...createObjectPropertyCode([
              attrNameText,
              "template",
              [prop.arg.loc.start.offset, prop.arg.loc.end.offset],
              {
                ...caps_attr,
                rename: {
                  normalize: shared_1$w.camelize,
                  apply: camelized ? shared_1$w.hyphenate : noEditApply
                }
              }
            ], prop.loc.name_2 ?? (prop.loc.name_2 = {})));
          }
          codes2.push(": (");
          if (prop.exp && !(prop.exp.constType === 3)) {
            codes2.push(...createInterpolationCode(prop.exp.loc.source, prop.exp.loc, prop.exp.loc.start.offset, caps_all, "(", ")"));
            if (mode === "normal") {
              formatCodes.push(...createFormatCode(prop.exp.loc.source, prop.exp.loc.start.offset, formatBrackets.normal));
            }
          } else {
            codes2.push("{}");
          }
          codes2.push(")");
          codes2.push([
            "",
            "template",
            prop.loc.end.offset,
            caps_diagnosticOnly
          ]);
          codes2.push(", ");
        } else if (prop.type === 6) {
          let attrNameText = prop.name;
          if (vueCompilerOptions.dataAttributes.some((pattern) => (0, minimatch_1.minimatch)(attrNameText, pattern)) || attrNameText === "style" && ++styleAttrNum >= 2 || attrNameText === "class" && ++classAttrNum >= 2 || attrNameText === "name" && node.tag === "slot") {
            continue;
          }
          let camelized = false;
          if ((0, shared_1$w.hyphenate)(prop.name) === prop.name && !vueCompilerOptions.htmlAttributes.some((pattern) => (0, minimatch_1.minimatch)(attrNameText, pattern))) {
            attrNameText = (0, shared_1$w.camelize)(prop.name);
            camelized = true;
          }
          codes2.push([
            "",
            "template",
            prop.loc.start.offset,
            caps_diagnosticOnly
          ]);
          codes2.push(...createObjectPropertyCode([
            attrNameText,
            "template",
            [prop.loc.start.offset, prop.loc.start.offset + prop.name.length],
            {
              ...caps_attr,
              rename: {
                normalize: shared_1$w.camelize,
                apply: camelized ? shared_1$w.hyphenate : noEditApply
              }
            }
          ], prop.loc.name_1 ?? (prop.loc.name_1 = {})));
          codes2.push(": (");
          if (prop.value) {
            generateAttrValue(prop.value);
          } else {
            codes2.push("true");
          }
          codes2.push(")");
          codes2.push([
            "",
            "template",
            prop.loc.end.offset,
            caps_diagnosticOnly
          ]);
          codes2.push(", ");
        } else if (prop.type === 7 && prop.name === "bind" && !prop.arg && ((_e = prop.exp) == null ? void 0 : _e.type) === 4) {
          codes2.push("...", ...createInterpolationCode(prop.exp.content, prop.exp.loc, prop.exp.loc.start.offset, caps_all, "(", ")"), ", ");
          if (mode === "normal") {
            formatCodes.push(...createFormatCode(prop.exp.content, prop.exp.loc.start.offset, formatBrackets.normal));
          }
        } else
          ;
      }
      return codes2;
      function generateAttrValue(attrNode) {
        const char = attrNode.loc.source.startsWith("'") ? "'" : '"';
        codes2.push(char);
        let start = attrNode.loc.start.offset;
        let end = attrNode.loc.end.offset;
        let content = attrNode.loc.source;
        if (content.startsWith('"') && content.endsWith('"') || content.startsWith("'") && content.endsWith("'")) {
          start++;
          end--;
          content = content.slice(1, -1);
        }
        codes2.push([
          toUnicodeIfNeed(content),
          "template",
          [start, end],
          caps_all
        ]);
        codes2.push(char);
      }
    }
    function generateInlineCss(props) {
      var _a2, _b;
      for (const prop of props) {
        if (prop.type === 7 && prop.name === "bind" && ((_a2 = prop.arg) == null ? void 0 : _a2.type) === 4 && ((_b = prop.exp) == null ? void 0 : _b.type) === 4 && prop.arg.content === "style" && prop.exp.constType === 3) {
          const endCrt = prop.arg.loc.source[prop.arg.loc.source.length - 1];
          const start = prop.arg.loc.source.indexOf(endCrt) + 1;
          const end = prop.arg.loc.source.lastIndexOf(endCrt);
          const content = prop.arg.loc.source.substring(start, end);
          cssCodes.push(`x { `);
          cssCodes.push([
            content,
            "template",
            prop.arg.loc.start.offset + start,
            capabilitiesPresets.all
          ]);
          cssCodes.push(` }
`);
        }
      }
    }
    function generateDirectives(node) {
      var _a2, _b;
      for (const prop of node.props) {
        if (prop.type === 7 && prop.name !== "slot" && prop.name !== "on" && prop.name !== "model" && prop.name !== "bind" && (prop.name !== "scope" && prop.name !== "data")) {
          identifiers2.add((0, shared_1$w.camelize)("v-" + prop.name));
          if (((_a2 = prop.arg) == null ? void 0 : _a2.type) === 4 && !prop.arg.isStatic) {
            codes.push(...createInterpolationCode(prop.arg.content, prop.arg.loc, prop.arg.loc.start.offset + prop.arg.loc.source.indexOf(prop.arg.content), capabilitiesPresets.all, "(", ")"), ";\n");
            formatCodes.push(...createFormatCode(prop.arg.content, prop.arg.loc.start.offset, formatBrackets.normal));
          }
          codes.push([
            "",
            "template",
            prop.loc.start.offset,
            capabilitiesPresets.diagnosticOnly
          ], `__VLS_directiveFunction(__VLS_ctx.`, [
            (0, shared_1$w.camelize)("v-" + prop.name),
            "template",
            [prop.loc.start.offset, prop.loc.start.offset + "v-".length + prop.name.length],
            {
              ...capabilitiesPresets.noDiagnostic,
              completion: {
                // fix https://github.com/vuejs/language-tools/issues/1905
                additional: true
              },
              rename: {
                normalize: shared_1$w.camelize,
                apply: getRenameApply(prop.name)
              }
            }
          ], ")", "(");
          if (((_b = prop.exp) == null ? void 0 : _b.type) === 4) {
            codes.push(["", "template", prop.exp.loc.start.offset, capabilitiesPresets.diagnosticOnly], ...createInterpolationCode(prop.exp.content, prop.exp.loc, prop.exp.loc.start.offset, capabilitiesPresets.all, "(", ")"), ["", "template", prop.exp.loc.end.offset, capabilitiesPresets.diagnosticOnly]);
            formatCodes.push(...createFormatCode(prop.exp.content, prop.exp.loc.start.offset, formatBrackets.normal));
          } else {
            codes.push("undefined");
          }
          codes.push(")", ["", "template", prop.loc.end.offset, capabilitiesPresets.diagnosticOnly], ";\n");
        }
      }
    }
    function generateElReferences(node) {
      for (const prop of node.props) {
        if (prop.type === 6 && prop.name === "ref" && prop.value) {
          codes.push("// @ts-ignore\n", ...createInterpolationCode(prop.value.content, prop.value.loc, prop.value.loc.start.offset + 1, capabilitiesPresets.refAttr, "(", ")"), ";\n");
        }
      }
    }
    function generateClassScoped(node) {
      var _a2, _b;
      for (const prop of node.props) {
        if (prop.type === 6 && prop.name === "class" && prop.value) {
          let startOffset = prop.value.loc.start.offset;
          let tempClassName = "";
          for (const char of prop.value.loc.source + " ") {
            if (char.trim() === "" || char === '"' || char === "'") {
              if (tempClassName !== "") {
                scopedClasses.push({ className: tempClassName, offset: startOffset });
                startOffset += tempClassName.length;
                tempClassName = "";
              }
              startOffset += char.length;
            } else {
              tempClassName += char;
            }
          }
        } else if (prop.type === 7 && ((_a2 = prop.arg) == null ? void 0 : _a2.type) === 4 && ((_b = prop.exp) == null ? void 0 : _b.type) === 4 && prop.arg.content === "class") {
          codes.push(`__VLS_styleScopedClasses = (`);
          codes.push([
            prop.exp.content,
            "template",
            prop.exp.loc.start.offset,
            capabilitiesPresets.scopedClassName
          ]);
          codes.push(`);
`);
        }
      }
    }
    function generateSlot(node, startTagOffset) {
      var _a2, _b, _c;
      const varSlot = `__VLS_${elementIndex++}`;
      const slotNameExpNode = getSlotNameExpNode();
      if (hasScriptSetupSlots) {
        codes.push("__VLS_normalizeSlot(", ["", "template", node.loc.start.offset, capabilitiesPresets.diagnosticOnly], "__VLS_slots[", ["", "template", node.loc.start.offset, capabilitiesPresets.diagnosticOnly], (slotNameExpNode == null ? void 0 : slotNameExpNode.content) ?? `('${getSlotName2()}' as const)`, ["", "template", node.loc.end.offset, capabilitiesPresets.diagnosticOnly], "]", ["", "template", node.loc.end.offset, capabilitiesPresets.diagnosticOnly], ")?.(", ["", "template", startTagOffset, capabilitiesPresets.diagnosticOnly], "{\n");
      } else {
        codes.push(`var ${varSlot} = {
`);
      }
      for (const prop of node.props) {
        if (prop.type === 7 && !prop.arg && ((_a2 = prop.exp) == null ? void 0 : _a2.type) === 4) {
          codes.push("...", ...createInterpolationCode(prop.exp.content, prop.exp.loc, prop.exp.loc.start.offset, capabilitiesPresets.attrReference, "(", ")"), ",\n");
        } else if (prop.type === 7 && ((_b = prop.arg) == null ? void 0 : _b.type) === 4 && ((_c = prop.exp) == null ? void 0 : _c.type) === 4 && prop.arg.content !== "name") {
          codes.push(...createObjectPropertyCode([
            prop.arg.content,
            "template",
            [prop.arg.loc.start.offset, prop.arg.loc.end.offset],
            {
              ...capabilitiesPresets.slotProp,
              rename: {
                normalize: shared_1$w.camelize,
                apply: getRenameApply(prop.arg.content)
              }
            }
          ], prop.arg.loc), ": ", ...createInterpolationCode(prop.exp.content, prop.exp.loc, prop.exp.loc.start.offset, capabilitiesPresets.attrReference, "(", ")"), ",\n");
        } else if (prop.type === 6 && prop.name !== "name") {
          codes.push(...createObjectPropertyCode([
            prop.name,
            "template",
            prop.loc.start.offset,
            {
              ...capabilitiesPresets.attr,
              rename: {
                normalize: shared_1$w.camelize,
                apply: getRenameApply(prop.name)
              }
            }
          ], prop.loc), ": (", prop.value !== void 0 ? `"${toUnicodeIfNeed(prop.value.content)}"` : "true", "),\n");
        }
      }
      codes.push("}", hasScriptSetupSlots ? ["", "template", startTagOffset + node.tag.length, capabilitiesPresets.diagnosticOnly] : "", hasScriptSetupSlots ? `);
` : `;
`);
      if (hasScriptSetupSlots) {
        return;
      }
      if (slotNameExpNode) {
        const varSlotExp = `__VLS_${elementIndex++}`;
        codes.push(`var ${varSlotExp} = `);
        if (typeof slotNameExpNode === "string") {
          codes.push(slotNameExpNode);
        } else {
          codes.push(...createInterpolationCode(slotNameExpNode.content, slotNameExpNode, void 0, void 0, "(", ")"));
        }
        codes.push(`;
`);
        slotExps.set(varSlotExp, {
          varName: varSlot
        });
      } else {
        const slotName = getSlotName2();
        slots.set(slotName, {
          varName: varSlot,
          loc: [startTagOffset, startTagOffset + node.tag.length],
          nodeLoc: node.loc
        });
      }
      function getSlotName2() {
        for (const prop2 of node.props) {
          if (prop2.name === "name" && prop2.type === 6 && prop2.value) {
            if (prop2.value.content) {
              return prop2.value.content;
            }
          }
        }
        return "default";
      }
      function getSlotNameExpNode() {
        var _a3, _b2;
        for (const prop2 of node.props) {
          if (prop2.type === 7 && prop2.name === "bind" && ((_a3 = prop2.arg) == null ? void 0 : _a3.type) === 4 && prop2.arg.content === "name") {
            if (((_b2 = prop2.exp) == null ? void 0 : _b2.type) === 4) {
              return prop2.exp;
            }
          }
        }
      }
    }
    function generateAutoImportCompletionCode() {
      if (!tempVars.length)
        return;
      codes.push("// @ts-ignore\n");
      codes.push("[");
      for (const _vars of tempVars) {
        for (const v of _vars) {
          codes.push([v.text, "template", v.offset, { completion: { additional: true } }]);
          codes.push(",");
        }
      }
      codes.push("];\n");
      tempVars.length = 0;
    }
    function createFormatCode(mapCode, sourceOffset, formatWrapper) {
      return [
        formatWrapper[0],
        [mapCode, "template", sourceOffset, {
          completion: true
          /* fix vue-autoinsert-parentheses not working */
        }],
        formatWrapper[1],
        "\n"
      ];
    }
    function createObjectPropertyCode(a2, astHolder) {
      const aStr = typeof a2 === "string" ? a2 : a2[0];
      if (validTsVarReg.test(aStr)) {
        return [a2];
      } else if (aStr.startsWith("[") && aStr.endsWith("]") && astHolder) {
        const range2 = typeof a2 === "object" ? a2[2] : void 0;
        const data2 = typeof a2 === "object" ? a2[3] : void 0;
        return createInterpolationCode(aStr, astHolder, range2 && typeof range2 === "object" ? range2[0] : range2, data2, "", "");
      } else {
        return createStringLiteralKeyCode(a2);
      }
    }
    function createInterpolationCode(_code, astHolder, start, data2, prefix, suffix) {
      const code = prefix + _code + suffix;
      const ast2 = createTsAst(astHolder, code);
      const codes2 = [];
      const vars = (0, transform_1$1.walkInterpolationFragment)(ts2, code, ast2, (frag, fragOffset, isJustForErrorMapping) => {
        if (fragOffset === void 0) {
          codes2.push(frag);
        } else {
          fragOffset -= prefix.length;
          let addSuffix = "";
          const overLength = fragOffset + frag.length - _code.length;
          if (overLength > 0) {
            addSuffix = frag.substring(frag.length - overLength);
            frag = frag.substring(0, frag.length - overLength);
          }
          if (fragOffset < 0) {
            codes2.push(frag.substring(0, -fragOffset));
            frag = frag.substring(-fragOffset);
            fragOffset = 0;
          }
          if (start !== void 0 && data2 !== void 0) {
            codes2.push([
              frag,
              "template",
              start + fragOffset,
              isJustForErrorMapping ? capabilitiesPresets.diagnosticOnly : typeof data2 === "function" ? data2() : data2
            ]);
          } else {
            codes2.push(frag);
          }
          codes2.push(addSuffix);
        }
      }, localVars, identifiers2, vueCompilerOptions);
      if (start !== void 0) {
        for (const v of vars) {
          v.offset = start + v.offset - prefix.length;
        }
        if (vars.length) {
          tempVars.push(vars);
        }
      }
      return codes2;
    }
    function createTsAst(astHolder, text2) {
      if (astHolder.__volar_ast_text !== text2) {
        astHolder.__volar_ast_text = text2;
        astHolder.__volar_ast = ts2.createSourceFile("/a.ts", text2, ts2.ScriptTarget.ESNext);
      }
      return astHolder.__volar_ast;
    }
    function createPropertyAccessCode(a2, astHolder) {
      const aStr = typeof a2 === "string" ? a2 : a2[0];
      if (!compilerOptions.noPropertyAccessFromIndexSignature && validTsVarReg.test(aStr)) {
        return [".", a2];
      } else if (aStr.startsWith("[") && aStr.endsWith("]")) {
        if (typeof a2 === "string" || !astHolder) {
          return [a2];
        } else {
          return createInterpolationCode(a2[0], astHolder, typeof a2[2] === "number" ? a2[2] : a2[2][0], a2[3], "", "");
        }
      } else {
        return ["[", ...createStringLiteralKeyCode(a2), "]"];
      }
    }
    function createStringLiteralKeyCode(a2) {
      let codes2 = ['"', a2, '"'];
      if (typeof a2 === "object") {
        const start = typeof a2[2] === "number" ? a2[2] : a2[2][0];
        const end = typeof a2[2] === "number" ? a2[2] : a2[2][1];
        codes2 = [
          ["", "template", start, a2[3]],
          ...codes2,
          ["", "template", end, a2[3]]
        ];
      }
      return codes2;
    }
  }
  template.generate = generate$3;
  function walkElementNodes(node, cb) {
    if (node.type === 0) {
      for (const child of node.children) {
        walkElementNodes(child, cb);
      }
    } else if (node.type === 1) {
      const patchForNode = getVForNode(node);
      if (patchForNode) {
        walkElementNodes(patchForNode, cb);
      } else {
        cb(node);
        for (const child of node.children) {
          walkElementNodes(child, cb);
        }
      }
    } else if (node.type === 9) {
      for (let i = 0; i < node.branches.length; i++) {
        const branch = node.branches[i];
        for (const childNode of branch.children) {
          walkElementNodes(childNode, cb);
        }
      }
    } else if (node.type === 11) {
      for (const child of node.children) {
        walkElementNodes(child, cb);
      }
    }
  }
  template.walkElementNodes = walkElementNodes;
  function toUnicodeIfNeed(str2) {
    if (str2.indexOf("\\") === -1 && str2.indexOf("\n") === -1) {
      return str2;
    }
    return toUnicode(str2);
  }
  function toUnicode(str2) {
    return str2.split("").map((value) => {
      const temp = value.charCodeAt(0).toString(16).padStart(4, "0");
      if (temp.length > 2) {
        return "\\u" + temp;
      }
      return value;
    }).join("");
  }
  function camelizeComponentName(newName) {
    return (0, shared_1$w.camelize)("-" + newName);
  }
  function getRenameApply(oldName) {
    return oldName === (0, shared_1$w.hyphenate)(oldName) ? shared_1$w.hyphenate : noEditApply;
  }
  function noEditApply(n) {
    return n;
  }
  function getModelValuePropName(node, vueVersion, vueCompilerOptions) {
    var _a2;
    for (const modelName in vueCompilerOptions.experimentalModelPropName) {
      const tags2 = vueCompilerOptions.experimentalModelPropName[modelName];
      for (const tag in tags2) {
        if (node.tag === tag || node.tag === (0, shared_1$w.hyphenate)(tag)) {
          const v = tags2[tag];
          if (typeof v === "object") {
            const arr = Array.isArray(v) ? v : [v];
            for (const attrs of arr) {
              let failed = false;
              for (const attr in attrs) {
                const attrNode = node.props.find((prop) => prop.type === 6 && prop.name === attr);
                if (!attrNode || ((_a2 = attrNode.value) == null ? void 0 : _a2.content) !== attrs[attr]) {
                  failed = true;
                  break;
                }
              }
              if (!failed) {
                return modelName || void 0;
              }
            }
          }
        }
      }
    }
    for (const modelName in vueCompilerOptions.experimentalModelPropName) {
      const tags2 = vueCompilerOptions.experimentalModelPropName[modelName];
      for (const tag in tags2) {
        if (node.tag === tag || node.tag === (0, shared_1$w.hyphenate)(tag)) {
          const attrs = tags2[tag];
          if (attrs === true) {
            return modelName || void 0;
          }
        }
      }
    }
    return vueVersion < 3 ? "value" : "modelValue";
  }
  function getVForNode(node) {
    const forDirective = node.props.find((prop) => prop.type === 7 && prop.name === "for");
    if (forDirective) {
      let forNode;
      CompilerDOM$1.processFor(node, forDirective, transformContext, (_forNode) => {
        forNode = { ..._forNode };
        return void 0;
      });
      if (forNode) {
        forNode.children = [{
          ...node,
          props: node.props.filter((prop) => prop !== forDirective)
        }];
        return forNode;
      }
    }
  }
  function getVIfNode(node) {
    const forDirective = node.props.find((prop) => prop.type === 7 && prop.name === "if");
    if (forDirective) {
      let ifNode;
      CompilerDOM$1.processIf(node, forDirective, transformContext, (_ifNode) => {
        ifNode = { ..._ifNode };
        return void 0;
      });
      if (ifNode) {
        for (const branch of ifNode.branches) {
          branch.children = [{
            ...node,
            props: node.props.filter((prop) => prop !== forDirective)
          }];
        }
        return ifNode;
      }
    }
  }
  function commonjsRequire(path2) {
    throw new Error('Could not dynamically require "' + path2 + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
  }
  var languageModule = {};
  var plugins = {};
  const sfcBlockReg$1 = /\<(script|style)\b([\s\S]*?)\>([\s\S]*?)\<\/\1\>/g;
  const langReg = /\blang\s*=\s*(['\"]?)(\S*)\b\1/;
  const plugin$d = () => {
    return {
      version: 1,
      parseSFC(fileName, content) {
        var _a2;
        if (fileName.endsWith(".html")) {
          let sfc = {
            descriptor: {
              filename: fileName,
              source: content,
              template: null,
              script: null,
              scriptSetup: null,
              styles: [],
              customBlocks: [],
              cssVars: [],
              shouldForceReload: () => false,
              slotted: false
            },
            errors: []
          };
          let templateContent = content;
          for (const match of content.matchAll(sfcBlockReg$1)) {
            const matchText = match[0];
            const tag = match[1];
            const attrs = match[2];
            const lang = (_a2 = attrs.match(langReg)) == null ? void 0 : _a2[2];
            const content2 = match[3];
            const contentStart = match.index + matchText.indexOf(content2);
            if (tag === "style") {
              sfc.descriptor.styles.push({
                attrs: {},
                content: content2,
                loc: {
                  start: { column: -1, line: -1, offset: contentStart },
                  end: { column: -1, line: -1, offset: contentStart + content2.length },
                  source: content2
                },
                type: "style",
                lang
              });
            } else if (tag === "script" && attrs.indexOf("src=") === -1) {
              let type = attrs.indexOf("type=") >= 0 ? "scriptSetup" : "script";
              sfc.descriptor[type] = {
                attrs: {},
                content: content2,
                loc: {
                  start: { column: -1, line: -1, offset: contentStart },
                  end: { column: -1, line: -1, offset: contentStart + content2.length },
                  source: content2
                },
                type: "script",
                lang
              };
            }
            templateContent = templateContent.substring(0, match.index) + " ".repeat(matchText.length) + templateContent.substring(match.index + matchText.length);
          }
          sfc.descriptor.template = {
            attrs: {},
            content: templateContent,
            loc: {
              start: { column: -1, line: -1, offset: 0 },
              end: { column: -1, line: -1, offset: templateContent.length },
              source: templateContent
            },
            type: "template",
            ast: {}
          };
          return sfc;
        }
      }
    };
  };
  var fileHtml = plugin$d;
  var parseSfc = {};
  Object.defineProperty(parseSfc, "__esModule", { value: true });
  parseSfc.parse = void 0;
  const compiler = require$$9$1;
  function parse$b(source) {
    const errors = [];
    const ast2 = compiler.parse(source, {
      // there are no components at SFC parsing level
      isNativeTag: () => true,
      // preserve all whitespaces
      isPreTag: () => true,
      getTextMode: ({ tag, props }, parent) => {
        if (!parent && tag !== "template" || tag === "template" && props.some((p) => p.type === 6 && p.name === "lang" && p.value && p.value.content && p.value.content !== "html")) {
          return 2;
        } else {
          return 0;
        }
      },
      onError: (e) => {
        errors.push(e);
      },
      comments: true
    });
    const descriptor = {
      filename: "anonymous.vue",
      source,
      template: null,
      script: null,
      scriptSetup: null,
      styles: [],
      customBlocks: [],
      cssVars: [],
      slotted: false,
      shouldForceReload: () => false
    };
    ast2.children.forEach((node) => {
      if (node.type !== 1) {
        return;
      }
      switch (node.tag) {
        case "template":
          const templateBlock = descriptor.template = createBlock(node, source);
          templateBlock.ast = node;
          break;
        case "script":
          const scriptBlock = createBlock(node, source);
          const isSetup = !!scriptBlock.attrs.setup;
          if (isSetup && !descriptor.scriptSetup) {
            descriptor.scriptSetup = scriptBlock;
            break;
          }
          if (!isSetup && !descriptor.script) {
            descriptor.script = scriptBlock;
            break;
          }
          break;
        case "style":
          const styleBlock = createBlock(node, source);
          descriptor.styles.push(styleBlock);
          break;
        default:
          descriptor.customBlocks.push(createBlock(node, source));
          break;
      }
    });
    return {
      descriptor,
      errors
    };
  }
  parseSfc.parse = parse$b;
  function createBlock(node, source) {
    const type = node.tag;
    let { start, end } = node.loc;
    let content = "";
    if (node.children.length) {
      start = node.children[0].loc.start;
      end = node.children[node.children.length - 1].loc.end;
      content = source.slice(start.offset, end.offset);
    } else {
      const offset = node.loc.source.indexOf(`</`);
      if (offset > -1) {
        start = {
          line: start.line,
          column: start.column + offset,
          offset: start.offset + offset
        };
      }
      end = Object.assign({}, start);
    }
    const loc = {
      source: content,
      start,
      end
    };
    const attrs = {};
    const block = {
      type,
      content,
      loc,
      attrs
    };
    node.props.forEach((p) => {
      if (p.type === 6) {
        attrs[p.name] = p.value ? p.value.content || true : true;
        if (p.name === "lang") {
          block.lang = p.value && p.value.content;
        } else if (p.name === "src") {
          block.src = p.value && p.value.content;
        } else if (type === "style") {
          if (p.name === "scoped") {
            block.scoped = true;
          } else if (p.name === "module") {
            block.module = attrs[p.name];
          }
        } else if (type === "script" && p.name === "setup") {
          block.setup = attrs.setup;
        }
      }
    });
    return block;
  }
  const source_map_1$2 = out$a;
  const parseSfc_1$1 = parseSfc;
  const codeblockReg = /```[\s\S]+?```/g;
  const inlineCodeblockReg = /`[^\n`]+?`/g;
  const scriptSetupReg = /\\\<[\s\S]+?\>\n?/g;
  const sfcBlockReg = /\<(script|style)\b[\s\S]*?\>([\s\S]*?)\<\/\1\>/g;
  const angleBracketReg = /\<\S*\:\S*\>/g;
  const linkReg = /\[[\s\S]*?\]\([\s\S]*?\)/g;
  const plugin$c = () => {
    return {
      version: 1,
      parseSFC(fileName, content) {
        if (fileName.endsWith(".md")) {
          let transformRange = function(block) {
            var _a2, _b;
            block.loc.start.offset = ((_a2 = file2VueSourceMap.toSourceOffset(block.loc.start.offset)) == null ? void 0 : _a2[0]) ?? -1;
            block.loc.end.offset = ((_b = file2VueSourceMap.toSourceOffset(block.loc.end.offset)) == null ? void 0 : _b[0]) ?? -1;
          };
          content = content.replace(codeblockReg, (match) => "```" + " ".repeat(match.length - 6) + "```").replace(inlineCodeblockReg, (match) => `\`${" ".repeat(match.length - 2)}\``).replace(scriptSetupReg, (match) => " ".repeat(match.length));
          const codes = [];
          for (const match of content.matchAll(sfcBlockReg)) {
            if (match.index !== void 0) {
              const matchText = match[0];
              codes.push([matchText, void 0, match.index]);
              codes.push("\n\n");
              content = content.substring(0, match.index) + " ".repeat(matchText.length) + content.substring(match.index + matchText.length);
            }
          }
          content = content.replace(angleBracketReg, (match) => " ".repeat(match.length)).replace(linkReg, (match) => " ".repeat(match.length));
          codes.push("<template>\n");
          codes.push([content, void 0, 0]);
          codes.push("\n</template>");
          const file2VueSourceMap = new source_map_1$2.SourceMap((0, source_map_1$2.buildMappings)(codes));
          const sfc = (0, parseSfc_1$1.parse)((0, source_map_1$2.toString)(codes));
          if (sfc.descriptor.template) {
            transformRange(sfc.descriptor.template);
          }
          if (sfc.descriptor.script) {
            transformRange(sfc.descriptor.script);
          }
          if (sfc.descriptor.scriptSetup) {
            transformRange(sfc.descriptor.scriptSetup);
          }
          for (const style2 of sfc.descriptor.styles) {
            transformRange(style2);
          }
          for (const customBlock of sfc.descriptor.customBlocks) {
            transformRange(customBlock);
          }
          return sfc;
        }
      }
    };
  };
  var fileMd = plugin$c;
  const parseSfc_1 = parseSfc;
  const plugin$b = (_ctx) => {
    return {
      version: 1,
      parseSFC(_fileName, content) {
        return (0, parseSfc_1.parse)(content);
      },
      updateSFC(sfc, change) {
        const blocks = [
          sfc.descriptor.template,
          sfc.descriptor.script,
          sfc.descriptor.scriptSetup,
          ...sfc.descriptor.styles,
          ...sfc.descriptor.customBlocks
        ].filter((block) => !!block);
        const hitBlock = blocks.find((block) => change.start >= block.loc.start.offset && change.end <= block.loc.end.offset);
        if (!hitBlock) {
          return;
        }
        hitBlock.content = hitBlock.content.substring(0, change.start - hitBlock.loc.start.offset) + change.newText + hitBlock.content.substring(change.end - hitBlock.loc.start.offset);
        const lengthDiff = change.newText.length - (change.end - change.start);
        for (const block of blocks) {
          if (block.loc.start.offset > change.end) {
            block.loc.start.offset += lengthDiff;
          }
          if (block.loc.end.offset >= change.end) {
            block.loc.end.offset += lengthDiff;
          }
        }
        return sfc;
      }
    };
  };
  var fileVue = plugin$b;
  const language_core_1$b = out$b;
  const customBlockReg = /^(.*)\.customBlock_([^_]+)_(\d+)\.([^.]+)$/;
  const plugin$a = () => {
    return {
      version: 1,
      getEmbeddedFileNames(fileName, sfc) {
        const names = [];
        for (let i = 0; i < sfc.customBlocks.length; i++) {
          const customBlock = sfc.customBlocks[i];
          names.push(fileName + ".customBlock_" + customBlock.type + "_" + i + "." + customBlock.lang);
        }
        return names;
      },
      resolveEmbeddedFile(_fileName, sfc, embeddedFile) {
        const match = embeddedFile.fileName.match(customBlockReg);
        if (match) {
          const index2 = parseInt(match[3]);
          const customBlock = sfc.customBlocks[index2];
          embeddedFile.capabilities = language_core_1$b.FileCapabilities.full;
          embeddedFile.content.push([
            customBlock.content,
            customBlock.name,
            0,
            language_core_1$b.FileRangeCapabilities.full
          ]);
        }
      }
    };
  };
  var vueSfcCustomblocks = plugin$a;
  const language_core_1$a = out$b;
  const scriptFormatReg = /^(.*)\.script_format\.([^.]+)$/;
  const scriptSetupFormatReg = /^(.*)\.scriptSetup_format\.([^.]+)$/;
  const plugin$9 = () => {
    return {
      version: 1,
      getEmbeddedFileNames(fileName, sfc) {
        const names = [];
        if (sfc.script) {
          names.push(fileName + ".script_format." + sfc.script.lang);
        }
        if (sfc.scriptSetup) {
          names.push(fileName + ".scriptSetup_format." + sfc.scriptSetup.lang);
        }
        return names;
      },
      resolveEmbeddedFile(_fileName, sfc, embeddedFile) {
        const scriptMatch = embeddedFile.fileName.match(scriptFormatReg);
        const scriptSetupMatch = embeddedFile.fileName.match(scriptSetupFormatReg);
        const script2 = scriptMatch ? sfc.script : scriptSetupMatch ? sfc.scriptSetup : void 0;
        if (script2) {
          embeddedFile.kind = language_core_1$a.FileKind.TextFile;
          embeddedFile.capabilities = {
            ...language_core_1$a.FileCapabilities.full,
            diagnostic: false,
            codeAction: false,
            inlayHint: false
          };
          embeddedFile.content.push([
            script2.content,
            script2.name,
            0,
            {}
          ]);
        }
      }
    };
  };
  var vueSfcScripts = plugin$9;
  const language_core_1$9 = out$b;
  const styleReg = /^(.*)\.style_(\d+)\.([^.]+)$/;
  const plugin$8 = () => {
    return {
      version: 1,
      getEmbeddedFileNames(fileName, sfc) {
        const names = [];
        for (let i = 0; i < sfc.styles.length; i++) {
          const style2 = sfc.styles[i];
          names.push(fileName + ".style_" + i + "." + style2.lang);
        }
        return names;
      },
      resolveEmbeddedFile(_fileName, sfc, embeddedFile) {
        const match = embeddedFile.fileName.match(styleReg);
        if (match) {
          const index2 = parseInt(match[2]);
          const style2 = sfc.styles[index2];
          embeddedFile.capabilities = language_core_1$9.FileCapabilities.full;
          embeddedFile.content.push([
            style2.content,
            style2.name,
            0,
            language_core_1$9.FileRangeCapabilities.full
          ]);
        }
      }
    };
  };
  var vueSfcStyles = plugin$8;
  const language_core_1$8 = out$b;
  const templateReg = /^(.*)\.template\.([^.]+)$/;
  const plugin$7 = () => {
    return {
      version: 1,
      getEmbeddedFileNames(fileName, sfc) {
        if (sfc.template) {
          return [fileName + ".template." + sfc.template.lang];
        }
        return [];
      },
      resolveEmbeddedFile(_fileName, sfc, embeddedFile) {
        const match = embeddedFile.fileName.match(templateReg);
        if (match && sfc.template) {
          embeddedFile.capabilities = language_core_1$8.FileCapabilities.full;
          embeddedFile.content.push([
            sfc.template.content,
            sfc.template.name,
            0,
            language_core_1$8.FileRangeCapabilities.full
          ]);
        }
      }
    };
  };
  var vueSfcTemplate = plugin$7;
  const plugin$6 = ({ modules: modules2 }) => {
    return {
      version: 1,
      compileSFCTemplate(lang, template2, options) {
        if (lang === "html") {
          const compiler2 = modules2["@vue/compiler-dom"];
          return compiler2.compile(template2, {
            ...options,
            comments: true
          });
        }
      },
      updateSFCTemplate(oldResult, change) {
        modules2["@vue/compiler-dom"];
        const lengthDiff = change.newText.length - (change.end - change.start);
        let hitNodes = [];
        if (tryUpdateNode(oldResult.ast) && hitNodes.length) {
          hitNodes = hitNodes.sort((a2, b) => a2.loc.source.length - b.loc.source.length);
          const hitNode = hitNodes[0];
          if (hitNode.type === 4) {
            return oldResult;
          }
        }
        function tryUpdateNode(node) {
          if (withinChangeRange(node.loc)) {
            hitNodes.push(node);
          }
          if (tryUpdateNodeLoc(node.loc)) {
            if (node.type === 0) {
              for (const child of node.children) {
                if (!tryUpdateNode(child)) {
                  return false;
                }
              }
            } else if (node.type === 1) {
              if (withinChangeRange(node.loc)) {
                const start = node.loc.start.offset + 2;
                const end = node.loc.start.offset + node.loc.source.lastIndexOf("</");
                if (!withinChangeRange({ start: { offset: start }, end: { offset: end }, source: "" })) {
                  return false;
                }
              }
              for (const prop of node.props) {
                if (!tryUpdateNode(prop)) {
                  return false;
                }
              }
              for (const child of node.children) {
                if (!tryUpdateNode(child)) {
                  return false;
                }
              }
            } else if (node.type === 6) {
              if (node.value && !tryUpdateNode(node.value)) {
                return false;
              }
            } else if (node.type === 7) {
              if (node.arg && withinChangeRange(node.arg.loc) && node.name === "slot") {
                return false;
              }
              if (node.exp && withinChangeRange(node.exp.loc) && node.name === "for") {
                return false;
              }
              if (node.arg && !tryUpdateNode(node.arg)) {
                return false;
              }
              if (node.exp && !tryUpdateNode(node.exp)) {
                return false;
              }
            } else if (node.type === 12) {
              if (!tryUpdateNode(node.content)) {
                return false;
              }
            } else if (node.type === 8) {
              for (const childNode of node.children) {
                if (typeof childNode === "object") {
                  if (!tryUpdateNode(childNode)) {
                    return false;
                  }
                }
              }
            } else if (node.type === 9) {
              for (const branch of node.branches) {
                if (branch.condition && !tryUpdateNode(branch.condition)) {
                  return false;
                }
                for (const child of branch.children) {
                  if (!tryUpdateNode(child)) {
                    return false;
                  }
                }
              }
            } else if (node.type === 11) {
              for (const child of [
                node.parseResult.source,
                node.parseResult.value,
                node.parseResult.key,
                node.parseResult.index
              ]) {
                if (child && !tryUpdateNode(child)) {
                  return false;
                }
              }
              for (const child of node.children) {
                if (!tryUpdateNode(child)) {
                  return false;
                }
              }
            } else if (node.type === 5) {
              if (!tryUpdateNode(node.content)) {
                return false;
              }
            } else if (node.type === 4) {
              if (withinChangeRange(node.loc)) {
                if (node.isStatic) {
                  return false;
                } else {
                  node.content = node.loc.source;
                }
              }
            }
            return true;
          }
          return false;
        }
        function tryUpdateNodeLoc(loc) {
          delete loc.__endOffset;
          if (withinChangeRange(loc)) {
            loc.source = loc.source.substring(0, change.start - loc.start.offset) + change.newText + loc.source.substring(change.end - loc.start.offset);
            loc.__endOffset = loc.end.offset;
            loc.end.offset += lengthDiff;
            return true;
          } else if (change.end <= loc.start.offset) {
            loc.__endOffset = loc.end.offset;
            loc.start.offset += lengthDiff;
            loc.end.offset += lengthDiff;
            return true;
          } else if (change.start >= loc.end.offset) {
            return true;
          }
          return false;
        }
        function withinChangeRange(loc) {
          const originalLocEnd = loc.__endOffset ?? loc.end.offset;
          return change.start >= loc.start.offset && change.end <= originalLocEnd;
        }
      }
    };
  };
  var vueTemplateHtml = plugin$6;
  var vueTsx = {};
  let activeEffectScope;
  class EffectScope {
    constructor(detached = false) {
      this.detached = detached;
      this._active = true;
      this.effects = [];
      this.cleanups = [];
      this.parent = activeEffectScope;
      if (!detached && activeEffectScope) {
        this.index = (activeEffectScope.scopes || (activeEffectScope.scopes = [])).push(
          this
        ) - 1;
      }
    }
    get active() {
      return this._active;
    }
    run(fn) {
      if (this._active) {
        const currentEffectScope = activeEffectScope;
        try {
          activeEffectScope = this;
          return fn();
        } finally {
          activeEffectScope = currentEffectScope;
        }
      }
    }
    /**
     * This should only be called on non-detached scopes
     * @internal
     */
    on() {
      activeEffectScope = this;
    }
    /**
     * This should only be called on non-detached scopes
     * @internal
     */
    off() {
      activeEffectScope = this.parent;
    }
    stop(fromParent) {
      if (this._active) {
        let i, l;
        for (i = 0, l = this.effects.length; i < l; i++) {
          this.effects[i].stop();
        }
        for (i = 0, l = this.cleanups.length; i < l; i++) {
          this.cleanups[i]();
        }
        if (this.scopes) {
          for (i = 0, l = this.scopes.length; i < l; i++) {
            this.scopes[i].stop(true);
          }
        }
        if (!this.detached && this.parent && !fromParent) {
          const last2 = this.parent.scopes.pop();
          if (last2 && last2 !== this) {
            this.parent.scopes[this.index] = last2;
            last2.index = this.index;
          }
        }
        this.parent = void 0;
        this._active = false;
      }
    }
  }
  function effectScope(detached) {
    return new EffectScope(detached);
  }
  function recordEffectScope(effect2, scope = activeEffectScope) {
    if (scope && scope.active) {
      scope.effects.push(effect2);
    }
  }
  function getCurrentScope() {
    return activeEffectScope;
  }
  function onScopeDispose(fn) {
    if (activeEffectScope) {
      activeEffectScope.cleanups.push(fn);
    }
  }
  const createDep = (effects) => {
    const dep = new Set(effects);
    dep.w = 0;
    dep.n = 0;
    return dep;
  };
  const wasTracked = (dep) => (dep.w & trackOpBit) > 0;
  const newTracked = (dep) => (dep.n & trackOpBit) > 0;
  const initDepMarkers = ({ deps }) => {
    if (deps.length) {
      for (let i = 0; i < deps.length; i++) {
        deps[i].w |= trackOpBit;
      }
    }
  };
  const finalizeDepMarkers = (effect2) => {
    const { deps } = effect2;
    if (deps.length) {
      let ptr = 0;
      for (let i = 0; i < deps.length; i++) {
        const dep = deps[i];
        if (wasTracked(dep) && !newTracked(dep)) {
          dep.delete(effect2);
        } else {
          deps[ptr++] = dep;
        }
        dep.w &= ~trackOpBit;
        dep.n &= ~trackOpBit;
      }
      deps.length = ptr;
    }
  };
  const targetMap = /* @__PURE__ */ new WeakMap();
  let effectTrackDepth = 0;
  let trackOpBit = 1;
  const maxMarkerBits = 30;
  let activeEffect;
  const ITERATE_KEY = Symbol("");
  const MAP_KEY_ITERATE_KEY = Symbol("");
  class ReactiveEffect {
    constructor(fn, scheduler2 = null, scope) {
      this.fn = fn;
      this.scheduler = scheduler2;
      this.active = true;
      this.deps = [];
      this.parent = void 0;
      recordEffectScope(this, scope);
    }
    run() {
      if (!this.active) {
        return this.fn();
      }
      let parent = activeEffect;
      let lastShouldTrack = shouldTrack;
      while (parent) {
        if (parent === this) {
          return;
        }
        parent = parent.parent;
      }
      try {
        this.parent = activeEffect;
        activeEffect = this;
        shouldTrack = true;
        trackOpBit = 1 << ++effectTrackDepth;
        if (effectTrackDepth <= maxMarkerBits) {
          initDepMarkers(this);
        } else {
          cleanupEffect(this);
        }
        return this.fn();
      } finally {
        if (effectTrackDepth <= maxMarkerBits) {
          finalizeDepMarkers(this);
        }
        trackOpBit = 1 << --effectTrackDepth;
        activeEffect = this.parent;
        shouldTrack = lastShouldTrack;
        this.parent = void 0;
        if (this.deferStop) {
          this.stop();
        }
      }
    }
    stop() {
      if (activeEffect === this) {
        this.deferStop = true;
      } else if (this.active) {
        cleanupEffect(this);
        if (this.onStop) {
          this.onStop();
        }
        this.active = false;
      }
    }
  }
  function cleanupEffect(effect2) {
    const { deps } = effect2;
    if (deps.length) {
      for (let i = 0; i < deps.length; i++) {
        deps[i].delete(effect2);
      }
      deps.length = 0;
    }
  }
  function effect(fn, options) {
    if (fn.effect) {
      fn = fn.effect.fn;
    }
    const _effect = new ReactiveEffect(fn);
    if (options) {
      extend$1(_effect, options);
      if (options.scope)
        recordEffectScope(_effect, options.scope);
    }
    if (!options || !options.lazy) {
      _effect.run();
    }
    const runner = _effect.run.bind(_effect);
    runner.effect = _effect;
    return runner;
  }
  function stop(runner) {
    runner.effect.stop();
  }
  let shouldTrack = true;
  const trackStack = [];
  function pauseTracking() {
    trackStack.push(shouldTrack);
    shouldTrack = false;
  }
  function enableTracking() {
    trackStack.push(shouldTrack);
    shouldTrack = true;
  }
  function resetTracking() {
    const last2 = trackStack.pop();
    shouldTrack = last2 === void 0 ? true : last2;
  }
  function track(target2, type, key) {
    if (shouldTrack && activeEffect) {
      let depsMap = targetMap.get(target2);
      if (!depsMap) {
        targetMap.set(target2, depsMap = /* @__PURE__ */ new Map());
      }
      let dep = depsMap.get(key);
      if (!dep) {
        depsMap.set(key, dep = createDep());
      }
      trackEffects(dep);
    }
  }
  function trackEffects(dep, debuggerEventExtraInfo) {
    let shouldTrack2 = false;
    if (effectTrackDepth <= maxMarkerBits) {
      if (!newTracked(dep)) {
        dep.n |= trackOpBit;
        shouldTrack2 = !wasTracked(dep);
      }
    } else {
      shouldTrack2 = !dep.has(activeEffect);
    }
    if (shouldTrack2) {
      dep.add(activeEffect);
      activeEffect.deps.push(dep);
    }
  }
  function trigger(target2, type, key, newValue, oldValue, oldTarget) {
    const depsMap = targetMap.get(target2);
    if (!depsMap) {
      return;
    }
    let deps = [];
    if (type === "clear") {
      deps = [...depsMap.values()];
    } else if (key === "length" && isArray$2(target2)) {
      const newLength = Number(newValue);
      depsMap.forEach((dep, key2) => {
        if (key2 === "length" || key2 >= newLength) {
          deps.push(dep);
        }
      });
    } else {
      if (key !== void 0) {
        deps.push(depsMap.get(key));
      }
      switch (type) {
        case "add":
          if (!isArray$2(target2)) {
            deps.push(depsMap.get(ITERATE_KEY));
            if (isMap(target2)) {
              deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
            }
          } else if (isIntegerKey(key)) {
            deps.push(depsMap.get("length"));
          }
          break;
        case "delete":
          if (!isArray$2(target2)) {
            deps.push(depsMap.get(ITERATE_KEY));
            if (isMap(target2)) {
              deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
            }
          }
          break;
        case "set":
          if (isMap(target2)) {
            deps.push(depsMap.get(ITERATE_KEY));
          }
          break;
      }
    }
    if (deps.length === 1) {
      if (deps[0]) {
        {
          triggerEffects(deps[0]);
        }
      }
    } else {
      const effects = [];
      for (const dep of deps) {
        if (dep) {
          effects.push(...dep);
        }
      }
      {
        triggerEffects(createDep(effects));
      }
    }
  }
  function triggerEffects(dep, debuggerEventExtraInfo) {
    const effects = isArray$2(dep) ? dep : [...dep];
    for (const effect2 of effects) {
      if (effect2.computed) {
        triggerEffect(effect2);
      }
    }
    for (const effect2 of effects) {
      if (!effect2.computed) {
        triggerEffect(effect2);
      }
    }
  }
  function triggerEffect(effect2, debuggerEventExtraInfo) {
    if (effect2 !== activeEffect || effect2.allowRecurse) {
      if (effect2.scheduler) {
        effect2.scheduler();
      } else {
        effect2.run();
      }
    }
  }
  function getDepFromReactive(object, key) {
    var _a2;
    return (_a2 = targetMap.get(object)) == null ? void 0 : _a2.get(key);
  }
  const isNonTrackableKeys = /* @__PURE__ */ makeMap$1(`__proto__,__v_isRef,__isVue`);
  const builtInSymbols = new Set(
    /* @__PURE__ */ Object.getOwnPropertyNames(Symbol).filter((key) => key !== "arguments" && key !== "caller").map((key) => Symbol[key]).filter(isSymbol)
  );
  const get$1 = /* @__PURE__ */ createGetter();
  const shallowGet = /* @__PURE__ */ createGetter(false, true);
  const readonlyGet = /* @__PURE__ */ createGetter(true);
  const shallowReadonlyGet = /* @__PURE__ */ createGetter(true, true);
  const arrayInstrumentations = /* @__PURE__ */ createArrayInstrumentations();
  function createArrayInstrumentations() {
    const instrumentations = {};
    ["includes", "indexOf", "lastIndexOf"].forEach((key) => {
      instrumentations[key] = function(...args) {
        const arr = toRaw(this);
        for (let i = 0, l = this.length; i < l; i++) {
          track(arr, "get", i + "");
        }
        const res = arr[key](...args);
        if (res === -1 || res === false) {
          return arr[key](...args.map(toRaw));
        } else {
          return res;
        }
      };
    });
    ["push", "pop", "shift", "unshift", "splice"].forEach((key) => {
      instrumentations[key] = function(...args) {
        pauseTracking();
        const res = toRaw(this)[key].apply(this, args);
        resetTracking();
        return res;
      };
    });
    return instrumentations;
  }
  function hasOwnProperty$1(key) {
    const obj = toRaw(this);
    track(obj, "has", key);
    return obj.hasOwnProperty(key);
  }
  function createGetter(isReadonly2 = false, shallow = false) {
    return function get2(target2, key, receiver) {
      if (key === "__v_isReactive") {
        return !isReadonly2;
      } else if (key === "__v_isReadonly") {
        return isReadonly2;
      } else if (key === "__v_isShallow") {
        return shallow;
      } else if (key === "__v_raw" && receiver === (isReadonly2 ? shallow ? shallowReadonlyMap : readonlyMap : shallow ? shallowReactiveMap : reactiveMap).get(target2)) {
        return target2;
      }
      const targetIsArray = isArray$2(target2);
      if (!isReadonly2) {
        if (targetIsArray && hasOwn$1(arrayInstrumentations, key)) {
          return Reflect.get(arrayInstrumentations, key, receiver);
        }
        if (key === "hasOwnProperty") {
          return hasOwnProperty$1;
        }
      }
      const res = Reflect.get(target2, key, receiver);
      if (isSymbol(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) {
        return res;
      }
      if (!isReadonly2) {
        track(target2, "get", key);
      }
      if (shallow) {
        return res;
      }
      if (isRef$1(res)) {
        return targetIsArray && isIntegerKey(key) ? res : res.value;
      }
      if (isObject$2(res)) {
        return isReadonly2 ? readonly(res) : reactive(res);
      }
      return res;
    };
  }
  const set$1 = /* @__PURE__ */ createSetter();
  const shallowSet = /* @__PURE__ */ createSetter(true);
  function createSetter(shallow = false) {
    return function set2(target2, key, value, receiver) {
      let oldValue = target2[key];
      if (isReadonly$1(oldValue) && isRef$1(oldValue) && !isRef$1(value)) {
        return false;
      }
      if (!shallow) {
        if (!isShallow(value) && !isReadonly$1(value)) {
          oldValue = toRaw(oldValue);
          value = toRaw(value);
        }
        if (!isArray$2(target2) && isRef$1(oldValue) && !isRef$1(value)) {
          oldValue.value = value;
          return true;
        }
      }
      const hadKey = isArray$2(target2) && isIntegerKey(key) ? Number(key) < target2.length : hasOwn$1(target2, key);
      const result = Reflect.set(target2, key, value, receiver);
      if (target2 === toRaw(receiver)) {
        if (!hadKey) {
          trigger(target2, "add", key, value);
        } else if (hasChanged$1(value, oldValue)) {
          trigger(target2, "set", key, value);
        }
      }
      return result;
    };
  }
  function deleteProperty(target2, key) {
    const hadKey = hasOwn$1(target2, key);
    target2[key];
    const result = Reflect.deleteProperty(target2, key);
    if (result && hadKey) {
      trigger(target2, "delete", key, void 0);
    }
    return result;
  }
  function has$1(target2, key) {
    const result = Reflect.has(target2, key);
    if (!isSymbol(key) || !builtInSymbols.has(key)) {
      track(target2, "has", key);
    }
    return result;
  }
  function ownKeys(target2) {
    track(target2, "iterate", isArray$2(target2) ? "length" : ITERATE_KEY);
    return Reflect.ownKeys(target2);
  }
  const mutableHandlers = {
    get: get$1,
    set: set$1,
    deleteProperty,
    has: has$1,
    ownKeys
  };
  const readonlyHandlers = {
    get: readonlyGet,
    set(target2, key) {
      return true;
    },
    deleteProperty(target2, key) {
      return true;
    }
  };
  const shallowReactiveHandlers = /* @__PURE__ */ extend$1(
    {},
    mutableHandlers,
    {
      get: shallowGet,
      set: shallowSet
    }
  );
  const shallowReadonlyHandlers = /* @__PURE__ */ extend$1(
    {},
    readonlyHandlers,
    {
      get: shallowReadonlyGet
    }
  );
  const toShallow = (value) => value;
  const getProto = (v) => Reflect.getPrototypeOf(v);
  function get$2(target2, key, isReadonly2 = false, isShallow2 = false) {
    target2 = target2["__v_raw"];
    const rawTarget = toRaw(target2);
    const rawKey = toRaw(key);
    if (!isReadonly2) {
      if (key !== rawKey) {
        track(rawTarget, "get", key);
      }
      track(rawTarget, "get", rawKey);
    }
    const { has: has2 } = getProto(rawTarget);
    const wrap = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
    if (has2.call(rawTarget, key)) {
      return wrap(target2.get(key));
    } else if (has2.call(rawTarget, rawKey)) {
      return wrap(target2.get(rawKey));
    } else if (target2 !== rawTarget) {
      target2.get(key);
    }
  }
  function has(key, isReadonly2 = false) {
    const target2 = this["__v_raw"];
    const rawTarget = toRaw(target2);
    const rawKey = toRaw(key);
    if (!isReadonly2) {
      if (key !== rawKey) {
        track(rawTarget, "has", key);
      }
      track(rawTarget, "has", rawKey);
    }
    return key === rawKey ? target2.has(key) : target2.has(key) || target2.has(rawKey);
  }
  function size(target2, isReadonly2 = false) {
    target2 = target2["__v_raw"];
    !isReadonly2 && track(toRaw(target2), "iterate", ITERATE_KEY);
    return Reflect.get(target2, "size", target2);
  }
  function add$1(value) {
    value = toRaw(value);
    const target2 = toRaw(this);
    const proto = getProto(target2);
    const hadKey = proto.has.call(target2, value);
    if (!hadKey) {
      target2.add(value);
      trigger(target2, "add", value, value);
    }
    return this;
  }
  function set$2(key, value) {
    value = toRaw(value);
    const target2 = toRaw(this);
    const { has: has2, get: get2 } = getProto(target2);
    let hadKey = has2.call(target2, key);
    if (!hadKey) {
      key = toRaw(key);
      hadKey = has2.call(target2, key);
    }
    const oldValue = get2.call(target2, key);
    target2.set(key, value);
    if (!hadKey) {
      trigger(target2, "add", key, value);
    } else if (hasChanged$1(value, oldValue)) {
      trigger(target2, "set", key, value);
    }
    return this;
  }
  function deleteEntry(key) {
    const target2 = toRaw(this);
    const { has: has2, get: get2 } = getProto(target2);
    let hadKey = has2.call(target2, key);
    if (!hadKey) {
      key = toRaw(key);
      hadKey = has2.call(target2, key);
    }
    get2 ? get2.call(target2, key) : void 0;
    const result = target2.delete(key);
    if (hadKey) {
      trigger(target2, "delete", key, void 0);
    }
    return result;
  }
  function clear() {
    const target2 = toRaw(this);
    const hadItems = target2.size !== 0;
    const result = target2.clear();
    if (hadItems) {
      trigger(target2, "clear", void 0, void 0);
    }
    return result;
  }
  function createForEach(isReadonly2, isShallow2) {
    return function forEach(callback, thisArg) {
      const observed = this;
      const target2 = observed["__v_raw"];
      const rawTarget = toRaw(target2);
      const wrap = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
      !isReadonly2 && track(rawTarget, "iterate", ITERATE_KEY);
      return target2.forEach((value, key) => {
        return callback.call(thisArg, wrap(value), wrap(key), observed);
      });
    };
  }
  function createIterableMethod(method, isReadonly2, isShallow2) {
    return function(...args) {
      const target2 = this["__v_raw"];
      const rawTarget = toRaw(target2);
      const targetIsMap = isMap(rawTarget);
      const isPair = method === "entries" || method === Symbol.iterator && targetIsMap;
      const isKeyOnly = method === "keys" && targetIsMap;
      const innerIterator = target2[method](...args);
      const wrap = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
      !isReadonly2 && track(
        rawTarget,
        "iterate",
        isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY
      );
      return {
        // iterator protocol
        next() {
          const { value, done } = innerIterator.next();
          return done ? { value, done } : {
            value: isPair ? [wrap(value[0]), wrap(value[1])] : wrap(value),
            done
          };
        },
        // iterable protocol
        [Symbol.iterator]() {
          return this;
        }
      };
    };
  }
  function createReadonlyMethod(type) {
    return function(...args) {
      return type === "delete" ? false : this;
    };
  }
  function createInstrumentations() {
    const mutableInstrumentations2 = {
      get(key) {
        return get$2(this, key);
      },
      get size() {
        return size(this);
      },
      has,
      add: add$1,
      set: set$2,
      delete: deleteEntry,
      clear,
      forEach: createForEach(false, false)
    };
    const shallowInstrumentations2 = {
      get(key) {
        return get$2(this, key, false, true);
      },
      get size() {
        return size(this);
      },
      has,
      add: add$1,
      set: set$2,
      delete: deleteEntry,
      clear,
      forEach: createForEach(false, true)
    };
    const readonlyInstrumentations2 = {
      get(key) {
        return get$2(this, key, true);
      },
      get size() {
        return size(this, true);
      },
      has(key) {
        return has.call(this, key, true);
      },
      add: createReadonlyMethod("add"),
      set: createReadonlyMethod("set"),
      delete: createReadonlyMethod("delete"),
      clear: createReadonlyMethod("clear"),
      forEach: createForEach(true, false)
    };
    const shallowReadonlyInstrumentations2 = {
      get(key) {
        return get$2(this, key, true, true);
      },
      get size() {
        return size(this, true);
      },
      has(key) {
        return has.call(this, key, true);
      },
      add: createReadonlyMethod("add"),
      set: createReadonlyMethod("set"),
      delete: createReadonlyMethod("delete"),
      clear: createReadonlyMethod("clear"),
      forEach: createForEach(true, true)
    };
    const iteratorMethods = ["keys", "values", "entries", Symbol.iterator];
    iteratorMethods.forEach((method) => {
      mutableInstrumentations2[method] = createIterableMethod(
        method,
        false,
        false
      );
      readonlyInstrumentations2[method] = createIterableMethod(
        method,
        true,
        false
      );
      shallowInstrumentations2[method] = createIterableMethod(
        method,
        false,
        true
      );
      shallowReadonlyInstrumentations2[method] = createIterableMethod(
        method,
        true,
        true
      );
    });
    return [
      mutableInstrumentations2,
      readonlyInstrumentations2,
      shallowInstrumentations2,
      shallowReadonlyInstrumentations2
    ];
  }
  const [
    mutableInstrumentations,
    readonlyInstrumentations,
    shallowInstrumentations,
    shallowReadonlyInstrumentations
  ] = /* @__PURE__ */ createInstrumentations();
  function createInstrumentationGetter(isReadonly2, shallow) {
    const instrumentations = shallow ? isReadonly2 ? shallowReadonlyInstrumentations : shallowInstrumentations : isReadonly2 ? readonlyInstrumentations : mutableInstrumentations;
    return (target2, key, receiver) => {
      if (key === "__v_isReactive") {
        return !isReadonly2;
      } else if (key === "__v_isReadonly") {
        return isReadonly2;
      } else if (key === "__v_raw") {
        return target2;
      }
      return Reflect.get(
        hasOwn$1(instrumentations, key) && key in target2 ? instrumentations : target2,
        key,
        receiver
      );
    };
  }
  const mutableCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(false, false)
  };
  const shallowCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(false, true)
  };
  const readonlyCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(true, false)
  };
  const shallowReadonlyCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(true, true)
  };
  const reactiveMap = /* @__PURE__ */ new WeakMap();
  const shallowReactiveMap = /* @__PURE__ */ new WeakMap();
  const readonlyMap = /* @__PURE__ */ new WeakMap();
  const shallowReadonlyMap = /* @__PURE__ */ new WeakMap();
  function targetTypeMap(rawType) {
    switch (rawType) {
      case "Object":
      case "Array":
        return 1;
      case "Map":
      case "Set":
      case "WeakMap":
      case "WeakSet":
        return 2;
      default:
        return 0;
    }
  }
  function getTargetType(value) {
    return value["__v_skip"] || !Object.isExtensible(value) ? 0 : targetTypeMap(toRawType$1(value));
  }
  function reactive(target2) {
    if (isReadonly$1(target2)) {
      return target2;
    }
    return createReactiveObject(
      target2,
      false,
      mutableHandlers,
      mutableCollectionHandlers,
      reactiveMap
    );
  }
  function shallowReactive(target2) {
    return createReactiveObject(
      target2,
      false,
      shallowReactiveHandlers,
      shallowCollectionHandlers,
      shallowReactiveMap
    );
  }
  function readonly(target2) {
    return createReactiveObject(
      target2,
      true,
      readonlyHandlers,
      readonlyCollectionHandlers,
      readonlyMap
    );
  }
  function shallowReadonly(target2) {
    return createReactiveObject(
      target2,
      true,
      shallowReadonlyHandlers,
      shallowReadonlyCollectionHandlers,
      shallowReadonlyMap
    );
  }
  function createReactiveObject(target2, isReadonly2, baseHandlers, collectionHandlers, proxyMap) {
    if (!isObject$2(target2)) {
      return target2;
    }
    if (target2["__v_raw"] && !(isReadonly2 && target2["__v_isReactive"])) {
      return target2;
    }
    const existingProxy = proxyMap.get(target2);
    if (existingProxy) {
      return existingProxy;
    }
    const targetType = getTargetType(target2);
    if (targetType === 0) {
      return target2;
    }
    const proxy = new Proxy(
      target2,
      targetType === 2 ? collectionHandlers : baseHandlers
    );
    proxyMap.set(target2, proxy);
    return proxy;
  }
  function isReactive(value) {
    if (isReadonly$1(value)) {
      return isReactive(value["__v_raw"]);
    }
    return !!(value && value["__v_isReactive"]);
  }
  function isReadonly$1(value) {
    return !!(value && value["__v_isReadonly"]);
  }
  function isShallow(value) {
    return !!(value && value["__v_isShallow"]);
  }
  function isProxy(value) {
    return isReactive(value) || isReadonly$1(value);
  }
  function toRaw(observed) {
    const raw = observed && observed["__v_raw"];
    return raw ? toRaw(raw) : observed;
  }
  function markRaw(value) {
    def$1(value, "__v_skip", true);
    return value;
  }
  const toReactive = (value) => isObject$2(value) ? reactive(value) : value;
  const toReadonly = (value) => isObject$2(value) ? readonly(value) : value;
  function trackRefValue(ref2) {
    if (shouldTrack && activeEffect) {
      ref2 = toRaw(ref2);
      {
        trackEffects(ref2.dep || (ref2.dep = createDep()));
      }
    }
  }
  function triggerRefValue(ref2, newVal) {
    ref2 = toRaw(ref2);
    const dep = ref2.dep;
    if (dep) {
      {
        triggerEffects(dep);
      }
    }
  }
  function isRef$1(r) {
    return !!(r && r.__v_isRef === true);
  }
  function ref(value) {
    return createRef(value, false);
  }
  function shallowRef(value) {
    return createRef(value, true);
  }
  function createRef(rawValue, shallow) {
    if (isRef$1(rawValue)) {
      return rawValue;
    }
    return new RefImpl(rawValue, shallow);
  }
  class RefImpl {
    constructor(value, __v_isShallow) {
      this.__v_isShallow = __v_isShallow;
      this.dep = void 0;
      this.__v_isRef = true;
      this._rawValue = __v_isShallow ? value : toRaw(value);
      this._value = __v_isShallow ? value : toReactive(value);
    }
    get value() {
      trackRefValue(this);
      return this._value;
    }
    set value(newVal) {
      const useDirectValue = this.__v_isShallow || isShallow(newVal) || isReadonly$1(newVal);
      newVal = useDirectValue ? newVal : toRaw(newVal);
      if (hasChanged$1(newVal, this._rawValue)) {
        this._rawValue = newVal;
        this._value = useDirectValue ? newVal : toReactive(newVal);
        triggerRefValue(this);
      }
    }
  }
  function triggerRef(ref2) {
    triggerRefValue(ref2);
  }
  function unref(ref2) {
    return isRef$1(ref2) ? ref2.value : ref2;
  }
  function toValue(source) {
    return isFunction$1(source) ? source() : unref(source);
  }
  const shallowUnwrapHandlers = {
    get: (target2, key, receiver) => unref(Reflect.get(target2, key, receiver)),
    set: (target2, key, value, receiver) => {
      const oldValue = target2[key];
      if (isRef$1(oldValue) && !isRef$1(value)) {
        oldValue.value = value;
        return true;
      } else {
        return Reflect.set(target2, key, value, receiver);
      }
    }
  };
  function proxyRefs(objectWithRefs) {
    return isReactive(objectWithRefs) ? objectWithRefs : new Proxy(objectWithRefs, shallowUnwrapHandlers);
  }
  class CustomRefImpl {
    constructor(factory) {
      this.dep = void 0;
      this.__v_isRef = true;
      const { get: get2, set: set2 } = factory(
        () => trackRefValue(this),
        () => triggerRefValue(this)
      );
      this._get = get2;
      this._set = set2;
    }
    get value() {
      return this._get();
    }
    set value(newVal) {
      this._set(newVal);
    }
  }
  function customRef(factory) {
    return new CustomRefImpl(factory);
  }
  function toRefs(object) {
    const ret = isArray$2(object) ? new Array(object.length) : {};
    for (const key in object) {
      ret[key] = propertyToRef(object, key);
    }
    return ret;
  }
  class ObjectRefImpl {
    constructor(_object, _key, _defaultValue) {
      this._object = _object;
      this._key = _key;
      this._defaultValue = _defaultValue;
      this.__v_isRef = true;
    }
    get value() {
      const val = this._object[this._key];
      return val === void 0 ? this._defaultValue : val;
    }
    set value(newVal) {
      this._object[this._key] = newVal;
    }
    get dep() {
      return getDepFromReactive(toRaw(this._object), this._key);
    }
  }
  class GetterRefImpl {
    constructor(_getter) {
      this._getter = _getter;
      this.__v_isRef = true;
      this.__v_isReadonly = true;
    }
    get value() {
      return this._getter();
    }
  }
  function toRef(source, key, defaultValue) {
    if (isRef$1(source)) {
      return source;
    } else if (isFunction$1(source)) {
      return new GetterRefImpl(source);
    } else if (isObject$2(source) && arguments.length > 1) {
      return propertyToRef(source, key, defaultValue);
    } else {
      return ref(source);
    }
  }
  function propertyToRef(source, key, defaultValue) {
    const val = source[key];
    return isRef$1