const version = "https://github.com/johnsoncodehk/volar/commit/2ddb2fa78e317fee86a90c76ad78746ff35ef86e";
const name = "vue";
const scopeName = "source.vue";
const patterns = [
  {
    include: "text.html.basic#comment"
  },
  {
    include: "#self-closing-tag"
  },
  {
    begin: "(<)",
    beginCaptures: {
      "1": {
        name: "punctuation.definition.tag.begin.html.vue"
      }
    },
    end: "(>)",
    endCaptures: {
      "1": {
        name: "punctuation.definition.tag.end.html.vue"
      }
    },
    patterns: [
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]md['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "text.html.markdown",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "text.html.markdown"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]html['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "text.html.derivative",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "#html-stuff"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]pug['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "text.pug",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "text.pug"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]stylus['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.stylus",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.stylus"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]postcss['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.postcss",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.postcss"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]sass['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.sass",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.sass"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]css['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.css",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.css"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]scss['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.css.scss",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.css.scss"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]less['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.css.less",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.css.less"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]js['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.js",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.js"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]ts['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.ts",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.ts"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]jsx['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.js.jsx",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.js.jsx"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]tsx['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.tsx",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.tsx"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]json['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.json",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.json"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]jsonc['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.json.comments",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.json.comments"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]yaml['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.yaml",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.yaml"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"]toml['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.toml",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.toml"
          }
        ]
      },
      {
        begin: `([a-zA-Z0-9:-]+)\\b(?=[^>]*\\blang\\s*=\\s*['"](gql|graphql)['"])`,
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.graphql",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.graphql"
          }
        ]
      },
      {
        begin: "(template)\\b",
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "text.html.derivative",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "#html-stuff"
          }
        ]
      },
      {
        begin: "(script)\\b",
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.js",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.js"
          }
        ]
      },
      {
        begin: "(style)\\b",
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "source.css",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "source.css"
          }
        ]
      },
      {
        begin: "([a-zA-Z0-9:-]+)",
        beginCaptures: {
          "1": {
            name: "entity.name.tag.$1.html.vue"
          }
        },
        end: "(</)(\\1)\\s*(?=>)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "2": {
            name: "entity.name.tag.$2.html.vue"
          }
        },
        name: "text",
        patterns: [
          {
            include: "#tag-stuff"
          }
        ]
      }
    ]
  }
];
const repository = {
  "self-closing-tag": {
    begin: "(<)([a-zA-Z0-9:-]+)(?=([^>]+/>))",
    beginCaptures: {
      "1": {
        name: "punctuation.definition.tag.begin.html.vue"
      },
      "2": {
        name: "entity.name.tag.$2.html.vue"
      }
    },
    end: "(?<=/>)",
    patterns: [
      {
        include: "#tag-stuff"
      }
    ]
  },
  "template-tag": {
    patterns: [
      {
        include: "#template-tag-1"
      },
      {
        include: "#template-tag-2"
      }
    ]
  },
  "template-tag-1": {
    begin: "(<)(template)\\b(>)",
    beginCaptures: {
      "1": {
        name: "punctuation.definition.tag.begin.html.vue"
      },
      "2": {
        name: "entity.name.tag.$2.html.vue"
      },
      "3": {
        name: "punctuation.definition.tag.end.html.vue"
      }
    },
    end: "(/?>)",
    endCaptures: {
      "1": {
        name: "punctuation.definition.tag.end.html.vue"
      }
    },
    name: "meta.template-tag.start",
    patterns: [
      {
        begin: "\\G",
        end: "(?=/>)|((</)(template)\\b)",
        endCaptures: {
          "2": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "3": {
            name: "entity.name.tag.$3.html.vue"
          }
        },
        name: "meta.template-tag.end",
        patterns: [
          {
            include: "#html-stuff"
          }
        ]
      }
    ]
  },
  "template-tag-2": {
    begin: "(<)(template)\\b",
    beginCaptures: {
      "1": {
        name: "punctuation.definition.tag.begin.html.vue"
      },
      "2": {
        name: "entity.name.tag.$2.html.vue"
      }
    },
    end: "(/?>)",
    endCaptures: {
      "1": {
        name: "punctuation.definition.tag.end.html.vue"
      }
    },
    name: "meta.template-tag.start",
    patterns: [
      {
        begin: "\\G",
        end: "(?=/>)|((</)(template)\\b)",
        endCaptures: {
          "2": {
            name: "punctuation.definition.tag.begin.html.vue"
          },
          "3": {
            name: "entity.name.tag.$3.html.vue"
          }
        },
        name: "meta.template-tag.end",
        patterns: [
          {
            include: "#tag-stuff"
          },
          {
            include: "#html-stuff"
          }
        ]
      }
    ]
  },
  "html-stuff": {
    patterns: [
      {
        include: "#template-tag"
      },
      {
        include: "text.html.basic"
      }
    ]
  },
  "tag-stuff": {
    begin: "\\G",
    end: "(?=/>)|(>)",
    endCaptures: {
      "1": {
        name: "punctuation.definition.tag.end.html.vue"
      }
    },
    name: "meta.tag-stuff",
    patterns: [
      {
        include: "#vue-directives"
      },
      {
        include: "text.html.basic#attribute"
      }
    ]
  },
  "vue-directives": {
    patterns: [
      {
        include: "#vue-directives-control"
      },
      {
        include: "#vue-directives-style-attr"
      },
      {
        include: "#vue-directives-original"
      }
    ]
  },
  "vue-directives-original": {
    begin: "(?:\\b(v-)|(:|@|#))(\\[?)([a-zA-Z0-9\\-_]*)(\\]?)(\\:([a-zA-Z0-9\\-_]+))?(?:\\.([a-zA-Z0-9\\-_]+))*\\s*(=)",
    captures: {
      "1": {
        name: "entity.other.attribute-name.html.vue"
      },
      "2": {
        name: "punctuation.separator.key-value.html.vue"
      },
      "3": {
        name: "punctuation.separator.key-value.html.vue"
      },
      "4": {
        name: "entity.other.attribute-name.html.vue"
      },
      "5": {
        name: "punctuation.separator.key-value.html.vue"
      },
      "6": {
        name: "entity.other.attribute-name.html.vue"
      },
      "7": {
        name: "entity.other.attribute-name.html.vue"
      },
      "8": {
        name: "entity.other.attribute-name.html.vue"
      },
      "9`": {
        name: "punctuation.separator.key-value.html.vue"
      }
    },
    end: `(?<='|")`,
    name: "meta.directive.vue",
    patterns: [
      {
        begin: `('|")`,
        beginCaptures: {
          "1": {
            name: "punctuation.definition.string.begin.html.vue"
          }
        },
        end: "(\\1)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.string.end.html.vue"
          }
        },
        name: "source.ts.embedded.html.vue",
        patterns: [
          {
            include: "source.ts"
          }
        ]
      }
    ]
  },
  "vue-directives-control": {
    begin: "(v-for)|(v-if|v-else-if|v-else)(?![\\w:-])",
    captures: {
      "0": {
        name: "keyword.control.loop.vue"
      },
      "1": {
        name: "keyword.control.conditional.vue"
      }
    },
    end: "(?=\\s*+[^=\\s])",
    name: "meta.directive.vue",
    patterns: [
      {
        begin: "=",
        beginCaptures: {
          "0": {
            name: "punctuation.separator.key-value.html.vue"
          }
        },
        end: "(?<=[^\\s=])(?!\\s*=)|(?=/?>)",
        patterns: [
          {
            begin: `('|")`,
            beginCaptures: {
              "1": {
                name: "punctuation.definition.string.begin.html.vue"
              }
            },
            end: "(\\1)",
            endCaptures: {
              "1": {
                name: "punctuation.definition.string.end.html.vue"
              }
            },
            name: "source.ts.embedded.html.vue",
            patterns: [
              {
                include: "source.ts"
              }
            ]
          }
        ]
      }
    ]
  },
  "vue-directives-style-attr": {
    begin: "\\b(style)\\s*(=)",
    captures: {
      "1": {
        name: "entity.other.attribute-name.html.vue"
      },
      "2": {
        name: "punctuation.separator.key-value.html.vue"
      }
    },
    end: `(?<='|")`,
    name: "meta.directive.vue",
    patterns: [
      {
        comment: "Copy from source.css#rule-list-innards",
        begin: `('|")`,
        beginCaptures: {
          "1": {
            name: "punctuation.definition.string.begin.html.vue"
          }
        },
        end: "(\\1)",
        endCaptures: {
          "1": {
            name: "punctuation.definition.string.end.html.vue"
          }
        },
        name: "source.css.embedded.html.vue",
        patterns: [
          {
            include: "source.css#comment-block"
          },
          {
            include: "source.css#escapes"
          },
          {
            include: "source.css#font-features"
          },
          {
            match: "(?x) (?<![\\w-])\n--\n(?:[-a-zA-Z_]    | [^\\x00-\\x7F])     # First letter\n(?:[-a-zA-Z0-9_] | [^\\x00-\\x7F]      # Remainder of identifier\n  |\\\\(?:[0-9a-fA-F]{1,6}|.)\n)*",
            name: "variable.css"
          },
          {
            begin: "(?<![-a-zA-Z])(?=[-a-zA-Z])",
            end: "$|(?![-a-zA-Z])",
            name: "meta.property-name.css",
            patterns: [
              {
                include: "source.css#property-names"
              }
            ]
          },
          {
            comment: "Modify end to fix #199. TODO: handle ' character.",
            begin: "(:)\\s*",
            beginCaptures: {
              "1": {
                name: "punctuation.separator.key-value.css"
              }
            },
            end: `\\s*(;)|\\s*(?='|")`,
            endCaptures: {
              "1": {
                name: "punctuation.terminator.rule.css"
              }
            },
            contentName: "meta.property-value.css",
            patterns: [
              {
                include: "source.css#comment-block"
              },
              {
                include: "source.css#property-values"
              }
            ]
          },
          {
            match: ";",
            name: "punctuation.terminator.rule.css"
          }
        ]
      }
    ]
  },
  "vue-interpolations": {
    patterns: [
      {
        begin: "\\{\\{",
        beginCaptures: [
          {
            name: "punctuation.definition.tag.begin.html.vue"
          }
        ],
        end: "\\}\\}",
        endCaptures: [
          {
            name: "punctuation.definition.tag.end.html.vue"
          }
        ],
        name: "expression.embbeded.vue",
        patterns: [
          {
            begin: "\\G",
            end: "(?=\\}\\})",
            name: "source.ts.embedded.html.vue",
            patterns: [
              {
                include: "source.ts"
              }
            ]
          }
        ]
      }
    ]
  }
};
const vue_tmLanguage = {
  version,
  name,
  scopeName,
  patterns,
  repository
};
export {
  vue_tmLanguage as default,
  name,
  patterns,
  repository,
  scopeName,
  version
};
