/*
 * Decompiled with CFR 0.152.
 */
package org.typo3.solr.search;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.PostFilter;
import org.typo3.access.Rootline;
import org.typo3.access.RootlineElement;
import org.typo3.access.RootlineElementType;
import org.typo3.common.lang.StringUtils;

public class AccessFilter
extends ExtendedQueryBase
implements PostFilter {
    private HashSet<Integer> userGroupSet;
    private String accessField;

    public AccessFilter() {
        this("0");
    }

    public boolean getCache() {
        return false;
    }

    public int getCost() {
        return Math.max(super.getCost(), 100);
    }

    public AccessFilter(String userGroupList) {
        this("access", userGroupList);
    }

    public AccessFilter(String field, String userGroupList) {
        this.accessField = field;
        this.setUserGroupList(userGroupList);
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    private boolean handleSingleValueAccessField(int doc, SortedDocValues values) throws IOException {
        values.advance(doc);
        BytesRef bytes = values.lookupOrd(values.ordValue());
        String documentGroupList = bytes.utf8ToString();
        return this.accessGranted(documentGroupList);
    }

    private boolean handleMultivalueAccessField(int doc, SortedSetDocValues multiValueSet) throws IOException {
        long ord;
        multiValueSet.advance(doc);
        while ((ord = multiValueSet.nextOrd()) != -1L) {
            BytesRef bytes = multiValueSet.lookupOrd(ord);
            String documentGroupList = bytes.utf8ToString();
            if (!this.accessGranted(documentGroupList)) continue;
            return true;
        }
        return false;
    }

    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        return new DelegatingCollector(){
            SortedDocValues acls;
            SortedSetDocValues aclsSet;
            boolean isMultivalue;

            public void doSetNextReader(LeafReaderContext context) throws IOException {
                DocValuesType type = context.reader().getFieldInfos().fieldInfo(AccessFilter.this.accessField).getDocValuesType();
                this.isMultivalue = type.equals((Object)DocValuesType.SORTED_SET);
                if (this.isMultivalue) {
                    this.aclsSet = context.reader().getSortedSetDocValues(AccessFilter.this.accessField);
                } else {
                    this.acls = context.reader().getSortedDocValues(AccessFilter.this.accessField);
                }
                super.doSetNextReader(context);
            }

            public void collect(int doc) throws IOException {
                if (this.isMultivalue && AccessFilter.this.handleMultivalueAccessField(doc, this.aclsSet)) {
                    super.collect(doc);
                }
                if (!this.isMultivalue && AccessFilter.this.handleSingleValueAccessField(doc, this.acls)) {
                    super.collect(doc);
                }
            }
        };
    }

    private boolean accessGranted(String documentGroupList) {
        RootlineElement element;
        Boolean accessGranted = false;
        Rootline accessRootline = new Rootline(documentGroupList);
        Iterator iterator = accessRootline.iterator();
        while (iterator.hasNext() && (accessGranted = (element = (RootlineElement)iterator.next()).getType() == RootlineElementType.PAGE ? this.accessGrantedForPage(element.getAccessGroups()) : (element.getType() == RootlineElementType.RECORD ? this.accessGrantedForRecord(element.getAccessGroups()) : Boolean.valueOf(this.userGroupSet.containsAll(element.getAccessGroups())))).booleanValue()) {
        }
        return accessGranted;
    }

    private Boolean accessGrantedForPage(HashSet<Integer> pageElementAccess) {
        Boolean accessGranted = false;
        for (Integer userGroup : this.userGroupSet) {
            if (!pageElementAccess.contains(userGroup)) continue;
            accessGranted = true;
            break;
        }
        return accessGranted;
    }

    private Boolean accessGrantedForRecord(HashSet<Integer> recordElementAccess) {
        Boolean accessGranted = false;
        for (Integer userGroup : this.userGroupSet) {
            if (!recordElementAccess.contains(userGroup)) continue;
            accessGranted = true;
            break;
        }
        return accessGranted;
    }

    private void setUserGroupList(String userGroupList) {
        this.userGroupSet = StringUtils.commaSeparatedListToIntegerHashSet(userGroupList);
    }

    public String toString(String field) {
        return ((Object)((Object)this)).getClass().getName() + " - " + this.accessField + ": " + StringUtils.implode(this.userGroupSet, ",");
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.userGroupSet != null ? this.userGroupSet.hashCode() : 0);
        result = 31 * result + (this.accessField != null ? this.accessField.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AccessFilter that = (AccessFilter)((Object)o);
        if (!this.userGroupSet.equals(that.userGroupSet)) {
            return false;
        }
        return this.accessField.equals(that.accessField);
    }
}

