/*
 * Decompiled with CFR 0.152.
 */
package org.typo3.access;

import java.util.HashSet;
import org.typo3.access.RootlineElementFormatException;
import org.typo3.access.RootlineElementType;
import org.typo3.common.lang.StringUtils;

public class RootlineElement {
    private String pageIdGroupDelimiter = ":";
    private RootlineElementType type = RootlineElementType.PAGE;
    private Integer id;
    private HashSet<Integer> accessGroups;

    public RootlineElement(String element) throws RootlineElementFormatException {
        String elementGroups;
        String[] elementAccess = StringUtils.explode(element, this.pageIdGroupDelimiter);
        if (elementAccess[0].equals("c") || elementAccess.length == 1) {
            this.id = null;
            this.type = RootlineElementType.CONTENT;
            elementGroups = elementAccess.length == 1 ? elementAccess[0] : elementAccess[1];
        } else if (elementAccess[0].equals("r")) {
            this.id = null;
            this.type = RootlineElementType.RECORD;
            elementGroups = elementAccess[1];
        } else {
            if (elementAccess.length != 2) {
                throw new RootlineElementFormatException();
            }
            this.id = Integer.parseInt(elementAccess[0]);
            elementGroups = elementAccess[1];
        }
        this.accessGroups = StringUtils.commaSeparatedListToIntegerHashSet(elementGroups);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type == RootlineElementType.CONTENT) {
            sb.append("c");
        } else if (this.type == RootlineElementType.RECORD) {
            sb.append("r");
        } else {
            sb.append(this.id);
        }
        sb.append(this.pageIdGroupDelimiter);
        sb.append(StringUtils.implode(this.accessGroups, ","));
        return new String(sb);
    }

    public final Integer getId() {
        return this.id;
    }

    public final RootlineElementType getType() {
        return this.type;
    }

    public final HashSet<Integer> getAccessGroups() {
        return this.accessGroups;
    }
}

