# GVLK Keys
These are keys, which can be used to activate a product with _py-kms_ (note this keys are provided officially by Microsoft). _py-kms_ will not reject any of your keys, instead the product will often revalidate the given key - and
sometimes even reject it by itself (often due too many uses - in that case try to use an other one).

## Windows
***

### Windows Server 2019

| Product | GVLK |
| --- | --- |
| Windows Server 2019 Datacenter | `WMDGN-G9PQG-XVVXX-R3X43-63DFG` |
| Windows Server 2019 Standard | `N69G4-B89J2-4G8F4-WWYCC-J464C` |
| Windows Server 2019 Essentials | `WVDHN-86M7X-466P6-VHXV7-YY726` |
| Windows Server 2019 Azure Core | `FDNH6-VW9RW-BXPJ7-4XTYG-239TB` |
| Windows Server 2019 Datacenter Semi-Annual Channel (v.1809) | `6NMRW-2C8FM-D24W7-TQWMY-CWH2D` |
| Windows Server 2019 Standard Semi-Annual Channel (v.1809) | `N2KJX-J94YW-TQVFB-DG9YT-724CC` |
| Windows Server 2019 ARM64 | `GRFBW-QNDC4-6QBHG-CCK3B-2PR88` |

### Windows Server 2016

| Product | GVLK |
| --- | --- |
| Windows Server 2016 Standard Semi-Annual Channel (v.1803) | `PTXN8-JFHJM-4WC78-MPCBR-9W4KR` |
| Windows Server 2016 Datacenter Semi-Annual Channel (v.1803) | `2HXDN-KRXHB-GPYC7-YCKFJ-7FVDG` |
| Windows Server 2016 Datacenter Semi-Annual Channel (v.1709) | `6Y6KB-N82V8-D8CQV-23MJW-BWTG6` |
| Windows Server 2016 Standard Semi-Annual Channel (v.1709) | `DPCNP-XQFKJ-BJF7R-FRC8D-GF6G4` |
| Windows Server 2016 ARM64 | `K9FYF-G6NCK-73M32-XMVPY-F9DRR` |
| Windows Server 2016 Datacenter | `CB7KF-BWN84-R7R2Y-793K2-8XDDG` |
| Windows Server 2016 Standard | `WC2BQ-8NRM3-FDDYY-2BFGV-KHKQY` |
| Windows Server 2016 Essentials | `JCKRF-N37P4-C2D82-9YXRT-4M63B` |
| Windows Server 2016 Cloud Storage | `QN4C6-GBJD2-FB422-GHWJK-GJG2R` |
| Windows Server 2016 Azure Core | `VP34G-4NPPG-79JTQ-864T4-R3MQX`<br>`WNCYY-GFBH2-M4WTT-XQ2FP-PG2K9` |

### Windows 10

| Product | GVLK |
| --- | --- |
| Windows 10 Professional Workstation | `NRG8B-VKK3Q-CXVCJ-9G2XF-6Q84J` |
| Windows 10 Professional Workstation N | `9FNHH-K3HBT-3W4TD-6383H-6XYWF` |
| Windows 10 Enterprise G | `YYVX9-NTFWV-6MDM3-9PT4T-4M68B` |
| Windows 10 Enterprise G N | `44RPN-FTY23-9VTTB-MP9BX-T84FV` |
| Windows 10 Enterprise LTSC 2019 | `M7XTQ-FN8P6-TTKYV-9D4CC-J462D` |
| Windows 10 Enterprise LTSC 2019 N | `92NFX-8DJQP-P6BBQ-THF9C-7CG2H` |
| Windows 10 Remote Server | `7NBT4-WGBQX-MP4H7-QXFF8-YP3KX` |
| Windows 10 Enterprise for Remote Sessions | `CPWHC-NT2C7-VYW78-DHDB2-PG3GK` |
| Windows 10 S (Lean) | `NBTWJ-3DR69-3C4V8-C26MC-GQ9M6` |
| Windows 10 Professional | `W269N-WFGWX-YVC9B-4J6C9-T83GX` |
| Windows 10 Professional N | `MH37W-N47XK-V7XM9-C7227-GCQG9`<br>`HMNWJ-V69R6-B2CDC-8P7VT-2373K` |
| Windows 10 Professional Education | `6TP4R-GNPTD-KYYHQ-7B7DP-J447Y` |
| Windows 10 Professional Education N | `YVWGF-BXNMC-HTQYQ-CPQ99-66QFC` |
| Windows 10 Education | `NW6C2-QMPVW-D7KKK-3GKT6-VCFB2`<br>`F48BJ-8NX82-MRVY9-PF8BW-HMHY2` |
| Windows 10 Education N | `2WH4N-8QGBV-H22JP-CT43Q-MDWWJ`<br>`PPWGW-8NW9C-J77Q9-8WHB9-QV64W` |
| Windows 10 Enterprise | `NPPR9-FWDCX-D2C8J-H872K-2YT43`<br>`96YNV-9X4RP-2YYKB-RMQH4-6Q72D`<br>`TN6CM-KCVXP-VVP8X-YVCF7-R9BDH`<br>`3PMKQ-YNVGT-HFJGG-2F4FQ-9D6T7` |
| Windows 10 Enterprise N | `DPH2V-TTNVB-4X9Q3-TJR4H-KHJW4`<br>`WGGHN-J84D6-QYCPR-T7PJ7-X766F` |
| Windows 10 Enterprise S | `H76BG-QBNM7-73XY9-V6W2T-684BJ` |
| Windows 10 Enterprise S N | `X4R4B-NV6WD-PKTVK-F98BH-4C2J8` |
| Windows 10 Enterprise 2015 LTSB | `WNMTR-4C88C-JK8YV-HQ7T2-76DF9` |
| Windows 10 Enterprise 2015 LTSB N | `2F77B-TNFGY-69QQF-B8YKP-D69TJ`<br>`RW7WN-FMT44-KRGBK-G44WK-QV7YK` |
| Windows 10 Enterprise 2016 LTSB | `DCPHK-NFMTC-H88MJ-PFHPY-QJ4BJ` |
| Windows 10 Enterprise 2016 LTSB N | `QFFDN-GRT3P-VKWWX-X7T3R-8B639` |
| Windows 10 Home<br>Windows 10 Core | `TX9XD-98N7V-6WMQ6-BX7FG-H8Q99`<br>`33QT6-RCNYF-DXB4F-DGP7B-7MHX9` |
| Windows 10 Home N<br>Windows 10 Core N | `3KHY7-WNT83-DGQKR-F7HPR-844BM`<br>`CP4KF-NG6TC-9K6QF-P6GTT-H8RBM` |
| Windows 10 Home Single Language<br>Windows 10 Core Single Language | `7HNRX-D7KGG-3K4RQ-4WPJ4-YTDFH`<br>`9HGRW-NH2CQ-XQHJD-YCRWB-6VJV7`<br>`4NX46-6DHCG-MR3PH-9FMCX-3RQ3G` |
| Windows 10 Home Country Specific<br>Windows 10 Core Country Specific | `PVMJN-6DFY6-9CCP6-7BKTT-D3WVR`<br>`JN9HR-MH7K4-DBPDD-TFTXF-Q9MMF` |

### Windows Server 2012 R2

| Product | GVLK |
| --- | --- |
| Windows Server 2012 R2 Standard | `D2N9P-3P6X9-2R39C-7RTCD-MDVJX` |
| Windows Server 2012 R2 Datacenter | `W3GGN-FT8W3-Y4M27-J84CP-Q3VJ9` |
| Windows Server 2012 R2 Essentials | `KNC87-3J2TX-XB4WP-VCPJV-M4FWM` |
| Windows Server 2012 R2 Cloud Storage | `3NPTF-33KPT-GGBPR-YX76B-39KDD` |

### Windows 8.1

| Product | GVLK |
| --- | --- |
| Windows 8.1 Professional | `GCRJD-8NW9H-F2CDX-CCM8D-9D6T9` |
| Windows 8.1 Professional N | `HMCNV-VVBFX-7HMBH-CTY9B-B4FXY` |
| Windows 8.1 Professional WMC | `789NJ-TQK6T-6XTH8-J39CJ-J8D3P` |
| Windows 8.1 Enterprise | `MHF9N-XY6XB-WVXMC-BTDCT-MKKG7`<br>`FHQNR-XYXYC-8PMHT-TV4PH-DRQ3H` |
| Windows 8.1 Enterprise N | `TT4HM-HN7YT-62K67-RGRQJ-JFFXW`<br>`NDRDJ-3YBP2-8WTKD-CK7VB-HT8KW` |
| Windows 8.1 Embedded Industry Automotive | `VHXM3-NR6FT-RY6RT-CK882-KW2CJ` |
| Windows 8.1 Embedded Industry Enterprise | `FNFKF-PWTVT-9RC8H-32HB2-JB34X` |
| Windows 8.1 Embedded Industry Professional | `NMMPB-38DD4-R2823-62W8D-VXKJB` |
| Windows 8.1 Core | `M9Q9P-WNJJT-6PXPY-DWX8H-6XWKK` |
| Windows 8.1 Core N | `7B9N3-D94CG-YTVHR-QBPX3-RJP64` |
| Windows 8.1 Core Single Language | `BB6NG-PQ82V-VRDPW-8XVD2-V8P66` |
| Windows 8.1 Core Country Specific | `NCTT7-2RGK8-WMHRF-RY7YQ-JTXG3` |
| Windows 8.1 Core ARM | `XYTND-K6QKT-K2MRH-66RTM-43JKP` |
| Windows 8.1 Core Connected | `3PY8R-QHNP9-W7XQD-G6DPH-3J2C9` |
| Windows 8.1 Core Connected N | `Q6HTR-N24GM-PMJFP-69CD8-2GXKR` |
| Windows 8.1 Core Connected Country Specific | `R962J-37N87-9VVK2-WJ74P-XTMHR` |
| Windows 8.1 Core Connected Single Language | `KF37N-VDV38-GRRTV-XH8X6-6F3BB` |
| Windows 8.1 Professional Student | `MX3RK-9HNGX-K3QKC-6PJ3F-W8D7B` |
| Windows 8.1 Professional Student N | `TNFGH-2R6PB-8XM3K-QYHX2-J4296` |

### Windows Server 2012

| Product | GVLK |
| --- | --- |
| Windows Server 2012<br>Windows 8 Core | `BN3D2-R7TKB-3YPBD-8DRP2-27GG4` |
| Windows Server 2012 N<br>Windows 8 Core N | `8N2M2-HWPGY-7PGT9-HGDD8-GVGGY` |
| Windows Server 2012 Single Language<br>Windows 8 Core Single Language | `2WN2H-YGCQR-KFX6K-CD6TF-84YXQ` |
| Windows Server 2012 Country Specific<br>Windows 8 Core Country Specific | `4K36P-JN4VD-GDC6V-KDT89-DYFKP` |
| Windows Server 2012 Standard | `XC9B7-NBPP2-83J2H-RHMBY-92BT4` |
| Windows Server 2012 MultiPoint Standard | `HM7DN-YVMH3-46JC3-XYTG7-CYQJJ` |
| Windows Server 2012 MultiPoint Premium | `XNH6W-2V9GX-RGJ4K-Y8X6F-QGJ2G` |
| Windows Server 2012 Datacenter | `48HP8-DN98B-MYWDG-T2DCC-8W83P` |

### Windows 8

| Product | GVLK |
| --- | --- |
| Windows 8 Professional | `NG4HW-VH26C-733KW-K6F98-J8CK4` |
| Windows 8 Professional N | `XCVCF-2NXM9-723PB-MHCB7-2RYQQ` |
| Windows 8 Professional WMC | `GNBB8-YVD74-QJHX6-27H4K-8QHDG`<br>`NQ3PX-BBY8Y-RRHMM-TBHFW-PJ866` |
| Windows 8 Enterprise | `32JNW-9KQ84-P47T8-D8GGY-CWCK7`<br>`8M9BN-YB7W9-YV3VJ-7WMGG-MKH3V` |
| Windows 8 Enterprise N | `JMNMF-RHW7P-DMY6X-RF3DR-X2BQT`<br>`NCVKH-RB9D4-R86X8-GB8WG-4M2K6` |
| Windows 8 Embedded Industry Professional | `JVPDN-TBWJW-PD94V-QYKJ2-KWYQM`<br>`RYXVT-BNQG7-VD29F-DBMRY-HT73M` |
| Windows 8 Embedded Industry Enterprise | `NKB3R-R2F8T-3XCDP-7Q2KW-XWYQ2` |
| Windows 8 Core<br>Windows Server 2012 | `BN3D2-R7TKB-3YPBD-8DRP2-27GG4` |
| Windows 8 Core N<br>Windows Server 2012 N | `8N2M2-HWPGY-7PGT9-HGDD8-GVGGY` |
| Windows 8 Core Single Language<br>Windows Server 2012 Single Language | `2WN2H-YGCQR-KFX6K-CD6TF-84YXQ` |
| Windows 8 Core Country Specific<br>Windows Server 2012 Country Specific | `4K36P-JN4VD-GDC6V-KDT89-DYFKP` |
| Windows 8 Core ARM | `DXHJF-N9KQX-MFPVR-GHGQK-Y7RKV` |

### Windows Server 2008 R2

| Product | GVLK |
| --- | --- |
| Windows MultiPoint Server 2010 | `736RG-XDKJK-V34PF-BHK87-J6X3K` |
| Windows Server 2008 R2 Web | `6TPJF-RBVHG-WBW2R-86QPH-6RTM4` |
| Windows Server 2008 R2 HPC edition | `TT8MH-CG224-D3D7Q-498W2-9QCTX` |
| Windows Server 2008 R2 Standard | `YC6KT-GKW9T-YTKYR-T4X34-R7VHC` |
| Windows Server 2008 R2 Enterprise | `489J6-VHDMP-X63PK-3K798-CPX3Y` |
| Windows Server 2008 R2 Datacenter | `74YFP-3QFB3-KQT8W-PMXWJ-7M648` |
| Windows Server 2008 R2 for Itanium-based Systems | `GT63C-RJFQ3-4GMB6-BRFB9-CB83V` |	

### Windows 7

| Product | GVLK |
| --- | --- |
| Windows 7 Professional | `FJ82H-XT6CR-J8D7P-XQJJ2-GPDD4`<br>`MYKDJ-XV4CV-M2D3P-KDVY4-MPTW8` |
| Windows 7 Professional N | `MRPKT-YTG23-K7D7T-X2JMM-QY7MG` |
| Windows 7 Professional E | `W82YF-2Q76Y-63HXB-FGJG9-GF7QX` |
| Windows 7 Enterprise | `33PXH-7Y6KF-2VJC9-XBBR8-HVTHH` |
| Windows 7 Enterprise N | `YDRBP-3D83W-TY26F-D46B2-XCKRJ` |
| Windows 7 Enterprise E | `C29WB-22CC8-VJ326-GHFJW-H9DH4` |
| Windows 7 Embedded POSReady | `YBYF6-BHCR3-JPKRB-CDW7B-F9BK4` |
| Windows 7 Embedded ThinPC | `73KQT-CD9G6-K7TQG-66MRP-CQ22C` |
| Windows 7 Embedded Standard | `XGY72-BRBBT-FF8MH-2GG8H-W7KCW` |

### Windows Server 2008

| Product | GVLK |
| --- | --- |
| Windows Server 2008 Web | `WYR28-R7TFJ-3X2YQ-YCY4H-M249D` |
| Windows Server 2008 Standard | `TM24T-X9RMF-VWXK6-X8JC9-BFGM2` |
| Windows Server 2008 Standard without Hyper-V | `W7VD6-7JFBR-RX26B-YKQ3Y-6FFFJ` |
| Windows Server 2008 Enterprise | `YQGMW-MPWTJ-34KDK-48M3W-X4Q6V` |
| Windows Server 2008 Enterprise without Hyper-V | `39BXF-X8Q23-P2WWT-38T2F-G3FPG` |
| Windows Server 2008 HPC edition (Computer Cluster) | `RCTX3-KWVHP-BR6TB-RB6DM-6X7HP` |
| Windows Server 2008 Datacenter | `7M67G-PC374-GR742-YH8V4-TCBY3` |
| Windows Server 2008 Datacenter without Hyper-V | `22XQ2-VRXRG-P8D42-K34TD-G3QQC` |
| Windows Server 2008 for Itanium-Based Systems | `4DWFP-JF3DJ-B7DTH-78FJB-PDRHK` |

### Windows Vista

| Product | GVLK |
| --- | --- |
| Windows Vista Business | `YFKBB-PQJJV-G996G-VWGXY-2V3X8` |
| Windows Vista Business N | `HMBQG-8H2RH-C77VX-27R82-VMQBT` |
| Windows Vista Enterprise | `VKK3X-68KWM-X2YGT-QR4M6-4BWMV` |
| Windows Vista Enterprise N | `VTC42-BM838-43QHV-84HX6-XJXKV` |

### Windows Previews

| Product | GVLK |
| --- | --- |
| Windows Server 2019 Datacenter [Preview] | `6XBNX-4JQGW-QX6QG-74P76-72V67` |
| Windows Server 2019 Standard [Preview] | `MFY9F-XBN2F-TYFMP-CCV49-RMYVH` |
| Windows 10 Home / Core [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows 10 Home / Core Country Specific [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows 10 Home / Core N [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows 10 Home / Core Single Language [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows 10 Home / Core [Technical Preview] | `?????-?????-?????-?????-?????` |
| Windows 10 Education [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows 10 Education N [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows 10 Enterprise [Preview] | `QNMXX-GCD3W-TCCT4-872RV-G6P4J` |
| Windows 10 Enterprise 2015 LTSB [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows 10 Enterprise 2015 LTSB N [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows 10 Enterprise N [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows 10 Professional N [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows 10 Professional [Preview] | `XQHPH-N4D9W-M8P96-DPDFP-TMVPY` |
| Windows 10 Professional WMC [Pre-Release] | `NKPM6-TCVPT-3HRFX-Q4H9B-QJ34Y`<br>`328NF-RTPQT-84J4Q-V44B8-78R2B` |
| Windows 10 IoT Core [Pre-Release] | `7NX88-X6YM3-9Q3YT-CCGBF-KBVQF`<br>`NHY4C-KCMKV-V9K9M-7R43T-KTP64` |
| Windows 10 Core Connected [Pre-Release] | `DJMYQ-WN6HG-YJ2YX-82JDB-CWFCW`<br>`QBWKP-NFVG3-CYGTT-724CF-FCYPW` |
| Windows 10 Core Connected N [Pre-Release] | `JQNT7-W63G4-WX4QX-RD9M9-6CPKM`<br>`TKDDW-N77V2-WXKMG-QY6WQ-WQJXM` |
| Windows 10 Core Connected Single Language [Pre-Release] | `QQMNF-GPVQ6-BFXGG-GWRCX-7XKT7`<br>`RQ2MN-RKR94-P86YQ-TM76X-P3667` |
| Windows 10 Core Connected Country Specific [Pre-Release] | `FTNXM-J4RGP-MYQCV-RVM8R-TVH24`<br>`TNPJK-GCKPR-4WX4C-HCJHT-HFRC4` |
| Windows 10 Professional S [Pre-Release] | `3NF4D-GF9GY-63VKH-QRC3V-7QW8P`<br>`NFDD9-FX3VM-DYCKP-B8HT8-D9M2C` |
| Windows 10 Professional S N [Pre-Release] | `KNDJ3-GVHWT-3TV4V-36K8Y-PR4PF`<br>`8Q36Y-N2F39-HRMHT-4XW33-TCQR4` |
| Windows 10 Professional Student [Pre-Release] | `YNXW3-HV3VB-Y83VG-KPBXM-6VH3Q`<br>`N6X24-448X6-HYV8Y-8XQ3V-DRRDQ` |
| Windows 10 Professional Student N [Pre-Release] | `8G9XJ-GN6PJ-GW787-MVV7G-GMR99`<br>`XHGFB-WNK7Q-BG8VG-BG2KQ-KKWX9` |
| Windows 10 PPIPro [Pre-Release (build 15063)] | `?????-?????-?????-?????-?????` |
| Windows 8 Core / Server 2012 [RC] | `?????-?????-?????-?????-?????` |
| Windows 8 Core / Server 2012 Country Specific [RC] | `?????-?????-?????-?????-?????` |
| Windows 8 Core / Server 2012 N [RC] | `?????-?????-?????-?????-?????` |
| Windows 8 Core / Server 2012 Single Language [RC] | `?????-?????-?????-?????-?????` |
| Windows 8 Core ARM64 [RC] | `?????-?????-?????-?????-?????` |
| Windows 8 Embedded Industry Professional [Beta] | `?????-?????-?????-?????-?????` |
| Windows 8 Embedded Industry Enterprise [Beta] | `?????-?????-?????-?????-?????` |
| Windows 8.1 Enterprise [Preview] | `2MP7K-98NK8-WPVF3-Q2WDG-VMD98` |
| Windows 8.1 Professional (Blue) [Preview] | `MTWNQ-CKDHJ-3HXW9-Q2PFX-WB2HQ` |
| Windows 8 Professional WMC [RC] | `MY4N9-TGH34-4X4VY-8FG2T-RRDPV` |
| Windows 8.x [Preview] | `MPWP3-DXNP9-BRD79-W8WFP-3YFJ6` |
| Windows 8.x ARM64 [Preview] | `?????-?????-?????-?????-?????` |
| Windows Next Core Connected [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Core Connected N [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Core Connected Country Specific [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Core Connected Single Language [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Professional Student [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Professional Student N [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Embedded Industry Professional [Beta] | `XY4TQ-CXNVJ-YCT73-HH6R7-R897X` |
| Windows Next Embedded Industry Enterprise [Beta] | `XCNC9-BPK3C-KCCMD-FTDTC-KWY4G`<br>`WN3XP-M9YFD-JRJ84-4J9FB-QJY4G` |
| Windows Next Embedded Industry Automotive [Beta] | `GN2X2-KXTK6-P92FR-VBB9G-PDJFP`<br>`434XB-NH62H-JG7RG-P3KMD-XHHJC` |
| Windows Server Next MultiPoint Standard [Preview] | `?????-?????-?????-?????-?????` |
| Windows Server Next MultiPoint Premium [Preview] | `?????-?????-?????-?????-?????` |
| Windows Server Next Enterprise [Preview] | `?????-?????-?????-?????-?????` |
| Windows Server Next Standard [Preview] | `?????-?????-?????-?????-?????` |
| Windows Server Next Web [Preview] | `?????-?????-?????-?????-?????` |
| Windows Server Next HPC Edition [Preview] | `?????-?????-?????-?????-?????` |
| Windows Server Next HI [Preview] | `7VX4N-3VDHQ-VYGHB-JXJVP-9QB26` |
| Enterprise ProdKey3 Win 9984 DLA/Bypass NQR Test | `?????-?????-?????-?????-?????` |
| Windows Server 2012 R2 Essentials [Preview] | `?????-?????-?????-?????-?????` |
| Windows Server 2016 Datacenter [Preview] | `VRDD2-NVGDP-K7QG8-69BR4-TVFHB` |
| Windows Vista Business [Preview 1] | `XQYF4-QVCMY-YXQRD-9QPV8-3YP9V` |
| Windows Vista Business [Preview 2] | `YVT36-YVCP2-J97GQ-7T22R-RWV8P` |
| Windows Vista Business N [Preview] | `HGBJ9-RWD6M-6HDGW-6T2XD-JQ66F` |
| Windows Vista Enterprise [Preview 1] | `3JHG3-Y66GP-B7F3K-JFVX2-VBH7K` |
| Windows Vista Enterprise [Beta-2 build 5384] | `MF9PG-RQK7R-26BPJ-TWFYK-RHXCM` |
| Windows Vista Enterprise N [Preview] | `?????-?????-?????-?????-?????` |
| Windows Longhorn Web [Preview] | `MDRCM-4WKCW-J93FF-J9Q48-M6KBB` |
| Windows Longhorn HPC Edition [Preview] | `?????-?????-?????-?????-?????` |
| Windows Longhorn Standard [Preview] | `Q37JX-P3HHB-GKRH2-PDBKG-GGXPW` |
| Windows Longhorn Enterprise [Preview] | `7KYMQ-R788Q-4RF69-KTWKM-92PFJ` |
| Windows Longhorn Datacenter [Preview] | `HR8VD-7DHG2-48378-M9D73-28F4T` |
| Windows Longhorn for Itanium Systems [Preview] | `CWV9H-PHGPW-V93WV-QBQV9-8V336` |
| Windows 7 Business [Preview] | `?????-?????-?????-?????-?????` |
| Windows 7 Business N [Preview] | `?????-?????-?????-?????-?????` |
| Windows 7 Enterprise [Preview] | `?????-?????-?????-?????-?????` |
| Windows 7 Enterprise N [Preview] | `?????-?????-?????-?????-?????` |
| Windows 7 Server Web [Preview] | `?????-?????-?????-?????-?????` |
| Windows 7 Server Standard [Preview] | `?????-?????-?????-?????-?????` |
| Windows 7 Server Standard without Hyper-V [Preview] | `?????-?????-?????-?????-?????` |
| Windows 7 Server Enterprise [Preview] | `?????-?????-?????-?????-?????` |
| Windows 7 Server Enterprise without Hyper-V [Preview] | `?????-?????-?????-?????-?????` |
| Windows 7 Server Datacenter [Preview] | `?????-?????-?????-?????-?????` |
| Windows 7 Server Datacenter without Hyper-V [Preview] | `?????-?????-?????-?????-?????` |
| Windows 7 Server for Itanium Systems [Preview] | `?????-?????-?????-?????-?????` |
| Windows Next Education [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Education N [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Professional [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Professional N [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Enterprise N [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Enterprise [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Enterprise S [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Enterprise S N [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Professional S [Pre-Release] | `?????-?????-?????-?????-?????` |
| Windows Next Professional S N [Pre-Release] | `?????-?????-?????-?????-?????` |

## Office
***

### Office 2019

| Product | GVLK |
| --- | --- |
| Professional Plus 2019 [C2R] | `VQ9DP-NVHPH-T9HJC-J9PDT-KTQRG` |
| Professional Plus 2019 | `NMMKJ-6RK4F-KMJVX-8D9MJ-6MWKP` |
| Standard 2019 | `6NWWJ-YQWMR-QKGCB-6TMB3-9D9HK` |
| Project Professional 2019 [C2R] | `XM2V9-DN9HH-QB449-XDGKC-W2RMW` |
| Project Professional 2019 | `B4NPR-3FKK7-T2MBV-FRQ4W-PKD2B` |
| Project Standard 2019 | `C4F7P-NCP8C-6CQPT-MQHV9-JXD2M` |
| Visio Professional 2019 [C2R] | `N2CG9-YD3YK-936X4-3WR82-Q3X4H`  |
| Visio Professional 2019 | `9BGNQ-K37YR-RQHF2-38RQ3-7VCBB` |
| Visio Standard 2019 | `7TQNQ-K3YQQ-3PFH7-CCPPM-X4VQ2` |
| Access 2019 | `9N9PT-27V4Y-VJ2PD-YXFMF-YTFQT` |
| Excel 2019 | `TMJWT-YYNMB-3BKTF-644FC-RVXBD` |
| Outlook 2019 | `7HD7K-N4PVK-BHBCQ-YWQRW-XW4VK` |
| PowerPoint 2019 | `RRNCX-C64HY-W2MM7-MCH9G-TJHMQ` |
| Publisher 2019 | `G2KWX-3NW6P-PY93R-JXK2T-C9Y9V` |
| Skype for Business 2019 | `NCJ33-JHBBY-HTK98-MYCV8-HMKHJ` |
| Word 2019 | `PBX3G-NWMT6-Q7XBW-PYJGG-WXD33` |

### Office 2016

| Product | GVLK |
| --- | --- |
| Professional Plus 2016 | `XQNVK-8JYDB-WJ9W3-YJ8YR-WFG99` |
| Standard 2016 | `JNRGM-WHDWX-FJJG3-K47QV-DRTFM` |
| Project Professional 2016 | `YG9NW-3K39V-2T3HJ-93F3Q-G83KT` |
| Project Professional 2016 [C2R] | `WGT24-HCNMF-FQ7XH-6M8K7-DRTW9` |
| Project Standard 2016 | `GNFHQ-F6YQM-KQDGJ-327XX-KQBVC` |
| Project Standard 2016 [C2R] | `D8NRQ-JTYM3-7J2DX-646CT-6836M` |
| Visio Professional 2016 | `PD3PC-RHNGV-FXJ29-8JK7D-RJRJK` |
| Visio Professional 2016 [C2R] | `69WXN-MBYV6-22PQG-3WGHK-RM6XC` |
| Visio Standard 2016 | `7WHWN-4T7MP-G96JF-G33KR-W8GF4` |
| Visio Standard 2016 [C2R] | `NY48V-PPYYH-3F4PX-XJRKJ-W4423` |
| Access 2016 | `GNH9Y-D2J4T-FJHGG-QRVH7-QPFDW` |
| Excel 2016 | `9C2PK-NWTVB-JMPW8-BFT28-7FTBF` |
| Mondo 2016 | `HFTND-W9MK4-8B7MJ-B6C4G-XQBR2` |
| Mondo Retail 2016 | `DMTCJ-KNRKX-26982-JYCKT-P7KB6` |
| OneNote 2016 | `DR92N-9HTF2-97XKM-XW2WJ-XW3J6` |
| Outlook 2016 | `R69KK-NTPKF-7M3Q4-QYBHW-6MT9B` |
| PowerPoint 2016 | `J7MQP-HNJ4Y-WJ7YM-PFYGF-BY6C6` |
| Publisher 2016 | `F47MM-N3XJP-TQXJ9-BP99D-8K837` |
| Skype for Business 2016 | `869NQ-FJ69K-466HW-QYCP2-DDBV6` |
| Word 2016 | `WXY84-JN2Q9-RBCCQ-3Q3J3-3PFJ6` |

### Office 2013

| Product | GVLK |
| --- | --- |
| Professional Plus 2013 [Preview] | `PGD67-JN23K-JGVWV-KTHP4-GXR9G` |
| Professional Plus 2013 | `YC7DK-G2NP3-2QQC3-J6H88-GVGXT` |
| Standard 2013 | `KBKQT-2NMXY-JJWGP-M62JB-92CD4` |
| Project Professional 2013 [Preview] | `NFKVM-DVG7F-TYWYR-3RPHY-F872K` |
| Project Professional 2013 | `FN8TT-7WMH6-2D4X9-M337T-2342K` |
| Project Standard 2013 [Preview] | `N89QF-GGB8J-BKD28-C4V28-W4XTK` |
| Project Standard 2013 | `6NTH3-CW976-3G3Y2-JK3TX-8QHTT` |
| Visio Professional 2013 [Preview] | `B3C7Q-D6NH2-2VRFW-HHWDG-FVQB6` |
| Visio Professional 2013 | `C2FG9-N6J68-H8BTJ-BW3QX-RM3B3` |
| Visio Standard 2013 [Preview] | `9MKNF-J9XQ6-JV4XB-FJQPY-43F43` |
| Visio Standard 2013 | `J484Y-4NKBF-W2HMG-DBMJC-PGWR7` |
| Access 2013 [Preview] | `DJBH8-RGN7Q-836KD-DMP3M-DM9MF` |
| Access 2013 | `NG2JY-H4JBT-HQXYP-78QH9-4JM2D` |
| Excel 2013 [Preview] | `Q3BNP-3WXDT-GG8HF-24KMW-HMDBK` |
| Excel 2013 | `VGPNG-Y7HQW-9RHP7-TKPV3-BG7GB` |
| OneNote 2013 [Preview] | `VYNYX-8GPBC-7FQMD-D6B7B-7MDFD` |
| OneNote 2013 | `TGN6P-8MMBC-37P2F-XHXXK-P34VW` |
| Outlook 2013 [Preview] | `X2KNB-FRRG2-WXDPH-739DM-DM9RH` |
| Outlook 2013 | `QPN8Q-BJBTJ-334K3-93TGY-2PMBT` |
| PowerPoint 2013 [Preview] | `B8CT8-BTNFQ-XQXBK-BFWV8-HMDFQ` |
| PowerPoint 2013 | `4NT99-8RJFH-Q2VDH-KYG2C-4RD4F` |
| Publisher 2013 [Preview] | `NB67P-J8XP4-XDK9B-V73VH-M4CKR` |
| Publisher 2013 | `PN2WF-29XG2-T9HJ7-JQPJR-FCXK4` |
| InfoPath 2013 (Preview) | `7KPJJ-N8TT7-CK3KR-QTV98-YPVXQ` |
| InfoPath 2013 | `DKT8B-N7VXH-D963P-Q4PHY-F8894` |
| Lync 2013 [Preview] | `XNVD3-RYC7T-7R6BT-WX6CF-8BYH7` |
| Lync 2013 | `2MG3G-3BNTT-3MFW9-KDQW3-TCK7R` |
| Word 2013 [Preview] | `JBGD4-3JNG7-JWWGV-CR6TP-DC62Q` |
| Word 2013 | `6Q7VD-NX8JD-WJ2VH-88V73-4GBJ7` |
| Mondo 2013 [Preview] | `GCGCN-6FJRM-TR9Q3-BGMWJ-78KQV` |
| Mondo 2013 | `42QTK-RN8M7-J3C4G-BBGYM-88CYV` |
| Mondo 2013 Retail | `?????-?????-?????-?????-?????` |
| SharePoint Workspace (Groove) 2013 [Preview] | `WVCGG-NK4FG-7XKXM-BD4WF-3C624` |
| SharePoint Workspace (Groove) 2013 | `H7R7V-WPNXQ-WCYYC-76BGV-VT7GH` |
| SharePoint Designer (Frontpage) 2013 Retail [Preview] | `?????-?????-?????-?????-?????` |
| SharePoint Designer (Frontpage) 2013 Retail | `GYJRG-NMYMF-VGBM4-T3QD4-842DW` |
		
### Office 2010

| Product | GVLK |
| --- | --- |
| Professional Plus 2010 | `VYBBJ-TRJPB-QFQRF-QFT4D-H3GVB` |
| Standard 2010 | `V7QKV-4XVVR-XYV4D-F7DFM-8R6BM` |
| Project Professional 2010 | `YGX6F-PGV49-PGW3J-9BTGG-VHKC6` |
| Project Standard 2010 | `4HP3K-88W3F-W2K3D-6677X-F9PGB` |
| Visio Professional 2010 | `7MCW8-VRQVK-G677T-PDJCM-Q8TCP` |
| Visio Standard 2010 | `767HD-QGMWX-8QTDB-9G3R2-KHFGJ` |
| Visio Premium 2010 | `D9DWC-HPYVV-JGF4P-BTWQB-WX8BJ` |
| Access 2010 | `V7Y44-9T38C-R2VJK-666HK-T7DDX` |
| Excel 2010 | `H62QG-HXVKF-PP4HP-66KMR-CW9BM` |
| OneNote 2010 | `Q4Y4M-RHWJM-PY37F-MTKWH-D3XHX` |
| Outlook 2010 | `7YDC2-CWM8M-RRTJC-8MDVC-X3DWQ` |
| PowerPoint 2010 | `RC8FX-88JRY-3PF7C-X8P67-P4VTT` |
| Publisher 2010 | `BFK7F-9MYHM-V68C7-DRQ66-83YTP` |
| InfoPath 2010 | `K96W8-67RPQ-62T9Y-J8FQJ-BT37T` |
| SharePoint Workspace (Groove) 2010 | `QYYW6-QP4CB-MBV6G-HYMCJ-4T3J4` |
| Word 2010 | `HVHB3-C6FV7-KQX9W-YQG79-CRY7T` |
| Small Business Basics 2010 | `D6QFG-VBYP2-XQHM7-J97RH-VVRCK` |
| Starter 2010 Retail | `VXHHB-W7HBD-7M342-RJ7P8-CHBD6` |
| SharePoint Designer (Frontpage) 2010 Retail | `H48K6-FB4Y6-P83GH-9J7XG-HDKKX` |
| Office Mondo 1 2010 | `YBJTT-JG6MD-V9Q7P-DBKXJ-38W9R` |
| Office Mondo 2 2010 | `7TC2V-WXF6P-TD7RT-BQRXR-B8K32` |
