# TGScraper

[![License](http://poser.pugx.org/sysbot/tgscraper/license)](https://packagist.org/packages/sysbot/tgscraper)
![Required PHP Version](https://img.shields.io/badge/php-%E2%89%A58.0-brightgreen)
[![Latest Stable Version](http://poser.pugx.org/sysbot/tgscraper/v)](https://packagist.org/packages/sysbot/tgscraper)
[![Dependencies](https://img.shields.io/librariesio/github/Sysbot-org/tgscraper)](https://libraries.io/github/Sysbot-org/tgscraper)
[![Code Quality](https://img.shields.io/scrutinizer/quality/g/Sysbot-org/tgscraper)](https://scrutinizer-ci.com/g/Sysbot-org/tgscraper/?branch=master)

A PHP library used to extract JSON data (and auto-generate PHP classes)
from [Telegram bot API documentation page](https://core.telegram.org/bots/api).

## Changelog

Interested in recent changes? Have a look [here](CHANGELOG.md)!


## Installation

Install the library with composer:

```bash 
  $ composer require sysbot/tgscraper --prefer-stable
```

(Optional) Install the cache package:

```bash 
  $ composer require sysbot/tgscraper-cache
```

## Using from command line

Once installed, you can use the CLI to interact with the library.

For basic help and command list:

```bash 
  $ vendor/bin/tgscraper help
```

### JSON

Extract the latest schema in a human-readable JSON:

```bash 
  $ vendor/bin/tgscraper app:export-schema --readable botapi.json
```

Or, if you want a Postman-compatible JSON (thanks to [davtur19](https://github.com/davtur19/TuriBotGen/blob/master/postman.php)):

```bash 
  $ vendor/bin/tgscraper app:export-schema --postman botapi_postman.json
```

### YAML

Extract the latest schema in YAML format:

```bash 
  $ vendor/bin/tgscraper app:export-schema --yaml botapi.yaml
```

### OpenAPI

Extract the latest OpenAPI schema in JSON format:

```bash 
  $ vendor/bin/tgscraper app:export-schema --openapi botapi_openapi.json
```

Or, if you prefer YAML:

```bash 
  $ vendor/bin/tgscraper app:export-schema --openapi --yaml botapi_openapi.yaml
```

### Stubs

_Note: since Telegram may change the page format at any time, do **NOT** rely on the automagically generated
stubs from this library, **ALWAYS** review the code!_

TGScraper can also generate class stubs that you can use in your library. A sample implementation is available in the [Sysbot Telegram module](https://github.com/Sysbot-org/Sysbot-tg).

Create stubs in the `out/` directory using `Sysbot\Telegram` as namespace prefix:

```bash 
  $ vendor/bin/tgscraper app:create-stubs --namespace-prefix "Sysbot\Telegram" out
```

### All versions

If you want to generate all schemas and stubs for every Bot API version, you can!

Here's an example on how to export everything to the `out/` directory, with schemas in human-readable format and using `Sysbot\Telegram` as namespace prefix for the stubs:

```bash 
  $ vendor/bin/tgscraper app:dump-schemas -r --namespace-prefix "Sysbot\Telegram" out
```

## Custom format

If you're interested in the custom format generated by TGScraper, you can find its schema [here](docs/schema.json).