// TestHelpers.swift - Copyright 2024 SwifterSwift

enum Season: String {
    case summer
    case autumn
    case winter
    case spring
}

/**
 These structs used to test ArrayExtensions and RangeReplaceableCollection.
 Feel free to use it for your needs.
 */
struct SimplePerson: Equatable {
    let forename, surname: String
    let age: Int
}

struct Person: Equatable {
    var name: String
    var age: Int?
    var location: Location?
    var isStudent: Bool

    init(name: String, age: Int?, location: Location? = nil, isStudent: Bool = false) {
        self.name = name
        self.age = age
        self.location = location
        self.isStudent = isStudent
    }
}

struct Location: Equatable {
    let city: String
}

struct TestStruct: ExpressibleByIntegerLiteral, Equatable {
    var testField: Int = 0
    typealias IntegerLiteralType = Int

    init(integerLiteral value: Int) {
        testField = value
    }
}
