/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pooling;

import java.util.concurrent.atomic.AtomicReference;
import oracle.jdbc.pooling.PoolIterator;

final class PoolIteratorQueue<T> {
    private final AtomicReference<Element> listHead = new AtomicReference<Element>(new Element(null));
    private final AtomicReference<Element> listTail = new AtomicReference<Element>(this.listHead.get());

    PoolIteratorQueue() {
    }

    void enqueue(PoolIterator<T> poolIterator) {
        this.skipToFirstActive();
        if (poolIterator == null) {
            throw new IllegalArgumentException("poolIterator is null");
        }
        Element element = new Element(poolIterator);
        Element element2 = this.listTail.get();
        while (true) {
            if (element2.next.compareAndSet(null, element)) {
                this.listTail.set(element);
                return;
            }
            element2 = element2.next.get();
        }
    }

    boolean peek(PoolIterator<T> poolIterator) {
        if (poolIterator == null) {
            throw new IllegalArgumentException("poolIterator is null");
        }
        Element element = this.skipToFirstActive();
        PoolIterator poolIterator2 = element.poolIterator.get();
        if (null == poolIterator2) {
            return true;
        }
        return poolIterator == poolIterator2;
    }

    boolean disable(PoolIterator<T> poolIterator) {
        if (poolIterator == null) {
            throw new IllegalArgumentException("poolIterator is null");
        }
        Element element = this.skipToFirstActive();
        return element.poolIterator.compareAndSet(poolIterator, null);
    }

    private Element skipToFirstActive() {
        Element element;
        PoolIterator poolIterator;
        Element element2 = this.listHead.get();
        while (true) {
            if ((poolIterator = element2.poolIterator.get()) != null) {
                if (poolIterator.isAlive()) break;
                element2.poolIterator.set(null);
            }
            if ((element = element2.next.get()) == null) break;
            element2 = element;
        }
        this.listHead.set(element2);
        while (((poolIterator = element2.poolIterator.get()) == null || poolIterator.isSleeping()) && (element = element2.next.get()) != null) {
            element2 = element;
        }
        return element2;
    }

    private final class Element {
        final AtomicReference<PoolIterator<T>> poolIterator;
        final AtomicReference<Element> next = new AtomicReference<Object>(null);

        Element(PoolIterator<T> poolIterator) {
            this.poolIterator = new AtomicReference(poolIterator);
        }
    }
}

