/* bkerndev - Bran's Kernel Development Tutorial
*  By:   Brandon F. (friesenb@gmail.com)
*  Desc: Interrupt Descriptor Table management
*
*  Notes: No warranty expressed or implied. Use at own risk.

   Strayex Kernel Interrupt Descriptor Table
   THIS IS NOT MY CODE!
   This file was a little rewritten only, by me,
   this is why I included above copyright header.
   I'm not a copyright holder.
*/

#include "klib/kdt.h"
#include "klib/kstring.h"

// Defines an IDT entry:
struct idt_entry
{
    unsigned short base_lo;
    unsigned short sel;        // Our kernel segment goes here!
    unsigned char always0;     // This will ALWAYS be set to 0!
    unsigned char flags;       // Set using the above table!
    unsigned short base_hi;
} __attribute__((packed));

struct idt_ptr
{
    unsigned short limit;
    unsigned int base;
} __attribute__((packed));

/*
Declare an IDT of 256 entries. Although we will only use the
first 32 entries in this tutorial, the rest exists as a bit
of a trap. If any undefined IDT entry is hit, it normally
will cause an "Unhandled Interrupt" exception. Any descriptor
for which the 'presence' bit is cleared (0) will generate an
"Unhandled Interrupt" exception
*/
struct idt_entry idt[256];
struct idt_ptr idtp;

// This exists in "idt_asm.asm", and is used to load our IDT:
extern void idt_load();

/*
Use this function to set an entry in the IDT.
A lot simpler than twiddling with the GDT ;)
*/
void idt_set_gate(unsigned char num, unsigned long base, unsigned short sel, unsigned char flags)
{
	// The interrupt routine's base address:
    idt[num].base_lo = (base & 0xFFFF);
    idt[num].base_hi = (base >> 16) & 0xFFFF;
	
	/*
	The segment or 'selector' that this IDT entry will use
    is set here, along with any access flags
	*/
    idt[num].sel = sel;
    idt[num].always0 = 0;
    idt[num].flags = flags;
}

// Installs the IDT:
void idt_init()
{
    // Sets the special IDT pointer up, just like in "gdt_c.c":
    idtp.limit = (sizeof (struct idt_entry) * 256) - 1;
    idtp.base = (unsigned int)&idt;

    // Clear out the entire IDT, initializing it to zeros:
    memset((unsigned char *)&idt, 0, sizeof(struct idt_entry) * 256);

    // Add any new ISRs to the IDT here using idt_set_gate!

    // Points the processor's internal register to the new IDT:
    idt_load();
}
