LocalizationReady("shared", "english", {
  language: "english",

  Button_About: "About",
  Button_Append: "Append",
  Button_Cancel: "Cancel",
  Button_Close: "Close",
  Button_Clone: "Clone",
  Button_Confirm: "Confirm",
  Button_Copy: "Copy",
  Button_CopyClipboard: "Copy to Clipboard",
  Button_CopyLink: "Copy Link",
  Button_Continue: "Continue",
  Button_Create: "Create",
  Button_Delete: "Delete",
  Button_Discuss: "Discuss",
  Button_Dismiss: "Dismiss",
  Button_Edit: "Edit",
  Button_Learn: "Learn more here",
  Button_Publish: "Publish",
  Button_Post: "Post",
  Button_OK: "OK",
  Button_Done: "Done",
  Button_Overwrite: "Overwrite",
  Button_Retry: "Retry",
  Button_Remove: "Remove",
  Button_Revert: "Revert",
  Button_Save: "Save",
  Button_Saved: "Saved",
  Button_Share: "Share",
  Button_Update: "Update",
  Button_SaveAndContinue: "Save and Continue",
  Button_Follow: "Follow",
  Button_Followed: "Followed",
  Button_Ignore: "Ignore",
  Button_Ignored: "Ignored",
  Button_NotifyMe: "Notify Me",
  Button_NotInterested: "Not Interested",
  Button_Preview: "Preview",
  Button_RateUp: "Rate Up",
  Button_ViewPage: "View Page",
  Button_Accept: "Accept",
  Button_Reject: "Reject",
  Button_Go: "Go",

  StoreLink_Label: "Store",
  CommunityLink_Label: "Community",
  SupportLink_Label: "Support",

  Error_Generic: "Error",
  Error_Generic_Label: "Error:",

  Dialog_DontShowMeAgain: "Don't show this message again",
  Dialog_AreYouSure: "Are you sure?",

  ToolTip_CopyLinkToClipboard: "Copy link to clipboard",

  Input_Error_NumberTooSmall: "Number too small.",
  Input_Error_NumberTooLarge: "Number too large.",
  Input_Error_MustBeURL: "Field is not a valid URL.",
  Input_Error_MustBeEmail: "Field is not a valid Email.",
  Input_Error_MustBeNumber: "Field must be a number.",

  Loading: "Loading...",
  Updating: "Updating...",
  Uploading: "Uploading...",
  Saving: "Saving...",
  Sending: "Sending...",
  Deleting: "Deleting...",

  Settings: "Settings",
  ViewDocumentation: "View Documentation",
  FriendSettings_AlwaysNewChatWindow:
    "Always open a new chat window rather than a tab",

  g_DisabledOnWeb: "Unavailable in web version",

  VoiceTransmissionType_Disabled: "Open Microphone only for web version",

  VoiceVolume: "Volume",
  VoiceSetupHeader: "Voice Setup And Testing",
  VoiceStartLocalMicTest: "Start Microphone Test",
  VoiceStopLocalMicTest: "End Microphone Test",
  VoiceWhenMicIsWorking:
    "If your microphone is working then you should both hear yourself and see the colored bar next to your avatar move as you speak.",
  VoiceDevice: "Voice Input Device",
  VoiceOutputDevice: "Voice Output Device",
  VoiceInputGain: "Input volume/gain",
  VoiceInputGainExplainer: "(My microphone)",
  VoiceOutputGain: "Output volume/gain",
  VoiceOutputGainExplainer: "(My friends)",
  VoiceTransmissionType: "Push-to-talk",
  VoiceTransmissionType_Label: "Voice Transmission Type",
  VoiceTransmissionType_OpenMic: "Open Microphone",
  VoiceTransmissionType_PushToTalk: "Push-to-Talk",
  VoiceTransmissionType_PushToMute: "Push-to-Mute",
  VoiceClearHotKeyTooltip: "Clear mute toggle hotkey assignment",
  VoiceTransmissionTypeExplainer:
    "Push a user defined key to talk in voice channels",
  VoiceTransmissionType_WhenSpeaking: "Automatic",
  VoiceTransmissionType_PushToTalk_Key: "Push-to-Talk: %1$s",
  VoicePushToTalkPressHotKey: "Press key or mouse-button to assign",
  VoicePushToTalkAssigned: "Push-to-talk hotkey assigned as",
  VoicePushToMuteAssigned: "Push-to-mute hotkey assigned as",
  VoiceMuteToggleAssigned: "Mute toggle hotkey assigned as",
  VoicePushToSomethingSoundOption: "Play a short sound on microphone toggle",
  VoiceTransmisionThreshold: "Voice Transmission Threshold",
  VoiceTransmissionThresholdExplainer:
    "When your microphone is on, we won't transmit noise below this threshold:",
  VoiceTransmissionThresholdOff: "Off",
  VoiceTransmissionThresholdMedium: "Medium",
  VoiceTransmissionThresholdHigh: "High",
  VoiceTransmissionThresholdRecommended: "Recommended",
  VoiceAdvancedSettings: "Advanced Settings",
  VoiceShowAdvancedSettings: "Show Advanced Settings",
  VoiceHideAdvancedSettings: "Hide Advanced Settings",
  VoiceAdvancedSettingsExplainer:
    "(These are microphone settings handled by your platform or browser.)",
  VoiceEchoCancellation: "Echo cancellation",
  VoiceNoiseCancellation: "Noise cancellation",
  VoiceAutoGainControl: "Automatic volume/gain control",
  DefaultMic: "Default",
  "MicLoading...": "Loading...",
  DefaultOutputDevice: "Default",
  "OutputDeviceLoading...": "Loading...",

  BreadCrumbs_AllEvents: "All Events",
  BreadCrumbs_GameEvents: "%1$s Events",

  CreatorHome_ThisGame: "About This Game:",
  CreatorHome_DevelopedBy: "Developed By:",
  CreatorHome_PublishedBy: "Published By:",
  CreatorHome_InFranchise: "In Franchise:",
  CreatorHome_Followers: "%1$s<br>followers",
  CreatorHome_JustFollowers: "followers",
  CreatorHome_Follow_tooltip:
    "Follow this creator to to be notified via e-mail and in your Steam store when they release a new game. Email notifications can be turned off at any time.",

  EventBrowse_MoreEventsTitle: "More events from %1$s",
  EventBrowse_MoreEventsBtn: "View All",
  EventBrowse_ViewLatestUpdate: "View",
  EventBrowse_LatestUpdateTime_Button: "See all updates (Latest: %1$s)",
  EventBrowse_RecentUpdates: "Recent Updates",
  EventBrowse_RecentEvents: "Recent Events & Announcements",
  EventBrowse_LastUpdateDate: "Last Update: %1$s",

  EventCurator_BrowseDialog_Title: "News from Steam curators",
  EventCurator_BrowseDialog_Desc:
    "Follow your favorite Steam Curators to get gaming news right in your Steam News Hub!",
  EventCurator_BrowseDialog_LangCurator: "%1$s Steam curators",
  EventCurator_NoEventsFound_Title: "No Postings Found",
  EventCurator_NoEventsFound_Body: "No postings were found for this curator",
  EventCurator_BrowseMore: "Browse More Sources",
  EventCurator_FeedCaption_Long:
    "Follow some of these Steam Curators to get gaming news right in your Steam News Hub!",
  EventCurator_DismissTitle: "Hide news suggestions",
  EventCurator_DismissBody:
    "This will hide news suggestions for this device. You can still find news by going to the Steam Curators tab in the news hub",

  EventCalendar_Title: "Steam%1$sNews Hub",
  EventCalendar_TabTitle_Global: "Steam News Hub",
  EventCalendar_TabTitle_GroupHub: "%1$s - Steam News Hub",
  EventCalendar_TabTitle_GroupNameAndEventDetail: "%1$s - %2$s - Steam News",
  EventCalendar_FilterSubSection_EventTypeGroups: "Show these types of posts",
  EventCalendar_FilterSubSection_GameSources: "Show posts from these sources",
  EventCalendar_FilterSubSection_CuratorSources: "Show posts from curators",
  EventCalendar_BrowseCurators: "Browse Curators",
  EventCalendar_EmptyCalendar:
    "No posts found. Try selecting different search criteria in the sidebar.",
  EventCalendar_DisabledFilter_LoginPrompt:
    "Sign in to enable these categories",
  EventCalendar_MainLoginPrompt: "Sign in to see your personal News Hub",
  EventCalendar_NoFutureEvents: "No upcoming events found",
  EventCalendar_NoPastEvents: "No older posts found",
  EventCalendar_NoMoreFutureEvents: "No more upcoming events found",
  EventCalendar_NoMorePastEvents: "No more older posts found",
  EventCalendar_UpdatesViewHeader: "Recent Updates",
  EventCalendar_NoPastUpdates: "No updates found",
  EventCalendar_NoMorePastUpdates: "No more updates found",
  EventCalendar_ResetFiltersButton: "See all posts",
  EventCalendar_ResetFilters_ttip: "Resets your filters to the default values",
  EventCalendar_GameSearch: "Games Search",
  EventCalendar_UniversalSearch: "Search",
  EventCalendar_GameSearch_NoneFound: "No Matches Found",
  EventCalendar_SearchResultsHeader_GameSection: "Games",
  EventCalendar_SearchResultsHeader_GameAndDLCSection: "Games and DLC",
  EventCalendar_SearchResultsHeader_CuratorSection: "Curators",
  EventCalendar_FollowingCurator: "following",
  EventCalendar_GroupTitle_Curators: "From Curators You Follow",
  EventCalendar_GroupTitle_FeaturedCurators: "Stories From Featured Curators",
  EventCalendar_NewsLanguage_Title:
    "Showing available news sources in your languages",
  EventCalendar_NewsLanguage_Text:
    "Update your language preferences to allow content and sources in more languages by visiting your %1$s",
  EventCalendar_NewsLanguage_TextInHyperlink: "store language preferences",
  EventCalendar_TimeEventLastPlayed: "Last Played %1$s",
  EventCalendar_TimeEventWishlisted: "Wishlisted %1$s",

  EventCalendar_GlobalCalendar_Action: "Return to News Hub",
  EventCalendar_SpecificCalendar: "%1$s %2$s News Hub",
  EventCalendar_Goto_SpecificCalendar: "Go to %1$s News Hub",
  EventCalendar_Goto_RSSFeed: "Open %1$s RSS Feed",
  EventCalendar_SingleAppIsMuted:
    "Note: This game is muted and will not show up in your personalized news hub.",
  EventCalendar_SingleGroupIsMuted:
    "Note: This group is muted and will not show up in your personalized news hub.",
  EventCalendar_WatchYouTubeVideo: "Watch YouTube Video",
  EventCalendar_WatchLiveBroadcast: "Watch Live Broadcast",

  EventModTile_Moderator: "Moderator: %1$s",
  EventModTile_EventCreator: "Original Poster: %1$s",
  EventModTile_EventLastUpdator: "Last Updater: %1$s",
  EventModTile_Signer: "Authority: %1$s",
  EventModTile_Action_Reviewed: "%1$s %2$s marked reviewed",
  EventModTile_Action_ReReviewed: "%1$s %2$s marked Re-Reviewed",
  EventModTile_Action_UnReviewed: "%1$s %2$s cleared reviewed flag",
  EventModTile_Action_NewEventType: "%1$s %2$s changed to category %3$s",
  EventModTile_Action_SeasonTagUpdate: "%1$s %2$s updated seasonal tag %3$s",
  EventModTile_Action_RemoveFromSC: "%1$s %2$s removed event from Steam China",
  EventModTile_Action_FlagAdultContent: "%1$s %2$s flagged as adult content",
  EventModTile_Action_RemoveAdultContent:
    "%1$s %2$s removed adult content flag",
  EventModTile_Action_Title: "Moderation History",
  EventModTile_Action_More: "Show %1$s older action(s)",
  EventModTile_Action_Hide: "Hide actions",

  SteamLabs: "Steam Labs",
  SteamLabs_ExperimentNumber: "Experiment %1$s",
  SteamLabs_DiscussionLink: "Discuss this experiment",

  EventCalendar_SignIn_Title: "Sign In To Get Personalized News",
  EventCalendar_SignIn_Text:
    "Sign in with your Steam account to access your personalized news hub or explore featured news and updates below.",
  EventCalendar_FutureEventsHint: "Scroll up to see what's coming next",
  EventCalendar_FutureEventsLink: "See all upcoming",
  EventCalendar_LoadEventsProgress: "Loaded %1$s events through %2$s",
  EventCalendar_LoadEventsFilters:
    "You can adjust your options and filters to see more events on this page",
  EventCalendar_FutureEventsHeader: "Coming soon",
  EventCalendar_PastEventsLink: "See earlier posts",
  EventCalendar_LiveAndRecentEventsHeader: "Live and recent",
  EventCalendar_TuneIn: "Tune In",
  EventCalendar_LiveNow: "Live now",
  EventCalendar_TimeLeft: "Ends in %1$s",
  EventCalendar_PostedAtTime: "Posted %1$s",
  EventCalendar_StartedAtTime: "Started %1$s",
  EventCalendar_Upcoming: "upcoming",
  EventCalendar_WillStartAtTime: "Starting %1$s",
  EventCalendar_WillStartAfterDuration: "Starting in %1$s",
  EventCalendar_WillStartAtDateTime: "%1$s at %2$s",
  EventCalendar_LaterToday: "later today",
  EventCalendar_Tomorrow: "tomorrow",
  EventCalendar_NextWeek: "next week",
  EventCalendar_LaterThisMonth: "later this month",
  EventCalendar_MuchLater: "much later",
  EventCalendar_MuteApp: "Mute App",
  EventCalendar_MuteApp_Title: "Mute %1$s",
  EventCalendar_Ignore: "Ignore",
  EventCalendar_IgnoreApp: "Ignore %1$s",
  EventCalendar_IgnoreApp_ttip:
    "Ignored titles will not be recommended to you and will not appear in featured areas.",
  EventCalendar_IgnoreApp_newhub:
    "The News Hub will apply your ignore settings and prevent games ignored on the store from appearing your news hub. You can manage ignored games here:",
  EventCalendar_FollowCurator: "Follow Steam Curator: %1$s",
  EventCalendar_FollowCurator_ttip:
    "By following this curator, their articles will appear in your personalized News hub and their game recommendations will appear on your Steam store.",
  EventCalendar_UnFollowCurator: "Unfollow Steam Curator: %1$s",
  EventCalendar_UnFollowCurator_ttip:
    "You currently follow this curator. By unfollowing, their articles will no longer appear on your personalized News hub and their recommendations will not appear on your Steam store.",
  EventCalendar_UnignoreApp: "Unignore %1$s",
  EventCalendar_UnMuteApp_Title: "Unmute %1$s",
  EventCalendar_MuteApp_ttip:
    "Removes this game from your News Hub and block future communications.",
  EventCalendar_UnMuteApp_ttip:
    "Restore this game to your News Hub and unblock future communications.",
  EventCalendar_MuteApp_details:
    "Remove this content from appearing in your News Hub and block all future communications. Muted content decisions are always reversible by visiting this page: ",
  EventCalendar_ManageMutedApps: "Manage Muted Apps",
  EventCalendar_ManageMutedSources: "Manage Muted Sources",
  EventCalendar_ManageStorePref: "Manage Store Preferences",
  EventCalendar_MuteApp_Unknown: "Unknown",
  EVentCalendar_Hide_EventType: "Hide all '%1$s' type posts",
  EventCalender_LastPlayed: "Last played %1$s",
  EventCalender_Reason_recent: "This game has been played recently",
  EventCalender_Reason_library: "This game is in your library",
  EventCalender_Reason_following: "You are following this game",
  EventCalender_Reason_wishlist: "This game is in your wishlist",
  EventCalender_Reason_recommended: "This game is recommended for you",
  EventCalender_Reason_steam: "This post is from the Steam Platform",
  EventCalender_Reason_topx: "Game is in the Top Sellers",
  EventCalender_Reason_featured: "This is a featured post",
  EventCalender_Reason_curator: "You are following this curator",
  EventCalender_Hide_Reason_recent: "Hide posts from recently played games",
  EventCalender_Hide_Reason_library: "Hide posts from games in your library",
  EventCalender_Hide_Reason_following:
    "Hide posts from games you are following",
  EventCalender_Hide_Reason_wishlist: "Hide posts from games in your wishlist",
  EventCalender_Hide_Reason_recommended:
    "Hide posts from games recommended for you",
  EventCalender_Hide_Reason_steam: "Hide posts from the Steam Platform",
  EventCalender_Hide_Reason_topx: "Hide posts from the Top Sellers",
  EventCalender_Hide_Reason_featured: "Hide featured posts",
  EventCalender_Hide_Reason_curator: "Hide curator posts",

  EventCalendar_ForceDesktopView: "Request desktop view",
  EventCalendar_ShowResponsiveView: "Request responsive view",

  EventCalendar_EventTypeGroup_news: "News",
  EventCalendar_EventTypeGroup_ttip_news:
    "Includes general news, dev blogs, and announcements",
  EventCalendar_EventTypeGroup_events: "Events",
  EventCalendar_EventTypeGroup_ttip_events:
    "Includes in-game, online/chat, and real-world events",
  EventCalendar_EventTypeGroup_streaming: "Live-Streams",
  EventCalendar_EventTypeGroup_ttip_streaming:
    "Includes developer live-streams such as tournaments and play-alongs",
  EventCalendar_EventTypeGroup_updates: "Content Updates",
  EventCalendar_EventTypeGroup_ttip_updates:
    "Includes news about new game content, expansions, DLC, and bug fixes",
  EventCalendar_EventTypeGroup_releases: "Releases",
  EventCalendar_EventTypeGroup_ttip_releases:
    "Includes new game, beta, season, or DLC release schedules.",
  EventCalendar_EventTypeGroup_sales: "Sales",
  EventCalendar_EventTypeGroup_ttip_sales:
    "Includes discounts, promotions, and free trials",

  EventCalendar_GameSource_recent: "Recently Played",
  EventCalendar_GameSource_ttip_recent:
    "Include posts about games you have played or purchased in the past six months",
  EventCalendar_GameSource_EventExplanation_ttip_recent:
    "You have played this game in the past six months",
  EventCalendar_GameSource_library: "Library",
  EventCalendar_GameSource_inLibrary: "In Library",
  EventCalendar_GameSource_ttip_library:
    "Include posts about games in your library",
  EventCalendar_GameSource_EventExplanation_ttip_library:
    "This game is in your library",
  EventCalendar_GameSource_wishlist: "wishlist",
  EventCalendar_GameSource_onWishlist: "On Wishlist",
  EventCalendar_GameSource_ttip_wishlist:
    "Include posts about games on your wishlist",
  EventCalendar_GameSource_EventExplanation_ttip_wishlist:
    "This game is on your wishlist",
  EventCalendar_GameSource_following: "following",
  EventCalendar_GameSource_followed: "Followed",
  EventCalendar_GameSource_ttip_following:
    "Include posts about games that you follow",
  EventCalendar_GameSource_EventExplanation_ttip_following:
    "This is a game that you follow",
  EventCalendar_GameSource_recommended: "recommended",
  EventCalendar_GameSource_recommended_Verbose: "Recommended Game",
  EventCalendar_GameSource_ttip_recommended:
    "Include posts about games we think you would like",
  EventCalendar_GameSource_EventExplanation_ttip_recommended:
    "This is a game we think you would like",
  EventCalendar_GameSource_steam: "steam",
  EventCalendar_GameSource_ttip_steam: "Include posts about the Steam platform",
  EventCalendar_GameSource_EventExplanation_ttip_steam:
    "This is a post about Steam",
  EventCalendar_GameSource_topx: "Top Sellers",
  EventCalendar_GameSource_ttip_topx:
    "Include posts about games from the regional top sellers lists",
  EventCalendar_GameSource_featured: "Featured",
  EventCalendar_GameSource_ttip_featured:
    "Include featured posts, such as those from top selling games",
  EventCalendar_GameSource_curator: "Curators You Follow",
  EventCalendar_GameSource_ttip_curator:
    "Includes posts from curators you follow on Steam",
  EventCalendar_GameSource_UnhideCuratorsDialog_Title: "Show Curators?",
  EventCalendar_GameSource_UnhideCuratorsDialog_Description:
    "You just followed a Steam Curator. Would you like to include news from Curators in your personalized News Hub?",
  EventCalendar_GameSource_UnhideCuratorsDialog_OKButton: "Yes",
  EventCalendar_GameSource_UnhideCuratorsDialog_CancelButton: "No",

  EventCalendar_EditFilters: "Options and Filters",
  EventCalendar_CloseFilters: "News Hub",
  EventCalendar_FiltersTitle: "Filters",
  EventCalendar_FiltersDescription:
    "Manage the types and sources of news that you see in your News Hub",
  EventCalendar_FiltersDescription_NonPersonalized:
    "Manage event types that you see on this page",
  EventCalendar_NewsChannels: "Your News & Events",
  EventCalendar_NewsChannels_Global: "Global News & Events",
  EventCalendar_NewsChannels_Discover: "Discover",
  EventCalendar_NewsChannel_YourNews: "Your News",
  EventCalendar_NewsChannel_YourNews_HeaderTitle: "Your Personalized Game News",
  EventCalendar_NewsChannel_Upcoming: "Your Upcoming Events",
  EventCalendar_NewsChannel_UpcomingShort: "Upcoming",
  EventCalendar_NewsChannel_Featured: "Featured",
  EventCalendar_NewsChannel_Featured_HeaderTitle: "Featured News",
  EventCalendar_NewsChannel_Personalized: "Personalized",
  EventCalendar_NewsChannel_Filtered: "Filtered",
  EventCalendar_NewsChannel_AllGames: "From all games",
  EventCalendar_NewsChannel_TopSellers: "From Top sources",
  EventCalendar_NewsChannel_Press: "News Curators",
  EventCalendar_Collection_News_Title: "Discover News Curators",
  EventCalendar_Collection_News_Subtitle:
    "Catch the latest in gaming news from top gaming news sources. Follow a Steam News Curator to add their news and game recommendations to your Steam News Hub.",
  EventCalendar_NewsChannel_Steam: "Steam Official",
  EventCalendar_NewsChannel_SteamSubtitle: "Steam Blog and News",
  EventCalendar_NewsChannel_Steam_HeaderTitle: "Official Steam News",
  EventCalendar_NewsChannel_All: "All News",
  EventCalendar_NewsChannel_AllSales: "All Sales Events",
  EventCalendar_NewsChannel_AssociatedPress: "Press Events Linked to Apps",
  EventCalendar_NewsChannel_Halloween: "Halloween Events",
  EventCalendar_NewsChannel_HalloweenSubtitle: "Beware: Spooky",
  EventCalendar_Collection_Halloween_Title: "Halloween Events",
  EventCalendar_Collection_Halloween_Subtitle:
    "Browse spooky Halloween related news and events from games on Steam",

  EventDisplay_Admin_Title: "Admin tools:",
  EventDisplay_ViewInLibrary: "View in Library",
  EventDisplay_ViewStorePage: "View Store Page",
  EventDisplay_RSSFeed: "RSS Feed",
  EventDisplay_RSSFeed_ExtraShort: "RSS",
  EventDisplay_ViewCommunityPage: "View Community Page",
  EventDisplay_ViewForum: "View Discussion Forum",
  EventDisplay_ViewRssFeed: "View RSS Feed",
  EventDisplay_ViewInLibrary_ExtraShort: "Library",
  EventDisplay_ViewStorePage_ExtraShort: "Store",
  EventDisplay_ViewCommunityPage_ExtraShort: "Community",
  EventDisplay_ViewForum_ExtraShort: "Forum",
  EventDisplay_ViewRssFeed_ExtraShort: "RSS",
  EventDisplay_Admin: "Admin Dashboard",
  EventDisplay_Admin_ExtraShort: "Admin",

  EventDisplay_NewsHubSubtitle: "News Hub",

  EventDisplay_CallToAction_LearnMore: "Learn More",
  EventDisplay_CallToAction_InLibrary: "In Library",
  EventDisplay_CallToAction_PlayNow: "Play Now",
  EventDisplay_CallToAction_ComingSoon: "Coming Soon",
  EventDisplay_CallToAction_Prepurchase_Short: "Prepurchase",
  EventDisplay_CallToAction_ShowPurchaseOptions_Button: "Purchase Options",
  EventDisplay_CallToAction_FreeToPlay: "Free To Play",
  EventDisplay_CallToAction_PlayNowForFree: "Play for Free!",
  EventDisplay_CallToAction_VisitStore: "View Store Page",

  EventDisplay_Events: "Admin Dashboard",
  EventDisplay_SeeOldVersion: "View Current Customer Version",
  EventDisplay_SalesPage: "View Store Sales Page",
  EventDisplay_StatsPage: "(VO) Stats Page",
  EventDisplay_ViewOnStore: "View on Store",
  EventDisplay_ViewOnCommunity: "View on Community",

  EventDisplay_NoEventsToSee: "No events found",

  EventDisplay_RightColumnTitle_Game: "Game",
  EventDisplay_RightColumnTitle_Blog: "Blog",
  EventDisplay_RightColumnTitle_DateAndTime: "Date and Time",
  EventDisplay_RightColumnTitle_EventType: "Type",

  EventDisplay_PostedBy: "by ",

  EventDisplay_Reminder_SetReminder: "Set a reminder",
  EventDisplay_Reminder_GetNotification_Via: "Get a notification",
  EventDisplay_Reminder_ViaEmail: "via email",
  EventDisplay_Reminder_ViaMobileApp: "via mobile app",

  EventDisplay_Reminder_FollowEvent: "Follow Event",
  EventDisplay_Reminder_FollowEvent_ttip:
    "Follow an event to be notified when the event starts.",
  EventDisplay_Reminder_RemindAtStart: "When the event starts",
  EventDisplay_Reminder_RemindAtStart_ttip:
    "Steam will notify you at the time the event starts.",
  EventDisplay_Reminder_IgnoreEvent: "Ignore This Event",
  EventDisplay_Reminder_IgnoreStop: "Stop Reminders",
  EventDisplay_Reminder_IgnoreEvent_ttip:
    "Ignoring an event will tell Steam to exclude this event for future suggestion and recommendations.",
  EventDisplay_Reminder_FollowEvent_Error: "Follow Event Error",
  EventDisplay_Reminder_FollowEvent_ErrorDesc:
    "Changing the event follow state hit the following error:",
  EventDisplay_Reminder_IgnoreEvent_Error: "Ignore Event Error",
  EventDisplay_Reminder_IgnoreEvent_ErrorDesc:
    "Changing the event ignore state hit the following error:",
  EventDisplay_Reminder_Toast: "Steam Desktop Toast at Start",
  EventDisplay_Reminder_AddToCalendar: "Add to calendar",
  EventDisplay_Reminder_AddToApple: "Add to Apple Calendar",
  EventDisplay_Reminder_AppleCalendar_Short: "Apple",
  EventDisplay_Reminder_AddToGoogle: "Add to Google Calendar",
  EventDisplay_Reminder_GoogleCalendar_Short: "Google",
  EventDisplay_Reminder_AddToOutlook: "Add to Outlook Calendar",
  EventDisplay_Reminder_OutlookCalendar_Short: "Outlook",
  EventDisplay_Reminder_AddToYahoo: "Add to Yahoo Calendar",
  EventDisplay_Reminder_Preferences: "Edit Reminder Preferences...",

  EventDisplay_TimeDisplay: "From %1$s to %2$s",
  EventDisplay_TimeDisplayNone: "No Date and Time Information",
  EventDisplay_TimeBeginsOn: "Upcoming Event Starts",
  EventDisplay_TimeBeginsOn_Past: "Started",
  EventDisplay_TimeBeginsOn_StartAndEnd_Past: "Past Event Started",
  EventDisplay_TimeEndsOn: "Ends",
  EventDisplay_TimeEndsOn_Past: "Ended",
  EventDisplay_RunsForDuration: "Runs %1$s",
  EventDisplay_TimeLeft: "Ends in %1$s",
  EventDisplay_TimeEndsOn_Ran: "Ran",
  EventDisplay_TimeRange: "Event Time",
  EventDisplay_TimeInPast: "Posted",
  EventDisplay_TimeUpcoming: "Event Starts",
  EventDisplay_EventUpcoming_WithDateAndTime: "Event starts %1$s at %2$s",
  EventDisplay_TimeEventActive: "Event is running now",
  EventDisplay_TimeEventOnNow: "On now!",

  EventDisplay_Share_Link: "Link: ",
  EventDisplay_Share_OnMyStatus: "Share directly to my status",
  EventDisplay_Share_OnMyStatus_Details:
    "Post this status to your Friends Activity feed. Steam will include the message and item preview shown below.",
  EventDisplay_Share_OnMyStatus_Placeholder:
    "Say something about this to your friends...",
  EventDisplay_Share_OnSteam: "Share on Steam Community as a status update",
  EventDisplay_Share_OnFaceBook: "Share on Facebook",
  EventDisplay_Share_OnTwitter: "Share on Twitter",
  EventDisplay_Share_OnReddit: "Share on Reddit",
  EventDisplay_Share_Success: "Success!",
  EventDisplay_Share_Failure: "Failed with following message: ",
  EventDisplay_Share_Announcement: "%1$s Announcement",
  EventDisplay_Share_Event: "%1$s Event",
  EventDisplay_Share_NotLoggedIn: "Not signed in",
  EventDisplay_Share_NotLoggedIn_Description:
    "To use this feature, you first need to sign into Steam",
  EventDisplay_Share_CommentMigrationInProcess:
    "Discussion for this event are queued to be migrated to the events system. They are temporarily unaccessible. Please come back later.",
  EventDisplay_Share_OpenActivityFeed: "Open my activity feed",

  EventDisplay_AreYouSure:
    "Are you sure you want to delete this event (%1$s)? This action cannot be undone.",
  EventDisplay_AreYouSure_Visible:
    "Are you sure you want to delete this event (%1$s)? This action cannot be undone. This event will be removed from all places a user can discover it within a few minutes.",
  EventDisplay_DeleteEvent_InProgress: "Delete in progress. Please wait.",
  EventDisplay_DeleteEvent_Error:
    "There was an error processing the delete request:",
  EventDisplay_DeleteEvent_ForumTopicError:
    "The event was successfully deleted. We failed when attempting to delete the forum topic thread for the event. You can always try against in %1$s site. Error details:",
  EventDisplay_DeleteEvent_Success: "The event was successfully deleted.",
  EventDisplay_DeleteEvent_Comment:
    "Also delete the discussion forum comment thread for this event?",
  EventDisplay_SocialTitle: "More About This Game",
  EventDisplay_Sketchfab: "Sketchfab Model",
  EventDisplay_SketchFab_Error_Network: "Could not contact Sketchfab",

  EventEditor_Publish_VisibleNow: "Make Visible Now",
  EventEditor_Publish_VisibleNow_ttip:
    "This event will automatically become visible at the scheduled time. This button forces the event to become immediately visible.",

  EventEditor_Edit: "Edit Event",
  EventDisplay_DeleteEvent: "Delete Event",

  EventReminder_InProgress:
    "(note that notification options shown here are representative and not yet functional)",
  EventReminder_NotifyByEmail: "Notify me by Email",
  EventReminder_NotifyByEmail_ttip:
    "Steam will send an email notification to your account when the event starts.",
  EventReminder_NotifyByMobile: "Notify me on my Mobile device",
  EventReminder_NotifyByMobile_ttip:
    "Steam will push a notification when the event starts to all devices where you have installed and logged into the Steam mobile app.",
  EventReminder_NotifyByEmail_Missing:
    "Verify your email address to sign up for email reminders.",
  EventReminder_NotifyByEmail_Missing_Add: "Verify your email address.",
  EventReminder_NotifyByMobile_Missing:
    "Install one of the Steam apps to sign up for mobile reminders. ",
  EventReminder_NotifyByMobile_Install: "View available apps here.",

  EventEmail_Subject_NewUpdate: "%1$s, New Update",
  EventEmail_Subject_UpcomingLaunch: "%1$s, Upcoming Launch",
  EventEmail_Subject_NowAvailable: "%1$s Now Available",
  EventEmail_Subject_FreeDemoAvailable: "%1$s Free Demo Now Available",
  EventEmail_Subject_SpecialOffer: "%1$s Special Offer",
  EventEmail_Subject_Tournament_Now: "%1$s Tournament, Tune in Now",
  EventEmail_Subject_LiveStream_Now: "%1$s Live Stream, Tune in Now",
  EventEmail_Subject_NewDLC: "%1$s, New DLC Available",
  EventEmail_Subject_NewExpansion: "%1$s, New Expansion Available",
  EventEmail_Subject_NewChapter: "%1$s, New Chapter Available",
  EventEmail_Subject_NewBattlePass: "%1$s, New Battle Pass Available",
  EventEmail_Subject_NewSeason: "%1$s, New Season Available",
  Email_Wishlist_NewReleaseEA_Subject:
    "%1$s is now available in Early Access on Steam!",
  EventEmail_Button_ClickForMoreDetails: "Read More",
  Event_Button_VisitSalePage: "Visit the Sales page",
  EventEmail_Button_PrepurchaseNow: "Prepurchase now!",
  EventEmail_Button_BuyNow: "Buy now!",
  EventEmail_Button_PlayNow: "Play Now!",
  EventEmail_Button_WishlistNow: "Wishlist now!",
  EventEmail_WatchNow: "Watch Now",
  EventEmail_Destination_Store: "Steam Store Game Product Page",
  EventEmail_Destination_Event: "Event Detail Page",
  EventEmail_Destination_SalesPage: "Steam Store Sales Page",

  EventDashBoard_SummaryStats_Admin_Title: "(Visible only to admins)",
  EventDashBoard_SummaryStats_Title: "Unique Impressions and Views",
  EventDashBoard_SummaryStats_Desc:
    "(Beta) These are impressions and views of your events and announcements by unique logged-in users. This is only for new events and announcements crafted with this editor.",
  EventDashBoard_SummaryStats_Link: "Click here for more details.",
  EventDashBoard_SummaryStats_TotalImpressions: "Total Unique Impressions:",
  EventDashBoard_SummaryStats_TotalViews: "Total Unique Views:",
  EventDashBoard_SummaryStats_Dec2020Note:
    "Note: Due to heavy load, visibility was greatly undercounted from Dec 23 - Jan 5, 2021",
  EventDashBoard_ModerationQueueWarning:
    "This event has not yet gone through routine moderation and is therefore not currently visible in the Library.",
  EventDashBoard_Summary_LibraryHome_Shown:
    "Impressions of events (cover image):",
  EventDashBoard_Summary_LibraryHome_Read:
    "Clicks on an event to view details:",
  EventDashBoard_Summary_AppDetailSpotlight_Shown:
    "Impressions of spotlight banner:",
  EventDashBoard_Summary_AppDetailSpotlight_Read:
    "Clicks on a spotlight banner to view details:",
  EventDashBoard_Summary_AppDetailActivity_Shown:
    "Impressions of events in activity feed:",
  EventDashBoard_Summary_AppDetailActivity_Read:
    "Clicks on an event to view details:",
  EventDashBoard_Summary_StoreAppPage_Shown:
    "Impressions of events (cover image):",
  EventDashBoard_Summary_StoreAppPage_Read:
    "Clicks on an event to view details:",
  EventDashBoard_Summary_Community_Shown: "Impressions of event summary:",
  EventDashBoard_Summary_Community_Read:
    "Clicks on event summary to view details:",
  EventDashBoard_Summary_NewsHub_Shown: "Impressions of event in news hub:",
  EventDashBoard_Summary_NewsHub_Read: "Clicks on event to view details:",
  EventDashBoard_Location_LibraryHome: "Library Home Page",
  EventDashBoard_Location_LibraryDetail: "Library Game Page",
  EventDashBoard_Location_StoreDetail: "Store Game Page",
  EventDashBoard_Location_CommunityDetail: "Community App Hub",
  EventDashBoard_Location_PopUpViews: "Views of event pop-up",
  EventDashBoard_Location_NewsHubDetail: "News Hub",

  EventRepost_Dialog_Title: "Repost Event",
  EventRepost_Dialog_OK: "Repost",
  EventRepost_Dialog_Desc:
    "Reposting is referencing the event in the news hub in the timeline of the chosen groups below. The following are other community groups or apps which this event can be reposted to. Choose one or more groups to be posted.",
  EventRepost_Dialog_Existing: "%1$s - Group already reposting",
  EventRepost_Dialog_Action_Desc: "On clicking OK, we will do the following:",
  EventRepost_Dialog_Action_Add: "Repost on %1$s group(s)",
  EventRepost_Dialog_Action_Remove: "Remove the repost on %1$s group(s)",
  EventRepost_Dialog_Progress: "Reposting %1$s of %2$s items",
  EventRepost_Dialog_ResultFail: "Reposting fail. Please try again later.",
  EventRepost_Dialog_ResultSuccess: "Reposting successfully completed.",

  EventDashBoard_Location_ModerationTitle: "About Event Moderation",
  EventDashBoard_Location_WaitingModeraion: "Visibility pending moderation",

  EventDisplay_ReferencedApps_Joiner: ", ",
  EventDisplay_ReferencedApps: "Referenced content: %2$s.",
  EventDisplay_ReferencedApps_Plural: "Referenced content: %2$s.",

  EventEditor_SaleValveApproval_Title:
    "This sale page requires approval by Valve before you can publish and set it live",
  EventEditor_SaleValveApproval_Desc:
    "Please communicate with your Valve contact at least 7 days ahead of your desired publish date to make sure there is time for review/approval and any necessary changes.",
  EventEditor_SaleValveApproval_Admin_Tooltip:
    "Marking the page as approved will allow the partner to publish the sale and make it live",

  AddToWishlist_short: "+ Wishlist",
  Wishlisted: "On your Wishlist",
  Wishlisted_short: "Wishlist",
  AddToWishlist_ttip:
    "Get notified by email when your wishlisted items get released or are on sale",
  Wishlist_Error: "Update Wishlist Error",
  Wishlist_Error_Desc:
    "We encountered an error adding to your wishlist. Please try again later:",

  WindowTitle_FriendsList: "Friends List",
  FriendsList_OfflineTitle: "ERROR",
  FriendsList_OfflineOrFailure: "Friends Network Unreachable",
  FriendsList_OfflineDetail:
    "This failure may indicate that your local network is offline or that the Steam Friends servers are currently offline.",
  FriendsList_SignedOut: "Signed Out of Friends & Chat",
  FriendsList_SignedOut_Detail:
    "You are currently offline.  Sign in to access your friends list and chat.",
  FriendsList_OfflineMode: "Signed Out of Friends & Chat",
  FriendsList_OfflineMode_Detail:
    "Friends and chat are not available in Offline Mode. Please go online to access your friends list and chat.",
  Friends_RetryLoading: "Retry Connection",
  Friends_SignIn: "Sign In",
  FriendsList_Offline_Disconnected: "Disconnected",

  FriendsList_LoadingTitle: "LOADING",
  FriendsList_StillLoadingSummary: "Friends Network Loading...",
  FriendsList_StillLoadingDetail:
    "Steam is trying to connect to the friends network.  This may take a few seconds longer.",

  Dialog_On: "ON",
  Dialog_Off: "OFF",
  Dialog_DefaultWindowTitle: "Steam Dialog",

  TimeInterval_XYears: "%1$s years",
  TimeInterval_1YearXMonths: "1 year and %1$s months",
  TimeInterval_1Year: "1 year",
  TimeInterval_XMonths: "%1$s months",
  TimeInterval_1Month: "1 month",
  TimeInterval_1MonthX: "1 month and %1$s days",
  TimeInterval_XWeeks: "%1$s weeks",
  TimeInterval_1Week: "1 week",
  TimeInterval_XDays: "%1$s days",
  TimeInterval_1Day: "1 day",
  TimeInterval_1DayXHours: "1 day and %1$s hours",
  TimeInterval_XHours: "%1$s hours",
  TimeInterval_1Hour: "1 hour",
  TimeInterval_1HourXMinutes: "1 hour and %1$s minutes",
  TimeInterval_LessThanAnHour: "less than an hour",
  TimeInterval_XMinutes: "%1$s minutes",
  TimeInterval_XMinutesXSeconds: "%1$s minutes, %2$s seconds",
  TimeInterval_XMinutes1Second: "%1$s minutes, 1 second",
  TimeInterval_1Minute: "1 minute",
  TimeInterval_1MinuteXSeconds: "1 minute, %1$s seconds",
  TimeInterval_1Minute1Second: "1 minute, 1 second",
  TimeInterval_LessThanAMinute: "less than a minute",
  TimeInterval_XSeconds: "%1$s seconds",
  TimeInterval_1Second: "1 second",

  TimeSince_XYears: "%1$s years ago",
  TimeSince_1YearXMonths: "1 year and %1$s months ago",
  TimeSince_1Year: "1 year ago",
  TimeSince_XMonths: "%1$s months ago",
  TimeSince_1Month: "1 month ago",
  TimeSince_1MonthXDays: "1 month and %1$s days ago",
  TimeSince_XWeeks: "%1$s weeks ago",
  TimeSince_1Week: "1 week ago",
  TimeSince_XDays: "%1$s days ago",
  TimeSince_1Day: "1 day ago",
  TimeSince_1DayXHours: "1 day and %1$s hours ago",
  TimeSince_XHours: "%1$s hours ago",
  TimeSince_1Hour: "1 hour ago",
  TimeSince_1HourXMinutes: "1 hour and %1$s minutes ago",
  TimeSince_LessThanAnHour: "less than an hour ago",
  TimeSince_XMinutes: "%1$s minutes ago",
  TimeSince_XMinutesXSeconds: "%1$s minutes, %2$s seconds ago",
  TimeSince_XMinutes1Second: "%1$s minutes, 1 second ago",
  TimeSince_1Minute: "1 minute ago",
  TimeSince_1MinuteXSeconds: "1 minute, %1$s seconds ago",
  TimeSince_1Minute1Second: "1 minute, 1 second ago",
  TimeSince_LessThanAMinute: "less than a minute ago",
  TimeSince_XSeconds: "%1$s seconds ago",
  TimeSince_1Second: "1 second ago",
  TimeSince_ThisWeek: "This week",

  TimeRemaining_XYears: "%1$s years remaining",
  TimeRemaining_1YearXMonths: "1 year and %1$s months remaining",
  TimeRemaining_1Year: "1 year remaining",
  TimeRemaining_XMonths: "%1$s months remaining",
  TimeRemaining_1Month: "1 month remaining",
  TimeRemaining_1MonthXDays: "1 month and %1$s days remaining",
  TimeRemaining_XWeeks: "%1$s weeks remaining",
  TimeRemaining_1Week: "1 week remaining",
  TimeRemaining_XDays: "%1$s days remaining",
  TimeRemaining_1Day: "1 day remaining",
  TimeRemaining_1DayXHours: "1 day and %1$s hours remaining",
  TimeRemaining_XHours: "%1$s hours remaining",
  TimeRemaining_1Hour: "1 hour remaining",
  TimeRemaining_1HourXMinutes: "1 hour and %1$s minutes remaining",
  TimeRemaining_LessThanAnHour: "less than an hour remaining",
  TimeRemaining_XMinutes: "%1$s minutes remaining",
  TimeRemaining_XMinutesXSeconds: "%1$s minutes, %2$s seconds remaining",
  TimeRemaining_XMinutes1Second: "%1$s minutes, 1 second remaining",
  TimeRemaining_1Minute: "1 minute remaining",
  TimeRemaining_1MinuteXSeconds: "1 minute, %1$s seconds remaining",
  TimeRemaining_1Minute1Second: "1 minute, 1 second remaining",
  TimeRemaining_LessThanAMinute: "less than a minute remaining",
  TimeRemaining_XSeconds: "%1$s seconds remaining",
  TimeRemaining_1Second: "1 second remaining",
  TimeRemaining_ThisWeek: "This week",

  Time_Now: "Live Now",
  Time_UpNext: "Up Next",
  Time_Today: "Today",
  Time_Tomorrow: "Tomorrow",
  Time_Yesterday: "Yesterday",
  Time_Recent: "Recent",
  Time_Today_At: "Today at %1$s",
  Time_Yesterday_At: "Yesterday at %1$s",
  Time_Past_At: "%1$s at %2$s",

  ContextMenu_Copy: "Copy",
  ContextMenu_Cut: "Cut",
  ContextMenu_Paste: "Paste",
  ContextMenu_CopyLinkURL: "Copy Link URL",
  ContextMenu_OpenLinkInNewWindow: "Open Link in New Window",
  ContextMenu_CopyImageURL: "Copy Image URL",
  ContextMenu_OpenImageInNewWindow: "Open Image in New Window",
  ContextMenu_AddToDictionary: 'Add "%1$s" To Dictionary',

  Tooltip_Settings: "Manage friends list settings",
  Tooltip_VoiceSettings: "Manage voice settings",
  Tooltip_CopyRemotePlayTogetherInviteURL:
    "Copy Remote Play Together invite URL",
  Tooltip_SearchFriends: "Search my friends list",
  Tooltip_AddFriend: "Add a friend",
  Tooltip_FriendRequest: "%1$s incoming request",
  Tooltip_FriendRequest_Plural: "%1$s incoming requests",
  Tooltip_CreateGroupChat: "Create a group chat",
  Tooltip_InviteToGroup: "Invite a friend to this group chat",
  Tooltip_InviteToGroup_Denied:
    "You do not have permission to invite users to this group",
  Tooltip_GroupChatSettings: "Manage group chat settings",
  Tooltip_MemberCollapse: "Collapse member list",
  Tooltip_MemberExpand: "Expand member list",
  Tooltip_ChatsCollapse: "Collapse chats list",
  Tooltip_ChatsExpand: "Expand chats list",
  Tooltip_MinimizeList: "Minimize List",
  Tooltip_ExpandList: "Expand List",
  Tooltip_PinChannelList: "Pin Channel List",
  Tooltip_UnpinChannelList: "Unpin Channel List",
  Tooltip_TextChannel: "Text chat with group members",
  Tooltip_TextChannelCreate: "Create new text channel",
  Tooltip_NoPermissionChannelCreate:
    "You do not have permission to create channels in this group chat",
  Tooltip_VoiceChannel: "Voice chat in these voice channels",
  Tooltip_VoiceChannelCreate: "Create new voice channel",
  Tooltip_DismissVoice: "Decline Voice Invite",
  Tooltip_MicStatus_Active: "Microphone is active",
  Tooltip_MicStatus_Muted: "Microphone is muted",
  Tooltip_RemoteMicStatus_Muted: "User muted their microphone",
  Tooltip_MicStatus_NoMic: "User has no microphone connected",
  Tooltip_RemoteOutputStatus_Muted: "User disabled audio from this channel",
  Tooltip_YourMicStatus_Muted: "You muted your microphone",
  Tooltip_YourOutputStatus_Muted: "You disabled audio from this channel",
  Tooltip_VoiceControlButton_1v1_inactive: "Send a voice request",
  Tooltip_VoiceControlButton_1v1_active: "Leave voice channel",
  Tooltip_VoiceControlButton_group_create: "Create a voice channel",
  Tooltip_VoiceControlButton_group_leave: "Leave voice channel",
  Tooltip_VoiceControlButton_group_joinsingle: "Join voice channel",
  Tooltip_VoiceControlButton_group_joinmultiple:
    "Select a voice channel to join",

  LanguageTitle: "Language",

  Language_english: "English",
  Language_german: "German",
  Language_french: "French",
  Language_italian: "Italian",
  Language_korean: "Korean",
  Language_spanish: "Spanish - Spain",
  Language_schinese: "Chinese - Simplified",
  Language_tchinese: "Chinese - Traditional",
  Language_russian: "Russian",
  Language_thai: "Thai",
  Language_japanese: "Japanese",
  Language_portuguese: "Portuguese - Portugal",
  Language_polish: "Polish",
  Language_danish: "Danish",
  Language_dutch: "Dutch",
  Language_finnish: "Finnish",
  Language_norwegian: "Norwegian",
  Language_swedish: "Swedish",
  Language_hungarian: "Hungarian",
  Language_czech: "Czech",
  Language_romanian: "Romanian",
  Language_turkish: "Turkish",
  Language_arabic: "Arabic",
  Language_brazilian: "Portuguese - Brazil",
  Language_bulgarian: "Bulgarian",
  Language_greek: "Greek",
  Language_ukrainian: "Ukrainian",
  Language_latam: "Spanish - Latin America",
  Language_vietnamese: "Vietnamese",
  Language_sc_schinese: "SteamChina - Simplified Chinese",

  Language_koreana: "Korean",

  language_selection_english: "English",
  language_selection_spanish: "Español - España (Spanish - Spain)",
  language_selection_french: "Français (French)",
  language_selection_italian: "Italiano (Italian)",
  language_selection_german: "Deutsch (German)",
  language_selection_greek: "Ελληνικά (Greek)",
  language_selection_koreana: "한국어 (Korean)",
  language_selection_korean: "한국어 (Korean)",
  language_selection_schinese: "简体中文 (Simplified Chinese)",
  language_selection_sc_schinese: "简体中文 (Simplified Chinese)",
  language_selection_tchinese: "繁體中文 (Traditional Chinese)",
  language_selection_russian: "Русский (Russian)",
  language_selection_thai: "ไทย (Thai)",
  language_selection_japanese: "日本語 (Japanese)",
  language_selection_portuguese: "Português (Portuguese)",
  language_selection_brazilian: "Português - Brasil (Portuguese - Brazil)",
  language_selection_polish: "Polski (Polish)",
  language_selection_danish: "Dansk (Danish)",
  language_selection_dutch: "Nederlands (Dutch)",
  language_selection_finnish: "Suomi (Finnish)",
  language_selection_norwegian: "Norsk (Norwegian)",
  language_selection_swedish: "Svenska (Swedish)",
  language_selection_czech: "Čeština (Czech)",
  language_selection_hungarian: "Magyar (Hungarian)",
  language_selection_romanian: "Română (Romanian)",
  language_selection_bulgarian: "Български (Bulgarian)",
  language_selection_pirate: "Pirate (Yarr!)",
  language_selection_turkish: "Türkçe (Turkish)",
  language_selection_ukrainian: "Українська (Ukrainian)",
  language_selection_vietnamese: "Tiếng Việt (Vietnamese)",
  language_selection_arabic: "العربية (Arabic)",
  language_selection_spanish_mexican: "Español - Mexicano (Spanish - Mexican)",
  language_selection_latam: "Español - Latinoamérica (Spanish - Latin America)",

  Bbcode_Originally_Posted_By: "Originally posted by",
  Bbcode_No_Match: "No matches to supported BBCode",
  Bbcode_Expand_ShowMore_Collapsed: "Show More",
  Bbcode_Expand_ShowMore_Expanded: "Show Less",
  Bbcode_Expand_Spoiler_Collapsed: "Show Spoilers",
  Bbcode_Expand_Spoiler_Expanded: "Hide Spoilers",
  Bbcode_Expand_Details_Collapsed: "Show Details",
  Bbcode_Expand_Details_Expanded: "Hide Details",

  Editor_Bold: "Bold",
  Editor_Underline: "Underline",
  Editor_Italics: "Italics",
  Editor_StrikeThrough: "Strikethrough",
  Editor_Link: "Insert Link",
  Editor_Unordered: "Unordered List",
  Editor_Ordered: "Ordered List",
  Editor_Header: "Header",
  Editor_Header2: "Header 2",
  Editor_Header3: "Header 3",
  Editor_Emoticon: "Insert Emoticon",

  EventEditor_ConvertHTML_Error: "Failed Converting HTML",
  EventEditor_ConvertHTML_Error_Desc:
    "Failed Converting HTML to BBcode with the following error: '%1$s'",
  EventEditor_InsertLinkURL: "Insert URL",
  EventEditor_FormattingHelp_GetHelpLink: "Formatting help",
  EventEditor_InsertTrailer: "Insert Game Trailer",
  EventEditor_InsertTrailer_SearchApp: "Search by app name or ID",
  EventEditor_FailedToLoadApp:
    "Failed to load app details, try again later: %1$s",
  EventEditor_ImportHTML: "Import HTML",
  EventEditor_ImportFromHTML: "Import from HTML",
  EventEditor_ImportFromHTML_ttip:
    "Import from HTML. Will automatically convert your html to Steam formatting tags.",
  EventEditor_ImportFromHTML_Instruction: "Type or paste HTML below.",
  EventEditor_ImportFromHTML_PreserveNewlines: "Preserve newlines",
  EventEditor_ImportFromHTML_PreserveNewlines_Hint:
    "In HTML, newlines usually have no effect, but in BBCode they will show as blank lines.  If you used <p> or <br> tags, leave this unchecked.  If you usually use blog software that automatically adds <br> tags for newlines, you will probably want to check this box.",
  EventEditor_ImportFromHTML_ConvertToBBCode: "Convert to BBCode:",
  EventEditor_ImportFromHTML_ConversionInProgress:
    "Conversion in progress. Please do not close dialog.",
  EventEditor_ImportFromHTML_ConvertFinished:
    "Conversion Finished. You can now safely close this dialog.",
  EventEditor_InsertYouTube: "Insert YouTube™ Video",
  EventEditor_InsertYouTube_Left: "Left-aligned",
  EventEditor_InsertYouTube_Right: "Right-aligned",
  EventEditor_InsertYouTube_Full: "Full width",
  EventEditor_InsertYouTube_URL: "Full URL",
  EventEditor_InsertYouTube_Position: "Position",
  EventEditor_InsertYouTube_Placholder: "Enter YouTube™ URL",
  EventEditor_InsertYouTube_NoURL: "Please enter a valid YouTube™ URL.",
  EventEditor_InsertYouTube_Summary: "Descriptive summary version",
  EventEditor_InsertImage: "Insert an image from the web",
  EventEditor_InsertImage_Title: "Insert Image",
  EventEditor_InsertImage_Desc:
    "Enter an URL for an image (such as .jpg .gif or .png) to include that image in your post.",
  EventEditor_InsertImage_URL: "Image URL",
  EventEditor_InsertImage_Placeholder: "Enter a valid URL",
  EventEditor_InsertImage_Anchor: "Optional: URL to open when image clicked",
  EventEditor_AddSpeaker: "Insert Speaker",
  EventEditor_AddSpeaker_Desc:
    "Add a speaker's or streamer's details to the events. They will appear on the event and will also appear in event summary such that they are inspectable by Steam users.",
  EventEditor_AddSpeaker_Name: "Name:",
  EventEditor_AddSpeaker_Title: "Title (optional):",
  EventEditor_AddSpeaker_Company: "Company (optional):",
  EventEditor_AddSpeaker_About: "About the Speakers:",
  EventEditor_AddSpeaker_About_Placeholder:
    "Tell us aout the Presenters/Streamers... Can include social media links",
  EventEditor_ChoosePhoto: "Choose Speaker Photo",
  EventEditor_AssociateSteamAccount: "Associate Steam Account",
  EventEditor_AssociateSteamAccount_ttip:
    "By associating the appropriate Steam account with the speaker, they will get a presenter badge on the Steam broadcast that appears on A Steam sale page.",
  EventEditor_SteamAccount_addme: "Add me",
  EventEditor_SteamAccount_addfriend: "Add a friend",
  EventEditor_SteamAccount_clear: "Clear association",

  BBCode_ChooseImage: "Choose Image (%1$s x %2$s)",
  BBCode_ResizeImage: "Resize Image",

  EventEditor_LinkDescription: "Text To Display",
  EventEditor_LinkURL: "URL",
  EventEditor_YouTubeVideoTitle: "YouTube™ Video: %1$s",
  EventEditor_YouTubeVideoViews: "Views: %1$s",
  EventEditor_Author: "By: %1$s",
  EventEditor_Comments: "Comments",
  EventEditor_UpVotes: "Up Votes",
  EventEditor_DownVotes: "Down Votes",

  RSSManager_PostEvent_CreateFeedTitle: "Create News Feed Settings",
  RSSManager_PostEvent_UpdateFeedTitle: "Update News Feed Settings",
  RSSManager_PostEvent_Tilte: "Post News to Steam?",
  RSSManager_CreateFeed_Review:
    "Please review the following requirement before continuing:",
  RSSManager_PostEvent_CreateFeed_DuringPost:
    "The RSS feed being previewed doesn't match the current setting. Before we can create this new event, we need to first update the feed to the RSS URL used for the preview.  By default the RSS feed automation will be disabled. This can be changed later.",
  RSSManager_PostEvent_CreateFeed_Desc:
    "Create/Update feed to this RSS URL?: '%1$s'",
  RSSManager_PostEvent_Failure:
    "Failed to complete the feed creation/update and/or news posting action",
  RSSManager_PostEvent_CreatePost: "Would you like to post this item to Steam?",
  RSSManager_PostEvent_CreatePost_Draft:
    "Save as a draft? - Instead of posting immediately, this will create a hidden and unpublished announcement. You may then make changes before publishing in your Announcements Dashboard.",
  RSSManager_PostEvent_UpdatePost:
    "This event already exists in Steam. Would you like to update its content from the RSS item? Useful if RSS item content has changed. This will remove any customization done using the editor.",
  RSSManager_PostEvent_InFlight:
    "Please wait for Steam server to complete action.",
  RSSManager_PostEvent_Success_feed: "RSS feed has been successfully updated",
  RSSManager_PostEvent_Success:
    "Your announcement has been successfully created. To edit further go here: ",
  RSSManager_PostEvent_EventLink: "Edit Event Here",
  RSSManager_CreateFeed_Permissions_v1:
    "I agree that I am authorized to provide this RSS feed to be stored and redistributed via Steam.",
  RSSManager_CreateFeed_Conduct_v1:
    "I confirm that the contents of this RSS feed that are redistributed through Steam will comply with the Steam Online Conduct Rules.",
  RSSManager_CreateFeed_Conduct_Link: "Read Steam Online Conduct Rules here.",
  RSSManager_Status_Automation_Desc:
    "Automatically post news announcements from RSS feed",
  RSSManager_Status_Automation_Activate: "Activate RSS Feed",
  RSSManager_Status_Automation_DisableFailed:
    "Failed to deactivate feed. Please try again later.",
  RSSManager_EventDashBoard: "Open events dashboard",
  RSSManager_PostEvent_ViewEvent: "View Event",
  RSSManager_PostEvent_EditEvent: "Edit Event",
  RSSManager_PostEvent_UpdateEvent: "Update Event from RSS",
  RSSManager_SeeReview: "See Curation",
  RSSManager_PostEvent_Draft: "Saved as a draft",
  RSSManager_PostEvent_Staged:
    "Saved as a draft, staged to automatically publish %1$s",
  RSSManager_PostEvent_PostedDate: "Posted on %1$s",
  RSSManager_PostEvent_ViewRaw: "View Raw RSS",
  RSSManager_PreviewInfo: "Showing content for RSS url '%1$s':",

  Error_Message: "Error Message",
  Warning_Message: "Warning Message",
  Informational_Message: "Informational Message",
  Error_Description: "Error (code: %1$s) occurred with details: (%2$s)",
  Error_FailureNotice: "Failure",
  Error_GenericFailureDescription: "Sorry, that didn't work.",

  Image_ErrorTitle: "Failed to Load Image '%1$s', possible issues include:",
  Image_Error_msg1: "Check that the path to the image is correct.",
  Image_Error_msg2:
    "Check if server hosting the image supports anonymous access. The browser console may indicate an error related Access-Control-Allow-Origin if it doesn't.",
  Image_Error_msg3:
    "Ensure the URL to the image starts with https:// not http://. We expect access to images over an encrypted transfer.",
  Image_Error_suggestion:
    "You can always upload the image to Steam to host the content for free.",

  Platform_Hint_Mobile: "on Mobile Device",
  Platform_Hint_BigPicture: "in Big Picture",
  Platform_Hint_VR: "in Virtual Reality",

  Hover_SteamLevel: "Steam Level",
  Hover_BadgeXP: "%1$s XP",

  PersonaStateOffline: "Offline",
  PersonaStateAway: "Away",
  PersonaStateOnline: "Online",
  PersonaStateBlocked: "Blocked",
  PersonaStateInGame: "In-Game",
  PersonaStateBusy: "Busy",
  PersonaStateSnooze: "Away",
  PersonaStateInNonSteamGame: "In non-Steam game",
  PersonaStateWatchingBroadcast: "Watching broadcast:",
  PersonaStateLookingToTrade: "Looking to Trade",
  PersonaStateLookingToPlay: "Looking to Play",
  PersonaStateLastSeen: "Last online %1$s",
  PersonaStateLastSeen_JustNow: "Last online just now",
  PersonaStateRemotePlayTogether: "Remote Play Together",

  User_WantsToPlay: "Join",
  User_ToggleDoNotDisturb: "Do Not Disturb",
  User_GameInfoHidden:
    "Your game status is hidden from friends because of your privacy settings",
  User_LimitedAccount:
    "Your account does not meet the requirements to use this feature. %1$s for more information.",
  User_LimitedAccount_UrlInfo: "Visit Steam Support",

  isNickname: "Your nickname for this friend",
  Friend_Menu_NotAFriendLabel: "Not Friends",
  Friend_Menu_NotAFriendRequesting: "Requesting to be Friends",

  DASHPlayerStats_BytesReceived: "Bytes Received:",
  DASHPlayerStats_BufferingResolution: "Buffering Resolution:",
  DASHPlayerStats_PlaybackResolution: "Playback Resolution:",
  DASHPlayerStats_HtmlResolution: "Display Resolution:",
  DASHPlayerStats_DroppedFrames: "Dropped Frames:",
  DASHPlayerStats_VideoBuffered: "Video Buffered:",
  DASHPlayerStats_AudioBuffered: "Audio Buffered:",
  DASHPlayerStats_BandwidthRequired: "Bandwidth Required (Mbps):",
  DASHPlayerStats_BandwidthVideo: "Bandwidth Video (Mbps):",
  DASHPlayerStats_BandwidthNums: "Bandwidth Min/Max/Avg (Mbps):",
  DASHPlayerStats_DownloadNums: "DL Times Min/Max/Avg (Sec):",
  DASHPlayerStats_ContentServer: "Host:",
  DASHPlayerStats_ActiveDownloads: "Active Downloads:",
  DASHPlayerStats_StallEvents: "Stall Events:",
  DASHPlayerStats_FailedDownloads: "Failed Download Events:",
  DASHPlayerStats_VideoDownloadProgress: "Video Download Progress:",
  DASHPlayerStats_TimeToFirstFrame: "Time to First Frame MS:",
  DASHPlayerStats_DroppingFrames: "Persistent Frame Drops Detected:",
  DASHPlayerStats_CurrentFPS: "Current FPS:",
  DASHPlayerStats_Tracking: "Gathering Data...",
  DASHPlayerStats_PlaybackRate: "Playback Speed:",
  DASHPlayerStats_VideoBufferRange: "Video Buffer %1$s:",
  DASHPlayerStats_AudioBufferRange: "Audio Buffer %1$s:",
  DASHPlayerStats_VideoNoRangeInformation: "No Buffered Video Segments",
  DASHPlayerStats_AudioNoRangeInformation: "No Buffered Audio Segments",
  DASHPlayerControls_GoLive: "Go Live",
  DASHPlayerControls_IsLive: "Live",
  DASHPlayerControls_ClickToPlay: "Click to Play",
  DASHPlayerControls_IsReplay: "RE-BROADCAST",
  DASHPlayerControls_Start: "Start",
  DASHPlayerControls_End: "End",

  Played_Minutes: "%1$s minutes",
  Played_Hours: "%1$s hours",

  WriteReview_Dialog_PostReview: "Post review",
  WriteReview_Dialog_ReviseReview: "Edit review",
  WriteReview_Dialog_Title: "Review",
  WriteReview_Dialog_Playtime: "You've played for %1$s",
  WriteReview_Dialog_Playtime_Software: "You've used this title for %1$s",
  WriteReview_Dialog_Playtime_Revise: "You've played an additional %1$s",
  WriteReview_Dialog_RecommendGame:
    "Would you recommend this game to other players?",
  WriteReview_Dialog_RecommendGame_Software:
    "Would you recommend this software to other players?",
  WriteReview_Dialog_RecommendGame_Revise:
    "Would you like to revise your review?",
  WriteReview_Dialog_GetHelp_Btn: "Get help with your purchase",
  WriteReview_Dialog_Visibility: "Visibility:",
  WriteReview_Dialog_Public: "Public",
  WriteReview_Dialog_Friends: "Friends Only",
  WriteReview_Dialog_Yes: "Yes",
  WriteReview_Dialog_No: "No",
  WriteReview_Dialog_GetSupport_Btn: "Get help with your purchase",
  WriteReview_Dialog_GetSupport_Desc:
    "Get technical advice, official customer support, or request a refund.",
  WriteReview_Dialog_AddReview_Btn: "Post a review",
  WriteReview_Dialog_AddReview_Desc: "Share your thoughts with other players.",
  WriteReview_Dialog_AddReview_Header: "Would you like to post a review?",
  WriteReview_Dialog_ReviewInstructions_Link: "Rules and Guidelines",
  WriteReview_Dialog_ReviewInstructions:
    "Please describe what you liked or disliked about this product and whether you recommend it to others. Please remember to be polite and follow the %1$s. A description is required to post your recommendation.",
  WriteReview_Dialog_AllowComments: "Allow comments",
  WriteReview_Dialog_FreeDisclaimer:
    "Check this box if you received this product for free",
  WriteReview_Dialog_FreeDisclaimer_Tooltip:
    "Check this box if you were given this product for free. Will show Product received for free alongside your review. If you received additional compensation for the review of this game, you must disclose that in the text of your review.",
  WriteReview_Dialog_FormattingHelp: "Formatting Help",
  WriteReview_Dialog_GenericError:
    "We encountered a problem while posting your review. Please try again later.",
  WriteReview_Dialog_NoTextError:
    "Please describe what you liked or disliked about this product.",
  WriteReview_Dialog_Delay: "Maybe Later",

  Broadcast_View_Stack_H: "Horizontal View",
  Broadcast_View_Stack_V: "Vertical View",
  Broadcast_View_Theater: "Theater Mode",
  Broadcast_View_Fullscreen: "Fullscreen",
  Broadcast_View_HideChat: "Hide Chat",
  Broadcast_View_ShowBothChats: "Show Both Chats",
  Broadcast_View_ShowSingleChats: "Show Single Chat",
  Broadcast_View_ShowChat: "Show Chat",
  Broadcast_Store_FreeToPlay: "Free to Play",

  PartnerEvent_1: "Other Event",
  PartnerEvent_2: "Game Event",
  PartnerEvent_3: "Party Event",
  PartnerEvent_4: "Meeting Event",
  PartnerEvent_5: "Special Cause",
  PartnerEvent_6: "Music and Arts Event",
  PartnerEvent_7: "Sports Event",
  PartnerEvent_8: "Live Trip Event",
  PartnerEvent_9: "Chat",
  PartnerEvent_9_editor: "A Chat or AMA Session",
  PartnerEvent_10: "Game Release",
  PartnerEvent_10_editor: "Game is Releasing Now!",
  PartnerEvent_11: "Live-Stream / Broadcast",
  PartnerEvent_12: "Small Update / Patch Notes",
  PartnerEvent_12_editor: "Small Update / Patch Notes",
  PartnerEvent_13: "Regular Update",
  PartnerEvent_14: "Major Update",
  PartnerEvent_15: "DLC Release",
  PartnerEvent_16: "Upcoming Release",
  PartnerEvent_16_editor: "Game is Releasing on a Specific Date",
  PartnerEvent_17: "ESport Tournament Broadcast",
  PartnerEvent_18: "Dev Stream Broadcast",
  PartnerEvent_19: "Famous Broadcast",
  PartnerEvent_20: "Game Discount",
  PartnerEvent_20_editor: "Discount on This Game",
  PartnerEvent_21: "Item or DLC Discount",
  PartnerEvent_21_editor: "Discount on In-Game Items or DLC",
  PartnerEvent_22: "XP Boost",
  PartnerEvent_23: "Loot Event",
  PartnerEvent_24: "Perks Event",
  PartnerEvent_25: "Challenge Event",
  PartnerEvent_26: "Contest",
  PartnerEvent_27: "IRL Event",
  PartnerEvent_27_editor: "Attending an Expo, Meetup, or Convention",
  PartnerEvent_28: "News",
  PartnerEvent_28_editor: "Announcement / News",
  PartnerEvent_29: "Beta Release",
  PartnerEvent_29_editor: "Beta Invitation / News",
  PartnerEvent_30: "In-Game Update",
  PartnerEvent_30_editor: "In-Game Content Updated",
  PartnerEvent_31: "Free Trial",
  PartnerEvent_32: "Season/Pass",
  PartnerEvent_32_editor: "Season or Battle Pass Release",
  PartnerEvent_33: "Season Update",
  PartnerEvent_34: "Cross Promotion",
  PartnerEvent_35: "In-Game Event",
  PartnerEvent_35_editor: "General In-Game Event",
  PartnerEvent_Other: "Other Event",
  PartnerEvent_SteamAwardNominations: "Steam Award Nomination Request",
  PartnerEvent_SteamAwardVoteRequest: "Steam Award Vote Request",
  PartnerEvent_SteamGameFestival_ArtistState:
    "Steam Next Fest Artists Statement",
  PartnerEvent_SteamGameFestival_Broadcast: "Steam Next Fest Live Stream",
  PartnerEvent_SteamGameFestival_OfficeHour: "Steam Next Fest Office Hours",
  PartnerEvent_Curator_Group_Members: "Curator Group Announcement",
  PartnerEvent_Curator_Public: "Curator Public News Post",

  SocialMedia_Type_ShortName_1: "Steam",
  SocialMedia_Type_ShortName_2: "Google",
  SocialMedia_Type_ShortName_3: "Facebook",
  SocialMedia_Type_ShortName_4: "Twitter",
  SocialMedia_Type_ShortName_5: "Twitch",
  SocialMedia_Type_ShortName_6: "YouTube",
  SocialMedia_Type_ShortName_7: "Facebook",

  MobileLogin_NoSteamAccount: "Don't have a Steam account?",
  MobileLogin_CreateAccount: "Create a Free Account",
  MobileLogin_ForgotPassword: "Forgot your account name or password?",
  MobileLogin_RefreshCaptcha: "Refresh",
  MobileLogin_SignIn: "Sign in",
  MobileLogin_SigningIn: "Signing in",
  MobileLogin_AccountName: "Steam Account Name",
  MobileLogin_Password: "Password",
  MobileLogin_CaptchaVerification: "Verification",
  MobileLogin_Enter2FA:
    "Enter the code generated on the Steam Guard section of your Steam Mobile App.",
  MobileLogin_Enter2FAHelp: "I cannot access my Steam Guard code",
  MobileLogin_EnterSteamguard: "I did not receive a Steam Guard e-mail",
  MobileLogin_SteamguardCode: "Steam Guard Code",
  MobileLogin_SteamguardSubmit: "Submit & Sign In",
  MobileLogin_SentSteamguard_1: "We sent a message to your",
  MobileLogin_SentSteamguard_2: "e-mail. Enter the Steam Guard code provided.",
  MobileLogin_IncorrectSteamGuard:
    "The entered Steam Guard code is incorrect. Please check the code and try again.",

  MobileLogin_Error_RateLimitExceeded:
    "There have been too many login failures from your network in a short time period. Please wait and try again later.",

  Login_SignIn: "Sign in",
  Login_SigningIn: "Signing in",
  Login_AccountName: "Steam Account Name",
  Login_Password: "Password",
  Login_RememberMe: "Remember me on this computer",
  Login_RememberMe_Short: "Remember me",
  Login_ForgotPassword: "Forgot your account name or password?",
  Login_NoSteamAccount: "Don't have a Steam account?",
  Login_CreateAccount: "Create a Free Account",
  Login_CaptchaVerification:
    "Please verify your humanity by re-entering the characters in the captcha.",
  Login_RefreshCaptcha: "Refresh",
  Login_Enter2FA:
    "Enter the code generated on the Steam Guard section of your Steam Mobile App.",
  Login_Enter2FAHelp: "I cannot access my Steam Guard code",
  Login_EnterSteamguard: "I did not receive a Steam Guard e-mail",
  Login_SteamguardSubmit: "Submit & Sign In",
  Login_SentSteamguard:
    "We sent a message to your %1$s e-mail. Enter the Steam Guard code provided.",
  Login_SignOut: "Sign out",

  Login_SignIn_WithAccountName: "Sign in with account name",
  Login_SignIn_OrWithQRCode: "Or sign in with QR",
  Login_UseAppForQR: "Use the %1$s to sign in via QR code",
  Login_UseAppForQR_Inner: "Steam Mobile App",
  Login_CheckCredentials:
    "Please check your password and account name and try again.",
  Login_IncorrectSteamGuard: "The Steam Guard code you entered was incorrect.",
  Login_Help_SignIn: "Help, I can't sign in",
  Login_Help_AccessMobileApp:
    "Help, I no longer have access to my Steam Mobile App",
  Login_EnterMobileCode: "Enter the code from your Steam Mobile App",
  Login_EnterEmailCode: "Enter the code from your email address at: %1$s",
  Login_MobileProtectingAccount:
    "You have a mobile authenticator protecting this account.",
  Login_EmailProtectingAccount:
    "You have an email authenticator protecting this account.",
  Login_ActiveAccountName: "Account: %1$s",
  Login_AwaitingMobileConfirmation:
    "Awaiting your confirmation via the Steam Mobile App...",
  Login_EnterCodeInstead: "Enter a code instead",
  Login_Title_SteamGuard: "Steam Guard",

  Emoticon_Search: "Search Emoticons",
  AddonPicker_RecentlyUsed: "Recently Used",
  AddonPicker_RecentEmoticons: "Recent Emoticons",
  AddonPicker_RecentStickers: "Recent Stickers",
  AddonPicker_Emoticons: "Emoticons",
  AddonPicker_AllEmoticons: "All Emoticons",
  AddonPicker_Stickers: "Stickers",
  AddonPicker_RoomEffects: "Room Effects",
  AddonPicker_NoResults: "No Results",
  AddonPicker_NoRecent: "You don't have any recently used %1$s",
  AddonPicker_NoneOwned: "You don't have any %1$s",
  AddonPicker_AcquireAtPointsShop: "You can acquire some in the %1$s",
  AddonPicker_AcquireAtPointsShop_Link: "Points Shop",
  AddonPicker_AcquireAtPointsShopOrMarket:
    "You can acquire some in the %1$s or the on the %2$s",
  AddonPicker_AcquireAtPointsShopOrMarket_Link: "Community Market",
  Chat_Settings_Error_ChatFileTooLarge: "%1$s is too large (10MB maximum).",
  Chat_Settings_Error_ChatFileTypeNotSupported:
    "Cannot upload %1$s.  Only jpg, png, gif, webm, mpg, and ogv file types are supported.",
  ConnectionTrouble_FailedToConnect: "Failed to connect to Steam",
  Chat_Upload_ErrorCloud: "Failed to upload image data to cloud server.",
  Chat_Settings_Error_ServerError: "A server error occurred",
  Broadcast_ViewerCount: "%1$s viewer",
  Broadcast_ViewerCount_Plural: "%1$s viewers",
  Broadcast_VideoContext_ToggleStats: "Toggle technical stats",
  Broadcast_VideoContext_OpenStore: "Visit Store",
  Broadcast_None: "None",
  Broadcast_Playing: "Playing: ",

  BroadcastWatch_MinBrowser:
    "Your web browser does not support the minimum set of features required to watch this broadcast",
  BroadcastWatch_RequestFailed: "Failed to load this broadcast",
  BroadcastWatch_NotAvailable: "This broadcaster is offline",
  BroadcastWatch_WaitingForResponse: "Waiting for approval to watch",
  BroadcastWatch_WaitingForStart: "This broadcast is starting",
  BroadcastWatch_WaitingForReconnect: "Reconnecting to this broadcast",
  BroadcastWatch_ServerLoad:
    "Steam is experiencing high broadcast load and is currently unable to reserve a server spot to start this broadcast. Please try again in a few minutes.",
  BroadcastWatch_SystemNotSupported:
    "Steam Broadcasting is not currently supported on this broadcaster's system",
  BroadcastWatch_UserRestricted:
    "This broadcaster is currently restricted from broadcasting on Steam",
  BroadcastWatch_PoorUploadQuality:
    "This broadcaster is currently unable to maintain a stable broadcast connection to Steam",

  BroadcastChat_Reconnected: "Reconnected to chat",
  BroadcastChat_UnableToJoinChat: "Unable to join chat",
  BroadcastChat_NeverTell: "Never tell your password to anyone",
  BroadcastChat_EnterResponse: "Type to chat",
  BroadcastChat_InsertEmoticon: "Insert Emoticon",
  BroadcastChat_Send: "Send",
  BroadcastChat_UserJoined: "%1$s joined the chat",
  BroadcastChat_UserLeft: "%1$s left the chat",
  BroadcastChat_UserMuted: "%1$s has been muted in this chatroom",
  BroadcastChat_UserMutedLocal: "%1$s has been muted",
  BroadcastChat_UserUnmutedLocal: "%1$s has been unmuted",
  BroadcastChat_UserMuteFailed: "Failed to mute %1$s. Please try again.",
  BroadcastChat_AddedModerator: "Moderator %1$s added.",
  BroadcastChat_RemovedModerator: "Moderator %1$s removed.",
  BroadcastChat_AddModeratorFailed: "Failed to add %1$s as moderator!",
  BroadcastChat_RemoveModeratorFailed: "Failed to remove %1$s as moderator!",
  BroadcastChat_RemoveMessagesFailed:
    "Failed to remove messages for %1$s. Please try again.",
  BroadcastChat_UserUnmuteFailed: "Failed to unmute %1$s. Please try again.",
  BroadcastChat_YouMuted:
    "You have been muted and cannot post messages to this chat",
  BroadcastChat_FailedToSendMsg: "Failed to send chat message: %1$s",
  BroadcastChat_Cooldown:
    "You are sending messages too fast, try again in %1$s seconds.",
  BroadcastChat_User: "User:",
  BroadcastChat_Mute: "Mute",
  BroadcastChat_Unmute: "Unmute",
  BroadcastChat_MuteLocal: "Mute Locally",
  BroadcastChat_UnmuteLocal: "Unmute Locally",
  BroadcastChat_Login: "Login to join chat",
  BroadcastChat_LimitedUser: "Limited chat access",
  BroadcastChat_RemoveMessages: "Remove this user's messages",
  BroadcastChat_Role_Presenter_ttip: "Presenter",
  BroadcastChat_Role_Broadcaster_ttip: "Broadcaster",
  BroadcastChat_Role_Moderatorr_ttip: "Moderator",
  BroadcastChat_Blocked:
    "Only game owners are allowed to send chat messages during this broadcast.",
  BroadcastChat_half_Mute: "Mute user for 12 hours",
  BroadcastChat_day_Mute: "Mute user for a day",
  BroadcastChat_week_Mute: "Mute user for a week",
  BroadcastChat_perm_Mute: "Mute user permanently",
  BroadcastChat_half_Shadow: "Shadow-Mute user for 12 hours",
  BroadcastChat_day_Shadow: "Shadow-Mute user for a day",
  BroadcastChat_week_Shadow: "Shadow-Mute user for a week",
  BroadcastChat_perm_Shadow: "Shadow-Mute user for permanently",
  BroadcastChat_Add_Moderator: "Make this user a Moderator",
  BroadcastChat_Remove_Moderator: "Remove Moderator status for user",
  BroadcastChat_Change_Moderator_Title: "Change Moderator status for user",
  BroadcastChat_Change_Add_Confirm:
    "Are you sure you want to add the following user as a moderator? They will be able to mute other users on the broadcast chat.",
  BroadcastChat_Change_Remove_Confirm:
    "Are you sure you want to remove the following user as a moderator?",
  BroadcastChat_Tooltip_Show_Chat_Viewers:
    "Show a list of people who are currently in the chat window.",
  BroadcastChat_Tooltip_Minimize_Chat: "Minimize the chat window",
  BroadcastChat_Tooltip_Maximize_Chat: "Maximize the chat window",
  BroadcastChat_Tooltip_Popout_Chat: "Pop-out the chat into a new window",
  BroadcastChat_ChatOnly_Title: "Broadcast Chat Only",
  BroadcastChat_DefaultMessage: "Welcome to the chat!",
  BroadcastChat_Moderator: "Moderator",
  BroadcastChat_Broadcaster: "Broadcaster",

  ChatEntryButton_Submit: "Submit",
  ChatEntryButton_Emoticon: "Emoticon Picker",
  ChatEntryButton_Flair: "Flair Picker",
  ChatEntryButton_SendEmbed: "Send Special",

  Store_AddToCart: "Add to Cart",

  YouTubePlayer_Loading: "Loading YouTube...",
  VODPlayer_Loading: "Loading VOD Content for AppID %1$s...",
  VODPlayer_ErrorLoading: "Error: Failed to load VOD Content for AppID %1$s",

  home_page_live_broadcast: "Live",
  StoreBroadcast_Hide_Tooltip: "Show/hide the live broadcast",
  StoreBroadcast_Detault_popout_Title: "Now Broadcasting",
  StoreBroadcast_close_broadcast_popup:
    "Closes broadcast popup. The pop-up will not re-open during this session.",
  StoreBroadcast_Change_store_Broadcast_settings: "Change broadcast settings",
  Broadcast_Embedded_viewer: "%1$s Viewer",
  Broadcast_Embedded_viewer_Plural: "%1$s Viewers",
  BroadcastWatch_View_Broadcast_Page: "View broadcast page",
  Broadcast_Embed_Watch_SteamTV: "Watch on Steam.tv",
  Broadcast_Embed_Watch_With_Frieds_SteamTV:
    "Watch and chat with Friends on Steam.tv",
  sale_three_section_hide_chat: "Hide Chat",
  sale_three_section_show_chat: "Show Chat",
  btn_live_streams_all: "View all",

  Broadcast_default_title_simple: "Now broadcasting",
  Broadcast_default_title_dev: "Now broadcasting: Watch the developer play",
  Broadcast_default_title_dev_chat:
    "Now broadcasting: Chat with the Developers",
  Broadcast_default_title_ama: "Now broadcasting: Join the AMA",
  Broadcast_default_title_community:
    "Now broadcasting: Watch the community play",
  Broadcast_default_title_comp:
    "Now broadcasting: Watch this competitive match",
  Broadcast_default_title_speed: "Now broadcasting: Watch this speedrun",

  Sale_BundleSave: "Includes %1$s items.",
  Sale_BundleSave_WithDiscount:
    "Buy this bundle to save %1$s% off all %2$s items!",
  Sale_PackageSave: "Includes %1$s items.",
  Sale_ShowContents: "Show contents",
  Sale_ShowBundleContent: "Show all %1$s items in bundle",
  Sale_BundleContents_Title: "Contains these %1$s items:",
  Sale_SeeAllUpcomingEvents: "See all upcoming events",
  Sale_TypePackage: "Multi-Item Package",
  Sale_ReleaseDate: "Release date: %1$s",
  Sale_Released_Shorter: "Released:",
  Sale_ShowMore: "Show more",
  Sale_ShowLess: "Show less",
  Sale_EmptySearchResultsOrLoadFailure: "No matches found",
  Sale_OnWishlist: "On Wishlist",
  Sale_InLibrary: "In Library",
  Sale_PlayDemo: "Play Demo",
  Sale_DownloadDemo: "Download %1$s Demo",
  Sale_InstallDemo: "Install Demo",
  Sale_InstallDemo_ttip: "Install and run the demo for %1$s",
  Sale_CannotInstallDemo_ttip: "No demo found for %1$s",
  Sale_OtherActions_MenuLabel: "More",
  Sale_HiddenItems: "%1$s items are hidden due to %2$s",
  Sale_HiddenItems_Short: "%1$s hidden",
  Sale_HiddenItem_Single: "%1$s item is hidden due to %2$s",
  Sale_HiddenItem_Single_Short: "%1$s hidden",
  Sale_HiddenItem_Tooltip:
    "Items have been hidden due to your store preferences. Click to visit and edit your store preferences.",
  Sale_StorePreferences: "your store preferences",
  Sale_SeeAllSpecials: "See All Specials",
  Sale_SeeUpcomingEvents: "See upcoming events",
  Sale_AddToWishlist: "Add to wishlist",
  Sale_FollowGame: "Follow game",
  Sale_StopFollowingGame: "Stop following",
  Sale_VisitStorePage: "Visit Store page",
  Sale_Wishlisted: "Wishlisted",
  Sale_RemoveFromWishlist: "Remove from wishlist",
  Sale_AddToLibrary: "+ Add to Library",
  Sale_SeeEventDetails: "See Event Details",
  Sale_WatchNow: "Watch Now",
  Sale_PlayNow: "Play Now",
  Sale_EventSchedule: "Event Schedule",
  Sale_BroadcastSchedule: "Broadcast Schedule",
  Sale_EventSchedule_NoUpcomingEvents: "No upcoming events",
  Sale_EventSchedule_NoEventsScheduled:
    "No events scheduled yet in this section",
  Sale_CuratorRecommendation_title: "Curator Recommendations",
  Sale_CuratorDisplay_Explore: "Explore",
  Sale_CuratorDisplay_ListDefaultTitle: "Curator Recommendation List",
  Sale_CuratorDisplay_ListDefaultDesc:
    "See the %1$s's recommendation of games listed on this event.",
  Sale_SectionLink_BrowseAll: "Browse All",
  Sale_MeetDev: "Meet the Developers",
  Sale_Preferences: "Preferences",
  Sale_PlaceHolder:
    "Preview Mode: This section has no capsules. Will not appear on user page if it is empty.",
  Sale_EventSchedulePlaceHolder:
    "Preview Mode: There are currently no events associated with this schedule, this will not appear in the current state on the sale",
  Sale_EventSchedulePlaceHolder_Tab:
    "Preview Mode: For the currently select TAB there are no events associated with this schedule. Other tabs may show events in the schedule. This will not appear in the current state on the sale",
  Sale_SmartPlaceHolder:
    "Preview Mode: This smart section has no apps for you. This would not appear on user page if it is empty.",
  Sale_ReserveNow: "Reserve Now %1$s",
  Sale_ReserveExhausted: "Out of stock",
  Sale_ReserveEditor: "Reservation Widget Editor",
  Sale_ReserveEditor_Add: "Add Reservation Option",
  Sale_ReserveEditor_EditTitle: "Edit Description",
  Sale_ReserveEditor_EditDesc:
    "Edit the short description that will appear around the reservation",
  Sale_ReserveEditor_ReservePack: "Reservation Package",
  Sale_ReserveEditor_ReservePack_ttip:
    "The actual hardware item the user actually wants to purchase when their reservation comes up",
  Sale_ReserveEditor_Deposit: "Optional: Deposit Package",
  Sale_ReserveEditor_Deposit_ttip:
    "If the user needs to put a deposit, then enter its package id here, they will be required to purchase this package prior to be included in the reservation queue",
  Sale_AlreadyReserved: "Reserved on %1$s",
  Sale_CancelReservation: "Cancel Reservation",
  Sale_default_label: "(no title)",
  Sale_default_label_custom: "(custom title)",
  Sale_default_label_OnSale: "On Sale",
  Sale_default_label_TopSellers: "Top Sellers",
  Sale_default_label_FreeToPlay: "Free to Play",
  Sale_default_label_HorrorGames: "Horror Games",
  Sale_default_label_HorrorVR: "Horror VR",
  Sale_default_label_HorrorFreeToPlay: "Horror Free to Play",
  Sale_default_label_HalloweenEventsHorror: "Halloween Events in Horror Games",
  Sale_default_label_HalloweenEventsNonHorror:
    "Halloween Events in Non-Horror Games",
  Sale_default_label_MoreHalloweenEvents: "More Halloween Events",
  Sale_default_label_MoreHalloweenEventsNonHorror:
    "More Halloween Events in Non-Horror Games",
  Sale_default_label_NewAndUpcomingHorror: "New and Upcoming Horror",
  Sale_default_label_RemotePlay_Together: "Play Together – With Remote Friends",
  Sale_default_label_RemotePlay_Phone: "Play Anywhere - On your Phone",
  Sale_default_label_RemotePlay_Tablet: "Play Anywhere - On your Tablet",
  Sale_default_label_RemotePlay_TV: "Play Anywhere - On your TV",
  Sale_default_label_OnYourWishlist: "On Your Wishlist",
  Sale_default_label_RecommendedForYou: "Recommended For You",
  Sale_default_label_ComingSoon: "Coming Soon",
  Sale_default_label_JustAnnounced: "Just Announced",
  Sale_default_label_JustUpdated: "Just Updated",
  Sale_default_label_FreeWeekend: "Free Weekend",
  Sale_default_label_FreeWeek: "Free Week",
  Sale_default_label_PrePurchase: "Pre-Purchase Now",
  Sale_default_label_NewReleases: "New Releases",
  Sale_default_label_JustReleased: "Just Released",
  Sale_default_label_Highlighted: "Highlighted Deals",
  Sale_default_label_BackCat: "Back Catalogue",
  Sale_default_label_PlayForFree: "Play for Free!",
  Sale_defautl_label_FreeToKeep:
    "For a limited time, install now and keep it forever",

  Sale_default_label_1: "On Sale",
  Sale_default_label_2: "Top Sellers",
  Sale_default_label_3: "Free to Play",
  Sale_default_label_4: "Horror Games",
  Sale_default_label_5: "Horror VR",
  Sale_default_label_6: "Horror Free to Play",
  Sale_default_label_7: "Halloween Events in Horror Games",
  Sale_default_label_8: "Halloween Events in Non-Horror Games",
  Sale_default_label_9: "More Halloween Events",
  Sale_default_label_10: "More Halloween Events in Non-Horror Games",
  Sale_default_label_11: "New and Upcoming Horror",
  Sale_default_label_12: "Play Together – With Remote Friends",
  Sale_default_label_13: "Play Anywhere - On your Phone",
  Sale_default_label_14: "Play Anywhere - On your Tablet",
  Sale_default_label_15: "Play Anywhere - On your TV",
  Sale_default_label_18: "Coming Soon",
  Sale_default_label_19: "Just Announced",
  Sale_default_label_20: "Just Updated",
  Sale_default_label_21: "Free Weekend",
  Sale_default_label_22: "Free Week",
  Sale_default_label_23: "Pre-Purchase Now",
  Sale_default_label_24: "New Releases",
  Sale_default_label_25: "Just Released",
  Sale_default_label_26: "Highlighted Deals",
  Sale_default_label_27: "Back Catalogue",
  Sale_default_label_28: "Play for Free!",
  Sale_default_label_29: "For a limited time, install now and keep it forever",
  Sale_default_label_30: "Featured",
  Sale_default_label_31: "Free to Play",
  Sale_default_label_32: "Early Access",
  Sale_default_label_33: "Virtual Reality",
  Sale_default_label_34: "Soundtracks",
  Sale_default_label_35: "Action",
  Sale_default_label_36: "Adventure",
  Sale_default_label_37: "Casual",
  Sale_default_label_38: "Indie",
  Sale_default_label_39: "Massively Multiplayer",
  Sale_default_label_40: "Racing",
  Sale_default_label_41: "RPG",
  Sale_default_label_42: "Simulation",
  Sale_default_label_43: "Sports",
  Sale_default_label_44: "Strategy",
  Sale_default_label_45: "Singleplayer",
  Sale_default_label_46: "Multiplayer",
  Sale_default_label_47: "Story Rich",
  Sale_default_label_48: "Open World",
  Sale_default_label_49: "Platformer",
  Sale_default_label_50: "Visual Novel",
  Sale_default_label_51: "Anime",
  Sale_default_label_52: "Fantasy",
  Sale_default_label_53: "Horror",
  Sale_default_label_54: "Retro",
  Sale_default_label_55: "Co-op",
  Sale_default_label_56: "Arcade",
  Sale_default_label_57: "Family Friendly",
  Sale_default_label_58: "Turn-Based",
  Sale_default_label_59: "Shooter",
  Sale_default_label_60: "Mystery",
  Sale_default_label_61: "Action-Adventure",
  Sale_default_label_62: "Popular Titles",
  Sale_default_label_63: "Sports & Racing",
  Sale_default_label_64: "Fighting",
  Sale_default_label_65: "Hack and Slash",
  Sale_default_label_66: "Shoot 'em up",
  Sale_default_label_67: "Metroidvania",
  Sale_default_label_68: "Roguelike",
  Sale_default_label_69: "VR",
  Sale_default_label_70: "Puzzle",
  Sale_default_label_71: "Third-Person Shooter",
  Sale_default_label_72: "First-Person Shooter",
  Sale_default_label_73: "Bullet Hell",
  Sale_default_label_74: "Shoot 'em up / Bullet Hell",
  Sale_default_label_75: "Tools",
  Sale_default_label_76: "Videos",
  Sale_default_label_77: "More Hits",
  Sale_default_label_78: "Story-Driven Exploration",
  Sale_default_label_79: "Real-Time",
  Sale_default_label_80: "Card & Board Games",
  Sale_default_label_81: "Tower Defense",
  Sale_default_label_82: "Grand Strategy & 4X",
  Sale_default_label_83: "Action RPG",
  Sale_default_label_84: "JRPG",
  Sale_default_label_85: "Party-Based RPG",
  Sale_default_label_86: "Dungeon Crawler",
  Sale_default_label_87: "Physics",
  Sale_default_label_88: "Hidden Object",
  Sale_default_label_89: "Point & Click",
  Sale_default_label_90: "Story Rich Puzzle",
  Sale_default_label_91: "Minimalist Puzzle",
  Sale_default_label_92: "Survival Horror",
  Sale_default_label_93: "Psychological Horror",
  Sale_default_label_94: "Comedy Visual Novels",
  Sale_default_label_95: "Romance Visual Novels",
  Sale_default_label_96: "Mystery Visual Novels",
  Sale_default_label_97: "Text-Based Adventures",
  Sale_default_label_98: "2D Platformers",
  Sale_default_label_99: "Precision Platformers",
  Sale_default_label_100: "Puzzle Platformers",
  Sale_default_label_101: "Third Person",
  Sale_default_label_102: "Rhythm",
  Sale_default_label_103: "Featured Titles",
  Sale_default_label_104: "Action Highlights",
  Sale_default_label_105: "Adventure Highlights",
  Sale_default_label_106: "RPG Highlights",
  Sale_default_label_107: "Strategy Highlights",
  Sale_default_label_108: "Puzzle Highlights",
  Sale_default_label_109: "Platformer Highlights",
  Sale_default_label_110: "Horror Highlights",
  Sale_default_label_111: "Racing Highlights",
  Sale_default_label_112: "VR Highlights",
  Sale_default_label_113: "Simulation Highlights",

  SalePage_LoginPrompt:
    "Sign in to view additional items selected just for you.",
  SalePage_LoginReservationPrompt: "Login for reservations",
  SalePage_ParentApp_DLC: "DLC For",
  SalePage_ParentApp_SoundTrack: "Soundtrack For",
  SalePage_Tabs_AllContents: "This tab will show all products",
  SalePage_Tabs_MobileSelectorLabel: "VIEWING:",
  SalePage_Tabs_MobileSelectorShortcut: "MORE CATEGORIES",

  Sale_Reservation_NotAllowedAccount:
    "Your account is either too new or not in good standing. Your account is not permitted to make reservation.",
  Sale_Reservation_NotAvailableCountry:
    "This item is not available for reservation in your country",
  Sale_Reservation_CanceledPendingRefund:
    "Reservation cancellation is in progress. Please be patient.",
  Sale_Reservation_CancelAreYouSure:
    "Are you sure? Cancelling your reservation will refund your deposit and remove you from the queue",
  Sale_Reservation_CompletePurchase: "Complete purchase",
  Sale_Reservation_CompleteBy: "Complete purchase by:",
  Sale_Reservation_CancelAuto:
    "If you do not complete the purchase before the expiration time noted above, then we will cancel your reservation and refund your deposit.",
  Sale_Reservation_Expired: "Reservation expired.",

  Sale_BrowserSortOption_TopWishlisted: "Most Wishlisted Upcoming Games",
  Sale_BrowserSortOption_TopWishlisted_ttip:
    "Upcoming games sorted by total (all-time) wishlist counts. Only includes games not yet released on Steam.",
  Sale_BrowserSortOption_TrendingWishlisted: "Trending Upcoming Games",
  Sale_BrowserSortOption_TrendingWishlisted_ttip:
    "Upcoming Games sorted by trending or recent wishlist counts. Only includes games not yet released on Steam.",
  Sale_BrowserSortOption_PopularComingSoon: "Launching Soon",
  Sale_BrowserSortOption_PopularComingSoon_ttip:
    "Highly-wishlisted games, sorted by release date. Only includes games not yet released on Steam.",
  Sale_BrowserSortOption_PopularUpcoming: "Popular Upcoming",
  Sale_BrowserSortOption_PopularUpcoming_ttip:
    "Highly-wishlisted games, sorted by release date. Only includes games not yet released on Steam.",
  Sale_BrowserSortOption_MostPlayedDemo: "Most Downloaded Demos",
  Sale_BrowserSortOption_MostPlayedDemo_ttip:
    "Games sorted by their demo's all-time peak user count",
  Sale_BrowserSortOption_DailyActiveUserDemo: "Daily Active Demo Players",
  Sale_BrowserSortOption_DailyActiveUserDemo_ttip:
    "Games sorted by their demo's daily user count - using recent daily active data.",
  Sale_BrowserSortOption_PlayedNowDemo: "Top Demos",
  Sale_BrowserSortOption_PlayedNowDemo_ttip:
    "Games sorted by their demo's current online user count",
  Sale_BrowserSortOption_RecentlyReleased: "Recently Released",
  Sale_BrowserSortOption_RecentlyReleased_ttip:
    "Recently released games; ordered by descending Steam release date.",
  Sale_BrowserSortOption_PopularPurchased: "Popular",
  Sale_BrowserSortOption_PopularPurchased_ttip:
    "The most popular games right now based on purchase data",
  Sale_BrowserSortOption_PopularPurchasedDiscounted: "Discounted",
  Sale_BrowserSortOption_PopularPurchasedDiscounted_ttip:
    "The most popular games based on purchase; that also have a discount right now",
  Sale_BrowserSortOption_Discounted: "Discount Amount",
  Sale_BrowserSortOption_Discounted_ttip:
    "The most deeply discounted items right now",
  Sale_BrowserSortOption_Price: "Price",
  Sale_BrowserSortOption_Price_ttip: "The lowest price games right now",
  Sale_BrowserSortOption_NewAndTrending: "New and Trending",
  Sale_BrowserSortOption_NewAndTrending_ttip:
    "New and Trending that have released recently and have positive indicators on the store; similar to the front page new and trending tab.",
  Sale_BrowserSortOption_ContentHub_NewAndTrending: "New and Trending",
  Sale_BrowserSortOption_ContentHub_NewAndTrending_ttip: "",
  Sale_BrowserSortOption_ContentHub_TopSellers: "Top Sellers",
  Sale_BrowserSortOption_ContentHub_TopSellers_ttip: "",
  Sale_BrowserSortOption_ContentHub_Popular: "Popular",
  Sale_BrowserSortOption_ContentHub_Popular_ttip: "",
  Sale_BrowserSortOption_ContentHub_TopRated: "Top Rated",
  Sale_BrowserSortOption_ContentHub_TopRated_ttip: "",
  Sale_BrowserSortOption_ContentHub_Upcoming: "Upcoming",
  Sale_BrowserSortOption_ContentHub_Upcoming_ttip: "",
  Sale_BrowserSortOption_ContentHub_Suffix: "Content Hub",
  SalePage_WatchForDrop_Minutes_Developer:
    "Watch the stream for %1$s minutes and get item drops from the developer when the event is over!",
  SalePage_WatchForDrop_Minutes_CreatorNamed:
    "Watch the stream for %1$s minutes and get item drops from %2$s when the event is over!",
  SalePage_WatchForDrop_Hours_Developer:
    "Watch the stream for %1$s hours and get item drops from the developer when the event is over!",
  SalePage_WatchForDrop_Hours_CreatorNamed:
    "Watch the stream for %1$s hours and get item drops from %2$s when the event is over!",
  SalePage_WatchForDrop_LearnMore: "Learn more about the drops here.",

  ContentHub_Recommendation_Curator: "Recommended by: %1$s",
  ContentHub_Recommendation_FollowedDeveloper: "Developed by: %1$s",
  ContentHub_Recommendation_FollowedPublisher: "Published by: %1$s",
  ContentHub_Recommendation_FollowedFranchise: "Part of franchise: %1$s",
  ContentHub_Recommendation_Tags:
    "Recommended because you play games tagged with: %1$s",
  ContentHub_Recommendation_Tags_Software:
    "Recommended because you use software tagged with: %1$s",
  ContentHub_Recommendation_Tags_Video:
    "Recommended because you watch videos tagged with: %1$s",
  ContentHub_Recommendation_TopSeller: "Top seller",
  ContentHub_Recommendation_PopularNew: "New and trending",
  ContentHub_Recommendation_Specials: "Discounted",
  ContentHub_Recommendation_Concurrent: "Popular",
  ContentHub_Recommendation_Featured: "Featured",

  Sale_DynamicReview_Preview: "Preview Dynamic Reveal",
  Sale_DynamicReview_Preview_desc:
    "Below section has the Dynamic Reveal feature enabled. You can preview the feature by starting the test. This will reset when you leave the preview tab.",
  Sale_DynamicReview_Preview_start: "Start Test Mode",
  Sale_DynamicReview_Preview_active_desc:
    "We cleared original data and will reveal all items randomly. This will automatically refresh %1$s seconds.",
  Sale_DynamicReview_Preview_action: "Force Service Call",

  SalePage_Admin_SaleEventDay: "View Sales Day %1$s",

  Steam_Settings_Compat_Launch_Prefix: "Runs on this computer via",
  Steam_Settings_Compat_Launch_Name: "Steam Play.",
  Steam_Settings_Compat_Launch_Forced: "selected by you for this title.",
  Steam_Settings_Compat_Launch_Wildcard: "selected by you for all titles.",
  Steam_Settings_Compat_Launch_Whitelisted: "selected by Valve testing.",

  SteamAwards_EventMainTitle: "The Steam Awards",
  SteamAwards_EventMainTitleSecondLine: "Nominee",
  SteamAwards_EventMainTitleCombined: "The Steam Awards Nominee",
  SteamAwards_EventCallToAction: "Coming this December",
  SteamAwards_ExpiredEvent:
    "This event's Steam Awards has ended. Check back in during this year's Autumn and Winter sale for the annual Steam Awards!",
  SteamAwards_EventVotingDateTeaser: "December %1$s",
  SteamAwards_EventVoteForGamePrompt: "Click below to vote for %1$s:",
  SteamAwards_EventNominateGamePrompt_Long:
    "Nominate %1$s for the category below as suggested by the developers of this game, or select a different category",
  SteamAwards_EventNominateGamePrompt_NoCategory:
    "Click here to nominate %1$s for a category on the Steam Awards page.",
  SteamAwards_Event_NominationsClosed:
    "Nominations have closed. Vote during the Winter Sale. Winners announced January 3rd.",
  SteamAwards_Event_VotesClosed:
    "Voting has ended. Click here to see the results.",
  SteamAwards_EventNominateGamePrompt_CategoryPrefix: "Nominate for:",
  SteamAwards_EventNominationAlternativeLinkText: "Or pick another category",
  promo_steamawards2020_cat50: "Game of the Year",
  promo_steamawards2020_cat51: "VR Game of the Year",
  promo_steamawards2020_cat52: "Labor of Love",
  promo_steamawards2020_cat53: "Better With Friends",
  promo_steamawards2020_cat54: "Outstanding Visual Style",
  promo_steamawards2020_cat55: "Most Innovative Gameplay",
  promo_steamawards2020_cat56: "Best Game You Suck At",
  promo_steamawards2020_cat57: "Best Soundtrack",
  promo_steamawards2020_cat58: "Outstanding Story-Rich Game",
  promo_steamawards2020_cat59: "Sit Back and Relax",
  promo_steamawards2020_cat0:
    "Do not suggest a specific category, and instead let your fans pick the category they think best fits your game. The event will still include a link to the nominations page.",
  promo_steamawards2020_cat0_desc: "No Category",
  promo_steamawards2020_cat50_desc:
    "Maybe it was its immersive gameplay, or its gripping story... its well-crafted characters, immaculate design, or addictive multiplayer. Whatever the reason, the winner of 2020's Game of the Year Award is an instant classic.",
  promo_steamawards2020_cat51_desc:
    "The VR Game of the Year isn't merely masquerading as regular reality. This game improves on reality, taking advantage of the medium of VR and pushing the boundaries of the virtual realm.",
  promo_steamawards2020_cat52_desc:
    "This game has been out for a while. The team is well past the debut of their creative baby, but being the good parents they are, these devs continue to nurture and support their creation. This game, to this day, is still getting new content after all these years.",
  promo_steamawards2020_cat53_desc:
    "There are some games out there that just aren't the same when you play by yourself. Maybe you need to have a friend to watch your back. Maybe you need to have a friend that you can stab in their back. Either way, fun is awaiting those who gather friends together play this game.",
  promo_steamawards2020_cat54_desc:
    "Visual style doesn't aspire to real-world graphical fidelity (though a noble goal in itself)… it describes a distinctive look and feel that suffuses an entire game.",
  promo_steamawards2020_cat55_desc:
    "The designers of this game are at the front lines of creative experimentation, bringing a fresh perspective and brain-breaking surprises. This game delighted, inspired and entertained with newness never played before.",
  promo_steamawards2020_cat56_desc:
    "This is the game that rewards persistence, and is not for the faint of heart. It's the toughest game we've ever loved.",
  promo_steamawards2020_cat57_desc:
    "This unsung hero deserves to be recognized for its outstanding musical score. It's the OST with the MOST! ",
  promo_steamawards2020_cat58_desc:
    "Some days, only a narrative-heavy game will hit the spot, and this one packs a wallop. It's as gripping as any soap opera, and as well-tuned as a prestige-TV screenplay. Bravissimo -- for making us feel things!",
  promo_steamawards2020_cat59_desc:
    "This game is the antidote to a busy day. It's smooth, it's relaxing, it lets your worries melt away. This game is your moment of zen.",
  SteamAward_NominationConflictWarning_Title: "Change your nomination?",
  SteamAward_NominationConflictWarning_Explanation:
    "You can only nominate one game for each category, and you have already nominated %1$s for this one. Would you like to nominate %2$s instead?",
  SteamAward_VoteButton_PromptText: "Vote",
  SteamAward_VoteButton_VotedText: "Voted",
  SteamAward_VoteButton_AlreadyVotedText: "Vote submitted",
  SteamAward_VoteConflictWarning_Title: "Change your vote?",
  SteamAward_VoteConflictWarning_Explanation:
    "You can only vote for one game for each category, and you have already voted for %1$s for this one. Would you like to change your vote to %2$s?",
  SteamAward_Nominate_LimitedAccount:
    "It appears that your account is limited. To prevent nomination abuse, you must spend $5 USD on Steam in order to participate in the Steam Awards. Visit <a %1$s>Steam Support</a> for more info.",
  SteamAward_Vote_LimitedAccount:
    "It appears that your account is limited. To prevent vote abuse, you must spend $5 USD on Steam in order to participate in the Steam Awards. Visit <a %1$s>Steam Support</a> for more info.",

  Store_VR_Support_OnlyVR: "VR Only",
  Store_VR_Support_SupportsVR: "VR Supported",

  Giveaway_CountDown: "%1$s left until next random draw!",
  Giveaway_CountDown2: "Time left until next random draw.",
  Giveaway_KeepWatching: "Keep watching for a chance to win!",
  Giveaway_RandomDraw: "Random Draw in Progress",
  Giveaway_Congratulation: "Number of lucky winners so far!",
  Giveaway_Closed_NoWinnerInfo:
    "The giveaway is now over, thanks for participating.",
  Giveaway_Closed:
    "The giveaway is now over with %1$s lucky winners, thanks for participating.",
  Giveaway_LearnMore: "Click to learn more about the prizes, winners and rules",

  Lunar2020_CheckBackEachDay:
    "Check back each day for a new gift from the Emperor!",
  Lunar2020_CheckBackEachDayForStory: "Check back each day for a new chapter",
  Lunar2020_FirstGift: "First Gift",
  Lunar2020_SecondGift: "Second Gift",
  Lunar2020_ThirdGift: "Third Gift",
  Lunar2020_FourthGift: "Fourth Gift",
  Lunar2020_GiftWasOpened: "opened",
  Lunar2020_RereadStory: "show story",
  Lunar2020_GiftCanBeOpenedNow: "open now",
  Lunar2020_GiftCanBeOpenedAfterThePreviousOne: "open next",
  Lunar2020_GiftLockedUntilDate: "open %1$s",
  Lunar2020_ErrorLoadingVideo:
    "Please use a browser that supports HTML videos to open your envelope.",
  Lunar2020_LinkBackToSale: "Return to sale",
  Lunar2020_LinkFromVideoToMarket: "Visit the market now",
  Lunar2020_ReceivedNumberOfTokens: "You've received %1$s tokens",
  Lunar2020_YourBalancePrefix: "Your balance",
  Lunar2020_BalanceNumberOfTokens: "%1$s tokens",

  Lunar2020_LimitedUserDialogTitle: "Unable to open envelope",

  Lunar2020_StoryTitle: "THE EMPEROR'S GREAT RACE",
  Lunar2020_StorySubTitle: "The Origin of the Chinese Zodiac",

  Lunar2020_StoryDayOneHeader: "Part I of IV",
  Lunar2020_StoryDayTwoHeader: "Part II of IV",
  Lunar2020_StoryDayThreeHeader: "Part III of IV",
  Lunar2020_StoryDayFourHeader: "Part IV of IV",

  Lunar2020_StoryDayOne:
    "The Jade Emperor summoned all creatures of his kingdom to race to the heavenly palace, declaring the first twelve to arrive would be honored with a place on his new calendar.\n\nClever Rat was the first to cross the river into the celestial domain. No fan of swimming, Rat hitched a ride atop the trusty Ox—excitedly jumping into the Emperor's garden just before the pair were set to reach shore.\n\nSteady Ox crossed the river with ease. Unconcerned with the results of the race, Ox felt content with a role in Rat's success.",
  Lunar2020_StoryDayTwo:
    "Self-sufficient Tiger traveled too carefully to outpace Ox, thinking it better to arrive third than not at all.\n\nSwift Rabbit hopped a log floating nowhere fast. But luck paid off where strategy didn't, and a helpful wind sped the makeshift boat safely on its way.\n\nFlying Dragon's vantage revealed a village in need, so of course Dragon stopped to help—even gifting Rabbit a gust across the river. Honor was far more important than victory, and Dragon found fifth place a fine fit.",
  Lunar2020_StoryDayThree:
    "Stealthy Snake had little interest in a long-distance effort, so it wrapped itself unnoticed around Horse's front hoof.\n\nAs Horse galloped towards the finish line, Snake uncoiled, startling the steed just long enough to slither into sixth—with the skittish Horse trotting close behind.",
  Lunar2020_StoryDayFour:
    "Goat, Monkey, and Rooster worked together, but let Goat claim eighth as the backbone of their journey. Cheerful Monkey was next, and the strutting Rooster crossed tenth, proud that the order was fair.\n\nPlayful Dog was mostly interested in splashing around, feeling eleventh a fine trade for all the fun.\n\nLast came Pig, who'd stopped for a snack n' a snooze—wise enough to know that each animal will have their time in the Emperor's favor.",

  SteamChina_PendingPersonaName:
    "Profile changes will take effect after review",

  Legal_Footer_WithYear:
    "© %1$s Valve Corporation. All rights reserved. All trademarks are property of their respective owners in the US and other countries.",

  Sale_Subscription_SelectPlan: "Select a plan",
  Sale_Subscription_AlreadyOwnedPackage: "Your current plan",
  Sale_Subscription_AlreadyOwnedApp: "Already a member",
  Sale_Subscription_Save: "Save %2$s",
  Sale_Subscription_Annual_Price: "%1$s/year",
  Sale_Subscription_Annual_Price_Discount: "%1$s for the first year",
  Sale_Subscription_Annual_Body:
    "Pay for one year of access and save %2$s off your subscription",
  Sale_Subscription_Annual_Body_Discount:
    "%1$s billed annually thereafter, cancel anytime",
  Sale_Subscription_Annual_Button: "Subscribe Annually",
  Sale_Subscription_Monthly_Price: "%1$s/month",
  Sale_Subscription_Monthly_Price_Discount: "%1$s for the first month",
  Sale_Subscription_Monthly_Body: "Pay month-to-month and cancel any time",
  Sale_Subscription_Monthly_Body_Discount:
    "%1$s billed monthly thereafter, cancel anytime",
  Sale_Subscription_Monthly_Button: "Subscribe Monthly",
  Sale_Subscription_DiscountEnd: "Save %2$s when you sign up by %1$s",
  Sale_Subscription_OfferEnds: "Offer ends %1$s",
  Sale_Subscription_NewSubsOfferEnds:
    "Offer only for new subscribers. Ends %1$s",
  Sale_Subscription_Asterisk: "*",

  GotSteam_Title: "Got Steam?",
  GotSteam_PromptWithDownloadLink:
    "You need to have the %1$s installed before you can install and launch %2$s. Do you have Steam installed on this computer?",
  GotSteam_DownloadLinkText: "Steam desktop application",
  GotSteam_Yes: "Yes, Steam is installed",
  GotSteam_Yes_Play: "Play this game now",
  GotSteam_No: "No, I need Steam",
  GotSteam_No_Download: "Read about and download Steam",
  GotSteam_Blurb:
    "Steam is the premiere desktop gaming platform. It's free to join and easy to use.",

  GrantAwardTitle: "Give an Award",
  GrantAwardDescription_Review:
    "Use your Steam Points to emphasize this review and grant the reviewer bonus points!",
  GrantAwardDescription_UGC:
    "Use your Steam Points to grant this item a special award and grant the author bonus points!",
  GrantAwardDescription_Profile:
    "Use your Steam Points to grant this profile a special award and grant the user bonus points!",
  GrantAwardDescription_ForumTopic:
    "Use your Steam Points to grant this discussion post a special award and grant the author bonus points!",
  GrantAwardDescription_Comment:
    "Use your Steam Points to grant this comment a special award and grant the author bonus points!",
  GrantAwardNowButton: "Give Award",
  GrantAward_PointsLink: "What are Steam Points?",
  GrantAward_PromptTooltip: "Please select an award",
  GrantAward_SubmitTooltip: "Spend Steam Points and give the award",
  GrantAward_SelectAward: "Select Award",
  GrantAward_CantAfford: "You need %1$s more points",
  GrantAward_HowToGetPoints: "How To Get Points",
  GrantAward_Next: "Next",
  GrantAward_Back: "Back",
  GrantAward_Confirm:
    "Please confirm you would like to use %1$s to give this item the %2$s award.",
  GrantAward_Confirm_Details:
    "The award will show up immediately and the recipient will receive %1$s bonus points after %2$s",
  GrantAward_Confirm_DetailsTimePeriod: "14 days.",
  GrantAward_Success: "The award has successfully been granted.",
  GrantAwardError_Busy:
    "Our servers are busy right now.  Please try again later.",
  GrantAwardError_PersistFailed:
    "Our servers are busy right now.  Please try again later.",
  GrantAwardError_InvalidParam:
    "You cannot give an award to something you created.",
  GrantAwardError_NoMatch: "The item could not be found.",
  GrantAwardError_InsufficientFunds:
    "You do not have enough Steam Points to grant the selected award.",
  GrantAwardError_Fail:
    "There was a problem granting this award.  Please try again later.",
  GrantAwardError_AccessDenied:
    "You cannot redeem points for an award due to the restrictions placed on your account.",
  GrantAwardError_NotLoggedOn:
    "You will need to log in before you can grant any awards.",
  YourBalance: "Your Balance",
  RewardsReaction_1: "Deep Thoughts",
  RewardsReaction_2: "Heartwarming",
  RewardsReaction_3: "Hilarious",
  RewardsReaction_4: "Hot Take",
  RewardsReaction_5: "Poetry",
  RewardsReaction_6: "Extra Helpful",
  RewardsReaction_7: "Gotta Have It",
  RewardsReaction_8: "Michelangelo",
  RewardsReaction_9: "Treasure",
  RewardsReaction_10: "Mind Blown",
  RewardsReaction_11: "Golden Unicorn",
  RewardsReaction_12: "Mad Scientist",
  RewardsReaction_13: "Clever",
  RewardsReaction_14: "Warm Blanket",
  RewardsReaction_15: "Saucy",
  RewardsReaction_16: "Slow Clap",
  RewardsReaction_17: "Take My Points",
  RewardsReaction_18: "Wholesome",
  RewardsReaction_19: "Jester",
  RewardsReaction_20: "Fancy Pants",
  RewardsReaction_21: "Whoa",
  RewardsReaction_22: "Super Star",
  RewardsReaction_23: "Wild",
  RewardsReaction_Tooltip: "%1$s person marked this item as '%2$s'",
  RewardsReaction_Tooltip_Plural: "%1$s people marked this item as '%2$s'",

  ClanImageChooser_Title: "Select Image",
  ClanImageChooser_Desc: "Double click to choose image",
  ClanImageChooser_Search: "Search Images...",
  ClanImageChooser_None: "No images",
  ClanImagePickAndResize_UploadImage: "Upload Resized Image",
  ClanImagePickAndResize_UploadStatus: "Image Upload Status: %1$s",

  AppType_game: "game",
  AppType_software: "software",
  AppType_dlc: "dlc",
  AppType_bundle: "bundle",
  AppType_video: "video",
  AppType_sub: "subscription",
  AppType_event: "event",
  AppType_tag: "tag",
  AppType_music: "music",
  AppType_hardware: "hardware",
  AppType_series: "series",

  AppTypeLabelTitle: "Type",
  AppTypeLabel_game: "Games",
  AppTypeLabel_software: "Software",
  AppTypeLabel_dlc: "Downloadable Content",
  AppTypeLabel_demo: "Demos",
  AppTypeLabel_music: "Soundtracks",
  AppTypeLabel_video: "Videos",
  AppTypeLabel_hardware: "Hardware",

  GameHover_Tags: "Tags",
  GameHover_UserReviewsHeader: "",
  GameHover_UserReviewCount: "| %1$s User Reviews",

  Localization_Export_Btn_RowLanguages: "Language per row",
  Localization_Export_Btn_ColumnLanguages: "Language per Column",
  Localization_Export_Btn_TokenLanguages: "Token, Language list",
  Localization_Export_Btn_XML: "Export XML",
  Localization_Import_Btn: "Import Localization File(s)...",
  Localization_Error_Input:
    "We were not able to parse or recognize the input file",
  Localization_Error_FileExtention:
    "File does not have the '.xml' or '.csv' extension, failed to parse filename: %1$s",
  Localization_Error_FileLangauage:
    "File name does not specify the API Language Code. Expect file in the format <user name>_<language>.xml: %1$s",
  Localization_Error_XMLParseError:
    "Error occurred when parsing and applying the XML data: %1$s",
  Localization_Success_ImportComplete:
    "Localization Import Completed. The following languages updated: %1$s",
  Localization_Success_ImportComplete_NoChange:
    "Localization Import Completed. No changes were made.",

  TrailerPlayer_ID_NotProvided:
    "Cannot display trailer: The App ID and/or Trailer ID is not provided. The offical group event can automatically deetermine appid, however, both are required.",
  TrailerPlayer_CouldNotLoad:
    "Could not load appid %1$s and trailer %2$s. Double check they are published and visible on the store.",
  TrailerPlayer_LoadingError:
    "Please use a browser that supports HTML videos to watch this trailer.",

  FacetedBrowse_Heading: "Narrow By",
  FacetedBrowse_NoMatches: "No matches found.",
  FacetedBrowse_MatchCount: "%1$s match",
  FacetedBrowse_MatchCount_Plural: "%1$s matches",
  FacetedBrowse_MatchCountPartial: "%1$s+ match",
  FacetedBrowse_MatchCountPartial_Plural: "%1$s+ matches",
  FacetedBrowse_Reset: "Reset",
  FacetedBrowse_ReturnToTop: "Return to Top",

  Platform: "Platform",
  Platform_Windows: "Windows",
  Platform_Linux: "Linux / SteamOS",
  Platform_Mac: "macOS",

  ContentDescriptor: "Content Descriptor",
  ContentDescriptor_GeneralMatureContent: "General Mature Content",
  ContentDescriptor_FrequentViolenceOrGore: "Frequent Violence or Gore",
  ContentDescriptor_NudityOrSexualContent: "Nudity or Sexual Content",
  ContentDescriptor_AdultOnlySexualContent: "Adult Only Sexual Content",

  UserPreference_HideOwnedItems: "Hide items in my library",
  UserPreference_HideWishlistedItems: "Hide items on my wishlist",
  UserPreference_HideIgnoredItems: "Hide ignored items",

  App_Taxonomy_Survey_QSuperGenreTitle: "Top-Level Genres",
  App_Taxonomy_Survey_QGenreTitle: "Genres",
  App_Taxonomy_Survey_QSubGenreTitle: "Sub-Genres",
  App_Taxonomy_Survey_QVisualsTitle: "Visuals & Viewpoint",
  App_Taxonomy_Survey_QThemeMoodTitle: "Themes & Moods",
  App_Taxonomy_Survey_QFeaturesTitle: "Features",
  App_Taxonomy_Survey_QPlayersTitle: "Players",

  Browse_Sale_Hide_Games_I_Own: "Hide items in my Library",
  Browse_Sale_Mature_Themes: "Mature Themes",
  Browse_Sale_Mature_Feature: "Mature",
  Browse_sale_Violence_Feature: "Violence",
  Browse_Sale_Sexual_Feature: "Nudity or Sexual Content",
  Browse_Sale_Adult_Feature: "Adult Only",

  bytes: "%1$s B",
  bytes_PerSecond: "%1$s B/s",
  bits: "%1$s b",
  bits_PerSecond: "%1$s bps",
  Kilobytes: "%1$s KB",
  Kilobytes_PerSecond: "%1$s KB/s",
  Kilobits: "%1$s Kb",
  Kilobits_PerSecond: "%1$s Kbps",
  Megabytes: "%1$s MB",
  Megabytes_PerSecond: "%1$s MB/s",
  Megabits: "%1$s Mb",
  Megabits_PerSecond: "%1$s Mbps",
  Gigabytes: "%1$s GB",
  Gigabytes_PerSecond: "%1$s GB/s",
  Gigabits: "%1$s Gb",
  Gigabits_PerSecond: "%1$s Gbps",
  Terabytes: "%1$s TB",
  Terabytes_PerSecond: "%1$s TB/s",
  Terabits: "%1$s Tb",
  Terabits_PerSecond: "%1$s Tbps",

  ImportLoc_Title: "Import Localization",
  ImportLoc_Description:
    "Import text for a variety of languages by importing a file from your machine. A variety of formats are supported, and for an example of each you can select a sample below.",
  ImportLoc_SampleTitle: "Download Samples",
  ImportLoc_CSVLangPerRow: "CSV Language Per Row",
  ImportLoc_CSVLangPerCol: "CSV Language Per Column",
  ImportLoc_CSVTokenLang: "CSV Token List",
  ImportLoc_XML: "XML Single Language",

  FAQViewer_SteamSupport: "Steam Support",
  FAQViewer_NoFAQFound: "Sorry, we could not find that page.",
  FAQViewer_GoToHomepage: "Return to community homepage",
  FAQViewer_AdminLinks: "Admin Links",
  FAQViewer_Admin_LastUpdate: "Last published by: %1$s on %2$s",
  FAQViewer_GotoEditor: "Edit FAQ",
  FAQViewer_DraftNewer:
    "Draft edited by: %1$s has newer changes, last save %2$s",
  FAQViewer_UnknownUser: "unknown user",
  FAQViewer_SideBar_ProblemWithSteam_Title: "Need help with Steam?",
  FAQViewer_SideBar_ProblemWithSteam_Desc:
    "Use the Steam help wizard to narrow down your topic and get the help you need.",
  FAQViewer_SideBar_ProblemWithSteam_Link: "Help Me With My Issue",
  FAQViewer_SideBar_CommunityHelp_Title: "Community Help",
  FAQViewer_SideBar_CommunityHelp_Desc:
    "Post or search in Steam Discussions for an answer to your question.",
  FAQViewer_SideBar_CommunityHelp_Link: "Visit Steam Discussions",

  StreamLaunch_Updating_Title: "Updating Game",
  StreamLaunch_Failed_Title: "Stream Launch Failed",
  StreamLaunch_RequiresUI:
    "This game launch requires user intervention.\n\nLaunch manually on the remote computer and then join the stream from here.",
  StreamLaunch_AccessDenied: "Authentication problem.",
  StreamLaunch_Unsupported: "This game currently doesn't support streaming.",
  StreamLaunch_ScreenLocked: "The screen is locked on the remote computer.",
  StreamLaunch_Broadcasting:
    "The remote computer is currently using Steam Broadcasting so it cannot start a Remote Play session.",
  StreamLaunch_OtherGameRunning:
    "There is another game already running on the remote computer.",
  StreamLaunch_Timeout: "Timed out waiting for stream to launch.",
  StreamLaunch_InstallRequiresUI:
    "Installation of this game requires user intervention.\n\nInstall manually on the remote computer.",
  StreamLaunch_Failed: "Unable to launch stream.",
  StreamLaunch_InstallDrivers:
    "Streaming requires additional driver installation.\n\nPlease follow the Steam prompts on the remote computer.",
  StreamLaunch_StillDownloading:
    "Update is in progress on the remote computer.  The game will be ready to stream when the download completes.",
  StreamLaunch_TransportUnavailable:
    "Streaming outside the home isn't currently available, try again later.",

  LOC_Ordinal_Prefix_Default: "<none>",
  LOC_Ordinal_Suffix_Default: "th",
  LOC_Ordinal_Suffix_1: "st",
  LOC_Ordinal_Suffix_2: "nd",
  LOC_Ordinal_Suffix_3: "rd",
  LOC_Ordinal_Suffix_21: "st",
  LOC_Ordinal_Suffix_22: "nd",
  LOC_Ordinal_Suffix_23: "rd",
  LOC_Ordinal_Suffix_31: "st",
  LOC_Ordinal_Suffix_32: "nd",
  LOC_Ordinal_Suffix_33: "rd",
  LOC_Ordinal_Suffix_41: "st",
  LOC_Ordinal_Suffix_42: "nd",
  LOC_Ordinal_Suffix_43: "rd",
  LOC_Ordinal_Suffix_51: "st",
  LOC_Ordinal_Suffix_52: "nd",
  LOC_Ordinal_Suffix_53: "rd",
  LOC_Ordinal_Suffix_61: "st",
  LOC_Ordinal_Suffix_62: "nd",
  LOC_Ordinal_Suffix_63: "rd",
  LOC_Ordinal_Suffix_71: "st",
  LOC_Ordinal_Suffix_72: "nd",
  LOC_Ordinal_Suffix_73: "rd",
  LOC_Ordinal_Suffix_81: "st",
  LOC_Ordinal_Suffix_82: "nd",
  LOC_Ordinal_Suffix_83: "rd",
  LOC_Ordinal_Suffix_91: "st",
  LOC_Ordinal_Suffix_92: "nd",
  LOC_Ordinal_Suffix_93: "rd",

  shared_dummy: "dont translate",
});
