// Generated by Haxe 3.4.7
(function ($hx_exports, $global) { "use strict";
$hx_exports["Render"] = $hx_exports["Render"] || {};
$hx_exports["Main"] = $hx_exports["Main"] || {};
function $extend(from, fields) {
	function Inherit() {} Inherit.prototype = from; var proto = new Inherit();
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var BoxEntry = function() {
	this.tags = [];
	this.tagEntries = [];
	this.tagCategories = [];
	this.disabledTags = [];
	this.boostedTags = [];
};
BoxEntry.__name__ = true;
BoxEntry.prototype = {
	toString: function() {
		return "BoxEntry(" + this.appid + "," + this.title + "," + this.url + "," + this.shortDescription + "," + this.screenshot + ")";
	}
	,setPrice: function(cents) {
		var priceStr = "$" + (cents / 100 | 0) + "." + (cents % 100 | 0);
		this.discountBlock = "<div class=\"discount_block  no_discount\" data-price-final=\"" + cents + "\"><div class=\"discount_prices\"><div class=\"discount_final_price\">" + priceStr + "</div></div></div>";
	}
	,clear: function() {
		this.appid = "";
		this.title = "";
		this.discountBlock = "";
		this.comingSoon = false;
		this.screenshot = "";
		this.screenshots = [];
		this.recommender = "";
		this.microtrailer_webm = "";
		this.microtrailer_mpeg4 = "";
		this.tags = [];
		this.tagEntries = [];
		this.tagCategories = [];
		this.url = "";
		this.shortDescription = "";
	}
	,getConsideredTags: function() {
		var results = [];
		var _g = 0;
		var _g1 = this.tags;
		while(_g < _g1.length) {
			var tag = _g1[_g];
			++_g;
			var pass = true;
			var _g2 = 0;
			var _g3 = this.disabledTags;
			while(_g2 < _g3.length) {
				var dt = _g3[_g2];
				++_g2;
				if(dt == tag.tagid) {
					pass = false;
					break;
				}
			}
			if(pass) {
				results.push(tag);
			}
		}
		return results;
	}
	,makeTagEntries: function(focusedTags,justGetEm,ignoreTags) {
		if(justGetEm == null) {
			justGetEm = false;
		}
		this.tagEntries = [];
		if(ignoreTags == null) {
			ignoreTags = [];
		}
		var blah = [];
		var _g = 0;
		while(_g < focusedTags.length) {
			var tag = focusedTags[_g];
			++_g;
			blah.push(tag.name);
		}
		if(justGetEm) {
			var _g1 = 0;
			while(_g1 < focusedTags.length) {
				var tag1 = focusedTags[_g1];
				++_g1;
				this.tagEntries.push({ name : tag1.name, tagid : tag1.tagid, highlighted : true});
			}
			return;
		}
		this.tags.sort(function(a,b) {
			if(a.count > b.count) {
				return -1;
			}
			if(a.count < b.count) {
				return 1;
			}
			return 0;
		});
		var _g2 = 0;
		var _g11 = this.tags;
		while(_g2 < _g11.length) {
			var tag2 = _g11[_g2];
			++_g2;
			var found = false;
			var disabled = false;
			if(focusedTags != null && focusedTags.length > 0) {
				var _g21 = 0;
				while(_g21 < ignoreTags.length) {
					var iTag = ignoreTags[_g21];
					++_g21;
					if(iTag == tag2.tagid) {
						found = false;
						disabled = true;
						break;
					}
				}
				if(!disabled) {
					var _g22 = 0;
					while(_g22 < focusedTags.length) {
						var fTag = focusedTags[_g22];
						++_g22;
						if(fTag.tagid == tag2.tagid) {
							found = true;
							break;
						}
					}
				}
			} else {
				found = true;
			}
			if(found) {
				this.tagEntries.push({ name : tag2.name, tagid : tag2.tagid, highlighted : true});
			} else {
				this.tagEntries.push({ name : tag2.name, tagid : tag2.tagid, highlighted : false});
			}
		}
	}
	,disableTag: function(tagid) {
		if(this.disabledTags.indexOf(tagid) == -1) {
			this.disabledTags.push(tagid);
		} else {
			HxOverrides.remove(this.disabledTags,tagid);
		}
		if(this.boostedTags.indexOf(tagid) != -1) {
			HxOverrides.remove(this.boostedTags,tagid);
		}
	}
	,boostTag: function(tagid) {
		if(this.boostedTags.indexOf(tagid) == -1) {
			this.boostedTags.push(tagid);
		} else {
			HxOverrides.remove(this.boostedTags,tagid);
		}
		if(this.disabledTags.indexOf(tagid) != -1) {
			HxOverrides.remove(this.disabledTags,tagid);
		}
	}
	,toggleTag: function(tagid) {
		if(this.disabledTags.indexOf(tagid) == -1) {
			this.disabledTags.push(tagid);
		} else {
			HxOverrides.remove(this.disabledTags,tagid);
		}
	}
	,getTagHTML3: function(keyAttributes,maxLines) {
		if(maxLines == null) {
			maxLines = 3;
		}
		if(keyAttributes == null) {
			keyAttributes = "";
		}
		var str = "";
		if(this.keyTags != null) {
			var _this = this.keyTags;
			var catTags = __map_reserved["reccats"] != null ? _this.getReserved("reccats") : _this.h["reccats"];
			if(catTags != null) {
				var keys = __map_reserved["key"] != null ? catTags.getReserved("key") : catTags.h["key"];
				var others = __map_reserved["other"] != null ? catTags.getReserved("other") : catTags.h["other"];
				var allTags = [];
				if(keys != null) {
					var _g = 0;
					while(_g < keys.length) {
						var key = keys[_g];
						++_g;
						allTags.push(key);
					}
				}
				if(others != null) {
					var _g1 = 0;
					while(_g1 < others.length) {
						var other = others[_g1];
						++_g1;
						allTags.push(other);
					}
				}
				var allTagIds = [];
				var _g2 = 0;
				while(_g2 < allTags.length) {
					var tag = allTags[_g2];
					++_g2;
					allTagIds.push(tag.tagid == null ? "null" : "" + tag.tagid);
				}
				var i = 0;
				var lines = 0;
				str += "<div>";
				var names = this.getTagNames(allTagIds,true);
				var _g3 = 0;
				while(_g3 < names.length) {
					var name = names[_g3];
					++_g3;
					if(i >= maxLines * 2) {
						break;
					}
					var tagid = allTagIds[i];
					var disabled = this.disabledTags.indexOf(tagid) != -1;
					var boosted = this.boostedTags.indexOf(tagid) != -1;
					str += Render.tagLine(i,tagid,name,disabled,boosted);
					++lines;
					++i;
				}
				str += "</div>";
				return "<em>" + keyAttributes + "</em><br>" + str;
			}
		} else {
			var keyAttributes1 = Main.loc("#labs_deepdive_keytags");
			var tagListClass = "tag-list";
			if(Main.FEATURE_FLAG_KILLABLE_TAGS) {
				tagListClass += " tag-list-killable";
			}
			return "<em>" + Main.loc("#labs_deepdive_loading") + ("</em><br><p class=\"" + tagListClass + "\">") + "<br><br><br><br><br></p>";
		}
		return "<em>" + keyAttributes + "</em><br>" + this.getTagHTML2(maxLines);
	}
	,getTagHTML2: function(maxLines) {
		if(maxLines == null) {
			maxLines = 3;
		}
		var str = "";
		var tmp = this.tagCategories != null;
		str += "</div>";
		return str;
	}
	,getTagHTML: function(header,forHover,maxLines) {
		if(maxLines == null) {
			maxLines = 3;
		}
		if(forHover == null) {
			forHover = false;
		}
		if(header == null) {
			header = "";
		}
		var str = "";
		if(this.tagCategories != null) {
			var genreIndex = -1;
			var i = 0;
			var hasWarning = false;
			var _g = 0;
			var _g1 = this.tagCategories;
			while(_g < _g1.length) {
				var cat = _g1[_g];
				++_g;
				if(cat == null || cat.category == null) {
					continue;
				}
				if(cat.category.indexOf("genre") != -1) {
					genreIndex = i;
					break;
				} else {
					var tmp = cat.category.indexOf("content") != -1;
				}
				++i;
			}
			i = 0;
			var lines = 0;
			var genres = [];
			var _g2 = 0;
			var _g11 = this.tagCategories;
			while(_g2 < _g11.length) {
				var cat1 = _g11[_g2];
				++_g2;
				if(cat1.category.indexOf("genre") != -1) {
					genres = genres.concat(cat1.tags);
				}
			}
			if(genres.length > 0) {
				var hasRogueLike = Data.cheapIndexOf(genres,"1716") != -1;
				var hasRogueLite = Data.cheapIndexOf(genres,"3959") != -1;
				if(hasRogueLike && hasRogueLite) {
					var i1 = Data.cheapIndexOf(genres,"1716");
					genres.splice(i1,1);
				}
				var arr = this.getTagNames(genres);
				while(arr.length > 3) arr.pop();
				var tagNames = arr.join(", ");
				var i2 = 0;
				var tagListClass = "tag-list";
				if(Main.FEATURE_FLAG_KILLABLE_TAGS) {
					tagListClass += " tag-list-killable";
				}
				if(tagNames != null && tagNames.length > 0) {
					if(!(tagNames.length == 1 && genres[0] == "492")) {
						str += "<p class=\"" + tagListClass + " tag-list-0\"> " + tagNames + "</p>";
						++lines;
					}
				}
			}
			var _g3 = 0;
			var _g12 = this.tagCategories;
			while(_g3 < _g12.length) {
				var cat2 = _g12[_g3];
				++_g3;
				if(i >= maxLines) {
					break;
				}
				if(cat2.category.indexOf("genre") != -1) {
					continue;
				}
				if(cat2.category.indexOf("weak") != -1) {
					continue;
				}
				var tagNames1 = "";
				var names = this.getTagNames(cat2.tags);
				var _g21 = 0;
				while(_g21 < names.length) {
					var name = names[_g21];
					++_g21;
					if(name == null || name == "") {
						HxOverrides.remove(names,name);
					}
				}
				var arr1 = this.getTagNames(cat2.tags);
				while(arr1.length > 3) arr1.pop();
				tagNames1 = arr1.join(", ");
				var tagListClass1 = "tag-list";
				if(Main.FEATURE_FLAG_KILLABLE_TAGS) {
					tagListClass1 += " tag-list-killable";
				}
				if(lines < maxLines && tagNames1 != null && tagNames1.length > 0) {
					str += "<p class=\"" + tagListClass1 + " tag-list-" + lines + "\"> " + tagNames1 + "</p>";
					++lines;
				}
				++i;
			}
			if(!forHover) {
				var tagListClass2 = "tag-list";
				if(Main.FEATURE_FLAG_KILLABLE_TAGS) {
					tagListClass2 += " tag-list-killable";
				}
				while(lines < maxLines) {
					str += "<p class=\"" + tagListClass2 + " tag-list-" + lines + "\">&nbsp;</p>";
					++lines;
				}
			}
		}
		return str;
	}
	,getTagCloud: function(forHover,maxLines) {
		if(maxLines == null) {
			maxLines = 3;
		}
		if(forHover == null) {
			forHover = false;
		}
		var str = "";
		var wrapTag = "<div class=\"app_tag\">";
		var wrapTag2 = "</div> ";
		var pTag = "<div class=\"hover_tag_row hover_tag_cloud\">";
		var pTag2 = "</div>";
		if(!forHover) {
			wrapTag = "";
			wrapTag2 = "";
			pTag = "<p class=\"tag-cloud\">";
			pTag2 = "</p>";
		}
		var _g = 0;
		var _g1 = this.tagEntries;
		while(_g < _g1.length) {
			var entry = _g1[_g];
			++_g;
			if(str != "" && !forHover) {
				str += " ";
			}
			if(entry.highlighted == true) {
				if(forHover) {
					str += wrapTag + entry.name + wrapTag2;
				} else {
					str += wrapTag + "<strong>" + entry.name + "</strong>" + wrapTag2;
				}
			} else {
				str += wrapTag + entry.name + wrapTag2;
			}
		}
		return pTag + str + pTag2;
	}
	,getCategoryName: function(str) {
		switch(str) {
		case "level design":
			str = "level";
			break;
		case "genre":case "subgenre":case "supergenre":
			str = "genre";
			break;
		default:
			str = str;
		}
		return str;
	}
	,getTagNames: function(tags,showDisabled) {
		if(showDisabled == null) {
			showDisabled = false;
		}
		var arr = [];
		var _g = 0;
		while(_g < tags.length) {
			var tagId = tags[_g];
			++_g;
			var pass = true;
			if(!showDisabled && this.disabledTags != null) {
				var _g1 = 0;
				var _g2 = this.disabledTags;
				while(_g1 < _g2.length) {
					var dTag = _g2[_g1];
					++_g1;
					if(dTag == tagId) {
						pass = false;
						break;
					}
				}
			}
			if(pass) {
				var name = this.getTagName(tagId);
				if(name != "") {
					arr.push(name);
				}
			}
		}
		return arr;
	}
	,getTagName: function(id) {
		return Main.tagDB.getName(id);
	}
	,setDetails: function(details) {
		if(details == null) {
			this.clear();
			return;
		}
		this.appid = details.appid;
		this.title = details.title;
		this.header = details.capsule;
		this.screenshot = details.screenshots != null && details.screenshots.length > 0 ? details.screenshots[0] : "";
		this.screenshots = details.screenshots != null ? details.screenshots.slice() : [];
		this.microtrailer_webm = details.microtrailer_webm;
		this.microtrailer_mpeg4 = details.microtrailer_mpeg4;
		this.discountBlock = details.discount_block;
		this.comingSoon = details.coming_soon;
		this.tags = this.copyTags(details.tags);
		this.url = details.url;
		this.shortDescription = details.shortDescription;
	}
	,copyValuesFrom: function(other) {
		this.appid = other.appid;
		this.title = other.title;
		this.header = other.header;
		this.discountBlock = other.discountBlock;
		this.comingSoon = other.comingSoon;
		this.screenshot = other.screenshot;
		this.screenshots = other.screenshots != null ? other.screenshots.slice() : [];
		this.recommender = other.recommender;
		this.microtrailer_webm = other.microtrailer_webm;
		this.microtrailer_mpeg4 = other.microtrailer_mpeg4;
		this.tags = this.copyTags(other.tags);
		this.tagEntries = this.copyTagEntries(other.tagEntries);
		this.tagCategories = this.copyTagCategories(other.tagCategories);
		this.disabledTags = other.disabledTags != null ? other.disabledTags.slice() : [];
		this.boostedTags = other.boostedTags != null ? other.boostedTags.slice() : [];
		this.url = other.url;
		this.shortDescription = other.shortDescription;
	}
	,copyTagCategories: function(otherCategories) {
		var arr = [];
		var _g = 0;
		while(_g < otherCategories.length) {
			var t = otherCategories[_g];
			++_g;
			arr.push({ category : t.category, score : t.score, tags : t.tags.slice()});
		}
		return arr;
	}
	,copyTagEntries: function(otherEntries) {
		var arr = [];
		var _g = 0;
		while(_g < otherEntries.length) {
			var t = otherEntries[_g];
			++_g;
			arr.push({ tagid : t.tagid, name : t.name, highlighted : t.highlighted});
		}
		return arr;
	}
	,copyTags: function(otherTags) {
		var arr = [];
		if(otherTags == null) {
			return arr;
		}
		var _g = 0;
		while(_g < otherTags.length) {
			var t = otherTags[_g];
			++_g;
			arr.push({ tagid : t.tagid, name : t.name, count : t.count, browseable : t.browseable});
		}
		return arr;
	}
	,copy: function() {
		var be = new BoxEntry();
		be.copyValuesFrom(this);
		return be;
	}
	,__class__: BoxEntry
};
var Data = function() { };
Data.__name__ = true;
Data.getVariables = function() {
	var map = new haxe_ds_StringMap();
	var href = window.location.href;
	var arr = href.split("?");
	if(arr != null && arr.length >= 2) {
		var varStr = arr[1];
		var vars = varStr.split("&");
		var _g = 0;
		while(_g < vars.length) {
			var variable = vars[_g];
			++_g;
			var nameValue = variable.split("=");
			if(nameValue != null && nameValue.length >= 2) {
				var name = nameValue[0];
				var value = nameValue[1];
				if(__map_reserved[name] != null) {
					map.setReserved(name,value);
				} else {
					map.h[name] = value;
				}
			}
		}
	}
	return map;
};
Data.getBasicStuff = function(callback) {
	Data.request("dbbasics",[],function(str) {
		var data = JSON.parse(str);
		var tagData = data.tagData;
		var categoriesByTag = tagData.categoriesByTag;
		var tags = Data.jsonToMapStrStr(tagData.tags);
		var tagMap = Data.jsonToMapStrArrOfStr(categoriesByTag);
		var prefs = data.prefs;
		var locMap = Data.parseLocs(data.locs);
		var wishlist = Data.parseWishlist(data.wishlist);
		var basicStuff = { baseUrl : data.baseUrl, cdnUrl : data.cdnUrl, tagMap : tagMap, tags : tags, prefs : prefs, locMap : locMap, loggedIn : data.loggedIn, wishlist : wishlist};
		callback(basicStuff);
	},function(error) {
		callback(null);
	});
};
Data.getWishlist = function(callback) {
	Data.request("dbwishlist",[],function(str) {
		var data = JSON.parse(str);
		var wishlist = Data.parseWishlist(data);
		callback(wishlist);
	},function(error) {
		callback(null);
	});
};
Data.parseWishlist = function(json) {
	var wishlist = new haxe_ds_StringMap();
	var _g = 0;
	var _g1 = Reflect.fields(json);
	while(_g < _g1.length) {
		var field = _g1[_g];
		++_g;
		var appid = field;
		var priority = 0;
		var added = 0;
		try {
			var obj = Reflect.field(json,field);
			priority = Reflect.field(obj,"priority");
			added = Reflect.field(obj,"added");
		} catch( msg ) {
			priority = 0;
			added = 0;
		}
		var entry = { appid : appid, priority : priority, added : added};
		if(__map_reserved[appid] != null) {
			wishlist.setReserved(appid,entry);
		} else {
			wishlist.h[appid] = entry;
		}
	}
	return wishlist;
};
Data.parseLocs = function(data) {
	var map = new haxe_ds_StringMap();
	var _g = 0;
	var _g1 = Reflect.fields(data);
	while(_g < _g1.length) {
		var field = _g1[_g];
		++_g;
		var value = Reflect.field(data,field);
		if(__map_reserved[field] != null) {
			map.setReserved(field,value);
		} else {
			map.h[field] = value;
		}
	}
	return map;
};
Data.getLinkParam = function(param,callback) {
	Data.request("dbgetlinkparam/" + param,[],function(str) {
		callback(str);
	},function(error) {
		callback(null);
	});
};
Data.filterMatches = function(matches) {
	var map = matches.map;
	var storeItemData = matches.storeItemData;
	var rgApps = storeItemData != null ? storeItemData.rgApps : null;
	var exclusions = [];
	var showVR = Main.prefs.show_vr;
	var showEA = Main.prefs.show_early_access;
	var showPreorder = Main.prefs.show_prepurchase;
	var tagsToExclude = Main.prefs.tags_to_exclude;
	var showLocalized = true;
	if(!rgApps != null) {
		var _g = 0;
		var _g1 = Reflect.fields(rgApps);
		while(_g < _g1.length) {
			var field = _g1[_g];
			++_g;
			var appid = field;
			var excluded = false;
			if(Main.isOwned(appid) || Main.onWishlist(appid)) {
				excluded = true;
				exclusions.push(appid);
			}
			if(!excluded) {
				var object = Reflect.field(rgApps,field);
				if(object != null) {
					excluded = false;
					var isLocalized = Object.prototype.hasOwnProperty.call(object,"localized") && Reflect.field(object,"localized");
					var isVR = Object.prototype.hasOwnProperty.call(object,"virtual_reality") && Reflect.field(object,"virtual_reality");
					var isEA = Object.prototype.hasOwnProperty.call(object,"early_access") && Reflect.field(object,"early_access");
					if(!showVR && isVR) {
						excluded = true;
					}
					if(!showEA && isEA) {
						excluded = true;
					}
					if(showLocalized && !isLocalized) {
						excluded = true;
					}
					if(excluded) {
						exclusions.push(appid);
					} else {
						var os_windows = Object.prototype.hasOwnProperty.call(object,"os_windows") && Reflect.field(object,"os_windows");
						var os_mac = Object.prototype.hasOwnProperty.call(object,"os_mac") && Reflect.field(object,"os_mac");
						var os_linux = Object.prototype.hasOwnProperty.call(object,"os_linux") && Reflect.field(object,"os_linux");
						var numPlatforms = Main.prefs.prefs.platform_linux + Main.prefs.prefs.platform_mac + Main.prefs.prefs.platform_windows;
						if(numPlatforms > 0) {
							var matchesOSFilters = 0;
							if(os_linux && Main.prefs.prefs.platform_linux == 1) {
								++matchesOSFilters;
							}
							if(os_mac && Main.prefs.prefs.platform_mac == 1) {
								++matchesOSFilters;
							}
							if(os_windows && Main.prefs.prefs.platform_windows == 1) {
								++matchesOSFilters;
							}
							if(matchesOSFilters == 0) {
								exclusions.push(appid);
							}
						}
					}
					if(!excluded) {
						var _this = matches.tags;
						var tags = __map_reserved[appid] != null ? _this.getReserved(appid) : _this.h[appid];
						if(tags != null && tags.length > 0) {
							var _g2 = 0;
							while(_g2 < tagsToExclude.length) {
								var badTag = tagsToExclude[_g2];
								++_g2;
								if(tags.indexOf(badTag) != -1) {
									exclusions.push(appid);
									break;
								}
							}
						}
					}
				}
			}
		}
	}
	var rec = map.keys();
	while(rec.hasNext()) {
		var rec1 = rec.next();
		var list = __map_reserved[rec1] != null ? map.getReserved(rec1) : map.h[rec1];
		if(list != null && list.length > 0) {
			var _g3 = 0;
			while(_g3 < exclusions.length) {
				var exclusion = exclusions[_g3];
				++_g3;
				var i = Data.cheapIndexOf(list,exclusion);
				if(i != -1) {
					list.splice(i,1);
				}
			}
			if(__map_reserved[rec1] != null) {
				map.setReserved(rec1,list);
			} else {
				map.h[rec1] = list;
			}
		}
	}
	var rgApps1 = matches.storeItemData.rgApps;
	var apps = [];
	var _g4 = 0;
	var _g11 = Reflect.fields(rgApps1);
	while(_g4 < _g11.length) {
		var field1 = _g11[_g4];
		++_g4;
		if(Data.cheapIndexOf(exclusions,field1) != -1) {
			continue;
		}
		apps.push(field1 == null ? "null" : "" + field1);
	}
	exclusions = [];
	var results = GlobalStuff.filterItemsForDisplay(matches.storeItemData);
	var _g5 = 0;
	while(_g5 < results.length) {
		var result = results[_g5];
		++_g5;
		if(Data.cheapIndexOf(apps,result) != -1) {
			exclusions.push(result);
		}
	}
	var rec2 = map.keys();
	while(rec2.hasNext()) {
		var rec3 = rec2.next();
		var list1 = __map_reserved[rec3] != null ? map.getReserved(rec3) : map.h[rec3];
		if(list1 != null && list1.length > 0) {
			var _g6 = 0;
			while(_g6 < exclusions.length) {
				var exclusion1 = exclusions[_g6];
				++_g6;
				if(Data.cheapIndexOf(list1,exclusion1) != -1) {
					HxOverrides.remove(list1,exclusion1);
				}
			}
			if(__map_reserved[rec3] != null) {
				map.setReserved(rec3,list1);
			} else {
				map.h[rec3] = list1;
			}
		}
	}
	return matches.map;
};
Data.getMatches = function(appid,recommenders,page,alreadySeen,disabledTags,boostedTags,callback) {
	var recString = recommenders.join("-");
	var url = "dbapi/" + appid + "/" + page;
	var allTags = [];
	if(boostedTags != null) {
		var _g = 0;
		while(_g < boostedTags.length) {
			var boostedTag = boostedTags[_g];
			++_g;
			allTags.push(boostedTag);
		}
	}
	if(disabledTags != null) {
		var _g1 = 0;
		while(_g1 < disabledTags.length) {
			var disabledTag = disabledTags[_g1];
			++_g1;
			allTags.push("-" + disabledTag);
		}
	}
	if(allTags.length > 0) {
		url += "/" + allTags.join(",");
	} else {
		url += "/_";
	}
	if(Main.FEATURE_FLAG_ML_RECOMMENDER) {
		url += "/ml";
	}
	Data.request(url,[],function(data) {
		var map = null;
		var matchData = null;
		try {
			matchData = Data.parseMatches(data);
			map = Data.filterMatches(matchData);
			matchData.map = map;
		} catch( msg ) {
		}
		callback(matchData);
	},function(error) {
		callback(null);
	});
};
Data.parseMatches = function(data) {
	var json = JSON.parse(data);
	if(json == null) {
		return null;
	}
	var map = new haxe_ds_StringMap();
	var tags = new haxe_ds_StringMap();
	var details = new haxe_ds_StringMap();
	var keyTags = new haxe_ds_StringMap();
	var storeItemData = null;
	var wishlist = null;
	var _g = 0;
	var _g1 = Reflect.fields(json);
	while(_g < _g1.length) {
		var field = _g1[_g];
		++_g;
		if(field == "tags") {
			var tagBlob = Reflect.field(json,field);
			var _g2 = 0;
			var _g3 = Reflect.fields(tagBlob);
			while(_g2 < _g3.length) {
				var tagField = _g3[_g2];
				++_g2;
				var arr = Reflect.field(tagBlob,tagField);
				if(arr != null) {
					if(__map_reserved[tagField] != null) {
						tags.setReserved(tagField,arr);
					} else {
						tags.h[tagField] = arr;
					}
				}
			}
		} else if(field == "keyTags") {
			var keyTagBlob = Reflect.field(json,field);
			var _g21 = 0;
			var _g31 = Reflect.fields(keyTagBlob);
			while(_g21 < _g31.length) {
				var recommenderField = _g31[_g21];
				++_g21;
				var recommenderBlob = Reflect.field(keyTagBlob,recommenderField);
				var weightMap = new haxe_ds_StringMap();
				var _g4 = 0;
				var _g5 = Reflect.fields(recommenderBlob);
				while(_g4 < _g5.length) {
					var tagTypeField = _g5[_g4];
					++_g4;
					var weightList = Reflect.field(recommenderBlob,tagTypeField);
					if(__map_reserved[tagTypeField] != null) {
						weightMap.setReserved(tagTypeField,weightList);
					} else {
						weightMap.h[tagTypeField] = weightList;
					}
				}
				if(__map_reserved[recommenderField] != null) {
					keyTags.setReserved(recommenderField,weightMap);
				} else {
					keyTags.h[recommenderField] = weightMap;
				}
			}
		} else if(field == "details") {
			var detailBlob = Reflect.field(json,field);
			var _g22 = 0;
			var _g32 = Reflect.fields(detailBlob);
			while(_g22 < _g32.length) {
				var detailField = _g32[_g22];
				++_g22;
				var data1 = Reflect.field(detailBlob,detailField);
				var dets = data1;
				if(dets != null) {
					if(__map_reserved[detailField] != null) {
						details.setReserved(detailField,dets);
					} else {
						details.h[detailField] = dets;
					}
				}
			}
		} else if(field == "storeitemdata") {
			storeItemData = Reflect.field(json,field);
		} else if(field == "focus") {
			var data2 = Reflect.field(json,field);
			var dets1 = data2;
			if(dets1 != null) {
				var key = dets1.appid;
				if(__map_reserved[key] != null) {
					details.setReserved(key,dets1);
				} else {
					details.h[key] = dets1;
				}
			}
		} else if(field == "wishlist") {
			var data3 = Reflect.field(json,field);
			wishlist = Data.parseWishlist(data3);
		} else {
			var arr1 = Reflect.field(json,field);
			if(arr1 != null) {
				if(__map_reserved[field] != null) {
					map.setReserved(field,arr1);
				} else {
					map.h[field] = arr1;
				}
			}
		}
	}
	return { map : map, tags : tags, keyTags : keyTags, details : details, storeItemData : storeItemData, wishlist : wishlist};
};
Data.getStarterApps = function(callback) {
	Data.request("dbstarterapps",[],function(data) {
		var json = JSON.parse(data);
		var appids = json.appids;
		var details = json.details;
		if(appids == null) {
			appids = [];
		}
		if(details == null) {
			details = [];
		}
		callback(appids,details);
	},function(error) {
		callback([],[]);
	});
};
Data.randomInteger = function(min,max) {
	return (Math.random() * js_Boot.__cast(1 + max - min , Float) | 0) + min;
};
Data.shuffle = function(list) {
	var _g1 = 0;
	var _g = list.length - 1;
	while(_g1 < _g) {
		var i = _g1++;
		var ii = list.length - 1 - i;
		if(ii > 1) {
			var j = Math.random() * js_Boot.__cast(1 + ii , Float) | 0;
			var temp = list[j];
			list[j] = list[ii];
			list[ii] = temp;
		}
	}
	return list;
};
Data.getDetailsFullFat = function(appid,callback) {
	if(appid == "" || appid == null) {
		callback(null);
		return;
	}
	Data.request("dbdetailsfullfat/" + appid,[],function(data) {
		var json = JSON.parse(data);
		callback(json);
	},function(error) {
		callback(null);
	});
};
Data.getDetails = function(appid,callback) {
	if(appid == "" || appid == null) {
		callback(null);
		return;
	}
	Data.request("dbdetails/" + appid,[],function(data) {
		var json = JSON.parse(data);
		callback(json);
	},function(error) {
		callback(null);
	});
};
Data.getDetailsMulti = function(appids,callback) {
	var allEmpty = true;
	var _g = 0;
	while(_g < appids.length) {
		var appid = appids[_g];
		++_g;
		if(appid != "" && appid != null) {
			allEmpty = false;
		}
	}
	if(allEmpty) {
		var data = "[";
		var _g1 = 0;
		var _g2 = appids.length;
		while(_g1 < _g2) {
			var i = _g1++;
			data += "[]";
			if(i != appids.length - 1) {
				data += ",";
			}
		}
		data += "]";
		var json = JSON.parse(data);
		var arr = json;
		callback(arr);
		return;
	}
	var arr1 = appids.join("-");
	Data.request("dbdetailsmulti/" + arr1,[],function(data1) {
		var json1 = null;
		var arr2 = null;
		try {
			json1 = JSON.parse(data1);
			arr2 = json1;
		} catch( msg ) {
			if (msg instanceof js__$Boot_HaxeError) msg = msg.val;
			console.log("getDetailsMulti(" + Std.string(appids) + ") ERROR(" + Std.string(msg) + ") parsing data:\n" + data1);
		}
		callback(arr2);
	},function(error) {
		callback(null);
	});
};
Data.setCookie = function(name,value) {
	var expireDelay = 2592000;
	js_Cookie.set(name,value,expireDelay);
};
Data.getCookie = function(name) {
	return js_Cookie.get(name);
};
Data.request = function(url,params,onData,onError) {
	var href = window.location.href;
	var hrefBits = href.split("/");
	var labsIndex = hrefBits.indexOf("labs");
	hrefBits.splice(labsIndex + 1,hrefBits.length);
	href = hrefBits.join("/");
	url = href + "/" + url;
	var query = new haxe_Http(url);
	var _g = 0;
	while(_g < params.length) {
		var param = params[_g];
		++_g;
		query.addParameter(param.name,param.value);
	}
	query.onStatus = function(i) {
		if(i != 200) {
			onError("HTTP Status " + i);
		}
	};
	query.onData = function(data) {
		onData(data);
	};
	query.onError = function(error) {
		console.log("HTTP Error = " + Std.string(error));
		onError(error);
	};
	query.request(true);
};
Data.jsonToMapStrStr = function(json) {
	var map = new haxe_ds_StringMap();
	if(json == null) {
		return map;
	}
	var _g = 0;
	var _g1 = Reflect.fields(json);
	while(_g < _g1.length) {
		var field = _g1[_g];
		++_g;
		if(field != null && field != "") {
			var value = Std.string(Reflect.field(json,field));
			if(__map_reserved[field] != null) {
				map.setReserved(field,value);
			} else {
				map.h[field] = value;
			}
		}
	}
	return map;
};
Data.jsonToMapStrArrOfStr = function(json) {
	var map = new haxe_ds_StringMap();
	if(json == null) {
		return map;
	}
	var _g = 0;
	var _g1 = Reflect.fields(json);
	while(_g < _g1.length) {
		var field = _g1[_g];
		++_g;
		if(field != null && field != "") {
			var values = Reflect.field(json,field);
			if(values != null) {
				if(__map_reserved[field] != null) {
					map.setReserved(field,values);
				} else {
					map.h[field] = values;
				}
			}
		}
	}
	return map;
};
Data.cheapIndexOf = function(arr,value) {
	var _g1 = 0;
	var _g = arr.length;
	while(_g1 < _g) {
		var i = _g1++;
		var arrValue = arr[i];
		if(arrValue == value) {
			return i;
		}
	}
	return -1;
};
var EReg = function(r,opt) {
	this.r = new RegExp(r,opt.split("u").join(""));
};
EReg.__name__ = true;
EReg.prototype = {
	match: function(s) {
		if(this.r.global) {
			this.r.lastIndex = 0;
		}
		this.r.m = this.r.exec(s);
		this.r.s = s;
		return this.r.m != null;
	}
	,__class__: EReg
};
var EggTimer = function(msPerTick,ticks,callback,clearOnStop,stopOnSuccess,failsafe) {
	if(failsafe == null) {
		failsafe = 999;
	}
	if(stopOnSuccess == null) {
		stopOnSuccess = false;
	}
	if(clearOnStop == null) {
		clearOnStop = false;
	}
	this.interval = -1;
	this.failsafeCounter = -1;
	this.failsafe = -1;
	this.msPerTick = msPerTick;
	this.ticks = ticks;
	this.clearOnStop = clearOnStop;
	this.msMax = msPerTick * ticks;
	this.msRemaining = this.msMax;
	this.callback = callback;
	this.stopOnSuccess = stopOnSuccess;
	this.failsafe = failsafe;
	this.failsafeCounter = failsafe;
};
EggTimer.__name__ = true;
EggTimer.runUntilItWorks = function(delayInMs,callback,failsafe) {
	if(failsafe == null) {
		failsafe = 999;
	}
	var e = new EggTimer(delayInMs,-1,callback,true,true,failsafe);
	e.start();
};
EggTimer.runOnce = function(delayInMs,callback) {
	var e = new EggTimer(delayInMs,1,callback,true);
	e.start();
};
EggTimer.run = function(delayInMs,ticks,callback) {
	var e = new EggTimer(delayInMs,ticks,callback);
	e.start();
};
EggTimer.prototype = {
	stop: function() {
		if(this.interval != -1) {
			this.clearInterval();
		}
		this.msRemaining = this.msMax;
		this.failsafeCounter = this.failsafe;
		if(this.clearOnStop) {
			this.callback = null;
		}
	}
	,start: function() {
		this.msRemaining = this.msMax;
		if(this.interval != -1) {
			this.clearInterval();
		}
		this.startNewInterval();
	}
	,onTick: function() {
		if(this.callback != null) {
			var success = this.callback();
			if(this.stopOnSuccess && success) {
				this.stop();
				return;
			}
		}
		this.msRemaining -= this.msPerTick;
		if(this.msRemaining <= 0 && this.ticks != -1) {
			this.msRemaining = 0;
			this.stop();
			return;
		}
		this.failsafeCounter--;
		if(this.failsafeCounter < 0) {
			this.stop();
		}
	}
	,startNewInterval: function() {
		this.interval = window.setInterval($bind(this,this.onTick),this.msPerTick);
	}
	,clearInterval: function() {
		window.clearInterval(this.interval);
		this.interval = -1;
	}
	,__class__: EggTimer
};
var GlobalStuff = function() { };
GlobalStuff.__name__ = true;
GlobalStuff.show = function(element,b) {
	if(element == null) {
		return;
	}
	if(!b) {
		GlobalStuff.addClass(element,"hide-fancy");
	} else {
		GlobalStuff.removeClass(element,"hide-fancy");
	}
};
GlobalStuff.hardHide = function(element) {
	if(element == null) {
		return;
	}
	var style = element.getAttribute("style");
	var styleArr = style.split(";");
	var newStyleArr = [];
	var _g = 0;
	while(_g < styleArr.length) {
		var styleBit = styleArr[_g];
		++_g;
		var bits = styleBit.split(":");
		var i = bits[0].indexOf("display");
		if(i != -1) {
			bits[1] = "none";
		}
		newStyleArr.push(bits.join(": "));
	}
	var newStyle = newStyleArr.join("; ");
	element.setAttribute("style",newStyle);
};
GlobalStuff.hardShow = function(element) {
	if(element == null) {
		return;
	}
	var style = element.getAttribute("style");
	var styleArr = style.split(";");
	var newStyleArr = [];
	var _g = 0;
	while(_g < styleArr.length) {
		var styleBit = styleArr[_g];
		++_g;
		var bits = styleBit.split(":");
		var i = bits[0].indexOf("display");
		if(i != -1) {
			bits[1] = "block";
		}
		newStyleArr.push(bits.join(": "));
	}
	var newStyle = newStyleArr.join("; ");
	element.setAttribute("style",newStyle);
};
GlobalStuff.hasClass = function(element,className) {
	if(element == null) {
		return false;
	}
	var classStr = element.getAttribute("class");
	if(classStr != "" && classStr != null) {
		var classes = classStr.split(" ");
		if(classes.length > 0) {
			if(classes.indexOf(className) != -1) {
				return true;
			}
		}
	}
	return false;
};
GlobalStuff.addClass = function(element,className) {
	if(element == null) {
		return;
	}
	var classStr = element.getAttribute("class");
	if(classStr != "" && classStr != null) {
		var classes = classStr.split(" ");
		if(classes.length > 0) {
			if(classes.indexOf(className) == -1) {
				classes.push(className);
				element.setAttribute("class",classes.join(" "));
			}
		}
	}
};
GlobalStuff.removeClass = function(element,className) {
	if(element == null) {
		return;
	}
	var classStr = element.getAttribute("class");
	if(classStr != "" && classStr != null) {
		var classes = classStr.split(" ");
		if(classes.length > 0) {
			if(classes.indexOf(className) != -1) {
				HxOverrides.remove(classes,className);
				element.setAttribute("class",classes.join(" "));
			}
		}
	}
};
GlobalStuff.RedirectToLogin = function() {
	var title = "Title";
	var desc = "Lorem ipsum dolor sit amet.";
	
			var dialog = ShowConfirmDialog(title, desc);
			dialog.done(function() {
				
			});
		;
};
GlobalStuff.bindHoverEvents = function(elementId,appIdInt,showTooltip,onMouseEnterCallback,onMouseLeaveCallback) {
	if(GlobalStuff.map == null) {
		GlobalStuff.map = new haxe_ds_StringMap();
	}
	var _this = GlobalStuff.map;
	if(__map_reserved[elementId] != null ? _this.existsReserved(elementId) : _this.h.hasOwnProperty(elementId)) {
		var test = window.document.getElementById(elementId);
		var _this1 = GlobalStuff.map;
		var old = __map_reserved[elementId] != null ? _this1.getReserved(elementId) : _this1.h[elementId];
		$J($(elementId)).data( 'oHoverState', null);
	}
	var onMouseEnter = function(event) {
		if(onMouseEnterCallback != null) {
			onMouseEnterCallback();
		}
		if(showTooltip) {
			
					if(appIdInt != null){
						GameHover( $(elementId), event, $J('#global_hover'), GStoreItemData.GetHoverParams(appIdInt));
					}
				;
		}
	};
	var onMouseLeave = function(event1) {
		if(onMouseLeaveCallback != null) {
			onMouseLeaveCallback();
		}
		if(showTooltip) {
			
					HideGameHover( $(elementId), event, $J('#global_hover') );
				;
		}
	};
	var el = window.document.getElementById(elementId);
	if(el != null) {
		el.onmouseenter = onMouseEnter;
		el.onmouseleave = onMouseLeave;
		var _this2 = GlobalStuff.map;
		if(__map_reserved[elementId] != null) {
			_this2.setReserved(elementId,el);
		} else {
			_this2.h[elementId] = el;
		}
	}
};
GlobalStuff.filterItemsForDisplay = function(storeItemData) {
	var results = null;
	var rgApps = storeItemData.rgApps;
	var apps = [];
	var _g = 0;
	var _g1 = Reflect.fields(rgApps);
	while(_g < _g1.length) {
		var field = _g1[_g];
		++_g;
		apps.push({ appid : field, bundleid : "", packageId : ""});
	}
	
			
			GStoreItemData.AddStoreItemDataSet(storeItemData);
			
			results = GDynamicStorePage.FilterItemsForDisplay(apps, null, 
				{
					games_already_in_library: false, 
					localized: true,
				}, 
				200, 8
			);
		;
	var newApps = [];
	var _g2 = 0;
	while(_g2 < results.length) {
		var result = results[_g2];
		++_g2;
		newApps.push(result.appid);
	}
	return newApps;
};
GlobalStuff.injectSearch = function() {
	injectSearch();
};
var HxOverrides = function() { };
HxOverrides.__name__ = true;
HxOverrides.strDate = function(s) {
	var _g = s.length;
	switch(_g) {
	case 8:
		var k = s.split(":");
		var d = new Date();
		d["setTime"](0);
		d["setUTCHours"](k[0]);
		d["setUTCMinutes"](k[1]);
		d["setUTCSeconds"](k[2]);
		return d;
	case 10:
		var k1 = s.split("-");
		return new Date(k1[0],k1[1] - 1,k1[2],0,0,0);
	case 19:
		var k2 = s.split(" ");
		var y = k2[0].split("-");
		var t = k2[1].split(":");
		return new Date(y[0],y[1] - 1,y[2],t[0],t[1],t[2]);
	default:
		throw new js__$Boot_HaxeError("Invalid date format : " + s);
	}
};
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) {
		return undefined;
	}
	return x;
};
HxOverrides.substr = function(s,pos,len) {
	if(len == null) {
		len = s.length;
	} else if(len < 0) {
		if(pos == 0) {
			len = s.length + len;
		} else {
			return "";
		}
	}
	return s.substr(pos,len);
};
HxOverrides.remove = function(a,obj) {
	var i = a.indexOf(obj);
	if(i == -1) {
		return false;
	}
	a.splice(i,1);
	return true;
};
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
};
var Lambda = function() { };
Lambda.__name__ = true;
Lambda.exists = function(it,f) {
	var x = $iterator(it)();
	while(x.hasNext()) {
		var x1 = x.next();
		if(f(x1)) {
			return true;
		}
	}
	return false;
};
var List = function() {
	this.length = 0;
};
List.__name__ = true;
List.prototype = {
	push: function(item) {
		var x = new _$List_ListNode(item,this.h);
		this.h = x;
		if(this.q == null) {
			this.q = x;
		}
		this.length++;
	}
	,iterator: function() {
		return new _$List_ListIterator(this.h);
	}
	,__class__: List
};
var _$List_ListNode = function(item,next) {
	this.item = item;
	this.next = next;
};
_$List_ListNode.__name__ = true;
_$List_ListNode.prototype = {
	__class__: _$List_ListNode
};
var _$List_ListIterator = function(head) {
	this.head = head;
};
_$List_ListIterator.__name__ = true;
_$List_ListIterator.prototype = {
	hasNext: function() {
		return this.head != null;
	}
	,next: function() {
		var val = this.head.item;
		this.head = this.head.next;
		return val;
	}
	,__class__: _$List_ListIterator
};
var Main = function() { };
Main.__name__ = true;
Main.main = function() {
	Main.userVariables = Data.getVariables();
	var _this = Main.userVariables;
	if(__map_reserved["killtags"] != null ? _this.existsReserved("killtags") : _this.h.hasOwnProperty("killtags")) {
		Main.FEATURE_FLAG_KILLABLE_TAGS = true;
	}
	var _this1 = Main.userVariables;
	if(__map_reserved["ml"] != null ? _this1.existsReserved("ml") : _this1.h.hasOwnProperty("ml")) {
		Main.FEATURE_FLAG_ML_RECOMMENDER = true;
	}
	if(Main.FEATURE_FLAG_ML_RECOMMENDER) {
		Main.columnHeaders = ["reccats","recml","recgems","recdefault"];
	}
	Main.recordOriginalHistoryPath(Main.userVariables);
	var hash = window.location.hash;
	if(hash != "") {
		hash = StringTools.replace(hash,"#","");
		Main.APPID = Main.sanitizeAppId(hash);
	}
	window.onpopstate = Main.onPopState;
	window.onhashchange = Main.onHashChange;
	GDynamicStore.OnReady(Main.onLoad);
};
Main.sanitizeAppId = function(hash) {
	var bits = hash.split(",");
	var newBits = [];
	var _g = 0;
	while(_g < bits.length) {
		var bit = bits[_g];
		++_g;
		var newBit = Std.parseInt(bit);
		if(newBits != null) {
			newBits.push(newBit);
		}
	}
	return newBits.join(",");
};
Main.getCurrentHistoryPath = function(useAsFocusedApp,useAsBreadcrumbs) {
	var history = "#";
	var i = 0;
	var theFocusedApp = useAsFocusedApp != null ? useAsFocusedApp : Main.focusedEntry != null ? Main.focusedEntry.appid : "";
	var theBreadcrumbs = useAsBreadcrumbs != null ? useAsBreadcrumbs : Main.breadcrumbs;
	var appids = theBreadcrumbs == null ? [] : theBreadcrumbs.slice();
	while(appids.indexOf("") != -1) HxOverrides.remove(appids,"");
	if(theFocusedApp != null && theFocusedApp != "") {
		appids.push(theFocusedApp);
	}
	appids.reverse();
	var appidStr = appids.join(",");
	history += appidStr;
	if(history != "#") {
		history = Main.originalHistory + history;
	} else {
		history = Main.originalHistory;
	}
	if(history == "") {
		history = "#";
	}
	return history;
};
Main.recordOriginalHistoryPath = function(vars) {
	var str = "";
	var key = vars.keys();
	while(key.hasNext()) {
		var key1 = key.next();
		if(key1 != "appid") {
			if(str == "") {
				str += "?";
			} else {
				str += "&";
			}
			var value = __map_reserved[key1] != null ? vars.getReserved(key1) : vars.h[key1];
			if(value.indexOf("#") != -1) {
				value = value.split("#")[0];
			}
			str += key1 + "=" + value;
		}
	}
	Main.originalHistory = str;
};
Main.base64Encode = function(n) {
	var chars = "";
	while(n > 0) {
		var digit = n % 64;
		var $char = Main.baseMap.charAt(digit);
		chars = $char + chars;
		n = Math.floor(n / 64);
	}
	return chars;
};
Main.base64Decode = function(str) {
	var value = 0.0;
	var place = 0;
	while(str.length > 0) {
		var $char = str.charAt(str.length - 1);
		str = HxOverrides.substr(str,0,str.length - 1);
		var num = Main.baseMap.indexOf($char);
		value += num * Math.pow(64,place);
		++place;
	}
	return value | 0;
};
Main.onHashChange = function(event) {
	if(window.location.hash == "") {
		Main.clickBreadcrumb(-1);
	}
};
Main.clearHistoryStates = function() {
	Main.ignorePopStateEvents = true;
	var len = window.history.length;
	Main.ignorePopStateEvents = false;
};
Main.onPopState = function(event) {
	if(Main.ignorePopStateEvents) {
		return;
	}
	if(!Main.justClickedAppBack && !Main.justClickedBreadcrumb) {
		Main.back();
	} else {
		var path = Main.getCurrentHistoryPath();
		window.history.replaceState(null,"",path);
		Main.justClickedBreadcrumb = false;
		Main.justClickedAppBack = false;
	}
};
Main.getBlankDetails = function() {
	return [null,null,null,null,null,null,null,null,null];
};
Main.getBlankAppIds = function() {
	return ["","","","","","","","",""];
};
Main.getTestAppIds = function() {
	return ["670750","243220","512790","866440","258520","251110","383870","757480","239030"];
};
Main.getPreviousAppIds = function() {
	var appids = [];
	var _g = 0;
	var _g1 = Main.breadcrumbBoxEntries;
	while(_g < _g1.length) {
		var arr = _g1[_g];
		++_g;
		var _g2 = 0;
		while(_g2 < arr.length) {
			var entry = arr[_g2];
			++_g2;
			var appid = entry.appid == null ? "null" : "" + entry.appid;
			if(appid != "" && appids.indexOf(appid) == -1) {
				appids.push(appid);
			}
		}
	}
	var _g3 = 0;
	var _g11 = Main.refreshHistory;
	while(_g3 < _g11.length) {
		var arr1 = _g11[_g3];
		++_g3;
		var _g21 = 0;
		while(_g21 < arr1.length) {
			var entry1 = arr1[_g21];
			++_g21;
			var appid1 = entry1.appid == null ? "null" : "" + entry1.appid;
			if(appid1 != "" && appids.indexOf(appid1) == -1) {
				appids.push(appid1);
			}
		}
	}
	var _g4 = 0;
	var _g12 = Main.breadcrumbs;
	while(_g4 < _g12.length) {
		var breadcrumbid = _g12[_g4];
		++_g4;
		var appid2 = breadcrumbid == null ? "null" : "" + breadcrumbid;
		if(appid2 != "" && appids.indexOf(appid2) == -1) {
			appids.push(appid2);
		}
	}
	if(Main.focusedEntry != null) {
		var appid3 = Std.string(Main.focusedEntry.appid);
		if(appid3 != "" && appids.indexOf(appid3) == -1) {
			appids.push(appid3);
		}
	}
	return appids;
};
Main.compareAppLists = function(appids,others) {
	var str1 = appids != null ? appids.join(",") : "null";
	var str2 = others != null ? others.join(",") : null;
	return str1 == str2;
};
Main.getBoxEntriesFor = function(appids,details,recommenders,callback) {
	var boxEntries = [];
	var matchesStarters = Main.compareAppLists(appids,Main.STARTER_APPS);
	if(matchesStarters) {
		Main.STARTER_BOXES = [];
	}
	var _g = 0;
	while(_g < 9) {
		var i = _g++;
		boxEntries.push(new BoxEntry());
	}
	var resolveDetails = function(details1) {
		if(details1 == null) {
			console.log("ERROR: couldn't get details for (" + Std.string(appids) + ")");
		} else {
			var i1 = 0;
			var _g1 = 0;
			while(_g1 < details1.length) {
				var detail = details1[_g1];
				++_g1;
				if(i1 >= 9) {
					break;
				}
				var isError = Object.prototype.hasOwnProperty.call(detail,"appid") == false;
				if(isError) {
					boxEntries[i1].appid = "";
					Main.setBoxDetails(boxEntries[i1],null);
					boxEntries[i1].recommender = "";
					++i1;
				} else {
					var appid = detail.appid;
					if(detail != null) {
						var arrIndex = -1;
						var _g2 = 0;
						var _g11 = appids.length;
						while(_g2 < _g11) {
							var j = _g2++;
							var otherappid = appids[j];
							if(appid == otherappid) {
								arrIndex = j;
								break;
							}
						}
						boxEntries[i1].appid = appid;
						Main.setBoxDetails(boxEntries[i1],detail);
						boxEntries[i1].recommender = arrIndex != -1 ? recommenders[arrIndex] : "";
						++i1;
					}
				}
			}
			if(matchesStarters) {
				var _g3 = 0;
				while(_g3 < boxEntries.length) {
					var entry = boxEntries[_g3];
					++_g3;
					var entry2 = entry.copy();
					Main.STARTER_BOXES.push(entry2);
				}
			}
			callback(boxEntries);
		}
	};
	var missingAppids = [];
	var _g12 = 0;
	var _g4 = appids.length;
	while(_g12 < _g4) {
		var i2 = _g12++;
		var appid1 = appids[i2];
		var detail1 = details[i2];
		if(detail1 == null) {
			missingAppids.push(appid1);
		}
	}
	if(missingAppids.length > 0) {
		Data.getDetailsMulti(missingAppids,function(details2) {
			var _g13 = 0;
			var _g5 = appids.length;
			while(_g13 < _g5) {
				var i3 = _g13++;
				var appid2 = appids[i3];
				var mindex = missingAppids.indexOf(appid2);
				if(mindex != -1) {
					var mdetails = details2[mindex];
					details2[i3] = mdetails;
				}
			}
			resolveDetails(details2);
		});
	} else {
		resolveDetails(details);
	}
};
Main.showBoxes = function(show) {
	var allNull = true;
	var _g1 = 0;
	var _g = Main.boxEntries.length;
	while(_g1 < _g) {
		var i = _g1++;
		if(Main.boxEntries[i] != null && Main.boxEntries[i].appid != "") {
			allNull = false;
		}
		Render.showBox(i,show);
	}
	if(!allNull && show) {
		EggTimer.runUntilItWorks(10,function() {
			var success = Render.hydrateBoxes();
			return success;
		});
	}
};
Main.renderBreadcrumbs = function() {
	var forShow = Main.breadcrumbs.slice();
	var forShowTitles = Main.breadcrumbTitles.slice();
	if(Main.focusedEntry != null) {
		forShow.push(Main.focusedEntry.appid);
		forShowTitles.push(Main.focusedEntry.title);
	}
	var breadcrumbNode = window.document.getElementById("breadcrumbs");
	breadcrumbNode.innerHTML = Render.breadcrumbsContent(forShow,forShowTitles);
};
Main.renderBackRefreshButtons = function() {
	var enableBack = Main.refreshHistory.length > 0 || Main.breadcrumbs.length > 0 || Main.focusedEntry != null;
	var enableRefresh = Main.lastMatchCount >= 9 || Main.lastMatchCount == -1;
	var back = window.document.getElementById("button-back");
	var refresh = window.document.getElementById("button-refresh");
	if(back != null) {
		if(!enableBack) {
			back.setAttribute("class","button-back button-round disabled");
		} else {
			back.setAttribute("class","button-back button-round");
		}
	}
	if(refresh != null) {
		if(!enableRefresh) {
			refresh.setAttribute("class","button-refresh button-round disabled");
		} else {
			refresh.setAttribute("class","button-refresh button-round");
		}
	}
};
Main.renderFocusedBox = function(appidSafeguard,iterations) {
	if(iterations == null) {
		iterations = 0;
	}
	if(appidSafeguard == null) {
		appidSafeguard = "";
	}
	if(iterations > 1) {
		return;
	}
	if(appidSafeguard != "") {
		if(appidSafeguard != Main.focusedEntry.appid) {
			return;
		}
	}
	if(Main.focusedEntry != null) {
		if(Main.focusedEntry.screenshots == null || Main.focusedEntry.screenshots.length < 5) {
			if(iterations < 1) {
				Data.getDetailsFullFat(Main.focusedEntry.appid,function(details) {
					if(details != null) {
						Main.focusedEntry.screenshots = details.screenshots;
					}
					if(Main.focusedEntry.screenshots == null || Main.focusedEntry.screenshots.length == 0) {
						Main.focusedEntry.screenshots = [""];
					}
					Main.renderFocusedBox(Main.focusedEntry.appid,iterations + 1);
				});
				return;
			}
		} else if(Main.focusedEntry.screenshots.length == 1 && Main.focusedEntry.screenshots[0] == "") {
			Main.focusedEntry.screenshots = [];
		}
	}
	var focusBoxNode = window.document.getElementById("box-focused");
	var appid = Main.focusedEntry != null ? Main.focusedEntry.appid : "";
	if(appid == "") {
		focusBoxNode.innerHTML = Render.searchBoxContent();
		var searchNode = window.document.getElementById("search_suggestion_contents");
		if(Main.searchObserver != null) {
			Main.searchObserver.disconnect();
			Main.searchObserver = null;
			Main.searchObserver = new MutationObserver(Main.onMutateSearchNode);
			Main.searchObserver.observe(searchNode,{ attributes : true, childList : true, subtree : true});
			GlobalStuff.injectSearch();
		}
	} else {
		focusBoxNode.innerHTML = Render.focusBoxContent(Main.focusedEntry);
	}
	var searchNameNode = window.document.getElementById("search-name");
	if(searchNameNode != null) {
		searchNameNode.focus();
	}
};
Main.countHistory = function() {
	return Main.breadcrumbs.length + (Main.focusedEntry != null ? 1 : 0);
};
Main.renderHeader = function(i) {
	var headerId = "box-header-" + i;
	var headerNode = window.document.getElementById(headerId);
	if(headerNode != null) {
		var headerTitle = Render.similarBlurb(Main.columnHeaders[i]).title;
		headerNode.innerHTML = "<a href=\"javascript:Main.clickColumn(" + i + ")\"><p>" + headerTitle + "</p></a>";
	}
};
Main.renderBoxes = function(sink,justThese) {
	if(sink == null) {
		sink = false;
	}
	var indeces = justThese;
	if(indeces == null) {
		indeces = [];
		var _g1 = 0;
		var _g = Main.boxEntries.length;
		while(_g1 < _g) {
			var i = _g1++;
			indeces.push(i);
		}
	}
	var _g2 = 0;
	while(_g2 < indeces.length) {
		var i1 = indeces[_g2];
		++_g2;
		var boxNode = window.document.getElementById("box-" + i1);
		if(boxNode != null) {
			var entry = Main.boxEntries[i1];
			entry.disabledTags = Main.focusedEntry != null && Main.focusedEntry.disabledTags != null ? Main.focusedEntry.disabledTags.slice() : [];
			boxNode.innerHTML = Render.boxContent(i1,entry,sink,Main.countHistory() == 0);
			if(entry == null || entry.appid == null || entry.appid == "") {
				GlobalStuff.addClass(boxNode,"empty-result");
			} else {
				GlobalStuff.removeClass(boxNode,"empty-result");
			}
		}
	}
	var html = Render.columnHeadersContent(Main.focusedEntry == null);
	var node = window.document.getElementById("header-container");
	if(node != null) {
		node.innerHTML = html;
	}
};
Main.getStarterApps = function(callback) {
	Data.getStarterApps(function(startIds,startDetails) {
		if(startIds.length < 9) {
			var testIds = Main.getTestAppIds();
			while(startIds.length < 9) {
				var testId = testIds.shift();
				startIds.push(testId);
				startDetails.push(null);
			}
		}
		Main.STARTER_APPS = startIds.slice();
		callback(startIds,startDetails);
	});
};
Main.renderPage = function(callback) {
	Main.domRoot = window.document.getElementById("diving-bell-content");
	if(Main.boxEntries == null) {
		var recommenders = ["","","","","","","","",""];
		var loadIds = function(appids,appdetails) {
			Main.getBoxEntriesFor(appids,appdetails,recommenders,function(entries) {
				Main.boxEntries = entries;
				Main._renderPage();
				Main.updateBoxes();
				callback();
			});
		};
		if(Main.APPID == "") {
			Main.getStarterApps(loadIds);
		} else {
			Main.STARTER_APPS = Main.getBlankAppIds();
			loadIds(Main.getBlankAppIds(),Main.getBlankDetails());
		}
	} else {
		Main._renderPage();
		callback();
	}
};
Main._renderPage = function() {
	Main.clear();
	var tmp = Render.breadcrumbs();
	var tmp1 = Render.grid(Main.boxEntries,Main.focusedEntry,false,Main.countHistory() == 0);
	Main.domRoot.innerHTML = tmp + tmp1;
	var searchNameNode = window.document.getElementById("search-name");
	if(searchNameNode != null) {
		searchNameNode.focus();
	}
};
Main.init = function(callback) {
	Data.getBasicStuff(function(basicStuff) {
		Main.baseURL = basicStuff.baseUrl;
		Main.cdnURL = basicStuff.cdnUrl;
		Main.tagDB = new TagDB(basicStuff.tagMap,basicStuff.tags);
		Main.prefs = basicStuff.prefs;
		Main.locs = basicStuff.locMap;
		Main.LOGGED_IN = basicStuff.loggedIn;
		Main.wishlist = basicStuff.wishlist;
		callback();
	});
};
Main.isOwned = function(appid) {
	if(Main.prefs == null) {
		return false;
	}
	var appid_i = Std.parseInt(appid);
	var _g = 0;
	var _g1 = Main.prefs.owned_apps;
	while(_g < _g1.length) {
		var otherappid_i = _g1[_g];
		++_g;
		if(otherappid_i == appid_i) {
			return true;
		}
	}
	return false;
};
Main.onWishlist = function(appid) {
	var _this = Main.wishlist;
	if(__map_reserved[appid] != null ? _this.existsReserved(appid) : _this.h.hasOwnProperty(appid)) {
		return true;
	}
	if(Data.cheapIndexOf(Main.tempWishlist,appid) != -1) {
		return true;
	}
	return false;
};
Main.loc = function(str) {
	var _this = Main.locs;
	if(__map_reserved[str] != null ? _this.existsReserved(str) : _this.h.hasOwnProperty(str)) {
		var _this1 = Main.locs;
		if(__map_reserved[str] != null) {
			return _this1.getReserved(str);
		} else {
			return _this1.h[str];
		}
	}
	return str;
};
Main.onLoad = function() {
	Main.init(function() {
		Main.renderPage(function() {
			Main.hideMainThrobber();
			var searchNode = window.document.getElementById("search_suggestion_contents");
			if(searchNode != null) {
				Main.searchObserver = new MutationObserver(Main.onMutateSearchNode);
				Main.searchObserver.observe(searchNode,{ attributes : true, childList : true, subtree : true});
				Main.updateBoxesHover();
				GlobalStuff.injectSearch();
			}
			Main.renderBackRefreshButtons();
			var bodyNode = window.document.getElementsByTagName("body")[0];
			Main.hoverAttachObserver = new MutationObserver(Main.onMutateBody);
			Main.hoverAttachObserver.observe(bodyNode,{ attributes : false, childList : true, subtree : false});
			if(Main.APPID != "") {
				EggTimer.runOnce(10,function() {
					Main.firstLoadApp(Main.APPID);
					return true;
				});
			}
		});
	});
};
Main.firstLoadApp = function(appid) {
	Main.MICROTRAILERS = Data.getCookie("deep_dive_show_microtrailers") != "false";
	Main.setMicrotrailers(Main.MICROTRAILERS);
	var currApp = appid;
	var apps = appid.split(",");
	if(apps.length > 0) {
		while(apps.indexOf("") != -1) HxOverrides.remove(apps,"");
		var history = apps.slice();
		var states = [];
		states.push(Main.originalHistory);
		var _g = 0;
		while(_g < states.length) {
			var state = states[_g];
			++_g;
			if(state == "" || state == null) {
				continue;
			}
		}
		currApp = apps.shift();
		Main.breadcrumbs = apps.slice();
		Main.breadcrumbs.reverse();
		Main.breadcrumbs.unshift("");
		var _g1 = 0;
		var _g2 = Main.breadcrumbs.length;
		while(_g1 < _g2) {
			var i = _g1++;
			Main.breadcrumbBoxEntries.push([]);
			Main.breadcrumbTitles.push("");
		}
	}
	Main.focus(currApp);
};
Main.onMutateBody = function(mutationList,observer) {
	var hoverNode = window.document.getElementById("global_hover");
	if(hoverNode != null) {
		Main.hoverObserver = new MutationObserver(Main.onMutateHoverNode);
		Main.hoverObserver.observe(hoverNode,{ attributes : false, childList : true, subtree : true});
	}
};
Main.onMutateHoverNode = function(mutationList,observer) {
	var globalHoverContentElement = window.document.getElementById("global_hover_content");
	var hoverAppNode = null;
	var hoverAppId = "";
	var _g = 0;
	while(_g < mutationList.length) {
		var mutation = mutationList[_g];
		++_g;
		if(mutation != null && mutation.addedNodes != null && mutation.addedNodes.length > 0) {
			var _g2 = 0;
			var _g1 = mutation.addedNodes.length;
			while(_g2 < _g1) {
				var i = _g2++;
				var addedNode = mutation.addedNodes.item(i);
				if(addedNode.nodeType == 1) {
					var element = addedNode;
					var id = element.attributes.getNamedItem("id");
					var idValue = "";
					if(id != null) {
						idValue = id.value;
					}
					if(idValue.indexOf("hover_app_") != -1) {
						hoverAppId = StringTools.replace(idValue,"hover_app_","");
						hoverAppNode = element;
					}
				}
			}
		}
	}
	var boxEntry = null;
	var _g3 = 0;
	var _g11 = Main.boxEntries;
	while(_g3 < _g11.length) {
		var entry = _g11[_g3];
		++_g3;
		if(hoverAppId == entry.appid) {
			boxEntry = entry;
			break;
		}
	}
	if(boxEntry == null) {
		if(Main.focusedEntry != null && hoverAppId == Main.focusedEntry.appid) {
			boxEntry = Main.focusedEntry;
		}
	}
	if(hoverAppNode != null && boxEntry != null) {
		if(Main.hoverObserver != null) {
			Main.hoverObserver.disconnect();
			Main.hoverObserver = null;
		}
		var hoverBody2 = hoverAppNode.getElementsByClassName("hover_body")[1];
		if(hoverBody2 != null) {
			hoverBody2.innerHTML = "";
			hoverBody2.remove();
		}
		var descText = boxEntry.shortDescription;
		var title = boxEntry.title;
		var descriptionBlurb = "<div id=\"hover-description-" + hoverAppId + "\" class=\"hover-description\">\r\n\t\t\t\t\t" + descText + "\r\n\t\t\t\t</div>";
		var headerImage = "<div id=\"hover-image-" + hoverAppId + "\" class=\"hover-image\">\r\n\t\t\t\t\t<img src=\"https://steamcdn-a.akamaihd.net/steam/apps/" + hoverAppId + "/header.jpg\" alt=\"" + title + "\" title=\"" + title + "\"/>\r\n\t\t\t\t</div>";
		var similarText = "";
		var similar = Render.similarBlurb(boxEntry.recommender);
		if(Main.focusedEntry == null || boxEntry.appid != Main.focusedEntry.appid) {
			var similarTitle = similar.title;
			var similarBlurb = similar.blurb;
			similarText = "<div id=\"hover-similar-title-" + hoverAppId + "\" class=\"hover-similar-title\">\r\n\t\t\t\t\t<p><em><strong>" + similarTitle + "</strong></em><br/>\r\n\t\t\t\t\t<em>" + similarBlurb + "</em></p>\r\n\t\t\t\t\t</hr>\r\n\t\t\t\t</div>";
		}
		var hoverScreenshots = hoverAppNode.getElementsByClassName("hover_screenshots")[0];
		if(hoverScreenshots != null) {
			hoverScreenshots.insertAdjacentHTML("afterend",descriptionBlurb);
			hoverScreenshots.insertAdjacentHTML("afterend",similarText);
			hoverScreenshots.insertAdjacentHTML("afterend",headerImage);
			hoverScreenshots.innerHTML = "";
			hoverScreenshots.remove();
		}
		var hoverNode = window.document.getElementById("global_hover");
		Main.hoverObserver = new MutationObserver(Main.onMutateHoverNode);
		Main.hoverObserver.observe(hoverNode,{ attributes : false, childList : true, subtree : true});
	}
};
Main.onMutateSearchNode = function(mutationList,observer) {
	if(Main.searchTimer == null) {
		Main.searchTimer = new EggTimer(10,1,function() {
			Main.cleanupSearchNode();
			return true;
		},false);
	}
	Main.searchTimer.start();
};
Main.cleanupSearchNode = function() {
	var searchNode = window.document.getElementById("search_suggestion_contents");
	if(searchNode == null) {
		return;
	}
	var html = searchNode.innerHTML;
	var _g = 0;
	var _g1 = searchNode.children;
	while(_g < _g1.length) {
		var child = _g1[_g];
		++_g;
		if(js_Boot.__instanceof(child,HTMLAnchorElement)) {
			var a = child;
			var link = a.href;
			if(StrTool.isLink(link)) {
				var appid = StrTool.urlToAppid(link);
				a.href = "javascript:Main.focusFromSearch(" + appid + ")";
			}
		}
	}
};
Main.killRefreshHistory = function() {
	Main.refreshHistory = [];
};
Main.killHistory = function() {
	Main.lastMatchCount = 0;
	Main.breadcrumbs = [];
	Main.breadcrumbTitles = [];
	Main.breadcrumbBoxEntries = [];
	Main.refreshHistory = [];
	Main.renderBreadcrumbs();
	Main.renderBackRefreshButtons();
};
Main.hideHover = function() {
	GlobalStuff.bindHoverEvents("box-focused",-1,false);
	var globalHover = window.document.getElementById("global_hover");
	if(globalHover != null) {
		GlobalStuff.hardHide(globalHover);
	}
};
Main.setMicrotrailers = function(b) {
	Main.MICROTRAILERS = b;
	var el = window.document.getElementById("checkbox-microtrailers");
	if(el != null) {
		el.checked = b;
	}
};
Main.plusTag = $hx_exports["Main"]["plusTag"] = function(tagid) {
	if(Main.focusedEntry == null) {
		return;
	}
	if(!Main.FEATURE_FLAG_KILLABLE_TAGS) {
		return;
	}
	var strtagid = tagid == null ? "null" : "" + tagid;
	Main.focusedEntry.boostTag(strtagid);
	Main.onTagPlusMinus();
};
Main.minusTag = $hx_exports["Main"]["minusTag"] = function(tagid) {
	if(Main.focusedEntry == null) {
		return;
	}
	if(!Main.FEATURE_FLAG_KILLABLE_TAGS) {
		return;
	}
	var strtagid = tagid == null ? "null" : "" + tagid;
	Main.focusedEntry.disableTag(strtagid);
	Main.onTagPlusMinus();
};
Main.toggleTag = $hx_exports["Main"]["toggleTag"] = function(tagid) {
	if(Main.focusedEntry == null) {
		return;
	}
	if(!Main.FEATURE_FLAG_KILLABLE_TAGS) {
		return;
	}
	var strtagid = tagid == null ? "null" : "" + tagid;
	Main.focusedEntry.toggleTag(strtagid);
	Main.onTagPlusMinus();
};
Main.onTagPlusMinus = function() {
	var el = window.document.getElementById("box-tags-10");
	var keyAttributes = Main.loc("#labs_deepdive_keytags");
	var tagHTML = Main.focusedEntry.getTagHTML3(keyAttributes,6);
	el.innerHTML = tagHTML;
	Main.killRefreshHistory();
	Main.focus(Main.focusedEntry.appid,null,null,Main.focusedEntry.disabledTags,Main.focusedEntry.boostedTags);
};
Main.toggleMicrotrailers = $hx_exports["Main"]["toggleMicrotrailers"] = function() {
	var el = window.document.getElementById("checkbox-microtrailers");
	if(el != null) {
		Main.MICROTRAILERS = el.checked;
		Data.setCookie("deep_dive_show_microtrailers",Std.string(Main.MICROTRAILERS));
		if(!Main.focusBusy) {
			Render.hydrateBoxes(true);
		}
	}
};
Main.onClickFocusSearch = $hx_exports["Main"]["onClickFocusSearch"] = function() {
	Main.focus("",null,function() {
		Main.renderBackRefreshButtons();
	});
	Main.hideHover();
};
Main.addToWishlist = $hx_exports["Main"]["addToWishlist"] = function(appid) {
	if(Main.tempWishlist != null) {
		if(Main.tempWishlist.indexOf(appid) == -1) {
			Main.tempWishlist.push(appid);
		}
	}
	var id = "wishlist-" + appid;
	var button = window.document.getElementById(id);
	Data.getLinkParam("game-add-to-wishlist-deepdive",function(linkParam) {
		if(linkParam != null) {
			AddToWishlistButton(button,appid,linkParam);
		}
	});
};
Main.allBlank = function(arr) {
	var result = true;
	var _g = 0;
	while(_g < arr.length) {
		var entry = arr[_g];
		++_g;
		if(entry != "" && entry != null) {
			result = false;
			break;
		}
	}
	return result;
};
Main.viewDetails = $hx_exports["Main"]["viewDetails"] = function(appid) {
};
Main.back = $hx_exports["Main"]["back"] = function() {
	if(Main.focusedEntry == null) {
		Main.clickBreadcrumb(Main.breadcrumbs.length - 1);
		return;
	}
	var currApp = Main.focusedEntry.appid;
	var theIndex = -1;
	Main.justClickedAppBack = true;
	if(Main.refreshHistory.length == 0) {
		var _g1 = 0;
		var _g = Main.breadcrumbs.length;
		while(_g1 < _g) {
			var i = _g1++;
			var j = Main.breadcrumbs.length - 1 - i;
			var backTo = Main.breadcrumbs[j];
			if(backTo != currApp) {
				theIndex = j;
				break;
			}
		}
		var allowBack = true;
		var clearInstead = false;
		if(theIndex < 0) {
			allowBack = false;
			if(currApp != null && currApp != "") {
				clearInstead = true;
			}
		}
		if(allowBack) {
			Main.clickBreadcrumb(theIndex);
			window.history.back();
		}
		if(clearInstead) {
			Main.onClickFocusSearch();
			window.history.back();
			Main.performClear();
		}
	} else {
		var boxes = Main.refreshHistory.pop();
		Main.focus(Main.focusedEntry.appid,boxes);
	}
};
Main.performClear = function(killHistoryAfterFocus) {
	if(killHistoryAfterFocus == null) {
		killHistoryAfterFocus = false;
	}
	if(Main.allBlank(Main.STARTER_APPS)) {
		Main.STARTER_APPS = [];
		Main.STARTER_BOXES = [];
	}
	if(Main.STARTER_BOXES.length == 0) {
		console.log("get starter apps");
		Main.getStarterApps(function(appids,details) {
			Main.getBoxEntriesFor(appids,details,["","","","","","","",""],function(entries) {
				Main.STARTER_BOXES = entries;
				Main.focus("",Main.STARTER_BOXES);
				if(killHistoryAfterFocus) {
					Main.killHistory();
				}
			});
		});
	} else {
		var needFocus = true;
		var i = 0;
		var matchAll = true;
		var _g = 0;
		while(_g < 9) {
			var i1 = _g++;
			var boxWrapper = window.document.getElementById("box-wrapper-" + (i1 + 1));
			if(boxWrapper == null) {
				continue;
			}
			var dataDsAppid = boxWrapper.getAttribute("data-ds-appid");
			if(Main.searchArray(Main.STARTER_APPS,dataDsAppid) == -1) {
				matchAll = false;
				break;
			}
		}
		if(matchAll) {
			if(Main.focusedEntry == null || Main.focusedEntry.appid == "") {
				needFocus = false;
			}
		}
		if(needFocus) {
			Main.clearHistoryStates();
			window.history.replaceState({ },"","");
			Main.focus("",Main.STARTER_BOXES,function() {
				Main.killHistory();
				Main.clearHistoryStates();
			});
		}
	}
};
Main.searchArray = function(arr,value) {
	var _g1 = 0;
	var _g = arr.length;
	while(_g1 < _g) {
		var i = _g1++;
		if(arr[i] == value) {
			return i;
		}
	}
	return -1;
};
Main.refresh = $hx_exports["Main"]["refresh"] = function() {
	if(Main.focusedEntry == null) {
		Main.clickBreadcrumb(Main.breadcrumbs.length - 1);
		return;
	}
	var freezeBoxes = [];
	var _g1 = 0;
	var _g = Main.boxEntries.length;
	while(_g1 < _g) {
		var i = _g1++;
		freezeBoxes.push(Main.boxEntries[i].copy());
	}
	Main.refreshHistory.push(freezeBoxes);
	Main.showBoxes(false);
	Main.snipCurrentMatches();
	EggTimer.runOnce(250,function() {
		Main.handleMatches(Main.focusedEntry.appid,Main.currMatches);
		return true;
	});
};
Main.clickColumn = $hx_exports["Main"]["clickColumn"] = function(i) {
	var cycle = Main.FEATURE_FLAG_ML_RECOMMENDER ? ["reccats","recml","recgems","recdefault"] : ["reccats","recdefault","recgems"];
	var currHeader = Main.columnHeaders[i];
	var index = cycle.indexOf(currHeader);
	++index;
	if(index >= cycle.length) {
		index -= cycle.length;
	}
	currHeader = cycle[index];
	Main.columnHeaders[i] = currHeader;
	Main.renderHeader(i);
	Main.updateMatches(Main.focusedEntry.appid,Main.currMatches,i);
};
Main.clickBreadcrumb = $hx_exports["Main"]["clickBreadcrumb"] = function(i) {
	Main.justClickedBreadcrumb = true;
	if(i == -1) {
		Main.killHistory();
		Main.performClear(true);
		return;
	}
	if(i >= Main.breadcrumbs.length) {
		return;
	}
	var appid = Main.breadcrumbs[i];
	var boxes = Main.breadcrumbBoxEntries[i];
	while(Main.breadcrumbs.length > i) {
		Main.breadcrumbs.pop();
		Main.breadcrumbTitles.pop();
		Main.breadcrumbBoxEntries.pop();
	}
	Main.hideHover();
	if(Main.focusedEntry != null) {
		Main.focusedEntry.clear();
	}
	Main.focus(appid,boxes,Main.renderBreadcrumbs);
};
Main.saveBreadcrumbs = function(appid,title,currBoxEntries) {
	if(appid == "") {
		return;
	}
	Main.breadcrumbs.push(appid);
	Main.breadcrumbTitles.push(title);
	var freezeBoxes = [];
	var _g1 = 0;
	var _g = Main.boxEntries.length;
	while(_g1 < _g) {
		var i = _g1++;
		freezeBoxes.push(currBoxEntries[i].copy());
	}
	Main.breadcrumbBoxEntries.push(freezeBoxes);
};
Main.saveHistory = function() {
	var state = Main.getCurrentHistoryPath();
	if(state != null && state != "" && state != "#") {
		window.history.pushState({ },"",state);
	}
};
Main.focusFromSearch = $hx_exports["Main"]["focusFromSearch"] = function(appid) {
	Main.killHistory();
	Main.focus(appid);
};
Main.focus = $hx_exports["Main"]["focus"] = function(appid,showTheseBoxes,callback,disabledTags,boostedTags) {
	if(appid == "" || appid == null) {
		var allNull = false;
		if(showTheseBoxes != null && showTheseBoxes.length > 0) {
			allNull = true;
			var _g = 0;
			while(_g < showTheseBoxes.length) {
				var box = showTheseBoxes[_g];
				++_g;
				if(box == null) {
					continue;
				}
				if(box.appid != "" && box.appid != null) {
					allNull = false;
				}
			}
		}
		if(allNull) {
			return;
		}
	}
	if(Main.focusBusy) {
		return;
	}
	var priorApp = "";
	var priorTitle = "";
	if(Main.focusedEntry != null) {
		priorApp = Main.focusedEntry.appid;
		priorTitle = Main.focusedEntry.title;
	}
	if(disabledTags == null) {
		disabledTags = [];
	}
	if(boostedTags == null) {
		boostedTags = [];
	}
	if(priorApp != appid) {
		Main.hideHover();
	}
	Main.focusedEntry = new BoxEntry();
	Main.focusedEntry.appid = appid;
	Main.focusedEntry.title = "App(" + appid + ")";
	Main.focusedEntry.setPrice(1999);
	Main.focusedEntry.disabledTags = disabledTags.slice();
	Main.focusedEntry.boostedTags = boostedTags.slice();
	var disabledTags1 = disabledTags.slice();
	if(showTheseBoxes == null || showTheseBoxes.length == 0) {
		if(priorApp != appid) {
			Main.saveBreadcrumbs(priorApp,priorTitle,Main.boxEntries);
		}
		Main.renderBreadcrumbs();
		if(priorApp != appid) {
			Main.refreshHistory = [];
		}
	} else {
		Main.lastMatchCount = -1;
	}
	Main.saveHistory();
	var currentHistory = Main.getCurrentHistoryPath();
	window.history.replaceState({ },"",currentHistory);
	if(appid == "") {
		Main.focusedEntry = null;
		Main.renderFocusedBox();
		if(showTheseBoxes != null && showTheseBoxes.length > 0) {
			Main.displayBoxes(showTheseBoxes,callback);
		}
		return;
	}
	var showFocusDetails = function(details,early) {
		if(early == null) {
			early = false;
		}
		Main.focusedEntry.disabledTags = disabledTags1;
		Main.focusedEntry.setDetails(details);
		if(early) {
			Main.focusedEntry.keyTags = null;
		} else {
			Main.focusedEntry.keyTags = Main.currMatches.keyTags;
		}
		Main.renderFocusedBox();
		Main.showBoxes(false);
	};
	var details1;
	if(Main.currMatches != null && Main.currMatches.details != null) {
		var _this = Main.currMatches.details;
		if(__map_reserved[appid] != null) {
			details1 = _this.getReserved(appid);
		} else {
			details1 = _this.h[appid];
		}
	} else {
		details1 = null;
	}
	var detailsWereNull = false;
	if(details1 != null) {
		showFocusDetails(details1,true);
	} else {
		showFocusDetails(details1,true);
		detailsWereNull = true;
	}
	if(showTheseBoxes == null || showTheseBoxes.length == 0) {
		Main.focusBusy = true;
		var tmp = Main.getPreviousAppIds();
		Data.getMatches(appid,["reccats","recdefault","recgems"],0,tmp,Main.focusedEntry.disabledTags,Main.focusedEntry.boostedTags,function(rawMatches) {
			Main.focusBusy = false;
			if(rawMatches == null || rawMatches.map == null) {
				Main.handleMatches(appid,null,callback);
				return;
			}
			rawMatches.map = Main.removeByPreferences(rawMatches.map);
			Main.currMatches = rawMatches;
			Main.matchPage = 0;
			if(detailsWereNull) {
				var _this1 = Main.currMatches.details;
				if(__map_reserved[appid] != null) {
					details1 = _this1.getReserved(appid);
				} else {
					details1 = _this1.h[appid];
				}
				showFocusDetails(details1);
			} else {
				Main.focusedEntry.keyTags = Main.currMatches.keyTags;
				Main.renderFocusedBox();
			}
			if(Main.LOGGED_IN) {
				Main.wishlist = rawMatches.wishlist;
				Main.tempWishlist = [];
			}
			Main.handleMatches(appid,rawMatches,callback);
		});
	} else {
		Main.displayBoxes(showTheseBoxes,callback);
	}
};
Main.hideMainThrobber = function() {
	var el = window.document.getElementById("main_loader");
	GlobalStuff.hardHide(el);
};
Main.displayBoxes = function(showTheseBoxes,callback) {
	var _g1 = 0;
	var _g = showTheseBoxes.length;
	while(_g1 < _g) {
		var i = _g1++;
		var showBox = showTheseBoxes[i];
		if(showBox != null) {
			if(Main.boxEntries.length > i) {
				var theBox = Main.boxEntries[i];
				if(theBox != null) {
					theBox.copyValuesFrom(showBox);
				}
			}
		}
	}
	EggTimer.runOnce(100,function() {
		Main.updateBoxes();
		if(callback != null) {
			callback();
		}
		return true;
	});
};
Main.getMoreMatches = function(appid,callback) {
	Data.getMatches(appid,["reccats","recdefault","recgems"],Main.matchPage + 1,Main.getPreviousAppIds(),Main.focusedEntry.disabledTags,Main.focusedEntry.boostedTags,function(rawMatches) {
		if(rawMatches != null) {
			rawMatches.map = Main.removeByPreferences(rawMatches.map);
			Main.addToCurrentMatches(rawMatches);
			Main.matchPage++;
			if(Main.LOGGED_IN) {
				Main.wishlist = rawMatches.wishlist;
				Main.tempWishlist = [];
			}
		}
		if(callback != null) {
			callback();
		}
	});
};
Main.addToCurrentMatches = function(rawMatches) {
	var currMap = Main.currMatches.map;
	var rawMap = rawMatches.map;
	var key = currMap.keys();
	while(key.hasNext()) {
		var key1 = key.next();
		var currAppIds = __map_reserved[key1] != null ? currMap.getReserved(key1) : currMap.h[key1];
		var rawAppIds = __map_reserved[key1] != null ? rawMap.getReserved(key1) : rawMap.h[key1];
		var _g = 0;
		while(_g < rawAppIds.length) {
			var appid = rawAppIds[_g];
			++_g;
			if(currAppIds.indexOf(appid) == -1) {
				currAppIds.push(appid);
			}
		}
	}
	var currDetails = Main.currMatches.details;
	var rawDetails = rawMatches.details;
	var key2 = rawDetails.keys();
	while(key2.hasNext()) {
		var key3 = key2.next();
		if((__map_reserved[key3] != null ? currDetails.existsReserved(key3) : currDetails.h.hasOwnProperty(key3)) == false) {
			var value = __map_reserved[key3] != null ? rawDetails.getReserved(key3) : rawDetails.h[key3];
			if(__map_reserved[key3] != null) {
				currDetails.setReserved(key3,value);
			} else {
				currDetails.h[key3] = value;
			}
		}
	}
	var currTags = Main.currMatches.tags;
	var rawTags = rawMatches.tags;
	var key4 = rawTags.keys();
	while(key4.hasNext()) {
		var key5 = key4.next();
		if((__map_reserved[key5] != null ? currTags.existsReserved(key5) : currTags.h.hasOwnProperty(key5)) == false) {
			var value1 = __map_reserved[key5] != null ? rawTags.getReserved(key5) : rawTags.h[key5];
			if(__map_reserved[key5] != null) {
				currTags.setReserved(key5,value1);
			} else {
				currTags.h[key5] = value1;
			}
		}
	}
	var currStoreItemData = Main.currMatches.storeItemData;
	var rawStoreItemData = rawMatches.storeItemData;
	var currRgApps = currStoreItemData.rgApps;
	var rawRgApps = rawStoreItemData.rgApps;
	var _g1 = 0;
	var _g11 = Reflect.fields(rawRgApps);
	while(_g1 < _g11.length) {
		var appid1 = _g11[_g1];
		++_g1;
		var appBlob = Reflect.field(rawRgApps,appid1);
		if(Object.prototype.hasOwnProperty.call(currRgApps,appid1) == false) {
			currRgApps[appid1] = appBlob;
		}
	}
};
Main.removeByPreferences = function(rawMatches) {
	if(rawMatches == null) {
		return rawMatches;
	}
	var key = rawMatches.keys();
	while(key.hasNext()) {
		var key1 = key.next();
		var appids = __map_reserved[key1] != null ? rawMatches.getReserved(key1) : rawMatches.h[key1];
		var kills = [];
		var _g = 0;
		while(_g < appids.length) {
			var appid = appids[_g];
			++_g;
			var appidint = Std.parseInt(appid);
			if(Main.prefs.owned_apps.indexOf(appidint) != -1 || Main.prefs.ignored.indexOf(appidint) != -1 || Main.prefs.played_elsewhere.indexOf(appidint) != -1) {
				kills.push(appid);
			}
		}
		var _g1 = 0;
		while(_g1 < kills.length) {
			var kill = kills[_g1];
			++_g1;
			HxOverrides.remove(appids,kill);
		}
		if(__map_reserved[key1] != null) {
			rawMatches.setReserved(key1,appids);
		} else {
			rawMatches.h[key1] = appids;
		}
	}
	return rawMatches;
};
Main.removeDuplicates = function(rawMatches) {
	var dupes = 0;
	if(rawMatches == null) {
		return rawMatches;
	}
	var key = rawMatches.keys();
	while(key.hasNext()) {
		var key1 = key.next();
		var appids = __map_reserved[key1] != null ? rawMatches.getReserved(key1) : rawMatches.h[key1];
		var otherkey = rawMatches.keys();
		while(otherkey.hasNext()) {
			var otherkey1 = otherkey.next();
			if(key1 == otherkey1) {
				continue;
			}
			var otherappids = __map_reserved[otherkey1] != null ? rawMatches.getReserved(otherkey1) : rawMatches.h[otherkey1];
			if(appids != null) {
				var _g1 = 0;
				var _g = appids.length;
				while(_g1 < _g) {
					var i = _g1++;
					var appid = appids[i];
					if(otherappids != null) {
						var _g3 = 0;
						var _g2 = otherappids.length;
						while(_g3 < _g2) {
							var j = _g3++;
							var jj = otherappids.length - j - 1;
							var otherappid = otherappids[jj];
							if(appid == otherappid) {
								otherappids.splice(jj,1);
								++dupes;
							}
						}
					}
				}
			}
		}
	}
	return rawMatches;
};
Main.snipCurrentMatches = function() {
	var snips = 0;
	var appids = [];
	var _g = 0;
	var _g1 = Main.boxEntries;
	while(_g < _g1.length) {
		var entry = _g1[_g];
		++_g;
		appids.push(entry.appid);
	}
	var key = Main.currMatches.map.keys();
	while(key.hasNext()) {
		var key1 = key.next();
		var _this = Main.currMatches.map;
		var matches = __map_reserved[key1] != null ? _this.getReserved(key1) : _this.h[key1];
		var _g2 = 0;
		while(_g2 < appids.length) {
			var appid = appids[_g2];
			++_g2;
			var _g21 = 0;
			var _g11 = matches.length;
			while(_g21 < _g11) {
				var j = _g21++;
				var jj = matches.length - j - 1;
				var matchAppid = matches[jj];
				if(matchAppid == appid) {
					matches.splice(jj,1);
					++snips;
				}
			}
		}
	}
};
Main.handleMatches = function(appid,rawMatches,callback) {
	if(rawMatches == null) {
		console.log("ERROR: couldn't get matches for (" + appid + ")");
	} else {
		var recs = Main.narrowMatches(rawMatches.map,Main.getPreviousAppIds());
		var count = 0;
		if(recs != null) {
			Main.lastMatchCount = recs.appids.length;
		}
		if(recs == null || recs.appids == null || recs.appids.length == 0) {
			var _this = rawMatches.map;
			console.log("ERROR: couldn't narrow matches for (" + appid + ") rawMatches = " + Std.string(__map_reserved["reccats"] != null ? _this.getReserved("reccats") : _this.h["reccats"]));
		} else {
			var details = rawMatches.details;
			if(details == null) {
				console.log("ERROR: couldn't get details for (" + Std.string(recs.appids) + ")");
			} else {
				var i = 0;
				var _g = 0;
				while(_g < 9) {
					var j = _g++;
					Main.boxEntries[j].appid = null;
					Main.setBoxDetails(Main.boxEntries[j],null);
					Main.boxEntries[j].recommender = "";
				}
				var lookup = [0,3,6,1,4,7,2,5,8];
				var _g1 = 0;
				var _g11 = recs.appids;
				while(_g1 < _g11.length) {
					var appid1 = _g11[_g1];
					++_g1;
					if(i >= 9) {
						break;
					}
					var detail = __map_reserved[appid1] != null ? details.getReserved(appid1) : details.h[appid1];
					if(detail != null) {
						var appid2 = detail.appid;
						var arrIndex = -1;
						var _g3 = 0;
						var _g2 = recs.appids.length;
						while(_g3 < _g2) {
							var j1 = _g3++;
							var otherappid = recs.appids[j1];
							if(appid2 == otherappid) {
								arrIndex = j1;
								break;
							}
						}
						var boxIndex = lookup[i];
						var entry = Main.boxEntries[boxIndex];
						entry.appid = appid2;
						Main.setBoxDetails(entry,detail,Main.focusedEntry);
						entry.recommender = arrIndex != -1 ? recs.recommenders[arrIndex] : "";
					}
					++i;
				}
				Main.updateBoxes();
				if(callback != null) {
					callback();
				}
			}
		}
	}
};
Main.updateMatches = function(appid,rawMatches,column) {
	if(rawMatches == null) {
		console.log("ERROR: couldn't get matches for (" + appid + ")");
	} else {
		var recs = Main.narrowMatches(rawMatches.map,Main.getPreviousAppIds(),column);
		var colIds;
		switch(column) {
		case 0:
			colIds = [0,3,6];
			break;
		case 1:
			colIds = [1,4,7];
			break;
		case 2:
			colIds = [2,5,8];
			break;
		default:
			colIds = [0,3,6];
		}
		var count = 0;
		if(recs != null) {
			Main.lastMatchCount = recs.appids.length;
		}
		if(recs == null || recs.appids == null || recs.appids.length == 0) {
			var _this = rawMatches.map;
			console.log("ERROR: couldn't narrow matches for (" + appid + ") rawMatches = " + Std.string(__map_reserved["reccats"] != null ? _this.getReserved("reccats") : _this.h["reccats"]));
		} else {
			var i = 0;
			var details = rawMatches.details;
			var _g = 0;
			while(_g < colIds.length) {
				var colId = colIds[_g];
				++_g;
				Main.boxEntries[colId].appid = null;
				Main.setBoxDetails(Main.boxEntries[colId],null);
				Main.boxEntries[colId].recommender = "";
			}
			var lookup_0 = 0;
			var lookup_1 = 3;
			var lookup_2 = 6;
			var lookup_3 = 1;
			var lookup_4 = 4;
			var lookup_5 = 7;
			var lookup_6 = 2;
			var lookup_7 = 5;
			var lookup_8 = 8;
			var _g1 = 0;
			var _g11 = recs.appids;
			while(_g1 < _g11.length) {
				var appid1 = _g11[_g1];
				++_g1;
				if(i >= 3) {
					break;
				}
				var detail = __map_reserved[appid1] != null ? details.getReserved(appid1) : details.h[appid1];
				if(detail != null) {
					var appid2 = detail.appid;
					var arrIndex = -1;
					var _g2 = 0;
					while(_g2 < 9) {
						var j = _g2++;
						if(colIds.indexOf(j) != -1) {
							continue;
						}
						var otherappid = Main.boxEntries[j].appid;
						if(appid2 == otherappid) {
							arrIndex = j;
							break;
						}
					}
					if(arrIndex != -1) {
						continue;
					}
					var boxIndex = colIds[i];
					var entry = Main.boxEntries[boxIndex];
					entry.appid = appid2;
					Main.setBoxDetails(entry,detail,Main.focusedEntry);
					entry.recommender = Main.columnHeaders[column];
					++i;
				}
			}
			Main.updateTheseBoxes(colIds);
		}
	}
};
Main.setBoxDetails = function(boxEntry,detail,focusedEntry) {
	boxEntry.setDetails(detail);
	if(focusedEntry != null) {
		boxEntry.makeTagEntries(focusedEntry.getConsideredTags(),false,focusedEntry.disabledTags);
	} else {
		boxEntry.makeTagEntries([],false,[]);
	}
};
Main.updateTheseBoxes = function(arr) {
	var _g = 0;
	while(_g < arr.length) {
		var boxIndex = arr[_g];
		++_g;
		var entry = Main.boxEntries[boxIndex];
		var _g1 = 0;
		var _g2 = Main.breadcrumbBoxEntries;
		while(_g1 < _g2.length) {
			var bcEntries = _g2[_g1];
			++_g1;
			var _g3 = 0;
			while(_g3 < bcEntries.length) {
				var bcEntry = bcEntries[_g3];
				++_g3;
				if(bcEntry.appid == entry.appid) {
					entry.title = entry.title;
				}
			}
		}
		if(entry.tags != null) {
			if(Main.focusedEntry != null && Main.focusedEntry.tags != null) {
				var comparison = Main.tagDB.compare(Main.focusedEntry.tags,entry.tags);
				var results = Main.tagDB.normalizeMatches(comparison.matches);
				entry.tagCategories = results;
			} else {
				var comparison1 = Main.tagDB.compare(entry.tags,entry.tags);
				var results1 = Main.tagDB.normalizeMatches(comparison1.matches);
				entry.tagCategories = results1;
			}
		}
	}
	Main.afterUpdateBoxes(arr);
};
Main.updateBoxes = function() {
	var _g = 0;
	var _g1 = Main.boxEntries;
	while(_g < _g1.length) {
		var entry = _g1[_g];
		++_g;
		var _g2 = 0;
		var _g3 = Main.breadcrumbBoxEntries;
		while(_g2 < _g3.length) {
			var bcEntries = _g3[_g2];
			++_g2;
			var _g4 = 0;
			while(_g4 < bcEntries.length) {
				var bcEntry = bcEntries[_g4];
				++_g4;
				if(bcEntry.appid == entry.appid) {
					entry.title = entry.title;
				}
			}
		}
		if(entry.tags != null) {
			if(Main.focusedEntry != null && Main.focusedEntry.tags != null) {
				var comparison = Main.tagDB.compare(Main.focusedEntry.tags,entry.tags);
				var results = Main.tagDB.normalizeMatches(comparison.matches);
				entry.tagCategories = results;
			} else {
				var comparison1 = Main.tagDB.compare(entry.tags,entry.tags);
				var results1 = Main.tagDB.normalizeMatches(comparison1.matches);
				entry.tagCategories = results1;
			}
		}
	}
	Main.afterUpdateBoxes();
};
Main.afterUpdateBoxes = function(justThese) {
	if(Main.focusedEntry != null && Main.focusedEntry.tags != null) {
		var comparison = Main.tagDB.compare(Main.focusedEntry.tags,Main.focusedEntry.tags);
		var results = Main.tagDB.normalizeMatches(comparison.matches);
		Main.focusedEntry.tagCategories = results;
		Main.focusedEntry.makeTagEntries(Main.focusedEntry.getConsideredTags(),true,Main.focusedEntry.disabledTags);
	}
	if(Main.gridObserver != null) {
		Main.gridObserver.disconnect();
	}
	Main.gridObserver = new MutationObserver(function(arr,observer) {
		observer.disconnect();
		EggTimer.runOnce(1,function() {
			Main.showBoxes(true);
			return true;
		});
	});
	var gridRoot = window.document.getElementById("grid");
	Main.gridObserver.observe(gridRoot,{ attributes : true, childList : true, subtree : true});
	Main.renderBoxes(true,justThese);
	Main.updateBoxesHover();
	Main.renderBackRefreshButtons();
	if(Main.isContentStarved() && Main.focusedEntry != null) {
		EggTimer.runOnce(1000,function() {
			Main.getMoreMatches(Main.focusedEntry.appid,function() {
				var result = Main.isContentStarved();
				if(Main.focusedEntry != null && Main.focusedEntry.keyTags == null) {
					Main.focusedEntry.keyTags = Main.currMatches.keyTags;
					Main.renderFocusedBox(Main.focusedEntry.appid);
				}
			});
			return true;
		});
	}
};
Main.isContentStarved = function() {
	if(Main.currMatches == null) {
		return false;
	}
	var key = Main.currMatches.map.keys();
	while(key.hasNext()) {
		var key1 = key.next();
		var _this = Main.currMatches.map;
		var list = __map_reserved[key1] != null ? _this.getReserved(key1) : _this.h[key1];
		if(list.length <= 18) {
			return true;
		}
	}
	return false;
};
Main.updateBoxesHover = function() {
	var _g = 0;
	while(_g < 9) {
		var i = _g++;
		var appIdInt = Std.parseInt(Main.boxEntries[i].appid);
		var params_top_area_content = "";
		var boxButtons = [window.document.getElementById("box-buttons-" + i)];
		var boxMicrotrailer = [window.document.getElementById("box-microtrailer-" + i)];
		var boxImage = window.document.getElementById("box-image-" + i);
		var boxPrompt = [window.document.getElementById("box-prompt-" + i)];
		var boxTags = [window.document.getElementById("box-tags-" + i)];
		GlobalStuff.show(boxButtons[0],false);
		GlobalStuff.show(boxMicrotrailer[0],false);
		var onMouseEnter = (function(boxTags1,boxPrompt1,boxMicrotrailer1,boxButtons1) {
			return function() {
				GlobalStuff.show(boxButtons1[0],true);
				GlobalStuff.show(boxMicrotrailer1[0],true);
				GlobalStuff.show(boxPrompt1[0],true);
				GlobalStuff.show(boxTags1[0],true);
			};
		})(boxTags,boxPrompt,boxMicrotrailer,boxButtons);
		var onMouseLeave = (function(boxTags2,boxPrompt2,boxMicrotrailer2,boxButtons2) {
			return function() {
				GlobalStuff.show(boxButtons2[0],false);
				GlobalStuff.show(boxMicrotrailer2[0],false);
				GlobalStuff.show(boxPrompt2[0],false);
				GlobalStuff.show(boxTags2[0],false);
			};
		})(boxTags,boxPrompt,boxMicrotrailer,boxButtons);
		GlobalStuff.bindHoverEvents("box-" + i,appIdInt,true,onMouseEnter,onMouseLeave);
	}
	if(Main.focusedEntry != null && Main.focusedEntry.appid != "") {
		var appIdInt1 = Std.parseInt(Main.focusedEntry.appid);
		var focusBoxMicrotrailer = window.document.getElementById("focus-box-microtrailer");
		var focusBoxBigScreenshot = window.document.getElementById("focus-box-big-screenshot");
		var onMouseEnterFocus = function() {
			GlobalStuff.show(focusBoxMicrotrailer,true);
		};
		var onMouseLeaveFocus = function() {
			GlobalStuff.show(focusBoxMicrotrailer,false);
		};
		GlobalStuff.bindHoverEvents("box-focused",appIdInt1,true,onMouseEnterFocus,onMouseLeaveFocus);
	}
};
Main.narrowMatches = function(rawMatches,previousAppIds,column) {
	if(column == null) {
		column = -1;
	}
	var matchTypes = [];
	var recommender = rawMatches.keys();
	while(recommender.hasNext()) {
		var recommender1 = recommender.next();
		var matchList = __map_reserved[recommender1] != null ? rawMatches.getReserved(recommender1) : rawMatches.h[recommender1];
		var _g1 = 0;
		var _g = previousAppIds.length;
		while(_g1 < _g) {
			var i = _g1++;
			var appid = previousAppIds[i];
			var _g3 = 0;
			var _g2 = matchList.length;
			while(_g3 < _g2) {
				var j = _g3++;
				var other = matchList[j];
				if(other == appid) {
					matchList.splice(j,1);
					break;
				}
			}
		}
		var count = matchList.length;
		if(count > 0) {
			matchTypes.push(recommender1);
		}
	}
	var failsafe = 100;
	var target = 9;
	var matches = { appids : [], recommenders : []};
	var columns = [{ appids : [null,null,null], recommenders : ["","",""]},{ appids : [null,null,null], recommenders : ["","",""]},{ appids : [null,null,null], recommenders : ["","",""]}];
	var matchQuota = [];
	if(column == -1) {
		matchQuota = [{ name : Main.columnHeaders[0], value : 3, count : 0},{ name : Main.columnHeaders[1], value : 3, count : 0},{ name : Main.columnHeaders[2], value : 3, count : 0}];
	} else {
		matchQuota = [{ name : Main.columnHeaders[column], value : 9, count : 0}];
	}
	var matchedApps = [];
	var failsafe1 = 100;
	while(target > 0 && failsafe1 > 0) {
		var _g11 = 0;
		var _g4 = matchQuota.length;
		while(_g11 < _g4) {
			var i1 = _g11++;
			var quota = matchQuota[i1];
			var recommender2 = quota.name;
			var value = quota.value;
			var matches1 = 0;
			var _g31 = 0;
			var _g21 = value;
			while(_g31 < _g21) {
				var j1 = _g31++;
				var matchList1 = __map_reserved[recommender2] != null ? rawMatches.getReserved(recommender2) : rawMatches.h[recommender2];
				var appid1 = null;
				while(appid1 == null && quota.count < matchList1.length) {
					appid1 = matchList1[quota.count];
					if(matchedApps.indexOf(appid1) != -1) {
						appid1 = null;
					}
					quota.count++;
				}
				if(appid1 != null) {
					matchedApps.push(appid1);
					++matches1;
				}
				columns[i1].appids[matches1 - 1] = appid1;
				columns[i1].recommenders[matches1 - 1] = recommender2;
				--target;
				if(appid1 != null) {
					matchedApps.push(appid1);
				}
			}
			quota.value = 1;
		}
		--failsafe1;
	}
	var _g5 = 0;
	while(_g5 < columns.length) {
		var column1 = columns[_g5];
		++_g5;
		var _g12 = 0;
		var _g22 = column1.appids;
		while(_g12 < _g22.length) {
			var appid2 = _g22[_g12];
			++_g12;
			matches.appids.push(appid2);
		}
		var _g13 = 0;
		var _g23 = column1.recommenders;
		while(_g13 < _g23.length) {
			var recommender3 = _g23[_g13];
			++_g13;
			matches.recommenders.push(recommender3);
		}
	}
	return matches;
};
Main.clear = function() {
	Main.domRoot.innerHTML = "<main class=\"diving-bell-content\"></main>";
};
Main.getPotatoScore = function() {
	var someConstant = 1.156 * Math.pow(10,-8);
	var oldTime = new Date().getTime() / 1000;
	var amount = 150000000;
	var medianCPU = 3.0;
	var _g1 = 0;
	var _g = amount;
	while(_g1 < _g) {
		var j = _g1++;
	}
	var newTime = new Date().getTime() / 1000;
	var deltaTime = newTime - oldTime;
	var speed = someConstant * amount / deltaTime;
	var estimatedSpeed = Math.round(someConstant * amount / medianCPU * 100) / 100;
	return 0.0;
};
Math.__name__ = true;
var Reflect = function() { };
Reflect.__name__ = true;
Reflect.field = function(o,field) {
	try {
		return o[field];
	} catch( e ) {
		return null;
	}
};
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(f != "__id__" && f != "hx__closures__" && hasOwnProperty.call(o,f)) {
			a.push(f);
		}
		}
	}
	return a;
};
var Render = function() { };
Render.__name__ = true;
Render.breadcrumbs = function(appids,titles) {
	var html = "<section class=\"breadcrumbs\" id=\"breadcrumbs\">\n" + Render.breadcrumbsContent(appids) + "\n" + "</section>";
	return html;
};
Render.breadcrumbsContent = function(appids,titles) {
	var blurb = "";
	var crumbs = "";
	var diveMapTitle = Main.loc("#labs_deepdive_divemaptitle");
	var diveMapBlurb = Main.loc("#labs_deepdive_divemapblurb");
	var showMicrotrailers = Main.loc("#labs_deepdive_showmicrotrailers");
	var prefURL = Main.baseURL + "account/preferences";
	diveMapBlurb = StringTools.replace(diveMapBlurb,"%s","href=\"" + prefURL + "\" target=\"_blank\"");
	var hr = "";
	if(appids == null || appids.length < 1) {
		blurb = Main.loc("#labs_deepdive_divemapcaption");
		hr = "<hr>";
	} else {
		blurb = "";
		var startOver = Main.loc("#labs_deepdive_startover");
		var url = Main.cdnURL + "labs/diving_bell/startover.svg";
		crumbs += "\n\r\n\t\t\t\t<a href=\"divingbell\">\r\n\t\t\t\t\t<div class=\"breadcrumb-startover-container\">\r\n\t\t\t\t\t\t<img src=\"" + url + "\" alt=\"" + startOver + "\" class=\"breadcrumb\"/>\r\n\t\t\t\t\t\t<div class=\"breadcrumb-startover-text\">" + startOver + "</div>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</a>";
	}
	var maxBreadcrumbs = 7;
	var minBreadcrumbs1 = 2;
	var minBreadcrumbs2 = 3;
	var minBreadcrumbs3 = 4;
	var minBreadcrumbs4 = 5;
	var minBreadcrumbs5 = 6;
	var minBreadcrumbs6 = 7;
	if(appids != null) {
		var start = 0;
		var overflow = appids.length - maxBreadcrumbs;
		if(overflow > 0) {
			start = overflow;
		}
		var k = 0;
		var _g1 = 0;
		var _g = appids.length;
		while(_g1 < _g) {
			var i = _g1++;
			var j = start + i;
			if(j >= appids.length) {
				break;
			}
			var appid = appids[j];
			var title = titles[j];
			if(appid != "" && appid != null) {
				var url1 = "https://steamcdn-a.akamaihd.net/steam/apps/" + appid + "/capsule_sm_120.jpg";
				var urlArrow = Main.cdnURL + "labs/diving_bell/arrow.png";
				var breadcrumbClass = "xcrumb-" + k;
				if(crumbs != "") {
					var arrowClass = "arrow " + breadcrumbClass;
					crumbs += "<img src=\"" + urlArrow + "\" class=\"" + arrowClass + "\">";
				}
				crumbs += "\n<a href=\"javascript:Main.clickBreadcrumb(" + j + ")\" class=\"" + breadcrumbClass + "\"><img src=\"" + url1 + "\" alt=\"" + title + "\" class=\"breadcrumb\"/></a>";
				if(k >= minBreadcrumbs1) {
					var narrow = "narrow5";
					var minBreadcrumbs = minBreadcrumbs1;
					if(k >= minBreadcrumbs2) {
						narrow = "narrow4";
						minBreadcrumbs = minBreadcrumbs2;
					}
					if(k >= minBreadcrumbs3) {
						narrow = "narrow3";
						minBreadcrumbs = minBreadcrumbs3;
					}
					if(k >= minBreadcrumbs4) {
						narrow = "narrow2";
						minBreadcrumbs = minBreadcrumbs4;
					}
					if(k >= minBreadcrumbs5) {
						narrow = "narrow1";
						minBreadcrumbs = minBreadcrumbs5;
					}
					if(k >= minBreadcrumbs6) {
						narrow = "narrow0";
						minBreadcrumbs = minBreadcrumbs6;
					}
					var overflow1 = k - minBreadcrumbs;
					var pattern = "xcrumb-" + i;
					var replacement = "breadcrumb-" + i + " breadcrumb-hide-on-" + narrow;
					crumbs = StringTools.replace(crumbs,pattern,replacement);
					crumbs = StringTools.replace(crumbs,"xcrumb-","breadcrumb-");
				}
				++k;
			}
		}
	}
	var checked = Main.MICROTRAILERS ? "checked" : "";
	var html = "" + hr + "<p>" + blurb + "</p>\r\n\t\t\t<div class=\"note-preferences\">\r\n\t\t\t\t<p><strong>" + diveMapTitle + "</strong>&nbsp;&nbsp;&nbsp;" + diveMapBlurb + "</p>\r\n\t\t\t</div>\r\n\t\t\t<div class=\"container-checkbox-microtrailers\">\r\n\t\t\t\t<input type=\"checkbox\" name=\"microtrailers\" value=\"microtrailers\" id=\"checkbox-microtrailers\" onclick=\"Main.toggleMicrotrailers()\" " + checked + ">\r\n\t\t\t\t\t<label class=\"label-checkbox-microtrailers\" for=\"microtrailers\">" + showMicrotrailers + "</label>\r\n\t\t\t\t</input>\r\n\t\t\t</div>\r\n\t\t\t<div class=\"breadcrumbbox\">" + crumbs + "</div>";
	return html;
};
Render.header = function() {
	var html = "<br>\r\n\t\t<h1>Discover your next favorite game </h1>\r\n\t\t";
	return html;
};
Render.showBox = function(index,show) {
	var box = window.document.getElementById(Std.string("box-wrapper-" + index));
	var appid = Main.boxEntries[index] != null ? Main.boxEntries[index].appid : "null";
	var doodads = window.document.getElementById(Std.string("box-doodads-" + index));
	var throbber = window.document.getElementById(Std.string("throbber-" + index));
	if(!show) {
		if(!box.classList.contains("sink")) {
			box.classList.add("sink");
		}
		GlobalStuff.show(doodads,true);
		EggTimer.runOnce(250,function() {
			GlobalStuff.show(doodads,false);
			return true;
		});
	} else {
		if(box.classList.contains("sink")) {
			box.classList.remove("sink");
		}
		GlobalStuff.show(doodads,false);
		EggTimer.runOnce(250,function() {
			GlobalStuff.show(doodads,true);
			return true;
		});
	}
};
Render.hydrateMicrotrailer = function(index,entry,className,id,overwrite) {
	if(overwrite == null) {
		overwrite = false;
	}
	if(id == null) {
		id = "";
	}
	if(className == null) {
		className = "microtrailer";
	}
	var boxMicrotrailerId = id == "" ? "box-microtrailer-" + index : id;
	if(boxMicrotrailerId != null) {
		var el = window.document.getElementById(boxMicrotrailerId);
		if(el != null && (el.childElementCount == 0 || overwrite)) {
			el.innerHTML = Render._microtrailerContent(entry,className,index);
		}
		return true;
	}
	return false;
};
Render.microtrailer = function(index,entry,className,id,containerClass,empty) {
	if(empty == null) {
		empty = false;
	}
	if(containerClass == null) {
		containerClass = "";
	}
	if(id == null) {
		id = "";
	}
	if(className == null) {
		className = "microtrailer";
	}
	var boxMicrotrailerId = id == "" ? "box-microtrailer-" + index : id;
	if(containerClass == "") {
		containerClass = "box-microtrailer hide-fancy";
	}
	var html = "<div class=\"" + containerClass + "\" id=\"" + boxMicrotrailerId + "\" >";
	if(!empty) {
		html += Render._microtrailerContent(entry,className,index);
	}
	html += "</div>";
	return html;
};
Render.replaceWithFullFatVideo = $hx_exports["Render"]["replaceWithFullFatVideo"] = function(index,el) {
	var id = "video-" + index;
	var videoTag = window.document.getElementById(id);
	var src = "";
	if(videoTag != null) {
		var _g1 = 0;
		var _g = videoTag.children.length;
		while(_g1 < _g) {
			var i = _g1++;
			var child = videoTag.children.item(i);
			if(child == el) {
				src = child.getAttribute("src");
				child.remove();
				break;
			}
		}
		if(src != "") {
			var srcFullFat = "";
			srcFullFat = StringTools.replace(src,"240.webm",".webm");
			srcFullFat = StringTools.replace(src,"240.mp4",".mp4");
			var error = "Render.replaceWithScreenshot(" + index + ",this)";
			var sourceEl = window.document.createElement("source");
			sourceEl.setAttribute("src",srcFullFat);
			sourceEl.setAttribute("onerror",error);
			videoTag.appendChild(sourceEl);
		}
	}
};
Render.replaceWithScreenshot = $hx_exports["Render"]["replaceWithScreenshot"] = function(index,el) {
	var id = "video-" + index;
	var videoTag = window.document.getElementById(id);
	if(videoTag != null) {
		var _g1 = 0;
		var _g = videoTag.children.length;
		while(_g1 < _g) {
			var i = _g1++;
			var child = videoTag.children.item(i);
			if(child == el) {
				child.remove();
				break;
			}
		}
		if(videoTag.children.length == 0) {
			videoTag.remove();
			var carousel = window.document.getElementById("screenshot-carousel-" + index);
			if(carousel != null) {
				carousel.setAttribute("style","display:block");
			}
		}
	}
};
Render._microtrailerContent = function(entry,className,index) {
	var appid = entry.appid;
	var title = entry.title;
	var webm = entry.microtrailer_webm;
	var mpeg4 = entry.microtrailer_mpeg4;
	var webm240 = webm != null ? StringTools.replace(webm,".webm","240.webm") : null;
	var mpeg4240 = mpeg4 != null ? StringTools.replace(mpeg4,".mp4","240.mp4") : null;
	var id = "video-" + index;
	var carouselid = "screenshot-carousel-" + index;
	var screenshots = "";
	var tmp = appid == "" || appid == null;
	if(entry.screenshots != null) {
		var _g1 = 0;
		var _g = entry.screenshots.length;
		while(_g1 < _g) {
			var i = _g1++;
			var imgUrl = entry.screenshots[i];
			if(imgUrl != null && imgUrl != "") {
				screenshots += "<div class=\"screenshot\" style=\"background-image: url( " + imgUrl + " );\"></div>";
			}
		}
	}
	var error1 = "Render.replaceWithFullFatVideo(" + index + ",this)";
	var error2 = "Render.replaceWithFullFatVideo(" + index + ",this)";
	if(webm240 == null || webm240 == "") {
		error1 = "Render.replaceWithScreenshot(" + index + ",this)";
	}
	if(mpeg4240 == null || mpeg4240 == "") {
		error2 = "Render.replaceWithScreenshot(" + index + ",this)";
	}
	var videoTag = "";
	if(Main.MICROTRAILERS) {
		videoTag = "<video id=\"" + id + "\" class=\"" + className + "\" loop preload muted autoplay alt=\"" + title + "\">\r\n\t\t\t\t<source src=\"" + webm240 + "\" onerror=\"" + error1 + "\">\r\n\t\t\t\t<source src=\"" + mpeg4240 + "\" onerror=\"" + error2 + "\">\r\n\t\t\t</video>";
	}
	var display = Main.MICROTRAILERS ? "style=display:none" : "";
	return videoTag + "\n" + ("<div class=\"hover_screenshots\" id=\"" + carouselid + "\" " + display + ">\r\n\t\t\t" + screenshots + "\r\n\t\t</div>");
};
Render.focusBox = function(entry) {
	if(entry == null || entry.appid == "") {
		return Render.searchBox();
	}
	var html = "<div class=\"box focused\" id=\"box-focused\">\n" + Render.focusBoxContent(entry);
	return html;
};
Render.focusBoxContent = function(entry,enableBack,enableRefresh) {
	if(enableRefresh == null) {
		enableRefresh = true;
	}
	if(enableBack == null) {
		enableBack = true;
	}
	var searchSvg = Main.cdnURL + "/labs/diving_bell/search.svg";
	var boxButtonsId = "box-buttons-focus";
	var index = 10;
	var extra = "";
	var doodadId = "box-doodads-" + index;
	var wrapperId = "box-wrapper-" + index;
	var wrapperClass = "box-wrapper" + extra;
	var boxButtonsId1 = "box-buttons-" + index;
	var boxImageId = "box-image-" + index;
	var boxTagsId = "box-tags-" + index;
	var boxPromptId = "box-prompt-" + index;
	var appid = entry.appid;
	var title = entry.title;
	var discountBlock = entry.discountBlock;
	if(entry.comingSoon) {
		discountBlock = "<div class=\"discount_block discount_block_inline no_discount\" data-price-final=\"\">\r\n\t\t\t\t\t<div class=\"discount_prices\">\r\n\t\t\t\t\t\t<div class=\"discount_final_price\">Coming Soon</div>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>";
	}
	if(entry.tagCategories.length == 0) {
		var comparison = Main.tagDB.compare(entry.tags,entry.tags);
		var results = Main.tagDB.normalizeMatches(comparison.matches);
		entry.tagCategories = results;
	}
	entry.makeTagEntries(entry.getConsideredTags(),null,entry.disabledTags);
	var arr = [];
	var _g = 0;
	var _g1 = entry.tags;
	while(_g < _g1.length) {
		var tag = _g1[_g];
		++_g;
		arr.push(tag.name);
	}
	var arr2 = [];
	var _g2 = 0;
	var _g11 = entry.tagEntries;
	while(_g2 < _g11.length) {
		var e = _g11[_g2];
		++_g2;
		arr2.push(e.name + ":" + (e.highlighted == null ? "null" : "" + e.highlighted));
	}
	var keyAttributes = Main.loc("#labs_deepdive_keytags");
	var tagHTML = entry.getTagHTML3(keyAttributes,8);
	var screenShots = "";
	screenShots += "<div class=\"box-images-big\">";
	var screenshot = entry.screenshots[0];
	if(screenshot != null) {
		screenShots += "<img class=\"focus-box-big-screenshot\" id=\"focus-box-big-screenshot\" src=\"" + screenshot + "\">";
		screenShots += Render.microtrailer(index,entry,"focus-box-microtrailer-video","focus-box-microtrailer","focus-box-microtrailer hide-fancy",false);
		screenShots += "</img>";
	}
	screenShots += "</div>";
	screenShots += "<div class=\"box-images-small\">";
	var _g3 = 1;
	while(_g3 < 5) {
		var i = _g3++;
		var screenshot1 = entry.screenshots[i];
		if(screenshot1 != null) {
			var imageClass = "box-images-" + i;
			screenShots += "<a href=\"" + screenshot1 + "\" target=\"_blank\">";
			screenShots += "<img src=\"" + screenshot1 + "\" class=\"" + imageClass + "\"/>";
			screenShots += "</a>";
		}
	}
	screenShots += "</div>";
	var selectToExplore = Main.loc("#labs_deepdive_selecttoexplore");
	var gamesLike = Main.loc("#labs_deepdive_gameslike");
	var onWishlist = Main.LOGGED_IN && Main.onWishlist(appid);
	var isOwned = Main.LOGGED_IN && Main.isOwned(appid);
	var wishlistBtn = Main.LOGGED_IN ? Render.wishlistButton(appid,onWishlist,isOwned) : "";
	var detailsBtn = Render.detailsButton(appid,entry.url);
	var html = "<div class=\"" + wrapperClass + "\" id=\"" + wrapperId + "\">\r\n\t\t\t\t\r\n\t\t\t\t<div class=\"box-prompt hide-fancy\" id=\"" + boxPromptId + "\">\r\n\t\t\t\t\t<p>" + selectToExplore + "</p>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div class=\"games-like\">" + gamesLike + "</div>\r\n\t\t\t\t\t<div id=\"search-wrapper\">\r\n\t\t\t\t\t\t<div class=\"search-container\" id=\"search-container\">\r\n\t\t\t\t\t\t\t<h2><a href=\"" + Std.string(entry) + ".url\">" + title + "</a></h2>\r\n\t\t\t\t\t\t\t<a href=\"javascript:Main.onClickFocusSearch();\">\r\n\t\t\t\t\t\t\t\t<h2 class=\"search-cursor\">&nbsp;</h2>\r\n\t\t\t\t\t\t\t\t<button id=\"button-search\" class=\"button-search-focus button-round\" onclick=\"trySearch()\">\r\n\t\t\t\t\t\t\t\t\t<img src=\"" + searchSvg + "\" class=\"search-icon-focus\"/>\r\n\t\t\t\t\t\t\t\t</button>\r\n\t\t\t\t\t\t\t</a>\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t\t<hr>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div class=\"box-doodads\" id=\"" + doodadId + "\">" + discountBlock + "</div>\r\n\t\t\t\t<div class=\"box-buttons\" id=\"" + boxButtonsId1 + "\">\r\n\t\t\t\t\t" + wishlistBtn + "\r\n\t\t\t\t\t" + detailsBtn + "\r\n\t\t\t\t</div>\r\n\t\t\t\t<div class=\"box-tags-focus hide-fancy\" id=\"" + boxTagsId + "\">\r\n\t\t\t\t\t" + tagHTML + "\r\n\t\t\t\t</div>\r\n\t\t\t\t" + screenShots + "\r\n\t\t\t</div>";
	return html;
};
Render.throbber = function(id,hide,position) {
	if(position == null) {
		position = "absolute";
	}
	var display = hide ? "display:none;" : "display:inline";
	var html = "<div class=\"box-microtrailer LoadingWrapper\" id=\"" + id + "\" style=\"z-index:0;position:" + position + ";" + display + "\">\r\n\t\t\t<div class=\"LoadingThrobber\">\r\n\t\t\t\t<div class=\"Bar Bar1\"></div>\r\n\t\t\t\t<div class=\"Bar Bar2\"></div>\r\n\t\t\t\t<div class=\"Bar Bar3\"></div>\r\n\t\t\t</div>\r\n\t\t\t<div class=\"LoadingText\">Main.loc(\"#labs_deepdive_loading\")</div>\r\n\t\t</div> ";
	return html;
};
Render.throbber2 = function() {
	var html = "<div class=\"LoadingThrobber\">\r\n\t\t\t<div class=\"Bar Bar1\"></div>\r\n\t\t\t<div class=\"Bar Bar2\"></div>\r\n\t\t\t<div class=\"Bar Bar3\"></div>\r\n\t\t</div>";
	return html;
};
Render.tagLine = function(i,tagid,name,disabled,boosted) {
	var disabledClass = disabled ? " disabled" : "";
	var boostedClass = boosted ? " boosted" : "";
	var tagListClass = Main.FEATURE_FLAG_KILLABLE_TAGS ? " tag-list-killable" : "";
	var tagPlus = Main.FEATURE_FLAG_KILLABLE_TAGS ? "<span class=\"tag-button tag-plus " + boostedClass + "\" onclick=\"Main.plusTag(" + tagid + ")\"><div>&check;</div></span>" : "";
	var tagMinus = Main.FEATURE_FLAG_KILLABLE_TAGS ? "<span class=\"tag-button tag-minus " + disabledClass + "\" onclick=\"Main.minusTag(" + tagid + ")\"><div>&mdash;</div></span>" : "";
	var tagCrouton = Main.FEATURE_FLAG_KILLABLE_TAGS ? "class=\"tag-crouton" : "";
	return "<span " + tagCrouton + ">\r\n\t\t\t" + tagPlus + "\r\n\t\t\t<span class=\"label tag-list tag-list-" + i + " tag-id-" + tagid + " " + disabledClass + " " + boostedClass + " " + tagListClass + "\">" + name + "&nbsp;</span>\r\n\t\t\t" + tagMinus + "\r\n\t\t</span><br/>";
};
Render.box = function(index,entry,sink,first) {
	if(first == null) {
		first = false;
	}
	if(sink == null) {
		sink = false;
	}
	var boxId = "box-" + index;
	var extra = "";
	if(sink) {
		extra += " sink";
	}
	var extraClass = "";
	if(entry == null || entry.appid == null || entry.appid == "") {
		extraClass = "empty-result";
	}
	var boxColumn;
	switch(index) {
	case 1:case 4:case 7:
		boxColumn = "1";
		break;
	case 0:case 3:case 6:
		boxColumn = "0";
		break;
	case 2:case 5:case 8:
		boxColumn = "2";
		break;
	default:
		boxColumn = "side";
	}
	var boxColumn1 = "column-" + boxColumn;
	var html = "<div class=\"box " + boxColumn1 + "\" id=\"" + boxId + "\">\n" + Render.boxContent(index,entry,sink,first) + "\n" + "</div>";
	return html;
};
Render.similarBlurb = function(recommender) {
	var recTitle = "";
	var recBlurb = "";
	switch(recommender) {
	case "reccats":
		recTitle = Main.loc("#labs_deepdive_keystonetagmatch");
		recBlurb = Main.loc("#labs_deepdive_keystonetagmatch_blurb");
		break;
	case "recdefault":
		recTitle = Main.loc("#labs_deepdive_defaultmatch");
		recBlurb = Main.loc("#labs_deepdive_defaultmatch_blurb");
		break;
	case "recgems":
		recTitle = Main.loc("#labs_deepdive_gemmatch");
		recBlurb = Main.loc("#labs_deepdive_gemmatch_blurb");
		break;
	case "recml":
		recTitle = Main.loc("#labs_deepdive_mlmatch");
		recBlurb = Main.loc("#labs_deepdive_mlmatch_blurb");
		break;
	}
	return { title : recTitle, blurb : recBlurb};
};
Render.boxContent = function(index,entry,sink,first) {
	if(first == null) {
		first = false;
	}
	if(sink == null) {
		sink = false;
	}
	if(entry == null) {
		return "";
	}
	var extra = "";
	if(sink) {
		extra += " sink";
	}
	var doodadId = "box-doodads-" + index;
	var wrapperId = "box-wrapper-" + index;
	var wrapperClass = "box-wrapper" + extra;
	var boxButtonsId = "box-buttons-" + index;
	var boxImageId = "box-image-" + index;
	var boxMicrotrailerId = "box-microtrailer-" + index;
	var boxTagsId = "box-tags-" + index;
	var boxPromptId = "box-prompt-" + index;
	var recommender = entry.recommender;
	var recTitle = "";
	var recBlurb = "";
	var recText = Render.similarBlurb(recommender);
	recTitle = recText.title;
	recBlurb = recText.blurb;
	var appid = entry.appid;
	var title = entry.title;
	var url = entry.url;
	var webm = entry.microtrailer_webm;
	var mpeg4 = entry.microtrailer_mpeg4;
	var discountBlock = entry.discountBlock;
	if(entry.comingSoon) {
		discountBlock = "<div class=\"discount_block discount_block_inline no_discount\" data-price-final=\"\">\r\n\t\t\t\t\t<div class=\"discount_prices\">\r\n\t\t\t\t\t\t<div class=\"discount_final_price\">Coming Soon</div>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>";
	}
	var tagHTML = entry.getTagHTML();
	var keyThings = first ? Main.loc("#labs_deepdive_keytags") : Main.loc("#labs_deepdive_keysimilarities");
	var selectToExplore = Main.loc("#labs_deepdive_selecttoexplore");
	var onWishlist = Main.LOGGED_IN && Main.onWishlist(appid);
	var isOwned = Main.LOGGED_IN && Main.isOwned(appid);
	var wishlistBtn = Main.LOGGED_IN ? Render.wishlistButton(appid,onWishlist,isOwned) : "";
	var detailsBtn = Render.detailsButton(appid,url);
	var headerURL = entry.header;
	var throbberStr = Render.throbber("throbber-" + index,true);
	var html = "<div class=\"" + wrapperClass + "\" id=\"" + wrapperId + "\" data-ds-appid=\"" + appid + "\">" + ("<a class=\"box-link\" href=\"javascript:Main.focus(" + appid + ")\"></a>") + ("<div class=\"box-image\" id=\"" + boxImageId + "\">") + throbberStr + ("<img src=\"" + headerURL + "\" alt=\"" + title + "\" title=\"" + title + "\">") + Render.microtrailer(index,entry,"microtrailer","","",true) + "</div>" + ("<div class=\"box-prompt hide-fancy\" id=\"" + boxPromptId + "\">") + ("<p>" + selectToExplore + "</p>") + "</div>" + ("<div class=\"box-doodads\" id=\"" + doodadId + "\">") + discountBlock + "</div>" + ("<div class=\"box-buttons\" id=\"" + boxButtonsId + "\">") + wishlistBtn + detailsBtn + "</div>" + ("<div class=\"box-tags hide-fancy\" id=\"" + boxTagsId + "\">") + ("<em class=\"key-tags-line\">" + keyThings + "<br></em>") + tagHTML + "</div>" + "</div>";
	return html;
};
Render.detailsButton = function(appid,url) {
	var details = Main.loc("#labs_deepdive_store_page_button");
	var details_short = Main.loc("#labs_deepdive_store_page_button_short");
	var newTabBtn = Main.cdnURL + "/labs/diving_bell/openinnewtab_icon.svg";
	return "<a href=\"" + url + "\" target=\"_blank\" class=\"btn_blue_steamui btn_small_tall btn-details\">\r\n\t\t\t<span>\t\r\n\t\t\t\t<span class=\"details_button_long\">" + details + "</span>\r\n\t\t\t\t<span class=\"details_button_short\">" + details_short + "</span>&nbsp;&nbsp;\r\n\t\t\t\t<img src=\"" + newTabBtn + "\">\r\n\t\t\t</span>\r\n\t\t</a>";
};
Render.wishlistButton = function(appid,onWishlist,isOwned) {
	if(isOwned == null) {
		isOwned = false;
	}
	if(onWishlist == null) {
		onWishlist = false;
	}
	var id = "wishlist-" + appid;
	if(isOwned) {
		var wishlist = Main.loc("#labs_deepdive_inlibrary");
		var cdn = Main.cdnURL;
		return "<a id=\"" + id + "\" href=\"#\" class=\"btn_blue_steamui btn_small_tall btn_disabled btn-wishlist\">\r\n\t\t\t\t<span>\r\n\t\t\t\t<img src=\"https://steamstore-a.akamaihd.net/public/images/v6/ico/ico_selected.png\" border=\"0\">\r\n\t\t\t\t" + wishlist + "\r\n\t\t\t\t</span>\r\n\t\t\t</a>";
	}
	if(!onWishlist) {
		var wishlist1 = Main.loc("#btn_add_to_wishlist");
		var wishlist_short = Main.loc("#btn_add_to_wishlist_short");
		return "<a id=\"" + id + "\" href=\"javascript:Main.addToWishlist(" + appid + ")\" class=\"btn_blue_steamui btn_small_tall btn-wishlist\">\r\n\t\t\t\t<span>\r\n\t\t\t\t<img src=\"https://steamstore-a.akamaihd.net/public/images/v6/ico/ico_selected.png\" border=\"0\">\r\n\t\t\t\t<span class=\"wishlist_button_long\">" + wishlist1 + "</span>\r\n\t\t\t\t<span class=\"wishlist_button_short\">" + wishlist_short + "</span>\r\n\t\t\t\t</span>\r\n\t\t\t</a>";
	} else {
		var wishlist2 = Main.loc("#labs_deepdive_onwishlist");
		var cdn1 = Main.cdnURL;
		return "<a id=\"" + id + "\" href=\"#\" class=\"btn_blue_steamui btn_small_tall btn_disabled btn-wishlist\">\r\n\t\t\t\t<span>\r\n\t\t\t\t<img src=\"https://steamstore-a.akamaihd.net/public/images/v6/ico/ico_selected.png\" border=\"0\">\r\n\t\t\t\t" + wishlist2 + "\r\n\t\t\t\t</span>\r\n\t\t\t</a>";
	}
};
Render.searchBox = function() {
	var html = "<div class=\"box focused\" id=\"box-focused\">" + Render.searchBoxContent() + "\n" + "</div>";
	return html;
};
Render.searchBoxContent = function() {
	var backgroundUrl = Main.cdnURL + "/labs/diving_bell/searchbackground.png";
	var gamesLike = Main.loc("#labs_deepdive_gameslike");
	var searchBlurb = Main.loc("#labs_deepdive_searchblurb");
	var search = Main.loc("#labs_deepdive_search");
	var searchSvg = Main.cdnURL + "/labs/diving_bell/search.svg";
	return "<div class=\"box-shadow\"></div>\r\n\t\t\t<div class=\"box-background\" style=\"background-image: url(" + backgroundUrl + ");\"></div>\r\n\t\t\t<div class=\"box-content\">\r\n\t\t\t\t<div class=\"games-like\">" + gamesLike + "</div>\r\n\t\t\t\t<br>\r\n\t\t\t\t<br>\r\n\t\t\t\t<input id=\"search-name\" type=\"text\" class=\"text-search-big\" placeholder=\"" + search + "\" autocomplete=\"off\" autofocus/>\r\n\t\t\t\t<button id=\"button-search\" class=\"button-search button-round\" onclick=\"trySearch()\">\r\n\t\t\t\t\t<img src=\"" + searchSvg + "\" class=\"search-icon\"/>\r\n\t\t\t\t</button>\r\n\t\t\t\t<hr>\r\n\t\t\t\t<p class=\"text-search-small\">" + searchBlurb + "</p>\r\n\t\t\t\t<div class=\"search-wrapper\">\r\n\t\t\t\t\t<div id=\"searchterm_options\" class=\"search_suggest popup_block_new\" style=\"display: none;\">\r\n\t\t\t\t\t<div class=\"popup_body\" style=\"border-top: none;\">\r\n\t\t\t\t\t\t<div id=\"search_suggestion_contents\">\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>";
};
Render.injectSearchContent = function(text) {
	return "<input id=\"search-name\" type=\"text\" class=\"text-search-big\" placeholder=\"" + text + "\" autocomplete=\"off\"/>\r\n\t\t<hr>\r\n\t\t<div id=\"searchterm_options\" class=\"search_suggest popup_block_new\" style=\"display: none;\">\r\n\t\t<div class=\"popup_body\" style=\"border-top: none;\">\r\n\t\t\t<div id=\"search_suggestion_contents\">\r\n\t\t\t</div>\r\n\t\t</div>";
};
Render.injectFocusContent = function(title) {
	var searchSvg = Main.cdnURL + "/labs/diving_bell/search.svg";
	return "<div class=\"search-container\" id=\"search-container\">\r\n\t\t\t<h2 id=\"focus-title\">" + title + "</h2>\r\n\t\t\t<button id=\"button-search\" class=\"button-search button-round\" onclick=\"trySearch()\">\r\n\t\t\t\t<img src=\"" + searchSvg + "\" class=\"search-icon\"/>\r\n\t\t\t</button>\r\n\t\t</div>";
};
Render.backRefreshButtons = function(enableBack,enableRefresh) {
	if(enableRefresh == null) {
		enableRefresh = true;
	}
	if(enableBack == null) {
		enableBack = true;
	}
	return Render.backRefreshButtonsContent(enableBack,enableRefresh) + "\n";
};
Render.backRefreshButtonsContent = function(enableBack,enableRefresh) {
	if(enableRefresh == null) {
		enableRefresh = true;
	}
	if(enableBack == null) {
		enableBack = true;
	}
	var backSvg = Main.cdnURL + "/labs/diving_bell/back.svg";
	var refreshSvg = Main.cdnURL + "/labs/diving_bell/refresh.svg";
	var refresh = Main.loc("#labs_deepdive_refresh");
	var back = Main.loc("#labs_deepdive_back");
	return "<div class='nav-button-wrapper'>" + ((enableBack ? "<button id=\"button-back\" class=\"button-back button-round\" onclick=\"Main.back()\">\r\n\t\t\t\t\t<p>" + back + "</p>\r\n\t\t\t\t\t<img src=\"" + backSvg + "\">\r\n\t\t\t\t </button>\n" : "<button id=\"button-back\" class=\"button-back button-round disabled\" onclick=\"\">\r\n\t\t\t\t\t<p>" + back + "</p>\r\n\t\t\t\t\t<img src=\"" + backSvg + "\">\r\n\t\t\t\t </button>\n") + (enableRefresh ? "<button id=\"button-refresh\" class=\"button-refresh button-round\" onclick=\"Main.refresh()\">\r\n\t\t\t\t\t<p>" + refresh + "</p>\r\n\t\t\t\t\t<img src=\"" + refreshSvg + "\">\r\n\t\t\t\t </button>\n" : "<button id=\"button-refresh\" class=\"button-refresh button-round disabled\" onclick=\"\">\r\n\t\t\t\t\t<p>" + refresh + "</p>\r\n\t\t\t\t\t<img src=\"" + refreshSvg + "\">\r\n\t\t\t\t </button>\n")) + "</div>";
};
Render.columnHeadersContent = function(first) {
	if(first == null) {
		first = false;
	}
	var html = "";
	var _g = 0;
	while(_g < 3) {
		var i = _g++;
		var headerText = Render.similarBlurb(Main.columnHeaders[i]).title;
		if(first) {
			headerText = "";
		}
		var boxHeaderId = "box-header-" + i;
		var boxColumn = "column-" + i;
		html += "<div id=\"" + boxHeaderId + "\" class=\"box-header " + boxColumn + "\">";
		html += "<a href=\"javascript:Main.clickColumn(" + i + ")\"><p>" + headerText + "</p></a>";
		html += "</div>";
	}
	return html;
};
Render.grid = function(recommendations,focus,sink,first) {
	if(first == null) {
		first = false;
	}
	if(sink == null) {
		sink = false;
	}
	var html = "";
	var b = 0;
	html += Render.backRefreshButtons();
	html += "<section class=\"side-panel\" id=\"side-panel\">\n";
	if(focus != null) {
		html += Render.focusBox(focus) + "\n";
	} else {
		html += Render.searchBox() + "\n";
	}
	html += "</section>\n";
	html += "<section class=\"grid-container\" id=\"grid\">";
	html += "<section id=\"header-container\" class=\"header-container\">";
	html += Render.columnHeadersContent(first);
	html += "</section>";
	var _g = 0;
	while(_g < 3) {
		var i = _g++;
		html += "<section class=\"box-container\">";
		var j = 0;
		var _g1 = 0;
		while(_g1 < 3) {
			var j1 = _g1++;
			var entry = recommendations[b];
			html += Render.box(b,entry,sink,first);
			++b;
		}
		html += "</section>";
	}
	html += "<section>";
	return html;
};
Render.hydrateBoxes = function(overwrite) {
	if(overwrite == null) {
		overwrite = false;
	}
	var successes = 0;
	var _g = 0;
	while(_g < 9) {
		var i = _g++;
		var entry = Main.boxEntries[i];
		var success = Render.hydrateMicrotrailer(i,entry,"microtrailer","",overwrite);
		if(success) {
			++successes;
		}
	}
	if(successes == 9) {
		return true;
	}
	return false;
};
var Std = function() { };
Std.__name__ = true;
Std.string = function(s) {
	return js_Boot.__string_rec(s,"");
};
Std.parseInt = function(x) {
	var v = parseInt(x,10);
	if(v == 0 && (HxOverrides.cca(x,1) == 120 || HxOverrides.cca(x,1) == 88)) {
		v = parseInt(x);
	}
	if(isNaN(v)) {
		return null;
	}
	return v;
};
var StrTool = function() { };
StrTool.__name__ = true;
StrTool.fu = function(str) {
	var first = str.charAt(0);
	var rest = HxOverrides.substr(str,1,str.length - 1);
	return first.toUpperCase() + rest;
};
StrTool.urlToAppid = function(str) {
	if(str.indexOf("https://") == 0) {
		var arr = str.split("/");
		var _g = 0;
		while(_g < arr.length) {
			var bit = arr[_g];
			++_g;
			var num = Std.parseInt(bit);
			if(num != null) {
				if(num == null) {
					return "null";
				} else {
					return "" + num;
				}
			}
		}
	}
	return "";
};
StrTool.isLink = function(str) {
	if(str.indexOf("https://") == 0) {
		return true;
	}
	if(str.indexOf("http://") == 0) {
		return true;
	}
	return false;
};
var StringTools = function() { };
StringTools.__name__ = true;
StringTools.isSpace = function(s,pos) {
	var c = HxOverrides.cca(s,pos);
	if(!(c > 8 && c < 14)) {
		return c == 32;
	} else {
		return true;
	}
};
StringTools.ltrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,r)) ++r;
	if(r > 0) {
		return HxOverrides.substr(s,r,l - r);
	} else {
		return s;
	}
};
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
};
var TagDB = function(map,tags) {
	this.allCategories = [];
	this.allTags = [];
	this.id2Cat = map;
	this.cat2Id = new haxe_ds_StringMap();
	this.id2Name = new haxe_ds_StringMap();
	var id = map.keys();
	while(id.hasNext()) {
		var id1 = id.next();
		var cats = __map_reserved[id1] != null ? map.getReserved(id1) : map.h[id1];
		var _g = 0;
		while(_g < cats.length) {
			var cat = cats[_g];
			++_g;
			this._addIdToCat(id1,cat,this.cat2Id);
			if(this.allCategories.indexOf(cat) == -1) {
				this.allCategories.push(cat);
			}
		}
		if(this.allTags.indexOf(id1) == -1) {
			this.allTags.push(id1);
		}
	}
	var id2 = tags.keys();
	while(id2.hasNext()) {
		var id3 = id2.next();
		var name = __map_reserved[id3] != null ? tags.getReserved(id3) : tags.h[id3];
		var _this = this.id2Name;
		if(__map_reserved[id3] != null) {
			_this.setReserved(id3,name);
		} else {
			_this.h[id3] = name;
		}
	}
};
TagDB.__name__ = true;
TagDB.prototype = {
	getName: function(id) {
		var _this = this.id2Name;
		if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
			var _this1 = this.id2Name;
			if(__map_reserved[id] != null) {
				return _this1.getReserved(id);
			} else {
				return _this1.h[id];
			}
		}
		return "tag<" + id + ">";
	}
	,copyTagMatch: function(tm) {
		var tm2 = { category : tm.category, tags : tm.tags != null ? tm.tags.slice() : null, weight : tm.weight, focusCount : tm.focusCount, otherCount : tm.otherCount};
		return tm2;
	}
	,copyTagMatchArr: function(arr) {
		var results = [];
		var _g = 0;
		while(_g < arr.length) {
			var tm = arr[_g];
			++_g;
			var tm2 = this.copyTagMatch(tm);
			results.push(tm2);
		}
		return results;
	}
	,normalizeMatches: function(matches) {
		var results = [];
		var focusTotal = 0.0;
		var otherTotal = 0.0;
		var _g = 0;
		while(_g < matches.length) {
			var match = matches[_g];
			++_g;
			focusTotal += match.focusCount;
			otherTotal += match.otherCount;
		}
		var hasSex = false;
		var hasViolence = false;
		var _g1 = 0;
		while(_g1 < matches.length) {
			var match1 = matches[_g1];
			++_g1;
			match1.focusCount /= focusTotal;
			match1.otherCount /= otherTotal;
			var score = (match1.focusCount - Math.abs(match1.focusCount - match1.otherCount)) * match1.weight;
			results.push({ category : match1.category, score : score, tags : match1.tags.slice()});
			if(match1.category == "sex") {
				hasSex = true;
			}
			if(match1.category == "violence") {
				hasViolence = true;
			}
		}
		if(hasSex || hasViolence) {
			var _g11 = 0;
			var _g2 = results.length;
			while(_g11 < _g2) {
				var i = _g11++;
				var j = results.length - i - 1;
				var result = results[j];
				if(result != null && result.category == "warning") {
					results.splice(j,1);
				}
			}
		}
		var _g12 = 0;
		var _g3 = results.length;
		while(_g12 < _g3) {
			var i1 = _g12++;
			var result1 = results[i1];
			var _g31 = 0;
			var _g21 = results.length;
			while(_g31 < _g21) {
				var j1 = _g31++;
				if(i1 == j1) {
					continue;
				}
				var other = results[j1];
				var _g4 = 0;
				var _g5 = result1.tags;
				while(_g4 < _g5.length) {
					var tag = _g5[_g4];
					++_g4;
					if(other.tags.indexOf(tag) != -1) {
						HxOverrides.remove(other.tags,tag);
						if(other.tags.length == 0) {
							other.score = 0.0;
						}
					}
				}
			}
			if(result1.tags.length == 0) {
				result1.score = 0.0;
			}
		}
		results.sort(function(a,b) {
			if(a.score > b.score) {
				return -1;
			}
			if(a.score < b.score) {
				return 1;
			}
			return 0;
		});
		return results;
	}
	,trimSynonyms: function(arr) {
		var kills = [];
		var _g1 = 0;
		var _g = arr.length;
		while(_g1 < _g) {
			var i = _g1++;
			var tag = arr[i];
			var _g3 = 0;
			var _g2 = arr.length;
			while(_g3 < _g2) {
				var j = _g3++;
				if(i == j) {
					continue;
				}
				var othertag = arr[j];
				if(this.isSynonym(tag,othertag) || this.isSynonym(othertag,tag)) {
					if(kills.indexOf(tag) == -1) {
						kills.push(othertag);
					}
				} else {
					var unPreferred = this.isNotPreferred(tag,othertag);
					if(unPreferred == "") {
						unPreferred = this.isNotPreferred(othertag,tag);
					}
					if(unPreferred != "") {
						if(kills.indexOf(unPreferred) == -1) {
							kills.push(unPreferred);
						}
					}
				}
			}
		}
		var _g4 = 0;
		while(_g4 < kills.length) {
			var kill = kills[_g4];
			++_g4;
			HxOverrides.remove(arr,kill);
		}
		return arr;
	}
	,isNotPreferred: function(a,b) {
		if(a == "3959" && b == "1716") {
			return b;
		}
		if(a == "3859") {
			if(b == "128" || b == "7368" || b == "3841" || b == "3843" || b == "1685" || b == "17770") {
				return a;
			}
		}
		if(a == "5611") {
			if(b == "6650" || b == "12095" || b == "24904" || b == "4667" || b == "4345" || b == "5228") {
				return a;
			}
		}
		if(a == "24904") {
			if(b == "6650" || b == "12095" || b == "5611" || b == "4667" || b == "4345" || b == "5228") {
				return a;
			}
		}
		if(a == "1677") {
			if(b == "1741" || b == "4325" || b == "14139") {
				return a;
			}
		}
		if(a == "3871") {
			if(b == "4736" || b == "4975") {
				return a;
			}
		}
		return "";
	}
	,isSynonym: function(a,b) {
		if(a == "1719" && b == "4136") {
			return true;
		}
		return false;
	}
	,compare: function(focusedTags,otherTags) {
		var focusCategories = [];
		var otherCategories = [];
		var report = { focus : { categories : [], counts : new haxe_ds_StringMap()}, other : { categories : [], counts : new haxe_ds_StringMap()}, matches : []};
		var i = 0;
		var _g = 0;
		while(_g < focusedTags.length) {
			var tag = focusedTags[_g];
			++_g;
			var id = tag.tagid;
			var value = tag.count;
			var _this = report.focus.counts;
			if(__map_reserved[id] != null) {
				_this.setReserved(id,value);
			} else {
				_this.h[id] = value;
			}
			var _this1 = this.id2Cat;
			var cats = __map_reserved[id] != null ? _this1.getReserved(id) : _this1.h[id];
			if(cats != null) {
				var _g1 = 0;
				while(_g1 < cats.length) {
					var cat = cats[_g1];
					++_g1;
					if(focusCategories.indexOf(cat) == -1) {
						focusCategories.push(cat);
						report.focus.categories.push({ name : cat, value : 0.0, multiplier : this.getCategoryWeight(cat)});
					}
					var index = focusCategories.indexOf(cat);
					var weight = report.focus.categories[index];
					weight.value += tag.count;
				}
				var _g11 = 0;
				while(_g11 < otherTags.length) {
					var oTag = otherTags[_g11];
					++_g11;
					var oid = oTag.tagid;
					if(id == oid) {
						var _g2 = 0;
						while(_g2 < cats.length) {
							var cat1 = cats[_g2];
							++_g2;
							var tagMatch = null;
							var _g3 = 0;
							var _g4 = report.matches;
							while(_g3 < _g4.length) {
								var match = _g4[_g3];
								++_g3;
								if(match.category == cat1) {
									tagMatch = match;
									break;
								}
							}
							if(tagMatch == null) {
								tagMatch = { category : cat1, tags : [id], weight : this.getCategoryWeight(cat1), focusCount : tag.count, otherCount : oTag.count};
								report.matches.push(tagMatch);
							} else {
								tagMatch.category = cat1;
								if(tagMatch.tags.indexOf(id) == -1) {
									tagMatch.tags.push(id);
									tagMatch.focusCount += tag.count;
									tagMatch.otherCount += oTag.count;
								}
							}
						}
						break;
					}
				}
			}
			++i;
		}
		var _g5 = 0;
		while(_g5 < otherTags.length) {
			var oTag1 = otherTags[_g5];
			++_g5;
			var oid1 = oTag1.tagid;
			var value1 = oTag1.count;
			var _this2 = report.other.counts;
			if(__map_reserved[oid1] != null) {
				_this2.setReserved(oid1,value1);
			} else {
				_this2.h[oid1] = value1;
			}
			var _this3 = this.id2Cat;
			var ocats = __map_reserved[oid1] != null ? _this3.getReserved(oid1) : _this3.h[oid1];
			if(ocats != null) {
				var _g12 = 0;
				while(_g12 < ocats.length) {
					var ocat = ocats[_g12];
					++_g12;
					if(otherCategories.indexOf(ocat) == -1) {
						otherCategories.push(ocat);
						report.other.categories.push({ name : ocat, value : 0.0, multiplier : this.getCategoryWeight(ocat)});
					}
					var index1 = otherCategories.indexOf(ocat);
					var weight1 = report.other.categories[index1];
					weight1.value += oTag1.count;
				}
			}
		}
		var byValue = function(a,b) {
			if(a.value * a.multiplier > b.value * b.multiplier) {
				return -1;
			}
			if(a.value * a.multiplier < b.value * b.multiplier) {
				return 1;
			}
			return 0;
		};
		report.focus.categories.sort(byValue);
		report.other.categories.sort(byValue);
		return report;
	}
	,getCategoryWeight: function(cat) {
		switch(cat) {
		case "adjective":
			return 1.00;
		case "assessment":
			return 3.00;
		case "audio":
			return 1.00;
		case "challenge":
			return 3.00;
		case "character":
			return 1.00;
		case "controls":
			return 2.00;
		case "coop":
			return 1.00;
		case "customization":
			return 1.00;
		case "feature":
			return 2.00;
		case "franchise":
			return 1.00;
		case "genre":
			return 2.00;
		case "hardware":
			return 1.00;
		case "level design":
			return 1.00;
		case "military":
			return 1.00;
		case "misc":
			return 0.50;
		case "mods":
			return 1.00;
		case "mood":
			return 2.00;
		case "multiplayer":
			return 1.00;
		case "noun":
			return 1.00;
		case "period":
			return 1.00;
		case "players":
			return 0.00;
		case "scary":
			return 1.00;
		case "setting":
			return 1.00;
		case "sex":
			return 4.00;
		case "sport":
			return 1.00;
		case "story":
			return 2.00;
		case "subgenre":
			return 4.00;
		case "supergenre":
			return 0.50;
		case "theme":
			return 2.00;
		case "tool":
			return 1.00;
		case "viewpoint":
			return 1.00;
		case "violence":
			return 4.00;
		case "visuals":
			return 1.00;
		case "warning":
			return 2.00;
		case "weak":
			return 0.25;
		default:
			return 1.00;
		}
	}
	,_addIdToCat: function(id,cat,map) {
		if((__map_reserved[cat] != null ? map.existsReserved(cat) : map.h.hasOwnProperty(cat)) == false) {
			var value = [];
			if(__map_reserved[cat] != null) {
				map.setReserved(cat,value);
			} else {
				map.h[cat] = value;
			}
		}
		var ids = __map_reserved[cat] != null ? map.getReserved(cat) : map.h[cat];
		if(ids.indexOf(id) == -1) {
			ids.push(id);
		}
	}
	,__class__: TagDB
};
var haxe_IMap = function() { };
haxe_IMap.__name__ = true;
var haxe_Http = function(url) {
	this.url = url;
	this.headers = new List();
	this.params = new List();
	this.async = true;
	this.withCredentials = false;
};
haxe_Http.__name__ = true;
haxe_Http.prototype = {
	addParameter: function(param,value) {
		this.params.push({ param : param, value : value});
		return this;
	}
	,request: function(post) {
		var me = this;
		me.responseData = null;
		var r = this.req = js_Browser.createXMLHttpRequest();
		var onreadystatechange = function(_) {
			if(r.readyState != 4) {
				return;
			}
			var s;
			try {
				s = r.status;
			} catch( e ) {
				s = null;
			}
			if(s != null && "undefined" !== typeof window) {
				var protocol = window.location.protocol.toLowerCase();
				var rlocalProtocol = new EReg("^(?:about|app|app-storage|.+-extension|file|res|widget):$","");
				var isLocal = rlocalProtocol.match(protocol);
				if(isLocal) {
					if(r.responseText != null) {
						s = 200;
					} else {
						s = 404;
					}
				}
			}
			if(s == undefined) {
				s = null;
			}
			if(s != null) {
				me.onStatus(s);
			}
			if(s != null && s >= 200 && s < 400) {
				me.req = null;
				me.onData(me.responseData = r.responseText);
			} else if(s == null) {
				me.req = null;
				me.onError("Failed to connect or resolve host");
			} else {
				switch(s) {
				case 12007:
					me.req = null;
					me.onError("Unknown host");
					break;
				case 12029:
					me.req = null;
					me.onError("Failed to connect to host");
					break;
				default:
					me.req = null;
					me.responseData = r.responseText;
					me.onError("Http Error #" + r.status);
				}
			}
		};
		if(this.async) {
			r.onreadystatechange = onreadystatechange;
		}
		var uri = this.postData;
		if(uri != null) {
			post = true;
		} else {
			var _g_head = this.params.h;
			while(_g_head != null) {
				var val = _g_head.item;
				_g_head = _g_head.next;
				var p = val;
				if(uri == null) {
					uri = "";
				} else {
					uri += "&";
				}
				var s1 = p.param;
				var uri1 = encodeURIComponent(s1) + "=";
				var s2 = p.value;
				uri += uri1 + encodeURIComponent(s2);
			}
		}
		try {
			if(post) {
				r.open("POST",this.url,this.async);
			} else if(uri != null) {
				var question = this.url.split("?").length <= 1;
				r.open("GET",this.url + (question ? "?" : "&") + uri,this.async);
				uri = null;
			} else {
				r.open("GET",this.url,this.async);
			}
		} catch( e1 ) {
			if (e1 instanceof js__$Boot_HaxeError) e1 = e1.val;
			me.req = null;
			this.onError(e1.toString());
			return;
		}
		r.withCredentials = this.withCredentials;
		if(!Lambda.exists(this.headers,function(h) {
			return h.header == "Content-Type";
		}) && post && this.postData == null) {
			r.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
		}
		var _g_head1 = this.headers.h;
		while(_g_head1 != null) {
			var val1 = _g_head1.item;
			_g_head1 = _g_head1.next;
			var h1 = val1;
			r.setRequestHeader(h1.header,h1.value);
		}
		r.send(uri);
		if(!this.async) {
			onreadystatechange(null);
		}
	}
	,onData: function(data) {
	}
	,onError: function(msg) {
	}
	,onStatus: function(status) {
	}
	,__class__: haxe_Http
};
var haxe_ds_StringMap = function() {
	this.h = { };
};
haxe_ds_StringMap.__name__ = true;
haxe_ds_StringMap.__interfaces__ = [haxe_IMap];
haxe_ds_StringMap.prototype = {
	setReserved: function(key,value) {
		if(this.rh == null) {
			this.rh = { };
		}
		this.rh["$" + key] = value;
	}
	,getReserved: function(key) {
		if(this.rh == null) {
			return null;
		} else {
			return this.rh["$" + key];
		}
	}
	,existsReserved: function(key) {
		if(this.rh == null) {
			return false;
		}
		return this.rh.hasOwnProperty("$" + key);
	}
	,keys: function() {
		return HxOverrides.iter(this.arrayKeys());
	}
	,arrayKeys: function() {
		var out = [];
		for( var key in this.h ) {
		if(this.h.hasOwnProperty(key)) {
			out.push(key);
		}
		}
		if(this.rh != null) {
			for( var key in this.rh ) {
			if(key.charCodeAt(0) == 36) {
				out.push(key.substr(1));
			}
			}
		}
		return out;
	}
	,__class__: haxe_ds_StringMap
};
var js__$Boot_HaxeError = function(val) {
	Error.call(this);
	this.val = val;
	this.message = String(val);
	if(Error.captureStackTrace) {
		Error.captureStackTrace(this,js__$Boot_HaxeError);
	}
};
js__$Boot_HaxeError.__name__ = true;
js__$Boot_HaxeError.wrap = function(val) {
	if((val instanceof Error)) {
		return val;
	} else {
		return new js__$Boot_HaxeError(val);
	}
};
js__$Boot_HaxeError.__super__ = Error;
js__$Boot_HaxeError.prototype = $extend(Error.prototype,{
	__class__: js__$Boot_HaxeError
});
var js_Boot = function() { };
js_Boot.__name__ = true;
js_Boot.getClass = function(o) {
	if((o instanceof Array) && o.__enum__ == null) {
		return Array;
	} else {
		var cl = o.__class__;
		if(cl != null) {
			return cl;
		}
		var name = js_Boot.__nativeClassName(o);
		if(name != null) {
			return js_Boot.__resolveNativeClass(name);
		}
		return null;
	}
};
js_Boot.__string_rec = function(o,s) {
	if(o == null) {
		return "null";
	}
	if(s.length >= 5) {
		return "<...>";
	}
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) {
		t = "object";
	}
	switch(t) {
	case "function":
		return "<function>";
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) {
					return o[0];
				}
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2;
				var _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) {
						str += "," + js_Boot.__string_rec(o[i],s);
					} else {
						str += js_Boot.__string_rec(o[i],s);
					}
				}
				return str + ")";
			}
			var l = o.length;
			var i1;
			var str1 = "[";
			s += "\t";
			var _g11 = 0;
			var _g2 = l;
			while(_g11 < _g2) {
				var i2 = _g11++;
				str1 += (i2 > 0 ? "," : "") + js_Boot.__string_rec(o[i2],s);
			}
			str1 += "]";
			return str1;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
			var s2 = o.toString();
			if(s2 != "[object Object]") {
				return s2;
			}
		}
		var k = null;
		var str2 = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) {
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str2.length != 2) {
			str2 += ", \n";
		}
		str2 += s + k + " : " + js_Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str2 += "\n" + s + "}";
		return str2;
	case "string":
		return o;
	default:
		return String(o);
	}
};
js_Boot.__interfLoop = function(cc,cl) {
	if(cc == null) {
		return false;
	}
	if(cc == cl) {
		return true;
	}
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0;
		var _g = intf.length;
		while(_g1 < _g) {
			var i = _g1++;
			var i1 = intf[i];
			if(i1 == cl || js_Boot.__interfLoop(i1,cl)) {
				return true;
			}
		}
	}
	return js_Boot.__interfLoop(cc.__super__,cl);
};
js_Boot.__instanceof = function(o,cl) {
	if(cl == null) {
		return false;
	}
	switch(cl) {
	case Array:
		if((o instanceof Array)) {
			return o.__enum__ == null;
		} else {
			return false;
		}
		break;
	case Bool:
		return typeof(o) == "boolean";
	case Dynamic:
		return true;
	case Float:
		return typeof(o) == "number";
	case Int:
		if(typeof(o) == "number") {
			return (o|0) === o;
		} else {
			return false;
		}
		break;
	case String:
		return typeof(o) == "string";
	default:
		if(o != null) {
			if(typeof(cl) == "function") {
				if(o instanceof cl) {
					return true;
				}
				if(js_Boot.__interfLoop(js_Boot.getClass(o),cl)) {
					return true;
				}
			} else if(typeof(cl) == "object" && js_Boot.__isNativeObj(cl)) {
				if(o instanceof cl) {
					return true;
				}
			}
		} else {
			return false;
		}
		if(cl == Class ? o.__name__ != null : false) {
			return true;
		}
		if(cl == Enum ? o.__ename__ != null : false) {
			return true;
		}
		return o.__enum__ == cl;
	}
};
js_Boot.__cast = function(o,t) {
	if(js_Boot.__instanceof(o,t)) {
		return o;
	} else {
		throw new js__$Boot_HaxeError("Cannot cast " + Std.string(o) + " to " + Std.string(t));
	}
};
js_Boot.__nativeClassName = function(o) {
	var name = js_Boot.__toStr.call(o).slice(8,-1);
	if(name == "Object" || name == "Function" || name == "Math" || name == "JSON") {
		return null;
	}
	return name;
};
js_Boot.__isNativeObj = function(o) {
	return js_Boot.__nativeClassName(o) != null;
};
js_Boot.__resolveNativeClass = function(name) {
	return $global[name];
};
var js_Browser = function() { };
js_Browser.__name__ = true;
js_Browser.createXMLHttpRequest = function() {
	if(typeof XMLHttpRequest != "undefined") {
		return new XMLHttpRequest();
	}
	if(typeof ActiveXObject != "undefined") {
		return new ActiveXObject("Microsoft.XMLHTTP");
	}
	throw new js__$Boot_HaxeError("Unable to create XMLHttpRequest object.");
};
var js_Cookie = function() { };
js_Cookie.__name__ = true;
js_Cookie.set = function(name,value,expireDelay,path,domain) {
	var s = name + "=" + encodeURIComponent(value);
	if(expireDelay != null) {
		var t = new Date().getTime() + expireDelay * 1000;
		var d = new Date(t);
		s += ";expires=" + d.toGMTString();
	}
	if(path != null) {
		s += ";path=" + path;
	}
	if(domain != null) {
		s += ";domain=" + domain;
	}
	window.document.cookie = s;
};
js_Cookie.all = function() {
	var h = new haxe_ds_StringMap();
	var a = window.document.cookie.split(";");
	var _g = 0;
	while(_g < a.length) {
		var e = a[_g];
		++_g;
		e = StringTools.ltrim(e);
		var t = e.split("=");
		if(t.length < 2) {
			continue;
		}
		var key = t[0];
		var value = decodeURIComponent(t[1].split("+").join(" "));
		if(__map_reserved[key] != null) {
			h.setReserved(key,value);
		} else {
			h.h[key] = value;
		}
	}
	return h;
};
js_Cookie.get = function(name) {
	var _this = js_Cookie.all();
	if(__map_reserved[name] != null) {
		return _this.getReserved(name);
	} else {
		return _this.h[name];
	}
};
function $iterator(o) { if( o instanceof Array ) return function() { return HxOverrides.iter(o); }; return typeof(o.iterator) == 'function' ? $bind(o,o.iterator) : o.iterator; }
var $_, $fid = 0;
function $bind(o,m) { if( m == null ) return null; if( m.__id__ == null ) m.__id__ = $fid++; var f; if( o.hx__closures__ == null ) o.hx__closures__ = {}; else f = o.hx__closures__[m.__id__]; if( f == null ) { f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; o.hx__closures__[m.__id__] = f; } return f; }
String.prototype.__class__ = String;
String.__name__ = true;
Array.__name__ = true;
Date.prototype.__class__ = Date;
Date.__name__ = ["Date"];
var Int = { __name__ : ["Int"]};
var Dynamic = { __name__ : ["Dynamic"]};
var Float = Number;
Float.__name__ = ["Float"];
var Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = { __name__ : ["Class"]};
var Enum = { };
var __map_reserved = {};
Main.matchPage = 0;
Main.breadcrumbs = [];
Main.breadcrumbTitles = [];
Main.breadcrumbBoxEntries = [];
Main.refreshHistory = [];
Main.cdnURL = "";
Main.baseURL = "";
Main.lastMatchCount = 0;
Main.VARIANT = 0;
Main.LIST = 0;
Main.EMOJI = 0;
Main.HOVER = 0;
Main.APPID = "";
Main.LOGGED_IN = false;
Main.tempWishlist = [];
Main.justClickedBreadcrumb = false;
Main.justClickedAppBack = false;
Main.originalHistory = "";
Main.focusBusy = false;
Main.MICROTRAILERS = true;
Main.columnHeaders = ["reccats","recdefault","recgems"];
Main.FEATURE_FLAG_KILLABLE_TAGS = false;
Main.FEATURE_FLAG_ML_RECOMMENDER = false;
Main.baseMap = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz01234567889+*";
Main.ignorePopStateEvents = false;
js_Boot.__toStr = ({ }).toString;
Main.main();
})(typeof exports != "undefined" ? exports : typeof window != "undefined" ? window : typeof self != "undefined" ? self : this, typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : this);
