var lastFilter = '';
var TotalGames = 0;
var PageStart = 0;
var PageEnd = 0;
var LoadedIDs = [];
var LoadedChangingIDs = [];
var AllLoaded = false;
var ActivationRetries = 0;
var DimButtonList = [];

function AlignMenuCumulative( elemLink, elemPopup, align, valign )
{
	var align = align ? align : 'left';

	if ( !valign )
	{
		//if there's not enough room between our spot and the top of the document, we definitely want to drop down
		if ( document.viewport.getScrollOffsets().top + elemLink.viewportOffset().top < nPopupHeight )
			valign = 'bottom';
		else
		{
			// add a little bit of padding so we don't position it flush to an edge if possible
			var nPopupHeight = elemPopup.getHeight() + 8;
			var nSpaceAbove = elemLink.viewportOffset().top;
			var nSpaceBelow = document.viewport.getHeight() - elemLink.viewportOffset().top;
			//otherwise we only want to drop down if we've got enough space below us (measured based on view area)
			// or if there's not enough space above to pop in either direction and there's more space below
			if ( nSpaceBelow > nPopupHeight || ( nSpaceAbove < nPopupHeight && nSpaceBelow > nSpaceAbove ) )
				valign = 'bottom';
			else
				valign = 'top';

		}
	}

	if ( align == 'left' )
	{
		elemPopup.style.left = ( elemLink.cumulativeOffset()[0] - 12 ) + 'px';
	}
	else if ( align == 'right' )
	{
		elemPopup.style.left = ( elemLink.cumulativeOffset()[0] + elemLink.getWidth() - elemPopup.getWidth() + 13 ) + 'px';
	}
	else if ( align == 'leftsubmenu' )
	{
		elemPopup.style.left = ( elemLink.cumulativeOffset()[0] - elemPopup.getWidth() + 12 ) + 'px';
	}
	else if ( align == 'rightsubmenu' )
	{
		elemPopup.style.left = ( elemLink.cumulativeOffset()[0] + elemLink.getWidth() - 12 ) + 'px';
	}

	if ( valign == 'bottom' )
	{
		elemPopup.style.top = ( elemLink.cumulativeOffset()[1] + elemLink.getHeight() - 12 ) + 'px';
	}
	else if ( valign == 'top' )
	{
		elemPopup.style.top = ( elemLink.cumulativeOffset()[1] - elemPopup.getHeight() + 12 ) + 'px';
	}
	else if ( valign == 'bottomsubmenu' )
	{
		elemPopup.style.top = ( elemLink.cumulativeOffset()[1] - 12 ) + 'px';
	}
}

function ShowMenuCumulative( elemLink, elemPopup, align, valign )
{
	var elemLink = $(elemLink);
	var elemPopup = $(elemPopup);
	
	// used for modal navigation support on gamepad
	var fnUnregisterShowMenuCumulative = null;

	AlignMenuCumulative( elemLink, elemPopup, align, valign );

	ShowWithFade( elemPopup );
	Element.addClassName.defer(elemLink,'focus');

	// if we're on gamepad, register this menu as a modal window
	if ( typeof GPOnShowingModalWindow === "function" )
	{
		fnUnregisterShowMenuCumulative = GPOnShowingModalWindow( elemPopup );
	}

	RegisterPopupDismissal( function() 
	{ 
		HideWithFade( elemPopup ); 
		elemLink.removeClassName('focus'); 

		// tell gamepad navigation the modal closed
		if ( fnUnregisterShowMenuCumulative )
		{
			fnUnregisterShowMenuCumulative();
			fnUnregisterShowMenuCumulative = null;
		}
	}, elemPopup );
}

function filterApps()
{
	filterString = $('gameFilter').value;
	filterString = filterString.toLowerCase();
	if ( filterString == lastFilter )
		return;
	rgGames.each(function(game, index)
	{
		var appid = game['appid'];
		if ( parseInt( appid ) != appid )
		{
			return;
		}
		lc = game['name'].toString().toLowerCase();
		if ( filterString.length == 0 || lc.indexOf( filterString ) != -1 )
		{
			z = $('game_'+appid);
			if ( z != null )
				$('game_'+appid).style.display = 'block';
		}
		else
		{
			z = $('game_'+appid);
			if ( z != null )
				$('game_'+appid).style.display = 'none';
		}
	});
	lastFilter = filterString;

	CScrollOffsetWatcher.ForceRecalc();
}

function AchievementHover( elem, event, divHover )
{
	if (!event) var event = window.event;
    elem = $(elem);

	var hover = $(divHover);
	if ( hover.visible() && hover.target == elem )
	{
		return;
	}
	else if ( ( !hover.visible() || hover.target != elem ) )
	{
		var name=elem.getAttribute( 'data-ach-name' );
		var description = elem.getAttribute( 'data-ach-description' );
		hover.down('.content').update( "<h1>" + name + "</h1>" + description );
		ShowAchievementHover( elem, divHover );
	}
}

function HideAchievementHover( elem, event, divHover )
{
	if (!event) var event = window.event;
	var reltarget = (event.relatedTarget) ? event.relatedTarget : event.toElement;
	if ( reltarget && $(reltarget).up( '#' + elem.identify() ) )
	{
		return;
	}
	divHover.hide();
}

function ShowAchievementHover( elem, divHover )
{

	var hover = $(divHover);
	hover.style.visibility = 'hidden';
	hover.show();

	hover.clonePosition( elem, {setWidth: false, setHeight: false} );
	var hover_box = hover.down( '.hover_box' );
	var hover_arrow = hover.down( '.hover_arrow' );

	if ( Prototype.Browser.IE )
	{
		hover.style.paddingTop = '12px';
		hover_box.style.marginTop = '0px';
	}

	hover.style.left = ( parseInt( hover.style.left ) - 12 ) + 'px';
	hover.style.top = ( parseInt( hover.style.top ) + 33 ) + 'px';

	var boxTopViewport = elem.viewportOffset().top;
	if ( boxTopViewport + hover_box.getHeight() + 8 > document.viewport.getHeight() )
	{
		var nViewportAdjustment = ( hover_box.getHeight() + 8 ) - ( document.viewport.getHeight() - boxTopViewport );
				nViewportAdjustment = Math.min( hover_box.getHeight() - 74, nViewportAdjustment );
		hover.style.top = ( parseInt( hover.style.top ) - nViewportAdjustment ) + 'px';

		hover_arrow.style.top = ( 48 + nViewportAdjustment ) + 'px';
	}
	else
	{
		hover_arrow.style.top = '';
	}

	hover.style.visibility = '';

	hover.target = elem;
}



var gameTemplate = new Template( "<div class=\"gameListRowLogo #{logo_class}\">\n\t<a href=\"#{link}\">\n\t\t<img class=\"game_capsule\" src=\"https:\/\/community.cloudflare.steamstatic.com\/public\/images\/trans.gif\" id=\"delayedimage_game_logo_#{appid}_0\">\n\t<\/a>\n<\/div>\n<div class=\"gameListRowItem\">\n\t#{achievement_block}\n\t<div class=\"gameListRowItemTop\">\n\t\t<div class=\"gameListRowItemTopPrimary\">\n\t\t\t<div class=\"gameListRowItemName ellipsis #{text_color}\">#{name_escaped}<\/div>\n\t\t\t<h5 class=\"ellipsis hours_played\">#{hours_message}<\/h5>\n\t\t<\/div>\n\t\t<div class=\"gameListRowItemTopSecondary\">\n    \t\t#{client_block}\n\t\t<\/div>\n\t<\/div>\n\t<div class=\"bottom_controls\">\n\t\t<div data-panel=\"{&quot;focusable&quot;:true,&quot;clickOnActivate&quot;:true}\" class=\"pullup_item\" onclick=\"ShowMenuCumulative( this, 'links_dropdown_#{appid}', 'left' );\">\n\t\t\t<div class=\"menu_ico\">\n\t\t\t\t<img src=\"https:\/\/community.cloudflare.steamstatic.com\/public\/images\/skin_1\/ico_www.png\" width=\"16\" height=\"16\" border=\"0\" \/>\n\t\t\t<\/div>\n\t\t\tLinks\t\t\t<img src=\"https:\/\/community.cloudflare.steamstatic.com\/public\/images\/header\/btn_arrow_down.png\" border=\"0\" class=\"menuarrow\" \/>\n\t\t<\/div>\n\t\t\t#{stats_button} #{gcpd_button} #{review_button}\n\t\t<\/div>\n\t<\/div>\n<\/div>\n" );
var changingGameTemplate = new Template( "<div class=\"changingGameListRowLogo\">\n\t<div class=\"changingGameLogoHolder\">\n        <div class=\"changingGameLogo\">\n            <a href=\"#{link}\">\n\t\t\t\t<img src=\"https:\/\/community.cloudflare.steamstatic.com\/public\/images\/trans.gif\" id=\"delayedimage_game_logo_#{appid}\">\n            <\/a>\n        <\/div>\n    <\/div>\n<\/div>\n<div class=\"changingGameListRowItem\">\n\t<div class=\"gameListRowItemName #{text_color}\">#{name_escaped}<\/div>\n\t<h5>#{hours_message}<\/h5>\n<\/div>\n" );
var gameHoursForeverTemplate = new Template ( '#{hours_forever} hrs on record' );
var gameHoursRecentTemplate = new Template ( '#{hours} hrs last two weeks / #{hours_forever} hrs on record' );
var gameStatsTemplate = new Template( "\t<div data-panel=\"{&quot;focusable&quot;:true,&quot;clickOnActivate&quot;:true}\" class=\"pullup_item\" onclick=\"ShowMenuCumulative( this, 'stats_dropdown_#{appid}', 'right' );\">\n\t\t<div class=\"menu_ico\"><img src=\"https:\/\/community.cloudflare.steamstatic.com\/public\/images\/skin_1\/ico_stats.png\" width=\"16\" height=\"16\" border=\"0\" \/><\/div>\n\t\tView Stats<img src=\"https:\/\/community.cloudflare.steamstatic.com\/public\/images\/header\/btn_arrow_down.png\" border=\"0\" class=\"menuarrow\" \/>\n\t<\/div>\n" );
var gamePersonalDataTemplate = new Template( "<div data-panel=\"{&quot;focusable&quot;:true,&quot;clickOnActivate&quot;:true}\" class=\"pullup_item\" onclick=\"ShowMenuCumulative( this, 'gcpd_dropdown_#{appid}', 'right' );\">\n\t<div class=\"menu_ico\"><img src=\"https:\/\/community.cloudflare.steamstatic.com\/public\/images\/skin_1\/ico_stats.png\" width=\"16\" height=\"16\" border=\"0\" \/><\/div>\nPersonal Game Data<img src=\"https:\/\/community.cloudflare.steamstatic.com\/public\/images\/header\/btn_arrow_down.png\" border=\"0\" class=\"menuarrow\" \/>\n<\/div>\n" );
var gameLinksPopupTemplate = new Template( "\t<div class=\"shadow_ul\"><\/div><div class=\"shadow_top\"><\/div><div class=\"shadow_ur\"><\/div><div class=\"shadow_left\"><\/div><div class=\"shadow_right\"><\/div><div class=\"shadow_bl\"><\/div><div class=\"shadow_bottom\"><\/div><div class=\"shadow_br\"><\/div>\t<div class=\"popup_body2 popup_menu2 shadow_content\">\n\t\t<a class=\"popup_menu_item2 tight\" href=\"https:\/\/store.steampowered.com\/app\/#{appid}\">\n\t\t\t<h5>Visit the Store Page<\/h5>\n\t\t<\/a>\n\t\t\t\t<a class=\"popup_menu_item2 tight\" href=\"https:\/\/store.steampowered.com\/forum\/#{appid}\">\n\t\t\t<h5>Visit the Forums<\/h5>\n\t\t<\/a>\n\t\t<a class=\"popup_menu_item2 tight\" href=\"https:\/\/steamcommunity.com\/search\/groups\/?text=#{name_encoded}\">\n\t\t\t<h5>Find Community Groups<\/h5>\n\t\t<\/a>\n\t\t<a class=\"popup_menu_item2 tight\" href=\"https:\/\/store.steampowered.com\/appofficialsite\/#{appid}\">\n\t\t\t<h5>Visit official website<\/h5>\n\t\t<\/a>\n\t\t<a class=\"popup_menu_item2 tight\" href=\"https:\/\/store.steampowered.com\/news\/?appids=#{appid}\">\n\t\t\t<h5>Read related news<\/h5>\n\t\t<\/a>\n\t\t\t<\/div>\n" );
var gameStatsPopupTemplate = new Template( "\t<div class=\"shadow_ul\"><\/div><div class=\"shadow_top\"><\/div><div class=\"shadow_ur\"><\/div><div class=\"shadow_left\"><\/div><div class=\"shadow_right\"><\/div><div class=\"shadow_bl\"><\/div><div class=\"shadow_bottom\"><\/div><div class=\"shadow_br\"><\/div>\t<div class=\"popup_body2 popup_menu2 shadow_content\">\n\t#{stats_links}\n\t<\/div>\n" );
var gamePersonalDataPopupTemplate = new Template( "<div class=\"shadow_ul\"><\/div><div class=\"shadow_top\"><\/div><div class=\"shadow_ur\"><\/div><div class=\"shadow_left\"><\/div><div class=\"shadow_right\"><\/div><div class=\"shadow_bl\"><\/div><div class=\"shadow_bottom\"><\/div><div class=\"shadow_br\"><\/div><div class=\"popup_body2 popup_menu2 shadow_content\">\n#{gcpd_links}\n<\/div>\n" );
var gameAchievementBlockTemplate = new Template( "<div class=\"recentAchievements\">\n\t#{ach_completed} of #{ach_total} achievements earned<br \/>\n\t<img src=\"https:\/\/community.cloudflare.steamstatic.com\/public\/images\/skin_1\/achieveBarLeft.gif\" width=\"2\" height=\"12\" border=\"0\" \/><img src=\"https:\/\/community.cloudflare.steamstatic.com\/public\/images\/skin_1\/achieveBarFull.gif\" width=\"#{ach_bar_width}\" height=\"12\" border=\"0\" \/><img src=\"https:\/\/community.cloudflare.steamstatic.com\/public\/images\/skin_1\/achieveBarEmpty.gif\" width=#{ach_bar_width_remainder}\" height=\"12\" border=\"0\" \/><img src=\"https:\/\/community.cloudflare.steamstatic.com\/public\/images\/skin_1\/achieveBarRight.gif\" width=\"2\" height=\"12\" border=\"0\" \/><br \/>\n\t#{achievements}\n<\/div>\n" );
var gameClientBlockTemplate = new Template( "<div class=\"clientConnItemBlock\">\n\t<div class=\"clientConnItemTextBlock\">\n\t\t<p class=\"clientConnItemText #{text_color}\">#{status}<\/p>\n\t\t<p class=\"clientConnItemText #{text_color}\">#{localContentSize}<\/p>\n\t<\/div>\n\t#{action_icon}\n<\/div>\n" );
var gameStatsAchievementsTemplate = new Template( '<a class="popup_menu_item2 tight" href="#{profile_link}/stats/#{friendlyURL}/?tab=achievements"><h5>#{persona_name}&#039;s Achievements</h5></a>' );
var gameStatsUserTemplate = new Template( '<a class="popup_menu_item2 tight" href="#{profile_link}/stats/#{friendlyURL}/?tab=stats"><h5>#{persona_name}&#039;s Stats</h5></a>');
var gamePersonalDataUserTemplate = new Template( '<a class="popup_menu_item2 tight" href="#{profile_link}/gcpd/#{appid}/"><h5>#{persona_name}&#039;s Personal Game Data</h5></a>');
var gameStatsLeaderboardTemplate = new Template( '<a class="popup_menu_item2 tight" href="#{profile_link}/stats/#{friendlyURL}/?tab=leaderboards"><h5>#{persona_name}&#039;s Leaderboards</h5></a>' );
var gameStatsGlobalAchievementsTemplate = new Template( '<a class="popup_menu_item2 tight" href="https://steamcommunity.com/stats/#{friendlyURL}/achievements/"><h5>Global Achievements</h5></a>' );
var gameStatsGlobalLeaderboardsTemplate = new Template( '<a class="popup_menu_item2 tight" href="https://steamcommunity.com/stats/#{friendlyURL}/leaderboards/"><h5>Global Leaderboards</h5></a>' );
var gameAchievementItemTemplate = new Template( '<img class="recentAchievementsImg" style="position:relative;" onmouseover="AchievementHover( this, event, $(\'global_hover\') )" onmouseout="HideAchievementHover( this, event, $(\'global_hover\') )" width="32" height="32" border="0" src="#{icon_closed}" data-ach-name="#{ach_name}" data-ach-description="#{ach_description}">');
var gameInfoBarTextTemplate = new Template( '#{items_start} - #{items_end} of #{items_total} items' );
var gameReviewButtonTemplate = new Template( "<a class=\"pullup_item\" href=\"https:\/\/store.steampowered.com\/recommended\/recommendgame\/#{appid}\">\n    <div class=\"menu_ico\">\n    <img src=\"https:\/\/community.cloudflare.steamstatic.com\/public\/images\/skin_1\/icon_rate.png\" width=\"16\" height=\"16\" border=\"0\" \/>\n<\/div>\nReview<\/a>\n" );

function BuildGameRow( gameInfo, bViewingOwnProfile )
{
	var bSteamChina = false;

	gameInfo['name_encoded'] = encodeURIComponent( gameInfo['name'] );
	gameInfo['name_escaped'] = gameInfo['name'].escapeHTML();	//prototype
	gameInfo['persona_name'] = personaName;
	gameInfo['profile_link'] = profileLink;
	gameInfo['link'] = ( "https://steamcommunity.com/app/" + gameInfo['appid'] );

	// Achievement block, if present.
	if( gameInfo['ach_completion'] && gameInfo['ach_completion']['closed'] > 0 )
	{
		gameInfo['ach_completed'] = gameInfo['ach_completion']['closed'];
		gameInfo['ach_total'] = gameInfo['ach_completion']['total'];
		gameInfo['ach_bar_width'] = 185 * ( gameInfo['ach_completed'] / gameInfo['ach_total'] );
		gameInfo['ach_bar_width_remainder'] = 185 - gameInfo['ach_bar_width'];

		var achievements = '';

		gameInfo['ach_completion']['recent_achievements'].each(function( achievement, index ) {
			achievements += gameAchievementItemTemplate.evaluate( achievement );
		});
		gameInfo['achievements'] = achievements;
		gameInfo['achievement_block'] = gameAchievementBlockTemplate.evaluate( gameInfo );
	}

    if ( gameInfo['client_summary'] )
    {
		UpdateGameInfoFromSummary( gameInfo, gameInfo['client_summary'] );
    }

	// Handle stats links
	var statsLinks = '';

	// Handle profile-own game specific data
	var gcpdLinks = '';

	if( gameInfo['availStatLinks'] )
	{
		if( gameInfo['availStatLinks']['achievements'] )
			statsLinks += gameStatsAchievementsTemplate.evaluate( gameInfo );

		if( gameInfo['availStatLinks']['stats'] )
			statsLinks += gameStatsUserTemplate.evaluate( gameInfo );

		if( gameInfo['availStatLinks']['gcpd'] && bViewingOwnProfile )
			gcpdLinks += gamePersonalDataUserTemplate.evaluate(gameInfo);

		if( gameInfo['availStatLinks']['leaderboards'] )
			statsLinks += gameStatsLeaderboardTemplate.evaluate( gameInfo );

		if( gameInfo['availStatLinks']['global_achievements'] )
			statsLinks += gameStatsGlobalAchievementsTemplate.evaluate( gameInfo );

		if( gameInfo['availStatLinks']['global_leaderboards'] )
			statsLinks += gameStatsGlobalLeaderboardsTemplate.evaluate( gameInfo );

		if( tab == 'recent' || tab == 'all' || tab == 'followed' )
		{
			if( tab == 'recent' && gameInfo['hours'] && gameInfo['hours_forever'] && gameInfo['hours'] != '0.0' )
			{
				gameInfo['hours_message'] = gameHoursRecentTemplate.evaluate( gameInfo );
			}
			else if( gameInfo['hours_forever'] )
			{
				gameInfo['hours_message'] = gameHoursForeverTemplate.evaluate( gameInfo );
			}
		}
	}

	if ( bViewingOwnProfile )
	{
		gameInfo['review_button'] = gameReviewButtonTemplate.evaluate(gameInfo);
	}

	var linkspopup = gameLinksPopupTemplate.evaluate( gameInfo );

	var div = new Element('div', {'class': 'popup_block2', id: 'links_dropdown_' + gameInfo['appid'] } );
	div.innerHTML = linkspopup;
	div.hide();
	$(document.body).appendChild(div);

	if ( statsLinks )

	{
		gameInfo['stats_links'] = statsLinks;
		gameInfo['stats_button'] = gameStatsTemplate.evaluate(gameInfo);

		var e = new Element('div', {'class': "popup_block2", 'id': "stats_dropdown_" + gameInfo['appid']  } );
		e.update( gameStatsPopupTemplate.evaluate( gameInfo ) );
		e.hide();
		$(document.body).appendChild(e);
	}

	if ( !bSteamChina && gcpdLinks )
	{
		gameInfo['gcpd_links'] = gcpdLinks;
		gameInfo['gcpd_button'] = gamePersonalDataTemplate.evaluate(gameInfo);

		var e = new Element('div', {'class': "popup_block2", 'id': "gcpd_dropdown_" + gameInfo['appid']} );
		e.update( gamePersonalDataPopupTemplate.evaluate( gameInfo ) );
		e.hide();
		$(document.body).appendChild(e);
	}

	gameInfo['logo_class'] = '';
	if ( gameInfo['content_descriptorids'] )
	{
		var overlappingContentDescriptorIDs = gameInfo['content_descriptorids'].filter( function ( n )
		{
			return g_ContentDescriptorPreferences.indexOf( n ) !== -1;
		} );
		if ( overlappingContentDescriptorIDs.length != 0 )
		{
			gameInfo['logo_class'] = 'app_has_adult_content';
		}
	}
	
	var html = gameTemplate.evaluate( gameInfo );

	var div = new Element('div', {'class': 'gameListRow', id: 'game_' + gameInfo['appid'] } );
	div.setAttribute( "data-panel","{\"type\":\"PanelGroup\"}" );
	if ( gameInfo.item_background )
		div.addClassName( gameInfo.item_background );

	div.innerHTML = html;
	$('games_list_rows').appendChild(div);

	var strDelayGroup = 'game_logo_' + gameInfo['appid'];
	g_rgDelayedLoadImages[strDelayGroup] = [ gameInfo['logo'] ];
	LoadImageGroupOnScroll( 'game_' + gameInfo['appid'], strDelayGroup );
}

function BuildChangingGameRow( gameInfo )
{
	gameInfo['name_escaped'] = gameInfo['name'].escapeHTML();
	gameInfo['link'] = ( "https://steamcommunity.com/app/" + gameInfo['appid'] );
	gameInfo['communityLink'] = "https://steamcommunity.com/app/" + gameInfo['appid'];
    gameInfo['hours_message'] = gameHoursForeverTemplate.evaluate( gameInfo );

    var html = changingGameTemplate.evaluate( gameInfo );
    var div = new Element('div', {'class': 'changingGameListRow' });
    div.innerHTML = html;
    $('clientConnChangingGames').appendChild(div);
}

function GetClientActionIcon( summary, appid )
{
	var actionIcon;
	var actionApi;
	var actionParams = { 'sessionid': sessionID, 'appid': appid };
    var actionIconOnClick = '';
    var clickSuccFunc = 'RequestChangingGames()';
    var wrapSuccFunc;

    if (summary['state'] == 'uninstalled')
    {
		actionIcon = 'InstallDefault';
		actionApi = 'install';
		// We delay a bit before fetching state to give
		// the install time to start and be reflected
		// in the client state.  We also force extra
        // queries to occur in case the install takes a
        // long time to start.
		clickSuccFunc = 'DelayRequestChangingGames(1000, 10)';
    }
    else if (summary['state'] == 'installed')
	{
		if (offerClientUninstall)
		{
			actionIcon = 'Uninstall';
			actionApi = 'uninstall';
			// Uninstall is more of an atomic action that doesn't have a lot of
			// intermediate status updates so just wait a while and then refresh.
			clickSuccFunc = 'DelayRefreshPage(3000)';
			wrapSuccFunc = 'ShowConfirmPopup(event, this.parentNode.parentNode, function () { ';
		}
	}
	else if (summary['state'] == 'downloading')
	{
		actionIcon = 'InstallPause';
		actionApi = 'pause';
	}
	else if (summary['state'] == 'paused')
	{
		actionIcon = 'InstallResume';
		actionApi = 'resume';
	}
	else if (summary['state'] == 'no_space')
	{
		actionIcon = 'InstallUnavailable';
	}
	else if (summary['state'] == 'invalid_platform' || summary['state'] == 'no_remote')
	{
	}
	if (actionIcon)
	{
		actionIcon = 'https://community.cloudflare.steamstatic.com/public/images/remote/Icon_Remote' + actionIcon + '.png';
		actionParams['operation'] = actionApi;

		if (actionApi)
		{
			onClickFunc = 'DoXmlRequest(event, \'https://steamcommunity.com/remoteactions/modifyappstate\', \'' +
				$H(actionParams).toQueryString() + '\', function () { ' + clickSuccFunc + '; }, ShowClientError);';
			if (wrapSuccFunc)
			{
				actionIconOnClick = ' onClick="DimButton(this, event, function() { ' + wrapSuccFunc + onClickFunc + ' } ); } );"';
			}
			else
			{
				actionIconOnClick = ' onClick="DimButton(this, event, function() { ' + onClickFunc + ' } );"';
			}
		}

		return '<div class="clientConnItemIcon ' + actionApi + '" style="background-image: url(' + actionIcon + ');"' + actionIconOnClick + '></div>';
	}

	return '';
}

function UpdateGameInfoFromSummary( gameInfo, summary )
{
	// Uninstalled apps don't have their state set to save data for a common case.
	// Recreate it here.
	if ( !summary['state'] )
	{
		summary['state'] = 'uninstalled';
		summary['status'] = 'Not installed';
	}

	gameInfo['text_color'] = '';
	gameInfo['item_background'] = '';

	if ( summary['state'] == 'uninstalled' )
	{
        // Apps which have finished uninstalling recently are still colored
        // active since it's likely the user wants to know when the
        // uninstall completed.
        if ( summary.hasOwnProperty( 'changing' ) )
        {
            gameInfo['item_background'] = 'gameListItemActive';
        }
        else
		{
            gameInfo['item_background'] = '';
        }
		gameInfo['text_color'] = 'color_uninstalled';
	}
	else if ( summary['state'] == 'invalid_platform' || summary['state'] == 'no_remote' )
	{
		gameInfo['text_color'] = 'color_disabled';
	}
	else if ( summary['state'] == 'downloading' || summary['state'] == 'paused' )
	{
		gameInfo['item_background'] = 'gameListItemActive';
	}
	else if ( summary['state'] == 'installed')
	{
		// Apps which have finished installing recently are still colored
		// active since it's likely the user wants to know when the
		// install completed.
		if ( summary.hasOwnProperty( 'changing' ) )
		{
			gameInfo['item_background'] = 'gameListItemActive';
		}
		else
		{
			gameInfo['item_background'] = 'gameListItemInstalled';
		}
	}

	gameInfo['status'] = summary['status'];
	gameInfo['localContentSize'] = summary['localContentSize'];

	gameInfo['action_icon'] = GetClientActionIcon( summary, gameInfo['appid'] );

	gameInfo['client_block'] = gameClientBlockTemplate.evaluate( gameInfo );
}

function IsGameActive( div )
{
	var divItem = div.down('.gameListRowItem');
	if ( divItem && divItem.hasClassName('gameListItemActive') )
	{
		return true;
	}

	return false;
}

function InsertActiveGameRow( div, divName )
{
	var allRows = $('games_list_rows');

	var nextChild = allRows.firstDescendant();
	if (!nextChild)
	{
		allRows.appendChild(div);
		return;
	}

	var nameLower = divName.toLowerCase();

	while (IsGameActive(nextChild))
	{
		var childName = nextChild.down('.gameListRowItemName').innerHTML.toLowerCase();
		if (childName >= nameLower)
		{
			break;
		}

		nextChild = nextChild.next();
	}

	allRows.insertBefore(div, nextChild);
}

function UpdateGameRow( gameInfo, summary )
{
    UpdateGameInfoFromSummary( gameInfo, summary );

	var div = $('game_' + gameInfo['appid']);
	var wasActive = IsGameActive(div);

	var html = gameTemplate.evaluate( gameInfo );
	div.update(html);

	// If an item has just become active we pin it to the top of the list.
    // We also reset the scroll and clear any active filter so that the user can see the
    // newly placed item.
	if ( !wasActive && IsGameActive(div) )
	{
		div.remove();
        $('gameFilter').value = '';
        filterApps();
        InsertActiveGameRow(div, gameInfo['name']);
        // The activation we were waiting for has arrived.
        ActivationRetries = 0;
	}
}


function UpdateChangingGames( updates )
{
	if ( !updates.hasOwnProperty( 'summaries' ) )
	{
		return;
	}

	var summaries = updates['summaries'];

    rgGames.each(function(game, index) {
        if ( summaries.hasOwnProperty( game['appid'] ) )
        {
            UpdateGameRow( game, summaries[game['appid']] );
        }
    });
}

function RequestChangingGames()
{
	// We aren't actually requesting XML but the xml=1 suppresses the
	// timing information that is appended to pages and which would
	// mess up our HTML block that we're substituting in.
	new Ajax.Updater({ success: 'clientConnBlock' }, profileLink + '/getchanging', {
		parameters: 'xml=1',
		evalScripts: true
		});
}

function DelayRequestChangingGames( delay, retries )
{
	if ( delay === undefined )
	{
		delay = 1000;
	}
    if ( retries !== undefined )
    {
        ActivationRetries = retries;
    }

	window.setTimeout( RequestChangingGames, delay );
}

function CheckRequestChangingGames()
{
    if (ActivationRetries < 1)
    {
        return;
    }

    ActivationRetries--;
    DelayRequestChangingGames(1000);
}

function RefreshPage()
{
	location.reload(true);
}

function DelayRefreshPage( delay )
{
    if ( delay === undefined )
    {
        delay = 5000;
    }

    window.setTimeout( RefreshPage, delay );
}

function ShowClientError( jqXHR, textStatus, errorThrown )
{
    RestoreDimButtons();

    var errorElt = document.getElementById( 'clientError' );
    if ( !errorElt || errorElt.style.display !== 'none' )
    {
        return;
    }

    errorElt.style.display = 'block';
}

function ConfirmCancel( event )
{
    RestoreDimButtons();
    ToggleElementHidden('uninstallConfirm', 'block', event);
}

function ShowConfirmPopup( event, targetElt, onClick )
{
    if ( event )
    {
        if ( event.stopPropagation )
        {
            event.stopPropagation();
        }
        event.cancelBubble = true;
    }

    var confirmElt = document.getElementById( 'uninstallConfirm' );
    if ( !confirmElt )
    {
        RestoreDimButtons();
        return;
    }

    confirmElt.setStyle({display: 'block'});
	confirmElt.clonePosition($(targetElt));

    var yesElt = document.getElementById( 'uninstallConfirmYes' );
    if (yesElt)
    {
        yesElt.onclick = function () { ToggleElementHidden( 'uninstallConfirm', 'block' ); onClick(); };
    }
}

function DoXmlRequest( event, subURL, postData, succFunc, errorFunc )
{
    if ( event.stopPropagation )
    {
        event.stopPropagation();
    }
    event.cancelBubble = true;

    new Ajax.Request(subURL, {
        method: 'post',
        parameters: postData,
        onSuccess: function( xhr )
        {
			var data = xhr.responseJSON;
            var success = false;
            if ( data && 'success' in data )
            {
                success = data.success;
                if ( success && succFunc )
                {
                    succFunc( );
                }
            }
        },
        onFailure: function( xhr, data )
        {
            if ( errorFunc )
            {
                errorFunc( xhr );
            }
        },
    });
}

function ToggleElementHidden( element, showType, event, iconElement, iconShowUrl, iconHideUrl )
{
    if ( event )
    {
        if ( event.stopPropagation )
        {
            event.stopPropagation();
        }
        event.cancelBubble = true;
    }

    var elt = document.getElementById( element );
    if ( elt )
    {
        var icon;

        if ( iconElement )
        {
            icon = document.getElementById( iconElement );
        }

        if ( elt.style.display == 'none' )
        {
            elt.style.display = showType;
            if ( icon )
            {
                icon.src = iconShowUrl;
            }
        }
        else
        {
            elt.style.display = 'none';
            if ( icon )
            {
                icon.src = iconHideUrl;
            }
        }
    }
}

function RestoreDimButtons()
{
    for (var i = 0; i < DimButtonList.length; i++)
    {
        $(DimButtonList[i]).setOpacity(1);
    }
    DimButtonList = [];
}

function DimButton( button, event, afterFunc )
{
    if ( event )
    {
        if ( event.stopPropagation )
        {
            event.stopPropagation();
        }
        event.cancelBubble = true;
    }

    // If the button has already been clicked we ignore another click.
    if ($(button).getOpacity() < 0.95)
    {
        return;
    }

    if ( DimButtonList.indexOf(button) < 0 )
    {
        DimButtonList.push(button);
    }

    $(button).setOpacity(0.25);
    afterFunc.call(button);
}

