# Algorithms in Rust

[![Codacy Badge](https://api.codacy.com/project/badge/Grade/27703a0a0f0b44efa7d3e2586ef63f84)](https://www.codacy.com/app/StardustDL/Algorithms-in-Rust?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=StardustDL/Algorithms-in-Rust&amp;utm_campaign=Badge_Grade)
[![](https://img.shields.io/librariesio/github/StardustDL/Algorithms-in-Rust.svg)](https://libraries.io/github/StardustDL/Algorithms-in-Rust)
[![Average time to resolve an issue](http://isitmaintained.com/badge/resolution/StardustDL/Algorithms-in-Rust.svg)](http://isitmaintained.com/project/StardustDL/Algorithms-in-Rust "Average time to resolve an issue")
[![Percentage of issues still open](http://isitmaintained.com/badge/open/StardustDL/Algorithms-in-Rust.svg)](http://isitmaintained.com/project/StardustDL/Algorithms-in-Rust "Percentage of issues still open")
![](https://img.shields.io/github/license/StardustDL/Algorithms-in-Rust.svg)

A collection of some algorithms and data-structures.

- See [Change log](./docs/CHANGELOG.md)

|Item|Status|
|-|-|
|Build|[![](https://img.shields.io/travis/StardustDL/Algorithms-in-Rust.svg?style=flat-square)](https://travis-ci.org/StardustDL/Algorithms-in-Rust)|
|Test|[![](https://img.shields.io/codecov/c/gh/StardustDL/Algorithms-in-Rust.svg?style=flat-square)](https://codecov.io/gh/StardustDL/Algorithms-in-Rust)|
|Crate|[![](https://img.shields.io/crates/v/rsalgo.svg?style=flat-square)](https://crates.io/crates/rsalgo) [![](https://img.shields.io/crates/v/rsalgo.svg?style=flat-square&label=docs&&colorA=blue)](https://docs.rs/rsalgo/) ![](https://img.shields.io/crates/d/rsalgo.svg?style=flat-square)|

## Algorithms

- [x] Discretization
- [x] Dichotomy
  - [x] Lower bound
  - [x] Upper bound
  - [x] Equal range
- [x] Inversion pairs
- [x] Next subset
- [ ] Matrix
- [ ] Number theory
  - [x] Quick pow, quick multiply
  - [x] Prime factor decompose
  - [x] Prime test
    - [x] Trial O(sqrt)
    - [x] Miller-Rabin
  - [x] GCD, LCM
    - [x] Euclid's algorithm
    - [x] Stein's algorithm
    - [x] Extended Euclid's algorithm
  - [x] Inverse element (Modal meaning)
  - [x] Euler phi function
- [ ] Linear sieve
- [x] Trichotomy
- [ ] Tree diameter

## Data-structures

- [x] Disjoint set
- [x] Monotonic queue
- [x] Sparse Table
- [ ] Prefix sum
  - [x] 1D
  - [ ] 2D
- [x] Fenwick tree
- [ ] Segment tree
- [ ] Leftist heap
- [ ] Trie
- [ ] String hash
- [ ] Shortest path
  - [ ] Single source
  - [ ] Multi source
- [x] Topological sorting
- [ ] DFS order
- [x] Minimum spanning tree

## Development

```sh
$ cargo test
```
