module Spina
  class Image < ApplicationRecord
    include Attachable
    
    belongs_to :media_folder, optional: true

    scope :sorted, -> { order("created_at DESC") }

    def variant(options)
      return "" unless file.attached?
      return file if file.content_type.include?("svg")
      return file unless file.variable?

      file.variant(options)
    end

    def content
      self
    end

    def thumbnail(size = "100x100", modifier = "^")
      variant(
        combine_options: {
          gravity: "center",
          thumbnail: "#{size}#{modifier}",
          extent: size
        }
      )
    end
  end
end
