# Contributing to Spina

First of all, you're awesome! Thanks for taking the time to contribute to `Spina`.

There's a bunch of ways to help, and we welcome any and all of them:

1. Opening issues
2. Commenting on open issues
3. Sending PRs
4. Testing PRs
5. Writing tests
6. Writing documentation

We always welcome code contributions, be it fixing an issue or adding new features.

The general workflow follows these steps:

- Open an issue / Find an issue / Suggest a feature via our GitHub Issues page
- Discuss the issue/feature with our team of developers and community members
- Take ownership of the issue/feature
- Fork the project
- Create a feature branch and begin work
- Sync your work with the main branch from time to time
- Open PR and iterate
- Accepted and Merged!

In shell commands, that will look something like:

```sh
# Fork the repository
$ git clone https://github.com/your_username/Spina.git
$ cd Spina
$ git checkout -b feature/feature_name
# Code
# Run tests
$ git add .
$ git commit -m "Adding posts support."
$ git push
# Open PR from your feature branch to main
```

Thank you.


## Financial contributions

We also welcome financial contributions in full transparency on our [open collective](https://opencollective.com/Spina).
Anyone can file an expense. If the expense makes sense for the development of the community, it will be "merged" in the ledger of our open collective by the core contributors and the person who filed the expense will be reimbursed.


## Credits


### Contributors

Thank you to all the people who have already contributed to Spina!
<a href="graphs/contributors"><img src="https://opencollective.com/Spina/contributors.svg?width=890" /></a>


### Backers

Thank you to all our backers! [[Become a backer](https://opencollective.com/Spina#backer)]

<a href="https://opencollective.com/Spina#backers" target="_blank"><img src="https://opencollective.com/Spina/backers.svg?width=890"></a>


### Sponsors

Thank you to all our sponsors! (please ask your company to also support this open source project by [becoming a sponsor](https://opencollective.com/Spina#sponsor))

<a href="https://opencollective.com/Spina/sponsor/0/website" target="_blank"><img src="https://opencollective.com/Spina/sponsor/0/avatar.svg"></a>
<a href="https://opencollective.com/Spina/sponsor/1/website" target="_blank"><img src="https://opencollective.com/Spina/sponsor/1/avatar.svg"></a>
<a href="https://opencollective.com/Spina/sponsor/2/website" target="_blank"><img src="https://opencollective.com/Spina/sponsor/2/avatar.svg"></a>
<a href="https://opencollective.com/Spina/sponsor/3/website" target="_blank"><img src="https://opencollective.com/Spina/sponsor/3/avatar.svg"></a>
<a href="https://opencollective.com/Spina/sponsor/4/website" target="_blank"><img src="https://opencollective.com/Spina/sponsor/4/avatar.svg"></a>
<a href="https://opencollective.com/Spina/sponsor/5/website" target="_blank"><img src="https://opencollective.com/Spina/sponsor/5/avatar.svg"></a>
<a href="https://opencollective.com/Spina/sponsor/6/website" target="_blank"><img src="https://opencollective.com/Spina/sponsor/6/avatar.svg"></a>
<a href="https://opencollective.com/Spina/sponsor/7/website" target="_blank"><img src="https://opencollective.com/Spina/sponsor/7/avatar.svg"></a>
<a href="https://opencollective.com/Spina/sponsor/8/website" target="_blank"><img src="https://opencollective.com/Spina/sponsor/8/avatar.svg"></a>
<a href="https://opencollective.com/Spina/sponsor/9/website" target="_blank"><img src="https://opencollective.com/Spina/sponsor/9/avatar.svg"></a>