/**
 * Usage: 驱动操作方法，用于IDE的智能提示
 * Author: Spikef < Spikef@Foxmail.com >
 * Copyright: Envirs Team < http://envirs.com >
 */

var obj = new ActiveXObject('Scripting.FileSystemObject');

var drive = function(path) {
    var d = obj.GetDrive(path);

    return {
        // Properties
        AvailableSpace: d.AvailableSpace,   // 向用户返回在指定的驱动器或网络共享驱动器上的可用空间容量。
        DriveLetter: d.DriveLetter,	        // 返回识别本地驱动器或网络共享驱动器的大写字母。
        DriveType: d.DriveType,	            // 返回指定驱动器的类型。
        FileSystem: d.FileSystem,	        // 返回指定驱动器所使用的文件系统类型。
        FreeSpace: d.FreeSpace,	            // 向用户返回在指定的驱动器或网络共享驱动器上的剩余空间容量。
        IsReady: d.IsReady, 	            // 如果指定驱动器已就绪，则返回 true。否则返回 false。
        Path: d.Path,	                    // 返回其后有一个冒号的大写字母，用来指示指定驱动器的路径名。
        RootFolder: d.RootFolder,	        // 返回一个文件夹对象，该文件夹代表指定驱动器的根文件夹。
        SerialNumber: d.SerialNumber,	    // 返回指定驱动器的序列号。
        ShareName: d.ShareName, 	        // 返回指定驱动器的网络共享名。
        TotalSize: d.TotalSize, 	        // 返回指定的驱动器或网络共享驱动器的总容量
        VolumeName: d.VolumeName    	    // 设置或者返回指定驱动器的卷标名
    }
}

module.exports = drive;