# 提瓦特大陆内的语言

## 目录

- [提瓦特大陆内的语言](#提瓦特大陆内的语言)
  - [目录](#目录)
  - [前言](#前言)
  - [蒙德 (Mondstadt)](#蒙德-mondstadt)
  - [璃月 (Líyuè)](#璃月-líyuè)
  - [稻妻（稲妻 / いなづま / Inazuma）](#稻妻稲妻--いなづま--inazuma)
    - [鹤观（鶴観 / つるみ / Tsurumi）](#鹤观鶴観--つるみ--tsurumi)
    - [白夜国](#白夜国)
  - [须弥（𒋗𒈨𒊒 / Šumeru）](#须弥𒋗𒈨𒊒--šumeru)
  - [赤王（𓋔 / dšrt / Deshret）](#赤王𓋔--dšrt--deshret)
  - [坎瑞亚 (Caenrium / Khaenri'ah)](#坎瑞亚-caenrium--khaenriah)
    - [深渊法师](#深渊法师)
    - [丘丘人](#丘丘人)

## 前言

《原神》是一个开放世界玩法的游戏，其中有七个不同的国度，每个国家都有不同的文化背景，使用着不同的语言，而破译这些语言则成了部分硬核玩家津津乐道的事情。由于制作一门语言需要的精力非常多，因此绝大部分的文字都是通过如同**凯撒密码般的字母替换**完成的，而语言本身则是借用现实世界中的语言。

旅行者在提瓦特是一个异乡人，因此一开始是不会说任何国度的语言的，但是旅行者遇到了会说家乡话的派蒙，而她则教了旅行者怎么说提瓦特的语言。而在整个游戏过程中，旅行者对除了提瓦特语之外的其他的任何文字都表现出了完全不认识的情况。因此，本文会将会把每个国度出现的语言和文字娓娓道来，希望各位旅行者们能喜欢。

--------------------------------------------------------------------------------
## 蒙德 (Mondstadt)

蒙德这个词在德语里面为两个名词的组合，`Mond`（月亮）和 `Stadt`（城市），原型可看作是西欧的国家。在蒙德，大家都说**通用语**（英语），用**通用文字**书写。在蒙德城内、晨曦酒庄、野外、甚至是游戏的教程界面都可看到这种文字。不仅如此，通用语也在盗宝团和深渊教团之间使用，因此通用语是类似英语一般的国际语言存在。

通用文字包含了 26 个字母（拉丁字母），不区分大小写。其字母形态是通过上下颠倒每个大写的拉丁字母，然后修改了部分笔划，使其整体看起来像**哥特体 (Blackletter)**。另外，通用文字还指定了数字的写法，但是数字目前并没有出现在除了用户界面之外的其他地方。通用文字的单词之间可以选择分词书写，也可以不分。

--------------------------------------------------------------------------------
## 璃月 (Líyuè)

璃月的原型是中国。由于赶工的缘故，璃月文并没有被完整地设计出来，只留下了字形，因此无论是街头还是书本的封面看到的璃月文，都是无意义的随机排列。每一个璃月文字符看起来都如同**方篆**，即形态像正方形的小篆。

正常的璃月文共有 26 个不同的字形，其中的每个字都可以找到原型。另外，在若陀龙王的尾巴形大树下面，可以通过门前上方的两个璃月文单字知晓这周副本的龙王有哪两种元素。这样有意义的文字共有四个，分别是`水`、`雷`、`火`和`冰`。另外，在烟绯攻击时的粒子效果里可看出`印`这个字，这也对应了烟绯重击的时候是使用印章向下砸。

--------------------------------------------------------------------------------
## 稻妻（稲妻 / いなづま / Inazuma）

稻妻这个词由两个字组成，“稻（いな）”（水稻）和“妻（つま）”（妻子），原型是日本。在稻妻，大家都说**稻妻语**（日语），用**稻妻文字**书写。

稻妻文字包含了 26 个字母（拉丁字母），不区分大小写。其字母形态是将通用文字的笔触改成毛笔得来的，因此，它长得和通用文字非常像。一开始，很多人以为稻妻文字是把每个假名替换了，但是发现字符的个数并没有假名那么多，因此才得出它是把拉丁字母替换了。之后，更加奇怪的是，单词的长度都非常短，所以才明白稻妻文字书写的并不是日语的罗马音，而是每个假名罗马音的首字母，这使破解变得很困难。同时，也出现了把罗马音写全了的情况。

部分稻妻文甚至没法与游戏内的日语文本完全对应，有可能是交给了不同的人进行翻译，但是意思是相同的。

### 鹤观（鶴観 / つるみ / Tsurumi）

这是稻妻最南端的一个岛，岛上的人（鬼魂）的名字都是**阿伊努语**（アイヌ・イタㇰ / Aynu itak）。另外还有一种文字，名为**石根文字**。石根文字是为剧情服务的，并没有被设计成为书写服务，其中只包含了 6 个不同的字符。

--------------------------------------------------------------------------------
### 白夜国

稻妻的海祁岛正下方的古老国度，原型为古希腊，目前只剩下鬼魂（仅能在大日御舆处于常夜模式下才能看见）。白夜国的石碑上有两种文字，第一种是**白夜国文**，另一种是通用文字。白夜国文没有在游戏中出现过。

由于白夜国的居民知道了许多有关这个世界和天空岛的秘密（在游戏中以禁书的形式存在，玩家可以阅读），因此天理将除掉这些居民。为了能够将自己伪装成稻妻人，每个白夜国居民都把自己的白夜国（古希腊）名字通过假名的发音转写后，随意安放了一些读音与其相同的汉字之后，变成了假稻妻名（日语）。

--------------------------------------------------------------------------------
## 须弥（𒋗𒈨𒊒 / Šumeru）

--------------------------------------------------------------------------------
## 赤王（𓋔 / dšrt / Deshret）

赤王所统治的沙漠，可以视作须弥的一部分，原型为（缝合了未来科技的）古埃及。在各种建筑物以及方尖碑上可以看到**赤冠文字**，共有 26 个字母（拉丁字母），其书写的语言为**古埃及语**。这种文字只拼写古埃及语的辅音，并同时使用阅读之母来标记长元音，也出现了不同的音位共用同一种拼写的情况。赤王的名字在古埃及语里意为下埃及。下埃及在现实中位于埃及的北部，接着地中海，有着肥沃的冲积平原。

在主线剧情中，主角与利露帕尔（نیلوفر / nilufar，在波斯语中意为睡莲）分别之际，她在主角耳旁仅仅低语了一阵，主角竟已然学会如何阅读赤冠文字？！看来派蒙教语言的功力远远不如这盏灯啊！埃及语比英语难多了。话说利露帕尔随便讲几句话就能让主角分辨字母的字形，也是有点离谱。

虽然这是表音文字，但是教令院的学者也将这二十六个字母解读出了个不同的意思：

<style>
    @font-face {
        font-family: DeshretNeue;
        src: url("../font/genshin-impact/DeshretNeue-Regular-1.002.otf") format("opentype");
    }
    .deshret-neue { font-family: DeshretNeue, serif; font-size: 1.5rem; }
</style>

|拉丁|赤冠|含义|
|:-:|:-:|:-:|
|A|<div class="deshret-neue">A</div>|谷地|
|B|<div class="deshret-neue">B</div>|鸟首|
|C|<div class="deshret-neue">C</div>|峭崖|
|D|<div class="deshret-neue">D</div>|举臂|
|E|<div class="deshret-neue">E</div>|沙暴|
|F|<div class="deshret-neue">F</div>|?|
|G|<div class="deshret-neue">G</div>|耳郭|
|H|<div class="deshret-neue">H</div>|树木|
|I|<div class="deshret-neue">I</div>|雷霆|
|J|<div class="deshret-neue">J</div>|?|
|K|<div class="deshret-neue">K</div>|危险|
|L|<div class="deshret-neue">L</div>|凿锤|
|M|<div class="deshret-neue">M</div>|日升|
|N|<div class="deshret-neue">N</div>|王权|
|O|<div class="deshret-neue">O</div>|?|
|P|<div class="deshret-neue">P</div>|羊首|
|Q|<div class="deshret-neue">Q</div>|?|
|R|<div class="deshret-neue">R</div>|鳄首|
|S|<div class="deshret-neue">S</div>|巨蛇|
|T|<div class="deshret-neue">T</div>|?|
|U|<div class="deshret-neue">U</div>|巨门|
|V|<div class="deshret-neue">V</div>|祭祀|
|W|<div class="deshret-neue">W</div>|?|
|X|<div class="deshret-neue">X</div>|劳作|
|Y|<div class="deshret-neue">Y</div>|?|
|Z|<div class="deshret-neue">Z</div>|沙丘|

--------------------------------------------------------------------------------
## 坎瑞亚 (Caenrium / Khaenri'ah)

被天理毁灭的国度。目前残留下来的文本都是**坎瑞亚语**（拉丁语），使用**坎瑞亚文字**书写。在龙脊雪山、层岩巨渊和鹤观都可以看到这种文字，其中属层岩巨渊最多。

坎瑞亚文字包含了 26 个字母（拉丁字母），不区分大小写，且书写时分词，还破天荒地包含了逗号、句号、问号和感叹号。每个字母的形态都是从拉丁字母变形得来的，且每个字母都从中间被分成了两半。

在层岩巨渊出现的坎瑞亚文字的上半部分都和其他字母调换了，因此在阅读的时候只需要关注文字的下半部分就好了。这些文字在流明石的照耀下将会消失，阅读时需要小心。因此，在接近这种文字之前，请收起你的流明石灯。

### 深渊法师

虽然深渊法师为坎瑞亚人，但是却由于不知名原因习得了一种在游戏中被称为“失落古语”的语言。其原型为**以诺奇语** (Enochian)，是一个人造语言，由 John Dee 与 Edward Kelley 于 1583 年左右发明，他称之为“天使的语言”或“神圣的语言”。

在凯亚的传说人物中，被迪卢克打倒的深渊法师说了一句 "Gohus, chiso vonph."。意思是“我说他们在发怒。”

### 丘丘人

丘丘人在灾难中被天理变成了怪物，智力也变低了，因此它们没有办法使用坎瑞亚语（拉丁语）进行交流，进而发展出了**丘丘语**。丘丘语是目前游戏中唯一的人造语言。丘丘语是一个孤立语（如同汉语），语序为 SVO（主谓宾），单词的音节最多有三个，以两个音节的居多。

丘丘语没有任何的书面形式，游戏中出现的丘丘语都是以转写的形式呈现的。并且，丘丘语的语音资料非常稀缺。

温迪、凯亚和深渊法师们都会丘丘语。旅行者有可能只会说 Olah, Dada 和 Mosi mita 这三句。