﻿// This is an open source non-commercial project. Dear PVS-Studio, please check it.
// PVS-Studio Static Code Analyzer for C, C++, C#, and Java: https://pvs-studio.com
/*
Copyright 2017-2020 Intel Corporation

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#include <SpecialK/render/present_mon/PresentMon.hpp>
#include <SpecialK/utility/lazy_global.h>
#include <SpecialK/thread.h>

static std::thread gConsumerThread;

void
Consume (TRACEHANDLE traceHandle)
{
  SetCurrentThreadDescription (L"[SK] PresentMon <Consume>");
  SetThreadPriority (GetCurrentThread (), THREAD_PRIORITY_TIME_CRITICAL);

  // You must call OpenTrace() prior to calling this function
  //
  // ProcessTrace() blocks the calling thread until it
  //     1) delivers all events in a trace log file, or
  //     2) the BufferCallback function returns FALSE, or
  //     3) you call CloseTrace(), or
  //     4) the controller stops the trace session.
  //
  // There may be a several second delay before the function returns.
  //
  // ProcessTrace() is supposed to return ERROR_CANCELLED if BufferCallback
  // (EtwThreadsShouldQuit) returns FALSE; and ERROR_SUCCESS if the trace
  // completes (parses the entire ETL, fills the maximum file size, or is
  // explicitly closed).
  //
  // However, it seems to always return ERROR_SUCCESS.

  auto   status = ProcessTrace (&traceHandle, 1, nullptr, nullptr);
  (void) status;

  // Signal MainThread to exit.  This is only needed if we are processing an
  // ETL file and ProcessTrace() returned because the ETL is done, but there
  // is no harm in calling ExitMainThread() if MainThread is already exiting
  // (and caused ProcessTrace() to exit via 2, 3, or 4 above) because the
  // message queue isn't beeing listened too anymore in that case.

  ////extern void StopTraceSession (void);
  ////            StopTraceSession (    );
////ExitMainThread();
}

void
StartConsumerThread (TRACEHANDLE traceHandle)
{
  gConsumerThread =
    std::thread (Consume, traceHandle);
}

void
WaitForConsumerThreadToExit (void)
{
  if (gConsumerThread.joinable ())
      gConsumerThread.join     ();
}
