# Request for contributions

Please contribute to this repository if any of the following is true:
- You have expertise in Arduino/ESP8266 development, WiFi, or C/C++
- You want to help lower the burden to first time contributors
- You want this open source community to be more collaborative and inclusive

# How to contribute

Prerequisites:

- Familiarity with [pull requests](https://help.github.com/articles/using-pull-requests) and [issues](https://guides.github.com/features/issues/).
- Knowledge of [Markdown](https://help.github.com/articles/markdown-basics/) for editing `.md` documents.
- Knowledge of [WiFi Deauth](https://en.wikipedia.org/wiki/Wi-Fi_deauthentication_attack) for understanding the project.

In particular, this community seeks the following types of contributions:

- **Ideas**: participate in an issue thread or start your own to have your voice
heard.
- **Resources**: submit a pull request to add to RESOURCES.md with links to related content.
- **Outline sections**: help us ensure that this repository is comprehensive. if
there is a topic that is overlooked, please add it, even if it is just a stub
in the form of a header and single sentence. Initially, most things fall into
this category.
- **Writing**: contribute your expertise in an area by helping us expand the included
content.
- **Copy editing**: fix typos, clarify language, and generally improve the quality
of the content.
- **Formatting**: help keep content easy to read with consistent formatting.

<a name="bugs"></a>
## Bug reports

A bug is a _demonstrable problem_ that is caused by the code in the repository.
Good bug reports are extremely helpful - thank you!

Guidelines for bug reports:

1. **Use the GitHub issue search** &mdash; check if the issue has already been
   reported.

2. **Check if the issue has been fixed** &mdash; try to reproduce it using the
   latest `master` or development branch in the repository.

3. **Isolate the problem**.

A good bug report shouldn't leave others needing to chase you up for more
information. Please try to be as detailed as possible in your report. What is
your environment? What steps will reproduce the issue? What browser(s) and OS
experience the problem? What would you expect to be the outcome? All these
details will help people to fix any potential bugs.

Example:

> Short and descriptive example bug report title
>
> A summary of the issue and the browser/OS environment in which it occurs. If
> suitable, include the steps required to reproduce the bug.
>
> 1. This is the first step
> 2. This is the second step
> 3. Further steps, etc.
>
> `<url>` - a link to the serial output on pastebin
> `<pic>` - a photo of your build with apparent wiring
>
> Any other information you want to share that is relevant to the issue being
> reported. This might include the lines of code that you have identified as
> causing the bug, and potential solutions (and your opinions on their
> merits).


<a name="features"></a>
## Feature requests

Feature requests are welcome. But take a moment to find out whether your idea
fits with the scope and aims of the project. It's up to *you* to make a strong
case to convince the project's developers of the merits of this feature. Please
provide as much detail and context as possible.


<a name="pull-requests"></a>
## Pull requests

Good pull requests - patches, improvements, new features - are a fantastic
help. They should remain focused in scope and avoid containing unrelated
commits.

**Please ask first** before embarking on any significant pull request (e.g.
implementing features, refactoring code, porting to a different language),
otherwise you risk spending a lot of time working on something that the
project's developers might not want to merge into the project.

Please adhere to the coding conventions used throughout a project (indentation,
accurate comments, etc.) and any other requirements (such as test coverage).
