import {Fragment, useRef, useState} from 'react'
import {Dialog, Transition} from '@headlessui/react'
import {signOut} from 'next-auth/react'
import {useCommonContext} from '@/context/common-context'

export default function LogoutModal({
    logoutModalDesc = '',
    confirmButtonText = '',
    cancelButtonText = '',
    redirectPath = '',
}) {
    const cancelButtonRef = useRef(null)
    const {showLogoutModal, setShowLogoutModal} = useCommonContext()

    const confirmButton = () => {
        signOut({callbackUrl: redirectPath})
    }

    return (
        <Transition.Root
            show={showLogoutModal}
            as={Fragment}>
            <Dialog
                as='div'
                className='relative z-10'
                initialFocus={cancelButtonRef}
                onClose={setShowLogoutModal}>
                <Transition.Child
                    as={Fragment}
                    enter='ease-out duration-300'
                    enterFrom='opacity-0'
                    enterTo='opacity-100'
                    leave='ease-in duration-200'
                    leaveFrom='opacity-100'
                    leaveTo='opacity-0'>
                    <div className='fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity' />
                </Transition.Child>

                <div className='fixed inset-0 z-10 overflow-y-auto'>
                    <div className='flex min-h-full items-end justify-center p-4 text-center sm:items-center sm:p-0'>
                        <Transition.Child
                            as={Fragment}
                            enter='ease-out duration-300'
                            enterFrom='opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95'
                            enterTo='opacity-100 translate-y-0 sm:scale-100'
                            leave='ease-in duration-200'
                            leaveFrom='opacity-100 translate-y-0 sm:scale-100'
                            leaveTo='opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95'>
                            <Dialog.Panel className='relative transform overflow-hidden rounded-lg bg-white px-4 pb-4 pt-5 text-left shadow-xl transition-all sm:my-8 sm:w-full sm:max-w-lg sm:p-6'>
                                <div className='sm:flex sm:items-start'>
                                    <div className='mt-3 text-center sm:ml-4 sm:mt-0 sm:text-left'>
                                        <Dialog.Title
                                            as='h3'
                                            className='text-base font-semibold leading-6 text-gray-900'>
                                            {logoutModalDesc}
                                        </Dialog.Title>
                                    </div>
                                </div>
                                <div className='mt-5 sm:mt-4 sm:flex sm:flex-row-reverse'>
                                    <button
                                        type='button'
                                        className='inline-flex w-full justify-center rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500 sm:ml-3 sm:w-auto'
                                        onClick={() => confirmButton()}>
                                        {confirmButtonText}
                                    </button>
                                    <button
                                        type='button'
                                        className='mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50 sm:mt-0 sm:w-auto'
                                        onClick={() =>
                                            setShowLogoutModal(false)
                                        }
                                        ref={cancelButtonRef}>
                                        {cancelButtonText}
                                    </button>
                                </div>
                            </Dialog.Panel>
                        </Transition.Child>
                    </div>
                </div>
            </Dialog>
        </Transition.Root>
    )
}
