<div align="center">
    <img src="./public/logo.png" alt="SoraFlows">
</div>

# SoraFlows
SoraFlows 是一个面向 OpenAI Sora 的浏览器界面，可以简单地生成, 编辑, 分享 文字/图片->视频。 👉 [SoraWebui](https://www.soraflows.com)

一键部署设计精良的跨平台 Sora 网页界面

<div align="center">
<a href="https://www.producthunt.com/posts/soraflows?utm_source=badge-featured&utm_medium=badge&utm_souce=badge-soraflows" target="_blank"><img src="https://api.producthunt.com/widgets/embed-image/v1/featured.svg?post_id=440901&theme=light" alt="SoraFlows - Open&#0045;source&#0032;AI&#0032;video&#0032;web&#0032;creation&#0032;with&#0032;Sora&#0032;Model | Product Hunt" style="width: 250px; height: 54px;" width="250" height="54" /></a>
<p>欢迎在Product Hunt上关注SoraFlows，欢迎评论和点赞！.</p>

<h4 align="center">
    <p>
        <b>English</b> |
        <a href="https://github.com/SoraFlows/SoraFlows/blob/main/README.zh.md">简体中文</a>
    <p>
</h4>

[![Website](https://img.shields.io/badge/Website-Demo-20B2AA.svg)](https://www.soraflows.com)

![starts](https://img.shields.io/github/stars/SoraFlows/SoraFlows.svg)  ![starts](https://img.shields.io/github/forks/SoraFlows/SoraFlows.svg)

## Quick Started

在 Railway 上部署

[![Deploy on Railway](https://railway.app/button.svg)](https://railway.app/template/39bNf0?referralCode=KRIchJ)

在 Vercel 上部署

[![Deploy with Vercel](https://vercel.com/button)](https://vercel.com/new/clone?s=https%3A%2F%2Fgithub.com%2FSoraflows%2FSoraFlows&hasTrialAvailable=0&showOptionalTeamCreation=false&project-name=SoraFlows&framework=nextjs&totalProjects=1&remainingProjects=1&external-id=https%3A%2F%2Fgithub.com%2FSoraflows%2FSoraFlows%2Ftree%2Fmain&build-command=prisma%20generate%20%26%26%20next%20build)

在 Zeabur 上部署

[![Deploy on Zeabur](https://zeabur.com/button.svg)](https://zeabur.com/templates/L6DZF5)

1. 克隆项目
```shell
git clone git@github.com:SoraFlows/SoraFlows.git
```
1. 安装依赖
```shell
cd SoraFlows && yarn
#or
cd SoraFlows && npm install
#or
cd SoraFlows && pnpm install
```
1. 运行
```shell
yarn dev
#or
npm run dev
#or
pnpm dev
```
1. 打开浏览器 http://localhost:3000 访问

## 交流群

欢迎加入微信交流群，反馈Bug~<br>
<p align="center">
  <img src="./public/wx-group.jpg" alt="Wechat QR Code" width="300"/>
</p>


## Sora

由 OpenAI 推出的 Sora 是一款先进的 AI 模型，能够根据文本指令生成逼真且充满想象力的场景。这款工具具有独特能力，能制作长达 60 秒的复杂视频，视频中包含高度详细的场景、复杂的摄像机运动以及展现广泛情绪的角色。然而，Sora 目前尚未向公众开放。

重要的是要注意，由于 OpenAI 的 Sora 仍处于初期开发阶段，我们计划定期更新我们的精选资源列表，以增强其能力。

我们致力于收集 Sora 的最高质量提示，确保其使用达到最佳效果。

在开发中，我们使用 NextJs 和 Tailwind CSS，这支持我们为 Sora 创建一个高度互动和视觉上吸引人的网络界面。

这个平台充当专为 Sora 设计的在线视频编辑器，为用户提供了一个便捷的网络界面，使他们能够直接通过浏览器创建视频。

访问我们的在线编辑器，请访问：[https://www.soraflows.com](https://www.soraflows.com)。

## Latest News


## Knowledge Base

- [World Model Sora: The Strongest Materials on the Entire Network](https://youmiais.feishu.cn/wiki/Le8qwM1whin6mokJ5NGc0FRDnFd?fromScene=spaceOverview)

- [Technical Report: Bilingual Comparison between Chinese and English](https://youmiais.feishu.cn/wiki/MnDbw81IwiWE15k3yyGcFpaHnRh?fromScene=spaceOverview)

- [Sora OpenAI: The AI Model That Generates Mind-Blowing Videos](https://medium.com/@iamsaro1996/sora-openai-the-ai-model-that-generates-mind-blowing-videos-from-text-8f2ceda8d900) 📖 - Discusses the capabilities of Sora, an AI model from OpenAI that can create impressive videos based on textual prompts, covering various genres and themes.
- [OpenAI Launches AI Text-to-Video Generator Sora - InfoQ](https://www.infoq.com/news/2024/02/openai-sora-video-generator/) 📖 - Provides an overview of Sora, OpenAI's generative AI model for creating photorealistic videos by understanding the real world and seamlessly combining shots without disruptions.
- [OpenAI Sora: One Step Away From The Matrix](https://medium.com/@albertoromgar/openai-sora-one-step-away-from-the-matrix-a751cdf4589c) 📖 - Explores the capabilities of Sora, the best text-to-video AI model, and its impact on bridging the gap between AI and people.
- [Explaining Sora by OpenAI: Spacetime Patches](https://towardsdatascience.com/explaining-openai-soras-spacetime-patches-the-key-ingredient-e14e0703ec5b) 📖 - Dives into how OpenAI's Sora utilizes spacetime patches to revolutionize video generation and set a new standard for AI-driven content.
- [SORA from OpenAI transcends conventional limits](https://medium.com/@adeshbhatt/sora-from-openai-transcends-conventional-limits-b4c7bd175dbc) 📖 - Introduces 'Sora,' OpenAI's cutting-edge AI tool capable of generating lifelike 60-second videos solely from textual input.
- [How Sora (actually) works. There's a lot of disinformation about...](https://medium.com/@mikeyoung_97230/how-sora-actually-works-23da050ef3f2) 📖 - Provides insights into the working principles of Sora, debunking disinformation surrounding this advanced video generation model.
- [SORA: Unbelieve New Text To Video AI Model By OpenAI](https://medium.com/@furkangozukara/sora-unbelieve-new-text-to-video-ai-model-by-openai-37-demo-videos-still-cant-believe-real-a669b101efb7) 📖 - Unveils Sora, an incredible AI model by OpenAI capable of creating realistic and imaginative scenes from text instructions.
- [OpenAI just dropped the biggest bomb on AGI— Sora](https://medium.com/@leoleung-ch/openai-just-dropped-another-bomb-on-agi-sora-000bf5bb27b5) 📖 - Explores the capabilities and significance of Sora, OpenAI's latest development in artificial general intelligence.
- [OpenAI's SORA: HD Text To Video Is Mind Blowing!](https://medium.com/@trendingAI/openais-sora-hd-text-to-video-is-mind-blowing-7d12c87ffbc8) 📖 - Highlights the mind-blowing abilities of Sora, an AI model that turns textual instructions into captivating videos.
- [OpenAI's Sora: A Cinematic Leap in Generative Video Technology](https://medium.com/@zamalbabar/openais-sora-a-cinematic-leap-in-generative-video-technology-323d753a6aa1): Revolutionary generative video model showcases Hollywood-quality clips, marking a significant milestone in the evolution of artificial intelligence.
- [OpenAI SORA: The Next Frontier in AI Innovation](https://medium.com/@mvbnsrinivas/openai-sora-the-next-frontier-in-ai-innovation-55abf9afcfed): Introduction to OpenAI SORA and exploration of its capabilities, applications, and potential impacts on AI technology.
- [Create realistic videos with SORA from OpenAI](https://medium.com/gptcommands/create-realistic-videos-with-sora-from-openai-258b60dd55a5): Exploring how artificial intelligence, specifically OpenAI's SORA model, can redefine visual storytelling and create realistic videos.
- [Advantages and Limitations of OpenAI's Innovative Video Generation Model Sora](https://medium.com/@rsupport/advantages-and-limitations-of-openais-innovative-video-generation-model-sora-3f21a2481748): Highlighting the advantages and revolutionary evolution of OpenAI's text-based video generation model, Sora.
- [Unlocking New Possibilities: Unleashing the Power of Open AI with Sora](https://medium.com/@asaadaliakhunzada/unlocking-new-possibilities-unleashing-the-power-of-open-ai-with-sora-f152b5a973f3): How Sora's open AI platform empowers businesses to bring their ideas to life through educational purposes, product demonstrations, and storytelling.
- [How to use OpenAI Sora?](https://medium.com/@ecommerce_plan/how-to-use-openai-sora-41218d9d6142): An introduction to OpenAI's latest project, Sora, and how it utilizes text prompts to generate mind-blowing videos.
- [OpenAI Unveils Sora: The Future of Text-to-Video Generation](https://dev.to/usulpro/openai-unveils-sora-the-future-of-text-to-video-generation-2om7): Exploring the capabilities of Sora and what makes it stand out in the rapidly progressing field of text-to-video generation.
- [Nvidia Researcher: OpenAI's Sora is Amazing, but not because of the patches](https://medium.com/@tiancaixinxin/nvidia-researcher-view-openais-sora-is-amazing-but-not-because-of-the-patches-3da7ce583b75): Focus on the impressive video generation capabilities of OpenAI's Sora model, particularly its handling of complex lighting and reflections.
- [OpenAI Dominates All: First Video Generation Model, Sora, Rings the Death Knell for the Film](https://medium.com/@lucas_scott/openai-dominates-all-first-video-generation-model-sora-rings-the-death-knell-for-the-film-29eabf529407): Introduction to Sora's ability to generate original and high-quality videos, signaling advancements in artificial general intelligence (AGI).
- [The near supernatural state of gen AI. The Lady in Red. Fascinating](https://medium.com/@paul.k.pallaghy/the-near-supernatural-state-of-gen-ai-61c1e9572e78): A recommendation to check out the impressive OpenAI gen AI video showcasing their new coming-soon AI service, Sora.

## Tools & Software

- [Sora Alternatives: Top 9 AI Video Generators & Similar Websites](https://alternativeto.net/software/sora-1/) ⭐️\
Sora is described as "OpenAI's text-to-video model" and is an AI video generator. This alternative list includes Stable Video Diffusion, Wonder Studio, and Runway ML.
- [What do you think about Sora - OpenAI's new text-to-video app](https://www.producthunt.com/discussions/what-do-you-think-about-sora-openai-s-new-text-to-video-app) 💭\
This Product Hunt discussion invites thoughts on Sora, OpenAI's new text-to-video app and its impact on video producers, software, filmmakers, and the video industry as a whole.
- [Sora OpenAI Video Samples And Guides - Product Information](https://www.producthunt.com/products/sora-openai-video-samples-and-guides) 📚\
Sora OpenAI Video Samples And Guides showcase the capabilities of the best text-to-video AI model on earth.
- [Sora Reviews and Pricing 2024](https://sourceforge.net/software/product/Sora-OpenAI/) 📝\
Read Sora reviews and get pricing information from real users of the AI Video Generators (Text-to-Video) software.
- [OpenAI's latest model takes video generation to the next level](https://www.producthunt.com/stories/openai-s-latest-model-takes-video-generation-to-the-next-level) 🔥\
OpenAI's latest model, Sora, has made advancements in video generation, competing with startups like RunwayML.
- [Sora: AI model that can create realistic and imaginative video](https://alternativeto.net/software/sora-1/about/) 🎥\
Sora is an OpenAI's text-to-video model that can generate visually appealing videos up to a minute long based on user prompts.
- [Sora By OpenAI - Product Information, Latest Updates, and Reviews](https://www.producthunt.com/products/sora-by-openai-2) 🚀\
SORA is an AI model by OpenAI that uses advanced machine learning to generate visually appealing videos from text inputs. It offers dynamic video creation, benefiting video production.
- [Runway vs. Sora Comparison](https://sourceforge.net/software/compare/Runway-ML-vs-Sora-OpenAI/) 📊\
This comparison chart helps compare Runway and Sora in terms of price, features, and reviews to make the best choice.
- [Open AI Sora - Product Information, Latest Updates, and Reviews](https://www.producthunt.com/products/open-ai-sora/launches) ✨\
Open AI Sora is a tool to create stunning videos from text effortlessly. It allows you to transform your ideas into captivating visuals. Visit the link to try Sora for free online.
- [Sora by OpenAI](https://www.producthunt.com/products/sora-by-openai): A pioneering text-to-video model designed to bridge the gap between textual prompts and video generation.
- [OpenAI unveils Sora](https://alternativeto.net/news/2024/2/openai-unveils-sora-a-new-ai-model-for-generating-photorealistic-videos-from-text-prompts/): A new Text-to-Video AI model capable of creating highly realistic video scenes from written prompts.
- [SoraHub](https://www.producthunt.com/all): Explore the newest OpenAI Sora-generated videos and discover the latest tech products and mobile apps.
- [Sora by OpenAI Makers](https://www.producthunt.com/products/sora-by-openai-2/makers): Meet the founders, developers, designers, and product people who worked on Sora By OpenAI.
- [ai sora tech](https://www.producthunt.com/products/ai-sora-tech/launches): Explore the latest OpenAI Sora-crafted video collection at aisoratech.com and effortlessly turn your prompts into videos.

## Contributors
<a href="https://github.com/SoraFlows/SoraFlows/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=SoraFlows/SoraFlows" />
</a>