import { FC, useEffect, useState } from 'react'
import styles from './DiscordBanner.module.css'
import Link from 'next/link'
const { bannerOutside, banner, svg } = styles

const DiscordBanner: FC = () => {
  const svgElement = (
    <svg
      width='24'
      height='24'
      viewBox='0 0 33 32'
      fill='currentColor'
      xmlns='http://www.w3.org/2000/svg'
    >
      <path d='M14.0621 13.8533C13.2943 13.8533 12.6882 14.52 12.6882 15.3333C12.6882 16.1467 13.3078 16.8133 14.0621 16.8133C14.8298 16.8133 15.4359 16.1467 15.4359 15.3333C15.4494 14.52 14.8298 13.8533 14.0621 13.8533ZM18.9784 13.8533C18.2106 13.8533 17.6045 14.52 17.6045 15.3333C17.6045 16.1467 18.2241 16.8133 18.9784 16.8133C19.7461 16.8133 20.3523 16.1467 20.3523 15.3333C20.3523 14.52 19.7461 13.8533 18.9784 13.8533Z'></path>{' '}
      <path d='M25.5245 2.66666H7.47552C5.95348 2.66666 4.71429 3.89332 4.71429 5.41332V23.44C4.71429 24.96 5.95348 26.1867 7.47552 26.1867H22.7498L22.0359 23.72L23.76 25.3067L25.3898 26.8L28.2857 29.3333V5.41332C28.2857 3.89332 27.0465 2.66666 25.5245 2.66666ZM20.3253 20.08C20.3253 20.08 19.8404 19.5067 19.4363 19C21.2008 18.5067 21.8743 17.4133 21.8743 17.4133C21.3221 17.7733 20.7967 18.0267 20.3253 18.2C19.6518 18.48 19.0053 18.6667 18.3723 18.7733C17.0792 19.0133 15.8939 18.9467 14.8837 18.76C14.1159 18.6133 13.4559 18.4 12.9037 18.1867C12.5939 18.0667 12.2572 17.92 11.9204 17.7333C11.88 17.7067 11.8396 17.6933 11.7992 17.6667C11.7723 17.6533 11.7588 17.64 11.7453 17.6267C11.5029 17.4933 11.3682 17.4 11.3682 17.4C11.3682 17.4 12.0147 18.4667 13.7253 18.9733C13.3212 19.48 12.8229 20.08 12.8229 20.08C9.84613 19.9867 8.7147 18.0533 8.7147 18.0533C8.7147 13.76 10.6543 10.28 10.6543 10.28C12.5939 8.83999 14.4392 8.87999 14.4392 8.87999L14.5739 9.03999C12.1494 9.73332 11.0314 10.7867 11.0314 10.7867C11.0314 10.7867 11.3278 10.6267 11.8261 10.4C13.2674 9.77332 14.4123 9.59999 14.8837 9.55999C14.9645 9.54666 15.0318 9.53332 15.1127 9.53332C15.9343 9.42666 16.8637 9.39999 17.8335 9.50666C19.1131 9.65332 20.4869 10.0267 21.8878 10.7867C21.8878 10.7867 20.8237 9.78666 18.5339 9.09332L18.7225 8.87999C18.7225 8.87999 20.5678 8.83999 22.5074 10.28C22.5074 10.28 24.4469 13.76 24.4469 18.0533C24.4469 18.0533 23.3021 19.9867 20.3253 20.08Z'></path>
    </svg>
  )

  const [text, setText] = useState('Discord')

  const returnText = (bool: boolean): string => {
    if (bool) {
      return 'Did you know we have a Discord server? discord.gg/snackbox'
    } else {
      return 'discord.gg/snackbox'
    }
  }

  useEffect(() => {
    setText(returnText(window.innerWidth > 770)) // for first page load
    window.addEventListener('resize', () => {
      setText(returnText(window.innerWidth > 770)) // if the page is resized
    })
  }, [])

  return (
    <div className={'container ' + bannerOutside}>
      <Link href='https://discord.gg/snackbox' target='_blank' rel='noreferrer'>
        <div className={banner}>
          <span className={svg}>{svgElement}</span> {text}
        </div>
      </Link>
    </div>
  )
}

export default DiscordBanner
