
## 从输入 URL 到展现页面的全过程

### 1. 域名解析（假设域名没有缓存）

1. 组织 UDP 数据包，源端口号为浏览器端口号，目的端口号为 53。向下传输至网络层，源 IP 地址为本机 IP 地址，目的 IP 地址为 DNS 服务器地址。继续向下传输至链路层，添加 MAC 头，若网关 MAC 地址位于缓存中，则直接获取。否则发送 ARP 包获取网关地址。得到网关地址后，数据包已完整，由网卡发出。
2. 数据包经由多个路由器到达 DNS 服务器后，DNS 服务器查询域名所对应的 IP 地址，可能查的到，也可能查不到。如果查到了，就把域名对应的 IP 地址放入到网络包内返回。若没有查找，则将当前 DNS 服务器的下层 DNS 服务器地址放回网络包中返回。
3. 客户端收到 DNS 的数据包以后，若得到的域名对应的 IP 地址则进行下一步。否则使用 DNS 服务器返回的下层 DNS 服务器 IP 地址，继续查询，直到查询到域名对应的 IP。或者根本没有这个域名，浏览器直接给出提示。

### 2. TCP 连接建立

1. 客户端向服务端发送带有 SYN 标志位以及一个随机的 Seq 序列号（X）的 TCP 数据包，目的端口号为 80，并将自己的 MSS大小、接收窗口大小（Win）一并放入数据包内，请求建立连接。
2. 服务端在收到客户端发来的 SYN 包以后，生成带有 SYN + ACK 标志的数据包，设置 Ack 确认号为 Seq + 1，并生成一个随机的 Seq 序列号（Y），与服务端 MSS大小、接收窗口大小（Win）一起添加至该数据包内，回送至客户端。
3. 客户端收到服务端发送的 SYN + ACK 数据包以后，需要回复确认包。即发送一个带有 ACK 标志位的数据包，此时 Seq 序列号为 X + 1，Ack 确认号为 Y + 1。连接已建立，开始正式传输 HTTP 数据。


### 3. 数据传输

浏览器将 URL 中的 URI、请求头等信息添加至 HTTP 数据包中，并设置请求方法为 GET，通过上面建立的 TCP 连接发出。服务端收到该数据包后进行处理，并返回浏览器所需要的数据。数据传输至浏览器以后，浏览器不断地从 TCP 缓冲区中读取数据，组成 response。

### 4. 数据渲染

浏览器根据 response 中的 HTML 文本内容开始进行渲染，并请求嵌入至 HTML 的相关资源，如 CSS、JS、图片、视频或者是音频等。
