// Copyright (c) Parbad. All rights reserved.
// Licensed under the GNU GENERAL PUBLIC License, Version 3.0. See License.txt in the project root for license information.

using Parbad.Options;

namespace Parbad.Gateway.IranKish.Internal
{
    internal static class IranKishGatewayResultTranslator
    {
        public static string Translate(string result, MessagesOptions options)
        {
            return result switch
            {
                "5" => "از انجام تراکنش صرف نظر شد",
                "3" => "پذیرنده فروشگاهی نامعتبر است",
                "17" => "اعلام انصراف مشتری",
                "64" => "مبلغ تراکنش نادرست است، جمع مبالغ تقسیم وجوه برابر مبلغ کل تراکنش نمی باشد",
                "94" => "تراکنش تکراری است",
                "25" => "تراکنش اصلی یافت نشد",
                "77" => "روز مالی تراکنش نامعتبر است",
                "63" => "کد اعتبار سنجی پیام نامعتبر است",
                "97" => "کد تولید کد اعتبار سنجی نامعتبر است",
                "30" => "فرمت پیام نادرست است",
                "86" => "شتاب در حال Sign Off است",
                "55" => "رمز کارت نادرست است",
                "40" => "عمل درخواستی پشتیبانی نمی شود",
                "57" => "انجام تراکنش مورد درخواست توسط پایانه انجام دهنده مجاز نمی باشد",
                "58" => "انجام تراکنش مورد درخواست توسط پایانه انجام دهنده مجاز نمی باشد",
                "96" => "قوانین سامانه نقض گردیده است ، خطای داخلی سامانه",
                "2" => "تراکنش قبلا برگشت شده است",
                "54" => "تاریخ انقضا کارت سررسید شده است",
                "62" => "کارت محدود شده است",
                "75" => "تعداد دفعات ورود رمز اشتباه از حد مجاز فراتر رفته است",
                "14" => "اطلاعات کارت صحیح نمی باشد",
                "51" => "موجودی حساب کافی نمی باشد",
                "56" => "اطلاعات کارت یافت نشد",
                "61" => "مبلغ تراکنش بیش از حد مجاز است",
                "65" => "تعداد دفعات انجام تراکنش بیش از حد مجاز است",
                "78" => "کارت فعال نیست",
                "79" => "حساب متصل به کارت بسته یا دارای اشکال است",
                "42" => "کارت یا حساب در وضعیت پذیرش نمی باشد",
                "31" => "عدم تطابق کد ملی خریدار با دارنده کارت",
                "98" => "سقف استفاده از رمز دوم ایستا به پایان رسیده است",
                "901" => "درخواست نامعتبر است",
                "902" => "پارامترهای اضافی درخواست نامعتبر می باشد",
                "903" => "شناسه پرداخت نامعتبر می باشد",
                "904" => "اطلاعات مرتبط با قبض نامعتبر می باشد",
                "905" => "شناسه درخواست نامعتبر می باشد",
                "906" => "درخواست تاریخ گذشته است",
                "907" => "آدرس بازگشت نتیجه پرداخت نامعتبر می باشد",
                "909" => "پذیرنده نامعتبر می باشد",
                "910" => "پارامترهای مورد انتظار پرداخت تسهیمی تامین نگردیده است",
                "911" => "پارامترهای مورد انتظار پرداخت تسهیمی نامعتبر یا دارای اشکال می باشد",
                "912" => "تراکنش درخواستی برای پذیرنده فعال نیست",
                "913" => "تراکنش تسهیم برای پذیرنده فعال نیست",
                "914" => "آدرس آی پی دریافتی درخواست نامعتبر می باشد",
                "915" => "شماره پایانه نامعتبر می باشد",
                "916" => "شماره پذیرنده نامعتبر می باشد",
                "917" => "نوع تراکنش اعلام شده در خواست نامعتبر می باشد",
                "918" => "پذیرنده فعال نیست",
                "919" => "مبالغ تسهیمی ارائه شده با توجه به قوانین حاکم بر وضعیت تسهیم پذیرنده ، نامعتبر است",
                "920" => "شناسه نشانه نامعتبر می باشد",
                "921" => "شناسه نشانه نامعتبر و یا منقضی شده است",
                "922" => "نقض امنیت درخواست",
                "923" => "ارسال شناسه پرداخت در تراکنش قبض مجاز نیست",
                "928" => "مبلغ مبادله شده نامعتبر می باشد",
                "929" => "شناسه پرداخت ارائه شده با توجه به الگوریتم متناظر نامعتبر می باشد",
                "930" => "کد ملی ارائه شده نامعتبر می باشد",
                _ => $"{options.UnexpectedErrorText} Response: {result}"
            };
        }
    }
}
