# Parbad - Online Payment Library for .NET developers

[<img align="right" width="150px" src="https://raw.githubusercontent.com/Sina-Soltani/Parbad/master/images/Parbad-256x256.png" />](https://www.nuget.org/packages/Parbad/)

Parbad is a free and open-source integrated online payment library which helps developers to add the online payment ability to their websites. It provides an easy solution to perform payment request, verify the requested payment and refund a payment.

[![NuGet version](https://img.shields.io/nuget/v/parbad.svg?style=flat&label=nuget)](https://www.nuget.org/packages/Parbad/)
[![Nuget Downloads](https://img.shields.io/nuget/dt/parbad.svg?color=blue&label=Downloads)](https://www.nuget.org/packages/Parbad/)
[![Build Status](https://dev.azure.com/ssoltani/Parbad/_apis/build/status/Sina-Soltani.Parbad?branchName=master)](https://dev.azure.com/ssoltani/Parbad/_build/latest?definitionId=5&branchName=master)

# Benefits and features
* Free and open-source
* Easy installation using Nuget
* No need to add any web service
* High security checks
* Virtual Gateway for developing and testing your application.
* Configurable Proxy
* Created with modern and standard technologies
* Supports ASP.NET CORE, ASP.NET MVC and ASP.NET WebForms
* Supported online payment providers:
  * [Mellat](https://www.nuget.org/packages/Parbad/)
  * [Melli](https://www.nuget.org/packages/Parbad/)
  * [Saman](https://www.nuget.org/packages/Parbad/)
  * [Pasargad](https://www.nuget.org/packages/Parbad/)
  * [Parsian](https://www.nuget.org/packages/Parbad/)
  * [Iran Kish](https://www.nuget.org/packages/Parbad/)
  * [Asan Pardakht](https://www.nuget.org/packages/Parbad/)
  * [Sepehr](https://www.nuget.org/packages/Parbad.Gateway.Sepehr/)
  * [ZarinPal](https://www.nuget.org/packages/Parbad.Gateway.ZarinPal/)
  * [Pay.ir](https://www.nuget.org/packages/Parbad.Gateway.PayIr/)
  * [IDPay.ir](https://www.nuget.org/packages/Parbad.Gateway.IdPay/)
  * [YekPay](https://www.nuget.org/packages/Parbad.Gateway.YekPay/)
  * [PayPing](https://www.nuget.org/packages/Parbad.Gateway.PayPing/)
  * [Zibal](https://www.nuget.org/packages/Parbad.Gateway.Zibal/)

# How it works?
![image](https://raw.githubusercontent.com/Sina-Soltani/Parbad/master/images/How-it-works.png)

# Tutorials

* [How to use it?](https://github.com/Sina-Soltani/Parbad/wiki/How-to-use-it%3F)
* [Installation](https://github.com/Sina-Soltani/Parbad/wiki/Installation)
* [Configuration](https://github.com/Sina-Soltani/Parbad/wiki/Configuration)
* [Payment](https://github.com/Sina-Soltani/Parbad/wiki/Payment)
* [Virtual Gateway](https://github.com/Sina-Soltani/Parbad/wiki/Virtual-Gateway)
* [Developing a new Gateway](https://github.com/Sina-Soltani/Parbad/wiki/Developing-a-new-Gateway)
* Samples
  * [Project Samples](https://github.com/Sina-Soltani/Parbad.Samples)
  * [Docker Demo](https://hub.docker.com/r/ssoltani/parbad.samples.aspnetcore)
* [Any question, problem or idea?](https://github.com/Sina-Soltani/Parbad/discussions?discussions_q=category%3AQ%26A)

[مشاهده مقاله قدیمی به فارسی](https://www.dntips.ir/post/3009/%d9%be%d8%b1%d8%a8%d8%a7%d8%af-%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d9%be%db%8c%d8%a7%d8%af%d9%87%e2%80%8c%d8%b3%d8%a7%d8%b2%db%8c-%d9%be%d8%b1%d8%af%d8%a7%d8%ae%d8%aa-%d8%a2%d9%86%d9%84%d8%a7%db%8c%d9%86-%d8%af%d8%b1-%d8%af%d8%a7%d8%aa-%d9%86%d8%aa-%d9%85%d9%82%d8%af%d9%85%d9%87)

توجه: آموزش‌ها و مثال‌های به روز شده را در گیت هاب دنبال کنید

# How can I contribute?
[Contributing](https://github.com/Sina-Soltani/Parbad/blob/master/CONTRIBUTING.md) explains what kinds of changes are welcome.

لطفا در صورت تمایل به مشارکت در پروژه، لینک بالا را حتما مطالعه کنید
