## Pull Requests

You would like to join the Parbad development and send a Pull Request? Then please read the bellow instructions:

**First of all:**

Create an [issue](https://github.com/Sina-Soltani/Parbad/issues/new/choose) and explain what your Pull Request is for. Maybe you don't need to do anything at all! If everything goes right after the discussion then continue the following steps.

## DOs and DON'Ts

### Do:
- **Do** follow [Microsoft coding style](https://github.com/dotnet/runtime/blob/master/docs/coding-guidelines/coding-style.md)
- **Do** write human readable codes. If you don't know how search for:
  - Clean Code
  - C# Naming Convention
- **Do** create a new branch from the `master` branch.
  - Branch name pattern: `[feature|bug]/[issue number]_[name]`
  - Examples: `feature/70_AddingSomething`, `bug/80_FixingSomething`
- **Do** write summary for codes (Interfaces, Classes, Methods, Properties, etc.) that are `public`, when you think that their usages are hard to understand. If your english is not so much good, don't worry, I will write suggestions for you during the code review.
- **Do** let people know how your feature works by writing a nice and understandable Wiki guidline. It's really kind from you and it will be added in [Wiki](https://github.com/Sina-Soltani/Parbad/wiki) page.

### Don't:
- **Don't** use 3rd party libraries which are not popular.
- **Don't** change another files that are not related to the issue and pull request.
- **Don't** merge any other branches into your branch. Your branch must be created only from the `master` branch.
- **Don't** participate please if you are a person who gets bored quickly. Every single line of code will be checked. It depends on the size of pull requests. It can even take a few days!
- **Don't** do it dirty. Otherwise you have to rewrite it again!