/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Predicate;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.ContainsUpperBoundSuperTypeVisitor;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.Visitor;

public final class TemplateType
extends ProxyObjectType {
    private static final long serialVersionUID = 1L;
    private final String name;
    private JSType bound;
    private final Node typeTransformation;

    TemplateType(JSTypeRegistry registry, String name) {
        this(registry, name, null, null);
    }

    TemplateType(JSTypeRegistry registry, String name, JSType bound) {
        this(registry, name, bound, null);
    }

    TemplateType(JSTypeRegistry registry, String name, Node typeTransformation) {
        this(registry, name, null, typeTransformation);
    }

    private TemplateType(JSTypeRegistry registry, String name, JSType bound, Node typeTransformation) {
        super(registry, bound == null ? registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE) : bound);
        this.name = name;
        this.bound = bound == null ? registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE) : bound;
        this.typeTransformation = typeTransformation;
    }

    @Override
    public String getReferenceName() {
        return this.name;
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        if (this.bound == this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE)) {
            return sb.append(this.name);
        }
        return sb.append(this.name).append(" extends ").append(this.bound);
    }

    @Override
    public TemplateType toMaybeTemplateType() {
        return this;
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return true;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseTemplateType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseTemplateType(this, that);
    }

    public boolean isTypeTransformation() {
        return this.typeTransformation != null;
    }

    public Node getTypeTransformation() {
        return this.typeTransformation;
    }

    public JSType getBound() {
        return this.bound;
    }

    public void setBound(JSType bound) {
        this.bound = bound;
        this.setReferencedType(bound);
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.isSubtype(that, JSType.ImplCache.create(), JSType.SubtypingMode.NORMAL);
    }

    @Override
    protected boolean isSubtype(JSType that, JSType.ImplCache implicitImplCache, JSType.SubtypingMode subtypingMode) {
        if (!this.getBound().isUnknownType() && that.isTemplateType() && !that.toMaybeTemplateType().getBound().isUnknownType()) {
            return this.visit(new ContainsUpperBoundSuperTypeVisitor(that)) == ContainsUpperBoundSuperTypeVisitor.Result.PRESENT;
        }
        return super.isSubtype(that, implicitImplCache, subtypingMode);
    }

    @Override
    public boolean equals(Object jsType) {
        return jsType instanceof TemplateType && JSType.areIdentical(this, (JSType)jsType);
    }

    @Override
    public boolean setValidator(Predicate<JSType> validator) {
        return validator.apply(this);
    }

    public boolean containsCycle() {
        ContainsUpperBoundSuperTypeVisitor typeVisitor = new ContainsUpperBoundSuperTypeVisitor(null);
        return this.visit(typeVisitor) == ContainsUpperBoundSuperTypeVisitor.Result.CYCLE;
    }
}

