/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.parsing.JsDocToken;
import com.google.javascript.rhino.TokenUtil;

public class JsDocTokenStream {
    private static final int EOF_CHAR = -1;
    private String string = "";
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private final int[] ungetBuffer = new int[3];
    private int ungetCursor;
    private int lineStart = 0;
    private int lineEndChar = -1;
    int lineno;
    private int charno = -1;
    private final int initCharno;
    private final int initLineno;
    private final String sourceString;
    private final int sourceEnd;
    int sourceCursor;
    int cursor;

    public JsDocTokenStream(String sourceString) {
        this(sourceString, 0);
    }

    JsDocTokenStream(String sourceString, int lineno) {
        this(sourceString, lineno, 0);
    }

    JsDocTokenStream(String sourceString, int lineno, int initCharno) {
        Preconditions.checkNotNull(sourceString);
        this.lineno = lineno;
        this.sourceString = sourceString;
        this.sourceEnd = sourceString.length();
        this.cursor = 0;
        this.sourceCursor = 0;
        this.initLineno = lineno;
        this.initCharno = initCharno;
    }

    final JsDocToken getJsDocToken() {
        int c;
        this.stringBufferTop = 0;
        do {
            this.charno = -1;
            c = this.getChar();
            if (c == -1) {
                return JsDocToken.EOF;
            }
            if (c != 10) continue;
            return JsDocToken.EOL;
        } while (TokenUtil.isJSSpace(c));
        switch (c) {
            case 64: {
                while (JsDocTokenStream.isAlpha(c = this.getChar())) {
                    this.addToString(c);
                }
                this.ungetChar(c);
                this.string = this.getStringFromBuffer();
                this.stringBufferTop = 0;
                return JsDocToken.ANNOTATION;
            }
            case 42: {
                if (this.matchChar(47)) {
                    return JsDocToken.EOC;
                }
                return JsDocToken.STAR;
            }
            case 44: {
                return JsDocToken.COMMA;
            }
            case 62: {
                return JsDocToken.RIGHT_ANGLE;
            }
            case 40: {
                return JsDocToken.LEFT_PAREN;
            }
            case 41: {
                return JsDocToken.RIGHT_PAREN;
            }
            case 123: {
                return JsDocToken.LEFT_CURLY;
            }
            case 125: {
                return JsDocToken.RIGHT_CURLY;
            }
            case 91: {
                return JsDocToken.LEFT_SQUARE;
            }
            case 93: {
                return JsDocToken.RIGHT_SQUARE;
            }
            case 63: {
                return JsDocToken.QMARK;
            }
            case 33: {
                return JsDocToken.BANG;
            }
            case 58: {
                return JsDocToken.COLON;
            }
            case 61: {
                return JsDocToken.EQUALS;
            }
            case 124: {
                return JsDocToken.PIPE;
            }
            case 60: {
                return JsDocToken.LEFT_ANGLE;
            }
            case 46: {
                c = this.getChar();
                if (c == 60) {
                    return JsDocToken.LEFT_ANGLE;
                }
                if (c == 46) {
                    c = this.getChar();
                    if (c == 46) {
                        return JsDocToken.ITER_REST;
                    }
                    this.addToString(46);
                }
                this.ungetBuffer[this.ungetCursor++] = c;
                c = 46;
            }
        }
        int c1 = c;
        this.addToString(c);
        int c2 = this.getChar();
        if (!JsDocTokenStream.isJSDocString(c2)) {
            this.ungetChar(c2);
            this.string = this.getStringFromBuffer();
            this.stringBufferTop = 0;
            return JsDocToken.STRING;
        }
        while (true) {
            c1 = c2;
            c2 = this.getChar();
            if (c1 == 46 && c2 == 60) {
                this.ungetChar(c2);
                this.ungetChar(c1);
                this.string = this.getStringFromBuffer();
                this.stringBufferTop = 0;
                return JsDocToken.STRING;
            }
            if (!JsDocTokenStream.isJSDocString(c2)) break;
            this.addToString(c1);
        }
        this.ungetChar(c2);
        this.addToString(c1);
        this.string = this.getStringFromBuffer();
        this.stringBufferTop = 0;
        return JsDocToken.STRING;
    }

    String getRemainingJSDocLine() {
        block4: while (true) {
            int c = this.getChar();
            switch (c) {
                case 42: {
                    if (this.peekChar() != 47) {
                        this.addToString(c);
                        continue block4;
                    }
                }
                case -1: 
                case 10: {
                    this.ungetChar(c);
                    this.string = this.getStringFromBuffer();
                    this.stringBufferTop = 0;
                    return this.string;
                }
            }
            this.addToString(c);
        }
    }

    final int getLineno() {
        return this.lineno;
    }

    final int getCharno() {
        return this.lineno == this.initLineno ? this.initCharno + this.charno : this.charno;
    }

    final String getString() {
        return this.string;
    }

    private String getStringFromBuffer() {
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int c) {
        int n = this.stringBufferTop;
        if (n == this.stringBuffer.length) {
            char[] tmp = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, tmp, 0, n);
            this.stringBuffer = tmp;
        }
        this.stringBuffer[n] = (char)c;
        this.stringBufferTop = n + 1;
    }

    void ungetChar(int c) {
        assert (this.ungetCursor == 0 || this.ungetBuffer[this.ungetCursor - 1] != 10);
        this.ungetBuffer[this.ungetCursor++] = c;
        --this.cursor;
    }

    private boolean matchChar(int test) {
        int c = this.getCharIgnoreLineEnd();
        if (c == test) {
            return true;
        }
        this.ungetCharIgnoreLineEnd(c);
        return false;
    }

    private static boolean isAlpha(int c) {
        if (c <= 90) {
            return 65 <= c;
        }
        return 97 <= c && c <= 122;
    }

    private static boolean isJSDocString(int c) {
        switch (c) {
            case -1: 
            case 10: 
            case 33: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 91: 
            case 93: 
            case 123: 
            case 124: 
            case 125: {
                return false;
            }
        }
        return !TokenUtil.isJSSpace(c);
    }

    void update() {
        this.charno = this.getOffset();
    }

    private int peekChar() {
        int c = this.getChar();
        this.ungetChar(c);
        return c;
    }

    protected int getChar() {
        int c;
        block11: {
            if (this.ungetCursor != 0) {
                ++this.cursor;
                --this.ungetCursor;
                if (this.charno == -1) {
                    this.charno = this.getOffset();
                }
                return this.ungetBuffer[this.ungetCursor];
            }
            while (true) {
                if (this.sourceCursor == this.sourceEnd) {
                    if (this.charno == -1) {
                        this.charno = this.getOffset();
                    }
                    return -1;
                }
                ++this.cursor;
                c = this.sourceString.charAt(this.sourceCursor++);
                if (this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && c == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    this.lineStart = this.sourceCursor - 1;
                    ++this.lineno;
                }
                if (c <= 127) {
                    if (c == 10 || c == 13) {
                        this.lineEndChar = c;
                        c = 10;
                    }
                    break block11;
                }
                if (!TokenUtil.isJSFormatChar(c)) break;
            }
            if (JsDocTokenStream.isJSLineTerminator(c)) {
                this.lineEndChar = c;
                c = 10;
            }
        }
        if (this.charno == -1) {
            this.charno = this.getOffset();
        }
        return c;
    }

    private int getCharIgnoreLineEnd() {
        int c;
        block8: {
            if (this.ungetCursor != 0) {
                ++this.cursor;
                --this.ungetCursor;
                if (this.charno == -1) {
                    this.charno = this.getOffset();
                }
                return this.ungetBuffer[this.ungetCursor];
            }
            do {
                if (this.sourceCursor == this.sourceEnd) {
                    if (this.charno == -1) {
                        this.charno = this.getOffset();
                    }
                    return -1;
                }
                ++this.cursor;
                if ((c = this.sourceString.charAt(this.sourceCursor++)) > 127) continue;
                if (c == 10 || c == 13) {
                    this.lineEndChar = c;
                    c = 10;
                }
                break block8;
            } while (TokenUtil.isJSFormatChar(c));
            if (JsDocTokenStream.isJSLineTerminator(c)) {
                this.lineEndChar = c;
                c = 10;
            }
        }
        if (this.charno == -1) {
            this.charno = this.getOffset();
        }
        return c;
    }

    private static boolean isJSLineTerminator(int c) {
        if ((c & 0xDFD0) != 0) {
            return false;
        }
        return c == 10 || c == 13 || c == 8232 || c == 8233;
    }

    private void ungetCharIgnoreLineEnd(int c) {
        this.ungetBuffer[this.ungetCursor++] = c;
        --this.cursor;
    }

    final int getOffset() {
        return this.sourceCursor - this.lineStart - this.ungetCursor - 1;
    }
}

