/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

public class CheckConstantCaseNames
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    public static final DiagnosticType MISSING_CONST_PROPERTY = DiagnosticType.disabled("JSC_MISSING_CONST_ON_CONSTANT_CASE", "CONSTANT_CASE {0} is constant-by-convention, so must be explicitly `const` or @const");
    private final AbstractCompiler compiler;
    private final CodingConvention convention;

    public CheckConstantCaseNames(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.convention = compiler.getCodingConvention();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!t.inModuleScope()) {
            return;
        }
        switch (n.getToken()) {
            case VAR: 
            case LET: {
                JSDocInfo info = n.getJSDocInfo();
                if (info != null && info.hasConstAnnotation()) break;
                for (Node name : NodeUtil.findLhsNodesInNode(n)) {
                    if (!this.convention.isConstant(name.getString())) continue;
                    t.report(name, MISSING_CONST_PROPERTY, name.getString());
                }
                break;
            }
        }
    }
}

