/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.ModuleResolver;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class NodeModuleResolver
extends ModuleResolver {
    private static final String[] FILE_EXTENSIONS_TO_SEARCH = new String[]{"", ".js", ".json", ".i.js", ".js.i.js"};
    private static final String[] FILES_TO_SEARCH = new String[]{"/package.json", "/index.js", "/index.json"};
    private final ImmutableMap<String, String> packageJsonMainEntries;
    private final ImmutableSortedSet<String> nodeModulesFolders;

    private static ImmutableSortedSet<String> buildNodeModulesFoldersRegistry(Iterable<String> modulePaths, Iterable<String> moduleRootPaths) {
        TreeSet<String> registry = new TreeSet<String>((a, b) -> {
            int comparison = Integer.compare(b.length(), a.length());
            if (comparison != 0) {
                return comparison;
            }
            return a.compareTo((String)b);
        });
        for (String modulePath : modulePaths) {
            for (String moduleRootPath : moduleRootPaths) {
                if (!modulePath.startsWith(moduleRootPath)) continue;
                modulePath = modulePath.substring(moduleRootPath.length());
                break;
            }
            String[] nodeModulesDirs = modulePath.split("/node_modules/");
            String parentPath = "";
            for (int i = 0; i < nodeModulesDirs.length - 1; ++i) {
                if (i + 1 < nodeModulesDirs.length) {
                    parentPath = parentPath + nodeModulesDirs[i] + "/";
                }
                registry.add(parentPath);
                parentPath = parentPath + "node_modules/";
            }
        }
        return ImmutableSortedSet.copyOfSorted(registry);
    }

    public NodeModuleResolver(ImmutableSet<String> modulePaths, ImmutableList<String> moduleRootPaths, Map<String, String> packageJsonMainEntries, ErrorHandler errorHandler, ModuleLoader.PathEscaper pathEscaper) {
        super(modulePaths, moduleRootPaths, errorHandler, pathEscaper);
        this.nodeModulesFolders = NodeModuleResolver.buildNodeModulesFoldersRegistry(modulePaths, moduleRootPaths);
        this.packageJsonMainEntries = packageJsonMainEntries == null ? ImmutableMap.of() : this.buildPackageJsonMainEntries(packageJsonMainEntries);
    }

    private ImmutableMap<String, String> buildPackageJsonMainEntries(Map<String, String> packageJsonMainEntries) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (Map.Entry<String, String> packageJsonMainEntry : packageJsonMainEntries.entrySet()) {
            String entryKey = packageJsonMainEntry.getKey();
            if (ModuleLoader.isAmbiguousIdentifier(entryKey)) {
                entryKey = "/" + entryKey;
            }
            builder.put(entryKey, packageJsonMainEntry.getValue());
        }
        return builder.build();
    }

    @Override
    Map<String, String> getPackageJsonMainEntries() {
        return this.packageJsonMainEntries;
    }

    @Override
    @Nullable
    public String resolveJsModule(String scriptAddress, String moduleAddress, String sourcename, int lineno, int colno) {
        String loadAddress = ModuleLoader.isAbsoluteIdentifier(moduleAddress) || ModuleLoader.isRelativeIdentifier(moduleAddress) ? this.resolveJsModuleNodeFileOrDirectory(scriptAddress, moduleAddress) : this.resolveJsModuleFromRegistry(scriptAddress, moduleAddress);
        if (loadAddress == null) {
            this.errorHandler.report(CheckLevel.WARNING, JSError.make(sourcename, lineno, colno, ModuleLoader.LOAD_WARNING, moduleAddress));
        }
        return loadAddress;
    }

    public String resolveJsModuleFile(String scriptAddress, String moduleAddress) {
        for (String extension : FILE_EXTENSIONS_TO_SEARCH) {
            String moduleAddressCandidate = moduleAddress + extension;
            String canonicalizedCandidatePath = this.canonicalizePath(scriptAddress, moduleAddressCandidate);
            if (this.packageJsonMainEntries.containsKey(canonicalizedCandidatePath) && "$jscomp$browser$blacklisted".equals(moduleAddressCandidate = this.packageJsonMainEntries.get(canonicalizedCandidatePath))) {
                return null;
            }
            String loadAddress = this.locate(scriptAddress, moduleAddressCandidate);
            if (loadAddress == null) continue;
            return loadAddress;
        }
        return null;
    }

    @Nullable
    private String resolveJsModuleNodeFileOrDirectory(String scriptAddress, String moduleAddress) {
        String loadAddress = this.resolveJsModuleFile(scriptAddress, moduleAddress);
        if (loadAddress == null) {
            loadAddress = this.resolveJsModuleNodeDirectory(scriptAddress, moduleAddress);
        }
        return loadAddress;
    }

    @Nullable
    private String resolveJsModuleNodeDirectory(String scriptAddress, String moduleAddress) {
        if (moduleAddress.endsWith("/")) {
            moduleAddress = moduleAddress.substring(0, moduleAddress.length() - 1);
        }
        for (int i = 0; i < FILES_TO_SEARCH.length; ++i) {
            String loadAddress = this.locate(scriptAddress, moduleAddress + FILES_TO_SEARCH[i]);
            if (loadAddress == null) continue;
            if (FILES_TO_SEARCH[i].equals("/package.json")) {
                if (!this.packageJsonMainEntries.containsKey(loadAddress)) continue;
                return this.resolveJsModuleFile(scriptAddress, this.packageJsonMainEntries.get(loadAddress));
            }
            return loadAddress;
        }
        return null;
    }

    @Nullable
    private String resolveJsModuleFromRegistry(String scriptAddress, String moduleAddress) {
        String normalizedScriptAddress = (ModuleLoader.isAmbiguousIdentifier(scriptAddress) ? "/" : "") + scriptAddress;
        for (String nodeModulesFolder : this.nodeModulesFolders) {
            if (!normalizedScriptAddress.startsWith(nodeModulesFolder)) continue;
            String fullModulePath = nodeModulesFolder + "node_modules/" + moduleAddress;
            String loadAddress = this.resolveJsModuleFile(scriptAddress, fullModulePath);
            if (loadAddress == null) {
                loadAddress = this.resolveJsModuleNodeDirectory(scriptAddress, fullModulePath);
            }
            if (loadAddress == null) continue;
            return loadAddress;
        }
        return null;
    }

    public static final class Factory
    implements ModuleLoader.ModuleResolverFactory {
        private final Map<String, String> packageJsonMainEntries;

        public Factory() {
            this(null);
        }

        public Factory(@Nullable Map<String, String> packageJsonMainEntries) {
            this.packageJsonMainEntries = packageJsonMainEntries;
        }

        @Override
        public ModuleResolver create(ImmutableSet<String> modulePaths, ImmutableList<String> moduleRootPaths, ErrorHandler errorHandler, ModuleLoader.PathEscaper pathEscaper) {
            return new NodeModuleResolver(modulePaths, moduleRootPaths, this.packageJsonMainEntries, errorHandler, pathEscaper);
        }
    }
}

