/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;

public final class Es6RewriteDestructuring
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    public static final DiagnosticType UNEXPECTED_DESTRUCTURING_REST_PARAMETER = DiagnosticType.error("JSC_UNEXPECTED_DESTRUCTURING_REST_PARAMETER", "Es6RewriteDestructuring not expecting object pattern rest parameter");
    private final AbstractCompiler compiler;
    private final ObjectDestructuringRewriteMode rewriteMode;
    private final AstFactory astFactory;
    private final FeatureSet featuresToTriggerRunningPass;
    private final FeatureSet featuresToMarkAsRemoved;
    private final Deque<PatternNestingLevel> patternNestingStack = new ArrayDeque<PatternNestingLevel>();
    static final String DESTRUCTURING_TEMP_VAR = "$jscomp$destructuring$var";
    private int destructuringVarCounter = 0;

    private Es6RewriteDestructuring(Builder builder) {
        this.compiler = builder.compiler;
        this.rewriteMode = builder.rewriteMode;
        this.astFactory = this.compiler.createAstFactory();
        switch (this.rewriteMode) {
            case REWRITE_ALL_OBJECT_PATTERNS: {
                this.featuresToTriggerRunningPass = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.DEFAULT_PARAMETERS, FeatureSet.Feature.ARRAY_DESTRUCTURING, FeatureSet.Feature.ARRAY_PATTERN_REST, FeatureSet.Feature.OBJECT_DESTRUCTURING);
                this.featuresToMarkAsRemoved = this.featuresToTriggerRunningPass.with(FeatureSet.Feature.OBJECT_PATTERN_REST);
                break;
            }
            case REWRITE_OBJECT_REST: {
                this.featuresToMarkAsRemoved = this.featuresToTriggerRunningPass = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.OBJECT_PATTERN_REST);
                break;
            }
            default: {
                throw new AssertionError((Object)("Es6RewriteDestructuring cannot handle ObjectDestructuringRewriteMode " + (Object)((Object)this.rewriteMode)));
            }
        }
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState(this.patternNestingStack.isEmpty());
        TranspilationPasses.processTranspile(this.compiler, externs, this.featuresToTriggerRunningPass, this);
        TranspilationPasses.processTranspile(this.compiler, root, this.featuresToTriggerRunningPass, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, this.featuresToMarkAsRemoved);
        Preconditions.checkState(this.patternNestingStack.isEmpty());
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        Preconditions.checkState(this.patternNestingStack.isEmpty());
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, this.featuresToTriggerRunningPass, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, this.featuresToMarkAsRemoved);
        Preconditions.checkState(this.patternNestingStack.isEmpty());
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case FUNCTION: {
                this.ensureArrowFunctionsHaveBlockBodies(t, n);
                break;
            }
            case PARAM_LIST: {
                this.pullDestructuringOutOfParams(n, parent);
                break;
            }
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                boolean hasRest;
                boolean bl = hasRest = n.isObjectPattern() && n.hasChildren() && n.getLastChild().isRest();
                if (!this.patternNestingStack.isEmpty() && hasRest) {
                    for (PatternNestingLevel level : this.patternNestingStack) {
                        if (level.hasNestedObjectRest) break;
                        level.hasNestedObjectRest = true;
                    }
                    this.patternNestingStack.peekLast().hasNestedObjectRest = true;
                }
                this.patternNestingStack.addLast(new PatternNestingLevel(n, hasRest));
                break;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (parent != null && parent.isDestructuringLhs()) {
            parent = parent.getParent();
        }
        switch (n.getToken()) {
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                this.visitPattern(t, n, parent);
                if (n != this.patternNestingStack.getLast().pattern) break;
                this.patternNestingStack.removeLast();
                break;
            }
        }
    }

    private void ensureArrowFunctionsHaveBlockBodies(NodeTraversal t, Node function) {
        Node body = function.getLastChild();
        if (!body.isBlock()) {
            body.detach();
            Node replacement = IR.block(IR.returnNode(body)).useSourceInfoIfMissingFromForTree(body);
            function.addChildToBack(replacement);
            t.reportCodeChange();
        }
    }

    private void pullDestructuringOutOfParams(Node paramList, Node function) {
        Node insertSpot = null;
        Node body = function.getLastChild();
        Node next = null;
        Node param = paramList.getFirstChild();
        while (param != null) {
            next = param.getNext();
            if (param.isDefaultValue()) {
                Node newParam;
                Node nameOrPattern = param.removeFirstChild();
                JSDocInfo jsDoc = nameOrPattern.getJSDocInfo();
                nameOrPattern.setJSDocInfo(null);
                Node defaultValue = param.removeFirstChild();
                boolean isNoop = false;
                if (nameOrPattern.isName()) {
                    if (defaultValue.isName()) {
                        isNoop = "undefined".equals(defaultValue.getString());
                    } else if (defaultValue.isVoid()) {
                        isNoop = NodeUtil.isImmutableValue(defaultValue.getFirstChild());
                    }
                }
                if (isNoop) {
                    newParam = nameOrPattern.cloneTree();
                } else {
                    newParam = nameOrPattern.isName() ? nameOrPattern : this.astFactory.createName(this.getTempVariableName(), nameOrPattern.getJSType());
                    Node lhs = nameOrPattern.cloneTree();
                    Node rhs = this.defaultValueHook(newParam.cloneTree(), defaultValue);
                    Node newStatement = nameOrPattern.isName() ? IR.exprResult(this.astFactory.createAssign(lhs, rhs)) : IR.var(lhs, rhs);
                    newStatement.useSourceInfoIfMissingFromForTree(param);
                    body.addChildAfter(newStatement, insertSpot);
                    insertSpot = newStatement;
                }
                paramList.replaceChild(param, newParam);
                newParam.setOptionalArg(true);
                newParam.setJSDocInfo(jsDoc);
                this.compiler.reportChangeToChangeScope(function);
            } else if (param.isDestructuringPattern()) {
                insertSpot = this.replacePatternParamWithTempVar(function, insertSpot, param, this.getTempVariableName());
                this.compiler.reportChangeToChangeScope(function);
            } else if (param.isRest() && param.getFirstChild().isDestructuringPattern()) {
                insertSpot = this.replacePatternParamWithTempVar(function, insertSpot, param.getFirstChild(), this.getTempVariableName());
                this.compiler.reportChangeToChangeScope(function);
            }
            param = next;
        }
    }

    private Node replacePatternParamWithTempVar(Node function, Node insertSpot, Node patternParam, String tempVarName) {
        JSType paramType = patternParam.getJSType();
        Node newParam = this.astFactory.createName(tempVarName, paramType);
        newParam.setJSDocInfo(patternParam.getJSDocInfo());
        patternParam.replaceWith(newParam);
        Node newDecl = IR.var(patternParam, this.astFactory.createName(tempVarName, paramType));
        function.getLastChild().addChildAfter(newDecl, insertSpot);
        return newDecl;
    }

    private String getTempVariableName() {
        return DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
    }

    private void visitPattern(NodeTraversal t, Node pattern, Node parent) {
        if (NodeUtil.isNameDeclaration(parent) && !NodeUtil.isEnhancedFor(parent.getParent())) {
            this.replacePattern(t, pattern, pattern.getNext(), parent, parent);
        } else if (parent.isAssign()) {
            if (parent.getParent().isExprResult()) {
                this.replacePattern(t, pattern, pattern.getNext(), parent, parent.getParent());
            } else {
                this.wrapAssignmentInCallToArrow(t, parent);
            }
        } else if (!(parent.isRest() || parent.isStringKey() || parent.isArrayPattern() || parent.isDefaultValue() || parent.isComputedProp())) {
            if (NodeUtil.isEnhancedFor(parent) || NodeUtil.isEnhancedFor(parent.getParent())) {
                this.visitDestructuringPatternInEnhancedFor(pattern);
            } else if (parent.isCatch()) {
                this.visitDestructuringPatternInCatch(t, pattern);
            } else {
                throw new IllegalStateException("unexpected parent");
            }
        }
    }

    private void replacePattern(NodeTraversal t, Node pattern, Node rhs, Node parent, Node nodeToDetach) {
        Preconditions.checkArgument(NodeUtil.isStatement(nodeToDetach), nodeToDetach);
        switch (pattern.getToken()) {
            case ARRAY_PATTERN: {
                this.replaceArrayPattern(t, pattern, rhs, parent, nodeToDetach);
                break;
            }
            case OBJECT_PATTERN: {
                this.replaceObjectPattern(t, pattern, rhs, parent, nodeToDetach);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
    }

    private void replaceObjectPattern(NodeTraversal t, Node objectPattern, Node rhs, Node parent, Node nodeToDetach) {
        Scope scope = t.getScope();
        String tempVarName = this.getTempVariableName();
        JSType tempVarType = objectPattern.getJSType();
        String restTempVarName = null;
        ArrayList<Node> propsToDeleteForRest = null;
        if (objectPattern.hasChildren() && objectPattern.getLastChild().isRest()) {
            propsToDeleteForRest = new ArrayList<Node>();
            restTempVarName = this.getTempVariableName();
        } else if (this.rewriteMode == ObjectDestructuringRewriteMode.REWRITE_OBJECT_REST && !this.patternNestingStack.peekLast().hasNestedObjectRest) {
            --this.destructuringVarCounter;
            return;
        }
        Node tempDecl = IR.var(this.astFactory.createName(tempVarName, tempVarType), rhs.detach()).useSourceInfoIfMissingFromForTree(objectPattern);
        if (parent.isConst()) {
            JSDocInfoBuilder jsDoc = new JSDocInfoBuilder(false);
            jsDoc.recordConstancy();
            tempDecl.setJSDocInfo(jsDoc.build());
        }
        nodeToDetach.getParent().addChildBefore(tempDecl, nodeToDetach);
        Node child = objectPattern.getFirstChild();
        while (child != null) {
            Node newNode;
            Node newRHS;
            Node newLHS;
            Node next = child.getNext();
            if (child.isStringKey()) {
                Node tempVarNameNode = this.astFactory.createName(tempVarName, tempVarType);
                Node getprop = child.isQuotedString() ? this.astFactory.createGetElem(tempVarNameNode, this.astFactory.createString(child.getString())) : this.astFactory.createGetProp(tempVarNameNode, child.getString());
                Node value = child.removeFirstChild();
                if (!value.isDefaultValue()) {
                    newLHS = value;
                    newRHS = getprop;
                } else {
                    newLHS = value.removeFirstChild();
                    Node defaultValue = value.removeFirstChild();
                    newRHS = this.defaultValueHook(getprop, defaultValue);
                }
                if (propsToDeleteForRest != null) {
                    propsToDeleteForRest.add(child);
                }
            } else if (child.isComputedProp()) {
                Node defaultValue;
                boolean hasDefault = child.getLastChild().isDefaultValue();
                Node propExpr = child.removeFirstChild();
                if (hasDefault) {
                    Node defaultNode = child.getLastChild();
                    newLHS = defaultNode.removeFirstChild();
                    defaultValue = defaultNode.removeFirstChild();
                } else {
                    newLHS = child.removeFirstChild();
                    defaultValue = null;
                }
                if (propsToDeleteForRest != null) {
                    String exprEvalTempVarName = this.getTempVariableName();
                    Node exprEvalTempVarModel = this.astFactory.createName(exprEvalTempVarName, propExpr.getJSType());
                    Node exprEvalDecl = IR.var(exprEvalTempVarModel.cloneNode(), propExpr);
                    exprEvalDecl.useSourceInfoIfMissingFromForTree(child);
                    nodeToDetach.getParent().addChildBefore(exprEvalDecl, nodeToDetach);
                    propExpr = exprEvalTempVarModel.cloneNode();
                    propsToDeleteForRest.add(exprEvalTempVarModel.cloneNode());
                }
                if (hasDefault) {
                    Node getelem = this.astFactory.createGetElem(this.astFactory.createName(tempVarName, tempVarType), propExpr);
                    String intermediateTempVarName = this.getTempVariableName();
                    Node intermediateDecl = IR.var(this.astFactory.createName(intermediateTempVarName, getelem.getJSType()), getelem);
                    intermediateDecl.useSourceInfoIfMissingFromForTree(child);
                    nodeToDetach.getParent().addChildBefore(intermediateDecl, nodeToDetach);
                    newRHS = this.defaultValueHook(this.astFactory.createName(intermediateTempVarName, getelem.getJSType()), defaultValue);
                } else {
                    newRHS = this.astFactory.createGetElem(this.astFactory.createName(tempVarName, newLHS.getJSType()), propExpr);
                }
            } else if (child.isRest()) {
                if (next != null) {
                    throw new IllegalStateException("object rest may not be followed by any properties");
                }
                Node assignCall = this.astFactory.createCall(this.astFactory.createQName(scope, "Object.assign"), new Node[0]);
                assignCall.addChildToBack(this.astFactory.createObjectLit(new Node[0]));
                assignCall.addChildToBack(this.astFactory.createName(tempVarName, tempVarType));
                Node restTempDecl = IR.var(this.astFactory.createName(restTempVarName, tempVarType), assignCall);
                restTempDecl.useSourceInfoIfMissingFromForTree(objectPattern);
                nodeToDetach.getParent().addChildAfter(restTempDecl, tempDecl);
                Node restName = child.getOnlyChild();
                newLHS = this.astFactory.createName(restName.getString(), restName.getJSType());
                newRHS = this.objectPatternRestRHS(objectPattern, child, restTempVarName, propsToDeleteForRest);
            } else {
                throw new IllegalStateException("unexpected child");
            }
            if (NodeUtil.isNameDeclaration(parent)) {
                newNode = IR.declaration(newLHS, newRHS, parent.getToken());
            } else if (parent.isAssign()) {
                newNode = IR.exprResult(this.astFactory.createAssign(newLHS, newRHS));
            } else {
                throw new IllegalStateException("not reached");
            }
            newNode.useSourceInfoIfMissingFromForTree(child);
            nodeToDetach.getParent().addChildBefore(newNode, nodeToDetach);
            this.visit(t, newLHS, newLHS.getParent());
            child = next;
        }
        nodeToDetach.detach();
        t.reportCodeChange();
    }

    private Node objectPatternRestRHS(Node objectPattern, Node rest, String restTempVarName, ArrayList<Node> statedProperties) {
        Preconditions.checkArgument(objectPattern.getLastChild() == rest);
        Node restTempVarModel = this.astFactory.createName(restTempVarName, objectPattern.getJSType());
        Node result = restTempVarModel.cloneNode();
        if (!statedProperties.isEmpty()) {
            Iterator<Node> propItr = statedProperties.iterator();
            Node comma = this.deletionNodeForRestProperty(restTempVarModel.cloneNode(), propItr.next());
            while (propItr.hasNext()) {
                comma = this.astFactory.createComma(comma, this.deletionNodeForRestProperty(restTempVarModel.cloneNode(), propItr.next()));
            }
            result = this.astFactory.createComma(comma, result);
        }
        result.useSourceInfoIfMissingFromForTree(rest);
        return result;
    }

    private Node deletionNodeForRestProperty(Node restTempVarNameNode, Node property) {
        Node get;
        switch (property.getToken()) {
            case STRING_KEY: {
                get = property.isQuotedString() ? this.astFactory.createGetElem(restTempVarNameNode, this.astFactory.createString(property.getString())) : this.astFactory.createGetProp(restTempVarNameNode, property.getString());
                break;
            }
            case NAME: {
                get = this.astFactory.createGetElem(restTempVarNameNode, property);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected property to delete node: " + property.toStringTree());
            }
        }
        return this.astFactory.createDelProp(get);
    }

    private void replaceArrayPattern(NodeTraversal t, Node arrayPattern, Node rhs, Node parent, Node nodeToDetach) {
        if (this.rewriteMode == ObjectDestructuringRewriteMode.REWRITE_OBJECT_REST && (this.patternNestingStack.isEmpty() || !this.patternNestingStack.peekLast().hasNestedObjectRest)) {
            return;
        }
        String tempVarName = this.getTempVariableName();
        Node makeIteratorCall = this.astFactory.createJSCompMakeIteratorCall(rhs.detach(), t.getScope());
        Node tempVarModel = this.astFactory.createName(tempVarName, makeIteratorCall.getJSType());
        Node tempDecl = IR.var(tempVarModel.cloneNode(), makeIteratorCall);
        tempDecl.useSourceInfoIfMissingFromForTree(arrayPattern);
        nodeToDetach.getParent().addChildBefore(tempDecl, nodeToDetach);
        Node child = arrayPattern.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (child.isEmpty()) {
                Node nextCall = IR.exprResult(this.astFactory.createCall(this.astFactory.createGetProp(tempVarModel.cloneNode(), "next"), new Node[0]));
                nextCall.useSourceInfoIfMissingFromForTree(child);
                nodeToDetach.getParent().addChildBefore(nextCall, nodeToDetach);
            } else {
                Node newNode;
                Node newRHS;
                Node newLHS;
                if (child.isDefaultValue()) {
                    String nextVarName = this.getTempVariableName();
                    Node nextCallDotValue = this.astFactory.createGetProp(this.astFactory.createCall(this.astFactory.createGetProp(tempVarModel.cloneNode(), "next"), new Node[0]), "value");
                    JSType nextVarType = nextCallDotValue.getJSType();
                    Node var = IR.var(this.astFactory.createName(nextVarName, nextVarType), nextCallDotValue);
                    var.useSourceInfoIfMissingFromForTree(child);
                    nodeToDetach.getParent().addChildBefore(var, nodeToDetach);
                    newLHS = child.getFirstChild().detach();
                    newRHS = this.defaultValueHook(this.astFactory.createName(nextVarName, nextVarType), child.getLastChild().detach());
                } else if (child.isRest()) {
                    newLHS = child.getFirstChild().detach();
                    newRHS = this.astFactory.createJscompArrayFromIteratorCall(tempVarModel.cloneNode(), t.getScope());
                } else {
                    newLHS = child.detach();
                    newRHS = this.astFactory.createGetProp(this.astFactory.createCall(this.astFactory.createGetProp(tempVarModel.cloneNode(), "next"), new Node[0]), "value");
                }
                if (parent.isAssign()) {
                    Node assignment = this.astFactory.createAssign(newLHS, newRHS);
                    newNode = IR.exprResult(assignment);
                } else {
                    newNode = IR.declaration(newLHS, newRHS, parent.getToken());
                }
                newNode.useSourceInfoIfMissingFromForTree(arrayPattern);
                nodeToDetach.getParent().addChildBefore(newNode, nodeToDetach);
                this.visit(t, newLHS, newLHS.getParent());
            }
            child = next;
        }
        nodeToDetach.detach();
        t.reportCodeChange();
    }

    private void wrapAssignmentInCallToArrow(NodeTraversal t, Node assignment) {
        String tempVarName = this.getTempVariableName();
        Node tempVarModel = this.astFactory.createName(tempVarName, assignment.getJSType());
        Node rhs = assignment.getLastChild().detach();
        Node newAssignment = IR.let(tempVarModel.cloneNode(), rhs);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.LET_DECLARATIONS);
        Node replacementExpr = this.astFactory.createAssign(assignment.getFirstChild().detach(), tempVarModel.cloneNode());
        Node exprResult = IR.exprResult(replacementExpr);
        Node returnNode = IR.returnNode(tempVarModel.cloneNode());
        Node block = IR.block(newAssignment, exprResult, returnNode);
        Node arrowFn = this.astFactory.createZeroArgFunction("", block, assignment.getJSType());
        arrowFn.setIsArrowFunction(true);
        Node call = this.astFactory.createCall(arrowFn, new Node[0]);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.ARROW_FUNCTIONS);
        call.useSourceInfoIfMissingFromForTree(assignment);
        call.putBooleanProp(Node.FREE_CALL, true);
        assignment.getParent().replaceChild(assignment, call);
        NodeUtil.markNewScopesChanged(call, this.compiler);
        this.replacePattern(t, replacementExpr.getFirstChild(), replacementExpr.getLastChild(), replacementExpr, exprResult);
    }

    private void visitDestructuringPatternInEnhancedFor(Node pattern) {
        Preconditions.checkArgument(pattern.isDestructuringPattern());
        String tempVarName = this.getTempVariableName();
        if (NodeUtil.isEnhancedFor(pattern.getParent())) {
            Node forNode = pattern.getParent();
            Node block = forNode.getLastChild();
            Node decl = IR.var(this.astFactory.createName(tempVarName, pattern.getJSType()));
            decl.useSourceInfoIfMissingFromForTree(pattern);
            forNode.replaceChild(pattern, decl);
            Node exprResult = IR.exprResult(this.astFactory.createAssign(pattern, this.astFactory.createName(tempVarName, pattern.getJSType())));
            exprResult.useSourceInfoIfMissingFromForTree(pattern);
            block.addChildToFront(exprResult);
        } else {
            Node destructuringLhs = pattern.getParent();
            Preconditions.checkState(destructuringLhs.isDestructuringLhs());
            Node declarationNode = destructuringLhs.getParent();
            Node forNode = declarationNode.getParent();
            Preconditions.checkState(NodeUtil.isEnhancedFor(forNode));
            Node block = forNode.getLastChild();
            declarationNode.replaceChild(destructuringLhs, this.astFactory.createName(tempVarName, pattern.getJSType()).useSourceInfoFrom(pattern));
            Token declarationType = declarationNode.getToken();
            Node decl = IR.declaration(pattern.detach(), this.astFactory.createName(tempVarName, pattern.getJSType()), declarationType);
            decl.useSourceInfoIfMissingFromForTree(pattern);
            Node newBlock = IR.block(decl);
            block.replaceWith(newBlock);
            newBlock.addChildToBack(block);
        }
    }

    private void visitDestructuringPatternInCatch(NodeTraversal t, Node pattern) {
        String tempVarName = this.getTempVariableName();
        Node catchBlock = pattern.getNext();
        pattern.replaceWith(this.astFactory.createName(tempVarName, pattern.getJSType()));
        catchBlock.addChildToFront(IR.declaration(pattern, this.astFactory.createName(tempVarName, pattern.getJSType()), Token.LET));
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.LET_DECLARATIONS);
    }

    private Node defaultValueHook(Node getprop, Node defaultValue) {
        Node undefined = this.astFactory.createName("undefined", JSTypeNative.VOID_TYPE);
        undefined.makeNonIndexable();
        Node getpropClone = getprop.cloneTree().setJSType(getprop.getJSType());
        return this.astFactory.createHook(this.astFactory.createSheq(getprop, undefined), defaultValue, getpropClone);
    }

    private static final class PatternNestingLevel {
        final Node pattern;
        boolean hasNestedObjectRest;

        public PatternNestingLevel(Node pattern, boolean hasNestedRest) {
            this.pattern = pattern;
            this.hasNestedObjectRest = hasNestedRest;
        }
    }

    static class Builder {
        private final AbstractCompiler compiler;
        private ObjectDestructuringRewriteMode rewriteMode = ObjectDestructuringRewriteMode.REWRITE_ALL_OBJECT_PATTERNS;

        public Builder(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        public Builder setDestructuringRewriteMode(ObjectDestructuringRewriteMode rewriteMode) {
            this.rewriteMode = rewriteMode;
            return this;
        }

        public Es6RewriteDestructuring build() {
            return new Es6RewriteDestructuring(this);
        }
    }

    static enum ObjectDestructuringRewriteMode {
        REWRITE_ALL_OBJECT_PATTERNS,
        REWRITE_OBJECT_REST;

    }
}

