/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class DeadPropertyAssignmentElimination
implements CompilerPass {
    private final AbstractCompiler compiler;
    @VisibleForTesting
    static final boolean ASSUME_CONSTRUCTORS_HAVENT_ESCAPED = false;

    DeadPropertyAssignmentElimination(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.compiler.getExternProperties() == null || this.compiler.getAccessorSummary() == null) {
            return;
        }
        Sets.SetView<String> blacklistedPropNames = Sets.union(this.compiler.getAccessorSummary().getAccessors().keySet(), this.compiler.getExternProperties());
        NodeTraversal.traverseChangedFunctions(this.compiler, new FunctionVisitor(blacklistedPropNames));
    }

    private static class FindCandidateAssignmentTraversal
    implements NodeTraversal.Callback {
        Map<String, Property> propertyMap = new HashMap<String, Property>();
        private final Set<String> blacklistedPropNames;
        private final boolean isConstructor;

        FindCandidateAssignmentTraversal(Set<String> blacklistedPropNames, boolean isConstructor) {
            this.blacklistedPropNames = blacklistedPropNames;
            this.isConstructor = isConstructor;
        }

        private Property getOrCreateProperty(Node propNode) {
            Property parentProperty;
            if (!propNode.isQualifiedName()) {
                return null;
            }
            String propName = propNode.isGetProp() ? propNode.getLastChild().getString() : propNode.getQualifiedName();
            Property property = this.propertyMap.computeIfAbsent(propName, name -> new Property((String)name));
            if (propNode.isGetProp() && (parentProperty = this.getOrCreateProperty(propNode.getFirstChild())) != null) {
                parentProperty.children.add(property);
            }
            return property;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return this.visitNode(n, parent);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isAssignmentOp(n)) {
                this.visitAssignmentLhs(n.getFirstChild());
            }
            if (NodeUtil.isInvocation(n) || n.isYield() || n.isAwait()) {
                this.markAllPropsRead();
            }
            if (n.isBlock()) {
                this.visitBlock(n);
            }
        }

        private void visitBlock(Node blockNode) {
            Preconditions.checkArgument(blockNode.isBlock());
            if (blockNode.hasChildren()) {
                this.markAllPropsRead();
            }
        }

        private static boolean isConditionalExpression(Node n) {
            switch (n.getToken()) {
                case AND: 
                case OR: 
                case HOOK: {
                    return true;
                }
            }
            return false;
        }

        private void visitAssignmentLhs(Node lhs) {
            Property childProperty;
            Property property = this.getOrCreateProperty(lhs);
            if (property == null) {
                return;
            }
            if (!lhs.isGetProp()) {
                property.markLastWriteRead();
                property.markChildrenRead();
                return;
            }
            Node assignNode = lhs.getParent();
            if (!assignNode.isAssign()) {
                property.markLastWriteRead();
            }
            property.markChildrenRead();
            property.addWrite(lhs);
            for (Node child = lhs.getFirstChild(); child != null && (childProperty = this.getOrCreateProperty(child)) != null; child = child.getFirstChild()) {
                childProperty.markLastWriteRead();
            }
        }

        private boolean visitNode(Node n, Node parent) {
            switch (n.getToken()) {
                case GETPROP: {
                    if (n.isGetProp() && this.blacklistedPropNames.contains(n.getLastChild().getString())) {
                        this.markAllPropsRead();
                        return true;
                    }
                    if (NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n) {
                        return false;
                    }
                    Property property = this.getOrCreateProperty(n);
                    if (property != null) {
                        property.markLastWriteRead();
                        if (!parent.isGetProp()) {
                            property.markChildrenRead();
                        }
                    }
                    return true;
                }
                case THIS: 
                case NAME: {
                    Property nameProp = Preconditions.checkNotNull(this.getOrCreateProperty(n));
                    nameProp.markLastWriteRead();
                    if (!parent.isGetProp()) {
                        nameProp.markChildrenRead();
                    }
                    return true;
                }
                case THROW: 
                case FOR: 
                case FOR_IN: 
                case SWITCH: {
                    this.markAllPropsRead();
                    return false;
                }
                case BLOCK: {
                    this.visitBlock(n);
                    return true;
                }
            }
            if (FindCandidateAssignmentTraversal.isConditionalExpression(n)) {
                this.markAllPropsRead();
                return false;
            }
            return true;
        }

        private void markAllPropsRead() {
            this.markAllPropsReadHelper(false);
        }

        private void markAllPropsReadExceptThisProps() {
            this.markAllPropsReadHelper(true);
        }

        private void markAllPropsReadHelper(boolean excludeThisProps) {
            for (Property property : this.propertyMap.values()) {
                if (property.writes.isEmpty() || excludeThisProps && ((PropertyWrite)property.writes.getLast()).isChildPropOf("this")) continue;
                property.markLastWriteRead();
            }
        }
    }

    private static class PropertyWrite {
        private final Node assignedAt;
        private boolean isRead = false;
        private final String qualifiedName;

        PropertyWrite(Node assignedAt) {
            Preconditions.checkArgument(assignedAt.isQualifiedName());
            this.assignedAt = assignedAt;
            this.qualifiedName = assignedAt.getQualifiedName();
        }

        boolean isSafeToRemove(@Nullable PropertyWrite nextWrite) {
            return !this.isRead && nextWrite != null && Objects.equals(this.qualifiedName, nextWrite.qualifiedName);
        }

        void markRead() {
            this.isRead = true;
        }

        boolean isChildPropOf(String lesserPropertyQName) {
            return this.qualifiedName != null && this.qualifiedName.startsWith(lesserPropertyQName + ".");
        }
    }

    private static class Property {
        private final String name;
        private final Deque<PropertyWrite> writes = new ArrayDeque<PropertyWrite>();
        private final Set<Property> children = new HashSet<Property>();

        Property(String name) {
            this.name = name;
        }

        void markLastWriteRead() {
            if (!this.writes.isEmpty()) {
                this.writes.getLast().markRead();
            }
        }

        void markChildrenRead() {
            HashSet<Property> propertiesSet = new HashSet<Property>(this.children);
            ArrayDeque<Property> propertyQueue = new ArrayDeque<Property>(propertiesSet);
            propertiesSet.add(this);
            while (!propertyQueue.isEmpty()) {
                Property childProperty = (Property)propertyQueue.remove();
                childProperty.markLastWriteRead();
                for (Property grandchildProperty : childProperty.children) {
                    if (!propertiesSet.add(grandchildProperty)) continue;
                    propertyQueue.add(grandchildProperty);
                }
            }
        }

        void addWrite(Node lhs) {
            Preconditions.checkArgument(lhs.isQualifiedName());
            this.writes.addLast(new PropertyWrite(lhs));
        }

        public String toString() {
            return "Property " + this.name;
        }
    }

    private static class FunctionVisitor
    implements NodeTraversal.ChangeScopeRootCallback {
        private final Set<String> blacklistedPropNames;

        FunctionVisitor(Set<String> blacklistedPropNames) {
            this.blacklistedPropNames = blacklistedPropNames;
        }

        @Override
        public void enterChangeScopeRoot(AbstractCompiler compiler, Node root) {
            if (!root.isFunction()) {
                return;
            }
            Node body = NodeUtil.getFunctionBody(root);
            if (!body.hasChildren() || NodeUtil.containsFunction(body)) {
                return;
            }
            FindCandidateAssignmentTraversal traversal = new FindCandidateAssignmentTraversal(this.blacklistedPropNames, NodeUtil.isConstructor(root));
            NodeTraversal.traverse(compiler, body, traversal);
            for (Property property : traversal.propertyMap.values()) {
                if (property.writes.size() <= 1) continue;
                PeekingIterator iter = Iterators.peekingIterator(property.writes.iterator());
                while (iter.hasNext()) {
                    PropertyWrite propertyWrite = (PropertyWrite)iter.next();
                    if (!iter.hasNext() || !propertyWrite.isSafeToRemove((PropertyWrite)iter.peek())) continue;
                    Node lhs = propertyWrite.assignedAt;
                    Node rhs = lhs.getNext();
                    Node assignNode = lhs.getParent();
                    if (assignNode.isAssign()) {
                        rhs.detach();
                        assignNode.replaceWith(rhs);
                        compiler.reportChangeToEnclosingScope(rhs);
                        continue;
                    }
                    Preconditions.checkState(NodeUtil.isAssignmentOp(assignNode));
                    Token opType = NodeUtil.getOpFromAssignmentOp(assignNode);
                    assignNode.setToken(opType);
                    compiler.reportChangeToEnclosingScope(assignNode);
                }
            }
        }
    }
}

