/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.BranchCoverageInstrumentationCallback;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CoverageInstrumentationCallback;
import com.google.javascript.jscomp.FileInstrumentationData;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.Map;

@GwtIncompatible(value="FileInstrumentationData")
class CoverageInstrumentationPass
implements CompilerPass {
    final AbstractCompiler compiler;
    private final Map<String, FileInstrumentationData> instrumentationData;
    private final CoverageReach reach;
    private final InstrumentOption instrumentOption;
    public static final String JS_INSTRUMENTATION_OBJECT_NAME = "__jscov";

    public CoverageInstrumentationPass(AbstractCompiler compiler, CoverageReach reach, InstrumentOption instrumentOption) {
        this.compiler = compiler;
        this.reach = reach;
        this.instrumentOption = instrumentOption;
        this.instrumentationData = new LinkedHashMap<String, FileInstrumentationData>();
    }

    public CoverageInstrumentationPass(AbstractCompiler compiler, CoverageReach reach) {
        this(compiler, reach, InstrumentOption.LINE_ONLY);
    }

    private void addHeaderCode(Node script) {
        script.addChildToFront(this.createConditionalObjectDecl(JS_INSTRUMENTATION_OBJECT_NAME, script));
        script.addChildToFront(this.compiler.parseSyntheticCode("if (!self.window) { self.window = self; self.window.top = self; }").removeFirstChild().useSourceInfoIfMissingFromForTree(script));
    }

    @Override
    public void process(Node externsNode, Node rootNode) {
        if (rootNode.hasChildren()) {
            if (this.instrumentOption == InstrumentOption.BRANCH_ONLY) {
                NodeTraversal.traverse(this.compiler, rootNode, new BranchCoverageInstrumentationCallback(this.compiler, this.instrumentationData));
            } else {
                NodeTraversal.traverse(this.compiler, rootNode, new CoverageInstrumentationCallback(this.instrumentationData, this.reach));
            }
            Node firstScript = rootNode.getFirstChild();
            Preconditions.checkState(firstScript.isScript());
            if (firstScript.hasChildren() && firstScript.getFirstChild().isModuleBody()) {
                firstScript = firstScript.getFirstChild();
            }
            this.addHeaderCode(firstScript);
        }
    }

    private Node createConditionalObjectDecl(String name, Node srcref) {
        Node jscovData;
        switch (this.instrumentOption) {
            case BRANCH_ONLY: {
                jscovData = IR.objectlit(IR.quotedStringKey("fileNames", IR.arraylit(new Node[0])), IR.quotedStringKey("branchPresent", IR.arraylit(new Node[0])), IR.quotedStringKey("branchesInLine", IR.arraylit(new Node[0])), IR.quotedStringKey("branchesTaken", IR.arraylit(new Node[0])));
                break;
            }
            case LINE_ONLY: {
                jscovData = IR.objectlit(IR.quotedStringKey("fileNames", IR.arraylit(new Node[0])), IR.quotedStringKey("instrumentedLines", IR.arraylit(new Node[0])), IR.quotedStringKey("executedLines", IR.arraylit(new Node[0])));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected option: " + (Object)((Object)this.instrumentOption)));
            }
        }
        Node var = IR.var(IR.name(name), IR.or(IR.getelem(IR.getprop(IR.name("window"), "top", new String[0]), IR.string(JS_INSTRUMENTATION_OBJECT_NAME)), IR.assign(IR.getelem(IR.getprop(IR.name("window"), "top", new String[0]), IR.string(JS_INSTRUMENTATION_OBJECT_NAME)), jscovData)));
        return var.useSourceInfoIfMissingFromForTree(srcref);
    }

    public static enum CoverageReach {
        ALL,
        CONDITIONAL;

    }

    public static enum InstrumentOption {
        LINE_ONLY,
        BRANCH_ONLY;

    }
}

