# 第16章 《string类和标准模板库》 编程练习题之我解

## 16.1

**题：**回文指的是顺读和逆读都一样的字符串。例如，“tot”和“otto”都 是简短的回文。编写一个程序，让用户输入字符串，并将字符串引用传 递给一个bool函数。如果字符串是回文，该函数将返回true，否则返回 false。此时，不要担心诸如大小写、空格和标点符号这些复杂的问题。 即这个简单的版本将拒绝“Otto”和“Madam，I'm Adam”。请查看附录F中 的字符串方法列表，以简化这项任务。



## 16.2 

**题：** 与编程练习1中给出的问题相同，但要考虑诸如大小写、空格和 标点符号这样的复杂问题。即“Madam，I'm Adam”将作为回文来测试。 例如，测试函数可能会将字符串缩略为“madamimadam”，然后测试倒过 来是否一样。不要忘了有用的cctype库，您可能从中找到几个有用的 STL函数，尽管不一定非要使用它们。

## 16.3

**题：** 修改程序清单16.3，使之从文件中读取单词。一种方案是，使用vector<string>对象而不是string数组。这样便可以使用push_back( )将 数据文件中的单词复制到vector<string>对象中，并使用size( )来确定单词列表的长度。由于程序应该每次从文件中读取一个单词，因此应使用 运算符>>而不是getline( )。文件中包含的单词应该用空格、制表符或换 行符分隔。



## 16.4

**题：** 编写一个具有老式风格接口的函数，其原型如下:

```cpp
int reduce(long arr[], int n);
```

实参应是数组名和数组中的元素个数。该函数对数组进行排序，删 除重复的值，返回缩减后数组中的元素数目。请使用STL函数编写该函 数(如果决定使用通用的unique( )函数，请注意它将返回结果区间的结 尾)。使用一个小程序测试该函数。



## 16.5

**题：** 问题与编程练习4相同，但要编写一个模板函数:

```cpp
template <class T>
int reduce(T arr[], int n)
```

在一个使用long实例和string实例的小程序中测试该函数。



## 16.6

**题：** 使用STL queue模板类而不是第12章的Queue类，重新编写程序清单12.12所示的示例。



## 16.7 

**题：** 彩票卡是一个常见的游戏。卡片上是带编号的圆点，其中一些 圆点被随机选中。编写一个lotto( )函数，它接受两个参数。第一个参数 是彩票卡上圆点的个数，第二个参数是随机选择的圆点个数。该函数返 回一个vector<int>对象，其中包含(按排列后的顺序)随机选择的号 码。例如，可以这样使用该函数:

```cpp
vector<int> winners;
winners = Lotto(51, 6);
```

这样将把一个矢量赋给winner，该矢量包含1~51中随机选定的6个 数字。注意，仅仅使用rand( )无法完成这项任务，因它会生成重复的 值。提示:让函数创建一个包含所有可能值的矢量，使用 random_shuffle( )，然后通过打乱后的矢量的第一个值来获取值。编写 一个小程序来测试这个函数。



## 16.8 

**题：** Mat和Pat希望邀请他们的朋友来参加派对。他们要编写一个程 序完成下面的任务。

* 让Mat输入他朋友的姓名列表。姓名存储在一个容器中，然后按排 列后的顺序显示出来。 
* 让Pat输入她朋友的姓名列表。姓名存储在另一个容器中，然后按 排列后的顺序显示出来。 
* 创建第三个容器，将两个列表合并，删除重复的部分，并显示这个 容器的内容。

## 16.9

**题：** 相对于数组，在链表中添加和删除元素更容易，但排序速度更 慢。这就引出了一种可能性:相对于使用链表算法进行排序，将链表复 制到数组中，对数组进行排序，再将排序后的结果复制到链表中的速度 可能更快;但这也可能占用更多的内存。请使用如下方法检验上述假设。

* a.创建大型 `vector<int>` 对象 `vi0`，并使用 `rand()` 给它提供初始值。 
* b.创建 `vector<int>` 对象 `vi` 和 `list<int>` 对象 `li`，它们的长度都和初始值与 `vi0` 相同。
* c.计算使用STL算法 `sort()` 对 `vi` 进行排序所需的时间，再计算使用list的方法 `sort()` 对li进行排序所需的时间。 
* d.将li重置为排序的 `vi0` 的内容，并计算执行如下操作所需的时间: 将li的内容复制到 `vi` 中，对 `vi` 进行排序，并将结果复制到 `li` 中。

要计算这些操作所需的时间，可使用 `ctime` 库中的 `clock()`。正如程序清单5.14演示的，可使用下面的语句来获取开始时间:

```cpp
clock_t start = clock();
```

再在操作结束后使用下面的语句获取经过了多长时间:

```cpp
clock_t end = clock();
cout << (double)(end- start) / CLOCKS_PER_SEC;
```

这种测试并非绝对可靠，因为结果取决于很多因素，如可用内存量、是否支持多处理以及数组(列表)的长度(随着要排序的元素数增 加，数组相对于列表的效率将更明显)。另外，如果编译器提供了默认 生成方式和发布生成方式，请使用发布生成方式。鉴于当今计算机的速 度非常快，要获得有意义的结果，可能需要使用尽可能大的数组。例 如，可尝试包含100000、1000000和10000000个元素。

## 16.10

**题：** 请按如下方式修改程序清单16.9(vect3.cpp)。

a. 在结构 `Review` 中添加成员 `price`。

b. 不使用 `vector<Review>` 来存储输入，而使用 `vector<shared_ptr<Review> >`。别忘了，必须使用 `new` 返回的指针来初始化 `shared_ptr` 。

c. 在输入阶段结束后，使用一个循环让用户选择如下方式之一显示书籍:按原始顺序显示、按字母表顺序显示、按评级升序显示、按评 级降序显示、按价格升序显示、按价格降序显示、退出。

下面是一种可能的解决方案:获取输入后，再创建一个 `shared_ptr` 矢量，并用原始数组初始化它。定义一个对指向结构的指针进行比较的 `operator < ()` 函数，并使用它对第二个矢量进行排序，让其中的 `shared_ptr` 按其指向的对象中的书名排序。重复上述过程，创建按 `rating` 和 `price` 排序的 `shared_ptr` 矢量。请注意，通过使用 `rbegin()` 和 `rend()`，可避 免创建按相反的顺序排列的 `shared_ptr` 矢量。







