# Dice Roll
Playing board games but can't find your dice? No worries, here is a simple dice roll app on your phone!

This project is an excellent tutorial for Android newbies. I have demonstrated it at multiple Android 101 workshops and have always received positive feedback.

On the first screen you enter player's name and hit the 'Start' button.
On the second screen, you see a hello message for the player, two dice images and a button to 'Roll Dice'. Everytime you click the button, you see two new and random dice values. Doubles sixes is a lucky draw!

<img src="https://github.com/Shrreya/Dice-Roll/blob/master/screenshots/1.png" width="216" height="384" /> <img src="https://github.com/Shrreya/Dice-Roll/blob/master/screenshots/2.png" width="216" height="384" /> <img src="https://github.com/Shrreya/Dice-Roll/blob/master/screenshots/3.png" width="216" height="384" /> </br>
<img src="https://github.com/Shrreya/Dice-Roll/blob/master/screenshots/4.png" width="216" height="384" />
<img src="https://github.com/Shrreya/Dice-Roll/blob/master/screenshots/5.png" width="216" height="384" /> </br>

#### Concepts learned in the tutorial
* Activities and their lifecycle.
* Handling user interaction through EditTexts, TextViews and Buttons.
* Intents and switching between activities.
* Working with layouts such as Constraint Layout, Linear Layout and Relative Layout.
* Working with image views.
* Working with Toast messages.
* Generating random numbers with Math library.
* Customizing app themes.
* Creating custom drawables and using image assets.
* And ofcourse Java programming.

#### Possible improvements to learn advanced concepts
* Shift view upwards when user types on keyboard.
* Responsive UI for landscape view and tablets.
* Create animated rolling effect on dice images.
* Shake phone to roll dice.
* Save history of dice rolls and switch back to previous moves.

Tutorial Inspiration Credits : [Learn to create a Dice Roll Game on Android by Sylvain Saurel](https://medium.com/@ssaurel/learn-to-create-a-roll-dice-game-on-android-a612167361cf)
