**Added YourName.md** by [@kibablu](https://github.com/kibablu)

# What is Hacktoberfest?
Have questions? These are the most Frequently Asked Questions about Hacktoberfest.

**Jump to:**

[General](#General)
[Rules](#Rules)
[Events](#Events)
[Shipping](#Shipping)

# General
What is Hacktoberfest?

Hacktoberfest is a month-long celebration of open source software run by DigitalOcean and DEV.

Hacktoberfest is open to everyone in our global community.
To participate, four pull requests must be submitted to public GitHub repositories.
You can sign up anytime between October 1 and October 31.
How do I get started?

First, register at hacktoberfest.digitalocean.com. Then, submit at least four PRs to any public GitHub repository. You can look for open issues labeled Hacktoberfest for inspiration. Quality contributions are encouraged!

Are you maintaining a repo? Create issues or label existing ones with Hacktoberfest on your GitHub projects to help new contributors know what to work on. Tag any spam or irrelevant PRs with the invalid label to disqualify them.

How do I track my progress?

Log in with your GitHub account at hacktoberfest.digitalocean.com to check your progress and stats.

I completed four PRs. When will I receive my T-shirt?

T-shirts will be awarded on a first-come, first-serve basis to the first 50,000 participants who successfully complete the Hacktoberfest challenge. We’ll start sending out emails with more details on redeeming T-shirts throughout the month, so stay tuned.

How do I get stickers?

Stickers are included with your T-shirt after completing four PRs.

What happens if I complete fewer than four PRs by the end of the month?

Unfortunately, you will have to submit at least four PRs to get a T-shirt.

As a maintainer, how should I handle spam PRs?

We don’t like seeing spam PRs just as much as you, so please give them an invalid label and close them. PRs with an invalid label won’t be counted toward Hacktoberfest.

As a maintainer, how do I encourage contributions to my repos?

Create issues for anything you’d like contributors to help with, making sure to give them a Hacktoberfest label so they’re easier to discover.

You can also share issues or repositories on Twitter, using #Hacktoberfest where we’ll retweet as many as we can for contributors to see.

My draft pull requests don’t seem to be counting toward Hacktoberfest. What’s going on?

For Hacktoberfest, pull requests on GitHub will not be counted until they are marked as ready for review: those marked as draft will not be counted. Please make sure to relabel any draft PRs as ready for review so that project maintainers can merge them.

My pull request was labeled as invalid by a maintainer, why doesn’t it count?

If a repository maintainer decides a pull request you made was spammy or an unhelpful contribution to the project, they can add an invalid label to your PR. This lets us know they do not think your pull request is a quality contribution, so it will not count toward Hacktoberfest.

My PR was labeled as invalid, but it isn’t. What should I do?

If a maintainer labels your pull request as invalid, but you don’t believe this is correct, please begin a conversation with the maintainer within the PR and explain your position.

My pull request is marked as being on an excluded repository. What does this mean?

Unfortunately, your pull request was made on a repository that doesn’t align with the core values of Hacktoberfest. We’ve decided that pull requests made to this repository will not count toward completing the challenge.

Why is my pull request in a maturing state on my profile?

In an effort to reduce spam and help maintainers, we’ve introduced a one-week review period for all pull requests. Once you have submitted four eligible PRs (ready-to-review, not drafts), the seven-day review window begins. This period gives maintainers time to identify and label any spammy PRs as invalid. If your PRs are not marked invalid during that window, they will allow you to complete the Hacktoberfest challenge. If during this period any of your PRs are labeled as invalid, you will return to the pending state until you have four eligible PRs, at which point the review period will start again.

# Rules
Do contributions made outside of GitHub count?

No, PRs must be made on the GitHub platform.

Do issues/commits count?

No, only PRs count.

I signed up for Hacktoberfest mid-October. Will PRs that I created earlier in October count?

Yes, all pull requests created between Oct. 1 and Oct. 31 will count, regardless of when you register for Hacktoberfest. Pull requests created before Oct. 1 but merged after do not count.

Do issues have to be labeled Hacktoberfest to count?

No, any pull request made on a public repository counts, whether it’s attached to a Hacktoberfest issue or not.

Do PRs made on my own repos count?

Yes, but we strongly encourage you to make quality contributions to other repositories.

Can I make PRs to issues/repos that are not listed on the homepage?

Yes, any public GitHub repo is good for Hacktoberfest.

Do multiple PRs to the same repo count?

Yes, each pull request will count separately.

Do PRs have to be accepted/merged?

No, they will still count unless they are spam, irrelevant, or labeled as invalid.

# Events
How can I host a Hacktoberfest event?

See the Hacktoberfest Event Organizer Kit: hacktoberfest.digitalocean.com/eventkit

Can you help me promote my Hacktoberfest event?

Tell us about your event: hacktoberfest.digitalocean.com/eventkit#form and we’ll add it to hacktoberfest.digitalocean.com!

Will Hacktoberfest T-shirts be given out at events?

No, Hacktoberfest T-shirts will be mailed to participants who make four PRs on Github between October 1 and October 31.

I’d like some credits for my Hacktoberfest meetup/event attendees. Can you give me some?

Feel free to share the following link with your attendees along with this wording: “New to DigitalOcean? Receive USD $50 in infrastructure credit at https://do.co/hacktoberfest_2019.”

Note that the free credit only applies to users who are new to DigitalOcean, and requires a valid credit card.

I’d like to speak/demo at a Hacktoberfest event. Can you give me free infrastructure credit?

Great! Please tell us more about your demo at www.digitalocean.com/droplets-for-demos/ and we’ll get back to you soon.

# Shipping
Will I have to pay anything to receive my T-shirt/stickers?

T-shirts are free of charge for participants, including shipping costs.

I didn’t receive my Hacktoberfest 2018 T-shirt/swag.

We are no longer printing 2018 T-shirts. If you did not receive your T-shirt, this means we tried to deliver multiple times unsuccessfully. We are working hard on improving the shipping process this year so that everyone receives their T-shirts. Thank you for your understanding.

Will I have to pay anything/custom tax/duty for the T-shirt?

We write down a low enough dollar value on the mailed packages that we don’t expect any issues with customs tax, but we cannot guarantee that – you might have to pay a small fee depending on your country’s import policies.

When will my T-shirt be shipped? (International)

You will receive an email once your T-shirt is shipped. It can take up to 3-5 weeks after shipment for international orders to be delivered. We intend to ship all shirts by the end of the first week of November this year.

When will my T-shirt be shipped? (United States)

You will receive an email once your T-shirt is shipped. It can take up to 1-2 weeks after shipment for orders within the U.S. to be delivered. We intend to ship all shirts by the end of the first week of November this year.

How do I return or exchange an item?

If you believe your order was shipped incorrectly, contact us with the order number from the email subject line, plus an explanation of the incorrect item you received. Otherwise, if it’s still within 30 days of the original purchase, follow the instructions at kotisdesign.com/returns. You will be responsible for shipping the item back to us.

Tracking for my order is not active, is my tracking number correct?

You may receive a tracking email 2-3 days before tracking becomes active on DHL’s website. Try again in a few days.

My international order is delayed. What can I do?

We recommend contacting DHL in your country for help with clearing the package: www.dhl.com/en/contact_center/contact_parcel_ecommerce.html.

What countries do you ship to?

We are able to ship to all countries with the exception of the following: Cuba, Iran, Libya, North Korea, Sierra Leone, Somalia, Sudan, Syria, and Yemen.

What T-shirt size should I order?

You can reference the size charts for the T-shirts on the ordering page. Both size charts include measurements in inches, and instructions for how to measure yourself.

How do I change my T-shirt size?

Please email Hacktoberfest@DigitalOcean.com within two days of placing your order. Please include your order number and the T-shirt size you’d like and we’ll get that updated for you.

How do I change my email address?

If you are unable to access the email address you used to place your order, please provide us with a new email address and your order number so we can update your order information. You can email Hacktoberfest@DigitalOcean.com with your new information.

Did my T-shirt order go through?

If you did not receive an order confirmation email within an hour of placing your order, we can look up your order using the email address you used. Please check your spam or junk folders first and if it’s not there, send us an email to Hacktoberfest@DigitalOcean.com to confirm your T-shirt order.
