# FlipDrip AI E-Commerce App

Welcome to FlipDrip AI, your personalized fashion destination! Discover the latest trends tailored just for you.

## Table of Contents

- [Problem Statement](#problem-statement)
- [Introduction](#introduction)
- [Features](#features)
- [Getting Started](#getting-started)
- [Usage](#usage)
- [Demo](#demo)
- [Technology Stack](#technology-stack)
- [Team Members](#team-members)

## Problem Statement

### Gen AI-Powered Fashion Outfit Generator for Flipkart

With the advent of Generative AI, search and product discovery are being revolutionized, moving away from a single open text box experience to something more conversational. This revolution opens up new possibilities for product discovery and recommendations by understanding users' needs in a more human-like conversational way. Fashion is one of the categories where discovery is undergoing a reset.

As part of this challenge, teams need to create a Gen AI-powered fashion outfit generator for Flipkart that revolutionizes the way users discover and create personalized fashion outfits in a natural conversational way. The outfit generator should leverage users' past purchase history, preferences based on browsing data, and insights from social media trends to offer tailored and on-trend outfit recommendations.

The fashion outfit generator should have the following capabilities:

- **Analyze Past Purchase History**: It should be able to analyze a user's past purchase history to understand their preferred style, color choices, and favorite brands. The generator should use this information to suggest outfits that align with the user's unique fashion taste.

- **Consider Browsing Behavior**: The generator can take into account the types of clothing items the user frequently views or adds to their cart, ensuring that the outfit recommendations are relevant and appealing.

- **Social Media Trends**: In addition to individual user data, the generator should tap into social media trends to provide up-to-date fashion recommendations. It should analyze current fashion trends, styles, and influencers on platforms like Instagram, Pinterest, and fashion blogs.

- **Complete Outfit Recommendations**: The generated outfit recommendations should be complete and well-coordinated, including clothing, accessories, footwear, etc. The generator should consider factors such as the user's body type, occasion (e.g., casual, formal, party), and regional and age preferences.

- **User Interaction**: Users should be able to interact with the outfit generator to give feedback and tweak outfits through a conversation-like interface. For example, users should be able to express preferences and request changes.

The ultimate goal of the fashion outfit generator is to enhance the user's shopping experience on Flipkart by providing them with personalized, trendy, and cohesive outfit ideas. Users should feel inspired and confident in their fashion choices, knowing that the generator has considered their preferences, browsing habits, and the latest fashion trends.

## Introduction

FlipDrip AI is a cutting-edge e-commerce platform with a unique twist – our AI fashion outfit generator leverages your region, age preferences, and past purchase history to curate fashion recommendations tailored to your individual style. We've also incorporated newer fashion trends by integrating images with context into our Zilliz Vector DB.

## Features

- **Personalized Fashion Recommendations**: Our AI analyzes your region, age, and past purchases to recommend outfits you'll love.

- **Generative AI Outfit Generator**: Experience fashion like never before with AI-generated outfits that suit your style.

- **Seamless Shopping Experience**: Shop effortlessly for the latest trends, clothing, and accessories.

- **Zilliz Vector DB Integration**: Stay ahead of the fashion curve with context-rich images that enhance your shopping experience.

## Getting Started

1. **Clone the Repository**:

   ```bash
   git clone https://github.com/your-username/fashiongen.git
   cd fashiongen
2. **Install Dependencies**:

    ```bash
    npm install

3. **Run the Application**:

    ```bash
    npm start

 4. **Access the App**:

    Open your web browser and go to http://localhost:3000 to start shopping!

## Usage
- Signup/Login: Create an account or log in to access your personalized fashion recommendations.
- AI Outfit Generator: Explore outfits generated just for you based on your preferences.
- Shopping: Browse and purchase the latest fashion items effortlessly.
- Zilliz Vector DB: Dive into a world of fashion trends enriched with context-rich images.

## Demo

https://github.com/ShashankGupta10/FlipDrip-AI/assets/117008526/dc407383-cc6e-4600-90dd-22d213215ba0


## Technology Stack
- Frontend: React.js, Redux
- Backend: Node.js, Express.js
- AI: ChatGPt-3.5-turbo, Stable Diffusion, Photoreal, HuggingFace
- Database: Zilliz Vector DB
- Authentication: JWT
- Payment: Razorpay
## Team Members
- Shashank Gupta (Team Lead)
- Pranav Patil
- Shaunak Rananaware
