﻿// Copyright (c) 2010-2014 SharpDX - Alexandre Mutel
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

using System.Globalization;
using System.Xml.Serialization;

namespace SharpGen.Config;

/// <summary>
/// Simple naming rule to rename short name, abbreviation to an expanded name. 
/// For example, rename SRV to ShaderResourceView.
/// </summary>
[XmlType("short")]
public class NamingRuleShort : NamingRule
{
    /// <summary>
    /// Initializes a new instance of the <see cref="NamingRuleShort"/> class.
    /// </summary>
    [ExcludeFromCodeCoverage(Reason = "For XML Serialization")]
    public NamingRuleShort()
    {
    }

    /// <summary>
    /// Initializes a new instance of the <see cref="NamingRuleShort"/> class.
    /// </summary>
    /// <param name="name">The name.</param>
    /// <param name="value">The value.</param>
    public NamingRuleShort(string name, string value) : base(name, value)
    {
    }

    /// <summary>
    /// Returns a <see cref="System.String"/> that represents this instance.
    /// </summary>
    /// <returns>
    /// A <see cref="System.String"/> that represents this instance.
    /// </returns>
    [ExcludeFromCodeCoverage]
    public override string ToString()
    {
        return string.Format(CultureInfo.InvariantCulture, "naming-rule-short: \"{0}\" => \"{1}\"", Name, Value);
    }
}