// Copyright (c) 2010-2014 SharpDX - Alexandre Mutel
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

namespace SharpGen.Platform;

public static class CastXml
{
    /// <summary>
    ///     GccXml tag for FundamentalType
    /// </summary>
    public const string TagFundamentalType = "FundamentalType";

    /// <summary>
    ///     GccXml tag for Enumeration
    /// </summary>
    public const string TagEnumeration = "Enumeration";

    /// <summary>
    ///     GccXml tag for Struct
    /// </summary>
    public const string TagStruct = "Struct";

    /// <summary>
    ///     CastXML tag for Class
    /// </summary>
    public const string TagClass = "Class";

    /// <summary>
    ///     GccXml tag for Field
    /// </summary>
    public const string TagField = "Field";

    /// <summary>
    ///     GccXml tag for Union
    /// </summary>
    public const string TagUnion = "Union";

    /// <summary>
    ///     GccXml tag for Typedef
    /// </summary>
    public const string TagTypedef = "Typedef";

    /// <summary>
    ///     GccXml tag for Function
    /// </summary>
    public const string TagFunction = "Function";

    /// <summary>
    ///     GccXml tag for PointerType
    /// </summary>
    public const string TagPointerType = "PointerType";

    /// <summary>
    ///     GccXml tag for ArrayType
    /// </summary>
    public const string TagArrayType = "ArrayType";

    /// <summary>
    ///     GccXml tag for ReferenceType
    /// </summary>
    public const string TagReferenceType = "ReferenceType";

    /// <summary>
    ///     GccXml tag for CvQualifiedType
    /// </summary>
    public const string TagCvQualifiedType = "CvQualifiedType";

    /// <summary>
    ///     GccXml tag for Namespace
    /// </summary>
    public const string TagNamespace = "Namespace";

    /// <summary>
    ///     GccXml tag for Variable
    /// </summary>
    public const string TagVariable = "Variable";

    /// <summary>
    ///     GccXml tag for FunctionType
    /// </summary>
    public const string TagFunctionType = "FunctionType";
}