# Apps

## Intro

All my favorite apps listed here used in SDLC.

## Browsers

- [Firefox](firefox.md) Nightly / Main 
- Safari 

## Writer

- [Obsidian](https://obsidian.md/)
- iA Writer
- [logseq](https://logseq.com/downloads)
- [netbox](https://docs.netbox.dev/en/stable/)
- [bookstackapp](https://www.bookstackapp.com/)
- [moinmo](https://moinmo.in/) 
- 1Writer (iOS + Dropbox Sync)


## Must Have

- [alfred](alfred.md) 
- [Rectangle](https://rectangleapp.com/) 
- istats pro
- [Monitor Control](https://github.com/MonitorControl/MonitorControl)

### Other notes

[reddit thread documentation](https://www.reddit.com/r/selfhosted/comments/160pxx1/what_do_you_use_for_documentation_or_notes/)

If you need [PDF to paperless conversion](https://github.com/paperless-ngx/paperless-ngx) to scan, index and archive all your physical documents

## Version Management

- Git
- Github Desktop
- GitKraken

## Compilation

- Github Pages
- GitBook
- Obsidian Graphs

## Task Manager

- Things by Cultured Code
- be focused pro - pomodoro app

## Scheduler

- Fantastical  (microsoft outlook personal requires app password not traditional password)
- Focused Pro
- [rescue Time](https://www.rescuetime.com/download) 

## Documentation Reference

- Dash

## Terminal

- [iTerm](iterm2.md)

## Debugging 

- [Proxyman](https://proxyman.io/) - network sniffer 
- [Postman](https://www.postman.com/downloads/) for API prototyping 
- Little Snitch


## Network

- [http request online](https://base64.guru/tools/http-request-online)
- [curl CLI request builder](https://curlbuilder.com/)

## Utility

- JSON typicode structure model https://app.quicktype.io/
- json validation


## Convertors

- [Date time timezone convertors](https://time.lol/#2001-09-11T12:14:00-00:00) 
- [unix timestamp to date convertor](https://www.timestamp-converter.com/)
- [text convert case](https://convertcase.net/)
- [type converts - UInt to Int 16 - 64bit](https://www.simonv.fr/TypesConvert/?integers)



## Calculators

- [video bitrate calculator](https://www.dr-lex.be/info-stuff/videocalc.html)


## Design

- [Miro board](https://miro.com/)
- [Draw io](https://www.drawio.com/)
- Apple Freeform

### Color Theory

- [UIColor.io](https://www.uicolor.io/)
- [Color Wheel Canva](https://www.canva.com/colors/color-wheel/) Use `Monochromatic` when working with Black - White Mono color. And use `Complementary` mode when working with RGB colors
- [Contrast checker](https://webaim.org/resources/contrastchecker/) Thanks to Design team Member
- [Figma plugin](https://www.figma.com/community/plugin/748533339900865323) 

## Image

###  Tools

- UI Color converters HEX 
- Quick photoshop
- image app icons extraction
- png / svg icons [icons8.com](http://icons8.com)
- SVG Gapplin [mac os app](https://apps.apple.com/us/app/gapplin/id768053424?mt=12?ls=1)

## IDE

- [Xcode](README_xcode.md)
- [VS Code](README_vscode.md) - Open Source fork 
- [xcodes app](https://github.com/XcodesOrg/XcodesApp/releases/) - multiple xcode app setup

## Collaboration

- [linkde shared scratchpad pastebin](https://linkode.org) 
- [pastebin](https://pastebin.com/) 

## [Project Management](project_management.md)

## [Fresh Install](../os/mac/fresh_install.md)

## Video

### Tools

- [kdenlive](https://kdenlive.org/en/features/) 
- [ffmpeg](https://ffmpeg.org/)
- [m4vgear](https://www.m4vgear.com/m4vgear-for-windows.html)
- [IINA video player](https://iina.io/) 
- cli download utility [aria2](https://aria2.github.io/)
- fav project [youtube_dl](youtube_dl.md)
- [ffmpeg](ffmpeg.md) video conversion cli
- handbrake - video encoder decoder GUI
- [Media Info - OOS tool](https://mediaarea.net/en/MediaInfo) to get media info in GUI.

### Project

- decryption AES streams [github project pycryptodome](https://github.com/Legrandin/pycryptodome) 
- geo verification proxy - VPN and browser session - decryption and encryption
- youtube [community sourced sponsor sharing](https://sponsor.ajay.app/) like Waze reporting tool.

### Geeking 

Codec - HEVC x265 - fav
Dolby Vision vs HDR10
4:4:4 DCI - Color accuracy
HLS - components sending data, easily quality switchable, streams m3u8 format
DASH MPD
HDMI 2.0 vs 2.1 
40Gbps vs 48Gbps
4K @120hz or 8K @60Hz
Apple Macbook pro 2023 M2Pro | Max finally has HDMI 2.1
Fav TV tech - LG OLEDs C3, G3 - 
Fav Video reviewer - [HDTVTest](https://www.youtube.com/@hdtvtest)
Fav games technical analysis - Digital Foundry
Rting website for nitty gritty comparison of Video tech.
[video tools - apps](apps.md#Video%20Tools)

## Security

- [SSL test website](https://www.ssllabs.com/ssltest)
- [Authy](https://authy.com/download/) 
- 1password

## Server

- [Plex](plex.md)
- [Jellyfin](jellyfin.md)
- Prism
- Infuse
- Plex Amp
- LunaSea
- nzb360

## dev utility 

- [amphetamine](https://apps.apple.com/us/app/amphetamine/id937984704?mt=12)
- [keepingYouAwake](https://github.com/newmarcel/KeepingYouAwake?tab=readme-ov-file)
- ntfs support for mac - [Mounty](https://www.mounty.app/)



## Vision Pro

[apps for vision pro](https://appsforapplevision.com/)

[vision directory](https://vision.directory/)