# Work Apps


## iOS

### Profiles

Setup `Work` profile on your iOS device in order to not get bombarded with non work related notifications.
I usually setup to allow work apps notifications from 9 - 5pm on my personal phone which has `Slack`, `Teams` & `Work Calendar` synced for event notifications.

## Slack
### Organize
Segregate your channels and connections into appropriate `Sections`. 
I have a list which is as follows 
- internal team
- cross team
- architecture
- design
- announcements
- QA 
- UI
- CI/CD

Each section has its own notification settings and arrange in the order of importance. 

### Notifications

Go in settings and enable custom notification schedule in order to only get notified on certain times.

Setup custom status for `lunch`, `coffee` and `brb` so its easier to quickly update your team members if they are mentioning you with `@username` to get your attention.

### Bots

Setup an Outlook or Google calendar bot which sync your calendar and now you don't have to rely on other apps. You can just have 1 notification enabled for it. 
Daily summary in the morning with meetings info is also nice feature to accept meetings right off slack and check the schedule for the whole day.
It notifies you just 1 minute before the event starts.


### Threads

Great to have them in order to not bombard other people with unnecessary information.

### Accessibility

Turn on dark mode and stop automatic loop of GIFs or Video. Saves CPU cycles and avoids distractions.



## Github

Have all your Issues, PRs and Project Kanban board all in one place.
Less VPN issues, less tabs, can also comment via Github Mobile app or using mobile browser.

[Customizing your inbox with filters](https://docs.github.com/en/account-and-profile/managing-subscriptions-and-notifications-on-github/viewing-and-triaging-notifications/managing-notifications-from-your-inbox#supported-queries-for-custom-filters)


## Outlook

Setup custom profiles to get filtered emails according to its subject.
I keep this open for checking on calendar events since work use Outlook + Team integration a lot.
