# Problem *Solving*

## Intro

Problem solving is one of those crucial things you learn as an engineer where the approach you take to deconstruct a problem being presented and make some sense on the context of the given task.
It is easier said than done. It kinda comes with experiences or critical thinking. Sometimes its more intuitive for certain people and depending on their state of mind at the time of approaching the problem is also significant. 
They say best solutions are found when you're `sitting` on a toilet seat or in a shower pondering on things with a fresh perspective. no puns intended!

## Phenomena

### Wishful Thinking

Great article to read about Wishful thinking.
[Programming by Wishful Thinking](https://flatrick.github.io/notes/Programming-by-Wishful-Thinking/)

### Rubber ducky Method

This is when you're explaining the problem statement to a rubber duck when you're bathing, while explaining the intricate logic you're challenging your own senses of what is going on and how it is happening. This is tried and true method where instead of talking to a rubber duck, you talk to your peer or junior/senior and whilst explaining the problem you reach to your solution in a train track connecting / bridging way to the destination.

[wiki](https://en.wikipedia.org/wiki/Rubber_duck_debugging)

### Soft Reset - State of Mind

So many engineers solve problems after a great sleep or a nap, I reckon that's kinda of like a soft reset / restart for the human mind with empty state or no dirty state. Managing state is one of the intricate things in software development when you're dealing with various inputs and outputs. The probability of things going wrong are always higher but when you come back to a problem after a soft mental reset, you're approaching that problem from a different perspective.

### Divide and Conquer

Big problem, divide it in smaller problems. Helps positive reinforcement and makes you feel you're progressing towards your goal. Remember state management is tough for humans since context changes a lot and it becomes more convoluted. 
Isolating those smaller problems in its own sandbox for unit testing or just defining the structure helps a lot towards approaching the problem and decomposing them in smaller problems - solutions. This might be correlated to Wishful thinking as well.

## Maintainability

reddit wisdom around optimizing solutions

> Don't worry about performance until someone asks you about performance. Metal is cheaper than dev hours and nothing trumps maintainability.

## Performance traits

When approaching a problem, quite often people always resort to optimizing performance first. I always say refactoring comes second, first solving the problem is important. Yeah knowing which data structure to use at first glance is important and having their pros and cons in your mind is crucial. But quite often people forget the target they need to reach as they get consumed on performance metrics. I would say this is a crucial difference between a Software Engineer and a Senior Software Engineer. KISS ( Keep it Simple Stupid ) or don't Over Engineer things when not needed. Less is more (Minimalism). Less State management. 
Good read on [code_readability](code_readability.md) on internal doc I wrote.


## Dogfooding

Good article about [developer's guide to dogfooding](https://codesubmit.io/blog/is-dogfooding-right-for-your-team/)


## Time boxing

You can utilize time to be boxed in for working on something, so that you can come back to it and have a different mindset and always feel like you're trying to progress further.
Working on debugging and solving a problem, even going from error_1 to error_3 is progress, since you just demonstrated that you advanced or you changed your strategy to give you more context around your debugging shenaningans.


You can use Pomodoro method as well to keep you accounted.
[Link to app](tools/apps#Task%20Manager)




## Debug


[crash bandicoot | hardware level bug](https://www.gamedeveloper.com/programming/my-hardest-bug-ever#close-modal)
