# Github SDLC

---
## Issues

Tags are your friend. Assign the person working so at a glance you can see the Github Profile pic on `Projects`. 

The single source of truth. From start to end you can see the whole timeline of the work associated with the `Epic` `Feature` or `Bug`. 

All business logic conversations should happen over here.

Targeted Stakeholders: Managers, Business, "Agile"

---


## Milestones

Helpful to cut releases based on work milestones. Could be treated as a release vehicle or an Epic of Issues. Team dependent on how they want to proceed with it.


---


## PR

Connects with Github Actions seamlessly and enforces more rules before merging the PR with protected branches.

All code logic conversation should happen over here.

Targeted Stakeholders: Developers



---


## Workflows



---


## Projects

Various View modes supported - advanced filtering with tags and milestones.

First class support with Github Issues, Actions, Pull Request and  Releases.




---

## Releases

Use Github tags and releases in tandem to make the project packaging a breeze to quickly point out new change sets and compare old tags on web faster.
Could also leverage `Pre - release` tags in order to prepare for a new release and only submit it when ready.


---
## SDLC

1. Issues -> Create Issue Branch -> Create PR -> Github Project Magic
2. Peer Review -> Github Actions Pre / Post Merge -> Github Projects Magic
3. QA Review -> Release Ceremony -> Github Projects Magic

---


## Github Project Automation

Kanban automatically updated with appropriate rules and Workflows.

1. Auto updates Github Projects when `Event` triggers
2. It can pick up and filter appropriately with tags or milestones for current sprints.
3. Releases / Milestones referencing and closing the Issue / Ticket.



## Mind Map

[Peer Review - restrictions](peer_review.md#Restrictions)

[github_Enterprise](github_Enterprise.md)

[github_actions](github_actions.md)

