# Network

## Intro



## Enable Disable Network


Enabling Wifi adapter via Command Line on Debian based distros

```sh
sudo ifconfig wlan0 up
```



To disable 

```sh
sudo ifconfig wlan0 down
```


## IP Address Info

To check up on network information

```sh
ip addr
```


[Source](https://raspberrytips.com/disable-wifi-raspberry-pi/)

## Config

All your network settings are located in `etc/dhcpcd.conf`
Make sure if you want to edit the Ethernet interface or WLAN interface for Wireless.

```config
interface eth0
static ip_address=10.1.1.30/24
static routers=10.1.1.1
static domain_name_servers=10.1.1.1
```

https://raspberrypi.stackexchange.com/questions/37920/how-do-i-set-up-networking-wifi-static-ip-address-on-raspbian-raspberry-pi-os/74428#74428

https://raspberrypi.stackexchange.com/questions/110950/no-internet-via-ethernet-local-network-working

https://www.reddit.com/r/raspberry_pi/comments/117eizu/raspberry_pi_4_connects_to_wlan0_but_refuses_to/

FileZilla for connecting the FTP / SFTP server

https://stackoverflow.com/questions/12687900/connection-attempt-failed-with-econnrefused-connection-refused-by-server

## Kill Switch


## Troubleshooting

### Internet Down


So my raspberry pi internet was down partly because I have manually configured my nameserver in conf file.
Location : /etc/resolv.conf


```config
# Generated by resolvconf
nameserver 192.168.0.1
nameserver 8.8.8.8
nameserver 192.168.0.88
nameserver 208.67.222.222
```


Below is the post copied from [Reddit comment](https://www.reddit.com/r/raspberry_pi/comments/117eizu/raspberry_pi_4_connects_to_wlan0_but_refuses_to/) 
Since you never know which subreddit or internet goes offline, deleted post etc.


A standard trick to differentiate between a low-level network problem and a DNS issue is to ping 8.8.8.8 which is google’s DNS server.

- If you can ping 8.8.8.8 successfully, then your network is good but your DNS is hosed. Look at /etc/resolv.conf and check the name server setting.
    
- If you can’t ping google DNS, then try pinging your router. This is often 192.168.0.1 but check another computer connected to the same router for the correct address.
    
    - also run ‘ip a’ or ‘ifconfig’ to check the IP address assigned to wlan0
        
- if you can’t ping your router, you probably have a Wi-Fi issue, or perhaps a DHCP server issue with your router (power cycling your router can sometimes solve).
    

Post back what you find out