# Naming Conventions

We would follow unique naming convention for all of the high level objects as that is more code readable and designer friendly. It would also help us in merging our branches and connecting the game objects with our code in the Object inspector.

## GameObjects / Prefabs

```text
"UsageFirst+ObjectType"
CamelCase convention
```

Eg.

> SafetySafePlanButton

## Other Conventions

Deprecate older numbering conventions for redundant prefabs or gameobjects with unique naming scheme.

```text
Eg. 
Card1 => CardTime | TimeCard
Card2 => CardDate | DateCard
Card3 => CardFeedback | FeedbackCard
```

## Big Buttons

We could also name buttons like

> "Next button" "Cancel" or "Start"

etc rather than having

> "medium-button" , "medium-button-1".

It would be more concise.

